/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.internal.file.AbstractOpaqueFileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.ProviderBackedFileCollection;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ProviderResolutionStrategy;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.internal.DeferredUtil;

public class UnpackingVisitor {
    private final Consumer<FileCollectionInternal> visitor;
    private final PathToFileResolver resolver;
    private final Factory<PatternSet> patternSetFactory;
    private final boolean includeBuildable;
    private final ProviderResolutionStrategy providerResolutionStrategy;
    private final TaskDependencyFactory taskDependencyFactory;

    public UnpackingVisitor(Consumer<FileCollectionInternal> visitor, PathToFileResolver resolver, TaskDependencyFactory taskDependencyFactory, Factory<PatternSet> patternSetFactory) {
        this(visitor, resolver, taskDependencyFactory, patternSetFactory, ProviderResolutionStrategy.REQUIRE_PRESENT, true);
    }

    public UnpackingVisitor(Consumer<FileCollectionInternal> visitor, PathToFileResolver resolver, TaskDependencyFactory taskDependencyFactory, Factory<PatternSet> patternSetFactory, ProviderResolutionStrategy providerResolutionStrategy, boolean includeBuildable) {
        this.visitor = visitor;
        this.resolver = resolver;
        this.taskDependencyFactory = taskDependencyFactory;
        this.patternSetFactory = patternSetFactory;
        this.providerResolutionStrategy = providerResolutionStrategy;
        this.includeBuildable = includeBuildable;
    }

    public void add(@Nullable Object element) {
        if (element instanceof FileCollectionInternal) {
            this.visitor.accept((FileCollectionInternal)element);
            return;
        }
        if (element instanceof DirectoryTree) {
            this.visitor.accept(new FileTreeAdapter((MinimalFileTree)element, this.taskDependencyFactory, this.patternSetFactory));
            return;
        }
        if (element instanceof ProviderInternal) {
            ProviderInternal provider = (ProviderInternal)element;
            this.visitor.accept(new ProviderBackedFileCollection(provider, this.resolver, this.taskDependencyFactory, this.patternSetFactory, this.providerResolutionStrategy));
            return;
        }
        if (this.includeBuildable && (element instanceof Buildable || element instanceof TaskDependencyContainer)) {
            this.visitor.accept(new BuildableElementFileCollection(element, this.resolver, this.patternSetFactory));
            return;
        }
        if (element instanceof Task) {
            this.visitor.accept((FileCollectionInternal)((Task)element).getOutputs().getFiles());
        } else if (element instanceof TaskOutputs) {
            this.visitor.accept((FileCollectionInternal)((TaskOutputs)element).getFiles());
        } else if (DeferredUtil.isNestableDeferred((Object)element)) {
            Object deferredResult = DeferredUtil.unpackNestableDeferred((Object)element);
            if (deferredResult != null) {
                this.add(deferredResult);
            }
        } else if (element instanceof Path) {
            this.visitSingleFile(element);
        } else if (element instanceof Iterable) {
            Iterable iterable = (Iterable)element;
            for (Object item : iterable) {
                this.add(item);
            }
        } else if (element instanceof Object[]) {
            Object[] array;
            for (Object value : array = (Object[])element) {
                this.add(value);
            }
        } else if (element != null) {
            this.visitSingleFile(element);
        }
    }

    private void visitSingleFile(Object element) {
        this.visitor.accept(new SingleFileResolvingFileCollection(element, this.resolver, this.taskDependencyFactory, this.patternSetFactory));
    }

    private static class BuildableElementFileCollection
    extends CompositeFileCollection {
        private final Object element;
        private final PathToFileResolver resolver;
        private final Factory<PatternSet> patternSetFactory;

        public BuildableElementFileCollection(Object element, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory) {
            this.element = element;
            this.resolver = resolver;
            this.patternSetFactory = patternSetFactory;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.element);
        }

        @Override
        public String getDisplayName() {
            return "file collection";
        }

        @Override
        protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
            new UnpackingVisitor(visitor, this.resolver, this.taskDependencyFactory, this.patternSetFactory, ProviderResolutionStrategy.REQUIRE_PRESENT, false).add(this.element);
        }
    }

    private static class SingleFileResolvingFileCollection
    extends AbstractOpaqueFileCollection {
        private Object element;
        private final PathToFileResolver resolver;
        private File resolved;

        public SingleFileResolvingFileCollection(Object element, PathToFileResolver resolver, TaskDependencyFactory taskDependencyFactory, Factory<PatternSet> patternSetFactory) {
            super(taskDependencyFactory, patternSetFactory);
            this.element = element;
            this.resolver = resolver;
        }

        @Override
        public String getDisplayName() {
            return "file collection";
        }

        @Override
        protected Set<File> getIntrinsicFiles() {
            if (this.resolved == null) {
                this.resolved = this.resolver.resolve(this.element);
                this.element = null;
            }
            return ImmutableSet.of((Object)this.resolved);
        }
    }
}

