/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.api.impl.SimpleCodeWriter;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.MethodGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckRegions
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(CheckRegions.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode() || mth.getRegion() == null || mth.getBasicBlocks().isEmpty() || mth.contains(AType.JADX_ERROR)) {
            return;
        }
        final HashSet blocksInRegions = new HashSet();
        DepthRegionTraversal.traverse(mth, new AbstractRegionVisitor(){

            @Override
            public void processBlock(MethodNode mth, IBlock container) {
                if (!(container instanceof BlockNode)) {
                    return;
                }
                BlockNode block = (BlockNode)container;
                if (blocksInRegions.add(block)) {
                    return;
                }
                if (!(!LOG.isDebugEnabled() || block.contains(AFlag.RETURN) || block.contains(AFlag.REMOVE) || block.contains(AFlag.SYNTHETIC) || block.getInstructions().isEmpty())) {
                    LOG.debug("Duplicated block: {} - {}", (Object)mth, (Object)block);
                }
            }
        });
        if (mth.getBasicBlocks().size() != blocksInRegions.size()) {
            for (BlockNode block : mth.getBasicBlocks()) {
                if (blocksInRegions.contains(block) || block.getInstructions().isEmpty() || block.contains(AFlag.ADDED_TO_REGION) || block.contains(AFlag.DONT_GENERATE) || block.contains(AFlag.REMOVE)) continue;
                String blockCode = CheckRegions.getBlockInsnStr(mth, block).replace("*/", "*\\/");
                mth.addWarn("Code restructure failed: missing block: " + block + ", code lost:" + blockCode);
            }
        }
        DepthRegionTraversal.traverse(mth, new AbstractRegionVisitor(){

            @Override
            public boolean enterRegion(MethodNode mth, IRegion region) {
                BlockNode loopHeader;
                if (region instanceof LoopRegion && (loopHeader = ((LoopRegion)region).getHeader()) != null && loopHeader.getInstructions().size() != 1) {
                    mth.addWarn("Incorrect condition in loop: " + loopHeader);
                }
                return true;
            }
        });
    }

    private static String getBlockInsnStr(MethodNode mth, IBlock block) {
        SimpleCodeWriter code = new SimpleCodeWriter();
        code.incIndent();
        code.newLine();
        MethodGen mg = MethodGen.getFallbackMethodGen(mth);
        InsnGen ig = new InsnGen(mg, true);
        for (InsnNode insn : block.getInstructions()) {
            try {
                ig.makeInsn(insn, code);
            }
            catch (CodegenException codegenException) {}
        }
        code.newLine();
        return code.getCodeStr();
    }
}

