/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.JarFileTreeNodeFactoryProvider;
import org.jd.gui.service.treenode.ZipFileTreeNodeFactoryProvider;
import org.jd.gui.view.data.TreeNodeBean;

public class WarFileTreeNodeFactoryProvider
extends ZipFileTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(JarFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/war_obj.gif"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.war");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        ZipFileTreeNodeFactoryProvider.TreeNode node = new ZipFileTreeNodeFactoryProvider.TreeNode(entry, new TreeNodeBean(label, "Location: " + location, (Icon)ICON));
        node.add(new DefaultMutableTreeNode());
        return (T)node;
    }
}

