/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;

public final class IpV6ExtUnknownPacket
extends AbstractPacket {
    private static final long serialVersionUID = -7055290165058067091L;
    private final IpV6ExtUnknownHeader header;
    private final Packet payload;

    public static IpV6ExtUnknownPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6ExtUnknownPacket(rawData, offset, length);
    }

    private IpV6ExtUnknownPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IpV6ExtUnknownHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        if (payloadLength > 0) {
            Packet nextPacket;
            PacketFactory<Packet, IpNumber> factory2 = PacketFactories.getFactory(Packet.class, IpNumber.class);
            Class<Packet> nextPacketClass = factory2.getTargetClass(this.header.getNextHeader());
            if (nextPacketClass.equals(factory2.getTargetClass())) {
                nextPacket = PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, offset + this.header.length(), payloadLength, NotApplicable.UNKNOWN_IP_V6_EXTENSION);
                if (nextPacket instanceof IllegalPacket) {
                    nextPacket = factory2.newInstance(rawData, offset + this.header.length(), payloadLength);
                }
            } else {
                nextPacket = PacketFactories.getFactory(Packet.class, IpNumber.class).newInstance(rawData, offset + this.header.length(), payloadLength, this.header.getNextHeader());
            }
            this.payload = nextPacket;
        } else {
            this.payload = null;
        }
    }

    private IpV6ExtUnknownPacket(Builder builder2) {
        if (builder2 == null || builder2.nextHeader == null || builder2.data == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.nextHeader: ").append(builder2.nextHeader).append(" builder.data: ").append(builder2.data);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder2.payloadBuilder != null ? builder2.payloadBuilder.build() : null;
        this.header = new IpV6ExtUnknownHeader(builder2);
    }

    @Override
    public IpV6ExtUnknownHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IpV6ExtUnknownHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -4314577591889991355L;
        private static final int NEXT_HEADER_OFFSET = 0;
        private static final int NEXT_HEADER_SIZE = 1;
        private static final int HDR_EXT_LEN_OFFSET = 1;
        private static final int HDR_EXT_LEN_SIZE = 1;
        private static final int DATA_OFFSET = 2;
        private final IpNumber nextHeader;
        private final byte hdrExtLen;
        private final byte[] data;

        private IpV6ExtUnknownHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data length of this header is must be more than 3. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.nextHeader = IpNumber.getInstance(ByteArrays.getByte(rawData, 0 + offset));
            this.hdrExtLen = ByteArrays.getByte(rawData, 1 + offset);
            int headerLength = (this.getHdrExtLenAsInt() + 1) * 8;
            if (length < headerLength) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build this header(").append(headerLength).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.data = ByteArrays.getSubArray(rawData, 2 + offset, headerLength - 2);
        }

        private IpV6ExtUnknownHeader(Builder builder2) {
            if (builder2.data.length < 6) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("data length must be more than 5. data: ").append(ByteArrays.toHexString(builder2.data, " "));
                throw new IllegalArgumentException(sb.toString());
            }
            if ((builder2.data.length + 2) % 8 != 0) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("(builder.data.length + 2) % 8 must be 0. data: ").append(builder2.data);
                throw new IllegalArgumentException(sb.toString());
            }
            this.nextHeader = builder2.nextHeader;
            this.data = ByteArrays.clone(builder2.data);
            this.hdrExtLen = builder2.correctLengthAtBuild ? (byte)((this.data.length + 2) / 8 - 1) : builder2.hdrExtLen;
        }

        public IpNumber getNextHeader() {
            return this.nextHeader;
        }

        public byte getHdrExtLen() {
            return this.hdrExtLen;
        }

        public int getHdrExtLenAsInt() {
            return 0xFF & this.hdrExtLen;
        }

        public byte[] getData() {
            return ByteArrays.clone(this.data);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.nextHeader.value()));
            rawFields.add(ByteArrays.toByteArray(this.hdrExtLen));
            rawFields.add(this.getData());
            return rawFields;
        }

        @Override
        public int calcLength() {
            return this.data.length + 2;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[IPv6 Unknown Extension Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Next Header: ").append(this.nextHeader).append(ls);
            sb.append("  Hdr Ext Len: ").append(this.getHdrExtLenAsInt()).append(" (").append((this.getHdrExtLenAsInt() + 1) * 8).append(" [bytes])").append(ls);
            sb.append("  data: ").append(ByteArrays.toHexString(this.data, " ")).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IpV6ExtUnknownHeader other = (IpV6ExtUnknownHeader)obj;
            return this.nextHeader.equals(other.nextHeader) && this.hdrExtLen == other.hdrExtLen && Arrays.equals(this.data, other.data);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.nextHeader.hashCode();
            result = 31 * result + this.hdrExtLen;
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<IpV6ExtUnknownPacket> {
        private IpNumber nextHeader;
        private byte hdrExtLen;
        private byte[] data;
        private Packet.Builder payloadBuilder;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        public Builder(IpV6ExtUnknownPacket packet) {
            this.nextHeader = packet.header.nextHeader;
            this.hdrExtLen = packet.header.hdrExtLen;
            this.data = packet.header.data;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder nextHeader(IpNumber nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder hdrExtLen(byte hdrExtLen) {
            this.hdrExtLen = hdrExtLen;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6ExtUnknownPacket build() {
            return new IpV6ExtUnknownPacket(this);
        }
    }
}

