/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.hibernate.query.spi.QueryInterpretationCache;

public class NonSelectInterpretationsKey
implements QueryInterpretationCache.Key {
    private final String sql;
    private final Collection<String> querySpaces;

    public NonSelectInterpretationsKey(String sql, Collection<String> querySpaces) {
        this.sql = sql;
        this.querySpaces = querySpaces == null ? Collections.emptySet() : querySpaces;
    }

    @Override
    public String getQueryString() {
        return this.sql;
    }

    @Override
    public QueryInterpretationCache.Key prepareForStore() {
        return new NonSelectInterpretationsKey(this.sql, (Collection<String>)(this.querySpaces.isEmpty() ? Collections.emptySet() : new HashSet<String>(this.querySpaces)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonSelectInterpretationsKey that = (NonSelectInterpretationsKey)o;
        if (!this.sql.equals(that.sql)) {
            return false;
        }
        return this.querySpaces.equals(that.querySpaces);
    }

    public int hashCode() {
        int result = this.sql.hashCode();
        result = 31 * result + this.querySpaces.hashCode();
        return result;
    }
}

