/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mdns.internal;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.openhab.core.io.transport.mdns.MDNSClient;
import org.openhab.core.io.transport.mdns.ServiceDescription;
import org.openhab.core.net.CidrAddress;
import org.openhab.core.net.NetworkAddressChangeListener;
import org.openhab.core.net.NetworkAddressService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={MDNSClient.class})
public class MDNSClientImpl
implements MDNSClient,
NetworkAddressChangeListener {
    private final Logger logger = LoggerFactory.getLogger(MDNSClientImpl.class);
    private final Map<InetAddress, JmDNS> jmdnsInstances = new ConcurrentHashMap<InetAddress, JmDNS>();
    private final Set<ServiceDescription> activeServices = ConcurrentHashMap.newKeySet();
    private final NetworkAddressService networkAddressService;

    @Activate
    public MDNSClientImpl(@Reference NetworkAddressService networkAddressService) {
        this.networkAddressService = networkAddressService;
    }

    /*
     * Unable to fully structure code
     */
    private Set<InetAddress> getAllInetAddresses() {
        addresses = new HashSet<InetAddress>();
        try {
            itInterfaces = NetworkInterface.getNetworkInterfaces();
            if (true) ** GOTO lbl49
        }
        catch (SocketException e) {
            return addresses;
        }
        do {
            iface = itInterfaces.nextElement();
            try {
                if (!iface.isUp() || iface.isLoopback()) continue;
                if (iface.isPointToPoint()) {
                }
            }
            catch (SocketException ex) {}
            continue;
            primaryIPv4HostAddress = null;
            if (this.networkAddressService.isUseOnlyOneAddress() && this.networkAddressService.getPrimaryIpv4HostAddress() != null) {
                itAddresses = iface.getInetAddresses();
                while (itAddresses.hasMoreElements()) {
                    address = itAddresses.nextElement();
                    if (!address.getHostAddress().equals(this.networkAddressService.getPrimaryIpv4HostAddress())) continue;
                    primaryIPv4HostAddress = address;
                    break;
                }
            }
            itAddresses = iface.getInetAddresses();
            ipv4addressAdded = false;
            ipv6addressAdded = false;
            while (itAddresses.hasMoreElements()) {
                address = itAddresses.nextElement();
                if (address.isLoopbackAddress() || address.isLinkLocalAddress() || !this.networkAddressService.isUseIPv6() && address instanceof Inet6Address) continue;
                if (this.networkAddressService.isUseOnlyOneAddress()) {
                    if (address instanceof Inet4Address) {
                        if (ipv4addressAdded) continue;
                        if (primaryIPv4HostAddress != null) {
                            addresses.add(primaryIPv4HostAddress);
                        } else {
                            addresses.add(address);
                        }
                        ipv4addressAdded = true;
                        continue;
                    }
                    if (!(address instanceof Inet6Address) || ipv6addressAdded) continue;
                    addresses.add(address);
                    ipv6addressAdded = true;
                    continue;
                }
                addresses.add(address);
            }
lbl49:
            // 5 sources

        } while (itInterfaces.hasMoreElements());
        return addresses;
    }

    @Override
    public Set<JmDNS> getClientInstances() {
        return new HashSet<JmDNS>(this.jmdnsInstances.values());
    }

    @Activate
    protected void activate() {
        this.networkAddressService.addNetworkAddressChangeListener((NetworkAddressChangeListener)this);
        this.start();
    }

    private void start() {
        for (InetAddress address : this.getAllInetAddresses()) {
            this.createJmDNSByAddress(address);
        }
        for (ServiceDescription description : this.activeServices) {
            try {
                this.registerServiceInternal(description);
            }
            catch (IOException e) {
                this.logger.warn("Exception while registering service {}", (Object)description, (Object)e);
            }
        }
    }

    @Deactivate
    public void deactivate() {
        this.close();
        this.activeServices.clear();
        this.networkAddressService.removeNetworkAddressChangeListener((NetworkAddressChangeListener)this);
    }

    @Override
    public void addServiceListener(String type, ServiceListener listener) {
        this.jmdnsInstances.values().forEach(jmdns -> jmdns.addServiceListener(type, listener));
    }

    @Override
    public void removeServiceListener(String type, ServiceListener listener) {
        this.jmdnsInstances.values().forEach(jmdns -> jmdns.removeServiceListener(type, listener));
    }

    @Override
    public void registerService(ServiceDescription description) throws IOException {
        this.activeServices.add(description);
        this.registerServiceInternal(description);
    }

    private void registerServiceInternal(ServiceDescription description) throws IOException {
        for (JmDNS instance : this.jmdnsInstances.values()) {
            this.logger.debug("Registering new service {} at {}:{} ({})", new Object[]{description.serviceType, instance.getInetAddress().getHostAddress(), description.servicePort, instance.getName()});
            ServiceInfo serviceInfo = ServiceInfo.create((String)description.serviceType, (String)description.serviceName, (int)description.servicePort, (int)0, (int)0, description.serviceProperties);
            instance.registerService(serviceInfo);
        }
    }

    @Override
    public void unregisterService(ServiceDescription description) {
        this.activeServices.remove(description);
        this.unregisterServiceInternal(description);
    }

    private void unregisterServiceInternal(ServiceDescription description) {
        for (JmDNS instance : this.jmdnsInstances.values()) {
            try {
                this.logger.debug("Unregistering service {} at {}:{} ({})", new Object[]{description.serviceType, instance.getInetAddress().getHostAddress(), description.servicePort, instance.getName()});
            }
            catch (IOException e) {
                this.logger.debug("Unregistering service {} ({})", (Object)description.serviceType, (Object)instance.getName());
            }
            ServiceInfo serviceInfo = ServiceInfo.create((String)description.serviceType, (String)description.serviceName, (int)description.servicePort, (int)0, (int)0, description.serviceProperties);
            instance.unregisterService(serviceInfo);
        }
    }

    @Override
    public void unregisterAllServices() {
        this.activeServices.clear();
        for (JmDNS instance : this.jmdnsInstances.values()) {
            instance.unregisterAllServices();
        }
    }

    @Override
    public ServiceInfo[] list(String type) {
        ServiceInfo[] services = new ServiceInfo[]{};
        for (JmDNS instance : this.jmdnsInstances.values()) {
            services = this.concatenate(services, instance.list(type));
        }
        return services;
    }

    @Override
    public ServiceInfo[] list(String type, Duration timeout) {
        ServiceInfo[] services = new ServiceInfo[]{};
        for (JmDNS instance : this.jmdnsInstances.values()) {
            services = this.concatenate(services, instance.list(type, timeout.toMillis()));
        }
        return services;
    }

    @Override
    public void close() {
        for (JmDNS jmdns : this.jmdnsInstances.values()) {
            this.closeQuietly(jmdns);
            this.logger.debug("mDNS service has been stopped ({})", (Object)jmdns.getName());
        }
        this.jmdnsInstances.clear();
    }

    private void closeQuietly(JmDNS jmdns) {
        try {
            jmdns.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ServiceInfo[] concatenate(ServiceInfo[] a, ServiceInfo[] b) {
        int aLen = a.length;
        int bLen = b.length;
        ServiceInfo[] c = new ServiceInfo[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    private void createJmDNSByAddress(InetAddress address) {
        try {
            JmDNS jmdns = JmDNS.create((InetAddress)address, null);
            this.jmdnsInstances.put(address, jmdns);
            this.logger.debug("mDNS service has been started ({} for IP {})", (Object)jmdns.getName(), (Object)address.getHostAddress());
        }
        catch (IOException e) {
            this.logger.debug("JmDNS instantiation failed ({})!", (Object)address.getHostAddress());
        }
    }

    public void onChanged(List<CidrAddress> added, List<CidrAddress> removed) {
        JmDNS jmdns;
        this.logger.debug("ip address change: added {}, removed {}", added, removed);
        Set<InetAddress> filteredAddresses = this.getAllInetAddresses();
        boolean changeRequired = false;
        for (InetAddress address : this.jmdnsInstances.keySet()) {
            if (filteredAddresses.contains(address)) continue;
            changeRequired = true;
            break;
        }
        if (!changeRequired) {
            for (InetAddress address : filteredAddresses) {
                jmdns = this.jmdnsInstances.get(address);
                if (jmdns != null) continue;
                changeRequired = true;
                break;
            }
        }
        if (!changeRequired) {
            this.logger.debug("mDNS services already OK for these ip addresses");
            return;
        }
        for (ServiceDescription description : this.activeServices) {
            this.unregisterServiceInternal(description);
        }
        for (InetAddress address : this.jmdnsInstances.keySet()) {
            if (filteredAddresses.contains(address) || (jmdns = this.jmdnsInstances.remove(address)) == null) continue;
            this.closeQuietly(jmdns);
            this.logger.debug("mDNS service has been stopped ({} for IP {})", (Object)jmdns.getName(), (Object)address.getHostAddress());
        }
        for (InetAddress address : filteredAddresses) {
            jmdns = this.jmdnsInstances.get(address);
            if (jmdns == null) {
                this.createJmDNSByAddress(address);
                continue;
            }
            this.logger.debug("mDNS service was already started ({} for IP {})", (Object)jmdns.getName(), (Object)address.getHostAddress());
        }
        for (ServiceDescription description : this.activeServices) {
            try {
                this.registerServiceInternal(description);
            }
            catch (IOException e) {
                this.logger.warn("Exception while registering service {}", (Object)description, (Object)e);
            }
        }
    }
}

