/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.helper;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.cm.impl.helper.ConfigurationMap;
import org.apache.felix.cm.impl.helper.TargetedPID;

class ManagedServiceConfigurationMap
extends ConfigurationMap<Entry> {
    protected ManagedServiceConfigurationMap(String[] configuredPids) {
        super(configuredPids);
    }

    @Override
    protected Map<String, Entry> createMap(int size) {
        return new HashMap<String, Entry>(size);
    }

    @Override
    protected boolean shallTake(TargetedPID configPid, TargetedPID factoryPid, long revision) {
        Entry entry = (Entry)this.get(configPid);
        if (entry == null) {
            return true;
        }
        if (configPid.equals(entry.targetedPid)) {
            return revision > entry.revision;
        }
        return configPid.bindsStronger(entry.targetedPid);
    }

    @Override
    protected boolean removeConfiguration(TargetedPID configPid, TargetedPID factoryPid) {
        Entry entry = (Entry)this.get(configPid);
        if (entry == null) {
            return false;
        }
        return configPid.equals(entry.targetedPid);
    }

    @Override
    protected void record(TargetedPID configPid, TargetedPID factoryPid, long revision) {
        Entry entry = revision < 0L ? null : new Entry(configPid, revision);
        this.put(configPid, entry);
    }

    static class Entry {
        final TargetedPID targetedPid;
        final long revision;

        Entry(TargetedPID targetedPid, long revision) {
            this.targetedPid = targetedPid;
            this.revision = revision;
        }

        public String toString() {
            return "Entry(pid=" + this.targetedPid + ",rev=" + this.revision + ")";
        }
    }
}

