/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.tasty;

import dotty.tools.tasty.TastyBuffer$Addr$;
import dotty.tools.tasty.TastyFormat$;
import dotty.tools.tasty.TastyHeader;
import dotty.tools.tasty.TastyHeaderUnpickler$;
import dotty.tools.tasty.TastyReader;
import dotty.tools.tasty.TastyVersion;
import dotty.tools.tasty.TastyVersion$;
import dotty.tools.tasty.UnpickleException;
import dotty.tools.tasty.UnpicklerConfig;
import dotty.tools.tasty.UnpicklerConfig$;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class TastyHeaderUnpickler {
    private final UnpicklerConfig config;
    private final TastyReader reader;
    private final int toolMajor;
    private final int toolMinor;
    private final int toolExperimental;

    public TastyHeaderUnpickler(UnpicklerConfig config, TastyReader reader) {
        this.config = config;
        this.reader = reader;
        this.toolMajor = config.majorVersion();
        this.toolMinor = config.minorVersion();
        this.toolExperimental = config.experimentalVersion();
    }

    public TastyHeaderUnpickler(UnpicklerConfig config, byte[] bytes) {
        this(config, new TastyReader(bytes));
    }

    public TastyHeaderUnpickler(TastyReader reader) {
        this(UnpicklerConfig$.MODULE$.generic(), reader);
    }

    public TastyHeaderUnpickler(byte[] bytes) {
        this(new TastyReader(bytes));
    }

    public UUID readHeader() {
        return this.readFullHeader().uuid();
    }

    public TastyHeader readFullHeader() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), TastyFormat$.MODULE$.header().length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$check(this.reader.readByte() == TastyFormat$.MODULE$.header()[i], (Function0<String>)((Function0 & Serializable)TastyHeaderUnpickler::readFullHeader$$anonfun$1$$anonfun$1)));
        int fileMajor = this.reader.readNat();
        if (fileMajor <= 27) {
            int fileMinor = this.reader.readNat();
            TastyVersion fileVersion = TastyVersion$.MODULE$.apply(fileMajor, fileMinor, 0);
            TastyVersion toolVersion = TastyVersion$.MODULE$.apply(this.toolMajor, this.toolMinor, this.toolExperimental);
            String signature = TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$signatureString(fileVersion, toolVersion, "Backward", (Option<String>)None$.MODULE$);
            String fix = TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$recompileFix(toolVersion.minStable(), this.config);
            throw new UnpickleException(new StringBuilder(0).append(signature).append(fix).append(TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$tastyAddendum()).toString());
        }
        int fileMinor = this.reader.readNat();
        int fileExperimental = this.reader.readNat();
        int length = this.reader.readNat();
        int start = this.reader.currentAddr();
        int end = TastyBuffer$Addr$.MODULE$.$plus$extension(start, length);
        this.reader.goto(end);
        String toolingVersion = new String(this.reader.bytes(), start, length);
        TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$checkValidVersion(fileMajor, fileMinor, fileExperimental, toolingVersion, this.config);
        UUID uuid = new UUID(this.reader.readUncompressedLong(), this.reader.readUncompressedLong());
        return new TastyHeader(uuid, fileMajor, fileMinor, fileExperimental, toolingVersion){};
    }

    public boolean isAtEnd() {
        return this.reader.isAtEnd();
    }

    private static final String readFullHeader$$anonfun$1$$anonfun$1() {
        return "not a TASTy file";
    }
}

