/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.keys;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPublicKey;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.util.Objects;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomDhPublicKey
extends CustomPublicKey
implements DHPublicKey {
    private static final Logger LOGGER = LogManager.getLogger();
    private BigInteger modulus;
    private BigInteger generator;
    private BigInteger publicKey;

    public CustomDhPublicKey(BigInteger modulus, BigInteger generator, BigInteger publicKey) {
        this.modulus = modulus;
        this.generator = generator;
        this.publicKey = publicKey;
    }

    private CustomDhPublicKey() {
        this.modulus = null;
        this.generator = null;
        this.publicKey = null;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getGenerator() {
        return this.generator;
    }

    @Override
    public void adjustInContext(TlsContext context, ConnectionEndType ownerOfKey) {
        LOGGER.debug("Adjusting DH public key in context");
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                context.setClientDhGenerator(this.generator);
                context.setClientDhModulus(this.modulus);
                context.setClientDhPublicKey(this.publicKey);
                break;
            }
            case SERVER: {
                context.setServerDhGenerator(this.generator);
                context.setServerDhModulus(this.modulus);
                context.setServerDhPublicKey(this.publicKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    @Override
    public BigInteger getY() {
        return this.publicKey;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.modulus, this.generator);
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public String getFormat() {
        return "None";
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void adjustInConfig(Config config, ConnectionEndType ownerOfKey) {
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                config.setDefaultClientDhGenerator(this.generator);
                config.setDefaultClientDhModulus(this.modulus);
                config.setDefaultClientDhPublicKey(this.publicKey);
                break;
            }
            case SERVER: {
                config.setDefaultServerDhGenerator(this.generator);
                config.setDefaultServerDhModulus(this.modulus);
                config.setDefaultServerDhPublicKey(this.publicKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.modulus);
        hash = 79 * hash + Objects.hashCode(this.generator);
        hash = 79 * hash + Objects.hashCode(this.publicKey);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomDhPublicKey other = (CustomDhPublicKey)obj;
        if (!Objects.equals(this.modulus, other.modulus)) {
            return false;
        }
        if (!Objects.equals(this.generator, other.generator)) {
            return false;
        }
        return Objects.equals(this.publicKey, other.publicKey);
    }

    public void setModulus(BigInteger modulus) {
        this.modulus = modulus;
    }

    public void setGenerator(BigInteger generator) {
        this.generator = generator;
    }

    public void setPublicKey(BigInteger publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public int keysize() {
        return this.modulus.bitLength();
    }
}

