/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.BulkWriterOperation;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.UpdateBuilder;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.rpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;

class BulkCommitBatch
extends UpdateBuilder<ApiFuture<WriteResult>> {
    final List<BulkWriterOperation> pendingOperations = new ArrayList<BulkWriterOperation>();
    private final Set<DocumentReference> documents = new CopyOnWriteArraySet<DocumentReference>();
    private final Executor executor;
    private int maxBatchSize;

    BulkCommitBatch(FirestoreImpl firestore, Executor executor, int maxBatchSize) {
        super(firestore);
        this.executor = executor;
        this.maxBatchSize = maxBatchSize;
    }

    int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    void setMaxBatchSize(int size) {
        Preconditions.checkState((this.getMutationsSize() <= size ? 1 : 0) != 0, (Object)"New batch size cannot be less than the number of enqueued writes");
        this.maxBatchSize = size;
    }

    @Override
    ApiFuture<WriteResult> wrapResult(int writeIndex) {
        return this.pendingOperations.get(writeIndex).getFuture();
    }

    ApiFuture<Void> bulkCommit() {
        this.committed = true;
        BatchWriteRequest request = this.buildBatchWriteRequest();
        ApiFuture<BatchWriteResponse> response = this.processExceptions(this.firestore.sendRequest(request, this.firestore.getClient().batchWriteCallable()));
        return ApiFutures.transformAsync(response, batchWriteResponse -> {
            ArrayList<ApiFuture<Void>> pendingUserCallbacks = new ArrayList<ApiFuture<Void>>();
            List writeResults = batchWriteResponse.getWriteResultsList();
            List statuses = batchWriteResponse.getStatusList();
            for (int i = 0; i < writeResults.size(); ++i) {
                com.google.firestore.v1.WriteResult writeResult = (com.google.firestore.v1.WriteResult)writeResults.get(i);
                Status status = (Status)statuses.get(i);
                BulkWriterOperation operation = this.pendingOperations.get(i);
                io.grpc.Status code = io.grpc.Status.fromCodeValue((int)status.getCode());
                if (code == io.grpc.Status.OK) {
                    pendingUserCallbacks.add(operation.onSuccess(new WriteResult(Timestamp.fromProto((com.google.protobuf.Timestamp)writeResult.getUpdateTime()))));
                    continue;
                }
                pendingUserCallbacks.add(operation.onException(FirestoreException.forServerRejection(code, status.getMessage(), new Object[0])));
            }
            return BulkWriter.silenceFuture(ApiFutures.allAsList(pendingUserCallbacks));
        }, (Executor)this.executor);
    }

    private BatchWriteRequest buildBatchWriteRequest() {
        BatchWriteRequest.Builder builder = BatchWriteRequest.newBuilder();
        builder.setDatabase(this.firestore.getDatabaseName());
        this.forEachWrite(arg_0 -> ((BatchWriteRequest.Builder)builder).addWrites(arg_0));
        return builder.build();
    }

    private ApiFuture<BatchWriteResponse> processExceptions(ApiFuture<BatchWriteResponse> response) {
        return ApiFutures.catching(response, ApiException.class, exception -> {
            Status.Builder status = Status.newBuilder().setCode(exception.getStatusCode().getCode().ordinal()).setMessage(exception.getMessage());
            BatchWriteResponse.Builder responseBuilder = BatchWriteResponse.newBuilder();
            for (int i = 0; i < this.pendingOperations.size(); ++i) {
                responseBuilder.addWriteResults(com.google.firestore.v1.WriteResult.getDefaultInstance());
                responseBuilder.addStatus(status);
            }
            return responseBuilder.build();
        }, (Executor)MoreExecutors.directExecutor());
    }

    void enqueueOperation(BulkWriterOperation operation) {
        boolean added = this.documents.add(operation.getDocumentReference());
        Preconditions.checkState((boolean)added, (Object)"Batch should not contain writes to the same document");
        this.pendingOperations.add(operation);
    }

    boolean has(DocumentReference documentReference) {
        return this.documents.contains(documentReference);
    }
}

