/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.util.JndiCloser;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.util.PropertiesUtil;

public class JndiManager
extends AbstractManager {
    public static final String ALLOWED_HOSTS = "allowedLdapHosts";
    public static final String ALLOWED_CLASSES = "allowedLdapClasses";
    public static final String ALLOWED_PROTOCOLS = "allowedJndiProtocols";
    private static final JndiManagerFactory FACTORY = new JndiManagerFactory();
    private static final String PREFIX = "log4j2.";
    private static final String LDAP = "ldap";
    private static final String LDAPS = "ldaps";
    private static final String JAVA = "java";
    private static final List<String> permanentAllowedHosts = NetUtils.getLocalIps();
    private static final List<String> permanentAllowedClasses = Arrays.asList(Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), String.class.getName());
    private static final List<String> permanentAllowedProtocols = Arrays.asList("java", "ldap", "ldaps");
    private static final String SERIALIZED_DATA = "javaSerializedData";
    private static final String CLASS_NAME = "javaClassName";
    private static final String REFERENCE_ADDRESS = "javaReferenceAddress";
    private static final String OBJECT_FACTORY = "javaFactory";
    private final List<String> allowedHosts;
    private final List<String> allowedClasses;
    private final List<String> allowedProtocols;
    private final DirContext context;

    private JndiManager(String name, DirContext context, List<String> allowedHosts, List<String> allowedClasses, List<String> allowedProtocols) {
        super(null, name);
        this.context = context;
        this.allowedHosts = allowedHosts;
        this.allowedClasses = allowedClasses;
        this.allowedProtocols = allowedProtocols;
    }

    public static JndiManager getDefaultManager() {
        return JndiManager.getManager(JndiManager.class.getName(), FACTORY, null);
    }

    public static JndiManager getDefaultManager(String name) {
        return JndiManager.getManager(name, FACTORY, null);
    }

    public static JndiManager getJndiManager(String initialContextFactoryName, String providerURL, String urlPkgPrefixes, String securityPrincipal, String securityCredentials, Properties additionalProperties) {
        Properties properties = JndiManager.createProperties(initialContextFactoryName, providerURL, urlPkgPrefixes, securityPrincipal, securityCredentials, additionalProperties);
        return JndiManager.getManager(JndiManager.createManagerName(), FACTORY, properties);
    }

    public static JndiManager getJndiManager(Properties properties) {
        return JndiManager.getManager(JndiManager.createManagerName(), FACTORY, properties);
    }

    private static String createManagerName() {
        return JndiManager.class.getName() + '@' + JndiManager.class.hashCode();
    }

    public static Properties createProperties(String initialContextFactoryName, String providerURL, String urlPkgPrefixes, String securityPrincipal, String securityCredentials, Properties additionalProperties) {
        if (initialContextFactoryName == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", initialContextFactoryName);
        if (providerURL != null) {
            properties.setProperty("java.naming.provider.url", providerURL);
        } else {
            LOGGER.warn("The JNDI InitialContextFactory class name [{}] was provided, but there was no associated provider URL. This is likely to cause problems.", (Object)initialContextFactoryName);
        }
        if (urlPkgPrefixes != null) {
            properties.setProperty("java.naming.factory.url.pkgs", urlPkgPrefixes);
        }
        if (securityPrincipal != null) {
            properties.setProperty("java.naming.security.principal", securityPrincipal);
            if (securityCredentials != null) {
                properties.setProperty("java.naming.security.credentials", securityCredentials);
            } else {
                LOGGER.warn("A security principal [{}] was provided, but with no corresponding security credentials.", (Object)securityPrincipal);
            }
        }
        if (additionalProperties != null) {
            properties.putAll((Map<?, ?>)additionalProperties);
        }
        return properties;
    }

    @Override
    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        return JndiCloser.closeSilently(this.context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized <T> T lookup(String name) throws NamingException {
        try {
            URI uri = new URI(name);
            if (uri.getScheme() == null) return (T)this.context.lookup(name);
            if (!this.allowedProtocols.contains(uri.getScheme().toLowerCase(Locale.ROOT))) {
                LOGGER.warn("Log4j JNDI does not allow protocol {}", (Object)uri.getScheme());
                return null;
            }
            if (!LDAP.equalsIgnoreCase(uri.getScheme())) {
                if (!LDAPS.equalsIgnoreCase(uri.getScheme())) return (T)this.context.lookup(name);
            }
            if (!this.allowedHosts.contains(uri.getHost())) {
                LOGGER.warn("Attempt to access ldap server not in allowed list");
                return null;
            }
            Attributes attributes = this.context.getAttributes(name);
            if (attributes == null) return (T)this.context.lookup(name);
            HashMap<String, Attribute> attributeMap = new HashMap<String, Attribute>();
            NamingEnumeration<? extends Attribute> enumeration = attributes.getAll();
            while (enumeration.hasMore()) {
                Attribute attribute = enumeration.next();
                attributeMap.put(attribute.getID(), attribute);
            }
            Attribute classNameAttr = (Attribute)attributeMap.get(CLASS_NAME);
            if (attributeMap.get(SERIALIZED_DATA) != null) {
                if (classNameAttr != null) {
                    String className = classNameAttr.get().toString();
                    if (this.allowedClasses.contains(className)) return (T)this.context.lookup(name);
                    LOGGER.warn("Deserialization of {} is not allowed", (Object)className);
                    return null;
                }
                LOGGER.warn("No class name provided for {}", (Object)name);
                return null;
            }
            if (attributeMap.get(REFERENCE_ADDRESS) == null) {
                if (attributeMap.get(OBJECT_FACTORY) == null) return (T)this.context.lookup(name);
            }
            LOGGER.warn("Referenceable class is not allowed for {}", (Object)name);
            return null;
        }
        catch (URISyntaxException ex) {
            LOGGER.warn("Invalid JNDI URI - {}", (Object)name);
            return null;
        }
    }

    public String toString() {
        return "JndiManager [context=" + this.context + ", count=" + this.count + "]";
    }

    private static class JndiManagerFactory
    implements ManagerFactory<JndiManager, Properties> {
        private JndiManagerFactory() {
        }

        @Override
        public JndiManager createManager(String name, Properties data) {
            String hosts = data != null ? data.getProperty(JndiManager.ALLOWED_HOSTS) : null;
            String classes = data != null ? data.getProperty(JndiManager.ALLOWED_CLASSES) : null;
            String protocols = data != null ? data.getProperty(JndiManager.ALLOWED_PROTOCOLS) : null;
            ArrayList<String> allowedHosts = new ArrayList<String>();
            ArrayList<String> allowedClasses = new ArrayList<String>();
            ArrayList<String> allowedProtocols = new ArrayList<String>();
            this.addAll(hosts, allowedHosts, permanentAllowedHosts, JndiManager.ALLOWED_HOSTS, data);
            this.addAll(classes, allowedClasses, permanentAllowedClasses, JndiManager.ALLOWED_CLASSES, data);
            this.addAll(protocols, allowedProtocols, permanentAllowedProtocols, JndiManager.ALLOWED_PROTOCOLS, data);
            try {
                return new JndiManager(name, new InitialDirContext(data), allowedHosts, allowedClasses, allowedProtocols);
            }
            catch (NamingException e) {
                LOGGER.error("Error creating JNDI InitialContext.", (Throwable)e);
                return null;
            }
        }

        private void addAll(String toSplit, List<String> list, List<String> permanentList, String propertyName, Properties data) {
            if (toSplit != null) {
                list.addAll(Arrays.asList(toSplit.split("\\s*,\\s*")));
                data.remove(propertyName);
            }
            if ((toSplit = PropertiesUtil.getProperties().getStringProperty(JndiManager.PREFIX + propertyName)) != null) {
                list.addAll(Arrays.asList(toSplit.split("\\s*,\\s*")));
            }
            list.addAll(permanentList);
        }
    }
}

