/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AlignAction;
import org.jhotdraw.gui.event.SelectionComponentDisplayer;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.util.ResourceBundleUtil;

public class AlignToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;

    public AlignToolBar() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(resourceBundleUtil.getString(this.getID() + ".toolbar"));
    }

    @Override
    public void setEditor(DrawingEditor drawingEditor) {
        DrawingEditor drawingEditor2 = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(drawingEditor);
        if (drawingEditor != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
            this.displayer.setMinSelectionCount(2);
            this.displayer.setVisibleIfCreationTool(false);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 0;
                AlignAction alignAction = new AlignAction.West(this.editor, resourceBundleUtil);
                JButton jButton = new JButton(alignAction);
                this.disposables.add(alignAction);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.setText(null);
                jPanel.add((Component)jButton, gridBagConstraints);
                gridBagConstraints.insets = new Insets(0, 3, 0, 0);
                alignAction = new AlignAction.East(this.editor, resourceBundleUtil);
                jButton = new JButton(alignAction);
                this.disposables.add(alignAction);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("hideActionText", Boolean.TRUE);
                jButton.setText(null);
                jPanel.add((Component)jButton, gridBagConstraints);
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                alignAction = new AlignAction.North(this.editor, resourceBundleUtil);
                jButton = new JButton(alignAction);
                this.disposables.add(alignAction);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("hideActionText", Boolean.TRUE);
                jButton.setText(null);
                jPanel.add((Component)jButton, gridBagConstraints);
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                alignAction = new AlignAction.South(this.editor, resourceBundleUtil);
                jButton = new JButton(alignAction);
                this.disposables.add(alignAction);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("hideActionText", Boolean.TRUE);
                jButton.setText(null);
                jPanel.add((Component)jButton, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                alignAction = new AlignAction.Horizontal(this.editor, resourceBundleUtil);
                jButton = new JButton(alignAction);
                this.disposables.add(alignAction);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("hideActionText", Boolean.TRUE);
                jButton.setText(null);
                jPanel.add((Component)jButton, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                alignAction = new AlignAction.Vertical(this.editor, resourceBundleUtil);
                jButton = new JButton(alignAction);
                this.disposables.add(alignAction);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("hideActionText", Boolean.TRUE);
                jButton.setText(null);
                jPanel.add((Component)jButton, gridBagConstraints);
            }
        }
        return jPanel;
    }

    private void initComponents() {
        this.setOpaque(false);
    }

    @Override
    protected String getID() {
        return "align";
    }
}

