"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchAgent = exports.getAgentIdByConfigName = void 0;
var _constants = require("../utils/constants");
var _errors = require("./errors");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getAgentIdByConfigName = async (configName, client) => {
  var _response$body$ml_con, _response$body$config, _response$body$ml_con2;
  const path = `${_constants.ML_COMMONS_BASE_API}/config/${configName}`;
  const response = await client.request({
    method: 'GET',
    path
  });
  if (!response || !((_response$body$ml_con = response.body.ml_configuration) !== null && _response$body$ml_con !== void 0 && _response$body$ml_con.agent_id || (_response$body$config = response.body.configuration) !== null && _response$body$config !== void 0 && _response$body$config.agent_id)) {
    throw new _errors.AgentNotFoundError(`cannot get agent by config name ${configName} by calling the api: ${path}`);
  }
  return ((_response$body$ml_con2 = response.body.ml_configuration) === null || _response$body$ml_con2 === void 0 ? void 0 : _response$body$ml_con2.agent_id) || response.body.configuration.agent_id;
};
exports.getAgentIdByConfigName = getAgentIdByConfigName;
const searchAgent = async ({
  name
}, client) => {
  const requestParams = {
    query: {
      term: {
        'name.keyword': name
      }
    },
    _source: ['_id'],
    sort: {
      created_time: 'desc'
    },
    size: 1
  };
  const path = `${_constants.ML_COMMONS_BASE_API}/agents/_search`;
  const response = await client.request({
    method: 'GET',
    path,
    body: requestParams
  });
  if (!response || response.body.hits.total.value === 0) {
    throw new _errors.AgentNotFoundError(`cannot find agent by name ${name} by calling the api: ${path}`);
  }
  return response.body.hits.hits[0]._id;
};
exports.searchAgent = searchAgent;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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