"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flowFrameworkPlugin = flowFrameworkPlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Used during the plugin's setup() lifecycle phase to register various client actions
 * representing Flow Framework plugin APIs. These are then exposed and used on the
 * server-side when processing node APIs - see server/routes/flow_framework_routes_service
 * for examples.
 */
function flowFrameworkPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.flowFramework = components.clientAction.namespaceFactory();
  const flowFramework = Client.prototype.flowFramework.prototype;
  flowFramework.getWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  flowFramework.searchWorkflows = ca({
    url: {
      fmt: _common.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE
    },
    needBody: true,
    // Exposed client rejects making GET requests with a body. So, we use POST
    method: 'POST'
  });
  flowFramework.getWorkflowState = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_status`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  flowFramework.searchWorkflowState = ca({
    url: {
      fmt: _common.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE
    },
    needBody: true,
    // Exposed client rejects making GET requests with a body. So, we use POST
    method: 'POST'
  });
  flowFramework.createWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}?provision=false`
    },
    needBody: true,
    method: 'POST'
  });
  flowFramework.updateWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>?update_fields=<%=update_fields%>&reprovision=<%=reprovision%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        update_fields: {
          type: 'boolean',
          required: true
        },
        reprovision: {
          type: 'boolean',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  flowFramework.provisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_provision`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.deprovisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_deprovision`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.forceDeprovisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_deprovision?allow_delete=<%=resource_ids%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        resource_ids: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.deleteWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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