/**
 * vis-network
 * https://visjs.github.io/vis-network/
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 9.1.9
 * @date    2023-11-03T01:44:38.007Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */

(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.vis = global.vis || {}));
})(this, (function (exports) { 'use strict';

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getDefaultExportFromCjs (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	var check = function (it) {
	  return it && it.Math === Math && it;
	};

	// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
	var global$s =
	  // eslint-disable-next-line es/no-global-this -- safe
	  check(typeof globalThis == 'object' && globalThis) ||
	  check(typeof window == 'object' && window) ||
	  // eslint-disable-next-line no-restricted-globals -- safe
	  check(typeof self == 'object' && self) ||
	  check(typeof commonjsGlobal == 'object' && commonjsGlobal) ||
	  // eslint-disable-next-line no-new-func -- fallback
	  (function () { return this; })() || commonjsGlobal || Function('return this')();

	var fails$A = function (exec) {
	  try {
	    return !!exec();
	  } catch (error) {
	    return true;
	  }
	};

	var fails$z = fails$A;

	var functionBindNative = !fails$z(function () {
	  // eslint-disable-next-line es/no-function-prototype-bind -- safe
	  var test = (function () { /* empty */ }).bind();
	  // eslint-disable-next-line no-prototype-builtins -- safe
	  return typeof test != 'function' || test.hasOwnProperty('prototype');
	});

	var NATIVE_BIND$4 = functionBindNative;

	var FunctionPrototype$4 = Function.prototype;
	var apply$6 = FunctionPrototype$4.apply;
	var call$l = FunctionPrototype$4.call;

	// eslint-disable-next-line es/no-reflect -- safe
	var functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND$4 ? call$l.bind(apply$6) : function () {
	  return call$l.apply(apply$6, arguments);
	});

	var NATIVE_BIND$3 = functionBindNative;

	var FunctionPrototype$3 = Function.prototype;
	var call$k = FunctionPrototype$3.call;
	var uncurryThisWithBind = NATIVE_BIND$3 && FunctionPrototype$3.bind.bind(call$k, call$k);

	var functionUncurryThis = NATIVE_BIND$3 ? uncurryThisWithBind : function (fn) {
	  return function () {
	    return call$k.apply(fn, arguments);
	  };
	};

	var uncurryThis$z = functionUncurryThis;

	var toString$d = uncurryThis$z({}.toString);
	var stringSlice$1 = uncurryThis$z(''.slice);

	var classofRaw$2 = function (it) {
	  return stringSlice$1(toString$d(it), 8, -1);
	};

	var classofRaw$1 = classofRaw$2;
	var uncurryThis$y = functionUncurryThis;

	var functionUncurryThisClause = function (fn) {
	  // Nashorn bug:
	  //   https://github.com/zloirock/core-js/issues/1128
	  //   https://github.com/zloirock/core-js/issues/1130
	  if (classofRaw$1(fn) === 'Function') return uncurryThis$y(fn);
	};

	var documentAll$2 = typeof document == 'object' && document.all;

	// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
	// eslint-disable-next-line unicorn/no-typeof-undefined -- required for testing
	var IS_HTMLDDA = typeof documentAll$2 == 'undefined' && documentAll$2 !== undefined;

	var documentAll_1 = {
	  all: documentAll$2,
	  IS_HTMLDDA: IS_HTMLDDA
	};

	var $documentAll$1 = documentAll_1;

	var documentAll$1 = $documentAll$1.all;

	// `IsCallable` abstract operation
	// https://tc39.es/ecma262/#sec-iscallable
	var isCallable$m = $documentAll$1.IS_HTMLDDA ? function (argument) {
	  return typeof argument == 'function' || argument === documentAll$1;
	} : function (argument) {
	  return typeof argument == 'function';
	};

	var objectGetOwnPropertyDescriptor = {};

	var fails$y = fails$A;

	// Detect IE8's incomplete defineProperty implementation
	var descriptors = !fails$y(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] !== 7;
	});

	var NATIVE_BIND$2 = functionBindNative;

	var call$j = Function.prototype.call;

	var functionCall = NATIVE_BIND$2 ? call$j.bind(call$j) : function () {
	  return call$j.apply(call$j, arguments);
	};

	var objectPropertyIsEnumerable = {};

	var $propertyIsEnumerable$2 = {}.propertyIsEnumerable;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getOwnPropertyDescriptor$a = Object.getOwnPropertyDescriptor;

	// Nashorn ~ JDK8 bug
	var NASHORN_BUG = getOwnPropertyDescriptor$a && !$propertyIsEnumerable$2.call({ 1: 2 }, 1);

	// `Object.prototype.propertyIsEnumerable` method implementation
	// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
	objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
	  var descriptor = getOwnPropertyDescriptor$a(this, V);
	  return !!descriptor && descriptor.enumerable;
	} : $propertyIsEnumerable$2;

	var createPropertyDescriptor$7 = function (bitmap, value) {
	  return {
	    enumerable: !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable: !(bitmap & 4),
	    value: value
	  };
	};

	var uncurryThis$x = functionUncurryThis;
	var fails$x = fails$A;
	var classof$g = classofRaw$2;

	var $Object$5 = Object;
	var split = uncurryThis$x(''.split);

	// fallback for non-array-like ES3 and non-enumerable old V8 strings
	var indexedObject = fails$x(function () {
	  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
	  // eslint-disable-next-line no-prototype-builtins -- safe
	  return !$Object$5('z').propertyIsEnumerable(0);
	}) ? function (it) {
	  return classof$g(it) === 'String' ? split(it, '') : $Object$5(it);
	} : $Object$5;

	// we can't use just `it == null` since of `document.all` special case
	// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
	var isNullOrUndefined$7 = function (it) {
	  return it === null || it === undefined;
	};

	var isNullOrUndefined$6 = isNullOrUndefined$7;

	var $TypeError$h = TypeError;

	// `RequireObjectCoercible` abstract operation
	// https://tc39.es/ecma262/#sec-requireobjectcoercible
	var requireObjectCoercible$5 = function (it) {
	  if (isNullOrUndefined$6(it)) throw new $TypeError$h("Can't call method on " + it);
	  return it;
	};

	// toObject with fallback for non-array-like ES3 strings
	var IndexedObject$3 = indexedObject;
	var requireObjectCoercible$4 = requireObjectCoercible$5;

	var toIndexedObject$b = function (it) {
	  return IndexedObject$3(requireObjectCoercible$4(it));
	};

	var isCallable$l = isCallable$m;
	var $documentAll = documentAll_1;

	var documentAll = $documentAll.all;

	var isObject$m = $documentAll.IS_HTMLDDA ? function (it) {
	  return typeof it == 'object' ? it !== null : isCallable$l(it) || it === documentAll;
	} : function (it) {
	  return typeof it == 'object' ? it !== null : isCallable$l(it);
	};

	var path$A = {};

	var path$z = path$A;
	var global$r = global$s;
	var isCallable$k = isCallable$m;

	var aFunction = function (variable) {
	  return isCallable$k(variable) ? variable : undefined;
	};

	var getBuiltIn$f = function (namespace, method) {
	  return arguments.length < 2 ? aFunction(path$z[namespace]) || aFunction(global$r[namespace])
	    : path$z[namespace] && path$z[namespace][method] || global$r[namespace] && global$r[namespace][method];
	};

	var uncurryThis$w = functionUncurryThis;

	var objectIsPrototypeOf = uncurryThis$w({}.isPrototypeOf);

	var engineUserAgent = typeof navigator != 'undefined' && String(navigator.userAgent) || '';

	var global$q = global$s;
	var userAgent$5 = engineUserAgent;

	var process$3 = global$q.process;
	var Deno$1 = global$q.Deno;
	var versions = process$3 && process$3.versions || Deno$1 && Deno$1.version;
	var v8 = versions && versions.v8;
	var match, version;

	if (v8) {
	  match = v8.split('.');
	  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
	  // but their correct versions are not interesting for us
	  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
	}

	// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
	// so check `userAgent` even if `.v8` exists, but 0
	if (!version && userAgent$5) {
	  match = userAgent$5.match(/Edge\/(\d+)/);
	  if (!match || match[1] >= 74) {
	    match = userAgent$5.match(/Chrome\/(\d+)/);
	    if (match) version = +match[1];
	  }
	}

	var engineV8Version = version;

	/* eslint-disable es/no-symbol -- required for testing */
	var V8_VERSION$3 = engineV8Version;
	var fails$w = fails$A;
	var global$p = global$s;

	var $String$5 = global$p.String;

	// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
	var symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails$w(function () {
	  var symbol = Symbol('symbol detection');
	  // Chrome 38 Symbol has incorrect toString conversion
	  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
	  // nb: Do not call `String` directly to avoid this being optimized out to `symbol+''` which will,
	  // of course, fail.
	  return !$String$5(symbol) || !(Object(symbol) instanceof Symbol) ||
	    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
	    !Symbol.sham && V8_VERSION$3 && V8_VERSION$3 < 41;
	});

	/* eslint-disable es/no-symbol -- required for testing */
	var NATIVE_SYMBOL$5 = symbolConstructorDetection;

	var useSymbolAsUid = NATIVE_SYMBOL$5
	  && !Symbol.sham
	  && typeof Symbol.iterator == 'symbol';

	var getBuiltIn$e = getBuiltIn$f;
	var isCallable$j = isCallable$m;
	var isPrototypeOf$o = objectIsPrototypeOf;
	var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;

	var $Object$4 = Object;

	var isSymbol$5 = USE_SYMBOL_AS_UID$1 ? function (it) {
	  return typeof it == 'symbol';
	} : function (it) {
	  var $Symbol = getBuiltIn$e('Symbol');
	  return isCallable$j($Symbol) && isPrototypeOf$o($Symbol.prototype, $Object$4(it));
	};

	var $String$4 = String;

	var tryToString$6 = function (argument) {
	  try {
	    return $String$4(argument);
	  } catch (error) {
	    return 'Object';
	  }
	};

	var isCallable$i = isCallable$m;
	var tryToString$5 = tryToString$6;

	var $TypeError$g = TypeError;

	// `Assert: IsCallable(argument) is true`
	var aCallable$e = function (argument) {
	  if (isCallable$i(argument)) return argument;
	  throw new $TypeError$g(tryToString$5(argument) + ' is not a function');
	};

	var aCallable$d = aCallable$e;
	var isNullOrUndefined$5 = isNullOrUndefined$7;

	// `GetMethod` abstract operation
	// https://tc39.es/ecma262/#sec-getmethod
	var getMethod$3 = function (V, P) {
	  var func = V[P];
	  return isNullOrUndefined$5(func) ? undefined : aCallable$d(func);
	};

	var call$i = functionCall;
	var isCallable$h = isCallable$m;
	var isObject$l = isObject$m;

	var $TypeError$f = TypeError;

	// `OrdinaryToPrimitive` abstract operation
	// https://tc39.es/ecma262/#sec-ordinarytoprimitive
	var ordinaryToPrimitive$1 = function (input, pref) {
	  var fn, val;
	  if (pref === 'string' && isCallable$h(fn = input.toString) && !isObject$l(val = call$i(fn, input))) return val;
	  if (isCallable$h(fn = input.valueOf) && !isObject$l(val = call$i(fn, input))) return val;
	  if (pref !== 'string' && isCallable$h(fn = input.toString) && !isObject$l(val = call$i(fn, input))) return val;
	  throw new $TypeError$f("Can't convert object to primitive value");
	};

	var shared$7 = {exports: {}};

	var isPure = true;

	var global$o = global$s;

	// eslint-disable-next-line es/no-object-defineproperty -- safe
	var defineProperty$f = Object.defineProperty;

	var defineGlobalProperty$1 = function (key, value) {
	  try {
	    defineProperty$f(global$o, key, { value: value, configurable: true, writable: true });
	  } catch (error) {
	    global$o[key] = value;
	  } return value;
	};

	var global$n = global$s;
	var defineGlobalProperty = defineGlobalProperty$1;

	var SHARED = '__core-js_shared__';
	var store$3 = global$n[SHARED] || defineGlobalProperty(SHARED, {});

	var sharedStore = store$3;

	var store$2 = sharedStore;

	(shared$7.exports = function (key, value) {
	  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
	})('versions', []).push({
	  version: '3.33.0',
	  mode: 'pure' ,
	  copyright: '© 2014-2023 Denis Pushkarev (zloirock.ru)',
	  license: 'https://github.com/zloirock/core-js/blob/v3.33.0/LICENSE',
	  source: 'https://github.com/zloirock/core-js'
	});

	var sharedExports = shared$7.exports;

	var requireObjectCoercible$3 = requireObjectCoercible$5;

	var $Object$3 = Object;

	// `ToObject` abstract operation
	// https://tc39.es/ecma262/#sec-toobject
	var toObject$f = function (argument) {
	  return $Object$3(requireObjectCoercible$3(argument));
	};

	var uncurryThis$v = functionUncurryThis;
	var toObject$e = toObject$f;

	var hasOwnProperty = uncurryThis$v({}.hasOwnProperty);

	// `HasOwnProperty` abstract operation
	// https://tc39.es/ecma262/#sec-hasownproperty
	// eslint-disable-next-line es/no-object-hasown -- safe
	var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
	  return hasOwnProperty(toObject$e(it), key);
	};

	var uncurryThis$u = functionUncurryThis;

	var id$2 = 0;
	var postfix = Math.random();
	var toString$c = uncurryThis$u(1.0.toString);

	var uid$4 = function (key) {
	  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString$c(++id$2 + postfix, 36);
	};

	var global$m = global$s;
	var shared$6 = sharedExports;
	var hasOwn$l = hasOwnProperty_1;
	var uid$3 = uid$4;
	var NATIVE_SYMBOL$4 = symbolConstructorDetection;
	var USE_SYMBOL_AS_UID = useSymbolAsUid;

	var Symbol$5 = global$m.Symbol;
	var WellKnownSymbolsStore$2 = shared$6('wks');
	var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol$5['for'] || Symbol$5 : Symbol$5 && Symbol$5.withoutSetter || uid$3;

	var wellKnownSymbol$p = function (name) {
	  if (!hasOwn$l(WellKnownSymbolsStore$2, name)) {
	    WellKnownSymbolsStore$2[name] = NATIVE_SYMBOL$4 && hasOwn$l(Symbol$5, name)
	      ? Symbol$5[name]
	      : createWellKnownSymbol('Symbol.' + name);
	  } return WellKnownSymbolsStore$2[name];
	};

	var call$h = functionCall;
	var isObject$k = isObject$m;
	var isSymbol$4 = isSymbol$5;
	var getMethod$2 = getMethod$3;
	var ordinaryToPrimitive = ordinaryToPrimitive$1;
	var wellKnownSymbol$o = wellKnownSymbol$p;

	var $TypeError$e = TypeError;
	var TO_PRIMITIVE = wellKnownSymbol$o('toPrimitive');

	// `ToPrimitive` abstract operation
	// https://tc39.es/ecma262/#sec-toprimitive
	var toPrimitive$6 = function (input, pref) {
	  if (!isObject$k(input) || isSymbol$4(input)) return input;
	  var exoticToPrim = getMethod$2(input, TO_PRIMITIVE);
	  var result;
	  if (exoticToPrim) {
	    if (pref === undefined) pref = 'default';
	    result = call$h(exoticToPrim, input, pref);
	    if (!isObject$k(result) || isSymbol$4(result)) return result;
	    throw new $TypeError$e("Can't convert object to primitive value");
	  }
	  if (pref === undefined) pref = 'number';
	  return ordinaryToPrimitive(input, pref);
	};

	var toPrimitive$5 = toPrimitive$6;
	var isSymbol$3 = isSymbol$5;

	// `ToPropertyKey` abstract operation
	// https://tc39.es/ecma262/#sec-topropertykey
	var toPropertyKey$4 = function (argument) {
	  var key = toPrimitive$5(argument, 'string');
	  return isSymbol$3(key) ? key : key + '';
	};

	var global$l = global$s;
	var isObject$j = isObject$m;

	var document$3 = global$l.document;
	// typeof document.createElement is 'object' in old IE
	var EXISTS$1 = isObject$j(document$3) && isObject$j(document$3.createElement);

	var documentCreateElement$1 = function (it) {
	  return EXISTS$1 ? document$3.createElement(it) : {};
	};

	var DESCRIPTORS$i = descriptors;
	var fails$v = fails$A;
	var createElement$1 = documentCreateElement$1;

	// Thanks to IE8 for its funny defineProperty
	var ie8DomDefine = !DESCRIPTORS$i && !fails$v(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty(createElement$1('div'), 'a', {
	    get: function () { return 7; }
	  }).a !== 7;
	});

	var DESCRIPTORS$h = descriptors;
	var call$g = functionCall;
	var propertyIsEnumerableModule$2 = objectPropertyIsEnumerable;
	var createPropertyDescriptor$6 = createPropertyDescriptor$7;
	var toIndexedObject$a = toIndexedObject$b;
	var toPropertyKey$3 = toPropertyKey$4;
	var hasOwn$k = hasOwnProperty_1;
	var IE8_DOM_DEFINE$1 = ie8DomDefine;

	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var $getOwnPropertyDescriptor$2 = Object.getOwnPropertyDescriptor;

	// `Object.getOwnPropertyDescriptor` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
	objectGetOwnPropertyDescriptor.f = DESCRIPTORS$h ? $getOwnPropertyDescriptor$2 : function getOwnPropertyDescriptor(O, P) {
	  O = toIndexedObject$a(O);
	  P = toPropertyKey$3(P);
	  if (IE8_DOM_DEFINE$1) try {
	    return $getOwnPropertyDescriptor$2(O, P);
	  } catch (error) { /* empty */ }
	  if (hasOwn$k(O, P)) return createPropertyDescriptor$6(!call$g(propertyIsEnumerableModule$2.f, O, P), O[P]);
	};

	var fails$u = fails$A;
	var isCallable$g = isCallable$m;

	var replacement = /#|\.prototype\./;

	var isForced$2 = function (feature, detection) {
	  var value = data[normalize(feature)];
	  return value === POLYFILL ? true
	    : value === NATIVE ? false
	    : isCallable$g(detection) ? fails$u(detection)
	    : !!detection;
	};

	var normalize = isForced$2.normalize = function (string) {
	  return String(string).replace(replacement, '.').toLowerCase();
	};

	var data = isForced$2.data = {};
	var NATIVE = isForced$2.NATIVE = 'N';
	var POLYFILL = isForced$2.POLYFILL = 'P';

	var isForced_1 = isForced$2;

	var uncurryThis$t = functionUncurryThisClause;
	var aCallable$c = aCallable$e;
	var NATIVE_BIND$1 = functionBindNative;

	var bind$i = uncurryThis$t(uncurryThis$t.bind);

	// optional / simple context binding
	var functionBindContext = function (fn, that) {
	  aCallable$c(fn);
	  return that === undefined ? fn : NATIVE_BIND$1 ? bind$i(fn, that) : function (/* ...args */) {
	    return fn.apply(that, arguments);
	  };
	};

	var objectDefineProperty = {};

	var DESCRIPTORS$g = descriptors;
	var fails$t = fails$A;

	// V8 ~ Chrome 36-
	// https://bugs.chromium.org/p/v8/issues/detail?id=3334
	var v8PrototypeDefineBug = DESCRIPTORS$g && fails$t(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
	    value: 42,
	    writable: false
	  }).prototype !== 42;
	});

	var isObject$i = isObject$m;

	var $String$3 = String;
	var $TypeError$d = TypeError;

	// `Assert: Type(argument) is Object`
	var anObject$f = function (argument) {
	  if (isObject$i(argument)) return argument;
	  throw new $TypeError$d($String$3(argument) + ' is not an object');
	};

	var DESCRIPTORS$f = descriptors;
	var IE8_DOM_DEFINE = ie8DomDefine;
	var V8_PROTOTYPE_DEFINE_BUG$1 = v8PrototypeDefineBug;
	var anObject$e = anObject$f;
	var toPropertyKey$2 = toPropertyKey$4;

	var $TypeError$c = TypeError;
	// eslint-disable-next-line es/no-object-defineproperty -- safe
	var $defineProperty$1 = Object.defineProperty;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;
	var ENUMERABLE = 'enumerable';
	var CONFIGURABLE$1 = 'configurable';
	var WRITABLE = 'writable';

	// `Object.defineProperty` method
	// https://tc39.es/ecma262/#sec-object.defineproperty
	objectDefineProperty.f = DESCRIPTORS$f ? V8_PROTOTYPE_DEFINE_BUG$1 ? function defineProperty(O, P, Attributes) {
	  anObject$e(O);
	  P = toPropertyKey$2(P);
	  anObject$e(Attributes);
	  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
	    var current = $getOwnPropertyDescriptor$1(O, P);
	    if (current && current[WRITABLE]) {
	      O[P] = Attributes.value;
	      Attributes = {
	        configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
	        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
	        writable: false
	      };
	    }
	  } return $defineProperty$1(O, P, Attributes);
	} : $defineProperty$1 : function defineProperty(O, P, Attributes) {
	  anObject$e(O);
	  P = toPropertyKey$2(P);
	  anObject$e(Attributes);
	  if (IE8_DOM_DEFINE) try {
	    return $defineProperty$1(O, P, Attributes);
	  } catch (error) { /* empty */ }
	  if ('get' in Attributes || 'set' in Attributes) throw new $TypeError$c('Accessors not supported');
	  if ('value' in Attributes) O[P] = Attributes.value;
	  return O;
	};

	var DESCRIPTORS$e = descriptors;
	var definePropertyModule$4 = objectDefineProperty;
	var createPropertyDescriptor$5 = createPropertyDescriptor$7;

	var createNonEnumerableProperty$9 = DESCRIPTORS$e ? function (object, key, value) {
	  return definePropertyModule$4.f(object, key, createPropertyDescriptor$5(1, value));
	} : function (object, key, value) {
	  object[key] = value;
	  return object;
	};

	var global$k = global$s;
	var apply$5 = functionApply;
	var uncurryThis$s = functionUncurryThisClause;
	var isCallable$f = isCallable$m;
	var getOwnPropertyDescriptor$9 = objectGetOwnPropertyDescriptor.f;
	var isForced$1 = isForced_1;
	var path$y = path$A;
	var bind$h = functionBindContext;
	var createNonEnumerableProperty$8 = createNonEnumerableProperty$9;
	var hasOwn$j = hasOwnProperty_1;

	var wrapConstructor = function (NativeConstructor) {
	  var Wrapper = function (a, b, c) {
	    if (this instanceof Wrapper) {
	      switch (arguments.length) {
	        case 0: return new NativeConstructor();
	        case 1: return new NativeConstructor(a);
	        case 2: return new NativeConstructor(a, b);
	      } return new NativeConstructor(a, b, c);
	    } return apply$5(NativeConstructor, this, arguments);
	  };
	  Wrapper.prototype = NativeConstructor.prototype;
	  return Wrapper;
	};

	/*
	  options.target         - name of the target object
	  options.global         - target is the global object
	  options.stat           - export as static methods of target
	  options.proto          - export as prototype methods of target
	  options.real           - real prototype method for the `pure` version
	  options.forced         - export even if the native feature is available
	  options.bind           - bind methods to the target, required for the `pure` version
	  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
	  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
	  options.sham           - add a flag to not completely full polyfills
	  options.enumerable     - export as enumerable property
	  options.dontCallGetSet - prevent calling a getter on target
	  options.name           - the .name of the function if it does not match the key
	*/
	var _export = function (options, source) {
	  var TARGET = options.target;
	  var GLOBAL = options.global;
	  var STATIC = options.stat;
	  var PROTO = options.proto;

	  var nativeSource = GLOBAL ? global$k : STATIC ? global$k[TARGET] : (global$k[TARGET] || {}).prototype;

	  var target = GLOBAL ? path$y : path$y[TARGET] || createNonEnumerableProperty$8(path$y, TARGET, {})[TARGET];
	  var targetPrototype = target.prototype;

	  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
	  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

	  for (key in source) {
	    FORCED = isForced$1(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
	    // contains in native
	    USE_NATIVE = !FORCED && nativeSource && hasOwn$j(nativeSource, key);

	    targetProperty = target[key];

	    if (USE_NATIVE) if (options.dontCallGetSet) {
	      descriptor = getOwnPropertyDescriptor$9(nativeSource, key);
	      nativeProperty = descriptor && descriptor.value;
	    } else nativeProperty = nativeSource[key];

	    // export native or implementation
	    sourceProperty = (USE_NATIVE && nativeProperty) ? nativeProperty : source[key];

	    if (USE_NATIVE && typeof targetProperty == typeof sourceProperty) continue;

	    // bind methods to global for calling from export context
	    if (options.bind && USE_NATIVE) resultProperty = bind$h(sourceProperty, global$k);
	    // wrap global constructors for prevent changes in this version
	    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty);
	    // make static versions for prototype methods
	    else if (PROTO && isCallable$f(sourceProperty)) resultProperty = uncurryThis$s(sourceProperty);
	    // default case
	    else resultProperty = sourceProperty;

	    // add a flag to not completely full polyfills
	    if (options.sham || (sourceProperty && sourceProperty.sham) || (targetProperty && targetProperty.sham)) {
	      createNonEnumerableProperty$8(resultProperty, 'sham', true);
	    }

	    createNonEnumerableProperty$8(target, key, resultProperty);

	    if (PROTO) {
	      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
	      if (!hasOwn$j(path$y, VIRTUAL_PROTOTYPE)) {
	        createNonEnumerableProperty$8(path$y, VIRTUAL_PROTOTYPE, {});
	      }
	      // export virtual prototype methods
	      createNonEnumerableProperty$8(path$y[VIRTUAL_PROTOTYPE], key, sourceProperty);
	      // export real prototype methods
	      if (options.real && targetPrototype && (FORCED || !targetPrototype[key])) {
	        createNonEnumerableProperty$8(targetPrototype, key, sourceProperty);
	      }
	    }
	  }
	};

	var ceil = Math.ceil;
	var floor$1 = Math.floor;

	// `Math.trunc` method
	// https://tc39.es/ecma262/#sec-math.trunc
	// eslint-disable-next-line es/no-math-trunc -- safe
	var mathTrunc = Math.trunc || function trunc(x) {
	  var n = +x;
	  return (n > 0 ? floor$1 : ceil)(n);
	};

	var trunc = mathTrunc;

	// `ToIntegerOrInfinity` abstract operation
	// https://tc39.es/ecma262/#sec-tointegerorinfinity
	var toIntegerOrInfinity$4 = function (argument) {
	  var number = +argument;
	  // eslint-disable-next-line no-self-compare -- NaN check
	  return number !== number || number === 0 ? 0 : trunc(number);
	};

	var toIntegerOrInfinity$3 = toIntegerOrInfinity$4;

	var max$3 = Math.max;
	var min$2 = Math.min;

	// Helper for a popular repeating case of the spec:
	// Let integer be ? ToInteger(index).
	// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
	var toAbsoluteIndex$5 = function (index, length) {
	  var integer = toIntegerOrInfinity$3(index);
	  return integer < 0 ? max$3(integer + length, 0) : min$2(integer, length);
	};

	var toIntegerOrInfinity$2 = toIntegerOrInfinity$4;

	var min$1 = Math.min;

	// `ToLength` abstract operation
	// https://tc39.es/ecma262/#sec-tolength
	var toLength$1 = function (argument) {
	  return argument > 0 ? min$1(toIntegerOrInfinity$2(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
	};

	var toLength = toLength$1;

	// `LengthOfArrayLike` abstract operation
	// https://tc39.es/ecma262/#sec-lengthofarraylike
	var lengthOfArrayLike$e = function (obj) {
	  return toLength(obj.length);
	};

	var toIndexedObject$9 = toIndexedObject$b;
	var toAbsoluteIndex$4 = toAbsoluteIndex$5;
	var lengthOfArrayLike$d = lengthOfArrayLike$e;

	// `Array.prototype.{ indexOf, includes }` methods implementation
	var createMethod$5 = function (IS_INCLUDES) {
	  return function ($this, el, fromIndex) {
	    var O = toIndexedObject$9($this);
	    var length = lengthOfArrayLike$d(O);
	    var index = toAbsoluteIndex$4(fromIndex, length);
	    var value;
	    // Array#includes uses SameValueZero equality algorithm
	    // eslint-disable-next-line no-self-compare -- NaN check
	    if (IS_INCLUDES && el !== el) while (length > index) {
	      value = O[index++];
	      // eslint-disable-next-line no-self-compare -- NaN check
	      if (value !== value) return true;
	    // Array#indexOf ignores holes, Array#includes - not
	    } else for (;length > index; index++) {
	      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
	    } return !IS_INCLUDES && -1;
	  };
	};

	var arrayIncludes = {
	  // `Array.prototype.includes` method
	  // https://tc39.es/ecma262/#sec-array.prototype.includes
	  includes: createMethod$5(true),
	  // `Array.prototype.indexOf` method
	  // https://tc39.es/ecma262/#sec-array.prototype.indexof
	  indexOf: createMethod$5(false)
	};

	var hiddenKeys$6 = {};

	var uncurryThis$r = functionUncurryThis;
	var hasOwn$i = hasOwnProperty_1;
	var toIndexedObject$8 = toIndexedObject$b;
	var indexOf$4 = arrayIncludes.indexOf;
	var hiddenKeys$5 = hiddenKeys$6;

	var push$d = uncurryThis$r([].push);

	var objectKeysInternal = function (object, names) {
	  var O = toIndexedObject$8(object);
	  var i = 0;
	  var result = [];
	  var key;
	  for (key in O) !hasOwn$i(hiddenKeys$5, key) && hasOwn$i(O, key) && push$d(result, key);
	  // Don't enum bug & hidden keys
	  while (names.length > i) if (hasOwn$i(O, key = names[i++])) {
	    ~indexOf$4(result, key) || push$d(result, key);
	  }
	  return result;
	};

	// IE8- don't enum bug keys
	var enumBugKeys$3 = [
	  'constructor',
	  'hasOwnProperty',
	  'isPrototypeOf',
	  'propertyIsEnumerable',
	  'toLocaleString',
	  'toString',
	  'valueOf'
	];

	var internalObjectKeys$1 = objectKeysInternal;
	var enumBugKeys$2 = enumBugKeys$3;

	// `Object.keys` method
	// https://tc39.es/ecma262/#sec-object.keys
	// eslint-disable-next-line es/no-object-keys -- safe
	var objectKeys$4 = Object.keys || function keys(O) {
	  return internalObjectKeys$1(O, enumBugKeys$2);
	};

	var objectGetOwnPropertySymbols = {};

	// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
	objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

	var DESCRIPTORS$d = descriptors;
	var uncurryThis$q = functionUncurryThis;
	var call$f = functionCall;
	var fails$s = fails$A;
	var objectKeys$3 = objectKeys$4;
	var getOwnPropertySymbolsModule$3 = objectGetOwnPropertySymbols;
	var propertyIsEnumerableModule$1 = objectPropertyIsEnumerable;
	var toObject$d = toObject$f;
	var IndexedObject$2 = indexedObject;

	// eslint-disable-next-line es/no-object-assign -- safe
	var $assign = Object.assign;
	// eslint-disable-next-line es/no-object-defineproperty -- required for testing
	var defineProperty$e = Object.defineProperty;
	var concat$6 = uncurryThis$q([].concat);

	// `Object.assign` method
	// https://tc39.es/ecma262/#sec-object.assign
	var objectAssign = !$assign || fails$s(function () {
	  // should have correct order of operations (Edge bug)
	  if (DESCRIPTORS$d && $assign({ b: 1 }, $assign(defineProperty$e({}, 'a', {
	    enumerable: true,
	    get: function () {
	      defineProperty$e(this, 'b', {
	        value: 3,
	        enumerable: false
	      });
	    }
	  }), { b: 2 })).b !== 1) return true;
	  // should work with symbols and should have deterministic property order (V8 bug)
	  var A = {};
	  var B = {};
	  // eslint-disable-next-line es/no-symbol -- safe
	  var symbol = Symbol('assign detection');
	  var alphabet = 'abcdefghijklmnopqrst';
	  A[symbol] = 7;
	  alphabet.split('').forEach(function (chr) { B[chr] = chr; });
	  return $assign({}, A)[symbol] !== 7 || objectKeys$3($assign({}, B)).join('') !== alphabet;
	}) ? function assign(target, source) { // eslint-disable-line no-unused-vars -- required for `.length`
	  var T = toObject$d(target);
	  var argumentsLength = arguments.length;
	  var index = 1;
	  var getOwnPropertySymbols = getOwnPropertySymbolsModule$3.f;
	  var propertyIsEnumerable = propertyIsEnumerableModule$1.f;
	  while (argumentsLength > index) {
	    var S = IndexedObject$2(arguments[index++]);
	    var keys = getOwnPropertySymbols ? concat$6(objectKeys$3(S), getOwnPropertySymbols(S)) : objectKeys$3(S);
	    var length = keys.length;
	    var j = 0;
	    var key;
	    while (length > j) {
	      key = keys[j++];
	      if (!DESCRIPTORS$d || call$f(propertyIsEnumerable, S, key)) T[key] = S[key];
	    }
	  } return T;
	} : $assign;

	var $$12 = _export;
	var assign$5 = objectAssign;

	// `Object.assign` method
	// https://tc39.es/ecma262/#sec-object.assign
	// eslint-disable-next-line es/no-object-assign -- required for testing
	$$12({ target: 'Object', stat: true, arity: 2, forced: Object.assign !== assign$5 }, {
	  assign: assign$5
	});

	var path$x = path$A;

	var assign$4 = path$x.Object.assign;

	var parent$1r = assign$4;

	var assign$3 = parent$1r;

	var assign$2 = assign$3;

	var _Object$assign = /*@__PURE__*/getDefaultExportFromCjs(assign$2);

	var uncurryThis$p = functionUncurryThis;

	var arraySlice$6 = uncurryThis$p([].slice);

	var uncurryThis$o = functionUncurryThis;
	var aCallable$b = aCallable$e;
	var isObject$h = isObject$m;
	var hasOwn$h = hasOwnProperty_1;
	var arraySlice$5 = arraySlice$6;
	var NATIVE_BIND = functionBindNative;

	var $Function = Function;
	var concat$5 = uncurryThis$o([].concat);
	var join = uncurryThis$o([].join);
	var factories = {};

	var construct$4 = function (C, argsLength, args) {
	  if (!hasOwn$h(factories, argsLength)) {
	    var list = [];
	    var i = 0;
	    for (; i < argsLength; i++) list[i] = 'a[' + i + ']';
	    factories[argsLength] = $Function('C,a', 'return new C(' + join(list, ',') + ')');
	  } return factories[argsLength](C, args);
	};

	// `Function.prototype.bind` method implementation
	// https://tc39.es/ecma262/#sec-function.prototype.bind
	// eslint-disable-next-line es/no-function-prototype-bind -- detection
	var functionBind = NATIVE_BIND ? $Function.bind : function bind(that /* , ...args */) {
	  var F = aCallable$b(this);
	  var Prototype = F.prototype;
	  var partArgs = arraySlice$5(arguments, 1);
	  var boundFunction = function bound(/* args... */) {
	    var args = concat$5(partArgs, arraySlice$5(arguments));
	    return this instanceof boundFunction ? construct$4(F, args.length, args) : F.apply(that, args);
	  };
	  if (isObject$h(Prototype)) boundFunction.prototype = Prototype;
	  return boundFunction;
	};

	// TODO: Remove from `core-js@4`
	var $$11 = _export;
	var bind$g = functionBind;

	// `Function.prototype.bind` method
	// https://tc39.es/ecma262/#sec-function.prototype.bind
	// eslint-disable-next-line es/no-function-prototype-bind -- detection
	$$11({ target: 'Function', proto: true, forced: Function.bind !== bind$g }, {
	  bind: bind$g
	});

	var path$w = path$A;

	var entryVirtual$l = function (CONSTRUCTOR) {
	  return path$w[CONSTRUCTOR + 'Prototype'];
	};

	var entryVirtual$k = entryVirtual$l;

	var bind$f = entryVirtual$k('Function').bind;

	var isPrototypeOf$n = objectIsPrototypeOf;
	var method$i = bind$f;

	var FunctionPrototype$2 = Function.prototype;

	var bind$e = function (it) {
	  var own = it.bind;
	  return it === FunctionPrototype$2 || (isPrototypeOf$n(FunctionPrototype$2, it) && own === FunctionPrototype$2.bind) ? method$i : own;
	};

	var parent$1q = bind$e;

	var bind$d = parent$1q;

	var bind$c = bind$d;

	var _bindInstanceProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(bind$c);

	/**
	 * Draw a circle.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - The radius of the circle.
	 */
	function drawCircle(ctx, x, y, r) {
	  ctx.beginPath();
	  ctx.arc(x, y, r, 0, 2 * Math.PI, false);
	  ctx.closePath();
	}
	/**
	 * Draw a square.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - Half of the width and height of the square.
	 */
	function drawSquare(ctx, x, y, r) {
	  ctx.beginPath();
	  ctx.rect(x - r, y - r, r * 2, r * 2);
	  ctx.closePath();
	}
	/**
	 * Draw an equilateral triangle standing on a side.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - Half of the length of the sides.
	 * @remarks
	 * http://en.wikipedia.org/wiki/Equilateral_triangle
	 */
	function drawTriangle(ctx, x, y, r) {
	  ctx.beginPath();
	  // the change in radius and the offset is here to center the shape
	  r *= 1.15;
	  y += 0.275 * r;
	  var s = r * 2;
	  var s2 = s / 2;
	  var ir = Math.sqrt(3) / 6 * s; // radius of inner circle
	  var h = Math.sqrt(s * s - s2 * s2); // height
	  ctx.moveTo(x, y - (h - ir));
	  ctx.lineTo(x + s2, y + ir);
	  ctx.lineTo(x - s2, y + ir);
	  ctx.lineTo(x, y - (h - ir));
	  ctx.closePath();
	}
	/**
	 * Draw an equilateral triangle standing on a vertex.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - Half of the length of the sides.
	 * @remarks
	 * http://en.wikipedia.org/wiki/Equilateral_triangle
	 */
	function drawTriangleDown(ctx, x, y, r) {
	  ctx.beginPath();
	  // the change in radius and the offset is here to center the shape
	  r *= 1.15;
	  y -= 0.275 * r;
	  var s = r * 2;
	  var s2 = s / 2;
	  var ir = Math.sqrt(3) / 6 * s; // radius of inner circle
	  var h = Math.sqrt(s * s - s2 * s2); // height
	  ctx.moveTo(x, y + (h - ir));
	  ctx.lineTo(x + s2, y - ir);
	  ctx.lineTo(x - s2, y - ir);
	  ctx.lineTo(x, y + (h - ir));
	  ctx.closePath();
	}
	/**
	 * Draw a star.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - The outer radius of the star.
	 */
	function drawStar(ctx, x, y, r) {
	  // http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
	  ctx.beginPath();
	  // the change in radius and the offset is here to center the shape
	  r *= 0.82;
	  y += 0.1 * r;
	  for (var n = 0; n < 10; n++) {
	    var radius = n % 2 === 0 ? r * 1.3 : r * 0.5;
	    ctx.lineTo(x + radius * Math.sin(n * 2 * Math.PI / 10), y - radius * Math.cos(n * 2 * Math.PI / 10));
	  }
	  ctx.closePath();
	}
	/**
	 * Draw a diamond.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - Half of the width and height of the diamond.
	 * @remarks
	 * http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
	 */
	function drawDiamond(ctx, x, y, r) {
	  ctx.beginPath();
	  ctx.lineTo(x, y + r);
	  ctx.lineTo(x + r, y);
	  ctx.lineTo(x, y - r);
	  ctx.lineTo(x - r, y);
	  ctx.closePath();
	}
	/**
	 * Draw a rectangle with rounded corners.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param w - The width of the rectangle.
	 * @param h - The height of the rectangle.
	 * @param r - The radius of the corners.
	 * @remarks
	 * http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
	 */
	function drawRoundRect(ctx, x, y, w, h, r) {
	  var r2d = Math.PI / 180;
	  if (w - 2 * r < 0) {
	    r = w / 2;
	  } //ensure that the radius isn't too large for x
	  if (h - 2 * r < 0) {
	    r = h / 2;
	  } //ensure that the radius isn't too large for y
	  ctx.beginPath();
	  ctx.moveTo(x + r, y);
	  ctx.lineTo(x + w - r, y);
	  ctx.arc(x + w - r, y + r, r, r2d * 270, r2d * 360, false);
	  ctx.lineTo(x + w, y + h - r);
	  ctx.arc(x + w - r, y + h - r, r, 0, r2d * 90, false);
	  ctx.lineTo(x + r, y + h);
	  ctx.arc(x + r, y + h - r, r, r2d * 90, r2d * 180, false);
	  ctx.lineTo(x, y + r);
	  ctx.arc(x + r, y + r, r, r2d * 180, r2d * 270, false);
	  ctx.closePath();
	}
	/**
	 * Draw an ellipse.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param w - The width of the ellipse.
	 * @param h - The height of the ellipse.
	 * @remarks
	 * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
	 *
	 * Postfix '_vis' added to discern it from standard method ellipse().
	 */
	function drawEllipse(ctx, x, y, w, h) {
	  var kappa = 0.5522848,
	    ox = w / 2 * kappa,
	    // control point offset horizontal
	    oy = h / 2 * kappa,
	    // control point offset vertical
	    xe = x + w,
	    // x-end
	    ye = y + h,
	    // y-end
	    xm = x + w / 2,
	    // x-middle
	    ym = y + h / 2; // y-middle
	  ctx.beginPath();
	  ctx.moveTo(x, ym);
	  ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
	  ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
	  ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
	  ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
	  ctx.closePath();
	}
	/**
	 * Draw an isometric cylinder.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param w - The width of the database.
	 * @param h - The height of the database.
	 * @remarks
	 * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
	 */
	function drawDatabase(ctx, x, y, w, h) {
	  var f = 1 / 3;
	  var wEllipse = w;
	  var hEllipse = h * f;
	  var kappa = 0.5522848,
	    ox = wEllipse / 2 * kappa,
	    // control point offset horizontal
	    oy = hEllipse / 2 * kappa,
	    // control point offset vertical
	    xe = x + wEllipse,
	    // x-end
	    ye = y + hEllipse,
	    // y-end
	    xm = x + wEllipse / 2,
	    // x-middle
	    ym = y + hEllipse / 2,
	    // y-middle
	    ymb = y + (h - hEllipse / 2),
	    // y-midlle, bottom ellipse
	    yeb = y + h; // y-end, bottom ellipse
	  ctx.beginPath();
	  ctx.moveTo(xe, ym);
	  ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
	  ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
	  ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
	  ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
	  ctx.lineTo(xe, ymb);
	  ctx.bezierCurveTo(xe, ymb + oy, xm + ox, yeb, xm, yeb);
	  ctx.bezierCurveTo(xm - ox, yeb, x, ymb + oy, x, ymb);
	  ctx.lineTo(x, ym);
	}
	/**
	 * Draw a dashed line.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The start position on the x axis.
	 * @param y - The start position on the y axis.
	 * @param x2 - The end position on the x axis.
	 * @param y2 - The end position on the y axis.
	 * @param pattern - List of lengths starting with line and then alternating between space and line.
	 * @author David Jordan
	 * @remarks
	 * date 2012-08-08
	 * http://stackoverflow.com/questions/4576724/dotted-stroke-in-canvas
	 */
	function drawDashedLine(ctx, x, y, x2, y2, pattern) {
	  ctx.beginPath();
	  ctx.moveTo(x, y);
	  var patternLength = pattern.length;
	  var dx = x2 - x;
	  var dy = y2 - y;
	  var slope = dy / dx;
	  var distRemaining = Math.sqrt(dx * dx + dy * dy);
	  var patternIndex = 0;
	  var draw = true;
	  var xStep = 0;
	  var dashLength = +pattern[0];
	  while (distRemaining >= 0.1) {
	    dashLength = +pattern[patternIndex++ % patternLength];
	    if (dashLength > distRemaining) {
	      dashLength = distRemaining;
	    }
	    xStep = Math.sqrt(dashLength * dashLength / (1 + slope * slope));
	    xStep = dx < 0 ? -xStep : xStep;
	    x += xStep;
	    y += slope * xStep;
	    if (draw === true) {
	      ctx.lineTo(x, y);
	    } else {
	      ctx.moveTo(x, y);
	    }
	    distRemaining -= dashLength;
	    draw = !draw;
	  }
	}
	/**
	 * Draw a hexagon.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - The radius of the hexagon.
	 */
	function drawHexagon(ctx, x, y, r) {
	  ctx.beginPath();
	  var sides = 6;
	  var a = Math.PI * 2 / sides;
	  ctx.moveTo(x + r, y);
	  for (var i = 1; i < sides; i++) {
	    ctx.lineTo(x + r * Math.cos(a * i), y + r * Math.sin(a * i));
	  }
	  ctx.closePath();
	}
	var shapeMap = {
	  circle: drawCircle,
	  dashedLine: drawDashedLine,
	  database: drawDatabase,
	  diamond: drawDiamond,
	  ellipse: drawEllipse,
	  ellipse_vis: drawEllipse,
	  hexagon: drawHexagon,
	  roundRect: drawRoundRect,
	  square: drawSquare,
	  star: drawStar,
	  triangle: drawTriangle,
	  triangleDown: drawTriangleDown
	};
	/**
	 * Returns either custom or native drawing function base on supplied name.
	 *
	 * @param name - The name of the function. Either the name of a
	 * CanvasRenderingContext2D property or an export from shapes.ts without the
	 * draw prefix.
	 * @returns The function that can be used for rendering. In case of native
	 * CanvasRenderingContext2D function the API is normalized to
	 * `(ctx: CanvasRenderingContext2D, ...originalArgs) => void`.
	 */
	function getShape(name) {
	  if (Object.prototype.hasOwnProperty.call(shapeMap, name)) {
	    return shapeMap[name];
	  } else {
	    return function (ctx) {
	      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	        args[_key - 1] = arguments[_key];
	      }
	      CanvasRenderingContext2D.prototype[name].call(ctx, args);
	    };
	  }
	}

	var componentEmitter = {exports: {}};

	(function (module) {
		/**
		 * Expose `Emitter`.
		 */

		{
		  module.exports = Emitter;
		}

		/**
		 * Initialize a new `Emitter`.
		 *
		 * @api public
		 */

		function Emitter(obj) {
		  if (obj) return mixin(obj);
		}
		/**
		 * Mixin the emitter properties.
		 *
		 * @param {Object} obj
		 * @return {Object}
		 * @api private
		 */

		function mixin(obj) {
		  for (var key in Emitter.prototype) {
		    obj[key] = Emitter.prototype[key];
		  }
		  return obj;
		}

		/**
		 * Listen on the given `event` with `fn`.
		 *
		 * @param {String} event
		 * @param {Function} fn
		 * @return {Emitter}
		 * @api public
		 */

		Emitter.prototype.on =
		Emitter.prototype.addEventListener = function(event, fn){
		  this._callbacks = this._callbacks || {};
		  (this._callbacks['$' + event] = this._callbacks['$' + event] || [])
		    .push(fn);
		  return this;
		};

		/**
		 * Adds an `event` listener that will be invoked a single
		 * time then automatically removed.
		 *
		 * @param {String} event
		 * @param {Function} fn
		 * @return {Emitter}
		 * @api public
		 */

		Emitter.prototype.once = function(event, fn){
		  function on() {
		    this.off(event, on);
		    fn.apply(this, arguments);
		  }

		  on.fn = fn;
		  this.on(event, on);
		  return this;
		};

		/**
		 * Remove the given callback for `event` or all
		 * registered callbacks.
		 *
		 * @param {String} event
		 * @param {Function} fn
		 * @return {Emitter}
		 * @api public
		 */

		Emitter.prototype.off =
		Emitter.prototype.removeListener =
		Emitter.prototype.removeAllListeners =
		Emitter.prototype.removeEventListener = function(event, fn){
		  this._callbacks = this._callbacks || {};

		  // all
		  if (0 == arguments.length) {
		    this._callbacks = {};
		    return this;
		  }

		  // specific event
		  var callbacks = this._callbacks['$' + event];
		  if (!callbacks) return this;

		  // remove all handlers
		  if (1 == arguments.length) {
		    delete this._callbacks['$' + event];
		    return this;
		  }

		  // remove specific handler
		  var cb;
		  for (var i = 0; i < callbacks.length; i++) {
		    cb = callbacks[i];
		    if (cb === fn || cb.fn === fn) {
		      callbacks.splice(i, 1);
		      break;
		    }
		  }

		  // Remove event specific arrays for event types that no
		  // one is subscribed for to avoid memory leak.
		  if (callbacks.length === 0) {
		    delete this._callbacks['$' + event];
		  }

		  return this;
		};

		/**
		 * Emit `event` with the given args.
		 *
		 * @param {String} event
		 * @param {Mixed} ...
		 * @return {Emitter}
		 */

		Emitter.prototype.emit = function(event){
		  this._callbacks = this._callbacks || {};

		  var args = new Array(arguments.length - 1)
		    , callbacks = this._callbacks['$' + event];

		  for (var i = 1; i < arguments.length; i++) {
		    args[i - 1] = arguments[i];
		  }

		  if (callbacks) {
		    callbacks = callbacks.slice(0);
		    for (var i = 0, len = callbacks.length; i < len; ++i) {
		      callbacks[i].apply(this, args);
		    }
		  }

		  return this;
		};

		/**
		 * Return array of callbacks for `event`.
		 *
		 * @param {String} event
		 * @return {Array}
		 * @api public
		 */

		Emitter.prototype.listeners = function(event){
		  this._callbacks = this._callbacks || {};
		  return this._callbacks['$' + event] || [];
		};

		/**
		 * Check if this emitter has `event` handlers.
		 *
		 * @param {String} event
		 * @return {Boolean}
		 * @api public
		 */

		Emitter.prototype.hasListeners = function(event){
		  return !! this.listeners(event).length;
		}; 
	} (componentEmitter));

	var componentEmitterExports = componentEmitter.exports;
	var Emitter = /*@__PURE__*/getDefaultExportFromCjs(componentEmitterExports);

	var wellKnownSymbol$n = wellKnownSymbol$p;

	var TO_STRING_TAG$4 = wellKnownSymbol$n('toStringTag');
	var test$2 = {};

	test$2[TO_STRING_TAG$4] = 'z';

	var toStringTagSupport = String(test$2) === '[object z]';

	var TO_STRING_TAG_SUPPORT$2 = toStringTagSupport;
	var isCallable$e = isCallable$m;
	var classofRaw = classofRaw$2;
	var wellKnownSymbol$m = wellKnownSymbol$p;

	var TO_STRING_TAG$3 = wellKnownSymbol$m('toStringTag');
	var $Object$2 = Object;

	// ES3 wrong here
	var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) === 'Arguments';

	// fallback for IE11 Script Access Denied error
	var tryGet = function (it, key) {
	  try {
	    return it[key];
	  } catch (error) { /* empty */ }
	};

	// getting tag from ES6+ `Object.prototype.toString`
	var classof$f = TO_STRING_TAG_SUPPORT$2 ? classofRaw : function (it) {
	  var O, tag, result;
	  return it === undefined ? 'Undefined' : it === null ? 'Null'
	    // @@toStringTag case
	    : typeof (tag = tryGet(O = $Object$2(it), TO_STRING_TAG$3)) == 'string' ? tag
	    // builtinTag case
	    : CORRECT_ARGUMENTS ? classofRaw(O)
	    // ES3 arguments fallback
	    : (result = classofRaw(O)) === 'Object' && isCallable$e(O.callee) ? 'Arguments' : result;
	};

	var classof$e = classof$f;

	var $String$2 = String;

	var toString$b = function (argument) {
	  if (classof$e(argument) === 'Symbol') throw new TypeError('Cannot convert a Symbol value to a string');
	  return $String$2(argument);
	};

	var uncurryThis$n = functionUncurryThis;
	var toIntegerOrInfinity$1 = toIntegerOrInfinity$4;
	var toString$a = toString$b;
	var requireObjectCoercible$2 = requireObjectCoercible$5;

	var charAt$3 = uncurryThis$n(''.charAt);
	var charCodeAt$1 = uncurryThis$n(''.charCodeAt);
	var stringSlice = uncurryThis$n(''.slice);

	var createMethod$4 = function (CONVERT_TO_STRING) {
	  return function ($this, pos) {
	    var S = toString$a(requireObjectCoercible$2($this));
	    var position = toIntegerOrInfinity$1(pos);
	    var size = S.length;
	    var first, second;
	    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
	    first = charCodeAt$1(S, position);
	    return first < 0xD800 || first > 0xDBFF || position + 1 === size
	      || (second = charCodeAt$1(S, position + 1)) < 0xDC00 || second > 0xDFFF
	        ? CONVERT_TO_STRING
	          ? charAt$3(S, position)
	          : first
	        : CONVERT_TO_STRING
	          ? stringSlice(S, position, position + 2)
	          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
	  };
	};

	var stringMultibyte = {
	  // `String.prototype.codePointAt` method
	  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
	  codeAt: createMethod$4(false),
	  // `String.prototype.at` method
	  // https://github.com/mathiasbynens/String.prototype.at
	  charAt: createMethod$4(true)
	};

	var global$j = global$s;
	var isCallable$d = isCallable$m;

	var WeakMap$1 = global$j.WeakMap;

	var weakMapBasicDetection = isCallable$d(WeakMap$1) && /native code/.test(String(WeakMap$1));

	var shared$5 = sharedExports;
	var uid$2 = uid$4;

	var keys$7 = shared$5('keys');

	var sharedKey$4 = function (key) {
	  return keys$7[key] || (keys$7[key] = uid$2(key));
	};

	var NATIVE_WEAK_MAP$1 = weakMapBasicDetection;
	var global$i = global$s;
	var isObject$g = isObject$m;
	var createNonEnumerableProperty$7 = createNonEnumerableProperty$9;
	var hasOwn$g = hasOwnProperty_1;
	var shared$4 = sharedStore;
	var sharedKey$3 = sharedKey$4;
	var hiddenKeys$4 = hiddenKeys$6;

	var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
	var TypeError$3 = global$i.TypeError;
	var WeakMap = global$i.WeakMap;
	var set$4, get$6, has;

	var enforce = function (it) {
	  return has(it) ? get$6(it) : set$4(it, {});
	};

	var getterFor = function (TYPE) {
	  return function (it) {
	    var state;
	    if (!isObject$g(it) || (state = get$6(it)).type !== TYPE) {
	      throw new TypeError$3('Incompatible receiver, ' + TYPE + ' required');
	    } return state;
	  };
	};

	if (NATIVE_WEAK_MAP$1 || shared$4.state) {
	  var store$1 = shared$4.state || (shared$4.state = new WeakMap());
	  /* eslint-disable no-self-assign -- prototype methods protection */
	  store$1.get = store$1.get;
	  store$1.has = store$1.has;
	  store$1.set = store$1.set;
	  /* eslint-enable no-self-assign -- prototype methods protection */
	  set$4 = function (it, metadata) {
	    if (store$1.has(it)) throw new TypeError$3(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    store$1.set(it, metadata);
	    return metadata;
	  };
	  get$6 = function (it) {
	    return store$1.get(it) || {};
	  };
	  has = function (it) {
	    return store$1.has(it);
	  };
	} else {
	  var STATE = sharedKey$3('state');
	  hiddenKeys$4[STATE] = true;
	  set$4 = function (it, metadata) {
	    if (hasOwn$g(it, STATE)) throw new TypeError$3(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    createNonEnumerableProperty$7(it, STATE, metadata);
	    return metadata;
	  };
	  get$6 = function (it) {
	    return hasOwn$g(it, STATE) ? it[STATE] : {};
	  };
	  has = function (it) {
	    return hasOwn$g(it, STATE);
	  };
	}

	var internalState = {
	  set: set$4,
	  get: get$6,
	  has: has,
	  enforce: enforce,
	  getterFor: getterFor
	};

	var DESCRIPTORS$c = descriptors;
	var hasOwn$f = hasOwnProperty_1;

	var FunctionPrototype$1 = Function.prototype;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getDescriptor = DESCRIPTORS$c && Object.getOwnPropertyDescriptor;

	var EXISTS = hasOwn$f(FunctionPrototype$1, 'name');
	// additional protection from minified / mangled / dropped function names
	var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
	var CONFIGURABLE = EXISTS && (!DESCRIPTORS$c || (DESCRIPTORS$c && getDescriptor(FunctionPrototype$1, 'name').configurable));

	var functionName = {
	  EXISTS: EXISTS,
	  PROPER: PROPER,
	  CONFIGURABLE: CONFIGURABLE
	};

	var objectDefineProperties = {};

	var DESCRIPTORS$b = descriptors;
	var V8_PROTOTYPE_DEFINE_BUG = v8PrototypeDefineBug;
	var definePropertyModule$3 = objectDefineProperty;
	var anObject$d = anObject$f;
	var toIndexedObject$7 = toIndexedObject$b;
	var objectKeys$2 = objectKeys$4;

	// `Object.defineProperties` method
	// https://tc39.es/ecma262/#sec-object.defineproperties
	// eslint-disable-next-line es/no-object-defineproperties -- safe
	objectDefineProperties.f = DESCRIPTORS$b && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
	  anObject$d(O);
	  var props = toIndexedObject$7(Properties);
	  var keys = objectKeys$2(Properties);
	  var length = keys.length;
	  var index = 0;
	  var key;
	  while (length > index) definePropertyModule$3.f(O, key = keys[index++], props[key]);
	  return O;
	};

	var getBuiltIn$d = getBuiltIn$f;

	var html$2 = getBuiltIn$d('document', 'documentElement');

	/* global ActiveXObject -- old IE, WSH */
	var anObject$c = anObject$f;
	var definePropertiesModule$1 = objectDefineProperties;
	var enumBugKeys$1 = enumBugKeys$3;
	var hiddenKeys$3 = hiddenKeys$6;
	var html$1 = html$2;
	var documentCreateElement = documentCreateElement$1;
	var sharedKey$2 = sharedKey$4;

	var GT = '>';
	var LT = '<';
	var PROTOTYPE$1 = 'prototype';
	var SCRIPT = 'script';
	var IE_PROTO$1 = sharedKey$2('IE_PROTO');

	var EmptyConstructor = function () { /* empty */ };

	var scriptTag = function (content) {
	  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
	};

	// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
	var NullProtoObjectViaActiveX = function (activeXDocument) {
	  activeXDocument.write(scriptTag(''));
	  activeXDocument.close();
	  var temp = activeXDocument.parentWindow.Object;
	  activeXDocument = null; // avoid memory leak
	  return temp;
	};

	// Create object with fake `null` prototype: use iframe Object with cleared prototype
	var NullProtoObjectViaIFrame = function () {
	  // Thrash, waste and sodomy: IE GC bug
	  var iframe = documentCreateElement('iframe');
	  var JS = 'java' + SCRIPT + ':';
	  var iframeDocument;
	  iframe.style.display = 'none';
	  html$1.appendChild(iframe);
	  // https://github.com/zloirock/core-js/issues/475
	  iframe.src = String(JS);
	  iframeDocument = iframe.contentWindow.document;
	  iframeDocument.open();
	  iframeDocument.write(scriptTag('document.F=Object'));
	  iframeDocument.close();
	  return iframeDocument.F;
	};

	// Check for document.domain and active x support
	// No need to use active x approach when document.domain is not set
	// see https://github.com/es-shims/es5-shim/issues/150
	// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
	// avoid IE GC bug
	var activeXDocument;
	var NullProtoObject = function () {
	  try {
	    activeXDocument = new ActiveXObject('htmlfile');
	  } catch (error) { /* ignore */ }
	  NullProtoObject = typeof document != 'undefined'
	    ? document.domain && activeXDocument
	      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
	      : NullProtoObjectViaIFrame()
	    : NullProtoObjectViaActiveX(activeXDocument); // WSH
	  var length = enumBugKeys$1.length;
	  while (length--) delete NullProtoObject[PROTOTYPE$1][enumBugKeys$1[length]];
	  return NullProtoObject();
	};

	hiddenKeys$3[IE_PROTO$1] = true;

	// `Object.create` method
	// https://tc39.es/ecma262/#sec-object.create
	// eslint-disable-next-line es/no-object-create -- safe
	var objectCreate = Object.create || function create(O, Properties) {
	  var result;
	  if (O !== null) {
	    EmptyConstructor[PROTOTYPE$1] = anObject$c(O);
	    result = new EmptyConstructor();
	    EmptyConstructor[PROTOTYPE$1] = null;
	    // add "__proto__" for Object.getPrototypeOf polyfill
	    result[IE_PROTO$1] = O;
	  } else result = NullProtoObject();
	  return Properties === undefined ? result : definePropertiesModule$1.f(result, Properties);
	};

	var fails$r = fails$A;

	var correctPrototypeGetter = !fails$r(function () {
	  function F() { /* empty */ }
	  F.prototype.constructor = null;
	  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
	  return Object.getPrototypeOf(new F()) !== F.prototype;
	});

	var hasOwn$e = hasOwnProperty_1;
	var isCallable$c = isCallable$m;
	var toObject$c = toObject$f;
	var sharedKey$1 = sharedKey$4;
	var CORRECT_PROTOTYPE_GETTER$1 = correctPrototypeGetter;

	var IE_PROTO = sharedKey$1('IE_PROTO');
	var $Object$1 = Object;
	var ObjectPrototype$2 = $Object$1.prototype;

	// `Object.getPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.getprototypeof
	// eslint-disable-next-line es/no-object-getprototypeof -- safe
	var objectGetPrototypeOf$1 = CORRECT_PROTOTYPE_GETTER$1 ? $Object$1.getPrototypeOf : function (O) {
	  var object = toObject$c(O);
	  if (hasOwn$e(object, IE_PROTO)) return object[IE_PROTO];
	  var constructor = object.constructor;
	  if (isCallable$c(constructor) && object instanceof constructor) {
	    return constructor.prototype;
	  } return object instanceof $Object$1 ? ObjectPrototype$2 : null;
	};

	var createNonEnumerableProperty$6 = createNonEnumerableProperty$9;

	var defineBuiltIn$6 = function (target, key, value, options) {
	  if (options && options.enumerable) target[key] = value;
	  else createNonEnumerableProperty$6(target, key, value);
	  return target;
	};

	var fails$q = fails$A;
	var isCallable$b = isCallable$m;
	var isObject$f = isObject$m;
	var create$b = objectCreate;
	var getPrototypeOf$9 = objectGetPrototypeOf$1;
	var defineBuiltIn$5 = defineBuiltIn$6;
	var wellKnownSymbol$l = wellKnownSymbol$p;

	var ITERATOR$6 = wellKnownSymbol$l('iterator');
	var BUGGY_SAFARI_ITERATORS$1 = false;

	// `%IteratorPrototype%` object
	// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
	var IteratorPrototype$1, PrototypeOfArrayIteratorPrototype, arrayIterator;

	/* eslint-disable es/no-array-prototype-keys -- safe */
	if ([].keys) {
	  arrayIterator = [].keys();
	  // Safari 8 has buggy iterators w/o `next`
	  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;
	  else {
	    PrototypeOfArrayIteratorPrototype = getPrototypeOf$9(getPrototypeOf$9(arrayIterator));
	    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$1 = PrototypeOfArrayIteratorPrototype;
	  }
	}

	var NEW_ITERATOR_PROTOTYPE = !isObject$f(IteratorPrototype$1) || fails$q(function () {
	  var test = {};
	  // FF44- legacy iterators case
	  return IteratorPrototype$1[ITERATOR$6].call(test) !== test;
	});

	if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$1 = {};
	else IteratorPrototype$1 = create$b(IteratorPrototype$1);

	// `%IteratorPrototype%[@@iterator]()` method
	// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
	if (!isCallable$b(IteratorPrototype$1[ITERATOR$6])) {
	  defineBuiltIn$5(IteratorPrototype$1, ITERATOR$6, function () {
	    return this;
	  });
	}

	var iteratorsCore = {
	  IteratorPrototype: IteratorPrototype$1,
	  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
	};

	var TO_STRING_TAG_SUPPORT$1 = toStringTagSupport;
	var classof$d = classof$f;

	// `Object.prototype.toString` method implementation
	// https://tc39.es/ecma262/#sec-object.prototype.tostring
	var objectToString = TO_STRING_TAG_SUPPORT$1 ? {}.toString : function toString() {
	  return '[object ' + classof$d(this) + ']';
	};

	var TO_STRING_TAG_SUPPORT = toStringTagSupport;
	var defineProperty$d = objectDefineProperty.f;
	var createNonEnumerableProperty$5 = createNonEnumerableProperty$9;
	var hasOwn$d = hasOwnProperty_1;
	var toString$9 = objectToString;
	var wellKnownSymbol$k = wellKnownSymbol$p;

	var TO_STRING_TAG$2 = wellKnownSymbol$k('toStringTag');

	var setToStringTag$7 = function (it, TAG, STATIC, SET_METHOD) {
	  if (it) {
	    var target = STATIC ? it : it.prototype;
	    if (!hasOwn$d(target, TO_STRING_TAG$2)) {
	      defineProperty$d(target, TO_STRING_TAG$2, { configurable: true, value: TAG });
	    }
	    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
	      createNonEnumerableProperty$5(target, 'toString', toString$9);
	    }
	  }
	};

	var iterators = {};

	var IteratorPrototype = iteratorsCore.IteratorPrototype;
	var create$a = objectCreate;
	var createPropertyDescriptor$4 = createPropertyDescriptor$7;
	var setToStringTag$6 = setToStringTag$7;
	var Iterators$5 = iterators;

	var returnThis$1 = function () { return this; };

	var iteratorCreateConstructor = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
	  var TO_STRING_TAG = NAME + ' Iterator';
	  IteratorConstructor.prototype = create$a(IteratorPrototype, { next: createPropertyDescriptor$4(+!ENUMERABLE_NEXT, next) });
	  setToStringTag$6(IteratorConstructor, TO_STRING_TAG, false, true);
	  Iterators$5[TO_STRING_TAG] = returnThis$1;
	  return IteratorConstructor;
	};

	var uncurryThis$m = functionUncurryThis;
	var aCallable$a = aCallable$e;

	var functionUncurryThisAccessor = function (object, key, method) {
	  try {
	    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	    return uncurryThis$m(aCallable$a(Object.getOwnPropertyDescriptor(object, key)[method]));
	  } catch (error) { /* empty */ }
	};

	var isCallable$a = isCallable$m;

	var $String$1 = String;
	var $TypeError$b = TypeError;

	var aPossiblePrototype$1 = function (argument) {
	  if (typeof argument == 'object' || isCallable$a(argument)) return argument;
	  throw new $TypeError$b("Can't set " + $String$1(argument) + ' as a prototype');
	};

	/* eslint-disable no-proto -- safe */
	var uncurryThisAccessor = functionUncurryThisAccessor;
	var anObject$b = anObject$f;
	var aPossiblePrototype = aPossiblePrototype$1;

	// `Object.setPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.setprototypeof
	// Works with __proto__ only. Old v8 can't work with null proto objects.
	// eslint-disable-next-line es/no-object-setprototypeof -- safe
	var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
	  var CORRECT_SETTER = false;
	  var test = {};
	  var setter;
	  try {
	    setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
	    setter(test, []);
	    CORRECT_SETTER = test instanceof Array;
	  } catch (error) { /* empty */ }
	  return function setPrototypeOf(O, proto) {
	    anObject$b(O);
	    aPossiblePrototype(proto);
	    if (CORRECT_SETTER) setter(O, proto);
	    else O.__proto__ = proto;
	    return O;
	  };
	}() : undefined);

	var $$10 = _export;
	var call$e = functionCall;
	var FunctionName = functionName;
	var createIteratorConstructor = iteratorCreateConstructor;
	var getPrototypeOf$8 = objectGetPrototypeOf$1;
	var setToStringTag$5 = setToStringTag$7;
	var defineBuiltIn$4 = defineBuiltIn$6;
	var wellKnownSymbol$j = wellKnownSymbol$p;
	var Iterators$4 = iterators;
	var IteratorsCore = iteratorsCore;

	var PROPER_FUNCTION_NAME = FunctionName.PROPER;
	FunctionName.CONFIGURABLE;
	IteratorsCore.IteratorPrototype;
	var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
	var ITERATOR$5 = wellKnownSymbol$j('iterator');
	var KEYS = 'keys';
	var VALUES = 'values';
	var ENTRIES = 'entries';

	var returnThis = function () { return this; };

	var iteratorDefine = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
	  createIteratorConstructor(IteratorConstructor, NAME, next);

	  var getIterationMethod = function (KIND) {
	    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
	    if (!BUGGY_SAFARI_ITERATORS && KIND && KIND in IterablePrototype) return IterablePrototype[KIND];

	    switch (KIND) {
	      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
	      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
	      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
	    }

	    return function () { return new IteratorConstructor(this); };
	  };

	  var TO_STRING_TAG = NAME + ' Iterator';
	  var INCORRECT_VALUES_NAME = false;
	  var IterablePrototype = Iterable.prototype;
	  var nativeIterator = IterablePrototype[ITERATOR$5]
	    || IterablePrototype['@@iterator']
	    || DEFAULT && IterablePrototype[DEFAULT];
	  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
	  var anyNativeIterator = NAME === 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
	  var CurrentIteratorPrototype, methods, KEY;

	  // fix native
	  if (anyNativeIterator) {
	    CurrentIteratorPrototype = getPrototypeOf$8(anyNativeIterator.call(new Iterable()));
	    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
	      // Set @@toStringTag to native iterators
	      setToStringTag$5(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
	      Iterators$4[TO_STRING_TAG] = returnThis;
	    }
	  }

	  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
	  if (PROPER_FUNCTION_NAME && DEFAULT === VALUES && nativeIterator && nativeIterator.name !== VALUES) {
	    {
	      INCORRECT_VALUES_NAME = true;
	      defaultIterator = function values() { return call$e(nativeIterator, this); };
	    }
	  }

	  // export additional methods
	  if (DEFAULT) {
	    methods = {
	      values: getIterationMethod(VALUES),
	      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
	      entries: getIterationMethod(ENTRIES)
	    };
	    if (FORCED) for (KEY in methods) {
	      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
	        defineBuiltIn$4(IterablePrototype, KEY, methods[KEY]);
	      }
	    } else $$10({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
	  }

	  // define iterator
	  if ((FORCED) && IterablePrototype[ITERATOR$5] !== defaultIterator) {
	    defineBuiltIn$4(IterablePrototype, ITERATOR$5, defaultIterator, { name: DEFAULT });
	  }
	  Iterators$4[NAME] = defaultIterator;

	  return methods;
	};

	// `CreateIterResultObject` abstract operation
	// https://tc39.es/ecma262/#sec-createiterresultobject
	var createIterResultObject$3 = function (value, done) {
	  return { value: value, done: done };
	};

	var charAt$2 = stringMultibyte.charAt;
	var toString$8 = toString$b;
	var InternalStateModule$6 = internalState;
	var defineIterator$2 = iteratorDefine;
	var createIterResultObject$2 = createIterResultObject$3;

	var STRING_ITERATOR = 'String Iterator';
	var setInternalState$6 = InternalStateModule$6.set;
	var getInternalState$2 = InternalStateModule$6.getterFor(STRING_ITERATOR);

	// `String.prototype[@@iterator]` method
	// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
	defineIterator$2(String, 'String', function (iterated) {
	  setInternalState$6(this, {
	    type: STRING_ITERATOR,
	    string: toString$8(iterated),
	    index: 0
	  });
	// `%StringIteratorPrototype%.next` method
	// https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
	}, function next() {
	  var state = getInternalState$2(this);
	  var string = state.string;
	  var index = state.index;
	  var point;
	  if (index >= string.length) return createIterResultObject$2(undefined, true);
	  point = charAt$2(string, index);
	  state.index += point.length;
	  return createIterResultObject$2(point, false);
	});

	var call$d = functionCall;
	var anObject$a = anObject$f;
	var getMethod$1 = getMethod$3;

	var iteratorClose$2 = function (iterator, kind, value) {
	  var innerResult, innerError;
	  anObject$a(iterator);
	  try {
	    innerResult = getMethod$1(iterator, 'return');
	    if (!innerResult) {
	      if (kind === 'throw') throw value;
	      return value;
	    }
	    innerResult = call$d(innerResult, iterator);
	  } catch (error) {
	    innerError = true;
	    innerResult = error;
	  }
	  if (kind === 'throw') throw value;
	  if (innerError) throw innerResult;
	  anObject$a(innerResult);
	  return value;
	};

	var anObject$9 = anObject$f;
	var iteratorClose$1 = iteratorClose$2;

	// call something on iterator step with safe closing on error
	var callWithSafeIterationClosing$1 = function (iterator, fn, value, ENTRIES) {
	  try {
	    return ENTRIES ? fn(anObject$9(value)[0], value[1]) : fn(value);
	  } catch (error) {
	    iteratorClose$1(iterator, 'throw', error);
	  }
	};

	var wellKnownSymbol$i = wellKnownSymbol$p;
	var Iterators$3 = iterators;

	var ITERATOR$4 = wellKnownSymbol$i('iterator');
	var ArrayPrototype$j = Array.prototype;

	// check on default Array iterator
	var isArrayIteratorMethod$2 = function (it) {
	  return it !== undefined && (Iterators$3.Array === it || ArrayPrototype$j[ITERATOR$4] === it);
	};

	var uncurryThis$l = functionUncurryThis;
	var isCallable$9 = isCallable$m;
	var store = sharedStore;

	var functionToString = uncurryThis$l(Function.toString);

	// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
	if (!isCallable$9(store.inspectSource)) {
	  store.inspectSource = function (it) {
	    return functionToString(it);
	  };
	}

	var inspectSource$2 = store.inspectSource;

	var uncurryThis$k = functionUncurryThis;
	var fails$p = fails$A;
	var isCallable$8 = isCallable$m;
	var classof$c = classof$f;
	var getBuiltIn$c = getBuiltIn$f;
	var inspectSource$1 = inspectSource$2;

	var noop = function () { /* empty */ };
	var empty = [];
	var construct$3 = getBuiltIn$c('Reflect', 'construct');
	var constructorRegExp = /^\s*(?:class|function)\b/;
	var exec$2 = uncurryThis$k(constructorRegExp.exec);
	var INCORRECT_TO_STRING = !constructorRegExp.test(noop);

	var isConstructorModern = function isConstructor(argument) {
	  if (!isCallable$8(argument)) return false;
	  try {
	    construct$3(noop, empty, argument);
	    return true;
	  } catch (error) {
	    return false;
	  }
	};

	var isConstructorLegacy = function isConstructor(argument) {
	  if (!isCallable$8(argument)) return false;
	  switch (classof$c(argument)) {
	    case 'AsyncFunction':
	    case 'GeneratorFunction':
	    case 'AsyncGeneratorFunction': return false;
	  }
	  try {
	    // we can't check .prototype since constructors produced by .bind haven't it
	    // `Function#toString` throws on some built-it function in some legacy engines
	    // (for example, `DOMQuad` and similar in FF41-)
	    return INCORRECT_TO_STRING || !!exec$2(constructorRegExp, inspectSource$1(argument));
	  } catch (error) {
	    return true;
	  }
	};

	isConstructorLegacy.sham = true;

	// `IsConstructor` abstract operation
	// https://tc39.es/ecma262/#sec-isconstructor
	var isConstructor$4 = !construct$3 || fails$p(function () {
	  var called;
	  return isConstructorModern(isConstructorModern.call)
	    || !isConstructorModern(Object)
	    || !isConstructorModern(function () { called = true; })
	    || called;
	}) ? isConstructorLegacy : isConstructorModern;

	var toPropertyKey$1 = toPropertyKey$4;
	var definePropertyModule$2 = objectDefineProperty;
	var createPropertyDescriptor$3 = createPropertyDescriptor$7;

	var createProperty$6 = function (object, key, value) {
	  var propertyKey = toPropertyKey$1(key);
	  if (propertyKey in object) definePropertyModule$2.f(object, propertyKey, createPropertyDescriptor$3(0, value));
	  else object[propertyKey] = value;
	};

	var classof$b = classof$f;
	var getMethod = getMethod$3;
	var isNullOrUndefined$4 = isNullOrUndefined$7;
	var Iterators$2 = iterators;
	var wellKnownSymbol$h = wellKnownSymbol$p;

	var ITERATOR$3 = wellKnownSymbol$h('iterator');

	var getIteratorMethod$9 = function (it) {
	  if (!isNullOrUndefined$4(it)) return getMethod(it, ITERATOR$3)
	    || getMethod(it, '@@iterator')
	    || Iterators$2[classof$b(it)];
	};

	var call$c = functionCall;
	var aCallable$9 = aCallable$e;
	var anObject$8 = anObject$f;
	var tryToString$4 = tryToString$6;
	var getIteratorMethod$8 = getIteratorMethod$9;

	var $TypeError$a = TypeError;

	var getIterator$8 = function (argument, usingIterator) {
	  var iteratorMethod = arguments.length < 2 ? getIteratorMethod$8(argument) : usingIterator;
	  if (aCallable$9(iteratorMethod)) return anObject$8(call$c(iteratorMethod, argument));
	  throw new $TypeError$a(tryToString$4(argument) + ' is not iterable');
	};

	var bind$b = functionBindContext;
	var call$b = functionCall;
	var toObject$b = toObject$f;
	var callWithSafeIterationClosing = callWithSafeIterationClosing$1;
	var isArrayIteratorMethod$1 = isArrayIteratorMethod$2;
	var isConstructor$3 = isConstructor$4;
	var lengthOfArrayLike$c = lengthOfArrayLike$e;
	var createProperty$5 = createProperty$6;
	var getIterator$7 = getIterator$8;
	var getIteratorMethod$7 = getIteratorMethod$9;

	var $Array$3 = Array;

	// `Array.from` method implementation
	// https://tc39.es/ecma262/#sec-array.from
	var arrayFrom = function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
	  var O = toObject$b(arrayLike);
	  var IS_CONSTRUCTOR = isConstructor$3(this);
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  if (mapping) mapfn = bind$b(mapfn, argumentsLength > 2 ? arguments[2] : undefined);
	  var iteratorMethod = getIteratorMethod$7(O);
	  var index = 0;
	  var length, result, step, iterator, next, value;
	  // if the target is not iterable or it's an array with the default iterator - use a simple case
	  if (iteratorMethod && !(this === $Array$3 && isArrayIteratorMethod$1(iteratorMethod))) {
	    iterator = getIterator$7(O, iteratorMethod);
	    next = iterator.next;
	    result = IS_CONSTRUCTOR ? new this() : [];
	    for (;!(step = call$b(next, iterator)).done; index++) {
	      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
	      createProperty$5(result, index, value);
	    }
	  } else {
	    length = lengthOfArrayLike$c(O);
	    result = IS_CONSTRUCTOR ? new this(length) : $Array$3(length);
	    for (;length > index; index++) {
	      value = mapping ? mapfn(O[index], index) : O[index];
	      createProperty$5(result, index, value);
	    }
	  }
	  result.length = index;
	  return result;
	};

	var wellKnownSymbol$g = wellKnownSymbol$p;

	var ITERATOR$2 = wellKnownSymbol$g('iterator');
	var SAFE_CLOSING = false;

	try {
	  var called = 0;
	  var iteratorWithReturn = {
	    next: function () {
	      return { done: !!called++ };
	    },
	    'return': function () {
	      SAFE_CLOSING = true;
	    }
	  };
	  iteratorWithReturn[ITERATOR$2] = function () {
	    return this;
	  };
	  // eslint-disable-next-line es/no-array-from, no-throw-literal -- required for testing
	  Array.from(iteratorWithReturn, function () { throw 2; });
	} catch (error) { /* empty */ }

	var checkCorrectnessOfIteration$2 = function (exec, SKIP_CLOSING) {
	  try {
	    if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
	  } catch (error) { return false; } // workaround of old WebKit + `eval` bug
	  var ITERATION_SUPPORT = false;
	  try {
	    var object = {};
	    object[ITERATOR$2] = function () {
	      return {
	        next: function () {
	          return { done: ITERATION_SUPPORT = true };
	        }
	      };
	    };
	    exec(object);
	  } catch (error) { /* empty */ }
	  return ITERATION_SUPPORT;
	};

	var $$$ = _export;
	var from$6 = arrayFrom;
	var checkCorrectnessOfIteration$1 = checkCorrectnessOfIteration$2;

	var INCORRECT_ITERATION = !checkCorrectnessOfIteration$1(function (iterable) {
	  // eslint-disable-next-line es/no-array-from -- required for testing
	  Array.from(iterable);
	});

	// `Array.from` method
	// https://tc39.es/ecma262/#sec-array.from
	$$$({ target: 'Array', stat: true, forced: INCORRECT_ITERATION }, {
	  from: from$6
	});

	var path$v = path$A;

	var from$5 = path$v.Array.from;

	var parent$1p = from$5;

	var from$4 = parent$1p;

	var from$3 = from$4;

	var _Array$from$1 = /*@__PURE__*/getDefaultExportFromCjs(from$3);

	var toIndexedObject$6 = toIndexedObject$b;
	var Iterators$1 = iterators;
	var InternalStateModule$5 = internalState;
	objectDefineProperty.f;
	var defineIterator$1 = iteratorDefine;
	var createIterResultObject$1 = createIterResultObject$3;

	var ARRAY_ITERATOR = 'Array Iterator';
	var setInternalState$5 = InternalStateModule$5.set;
	var getInternalState$1 = InternalStateModule$5.getterFor(ARRAY_ITERATOR);

	// `Array.prototype.entries` method
	// https://tc39.es/ecma262/#sec-array.prototype.entries
	// `Array.prototype.keys` method
	// https://tc39.es/ecma262/#sec-array.prototype.keys
	// `Array.prototype.values` method
	// https://tc39.es/ecma262/#sec-array.prototype.values
	// `Array.prototype[@@iterator]` method
	// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
	// `CreateArrayIterator` internal method
	// https://tc39.es/ecma262/#sec-createarrayiterator
	defineIterator$1(Array, 'Array', function (iterated, kind) {
	  setInternalState$5(this, {
	    type: ARRAY_ITERATOR,
	    target: toIndexedObject$6(iterated), // target
	    index: 0,                          // next index
	    kind: kind                         // kind
	  });
	// `%ArrayIteratorPrototype%.next` method
	// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
	}, function () {
	  var state = getInternalState$1(this);
	  var target = state.target;
	  var kind = state.kind;
	  var index = state.index++;
	  if (!target || index >= target.length) {
	    state.target = undefined;
	    return createIterResultObject$1(undefined, true);
	  }
	  switch (kind) {
	    case 'keys': return createIterResultObject$1(index, false);
	    case 'values': return createIterResultObject$1(target[index], false);
	  } return createIterResultObject$1([index, target[index]], false);
	}, 'values');

	// argumentsList[@@iterator] is %ArrayProto_values%
	// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
	// https://tc39.es/ecma262/#sec-createmappedargumentsobject
	Iterators$1.Arguments = Iterators$1.Array;

	var getIteratorMethod$6 = getIteratorMethod$9;

	var getIteratorMethod_1 = getIteratorMethod$6;

	// iterable DOM collections
	// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
	var domIterables = {
	  CSSRuleList: 0,
	  CSSStyleDeclaration: 0,
	  CSSValueList: 0,
	  ClientRectList: 0,
	  DOMRectList: 0,
	  DOMStringList: 0,
	  DOMTokenList: 1,
	  DataTransferItemList: 0,
	  FileList: 0,
	  HTMLAllCollection: 0,
	  HTMLCollection: 0,
	  HTMLFormElement: 0,
	  HTMLSelectElement: 0,
	  MediaList: 0,
	  MimeTypeArray: 0,
	  NamedNodeMap: 0,
	  NodeList: 1,
	  PaintRequestList: 0,
	  Plugin: 0,
	  PluginArray: 0,
	  SVGLengthList: 0,
	  SVGNumberList: 0,
	  SVGPathSegList: 0,
	  SVGPointList: 0,
	  SVGStringList: 0,
	  SVGTransformList: 0,
	  SourceBufferList: 0,
	  StyleSheetList: 0,
	  TextTrackCueList: 0,
	  TextTrackList: 0,
	  TouchList: 0
	};

	var DOMIterables$4 = domIterables;
	var global$h = global$s;
	var classof$a = classof$f;
	var createNonEnumerableProperty$4 = createNonEnumerableProperty$9;
	var Iterators = iterators;
	var wellKnownSymbol$f = wellKnownSymbol$p;

	var TO_STRING_TAG$1 = wellKnownSymbol$f('toStringTag');

	for (var COLLECTION_NAME in DOMIterables$4) {
	  var Collection = global$h[COLLECTION_NAME];
	  var CollectionPrototype = Collection && Collection.prototype;
	  if (CollectionPrototype && classof$a(CollectionPrototype) !== TO_STRING_TAG$1) {
	    createNonEnumerableProperty$4(CollectionPrototype, TO_STRING_TAG$1, COLLECTION_NAME);
	  }
	  Iterators[COLLECTION_NAME] = Iterators.Array;
	}

	var parent$1o = getIteratorMethod_1;


	var getIteratorMethod$5 = parent$1o;

	var parent$1n = getIteratorMethod$5;

	var getIteratorMethod$4 = parent$1n;

	var parent$1m = getIteratorMethod$4;

	var getIteratorMethod$3 = parent$1m;

	var getIteratorMethod$2 = getIteratorMethod$3;

	var _getIteratorMethod$1 = /*@__PURE__*/getDefaultExportFromCjs(getIteratorMethod$2);

	var getIteratorMethod$1 = getIteratorMethod$2;

	var _getIteratorMethod = /*@__PURE__*/getDefaultExportFromCjs(getIteratorMethod$1);

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	var defineProperty$c = {exports: {}};

	var $$_ = _export;
	var DESCRIPTORS$a = descriptors;
	var defineProperty$b = objectDefineProperty.f;

	// `Object.defineProperty` method
	// https://tc39.es/ecma262/#sec-object.defineproperty
	// eslint-disable-next-line es/no-object-defineproperty -- safe
	$$_({ target: 'Object', stat: true, forced: Object.defineProperty !== defineProperty$b, sham: !DESCRIPTORS$a }, {
	  defineProperty: defineProperty$b
	});

	var path$u = path$A;

	var Object$5 = path$u.Object;

	var defineProperty$a = defineProperty$c.exports = function defineProperty(it, key, desc) {
	  return Object$5.defineProperty(it, key, desc);
	};

	if (Object$5.defineProperty.sham) defineProperty$a.sham = true;

	var definePropertyExports = defineProperty$c.exports;

	var parent$1l = definePropertyExports;

	var defineProperty$9 = parent$1l;

	var parent$1k = defineProperty$9;

	var defineProperty$8 = parent$1k;

	var parent$1j = defineProperty$8;

	var defineProperty$7 = parent$1j;

	var defineProperty$6 = defineProperty$7;

	var _Object$defineProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(defineProperty$6);

	var classof$9 = classofRaw$2;

	// `IsArray` abstract operation
	// https://tc39.es/ecma262/#sec-isarray
	// eslint-disable-next-line es/no-array-isarray -- safe
	var isArray$f = Array.isArray || function isArray(argument) {
	  return classof$9(argument) === 'Array';
	};

	var $TypeError$9 = TypeError;
	var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF; // 2 ** 53 - 1 == 9007199254740991

	var doesNotExceedSafeInteger$4 = function (it) {
	  if (it > MAX_SAFE_INTEGER) throw $TypeError$9('Maximum allowed index exceeded');
	  return it;
	};

	var isArray$e = isArray$f;
	var isConstructor$2 = isConstructor$4;
	var isObject$e = isObject$m;
	var wellKnownSymbol$e = wellKnownSymbol$p;

	var SPECIES$5 = wellKnownSymbol$e('species');
	var $Array$2 = Array;

	// a part of `ArraySpeciesCreate` abstract operation
	// https://tc39.es/ecma262/#sec-arrayspeciescreate
	var arraySpeciesConstructor$1 = function (originalArray) {
	  var C;
	  if (isArray$e(originalArray)) {
	    C = originalArray.constructor;
	    // cross-realm fallback
	    if (isConstructor$2(C) && (C === $Array$2 || isArray$e(C.prototype))) C = undefined;
	    else if (isObject$e(C)) {
	      C = C[SPECIES$5];
	      if (C === null) C = undefined;
	    }
	  } return C === undefined ? $Array$2 : C;
	};

	var arraySpeciesConstructor = arraySpeciesConstructor$1;

	// `ArraySpeciesCreate` abstract operation
	// https://tc39.es/ecma262/#sec-arrayspeciescreate
	var arraySpeciesCreate$4 = function (originalArray, length) {
	  return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
	};

	var fails$o = fails$A;
	var wellKnownSymbol$d = wellKnownSymbol$p;
	var V8_VERSION$2 = engineV8Version;

	var SPECIES$4 = wellKnownSymbol$d('species');

	var arrayMethodHasSpeciesSupport$5 = function (METHOD_NAME) {
	  // We can't use this feature detection in V8 since it causes
	  // deoptimization and serious performance degradation
	  // https://github.com/zloirock/core-js/issues/677
	  return V8_VERSION$2 >= 51 || !fails$o(function () {
	    var array = [];
	    var constructor = array.constructor = {};
	    constructor[SPECIES$4] = function () {
	      return { foo: 1 };
	    };
	    return array[METHOD_NAME](Boolean).foo !== 1;
	  });
	};

	var $$Z = _export;
	var fails$n = fails$A;
	var isArray$d = isArray$f;
	var isObject$d = isObject$m;
	var toObject$a = toObject$f;
	var lengthOfArrayLike$b = lengthOfArrayLike$e;
	var doesNotExceedSafeInteger$3 = doesNotExceedSafeInteger$4;
	var createProperty$4 = createProperty$6;
	var arraySpeciesCreate$3 = arraySpeciesCreate$4;
	var arrayMethodHasSpeciesSupport$4 = arrayMethodHasSpeciesSupport$5;
	var wellKnownSymbol$c = wellKnownSymbol$p;
	var V8_VERSION$1 = engineV8Version;

	var IS_CONCAT_SPREADABLE = wellKnownSymbol$c('isConcatSpreadable');

	// We can't use this feature detection in V8 since it causes
	// deoptimization and serious performance degradation
	// https://github.com/zloirock/core-js/issues/679
	var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION$1 >= 51 || !fails$n(function () {
	  var array = [];
	  array[IS_CONCAT_SPREADABLE] = false;
	  return array.concat()[0] !== array;
	});

	var isConcatSpreadable = function (O) {
	  if (!isObject$d(O)) return false;
	  var spreadable = O[IS_CONCAT_SPREADABLE];
	  return spreadable !== undefined ? !!spreadable : isArray$d(O);
	};

	var FORCED$a = !IS_CONCAT_SPREADABLE_SUPPORT || !arrayMethodHasSpeciesSupport$4('concat');

	// `Array.prototype.concat` method
	// https://tc39.es/ecma262/#sec-array.prototype.concat
	// with adding support of @@isConcatSpreadable and @@species
	$$Z({ target: 'Array', proto: true, arity: 1, forced: FORCED$a }, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  concat: function concat(arg) {
	    var O = toObject$a(this);
	    var A = arraySpeciesCreate$3(O, 0);
	    var n = 0;
	    var i, k, length, len, E;
	    for (i = -1, length = arguments.length; i < length; i++) {
	      E = i === -1 ? O : arguments[i];
	      if (isConcatSpreadable(E)) {
	        len = lengthOfArrayLike$b(E);
	        doesNotExceedSafeInteger$3(n + len);
	        for (k = 0; k < len; k++, n++) if (k in E) createProperty$4(A, n, E[k]);
	      } else {
	        doesNotExceedSafeInteger$3(n + 1);
	        createProperty$4(A, n++, E);
	      }
	    }
	    A.length = n;
	    return A;
	  }
	});

	var objectGetOwnPropertyNames = {};

	var internalObjectKeys = objectKeysInternal;
	var enumBugKeys = enumBugKeys$3;

	var hiddenKeys$2 = enumBugKeys.concat('length', 'prototype');

	// `Object.getOwnPropertyNames` method
	// https://tc39.es/ecma262/#sec-object.getownpropertynames
	// eslint-disable-next-line es/no-object-getownpropertynames -- safe
	objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
	  return internalObjectKeys(O, hiddenKeys$2);
	};

	var objectGetOwnPropertyNamesExternal = {};

	var toAbsoluteIndex$3 = toAbsoluteIndex$5;
	var lengthOfArrayLike$a = lengthOfArrayLike$e;
	var createProperty$3 = createProperty$6;

	var $Array$1 = Array;
	var max$2 = Math.max;

	var arraySliceSimple = function (O, start, end) {
	  var length = lengthOfArrayLike$a(O);
	  var k = toAbsoluteIndex$3(start, length);
	  var fin = toAbsoluteIndex$3(end === undefined ? length : end, length);
	  var result = $Array$1(max$2(fin - k, 0));
	  var n = 0;
	  for (; k < fin; k++, n++) createProperty$3(result, n, O[k]);
	  result.length = n;
	  return result;
	};

	/* eslint-disable es/no-object-getownpropertynames -- safe */
	var classof$8 = classofRaw$2;
	var toIndexedObject$5 = toIndexedObject$b;
	var $getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
	var arraySlice$4 = arraySliceSimple;

	var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
	  ? Object.getOwnPropertyNames(window) : [];

	var getWindowNames = function (it) {
	  try {
	    return $getOwnPropertyNames$1(it);
	  } catch (error) {
	    return arraySlice$4(windowNames);
	  }
	};

	// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
	objectGetOwnPropertyNamesExternal.f = function getOwnPropertyNames(it) {
	  return windowNames && classof$8(it) === 'Window'
	    ? getWindowNames(it)
	    : $getOwnPropertyNames$1(toIndexedObject$5(it));
	};

	var defineProperty$5 = objectDefineProperty;

	var defineBuiltInAccessor$3 = function (target, name, descriptor) {
	  return defineProperty$5.f(target, name, descriptor);
	};

	var wellKnownSymbolWrapped = {};

	var wellKnownSymbol$b = wellKnownSymbol$p;

	wellKnownSymbolWrapped.f = wellKnownSymbol$b;

	var path$t = path$A;
	var hasOwn$c = hasOwnProperty_1;
	var wrappedWellKnownSymbolModule$1 = wellKnownSymbolWrapped;
	var defineProperty$4 = objectDefineProperty.f;

	var wellKnownSymbolDefine = function (NAME) {
	  var Symbol = path$t.Symbol || (path$t.Symbol = {});
	  if (!hasOwn$c(Symbol, NAME)) defineProperty$4(Symbol, NAME, {
	    value: wrappedWellKnownSymbolModule$1.f(NAME)
	  });
	};

	var call$a = functionCall;
	var getBuiltIn$b = getBuiltIn$f;
	var wellKnownSymbol$a = wellKnownSymbol$p;
	var defineBuiltIn$3 = defineBuiltIn$6;

	var symbolDefineToPrimitive = function () {
	  var Symbol = getBuiltIn$b('Symbol');
	  var SymbolPrototype = Symbol && Symbol.prototype;
	  var valueOf = SymbolPrototype && SymbolPrototype.valueOf;
	  var TO_PRIMITIVE = wellKnownSymbol$a('toPrimitive');

	  if (SymbolPrototype && !SymbolPrototype[TO_PRIMITIVE]) {
	    // `Symbol.prototype[@@toPrimitive]` method
	    // https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
	    // eslint-disable-next-line no-unused-vars -- required for .length
	    defineBuiltIn$3(SymbolPrototype, TO_PRIMITIVE, function (hint) {
	      return call$a(valueOf, this);
	    }, { arity: 1 });
	  }
	};

	var bind$a = functionBindContext;
	var uncurryThis$j = functionUncurryThis;
	var IndexedObject$1 = indexedObject;
	var toObject$9 = toObject$f;
	var lengthOfArrayLike$9 = lengthOfArrayLike$e;
	var arraySpeciesCreate$2 = arraySpeciesCreate$4;

	var push$c = uncurryThis$j([].push);

	// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation
	var createMethod$3 = function (TYPE) {
	  var IS_MAP = TYPE === 1;
	  var IS_FILTER = TYPE === 2;
	  var IS_SOME = TYPE === 3;
	  var IS_EVERY = TYPE === 4;
	  var IS_FIND_INDEX = TYPE === 6;
	  var IS_FILTER_REJECT = TYPE === 7;
	  var NO_HOLES = TYPE === 5 || IS_FIND_INDEX;
	  return function ($this, callbackfn, that, specificCreate) {
	    var O = toObject$9($this);
	    var self = IndexedObject$1(O);
	    var boundFunction = bind$a(callbackfn, that);
	    var length = lengthOfArrayLike$9(self);
	    var index = 0;
	    var create = specificCreate || arraySpeciesCreate$2;
	    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
	    var value, result;
	    for (;length > index; index++) if (NO_HOLES || index in self) {
	      value = self[index];
	      result = boundFunction(value, index, O);
	      if (TYPE) {
	        if (IS_MAP) target[index] = result; // map
	        else if (result) switch (TYPE) {
	          case 3: return true;              // some
	          case 5: return value;             // find
	          case 6: return index;             // findIndex
	          case 2: push$c(target, value);      // filter
	        } else switch (TYPE) {
	          case 4: return false;             // every
	          case 7: push$c(target, value);      // filterReject
	        }
	      }
	    }
	    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
	  };
	};

	var arrayIteration = {
	  // `Array.prototype.forEach` method
	  // https://tc39.es/ecma262/#sec-array.prototype.foreach
	  forEach: createMethod$3(0),
	  // `Array.prototype.map` method
	  // https://tc39.es/ecma262/#sec-array.prototype.map
	  map: createMethod$3(1),
	  // `Array.prototype.filter` method
	  // https://tc39.es/ecma262/#sec-array.prototype.filter
	  filter: createMethod$3(2),
	  // `Array.prototype.some` method
	  // https://tc39.es/ecma262/#sec-array.prototype.some
	  some: createMethod$3(3),
	  // `Array.prototype.every` method
	  // https://tc39.es/ecma262/#sec-array.prototype.every
	  every: createMethod$3(4),
	  // `Array.prototype.find` method
	  // https://tc39.es/ecma262/#sec-array.prototype.find
	  find: createMethod$3(5),
	  // `Array.prototype.findIndex` method
	  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
	  findIndex: createMethod$3(6),
	  // `Array.prototype.filterReject` method
	  // https://github.com/tc39/proposal-array-filtering
	  filterReject: createMethod$3(7)
	};

	var $$Y = _export;
	var global$g = global$s;
	var call$9 = functionCall;
	var uncurryThis$i = functionUncurryThis;
	var DESCRIPTORS$9 = descriptors;
	var NATIVE_SYMBOL$3 = symbolConstructorDetection;
	var fails$m = fails$A;
	var hasOwn$b = hasOwnProperty_1;
	var isPrototypeOf$m = objectIsPrototypeOf;
	var anObject$7 = anObject$f;
	var toIndexedObject$4 = toIndexedObject$b;
	var toPropertyKey = toPropertyKey$4;
	var $toString = toString$b;
	var createPropertyDescriptor$2 = createPropertyDescriptor$7;
	var nativeObjectCreate = objectCreate;
	var objectKeys$1 = objectKeys$4;
	var getOwnPropertyNamesModule$2 = objectGetOwnPropertyNames;
	var getOwnPropertyNamesExternal = objectGetOwnPropertyNamesExternal;
	var getOwnPropertySymbolsModule$2 = objectGetOwnPropertySymbols;
	var getOwnPropertyDescriptorModule$3 = objectGetOwnPropertyDescriptor;
	var definePropertyModule$1 = objectDefineProperty;
	var definePropertiesModule = objectDefineProperties;
	var propertyIsEnumerableModule = objectPropertyIsEnumerable;
	var defineBuiltIn$2 = defineBuiltIn$6;
	var defineBuiltInAccessor$2 = defineBuiltInAccessor$3;
	var shared$3 = sharedExports;
	var sharedKey = sharedKey$4;
	var hiddenKeys$1 = hiddenKeys$6;
	var uid$1 = uid$4;
	var wellKnownSymbol$9 = wellKnownSymbol$p;
	var wrappedWellKnownSymbolModule = wellKnownSymbolWrapped;
	var defineWellKnownSymbol$l = wellKnownSymbolDefine;
	var defineSymbolToPrimitive$1 = symbolDefineToPrimitive;
	var setToStringTag$4 = setToStringTag$7;
	var InternalStateModule$4 = internalState;
	var $forEach$1 = arrayIteration.forEach;

	var HIDDEN = sharedKey('hidden');
	var SYMBOL = 'Symbol';
	var PROTOTYPE = 'prototype';

	var setInternalState$4 = InternalStateModule$4.set;
	var getInternalState = InternalStateModule$4.getterFor(SYMBOL);

	var ObjectPrototype$1 = Object[PROTOTYPE];
	var $Symbol = global$g.Symbol;
	var SymbolPrototype = $Symbol && $Symbol[PROTOTYPE];
	var RangeError$1 = global$g.RangeError;
	var TypeError$2 = global$g.TypeError;
	var QObject = global$g.QObject;
	var nativeGetOwnPropertyDescriptor$1 = getOwnPropertyDescriptorModule$3.f;
	var nativeDefineProperty = definePropertyModule$1.f;
	var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
	var nativePropertyIsEnumerable = propertyIsEnumerableModule.f;
	var push$b = uncurryThis$i([].push);

	var AllSymbols = shared$3('symbols');
	var ObjectPrototypeSymbols = shared$3('op-symbols');
	var WellKnownSymbolsStore$1 = shared$3('wks');

	// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
	var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

	// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
	var fallbackDefineProperty = function (O, P, Attributes) {
	  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor$1(ObjectPrototype$1, P);
	  if (ObjectPrototypeDescriptor) delete ObjectPrototype$1[P];
	  nativeDefineProperty(O, P, Attributes);
	  if (ObjectPrototypeDescriptor && O !== ObjectPrototype$1) {
	    nativeDefineProperty(ObjectPrototype$1, P, ObjectPrototypeDescriptor);
	  }
	};

	var setSymbolDescriptor = DESCRIPTORS$9 && fails$m(function () {
	  return nativeObjectCreate(nativeDefineProperty({}, 'a', {
	    get: function () { return nativeDefineProperty(this, 'a', { value: 7 }).a; }
	  })).a !== 7;
	}) ? fallbackDefineProperty : nativeDefineProperty;

	var wrap = function (tag, description) {
	  var symbol = AllSymbols[tag] = nativeObjectCreate(SymbolPrototype);
	  setInternalState$4(symbol, {
	    type: SYMBOL,
	    tag: tag,
	    description: description
	  });
	  if (!DESCRIPTORS$9) symbol.description = description;
	  return symbol;
	};

	var $defineProperty = function defineProperty(O, P, Attributes) {
	  if (O === ObjectPrototype$1) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
	  anObject$7(O);
	  var key = toPropertyKey(P);
	  anObject$7(Attributes);
	  if (hasOwn$b(AllSymbols, key)) {
	    if (!Attributes.enumerable) {
	      if (!hasOwn$b(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor$2(1, {}));
	      O[HIDDEN][key] = true;
	    } else {
	      if (hasOwn$b(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
	      Attributes = nativeObjectCreate(Attributes, { enumerable: createPropertyDescriptor$2(0, false) });
	    } return setSymbolDescriptor(O, key, Attributes);
	  } return nativeDefineProperty(O, key, Attributes);
	};

	var $defineProperties = function defineProperties(O, Properties) {
	  anObject$7(O);
	  var properties = toIndexedObject$4(Properties);
	  var keys = objectKeys$1(properties).concat($getOwnPropertySymbols(properties));
	  $forEach$1(keys, function (key) {
	    if (!DESCRIPTORS$9 || call$9($propertyIsEnumerable$1, properties, key)) $defineProperty(O, key, properties[key]);
	  });
	  return O;
	};

	var $create = function create(O, Properties) {
	  return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
	};

	var $propertyIsEnumerable$1 = function propertyIsEnumerable(V) {
	  var P = toPropertyKey(V);
	  var enumerable = call$9(nativePropertyIsEnumerable, this, P);
	  if (this === ObjectPrototype$1 && hasOwn$b(AllSymbols, P) && !hasOwn$b(ObjectPrototypeSymbols, P)) return false;
	  return enumerable || !hasOwn$b(this, P) || !hasOwn$b(AllSymbols, P) || hasOwn$b(this, HIDDEN) && this[HIDDEN][P]
	    ? enumerable : true;
	};

	var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
	  var it = toIndexedObject$4(O);
	  var key = toPropertyKey(P);
	  if (it === ObjectPrototype$1 && hasOwn$b(AllSymbols, key) && !hasOwn$b(ObjectPrototypeSymbols, key)) return;
	  var descriptor = nativeGetOwnPropertyDescriptor$1(it, key);
	  if (descriptor && hasOwn$b(AllSymbols, key) && !(hasOwn$b(it, HIDDEN) && it[HIDDEN][key])) {
	    descriptor.enumerable = true;
	  }
	  return descriptor;
	};

	var $getOwnPropertyNames = function getOwnPropertyNames(O) {
	  var names = nativeGetOwnPropertyNames(toIndexedObject$4(O));
	  var result = [];
	  $forEach$1(names, function (key) {
	    if (!hasOwn$b(AllSymbols, key) && !hasOwn$b(hiddenKeys$1, key)) push$b(result, key);
	  });
	  return result;
	};

	var $getOwnPropertySymbols = function (O) {
	  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype$1;
	  var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject$4(O));
	  var result = [];
	  $forEach$1(names, function (key) {
	    if (hasOwn$b(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || hasOwn$b(ObjectPrototype$1, key))) {
	      push$b(result, AllSymbols[key]);
	    }
	  });
	  return result;
	};

	// `Symbol` constructor
	// https://tc39.es/ecma262/#sec-symbol-constructor
	if (!NATIVE_SYMBOL$3) {
	  $Symbol = function Symbol() {
	    if (isPrototypeOf$m(SymbolPrototype, this)) throw new TypeError$2('Symbol is not a constructor');
	    var description = !arguments.length || arguments[0] === undefined ? undefined : $toString(arguments[0]);
	    var tag = uid$1(description);
	    var setter = function (value) {
	      if (this === ObjectPrototype$1) call$9(setter, ObjectPrototypeSymbols, value);
	      if (hasOwn$b(this, HIDDEN) && hasOwn$b(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
	      var descriptor = createPropertyDescriptor$2(1, value);
	      try {
	        setSymbolDescriptor(this, tag, descriptor);
	      } catch (error) {
	        if (!(error instanceof RangeError$1)) throw error;
	        fallbackDefineProperty(this, tag, descriptor);
	      }
	    };
	    if (DESCRIPTORS$9 && USE_SETTER) setSymbolDescriptor(ObjectPrototype$1, tag, { configurable: true, set: setter });
	    return wrap(tag, description);
	  };

	  SymbolPrototype = $Symbol[PROTOTYPE];

	  defineBuiltIn$2(SymbolPrototype, 'toString', function toString() {
	    return getInternalState(this).tag;
	  });

	  defineBuiltIn$2($Symbol, 'withoutSetter', function (description) {
	    return wrap(uid$1(description), description);
	  });

	  propertyIsEnumerableModule.f = $propertyIsEnumerable$1;
	  definePropertyModule$1.f = $defineProperty;
	  definePropertiesModule.f = $defineProperties;
	  getOwnPropertyDescriptorModule$3.f = $getOwnPropertyDescriptor;
	  getOwnPropertyNamesModule$2.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
	  getOwnPropertySymbolsModule$2.f = $getOwnPropertySymbols;

	  wrappedWellKnownSymbolModule.f = function (name) {
	    return wrap(wellKnownSymbol$9(name), name);
	  };

	  if (DESCRIPTORS$9) {
	    // https://github.com/tc39/proposal-Symbol-description
	    defineBuiltInAccessor$2(SymbolPrototype, 'description', {
	      configurable: true,
	      get: function description() {
	        return getInternalState(this).description;
	      }
	    });
	  }
	}

	$$Y({ global: true, constructor: true, wrap: true, forced: !NATIVE_SYMBOL$3, sham: !NATIVE_SYMBOL$3 }, {
	  Symbol: $Symbol
	});

	$forEach$1(objectKeys$1(WellKnownSymbolsStore$1), function (name) {
	  defineWellKnownSymbol$l(name);
	});

	$$Y({ target: SYMBOL, stat: true, forced: !NATIVE_SYMBOL$3 }, {
	  useSetter: function () { USE_SETTER = true; },
	  useSimple: function () { USE_SETTER = false; }
	});

	$$Y({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL$3, sham: !DESCRIPTORS$9 }, {
	  // `Object.create` method
	  // https://tc39.es/ecma262/#sec-object.create
	  create: $create,
	  // `Object.defineProperty` method
	  // https://tc39.es/ecma262/#sec-object.defineproperty
	  defineProperty: $defineProperty,
	  // `Object.defineProperties` method
	  // https://tc39.es/ecma262/#sec-object.defineproperties
	  defineProperties: $defineProperties,
	  // `Object.getOwnPropertyDescriptor` method
	  // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
	  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
	});

	$$Y({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL$3 }, {
	  // `Object.getOwnPropertyNames` method
	  // https://tc39.es/ecma262/#sec-object.getownpropertynames
	  getOwnPropertyNames: $getOwnPropertyNames
	});

	// `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
	defineSymbolToPrimitive$1();

	// `Symbol.prototype[@@toStringTag]` property
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
	setToStringTag$4($Symbol, SYMBOL);

	hiddenKeys$1[HIDDEN] = true;

	var NATIVE_SYMBOL$2 = symbolConstructorDetection;

	/* eslint-disable es/no-symbol -- safe */
	var symbolRegistryDetection = NATIVE_SYMBOL$2 && !!Symbol['for'] && !!Symbol.keyFor;

	var $$X = _export;
	var getBuiltIn$a = getBuiltIn$f;
	var hasOwn$a = hasOwnProperty_1;
	var toString$7 = toString$b;
	var shared$2 = sharedExports;
	var NATIVE_SYMBOL_REGISTRY$1 = symbolRegistryDetection;

	var StringToSymbolRegistry = shared$2('string-to-symbol-registry');
	var SymbolToStringRegistry$1 = shared$2('symbol-to-string-registry');

	// `Symbol.for` method
	// https://tc39.es/ecma262/#sec-symbol.for
	$$X({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY$1 }, {
	  'for': function (key) {
	    var string = toString$7(key);
	    if (hasOwn$a(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
	    var symbol = getBuiltIn$a('Symbol')(string);
	    StringToSymbolRegistry[string] = symbol;
	    SymbolToStringRegistry$1[symbol] = string;
	    return symbol;
	  }
	});

	var $$W = _export;
	var hasOwn$9 = hasOwnProperty_1;
	var isSymbol$2 = isSymbol$5;
	var tryToString$3 = tryToString$6;
	var shared$1 = sharedExports;
	var NATIVE_SYMBOL_REGISTRY = symbolRegistryDetection;

	var SymbolToStringRegistry = shared$1('symbol-to-string-registry');

	// `Symbol.keyFor` method
	// https://tc39.es/ecma262/#sec-symbol.keyfor
	$$W({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY }, {
	  keyFor: function keyFor(sym) {
	    if (!isSymbol$2(sym)) throw new TypeError(tryToString$3(sym) + ' is not a symbol');
	    if (hasOwn$9(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
	  }
	});

	var uncurryThis$h = functionUncurryThis;
	var isArray$c = isArray$f;
	var isCallable$7 = isCallable$m;
	var classof$7 = classofRaw$2;
	var toString$6 = toString$b;

	var push$a = uncurryThis$h([].push);

	var getJsonReplacerFunction = function (replacer) {
	  if (isCallable$7(replacer)) return replacer;
	  if (!isArray$c(replacer)) return;
	  var rawLength = replacer.length;
	  var keys = [];
	  for (var i = 0; i < rawLength; i++) {
	    var element = replacer[i];
	    if (typeof element == 'string') push$a(keys, element);
	    else if (typeof element == 'number' || classof$7(element) === 'Number' || classof$7(element) === 'String') push$a(keys, toString$6(element));
	  }
	  var keysLength = keys.length;
	  var root = true;
	  return function (key, value) {
	    if (root) {
	      root = false;
	      return value;
	    }
	    if (isArray$c(this)) return value;
	    for (var j = 0; j < keysLength; j++) if (keys[j] === key) return value;
	  };
	};

	var $$V = _export;
	var getBuiltIn$9 = getBuiltIn$f;
	var apply$4 = functionApply;
	var call$8 = functionCall;
	var uncurryThis$g = functionUncurryThis;
	var fails$l = fails$A;
	var isCallable$6 = isCallable$m;
	var isSymbol$1 = isSymbol$5;
	var arraySlice$3 = arraySlice$6;
	var getReplacerFunction = getJsonReplacerFunction;
	var NATIVE_SYMBOL$1 = symbolConstructorDetection;

	var $String = String;
	var $stringify = getBuiltIn$9('JSON', 'stringify');
	var exec$1 = uncurryThis$g(/./.exec);
	var charAt$1 = uncurryThis$g(''.charAt);
	var charCodeAt = uncurryThis$g(''.charCodeAt);
	var replace$2 = uncurryThis$g(''.replace);
	var numberToString = uncurryThis$g(1.0.toString);

	var tester = /[\uD800-\uDFFF]/g;
	var low = /^[\uD800-\uDBFF]$/;
	var hi = /^[\uDC00-\uDFFF]$/;

	var WRONG_SYMBOLS_CONVERSION = !NATIVE_SYMBOL$1 || fails$l(function () {
	  var symbol = getBuiltIn$9('Symbol')('stringify detection');
	  // MS Edge converts symbol values to JSON as {}
	  return $stringify([symbol]) !== '[null]'
	    // WebKit converts symbol values to JSON as null
	    || $stringify({ a: symbol }) !== '{}'
	    // V8 throws on boxed symbols
	    || $stringify(Object(symbol)) !== '{}';
	});

	// https://github.com/tc39/proposal-well-formed-stringify
	var ILL_FORMED_UNICODE = fails$l(function () {
	  return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"'
	    || $stringify('\uDEAD') !== '"\\udead"';
	});

	var stringifyWithSymbolsFix = function (it, replacer) {
	  var args = arraySlice$3(arguments);
	  var $replacer = getReplacerFunction(replacer);
	  if (!isCallable$6($replacer) && (it === undefined || isSymbol$1(it))) return; // IE8 returns string on undefined
	  args[1] = function (key, value) {
	    // some old implementations (like WebKit) could pass numbers as keys
	    if (isCallable$6($replacer)) value = call$8($replacer, this, $String(key), value);
	    if (!isSymbol$1(value)) return value;
	  };
	  return apply$4($stringify, null, args);
	};

	var fixIllFormed = function (match, offset, string) {
	  var prev = charAt$1(string, offset - 1);
	  var next = charAt$1(string, offset + 1);
	  if ((exec$1(low, match) && !exec$1(hi, next)) || (exec$1(hi, match) && !exec$1(low, prev))) {
	    return '\\u' + numberToString(charCodeAt(match, 0), 16);
	  } return match;
	};

	if ($stringify) {
	  // `JSON.stringify` method
	  // https://tc39.es/ecma262/#sec-json.stringify
	  $$V({ target: 'JSON', stat: true, arity: 3, forced: WRONG_SYMBOLS_CONVERSION || ILL_FORMED_UNICODE }, {
	    // eslint-disable-next-line no-unused-vars -- required for `.length`
	    stringify: function stringify(it, replacer, space) {
	      var args = arraySlice$3(arguments);
	      var result = apply$4(WRONG_SYMBOLS_CONVERSION ? stringifyWithSymbolsFix : $stringify, null, args);
	      return ILL_FORMED_UNICODE && typeof result == 'string' ? replace$2(result, tester, fixIllFormed) : result;
	    }
	  });
	}

	var $$U = _export;
	var NATIVE_SYMBOL = symbolConstructorDetection;
	var fails$k = fails$A;
	var getOwnPropertySymbolsModule$1 = objectGetOwnPropertySymbols;
	var toObject$8 = toObject$f;

	// V8 ~ Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
	// https://bugs.chromium.org/p/v8/issues/detail?id=3443
	var FORCED$9 = !NATIVE_SYMBOL || fails$k(function () { getOwnPropertySymbolsModule$1.f(1); });

	// `Object.getOwnPropertySymbols` method
	// https://tc39.es/ecma262/#sec-object.getownpropertysymbols
	$$U({ target: 'Object', stat: true, forced: FORCED$9 }, {
	  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
	    var $getOwnPropertySymbols = getOwnPropertySymbolsModule$1.f;
	    return $getOwnPropertySymbols ? $getOwnPropertySymbols(toObject$8(it)) : [];
	  }
	});

	var defineWellKnownSymbol$k = wellKnownSymbolDefine;

	// `Symbol.asyncIterator` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.asynciterator
	defineWellKnownSymbol$k('asyncIterator');

	var defineWellKnownSymbol$j = wellKnownSymbolDefine;

	// `Symbol.hasInstance` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.hasinstance
	defineWellKnownSymbol$j('hasInstance');

	var defineWellKnownSymbol$i = wellKnownSymbolDefine;

	// `Symbol.isConcatSpreadable` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.isconcatspreadable
	defineWellKnownSymbol$i('isConcatSpreadable');

	var defineWellKnownSymbol$h = wellKnownSymbolDefine;

	// `Symbol.iterator` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.iterator
	defineWellKnownSymbol$h('iterator');

	var defineWellKnownSymbol$g = wellKnownSymbolDefine;

	// `Symbol.match` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.match
	defineWellKnownSymbol$g('match');

	var defineWellKnownSymbol$f = wellKnownSymbolDefine;

	// `Symbol.matchAll` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.matchall
	defineWellKnownSymbol$f('matchAll');

	var defineWellKnownSymbol$e = wellKnownSymbolDefine;

	// `Symbol.replace` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.replace
	defineWellKnownSymbol$e('replace');

	var defineWellKnownSymbol$d = wellKnownSymbolDefine;

	// `Symbol.search` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.search
	defineWellKnownSymbol$d('search');

	var defineWellKnownSymbol$c = wellKnownSymbolDefine;

	// `Symbol.species` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.species
	defineWellKnownSymbol$c('species');

	var defineWellKnownSymbol$b = wellKnownSymbolDefine;

	// `Symbol.split` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.split
	defineWellKnownSymbol$b('split');

	var defineWellKnownSymbol$a = wellKnownSymbolDefine;
	var defineSymbolToPrimitive = symbolDefineToPrimitive;

	// `Symbol.toPrimitive` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.toprimitive
	defineWellKnownSymbol$a('toPrimitive');

	// `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
	defineSymbolToPrimitive();

	var getBuiltIn$8 = getBuiltIn$f;
	var defineWellKnownSymbol$9 = wellKnownSymbolDefine;
	var setToStringTag$3 = setToStringTag$7;

	// `Symbol.toStringTag` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.tostringtag
	defineWellKnownSymbol$9('toStringTag');

	// `Symbol.prototype[@@toStringTag]` property
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
	setToStringTag$3(getBuiltIn$8('Symbol'), 'Symbol');

	var defineWellKnownSymbol$8 = wellKnownSymbolDefine;

	// `Symbol.unscopables` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.unscopables
	defineWellKnownSymbol$8('unscopables');

	var global$f = global$s;
	var setToStringTag$2 = setToStringTag$7;

	// JSON[@@toStringTag] property
	// https://tc39.es/ecma262/#sec-json-@@tostringtag
	setToStringTag$2(global$f.JSON, 'JSON', true);

	var path$s = path$A;

	var symbol$5 = path$s.Symbol;

	var parent$1i = symbol$5;


	var symbol$4 = parent$1i;

	var wellKnownSymbol$8 = wellKnownSymbol$p;
	var defineProperty$3 = objectDefineProperty.f;

	var METADATA$1 = wellKnownSymbol$8('metadata');
	var FunctionPrototype = Function.prototype;

	// Function.prototype[@@metadata]
	// https://github.com/tc39/proposal-decorator-metadata
	if (FunctionPrototype[METADATA$1] === undefined) {
	  defineProperty$3(FunctionPrototype, METADATA$1, {
	    value: null
	  });
	}

	var defineWellKnownSymbol$7 = wellKnownSymbolDefine;

	// `Symbol.asyncDispose` well-known symbol
	// https://github.com/tc39/proposal-async-explicit-resource-management
	defineWellKnownSymbol$7('asyncDispose');

	var defineWellKnownSymbol$6 = wellKnownSymbolDefine;

	// `Symbol.dispose` well-known symbol
	// https://github.com/tc39/proposal-explicit-resource-management
	defineWellKnownSymbol$6('dispose');

	// TODO: Remove from `core-js@4`
	var defineWellKnownSymbol$5 = wellKnownSymbolDefine;

	// `Symbol.metadata` well-known symbol
	// https://github.com/tc39/proposal-decorators
	defineWellKnownSymbol$5('metadata');

	var parent$1h = symbol$4;






	var symbol$3 = parent$1h;

	var getBuiltIn$7 = getBuiltIn$f;
	var uncurryThis$f = functionUncurryThis;

	var Symbol$4 = getBuiltIn$7('Symbol');
	var keyFor = Symbol$4.keyFor;
	var thisSymbolValue$1 = uncurryThis$f(Symbol$4.prototype.valueOf);

	// `Symbol.isRegisteredSymbol` method
	// https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregisteredsymbol
	var symbolIsRegistered = Symbol$4.isRegisteredSymbol || function isRegisteredSymbol(value) {
	  try {
	    return keyFor(thisSymbolValue$1(value)) !== undefined;
	  } catch (error) {
	    return false;
	  }
	};

	var $$T = _export;
	var isRegisteredSymbol$1 = symbolIsRegistered;

	// `Symbol.isRegisteredSymbol` method
	// https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregisteredsymbol
	$$T({ target: 'Symbol', stat: true }, {
	  isRegisteredSymbol: isRegisteredSymbol$1
	});

	var shared = sharedExports;
	var getBuiltIn$6 = getBuiltIn$f;
	var uncurryThis$e = functionUncurryThis;
	var isSymbol = isSymbol$5;
	var wellKnownSymbol$7 = wellKnownSymbol$p;

	var Symbol$3 = getBuiltIn$6('Symbol');
	var $isWellKnownSymbol = Symbol$3.isWellKnownSymbol;
	var getOwnPropertyNames$4 = getBuiltIn$6('Object', 'getOwnPropertyNames');
	var thisSymbolValue = uncurryThis$e(Symbol$3.prototype.valueOf);
	var WellKnownSymbolsStore = shared('wks');

	for (var i = 0, symbolKeys = getOwnPropertyNames$4(Symbol$3), symbolKeysLength = symbolKeys.length; i < symbolKeysLength; i++) {
	  // some old engines throws on access to some keys like `arguments` or `caller`
	  try {
	    var symbolKey = symbolKeys[i];
	    if (isSymbol(Symbol$3[symbolKey])) wellKnownSymbol$7(symbolKey);
	  } catch (error) { /* empty */ }
	}

	// `Symbol.isWellKnownSymbol` method
	// https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknownsymbol
	// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
	var symbolIsWellKnown = function isWellKnownSymbol(value) {
	  if ($isWellKnownSymbol && $isWellKnownSymbol(value)) return true;
	  try {
	    var symbol = thisSymbolValue(value);
	    for (var j = 0, keys = getOwnPropertyNames$4(WellKnownSymbolsStore), keysLength = keys.length; j < keysLength; j++) {
	      // eslint-disable-next-line eqeqeq -- polyfilled symbols case
	      if (WellKnownSymbolsStore[keys[j]] == symbol) return true;
	    }
	  } catch (error) { /* empty */ }
	  return false;
	};

	var $$S = _export;
	var isWellKnownSymbol$1 = symbolIsWellKnown;

	// `Symbol.isWellKnownSymbol` method
	// https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknownsymbol
	// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
	$$S({ target: 'Symbol', stat: true, forced: true }, {
	  isWellKnownSymbol: isWellKnownSymbol$1
	});

	var defineWellKnownSymbol$4 = wellKnownSymbolDefine;

	// `Symbol.matcher` well-known symbol
	// https://github.com/tc39/proposal-pattern-matching
	defineWellKnownSymbol$4('matcher');

	var defineWellKnownSymbol$3 = wellKnownSymbolDefine;

	// `Symbol.observable` well-known symbol
	// https://github.com/tc39/proposal-observable
	defineWellKnownSymbol$3('observable');

	var $$R = _export;
	var isRegisteredSymbol = symbolIsRegistered;

	// `Symbol.isRegistered` method
	// obsolete version of https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregisteredsymbol
	$$R({ target: 'Symbol', stat: true, name: 'isRegisteredSymbol' }, {
	  isRegistered: isRegisteredSymbol
	});

	var $$Q = _export;
	var isWellKnownSymbol = symbolIsWellKnown;

	// `Symbol.isWellKnown` method
	// obsolete version of https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknownsymbol
	// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
	$$Q({ target: 'Symbol', stat: true, name: 'isWellKnownSymbol', forced: true }, {
	  isWellKnown: isWellKnownSymbol
	});

	var defineWellKnownSymbol$2 = wellKnownSymbolDefine;

	// `Symbol.metadataKey` well-known symbol
	// https://github.com/tc39/proposal-decorator-metadata
	defineWellKnownSymbol$2('metadataKey');

	// TODO: remove from `core-js@4`
	var defineWellKnownSymbol$1 = wellKnownSymbolDefine;

	// `Symbol.patternMatch` well-known symbol
	// https://github.com/tc39/proposal-pattern-matching
	defineWellKnownSymbol$1('patternMatch');

	// TODO: remove from `core-js@4`
	var defineWellKnownSymbol = wellKnownSymbolDefine;

	defineWellKnownSymbol('replaceAll');

	var parent$1g = symbol$3;




	// TODO: Remove from `core-js@4`






	var symbol$2 = parent$1g;

	var symbol$1 = symbol$2;

	var _Symbol$1 = /*@__PURE__*/getDefaultExportFromCjs(symbol$1);

	var WrappedWellKnownSymbolModule$1 = wellKnownSymbolWrapped;

	var iterator$5 = WrappedWellKnownSymbolModule$1.f('iterator');

	var parent$1f = iterator$5;


	var iterator$4 = parent$1f;

	var parent$1e = iterator$4;

	var iterator$3 = parent$1e;

	var parent$1d = iterator$3;

	var iterator$2 = parent$1d;

	var iterator$1 = iterator$2;

	var _Symbol$iterator$1 = /*@__PURE__*/getDefaultExportFromCjs(iterator$1);

	function _typeof$1(o) {
	  "@babel/helpers - typeof";

	  return _typeof$1 = "function" == typeof _Symbol$1 && "symbol" == typeof _Symbol$iterator$1 ? function (o) {
	    return typeof o;
	  } : function (o) {
	    return o && "function" == typeof _Symbol$1 && o.constructor === _Symbol$1 && o !== _Symbol$1.prototype ? "symbol" : typeof o;
	  }, _typeof$1(o);
	}

	var WrappedWellKnownSymbolModule = wellKnownSymbolWrapped;

	var toPrimitive$4 = WrappedWellKnownSymbolModule.f('toPrimitive');

	var parent$1c = toPrimitive$4;

	var toPrimitive$3 = parent$1c;

	var parent$1b = toPrimitive$3;

	var toPrimitive$2 = parent$1b;

	var parent$1a = toPrimitive$2;

	var toPrimitive$1 = parent$1a;

	var toPrimitive = toPrimitive$1;

	var _Symbol$toPrimitive = /*@__PURE__*/getDefaultExportFromCjs(toPrimitive);

	function _toPrimitive(input, hint) {
	  if (_typeof$1(input) !== "object" || input === null) return input;
	  var prim = input[_Symbol$toPrimitive];
	  if (prim !== undefined) {
	    var res = prim.call(input, hint || "default");
	    if (_typeof$1(res) !== "object") return res;
	    throw new TypeError("@@toPrimitive must return a primitive value.");
	  }
	  return (hint === "string" ? String : Number)(input);
	}

	function _toPropertyKey(arg) {
	  var key = _toPrimitive(arg, "string");
	  return _typeof$1(key) === "symbol" ? key : String(key);
	}

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    _Object$defineProperty$1(target, _toPropertyKey(descriptor.key), descriptor);
	  }
	}
	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  _Object$defineProperty$1(Constructor, "prototype", {
	    writable: false
	  });
	  return Constructor;
	}

	var $$P = _export;
	var isArray$b = isArray$f;

	// `Array.isArray` method
	// https://tc39.es/ecma262/#sec-array.isarray
	$$P({ target: 'Array', stat: true }, {
	  isArray: isArray$b
	});

	var path$r = path$A;

	var isArray$a = path$r.Array.isArray;

	var parent$19 = isArray$a;

	var isArray$9 = parent$19;

	var parent$18 = isArray$9;

	var isArray$8 = parent$18;

	var parent$17 = isArray$8;

	var isArray$7 = parent$17;

	var isArray$6 = isArray$7;

	var _Array$isArray$1 = /*@__PURE__*/getDefaultExportFromCjs(isArray$6);

	function _arrayWithHoles(arr) {
	  if (_Array$isArray$1(arr)) return arr;
	}

	var DESCRIPTORS$8 = descriptors;
	var isArray$5 = isArray$f;

	var $TypeError$8 = TypeError;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getOwnPropertyDescriptor$8 = Object.getOwnPropertyDescriptor;

	// Safari < 13 does not throw an error in this case
	var SILENT_ON_NON_WRITABLE_LENGTH_SET = DESCRIPTORS$8 && !function () {
	  // makes no sense without proper strict mode support
	  if (this !== undefined) return true;
	  try {
	    // eslint-disable-next-line es/no-object-defineproperty -- safe
	    Object.defineProperty([], 'length', { writable: false }).length = 1;
	  } catch (error) {
	    return error instanceof TypeError;
	  }
	}();

	var arraySetLength = SILENT_ON_NON_WRITABLE_LENGTH_SET ? function (O, length) {
	  if (isArray$5(O) && !getOwnPropertyDescriptor$8(O, 'length').writable) {
	    throw new $TypeError$8('Cannot set read only .length');
	  } return O.length = length;
	} : function (O, length) {
	  return O.length = length;
	};

	var $$O = _export;
	var toObject$7 = toObject$f;
	var lengthOfArrayLike$8 = lengthOfArrayLike$e;
	var setArrayLength$1 = arraySetLength;
	var doesNotExceedSafeInteger$2 = doesNotExceedSafeInteger$4;
	var fails$j = fails$A;

	var INCORRECT_TO_LENGTH = fails$j(function () {
	  return [].push.call({ length: 0x100000000 }, 1) !== 4294967297;
	});

	// V8 and Safari <= 15.4, FF < 23 throws InternalError
	// https://bugs.chromium.org/p/v8/issues/detail?id=12681
	var properErrorOnNonWritableLength = function () {
	  try {
	    // eslint-disable-next-line es/no-object-defineproperty -- safe
	    Object.defineProperty([], 'length', { writable: false }).push();
	  } catch (error) {
	    return error instanceof TypeError;
	  }
	};

	var FORCED$8 = INCORRECT_TO_LENGTH || !properErrorOnNonWritableLength();

	// `Array.prototype.push` method
	// https://tc39.es/ecma262/#sec-array.prototype.push
	$$O({ target: 'Array', proto: true, arity: 1, forced: FORCED$8 }, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  push: function push(item) {
	    var O = toObject$7(this);
	    var len = lengthOfArrayLike$8(O);
	    var argCount = arguments.length;
	    doesNotExceedSafeInteger$2(len + argCount);
	    for (var i = 0; i < argCount; i++) {
	      O[len] = arguments[i];
	      len++;
	    }
	    setArrayLength$1(O, len);
	    return len;
	  }
	});

	var entryVirtual$j = entryVirtual$l;

	var push$9 = entryVirtual$j('Array').push;

	var isPrototypeOf$l = objectIsPrototypeOf;
	var method$h = push$9;

	var ArrayPrototype$i = Array.prototype;

	var push$8 = function (it) {
	  var own = it.push;
	  return it === ArrayPrototype$i || (isPrototypeOf$l(ArrayPrototype$i, it) && own === ArrayPrototype$i.push) ? method$h : own;
	};

	var parent$16 = push$8;

	var push$7 = parent$16;

	var parent$15 = push$7;

	var push$6 = parent$15;

	var parent$14 = push$6;

	var push$5 = parent$14;

	var push$4 = push$5;

	var _pushInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(push$4);

	function _iterableToArrayLimit(r, l) {
	  var t = null == r ? null : "undefined" != typeof _Symbol$1 && _getIteratorMethod$1(r) || r["@@iterator"];
	  if (null != t) {
	    var e,
	      n,
	      i,
	      u,
	      a = [],
	      f = !0,
	      o = !1;
	    try {
	      if (i = (t = t.call(r)).next, 0 === l) {
	        if (Object(t) !== t) return;
	        f = !1;
	      } else for (; !(f = (e = i.call(t)).done) && (_pushInstanceProperty(a).call(a, e.value), a.length !== l); f = !0);
	    } catch (r) {
	      o = !0, n = r;
	    } finally {
	      try {
	        if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
	      } finally {
	        if (o) throw n;
	      }
	    }
	    return a;
	  }
	}

	var $$N = _export;
	var isArray$4 = isArray$f;
	var isConstructor$1 = isConstructor$4;
	var isObject$c = isObject$m;
	var toAbsoluteIndex$2 = toAbsoluteIndex$5;
	var lengthOfArrayLike$7 = lengthOfArrayLike$e;
	var toIndexedObject$3 = toIndexedObject$b;
	var createProperty$2 = createProperty$6;
	var wellKnownSymbol$6 = wellKnownSymbol$p;
	var arrayMethodHasSpeciesSupport$3 = arrayMethodHasSpeciesSupport$5;
	var nativeSlice = arraySlice$6;

	var HAS_SPECIES_SUPPORT$3 = arrayMethodHasSpeciesSupport$3('slice');

	var SPECIES$3 = wellKnownSymbol$6('species');
	var $Array = Array;
	var max$1 = Math.max;

	// `Array.prototype.slice` method
	// https://tc39.es/ecma262/#sec-array.prototype.slice
	// fallback for not array-like ES3 strings and DOM objects
	$$N({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT$3 }, {
	  slice: function slice(start, end) {
	    var O = toIndexedObject$3(this);
	    var length = lengthOfArrayLike$7(O);
	    var k = toAbsoluteIndex$2(start, length);
	    var fin = toAbsoluteIndex$2(end === undefined ? length : end, length);
	    // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible
	    var Constructor, result, n;
	    if (isArray$4(O)) {
	      Constructor = O.constructor;
	      // cross-realm fallback
	      if (isConstructor$1(Constructor) && (Constructor === $Array || isArray$4(Constructor.prototype))) {
	        Constructor = undefined;
	      } else if (isObject$c(Constructor)) {
	        Constructor = Constructor[SPECIES$3];
	        if (Constructor === null) Constructor = undefined;
	      }
	      if (Constructor === $Array || Constructor === undefined) {
	        return nativeSlice(O, k, fin);
	      }
	    }
	    result = new (Constructor === undefined ? $Array : Constructor)(max$1(fin - k, 0));
	    for (n = 0; k < fin; k++, n++) if (k in O) createProperty$2(result, n, O[k]);
	    result.length = n;
	    return result;
	  }
	});

	var entryVirtual$i = entryVirtual$l;

	var slice$6 = entryVirtual$i('Array').slice;

	var isPrototypeOf$k = objectIsPrototypeOf;
	var method$g = slice$6;

	var ArrayPrototype$h = Array.prototype;

	var slice$5 = function (it) {
	  var own = it.slice;
	  return it === ArrayPrototype$h || (isPrototypeOf$k(ArrayPrototype$h, it) && own === ArrayPrototype$h.slice) ? method$g : own;
	};

	var parent$13 = slice$5;

	var slice$4 = parent$13;

	var parent$12 = slice$4;

	var slice$3 = parent$12;

	var parent$11 = slice$3;

	var slice$2 = parent$11;

	var slice$1 = slice$2;

	var _sliceInstanceProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(slice$1);

	var parent$10 = from$4;

	var from$2 = parent$10;

	var parent$$ = from$2;

	var from$1 = parent$$;

	var from = from$1;

	var _Array$from = /*@__PURE__*/getDefaultExportFromCjs(from);

	function _arrayLikeToArray$8(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;
	  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
	  return arr2;
	}

	function _unsupportedIterableToArray$8(o, minLen) {
	  var _context;
	  if (!o) return;
	  if (typeof o === "string") return _arrayLikeToArray$8(o, minLen);
	  var n = _sliceInstanceProperty$1(_context = Object.prototype.toString.call(o)).call(_context, 8, -1);
	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return _Array$from(o);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$8(o, minLen);
	}

	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _slicedToArray(arr, i) {
	  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray$8(arr, i) || _nonIterableRest();
	}

	function _arrayWithoutHoles(arr) {
	  if (_Array$isArray$1(arr)) return _arrayLikeToArray$8(arr);
	}

	function _iterableToArray(iter) {
	  if (typeof _Symbol$1 !== "undefined" && _getIteratorMethod$1(iter) != null || iter["@@iterator"] != null) return _Array$from(iter);
	}

	function _nonIterableSpread() {
	  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _toConsumableArray(arr) {
	  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray$8(arr) || _nonIterableSpread();
	}

	var symbol = symbol$4;

	var _Symbol = /*@__PURE__*/getDefaultExportFromCjs(symbol);

	var entryVirtual$h = entryVirtual$l;

	var concat$4 = entryVirtual$h('Array').concat;

	var isPrototypeOf$j = objectIsPrototypeOf;
	var method$f = concat$4;

	var ArrayPrototype$g = Array.prototype;

	var concat$3 = function (it) {
	  var own = it.concat;
	  return it === ArrayPrototype$g || (isPrototypeOf$j(ArrayPrototype$g, it) && own === ArrayPrototype$g.concat) ? method$f : own;
	};

	var parent$_ = concat$3;

	var concat$2 = parent$_;

	var concat$1 = concat$2;

	var _concatInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(concat$1);

	var slice = slice$4;

	var _sliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(slice);

	var getBuiltIn$5 = getBuiltIn$f;
	var uncurryThis$d = functionUncurryThis;
	var getOwnPropertyNamesModule$1 = objectGetOwnPropertyNames;
	var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
	var anObject$6 = anObject$f;

	var concat = uncurryThis$d([].concat);

	// all object keys, includes non-enumerable and symbols
	var ownKeys$b = getBuiltIn$5('Reflect', 'ownKeys') || function ownKeys(it) {
	  var keys = getOwnPropertyNamesModule$1.f(anObject$6(it));
	  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
	  return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
	};

	var $$M = _export;
	var ownKeys$a = ownKeys$b;

	// `Reflect.ownKeys` method
	// https://tc39.es/ecma262/#sec-reflect.ownkeys
	$$M({ target: 'Reflect', stat: true }, {
	  ownKeys: ownKeys$a
	});

	var path$q = path$A;

	var ownKeys$9 = path$q.Reflect.ownKeys;

	var parent$Z = ownKeys$9;

	var ownKeys$8 = parent$Z;

	var ownKeys$7 = ownKeys$8;

	var _Reflect$ownKeys = /*@__PURE__*/getDefaultExportFromCjs(ownKeys$7);

	var isArray$3 = isArray$9;

	var _Array$isArray = /*@__PURE__*/getDefaultExportFromCjs(isArray$3);

	var $$L = _export;
	var $map = arrayIteration.map;
	var arrayMethodHasSpeciesSupport$2 = arrayMethodHasSpeciesSupport$5;

	var HAS_SPECIES_SUPPORT$2 = arrayMethodHasSpeciesSupport$2('map');

	// `Array.prototype.map` method
	// https://tc39.es/ecma262/#sec-array.prototype.map
	// with adding support of @@species
	$$L({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT$2 }, {
	  map: function map(callbackfn /* , thisArg */) {
	    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$g = entryVirtual$l;

	var map$6 = entryVirtual$g('Array').map;

	var isPrototypeOf$i = objectIsPrototypeOf;
	var method$e = map$6;

	var ArrayPrototype$f = Array.prototype;

	var map$5 = function (it) {
	  var own = it.map;
	  return it === ArrayPrototype$f || (isPrototypeOf$i(ArrayPrototype$f, it) && own === ArrayPrototype$f.map) ? method$e : own;
	};

	var parent$Y = map$5;

	var map$4 = parent$Y;

	var map$3 = map$4;

	var _mapInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(map$3);

	var $$K = _export;
	var toObject$6 = toObject$f;
	var nativeKeys = objectKeys$4;
	var fails$i = fails$A;

	var FAILS_ON_PRIMITIVES$3 = fails$i(function () { nativeKeys(1); });

	// `Object.keys` method
	// https://tc39.es/ecma262/#sec-object.keys
	$$K({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES$3 }, {
	  keys: function keys(it) {
	    return nativeKeys(toObject$6(it));
	  }
	});

	var path$p = path$A;

	var keys$6 = path$p.Object.keys;

	var parent$X = keys$6;

	var keys$5 = parent$X;

	var keys$4 = keys$5;

	var _Object$keys = /*@__PURE__*/getDefaultExportFromCjs(keys$4);

	// TODO: Remove from `core-js@4`
	var $$J = _export;
	var uncurryThis$c = functionUncurryThis;

	var $Date = Date;
	var thisTimeValue = uncurryThis$c($Date.prototype.getTime);

	// `Date.now` method
	// https://tc39.es/ecma262/#sec-date.now
	$$J({ target: 'Date', stat: true }, {
	  now: function now() {
	    return thisTimeValue(new $Date());
	  }
	});

	var path$o = path$A;

	var now$3 = path$o.Date.now;

	var parent$W = now$3;

	var now$2 = parent$W;

	var now$1 = now$2;

	var _Date$now = /*@__PURE__*/getDefaultExportFromCjs(now$1);

	var fails$h = fails$A;

	var arrayMethodIsStrict$6 = function (METHOD_NAME, argument) {
	  var method = [][METHOD_NAME];
	  return !!method && fails$h(function () {
	    // eslint-disable-next-line no-useless-call -- required for testing
	    method.call(null, argument || function () { return 1; }, 1);
	  });
	};

	var $forEach = arrayIteration.forEach;
	var arrayMethodIsStrict$5 = arrayMethodIsStrict$6;

	var STRICT_METHOD$3 = arrayMethodIsStrict$5('forEach');

	// `Array.prototype.forEach` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.foreach
	var arrayForEach = !STRICT_METHOD$3 ? function forEach(callbackfn /* , thisArg */) {
	  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	// eslint-disable-next-line es/no-array-prototype-foreach -- safe
	} : [].forEach;

	var $$I = _export;
	var forEach$9 = arrayForEach;

	// `Array.prototype.forEach` method
	// https://tc39.es/ecma262/#sec-array.prototype.foreach
	// eslint-disable-next-line es/no-array-prototype-foreach -- safe
	$$I({ target: 'Array', proto: true, forced: [].forEach !== forEach$9 }, {
	  forEach: forEach$9
	});

	var entryVirtual$f = entryVirtual$l;

	var forEach$8 = entryVirtual$f('Array').forEach;

	var parent$V = forEach$8;

	var forEach$7 = parent$V;

	var classof$6 = classof$f;
	var hasOwn$8 = hasOwnProperty_1;
	var isPrototypeOf$h = objectIsPrototypeOf;
	var method$d = forEach$7;

	var ArrayPrototype$e = Array.prototype;

	var DOMIterables$3 = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var forEach$6 = function (it) {
	  var own = it.forEach;
	  return it === ArrayPrototype$e || (isPrototypeOf$h(ArrayPrototype$e, it) && own === ArrayPrototype$e.forEach)
	    || hasOwn$8(DOMIterables$3, classof$6(it)) ? method$d : own;
	};

	var forEach$5 = forEach$6;

	var _forEachInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(forEach$5);

	var $$H = _export;
	var uncurryThis$b = functionUncurryThis;
	var isArray$2 = isArray$f;

	var nativeReverse = uncurryThis$b([].reverse);
	var test$1 = [1, 2];

	// `Array.prototype.reverse` method
	// https://tc39.es/ecma262/#sec-array.prototype.reverse
	// fix for Safari 12.0 bug
	// https://bugs.webkit.org/show_bug.cgi?id=188794
	$$H({ target: 'Array', proto: true, forced: String(test$1) === String(test$1.reverse()) }, {
	  reverse: function reverse() {
	    // eslint-disable-next-line no-self-assign -- dirty hack
	    if (isArray$2(this)) this.length = this.length;
	    return nativeReverse(this);
	  }
	});

	var entryVirtual$e = entryVirtual$l;

	var reverse$6 = entryVirtual$e('Array').reverse;

	var isPrototypeOf$g = objectIsPrototypeOf;
	var method$c = reverse$6;

	var ArrayPrototype$d = Array.prototype;

	var reverse$5 = function (it) {
	  var own = it.reverse;
	  return it === ArrayPrototype$d || (isPrototypeOf$g(ArrayPrototype$d, it) && own === ArrayPrototype$d.reverse) ? method$c : own;
	};

	var parent$U = reverse$5;

	var reverse$4 = parent$U;

	var reverse$3 = reverse$4;

	var _reverseInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reverse$3);

	var tryToString$2 = tryToString$6;

	var $TypeError$7 = TypeError;

	var deletePropertyOrThrow$2 = function (O, P) {
	  if (!delete O[P]) throw new $TypeError$7('Cannot delete property ' + tryToString$2(P) + ' of ' + tryToString$2(O));
	};

	var $$G = _export;
	var toObject$5 = toObject$f;
	var toAbsoluteIndex$1 = toAbsoluteIndex$5;
	var toIntegerOrInfinity = toIntegerOrInfinity$4;
	var lengthOfArrayLike$6 = lengthOfArrayLike$e;
	var setArrayLength = arraySetLength;
	var doesNotExceedSafeInteger$1 = doesNotExceedSafeInteger$4;
	var arraySpeciesCreate$1 = arraySpeciesCreate$4;
	var createProperty$1 = createProperty$6;
	var deletePropertyOrThrow$1 = deletePropertyOrThrow$2;
	var arrayMethodHasSpeciesSupport$1 = arrayMethodHasSpeciesSupport$5;

	var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport$1('splice');

	var max = Math.max;
	var min = Math.min;

	// `Array.prototype.splice` method
	// https://tc39.es/ecma262/#sec-array.prototype.splice
	// with adding support of @@species
	$$G({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT$1 }, {
	  splice: function splice(start, deleteCount /* , ...items */) {
	    var O = toObject$5(this);
	    var len = lengthOfArrayLike$6(O);
	    var actualStart = toAbsoluteIndex$1(start, len);
	    var argumentsLength = arguments.length;
	    var insertCount, actualDeleteCount, A, k, from, to;
	    if (argumentsLength === 0) {
	      insertCount = actualDeleteCount = 0;
	    } else if (argumentsLength === 1) {
	      insertCount = 0;
	      actualDeleteCount = len - actualStart;
	    } else {
	      insertCount = argumentsLength - 2;
	      actualDeleteCount = min(max(toIntegerOrInfinity(deleteCount), 0), len - actualStart);
	    }
	    doesNotExceedSafeInteger$1(len + insertCount - actualDeleteCount);
	    A = arraySpeciesCreate$1(O, actualDeleteCount);
	    for (k = 0; k < actualDeleteCount; k++) {
	      from = actualStart + k;
	      if (from in O) createProperty$1(A, k, O[from]);
	    }
	    A.length = actualDeleteCount;
	    if (insertCount < actualDeleteCount) {
	      for (k = actualStart; k < len - actualDeleteCount; k++) {
	        from = k + actualDeleteCount;
	        to = k + insertCount;
	        if (from in O) O[to] = O[from];
	        else deletePropertyOrThrow$1(O, to);
	      }
	      for (k = len; k > len - actualDeleteCount + insertCount; k--) deletePropertyOrThrow$1(O, k - 1);
	    } else if (insertCount > actualDeleteCount) {
	      for (k = len - actualDeleteCount; k > actualStart; k--) {
	        from = k + actualDeleteCount - 1;
	        to = k + insertCount - 1;
	        if (from in O) O[to] = O[from];
	        else deletePropertyOrThrow$1(O, to);
	      }
	    }
	    for (k = 0; k < insertCount; k++) {
	      O[k + actualStart] = arguments[k + 2];
	    }
	    setArrayLength(O, len - actualDeleteCount + insertCount);
	    return A;
	  }
	});

	var entryVirtual$d = entryVirtual$l;

	var splice$4 = entryVirtual$d('Array').splice;

	var isPrototypeOf$f = objectIsPrototypeOf;
	var method$b = splice$4;

	var ArrayPrototype$c = Array.prototype;

	var splice$3 = function (it) {
	  var own = it.splice;
	  return it === ArrayPrototype$c || (isPrototypeOf$f(ArrayPrototype$c, it) && own === ArrayPrototype$c.splice) ? method$b : own;
	};

	var parent$T = splice$3;

	var splice$2 = parent$T;

	var splice$1 = splice$2;

	var _spliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(splice$1);

	var $$F = _export;
	var $includes = arrayIncludes.includes;
	var fails$g = fails$A;

	// FF99+ bug
	var BROKEN_ON_SPARSE = fails$g(function () {
	  // eslint-disable-next-line es/no-array-prototype-includes -- detection
	  return !Array(1).includes();
	});

	// `Array.prototype.includes` method
	// https://tc39.es/ecma262/#sec-array.prototype.includes
	$$F({ target: 'Array', proto: true, forced: BROKEN_ON_SPARSE }, {
	  includes: function includes(el /* , fromIndex = 0 */) {
	    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$c = entryVirtual$l;

	var includes$4 = entryVirtual$c('Array').includes;

	var isObject$b = isObject$m;
	var classof$5 = classofRaw$2;
	var wellKnownSymbol$5 = wellKnownSymbol$p;

	var MATCH$1 = wellKnownSymbol$5('match');

	// `IsRegExp` abstract operation
	// https://tc39.es/ecma262/#sec-isregexp
	var isRegexp = function (it) {
	  var isRegExp;
	  return isObject$b(it) && ((isRegExp = it[MATCH$1]) !== undefined ? !!isRegExp : classof$5(it) === 'RegExp');
	};

	var isRegExp = isRegexp;

	var $TypeError$6 = TypeError;

	var notARegexp = function (it) {
	  if (isRegExp(it)) {
	    throw new $TypeError$6("The method doesn't accept regular expressions");
	  } return it;
	};

	var wellKnownSymbol$4 = wellKnownSymbol$p;

	var MATCH = wellKnownSymbol$4('match');

	var correctIsRegexpLogic = function (METHOD_NAME) {
	  var regexp = /./;
	  try {
	    '/./'[METHOD_NAME](regexp);
	  } catch (error1) {
	    try {
	      regexp[MATCH] = false;
	      return '/./'[METHOD_NAME](regexp);
	    } catch (error2) { /* empty */ }
	  } return false;
	};

	var $$E = _export;
	var uncurryThis$a = functionUncurryThis;
	var notARegExp = notARegexp;
	var requireObjectCoercible$1 = requireObjectCoercible$5;
	var toString$5 = toString$b;
	var correctIsRegExpLogic = correctIsRegexpLogic;

	var stringIndexOf = uncurryThis$a(''.indexOf);

	// `String.prototype.includes` method
	// https://tc39.es/ecma262/#sec-string.prototype.includes
	$$E({ target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') }, {
	  includes: function includes(searchString /* , position = 0 */) {
	    return !!~stringIndexOf(
	      toString$5(requireObjectCoercible$1(this)),
	      toString$5(notARegExp(searchString)),
	      arguments.length > 1 ? arguments[1] : undefined
	    );
	  }
	});

	var entryVirtual$b = entryVirtual$l;

	var includes$3 = entryVirtual$b('String').includes;

	var isPrototypeOf$e = objectIsPrototypeOf;
	var arrayMethod = includes$4;
	var stringMethod = includes$3;

	var ArrayPrototype$b = Array.prototype;
	var StringPrototype = String.prototype;

	var includes$2 = function (it) {
	  var own = it.includes;
	  if (it === ArrayPrototype$b || (isPrototypeOf$e(ArrayPrototype$b, it) && own === ArrayPrototype$b.includes)) return arrayMethod;
	  if (typeof it == 'string' || it === StringPrototype || (isPrototypeOf$e(StringPrototype, it) && own === StringPrototype.includes)) {
	    return stringMethod;
	  } return own;
	};

	var parent$S = includes$2;

	var includes$1 = parent$S;

	var includes = includes$1;

	var _includesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(includes);

	var $$D = _export;
	var fails$f = fails$A;
	var toObject$4 = toObject$f;
	var nativeGetPrototypeOf = objectGetPrototypeOf$1;
	var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;

	var FAILS_ON_PRIMITIVES$2 = fails$f(function () { nativeGetPrototypeOf(1); });

	// `Object.getPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.getprototypeof
	$$D({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES$2, sham: !CORRECT_PROTOTYPE_GETTER }, {
	  getPrototypeOf: function getPrototypeOf(it) {
	    return nativeGetPrototypeOf(toObject$4(it));
	  }
	});

	var path$n = path$A;

	var getPrototypeOf$7 = path$n.Object.getPrototypeOf;

	var parent$R = getPrototypeOf$7;

	var getPrototypeOf$6 = parent$R;

	var getPrototypeOf$5 = getPrototypeOf$6;

	var _Object$getPrototypeOf$1 = /*@__PURE__*/getDefaultExportFromCjs(getPrototypeOf$5);

	var $$C = _export;
	var $filter = arrayIteration.filter;
	var arrayMethodHasSpeciesSupport = arrayMethodHasSpeciesSupport$5;

	var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter');

	// `Array.prototype.filter` method
	// https://tc39.es/ecma262/#sec-array.prototype.filter
	// with adding support of @@species
	$$C({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
	  filter: function filter(callbackfn /* , thisArg */) {
	    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$a = entryVirtual$l;

	var filter$3 = entryVirtual$a('Array').filter;

	var isPrototypeOf$d = objectIsPrototypeOf;
	var method$a = filter$3;

	var ArrayPrototype$a = Array.prototype;

	var filter$2 = function (it) {
	  var own = it.filter;
	  return it === ArrayPrototype$a || (isPrototypeOf$d(ArrayPrototype$a, it) && own === ArrayPrototype$a.filter) ? method$a : own;
	};

	var parent$Q = filter$2;

	var filter$1 = parent$Q;

	var filter = filter$1;

	var _filterInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(filter);

	var DESCRIPTORS$7 = descriptors;
	var fails$e = fails$A;
	var uncurryThis$9 = functionUncurryThis;
	var objectGetPrototypeOf = objectGetPrototypeOf$1;
	var objectKeys = objectKeys$4;
	var toIndexedObject$2 = toIndexedObject$b;
	var $propertyIsEnumerable = objectPropertyIsEnumerable.f;

	var propertyIsEnumerable = uncurryThis$9($propertyIsEnumerable);
	var push$3 = uncurryThis$9([].push);

	// in some IE versions, `propertyIsEnumerable` returns incorrect result on integer keys
	// of `null` prototype objects
	var IE_BUG = DESCRIPTORS$7 && fails$e(function () {
	  // eslint-disable-next-line es/no-object-create -- safe
	  var O = Object.create(null);
	  O[2] = 2;
	  return !propertyIsEnumerable(O, 2);
	});

	// `Object.{ entries, values }` methods implementation
	var createMethod$2 = function (TO_ENTRIES) {
	  return function (it) {
	    var O = toIndexedObject$2(it);
	    var keys = objectKeys(O);
	    var IE_WORKAROUND = IE_BUG && objectGetPrototypeOf(O) === null;
	    var length = keys.length;
	    var i = 0;
	    var result = [];
	    var key;
	    while (length > i) {
	      key = keys[i++];
	      if (!DESCRIPTORS$7 || (IE_WORKAROUND ? key in O : propertyIsEnumerable(O, key))) {
	        push$3(result, TO_ENTRIES ? [key, O[key]] : O[key]);
	      }
	    }
	    return result;
	  };
	};

	var objectToArray = {
	  // `Object.entries` method
	  // https://tc39.es/ecma262/#sec-object.entries
	  entries: createMethod$2(true),
	  // `Object.values` method
	  // https://tc39.es/ecma262/#sec-object.values
	  values: createMethod$2(false)
	};

	var $$B = _export;
	var $values = objectToArray.values;

	// `Object.values` method
	// https://tc39.es/ecma262/#sec-object.values
	$$B({ target: 'Object', stat: true }, {
	  values: function values(O) {
	    return $values(O);
	  }
	});

	var path$m = path$A;

	var values$6 = path$m.Object.values;

	var parent$P = values$6;

	var values$5 = parent$P;

	var values$4 = values$5;

	var _Object$values = /*@__PURE__*/getDefaultExportFromCjs(values$4);

	// a string of all valid unicode whitespaces
	var whitespaces$3 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
	  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

	var uncurryThis$8 = functionUncurryThis;
	var requireObjectCoercible = requireObjectCoercible$5;
	var toString$4 = toString$b;
	var whitespaces$2 = whitespaces$3;

	var replace$1 = uncurryThis$8(''.replace);
	var ltrim = RegExp('^[' + whitespaces$2 + ']+');
	var rtrim = RegExp('(^|[^' + whitespaces$2 + '])[' + whitespaces$2 + ']+$');

	// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
	var createMethod$1 = function (TYPE) {
	  return function ($this) {
	    var string = toString$4(requireObjectCoercible($this));
	    if (TYPE & 1) string = replace$1(string, ltrim, '');
	    if (TYPE & 2) string = replace$1(string, rtrim, '$1');
	    return string;
	  };
	};

	var stringTrim = {
	  // `String.prototype.{ trimLeft, trimStart }` methods
	  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
	  start: createMethod$1(1),
	  // `String.prototype.{ trimRight, trimEnd }` methods
	  // https://tc39.es/ecma262/#sec-string.prototype.trimend
	  end: createMethod$1(2),
	  // `String.prototype.trim` method
	  // https://tc39.es/ecma262/#sec-string.prototype.trim
	  trim: createMethod$1(3)
	};

	var global$e = global$s;
	var fails$d = fails$A;
	var uncurryThis$7 = functionUncurryThis;
	var toString$3 = toString$b;
	var trim$1 = stringTrim.trim;
	var whitespaces$1 = whitespaces$3;

	var $parseInt$1 = global$e.parseInt;
	var Symbol$2 = global$e.Symbol;
	var ITERATOR$1 = Symbol$2 && Symbol$2.iterator;
	var hex = /^[+-]?0x/i;
	var exec = uncurryThis$7(hex.exec);
	var FORCED$7 = $parseInt$1(whitespaces$1 + '08') !== 8 || $parseInt$1(whitespaces$1 + '0x16') !== 22
	  // MS Edge 18- broken with boxed symbols
	  || (ITERATOR$1 && !fails$d(function () { $parseInt$1(Object(ITERATOR$1)); }));

	// `parseInt` method
	// https://tc39.es/ecma262/#sec-parseint-string-radix
	var numberParseInt = FORCED$7 ? function parseInt(string, radix) {
	  var S = trim$1(toString$3(string));
	  return $parseInt$1(S, (radix >>> 0) || (exec(hex, S) ? 16 : 10));
	} : $parseInt$1;

	var $$A = _export;
	var $parseInt = numberParseInt;

	// `parseInt` method
	// https://tc39.es/ecma262/#sec-parseint-string-radix
	$$A({ global: true, forced: parseInt !== $parseInt }, {
	  parseInt: $parseInt
	});

	var path$l = path$A;

	var _parseInt$3 = path$l.parseInt;

	var parent$O = _parseInt$3;

	var _parseInt$2 = parent$O;

	var _parseInt = _parseInt$2;

	var _parseInt$1 = /*@__PURE__*/getDefaultExportFromCjs(_parseInt);

	/* eslint-disable es/no-array-prototype-indexof -- required for testing */
	var $$z = _export;
	var uncurryThis$6 = functionUncurryThisClause;
	var $indexOf = arrayIncludes.indexOf;
	var arrayMethodIsStrict$4 = arrayMethodIsStrict$6;

	var nativeIndexOf = uncurryThis$6([].indexOf);

	var NEGATIVE_ZERO = !!nativeIndexOf && 1 / nativeIndexOf([1], 1, -0) < 0;
	var FORCED$6 = NEGATIVE_ZERO || !arrayMethodIsStrict$4('indexOf');

	// `Array.prototype.indexOf` method
	// https://tc39.es/ecma262/#sec-array.prototype.indexof
	$$z({ target: 'Array', proto: true, forced: FORCED$6 }, {
	  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
	    var fromIndex = arguments.length > 1 ? arguments[1] : undefined;
	    return NEGATIVE_ZERO
	      // convert -0 to +0
	      ? nativeIndexOf(this, searchElement, fromIndex) || 0
	      : $indexOf(this, searchElement, fromIndex);
	  }
	});

	var entryVirtual$9 = entryVirtual$l;

	var indexOf$3 = entryVirtual$9('Array').indexOf;

	var isPrototypeOf$c = objectIsPrototypeOf;
	var method$9 = indexOf$3;

	var ArrayPrototype$9 = Array.prototype;

	var indexOf$2 = function (it) {
	  var own = it.indexOf;
	  return it === ArrayPrototype$9 || (isPrototypeOf$c(ArrayPrototype$9, it) && own === ArrayPrototype$9.indexOf) ? method$9 : own;
	};

	var parent$N = indexOf$2;

	var indexOf$1 = parent$N;

	var indexOf = indexOf$1;

	var _indexOfInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(indexOf);

	var $$y = _export;
	var $entries = objectToArray.entries;

	// `Object.entries` method
	// https://tc39.es/ecma262/#sec-object.entries
	$$y({ target: 'Object', stat: true }, {
	  entries: function entries(O) {
	    return $entries(O);
	  }
	});

	var path$k = path$A;

	var entries$6 = path$k.Object.entries;

	var parent$M = entries$6;

	var entries$5 = parent$M;

	var entries$4 = entries$5;

	var _Object$entries2 = /*@__PURE__*/getDefaultExportFromCjs(entries$4);

	// TODO: Remove from `core-js@4`
	var $$x = _export;
	var DESCRIPTORS$6 = descriptors;
	var create$9 = objectCreate;

	// `Object.create` method
	// https://tc39.es/ecma262/#sec-object.create
	$$x({ target: 'Object', stat: true, sham: !DESCRIPTORS$6 }, {
	  create: create$9
	});

	var path$j = path$A;

	var Object$4 = path$j.Object;

	var create$8 = function create(P, D) {
	  return Object$4.create(P, D);
	};

	var parent$L = create$8;

	var create$7 = parent$L;

	var create$6 = create$7;

	var _Object$create$1 = /*@__PURE__*/getDefaultExportFromCjs(create$6);

	var path$i = path$A;
	var apply$3 = functionApply;

	// eslint-disable-next-line es/no-json -- safe
	if (!path$i.JSON) path$i.JSON = { stringify: JSON.stringify };

	// eslint-disable-next-line no-unused-vars -- required for `.length`
	var stringify$2 = function stringify(it, replacer, space) {
	  return apply$3(path$i.JSON.stringify, null, arguments);
	};

	var parent$K = stringify$2;

	var stringify$1 = parent$K;

	var stringify = stringify$1;

	var _JSON$stringify = /*@__PURE__*/getDefaultExportFromCjs(stringify);

	/* global Bun -- Deno case */
	var engineIsBun = typeof Bun == 'function' && Bun && typeof Bun.version == 'string';

	var $TypeError$5 = TypeError;

	var validateArgumentsLength$2 = function (passed, required) {
	  if (passed < required) throw new $TypeError$5('Not enough arguments');
	  return passed;
	};

	var global$d = global$s;
	var apply$2 = functionApply;
	var isCallable$5 = isCallable$m;
	var ENGINE_IS_BUN = engineIsBun;
	var USER_AGENT = engineUserAgent;
	var arraySlice$2 = arraySlice$6;
	var validateArgumentsLength$1 = validateArgumentsLength$2;

	var Function$2 = global$d.Function;
	// dirty IE9- and Bun 0.3.0- checks
	var WRAP = /MSIE .\./.test(USER_AGENT) || ENGINE_IS_BUN && (function () {
	  var version = global$d.Bun.version.split('.');
	  return version.length < 3 || version[0] === '0' && (version[1] < 3 || version[1] === '3' && version[2] === '0');
	})();

	// IE9- / Bun 0.3.0- setTimeout / setInterval / setImmediate additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#timers
	// https://github.com/oven-sh/bun/issues/1633
	var schedulersFix$2 = function (scheduler, hasTimeArg) {
	  var firstParamIndex = hasTimeArg ? 2 : 1;
	  return WRAP ? function (handler, timeout /* , ...arguments */) {
	    var boundArgs = validateArgumentsLength$1(arguments.length, 1) > firstParamIndex;
	    var fn = isCallable$5(handler) ? handler : Function$2(handler);
	    var params = boundArgs ? arraySlice$2(arguments, firstParamIndex) : [];
	    var callback = boundArgs ? function () {
	      apply$2(fn, this, params);
	    } : fn;
	    return hasTimeArg ? scheduler(callback, timeout) : scheduler(callback);
	  } : scheduler;
	};

	var $$w = _export;
	var global$c = global$s;
	var schedulersFix$1 = schedulersFix$2;

	var setInterval$2 = schedulersFix$1(global$c.setInterval, true);

	// Bun / IE9- setInterval additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-setinterval
	$$w({ global: true, bind: true, forced: global$c.setInterval !== setInterval$2 }, {
	  setInterval: setInterval$2
	});

	var $$v = _export;
	var global$b = global$s;
	var schedulersFix = schedulersFix$2;

	var setTimeout$3 = schedulersFix(global$b.setTimeout, true);

	// Bun / IE9- setTimeout additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-settimeout
	$$v({ global: true, bind: true, forced: global$b.setTimeout !== setTimeout$3 }, {
	  setTimeout: setTimeout$3
	});

	var path$h = path$A;

	var setTimeout$2 = path$h.setTimeout;

	var setTimeout$1 = setTimeout$2;

	var _setTimeout = /*@__PURE__*/getDefaultExportFromCjs(setTimeout$1);

	var toObject$3 = toObject$f;
	var toAbsoluteIndex = toAbsoluteIndex$5;
	var lengthOfArrayLike$5 = lengthOfArrayLike$e;

	// `Array.prototype.fill` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.fill
	var arrayFill = function fill(value /* , start = 0, end = @length */) {
	  var O = toObject$3(this);
	  var length = lengthOfArrayLike$5(O);
	  var argumentsLength = arguments.length;
	  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
	  var end = argumentsLength > 2 ? arguments[2] : undefined;
	  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
	  while (endPos > index) O[index++] = value;
	  return O;
	};

	var $$u = _export;
	var fill$4 = arrayFill;

	// `Array.prototype.fill` method
	// https://tc39.es/ecma262/#sec-array.prototype.fill
	$$u({ target: 'Array', proto: true }, {
	  fill: fill$4
	});

	var entryVirtual$8 = entryVirtual$l;

	var fill$3 = entryVirtual$8('Array').fill;

	var isPrototypeOf$b = objectIsPrototypeOf;
	var method$8 = fill$3;

	var ArrayPrototype$8 = Array.prototype;

	var fill$2 = function (it) {
	  var own = it.fill;
	  return it === ArrayPrototype$8 || (isPrototypeOf$b(ArrayPrototype$8, it) && own === ArrayPrototype$8.fill) ? method$8 : own;
	};

	var parent$J = fill$2;

	var fill$1 = parent$J;

	var fill = fill$1;

	var _fillInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(fill);

	/*! Hammer.JS - v2.0.17-rc - 2019-12-16
	 * http://naver.github.io/egjs
	 *
	 * Forked By Naver egjs
	 * Copyright (c) hammerjs
	 * Licensed under the MIT license */
	function _extends() {
	  _extends = Object.assign || function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];

	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }

	    return target;
	  };

	  return _extends.apply(this, arguments);
	}

	function _inheritsLoose(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  subClass.__proto__ = superClass;
	}

	function _assertThisInitialized$1(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}

	/**
	 * @private
	 * extend object.
	 * means that properties in dest will be overwritten by the ones in src.
	 * @param {Object} target
	 * @param {...Object} objects_to_assign
	 * @returns {Object} target
	 */
	var assign;

	if (typeof Object.assign !== 'function') {
	  assign = function assign(target) {
	    if (target === undefined || target === null) {
	      throw new TypeError('Cannot convert undefined or null to object');
	    }

	    var output = Object(target);

	    for (var index = 1; index < arguments.length; index++) {
	      var source = arguments[index];

	      if (source !== undefined && source !== null) {
	        for (var nextKey in source) {
	          if (source.hasOwnProperty(nextKey)) {
	            output[nextKey] = source[nextKey];
	          }
	        }
	      }
	    }

	    return output;
	  };
	} else {
	  assign = Object.assign;
	}

	var assign$1 = assign;

	var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
	var TEST_ELEMENT = typeof document === "undefined" ? {
	  style: {}
	} : document.createElement('div');
	var TYPE_FUNCTION = 'function';
	var round = Math.round,
	    abs$1 = Math.abs;
	var now = Date.now;

	/**
	 * @private
	 * get the prefixed property
	 * @param {Object} obj
	 * @param {String} property
	 * @returns {String|Undefined} prefixed
	 */

	function prefixed(obj, property) {
	  var prefix;
	  var prop;
	  var camelProp = property[0].toUpperCase() + property.slice(1);
	  var i = 0;

	  while (i < VENDOR_PREFIXES.length) {
	    prefix = VENDOR_PREFIXES[i];
	    prop = prefix ? prefix + camelProp : property;

	    if (prop in obj) {
	      return prop;
	    }

	    i++;
	  }

	  return undefined;
	}

	/* eslint-disable no-new-func, no-nested-ternary */
	var win;

	if (typeof window === "undefined") {
	  // window is undefined in node.js
	  win = {};
	} else {
	  win = window;
	}

	var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
	var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;
	function getTouchActionProps() {
	  if (!NATIVE_TOUCH_ACTION) {
	    return false;
	  }

	  var touchMap = {};
	  var cssSupports = win.CSS && win.CSS.supports;
	  ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function (val) {
	    // If css.supports is not supported but there is native touch-action assume it supports
	    // all values. This is the case for IE 10 and 11.
	    return touchMap[val] = cssSupports ? win.CSS.supports('touch-action', val) : true;
	  });
	  return touchMap;
	}

	var TOUCH_ACTION_COMPUTE = 'compute';
	var TOUCH_ACTION_AUTO = 'auto';
	var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented

	var TOUCH_ACTION_NONE = 'none';
	var TOUCH_ACTION_PAN_X = 'pan-x';
	var TOUCH_ACTION_PAN_Y = 'pan-y';
	var TOUCH_ACTION_MAP = getTouchActionProps();

	var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
	var SUPPORT_TOUCH = 'ontouchstart' in win;
	var SUPPORT_POINTER_EVENTS = prefixed(win, 'PointerEvent') !== undefined;
	var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
	var INPUT_TYPE_TOUCH = 'touch';
	var INPUT_TYPE_PEN = 'pen';
	var INPUT_TYPE_MOUSE = 'mouse';
	var INPUT_TYPE_KINECT = 'kinect';
	var COMPUTE_INTERVAL = 25;
	var INPUT_START = 1;
	var INPUT_MOVE = 2;
	var INPUT_END = 4;
	var INPUT_CANCEL = 8;
	var DIRECTION_NONE = 1;
	var DIRECTION_LEFT = 2;
	var DIRECTION_RIGHT = 4;
	var DIRECTION_UP = 8;
	var DIRECTION_DOWN = 16;
	var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
	var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
	var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
	var PROPS_XY = ['x', 'y'];
	var PROPS_CLIENT_XY = ['clientX', 'clientY'];

	/**
	 * @private
	 * walk objects and arrays
	 * @param {Object} obj
	 * @param {Function} iterator
	 * @param {Object} context
	 */
	function each(obj, iterator, context) {
	  var i;

	  if (!obj) {
	    return;
	  }

	  if (obj.forEach) {
	    obj.forEach(iterator, context);
	  } else if (obj.length !== undefined) {
	    i = 0;

	    while (i < obj.length) {
	      iterator.call(context, obj[i], i, obj);
	      i++;
	    }
	  } else {
	    for (i in obj) {
	      obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
	    }
	  }
	}

	/**
	 * @private
	 * let a boolean value also be a function that must return a boolean
	 * this first item in args will be used as the context
	 * @param {Boolean|Function} val
	 * @param {Array} [args]
	 * @returns {Boolean}
	 */

	function boolOrFn(val, args) {
	  if (typeof val === TYPE_FUNCTION) {
	    return val.apply(args ? args[0] || undefined : undefined, args);
	  }

	  return val;
	}

	/**
	 * @private
	 * small indexOf wrapper
	 * @param {String} str
	 * @param {String} find
	 * @returns {Boolean} found
	 */
	function inStr(str, find) {
	  return str.indexOf(find) > -1;
	}

	/**
	 * @private
	 * when the touchActions are collected they are not a valid value, so we need to clean things up. *
	 * @param {String} actions
	 * @returns {*}
	 */

	function cleanTouchActions(actions) {
	  // none
	  if (inStr(actions, TOUCH_ACTION_NONE)) {
	    return TOUCH_ACTION_NONE;
	  }

	  var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
	  var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y); // if both pan-x and pan-y are set (different recognizers
	  // for different directions, e.g. horizontal pan but vertical swipe?)
	  // we need none (as otherwise with pan-x pan-y combined none of these
	  // recognizers will work, since the browser would handle all panning

	  if (hasPanX && hasPanY) {
	    return TOUCH_ACTION_NONE;
	  } // pan-x OR pan-y


	  if (hasPanX || hasPanY) {
	    return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
	  } // manipulation


	  if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
	    return TOUCH_ACTION_MANIPULATION;
	  }

	  return TOUCH_ACTION_AUTO;
	}

	/**
	 * @private
	 * Touch Action
	 * sets the touchAction property or uses the js alternative
	 * @param {Manager} manager
	 * @param {String} value
	 * @constructor
	 */

	var TouchAction =
	/*#__PURE__*/
	function () {
	  function TouchAction(manager, value) {
	    this.manager = manager;
	    this.set(value);
	  }
	  /**
	   * @private
	   * set the touchAction value on the element or enable the polyfill
	   * @param {String} value
	   */


	  var _proto = TouchAction.prototype;

	  _proto.set = function set(value) {
	    // find out the touch-action by the event handlers
	    if (value === TOUCH_ACTION_COMPUTE) {
	      value = this.compute();
	    }

	    if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
	      this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
	    }

	    this.actions = value.toLowerCase().trim();
	  };
	  /**
	   * @private
	   * just re-set the touchAction value
	   */


	  _proto.update = function update() {
	    this.set(this.manager.options.touchAction);
	  };
	  /**
	   * @private
	   * compute the value for the touchAction property based on the recognizer's settings
	   * @returns {String} value
	   */


	  _proto.compute = function compute() {
	    var actions = [];
	    each(this.manager.recognizers, function (recognizer) {
	      if (boolOrFn(recognizer.options.enable, [recognizer])) {
	        actions = actions.concat(recognizer.getTouchAction());
	      }
	    });
	    return cleanTouchActions(actions.join(' '));
	  };
	  /**
	   * @private
	   * this method is called on each input cycle and provides the preventing of the browser behavior
	   * @param {Object} input
	   */


	  _proto.preventDefaults = function preventDefaults(input) {
	    var srcEvent = input.srcEvent;
	    var direction = input.offsetDirection; // if the touch action did prevented once this session

	    if (this.manager.session.prevented) {
	      srcEvent.preventDefault();
	      return;
	    }

	    var actions = this.actions;
	    var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
	    var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
	    var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

	    if (hasNone) {
	      // do not prevent defaults if this is a tap gesture
	      var isTapPointer = input.pointers.length === 1;
	      var isTapMovement = input.distance < 2;
	      var isTapTouchTime = input.deltaTime < 250;

	      if (isTapPointer && isTapMovement && isTapTouchTime) {
	        return;
	      }
	    }

	    if (hasPanX && hasPanY) {
	      // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
	      return;
	    }

	    if (hasNone || hasPanY && direction & DIRECTION_HORIZONTAL || hasPanX && direction & DIRECTION_VERTICAL) {
	      return this.preventSrc(srcEvent);
	    }
	  };
	  /**
	   * @private
	   * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
	   * @param {Object} srcEvent
	   */


	  _proto.preventSrc = function preventSrc(srcEvent) {
	    this.manager.session.prevented = true;
	    srcEvent.preventDefault();
	  };

	  return TouchAction;
	}();

	/**
	 * @private
	 * find if a node is in the given parent
	 * @method hasParent
	 * @param {HTMLElement} node
	 * @param {HTMLElement} parent
	 * @return {Boolean} found
	 */
	function hasParent$1(node, parent) {
	  while (node) {
	    if (node === parent) {
	      return true;
	    }

	    node = node.parentNode;
	  }

	  return false;
	}

	/**
	 * @private
	 * get the center of all the pointers
	 * @param {Array} pointers
	 * @return {Object} center contains `x` and `y` properties
	 */

	function getCenter(pointers) {
	  var pointersLength = pointers.length; // no need to loop when only one touch

	  if (pointersLength === 1) {
	    return {
	      x: round(pointers[0].clientX),
	      y: round(pointers[0].clientY)
	    };
	  }

	  var x = 0;
	  var y = 0;
	  var i = 0;

	  while (i < pointersLength) {
	    x += pointers[i].clientX;
	    y += pointers[i].clientY;
	    i++;
	  }

	  return {
	    x: round(x / pointersLength),
	    y: round(y / pointersLength)
	  };
	}

	/**
	 * @private
	 * create a simple clone from the input used for storage of firstInput and firstMultiple
	 * @param {Object} input
	 * @returns {Object} clonedInputData
	 */

	function simpleCloneInputData(input) {
	  // make a simple copy of the pointers because we will get a reference if we don't
	  // we only need clientXY for the calculations
	  var pointers = [];
	  var i = 0;

	  while (i < input.pointers.length) {
	    pointers[i] = {
	      clientX: round(input.pointers[i].clientX),
	      clientY: round(input.pointers[i].clientY)
	    };
	    i++;
	  }

	  return {
	    timeStamp: now(),
	    pointers: pointers,
	    center: getCenter(pointers),
	    deltaX: input.deltaX,
	    deltaY: input.deltaY
	  };
	}

	/**
	 * @private
	 * calculate the absolute distance between two points
	 * @param {Object} p1 {x, y}
	 * @param {Object} p2 {x, y}
	 * @param {Array} [props] containing x and y keys
	 * @return {Number} distance
	 */

	function getDistance(p1, p2, props) {
	  if (!props) {
	    props = PROPS_XY;
	  }

	  var x = p2[props[0]] - p1[props[0]];
	  var y = p2[props[1]] - p1[props[1]];
	  return Math.sqrt(x * x + y * y);
	}

	/**
	 * @private
	 * calculate the angle between two coordinates
	 * @param {Object} p1
	 * @param {Object} p2
	 * @param {Array} [props] containing x and y keys
	 * @return {Number} angle
	 */

	function getAngle(p1, p2, props) {
	  if (!props) {
	    props = PROPS_XY;
	  }

	  var x = p2[props[0]] - p1[props[0]];
	  var y = p2[props[1]] - p1[props[1]];
	  return Math.atan2(y, x) * 180 / Math.PI;
	}

	/**
	 * @private
	 * get the direction between two points
	 * @param {Number} x
	 * @param {Number} y
	 * @return {Number} direction
	 */

	function getDirection(x, y) {
	  if (x === y) {
	    return DIRECTION_NONE;
	  }

	  if (abs$1(x) >= abs$1(y)) {
	    return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
	  }

	  return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
	}

	function computeDeltaXY(session, input) {
	  var center = input.center; // let { offsetDelta:offset = {}, prevDelta = {}, prevInput = {} } = session;
	  // jscs throwing error on defalut destructured values and without defaults tests fail

	  var offset = session.offsetDelta || {};
	  var prevDelta = session.prevDelta || {};
	  var prevInput = session.prevInput || {};

	  if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
	    prevDelta = session.prevDelta = {
	      x: prevInput.deltaX || 0,
	      y: prevInput.deltaY || 0
	    };
	    offset = session.offsetDelta = {
	      x: center.x,
	      y: center.y
	    };
	  }

	  input.deltaX = prevDelta.x + (center.x - offset.x);
	  input.deltaY = prevDelta.y + (center.y - offset.y);
	}

	/**
	 * @private
	 * calculate the velocity between two points. unit is in px per ms.
	 * @param {Number} deltaTime
	 * @param {Number} x
	 * @param {Number} y
	 * @return {Object} velocity `x` and `y`
	 */
	function getVelocity(deltaTime, x, y) {
	  return {
	    x: x / deltaTime || 0,
	    y: y / deltaTime || 0
	  };
	}

	/**
	 * @private
	 * calculate the scale factor between two pointersets
	 * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
	 * @param {Array} start array of pointers
	 * @param {Array} end array of pointers
	 * @return {Number} scale
	 */

	function getScale(start, end) {
	  return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
	}

	/**
	 * @private
	 * calculate the rotation degrees between two pointersets
	 * @param {Array} start array of pointers
	 * @param {Array} end array of pointers
	 * @return {Number} rotation
	 */

	function getRotation(start, end) {
	  return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
	}

	/**
	 * @private
	 * velocity is calculated every x ms
	 * @param {Object} session
	 * @param {Object} input
	 */

	function computeIntervalInputData(session, input) {
	  var last = session.lastInterval || input;
	  var deltaTime = input.timeStamp - last.timeStamp;
	  var velocity;
	  var velocityX;
	  var velocityY;
	  var direction;

	  if (input.eventType !== INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
	    var deltaX = input.deltaX - last.deltaX;
	    var deltaY = input.deltaY - last.deltaY;
	    var v = getVelocity(deltaTime, deltaX, deltaY);
	    velocityX = v.x;
	    velocityY = v.y;
	    velocity = abs$1(v.x) > abs$1(v.y) ? v.x : v.y;
	    direction = getDirection(deltaX, deltaY);
	    session.lastInterval = input;
	  } else {
	    // use latest velocity info if it doesn't overtake a minimum period
	    velocity = last.velocity;
	    velocityX = last.velocityX;
	    velocityY = last.velocityY;
	    direction = last.direction;
	  }

	  input.velocity = velocity;
	  input.velocityX = velocityX;
	  input.velocityY = velocityY;
	  input.direction = direction;
	}

	/**
	* @private
	 * extend the data with some usable properties like scale, rotate, velocity etc
	 * @param {Object} manager
	 * @param {Object} input
	 */

	function computeInputData(manager, input) {
	  var session = manager.session;
	  var pointers = input.pointers;
	  var pointersLength = pointers.length; // store the first input to calculate the distance and direction

	  if (!session.firstInput) {
	    session.firstInput = simpleCloneInputData(input);
	  } // to compute scale and rotation we need to store the multiple touches


	  if (pointersLength > 1 && !session.firstMultiple) {
	    session.firstMultiple = simpleCloneInputData(input);
	  } else if (pointersLength === 1) {
	    session.firstMultiple = false;
	  }

	  var firstInput = session.firstInput,
	      firstMultiple = session.firstMultiple;
	  var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
	  var center = input.center = getCenter(pointers);
	  input.timeStamp = now();
	  input.deltaTime = input.timeStamp - firstInput.timeStamp;
	  input.angle = getAngle(offsetCenter, center);
	  input.distance = getDistance(offsetCenter, center);
	  computeDeltaXY(session, input);
	  input.offsetDirection = getDirection(input.deltaX, input.deltaY);
	  var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
	  input.overallVelocityX = overallVelocity.x;
	  input.overallVelocityY = overallVelocity.y;
	  input.overallVelocity = abs$1(overallVelocity.x) > abs$1(overallVelocity.y) ? overallVelocity.x : overallVelocity.y;
	  input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
	  input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
	  input.maxPointers = !session.prevInput ? input.pointers.length : input.pointers.length > session.prevInput.maxPointers ? input.pointers.length : session.prevInput.maxPointers;
	  computeIntervalInputData(session, input); // find the correct target

	  var target = manager.element;
	  var srcEvent = input.srcEvent;
	  var srcEventTarget;

	  if (srcEvent.composedPath) {
	    srcEventTarget = srcEvent.composedPath()[0];
	  } else if (srcEvent.path) {
	    srcEventTarget = srcEvent.path[0];
	  } else {
	    srcEventTarget = srcEvent.target;
	  }

	  if (hasParent$1(srcEventTarget, target)) {
	    target = srcEventTarget;
	  }

	  input.target = target;
	}

	/**
	 * @private
	 * handle input events
	 * @param {Manager} manager
	 * @param {String} eventType
	 * @param {Object} input
	 */

	function inputHandler(manager, eventType, input) {
	  var pointersLen = input.pointers.length;
	  var changedPointersLen = input.changedPointers.length;
	  var isFirst = eventType & INPUT_START && pointersLen - changedPointersLen === 0;
	  var isFinal = eventType & (INPUT_END | INPUT_CANCEL) && pointersLen - changedPointersLen === 0;
	  input.isFirst = !!isFirst;
	  input.isFinal = !!isFinal;

	  if (isFirst) {
	    manager.session = {};
	  } // source event is the normalized value of the domEvents
	  // like 'touchstart, mouseup, pointerdown'


	  input.eventType = eventType; // compute scale, rotation etc

	  computeInputData(manager, input); // emit secret event

	  manager.emit('hammer.input', input);
	  manager.recognize(input);
	  manager.session.prevInput = input;
	}

	/**
	 * @private
	 * split string on whitespace
	 * @param {String} str
	 * @returns {Array} words
	 */
	function splitStr(str) {
	  return str.trim().split(/\s+/g);
	}

	/**
	 * @private
	 * addEventListener with multiple events at once
	 * @param {EventTarget} target
	 * @param {String} types
	 * @param {Function} handler
	 */

	function addEventListeners(target, types, handler) {
	  each(splitStr(types), function (type) {
	    target.addEventListener(type, handler, false);
	  });
	}

	/**
	 * @private
	 * removeEventListener with multiple events at once
	 * @param {EventTarget} target
	 * @param {String} types
	 * @param {Function} handler
	 */

	function removeEventListeners(target, types, handler) {
	  each(splitStr(types), function (type) {
	    target.removeEventListener(type, handler, false);
	  });
	}

	/**
	 * @private
	 * get the window object of an element
	 * @param {HTMLElement} element
	 * @returns {DocumentView|Window}
	 */
	function getWindowForElement(element) {
	  var doc = element.ownerDocument || element;
	  return doc.defaultView || doc.parentWindow || window;
	}

	/**
	 * @private
	 * create new input type manager
	 * @param {Manager} manager
	 * @param {Function} callback
	 * @returns {Input}
	 * @constructor
	 */

	var Input =
	/*#__PURE__*/
	function () {
	  function Input(manager, callback) {
	    var self = this;
	    this.manager = manager;
	    this.callback = callback;
	    this.element = manager.element;
	    this.target = manager.options.inputTarget; // smaller wrapper around the handler, for the scope and the enabled state of the manager,
	    // so when disabled the input events are completely bypassed.

	    this.domHandler = function (ev) {
	      if (boolOrFn(manager.options.enable, [manager])) {
	        self.handler(ev);
	      }
	    };

	    this.init();
	  }
	  /**
	   * @private
	   * should handle the inputEvent data and trigger the callback
	   * @virtual
	   */


	  var _proto = Input.prototype;

	  _proto.handler = function handler() {};
	  /**
	   * @private
	   * bind the events
	   */


	  _proto.init = function init() {
	    this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
	    this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
	    this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
	  };
	  /**
	   * @private
	   * unbind the events
	   */


	  _proto.destroy = function destroy() {
	    this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
	    this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
	    this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
	  };

	  return Input;
	}();

	/**
	 * @private
	 * find if a array contains the object using indexOf or a simple polyFill
	 * @param {Array} src
	 * @param {String} find
	 * @param {String} [findByKey]
	 * @return {Boolean|Number} false when not found, or the index
	 */
	function inArray(src, find, findByKey) {
	  if (src.indexOf && !findByKey) {
	    return src.indexOf(find);
	  } else {
	    var i = 0;

	    while (i < src.length) {
	      if (findByKey && src[i][findByKey] == find || !findByKey && src[i] === find) {
	        // do not use === here, test fails
	        return i;
	      }

	      i++;
	    }

	    return -1;
	  }
	}

	var POINTER_INPUT_MAP = {
	  pointerdown: INPUT_START,
	  pointermove: INPUT_MOVE,
	  pointerup: INPUT_END,
	  pointercancel: INPUT_CANCEL,
	  pointerout: INPUT_CANCEL
	}; // in IE10 the pointer types is defined as an enum

	var IE10_POINTER_TYPE_ENUM = {
	  2: INPUT_TYPE_TOUCH,
	  3: INPUT_TYPE_PEN,
	  4: INPUT_TYPE_MOUSE,
	  5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816

	};
	var POINTER_ELEMENT_EVENTS = 'pointerdown';
	var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel'; // IE10 has prefixed support, and case-sensitive

	if (win.MSPointerEvent && !win.PointerEvent) {
	  POINTER_ELEMENT_EVENTS = 'MSPointerDown';
	  POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
	}
	/**
	 * @private
	 * Pointer events input
	 * @constructor
	 * @extends Input
	 */


	var PointerEventInput =
	/*#__PURE__*/
	function (_Input) {
	  _inheritsLoose(PointerEventInput, _Input);

	  function PointerEventInput() {
	    var _this;

	    var proto = PointerEventInput.prototype;
	    proto.evEl = POINTER_ELEMENT_EVENTS;
	    proto.evWin = POINTER_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.store = _this.manager.session.pointerEvents = [];
	    return _this;
	  }
	  /**
	   * @private
	   * handle mouse events
	   * @param {Object} ev
	   */


	  var _proto = PointerEventInput.prototype;

	  _proto.handler = function handler(ev) {
	    var store = this.store;
	    var removePointer = false;
	    var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
	    var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
	    var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
	    var isTouch = pointerType === INPUT_TYPE_TOUCH; // get index of the event in the store

	    var storeIndex = inArray(store, ev.pointerId, 'pointerId'); // start and mouse must be down

	    if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
	      if (storeIndex < 0) {
	        store.push(ev);
	        storeIndex = store.length - 1;
	      }
	    } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
	      removePointer = true;
	    } // it not found, so the pointer hasn't been down (so it's probably a hover)


	    if (storeIndex < 0) {
	      return;
	    } // update the event in the store


	    store[storeIndex] = ev;
	    this.callback(this.manager, eventType, {
	      pointers: store,
	      changedPointers: [ev],
	      pointerType: pointerType,
	      srcEvent: ev
	    });

	    if (removePointer) {
	      // remove from the store
	      store.splice(storeIndex, 1);
	    }
	  };

	  return PointerEventInput;
	}(Input);

	/**
	 * @private
	 * convert array-like objects to real arrays
	 * @param {Object} obj
	 * @returns {Array}
	 */
	function toArray$1(obj) {
	  return Array.prototype.slice.call(obj, 0);
	}

	/**
	 * @private
	 * unique array with objects based on a key (like 'id') or just by the array's value
	 * @param {Array} src [{id:1},{id:2},{id:1}]
	 * @param {String} [key]
	 * @param {Boolean} [sort=False]
	 * @returns {Array} [{id:1},{id:2}]
	 */

	function uniqueArray(src, key, sort) {
	  var results = [];
	  var values = [];
	  var i = 0;

	  while (i < src.length) {
	    var val = key ? src[i][key] : src[i];

	    if (inArray(values, val) < 0) {
	      results.push(src[i]);
	    }

	    values[i] = val;
	    i++;
	  }

	  if (sort) {
	    if (!key) {
	      results = results.sort();
	    } else {
	      results = results.sort(function (a, b) {
	        return a[key] > b[key];
	      });
	    }
	  }

	  return results;
	}

	var TOUCH_INPUT_MAP = {
	  touchstart: INPUT_START,
	  touchmove: INPUT_MOVE,
	  touchend: INPUT_END,
	  touchcancel: INPUT_CANCEL
	};
	var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';
	/**
	 * @private
	 * Multi-user touch events input
	 * @constructor
	 * @extends Input
	 */

	var TouchInput =
	/*#__PURE__*/
	function (_Input) {
	  _inheritsLoose(TouchInput, _Input);

	  function TouchInput() {
	    var _this;

	    TouchInput.prototype.evTarget = TOUCH_TARGET_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.targetIds = {}; // this.evTarget = TOUCH_TARGET_EVENTS;

	    return _this;
	  }

	  var _proto = TouchInput.prototype;

	  _proto.handler = function handler(ev) {
	    var type = TOUCH_INPUT_MAP[ev.type];
	    var touches = getTouches.call(this, ev, type);

	    if (!touches) {
	      return;
	    }

	    this.callback(this.manager, type, {
	      pointers: touches[0],
	      changedPointers: touches[1],
	      pointerType: INPUT_TYPE_TOUCH,
	      srcEvent: ev
	    });
	  };

	  return TouchInput;
	}(Input);

	function getTouches(ev, type) {
	  var allTouches = toArray$1(ev.touches);
	  var targetIds = this.targetIds; // when there is only one touch, the process can be simplified

	  if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
	    targetIds[allTouches[0].identifier] = true;
	    return [allTouches, allTouches];
	  }

	  var i;
	  var targetTouches;
	  var changedTouches = toArray$1(ev.changedTouches);
	  var changedTargetTouches = [];
	  var target = this.target; // get target touches from touches

	  targetTouches = allTouches.filter(function (touch) {
	    return hasParent$1(touch.target, target);
	  }); // collect touches

	  if (type === INPUT_START) {
	    i = 0;

	    while (i < targetTouches.length) {
	      targetIds[targetTouches[i].identifier] = true;
	      i++;
	    }
	  } // filter changed touches to only contain touches that exist in the collected target ids


	  i = 0;

	  while (i < changedTouches.length) {
	    if (targetIds[changedTouches[i].identifier]) {
	      changedTargetTouches.push(changedTouches[i]);
	    } // cleanup removed touches


	    if (type & (INPUT_END | INPUT_CANCEL)) {
	      delete targetIds[changedTouches[i].identifier];
	    }

	    i++;
	  }

	  if (!changedTargetTouches.length) {
	    return;
	  }

	  return [// merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
	  uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true), changedTargetTouches];
	}

	var MOUSE_INPUT_MAP = {
	  mousedown: INPUT_START,
	  mousemove: INPUT_MOVE,
	  mouseup: INPUT_END
	};
	var MOUSE_ELEMENT_EVENTS = 'mousedown';
	var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';
	/**
	 * @private
	 * Mouse events input
	 * @constructor
	 * @extends Input
	 */

	var MouseInput =
	/*#__PURE__*/
	function (_Input) {
	  _inheritsLoose(MouseInput, _Input);

	  function MouseInput() {
	    var _this;

	    var proto = MouseInput.prototype;
	    proto.evEl = MOUSE_ELEMENT_EVENTS;
	    proto.evWin = MOUSE_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.pressed = false; // mousedown state

	    return _this;
	  }
	  /**
	   * @private
	   * handle mouse events
	   * @param {Object} ev
	   */


	  var _proto = MouseInput.prototype;

	  _proto.handler = function handler(ev) {
	    var eventType = MOUSE_INPUT_MAP[ev.type]; // on start we want to have the left mouse button down

	    if (eventType & INPUT_START && ev.button === 0) {
	      this.pressed = true;
	    }

	    if (eventType & INPUT_MOVE && ev.which !== 1) {
	      eventType = INPUT_END;
	    } // mouse must be down


	    if (!this.pressed) {
	      return;
	    }

	    if (eventType & INPUT_END) {
	      this.pressed = false;
	    }

	    this.callback(this.manager, eventType, {
	      pointers: [ev],
	      changedPointers: [ev],
	      pointerType: INPUT_TYPE_MOUSE,
	      srcEvent: ev
	    });
	  };

	  return MouseInput;
	}(Input);

	/**
	 * @private
	 * Combined touch and mouse input
	 *
	 * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
	 * This because touch devices also emit mouse events while doing a touch.
	 *
	 * @constructor
	 * @extends Input
	 */

	var DEDUP_TIMEOUT = 2500;
	var DEDUP_DISTANCE = 25;

	function setLastTouch(eventData) {
	  var _eventData$changedPoi = eventData.changedPointers,
	      touch = _eventData$changedPoi[0];

	  if (touch.identifier === this.primaryTouch) {
	    var lastTouch = {
	      x: touch.clientX,
	      y: touch.clientY
	    };
	    var lts = this.lastTouches;
	    this.lastTouches.push(lastTouch);

	    var removeLastTouch = function removeLastTouch() {
	      var i = lts.indexOf(lastTouch);

	      if (i > -1) {
	        lts.splice(i, 1);
	      }
	    };

	    setTimeout(removeLastTouch, DEDUP_TIMEOUT);
	  }
	}

	function recordTouches(eventType, eventData) {
	  if (eventType & INPUT_START) {
	    this.primaryTouch = eventData.changedPointers[0].identifier;
	    setLastTouch.call(this, eventData);
	  } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
	    setLastTouch.call(this, eventData);
	  }
	}

	function isSyntheticEvent(eventData) {
	  var x = eventData.srcEvent.clientX;
	  var y = eventData.srcEvent.clientY;

	  for (var i = 0; i < this.lastTouches.length; i++) {
	    var t = this.lastTouches[i];
	    var dx = Math.abs(x - t.x);
	    var dy = Math.abs(y - t.y);

	    if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
	      return true;
	    }
	  }

	  return false;
	}

	var TouchMouseInput =
	/*#__PURE__*/
	function () {
	  var TouchMouseInput =
	  /*#__PURE__*/
	  function (_Input) {
	    _inheritsLoose(TouchMouseInput, _Input);

	    function TouchMouseInput(_manager, callback) {
	      var _this;

	      _this = _Input.call(this, _manager, callback) || this;

	      _this.handler = function (manager, inputEvent, inputData) {
	        var isTouch = inputData.pointerType === INPUT_TYPE_TOUCH;
	        var isMouse = inputData.pointerType === INPUT_TYPE_MOUSE;

	        if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
	          return;
	        } // when we're in a touch event, record touches to  de-dupe synthetic mouse event


	        if (isTouch) {
	          recordTouches.call(_assertThisInitialized$1(_assertThisInitialized$1(_this)), inputEvent, inputData);
	        } else if (isMouse && isSyntheticEvent.call(_assertThisInitialized$1(_assertThisInitialized$1(_this)), inputData)) {
	          return;
	        }

	        _this.callback(manager, inputEvent, inputData);
	      };

	      _this.touch = new TouchInput(_this.manager, _this.handler);
	      _this.mouse = new MouseInput(_this.manager, _this.handler);
	      _this.primaryTouch = null;
	      _this.lastTouches = [];
	      return _this;
	    }
	    /**
	     * @private
	     * handle mouse and touch events
	     * @param {Hammer} manager
	     * @param {String} inputEvent
	     * @param {Object} inputData
	     */


	    var _proto = TouchMouseInput.prototype;

	    /**
	     * @private
	     * remove the event listeners
	     */
	    _proto.destroy = function destroy() {
	      this.touch.destroy();
	      this.mouse.destroy();
	    };

	    return TouchMouseInput;
	  }(Input);

	  return TouchMouseInput;
	}();

	/**
	 * @private
	 * create new input type manager
	 * called by the Manager constructor
	 * @param {Hammer} manager
	 * @returns {Input}
	 */

	function createInputInstance(manager) {
	  var Type; // let inputClass = manager.options.inputClass;

	  var inputClass = manager.options.inputClass;

	  if (inputClass) {
	    Type = inputClass;
	  } else if (SUPPORT_POINTER_EVENTS) {
	    Type = PointerEventInput;
	  } else if (SUPPORT_ONLY_TOUCH) {
	    Type = TouchInput;
	  } else if (!SUPPORT_TOUCH) {
	    Type = MouseInput;
	  } else {
	    Type = TouchMouseInput;
	  }

	  return new Type(manager, inputHandler);
	}

	/**
	 * @private
	 * if the argument is an array, we want to execute the fn on each entry
	 * if it aint an array we don't want to do a thing.
	 * this is used by all the methods that accept a single and array argument.
	 * @param {*|Array} arg
	 * @param {String} fn
	 * @param {Object} [context]
	 * @returns {Boolean}
	 */

	function invokeArrayArg(arg, fn, context) {
	  if (Array.isArray(arg)) {
	    each(arg, context[fn], context);
	    return true;
	  }

	  return false;
	}

	var STATE_POSSIBLE = 1;
	var STATE_BEGAN = 2;
	var STATE_CHANGED = 4;
	var STATE_ENDED = 8;
	var STATE_RECOGNIZED = STATE_ENDED;
	var STATE_CANCELLED = 16;
	var STATE_FAILED = 32;

	/**
	 * @private
	 * get a unique id
	 * @returns {number} uniqueId
	 */
	var _uniqueId = 1;
	function uniqueId() {
	  return _uniqueId++;
	}

	/**
	 * @private
	 * get a recognizer by name if it is bound to a manager
	 * @param {Recognizer|String} otherRecognizer
	 * @param {Recognizer} recognizer
	 * @returns {Recognizer}
	 */
	function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
	  var manager = recognizer.manager;

	  if (manager) {
	    return manager.get(otherRecognizer);
	  }

	  return otherRecognizer;
	}

	/**
	 * @private
	 * get a usable string, used as event postfix
	 * @param {constant} state
	 * @returns {String} state
	 */

	function stateStr(state) {
	  if (state & STATE_CANCELLED) {
	    return 'cancel';
	  } else if (state & STATE_ENDED) {
	    return 'end';
	  } else if (state & STATE_CHANGED) {
	    return 'move';
	  } else if (state & STATE_BEGAN) {
	    return 'start';
	  }

	  return '';
	}

	/**
	 * @private
	 * Recognizer flow explained; *
	 * All recognizers have the initial state of POSSIBLE when a input session starts.
	 * The definition of a input session is from the first input until the last input, with all it's movement in it. *
	 * Example session for mouse-input: mousedown -> mousemove -> mouseup
	 *
	 * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
	 * which determines with state it should be.
	 *
	 * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
	 * POSSIBLE to give it another change on the next cycle.
	 *
	 *               Possible
	 *                  |
	 *            +-----+---------------+
	 *            |                     |
	 *      +-----+-----+               |
	 *      |           |               |
	 *   Failed      Cancelled          |
	 *                          +-------+------+
	 *                          |              |
	 *                      Recognized       Began
	 *                                         |
	 *                                      Changed
	 *                                         |
	 *                                  Ended/Recognized
	 */

	/**
	 * @private
	 * Recognizer
	 * Every recognizer needs to extend from this class.
	 * @constructor
	 * @param {Object} options
	 */

	var Recognizer =
	/*#__PURE__*/
	function () {
	  function Recognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    this.options = _extends({
	      enable: true
	    }, options);
	    this.id = uniqueId();
	    this.manager = null; // default is enable true

	    this.state = STATE_POSSIBLE;
	    this.simultaneous = {};
	    this.requireFail = [];
	  }
	  /**
	   * @private
	   * set options
	   * @param {Object} options
	   * @return {Recognizer}
	   */


	  var _proto = Recognizer.prototype;

	  _proto.set = function set(options) {
	    assign$1(this.options, options); // also update the touchAction, in case something changed about the directions/enabled state

	    this.manager && this.manager.touchAction.update();
	    return this;
	  };
	  /**
	   * @private
	   * recognize simultaneous with an other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.recognizeWith = function recognizeWith(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
	      return this;
	    }

	    var simultaneous = this.simultaneous;
	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

	    if (!simultaneous[otherRecognizer.id]) {
	      simultaneous[otherRecognizer.id] = otherRecognizer;
	      otherRecognizer.recognizeWith(this);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * drop the simultaneous link. it doesnt remove the link on the other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.dropRecognizeWith = function dropRecognizeWith(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
	      return this;
	    }

	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
	    delete this.simultaneous[otherRecognizer.id];
	    return this;
	  };
	  /**
	   * @private
	   * recognizer can only run when an other is failing
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.requireFailure = function requireFailure(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
	      return this;
	    }

	    var requireFail = this.requireFail;
	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

	    if (inArray(requireFail, otherRecognizer) === -1) {
	      requireFail.push(otherRecognizer);
	      otherRecognizer.requireFailure(this);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * drop the requireFailure link. it does not remove the link on the other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.dropRequireFailure = function dropRequireFailure(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
	      return this;
	    }

	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
	    var index = inArray(this.requireFail, otherRecognizer);

	    if (index > -1) {
	      this.requireFail.splice(index, 1);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * has require failures boolean
	   * @returns {boolean}
	   */


	  _proto.hasRequireFailures = function hasRequireFailures() {
	    return this.requireFail.length > 0;
	  };
	  /**
	   * @private
	   * if the recognizer can recognize simultaneous with an other recognizer
	   * @param {Recognizer} otherRecognizer
	   * @returns {Boolean}
	   */


	  _proto.canRecognizeWith = function canRecognizeWith(otherRecognizer) {
	    return !!this.simultaneous[otherRecognizer.id];
	  };
	  /**
	   * @private
	   * You should use `tryEmit` instead of `emit` directly to check
	   * that all the needed recognizers has failed before emitting.
	   * @param {Object} input
	   */


	  _proto.emit = function emit(input) {
	    var self = this;
	    var state = this.state;

	    function emit(event) {
	      self.manager.emit(event, input);
	    } // 'panstart' and 'panmove'


	    if (state < STATE_ENDED) {
	      emit(self.options.event + stateStr(state));
	    }

	    emit(self.options.event); // simple 'eventName' events

	    if (input.additionalEvent) {
	      // additional event(panleft, panright, pinchin, pinchout...)
	      emit(input.additionalEvent);
	    } // panend and pancancel


	    if (state >= STATE_ENDED) {
	      emit(self.options.event + stateStr(state));
	    }
	  };
	  /**
	   * @private
	   * Check that all the require failure recognizers has failed,
	   * if true, it emits a gesture event,
	   * otherwise, setup the state to FAILED.
	   * @param {Object} input
	   */


	  _proto.tryEmit = function tryEmit(input) {
	    if (this.canEmit()) {
	      return this.emit(input);
	    } // it's failing anyway


	    this.state = STATE_FAILED;
	  };
	  /**
	   * @private
	   * can we emit?
	   * @returns {boolean}
	   */


	  _proto.canEmit = function canEmit() {
	    var i = 0;

	    while (i < this.requireFail.length) {
	      if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
	        return false;
	      }

	      i++;
	    }

	    return true;
	  };
	  /**
	   * @private
	   * update the recognizer
	   * @param {Object} inputData
	   */


	  _proto.recognize = function recognize(inputData) {
	    // make a new copy of the inputData
	    // so we can change the inputData without messing up the other recognizers
	    var inputDataClone = assign$1({}, inputData); // is is enabled and allow recognizing?

	    if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
	      this.reset();
	      this.state = STATE_FAILED;
	      return;
	    } // reset when we've reached the end


	    if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
	      this.state = STATE_POSSIBLE;
	    }

	    this.state = this.process(inputDataClone); // the recognizer has recognized a gesture
	    // so trigger an event

	    if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
	      this.tryEmit(inputDataClone);
	    }
	  };
	  /**
	   * @private
	   * return the state of the recognizer
	   * the actual recognizing happens in this method
	   * @virtual
	   * @param {Object} inputData
	   * @returns {constant} STATE
	   */

	  /* jshint ignore:start */


	  _proto.process = function process(inputData) {};
	  /* jshint ignore:end */

	  /**
	   * @private
	   * return the preferred touch-action
	   * @virtual
	   * @returns {Array}
	   */


	  _proto.getTouchAction = function getTouchAction() {};
	  /**
	   * @private
	   * called when the gesture isn't allowed to recognize
	   * like when another is being recognized or it is disabled
	   * @virtual
	   */


	  _proto.reset = function reset() {};

	  return Recognizer;
	}();

	/**
	 * @private
	 * A tap is recognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
	 * between the given interval and position. The delay option can be used to recognize multi-taps without firing
	 * a single tap.
	 *
	 * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
	 * multi-taps being recognized.
	 * @constructor
	 * @extends Recognizer
	 */

	var TapRecognizer =
	/*#__PURE__*/
	function (_Recognizer) {
	  _inheritsLoose(TapRecognizer, _Recognizer);

	  function TapRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _Recognizer.call(this, _extends({
	      event: 'tap',
	      pointers: 1,
	      taps: 1,
	      interval: 300,
	      // max time between the multi-tap taps
	      time: 250,
	      // max time of the pointer to be down (like finger on the screen)
	      threshold: 9,
	      // a minimal movement is ok, but keep it low
	      posThreshold: 10
	    }, options)) || this; // previous time and center,
	    // used for tap counting

	    _this.pTime = false;
	    _this.pCenter = false;
	    _this._timer = null;
	    _this._input = null;
	    _this.count = 0;
	    return _this;
	  }

	  var _proto = TapRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_MANIPULATION];
	  };

	  _proto.process = function process(input) {
	    var _this2 = this;

	    var options = this.options;
	    var validPointers = input.pointers.length === options.pointers;
	    var validMovement = input.distance < options.threshold;
	    var validTouchTime = input.deltaTime < options.time;
	    this.reset();

	    if (input.eventType & INPUT_START && this.count === 0) {
	      return this.failTimeout();
	    } // we only allow little movement
	    // and we've reached an end event, so a tap is possible


	    if (validMovement && validTouchTime && validPointers) {
	      if (input.eventType !== INPUT_END) {
	        return this.failTimeout();
	      }

	      var validInterval = this.pTime ? input.timeStamp - this.pTime < options.interval : true;
	      var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;
	      this.pTime = input.timeStamp;
	      this.pCenter = input.center;

	      if (!validMultiTap || !validInterval) {
	        this.count = 1;
	      } else {
	        this.count += 1;
	      }

	      this._input = input; // if tap count matches we have recognized it,
	      // else it has began recognizing...

	      var tapCount = this.count % options.taps;

	      if (tapCount === 0) {
	        // no failing requirements, immediately trigger the tap event
	        // or wait as long as the multitap interval to trigger
	        if (!this.hasRequireFailures()) {
	          return STATE_RECOGNIZED;
	        } else {
	          this._timer = setTimeout(function () {
	            _this2.state = STATE_RECOGNIZED;

	            _this2.tryEmit();
	          }, options.interval);
	          return STATE_BEGAN;
	        }
	      }
	    }

	    return STATE_FAILED;
	  };

	  _proto.failTimeout = function failTimeout() {
	    var _this3 = this;

	    this._timer = setTimeout(function () {
	      _this3.state = STATE_FAILED;
	    }, this.options.interval);
	    return STATE_FAILED;
	  };

	  _proto.reset = function reset() {
	    clearTimeout(this._timer);
	  };

	  _proto.emit = function emit() {
	    if (this.state === STATE_RECOGNIZED) {
	      this._input.tapCount = this.count;
	      this.manager.emit(this.options.event, this._input);
	    }
	  };

	  return TapRecognizer;
	}(Recognizer);

	/**
	 * @private
	 * This recognizer is just used as a base for the simple attribute recognizers.
	 * @constructor
	 * @extends Recognizer
	 */

	var AttrRecognizer =
	/*#__PURE__*/
	function (_Recognizer) {
	  _inheritsLoose(AttrRecognizer, _Recognizer);

	  function AttrRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _Recognizer.call(this, _extends({
	      pointers: 1
	    }, options)) || this;
	  }
	  /**
	   * @private
	   * Used to check if it the recognizer receives valid input, like input.distance > 10.
	   * @memberof AttrRecognizer
	   * @param {Object} input
	   * @returns {Boolean} recognized
	   */


	  var _proto = AttrRecognizer.prototype;

	  _proto.attrTest = function attrTest(input) {
	    var optionPointers = this.options.pointers;
	    return optionPointers === 0 || input.pointers.length === optionPointers;
	  };
	  /**
	   * @private
	   * Process the input and return the state for the recognizer
	   * @memberof AttrRecognizer
	   * @param {Object} input
	   * @returns {*} State
	   */


	  _proto.process = function process(input) {
	    var state = this.state;
	    var eventType = input.eventType;
	    var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
	    var isValid = this.attrTest(input); // on cancel input and we've recognized before, return STATE_CANCELLED

	    if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
	      return state | STATE_CANCELLED;
	    } else if (isRecognized || isValid) {
	      if (eventType & INPUT_END) {
	        return state | STATE_ENDED;
	      } else if (!(state & STATE_BEGAN)) {
	        return STATE_BEGAN;
	      }

	      return state | STATE_CHANGED;
	    }

	    return STATE_FAILED;
	  };

	  return AttrRecognizer;
	}(Recognizer);

	/**
	 * @private
	 * direction cons to string
	 * @param {constant} direction
	 * @returns {String}
	 */

	function directionStr(direction) {
	  if (direction === DIRECTION_DOWN) {
	    return 'down';
	  } else if (direction === DIRECTION_UP) {
	    return 'up';
	  } else if (direction === DIRECTION_LEFT) {
	    return 'left';
	  } else if (direction === DIRECTION_RIGHT) {
	    return 'right';
	  }

	  return '';
	}

	/**
	 * @private
	 * Pan
	 * Recognized when the pointer is down and moved in the allowed direction.
	 * @constructor
	 * @extends AttrRecognizer
	 */

	var PanRecognizer =
	/*#__PURE__*/
	function (_AttrRecognizer) {
	  _inheritsLoose(PanRecognizer, _AttrRecognizer);

	  function PanRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _AttrRecognizer.call(this, _extends({
	      event: 'pan',
	      threshold: 10,
	      pointers: 1,
	      direction: DIRECTION_ALL
	    }, options)) || this;
	    _this.pX = null;
	    _this.pY = null;
	    return _this;
	  }

	  var _proto = PanRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    var direction = this.options.direction;
	    var actions = [];

	    if (direction & DIRECTION_HORIZONTAL) {
	      actions.push(TOUCH_ACTION_PAN_Y);
	    }

	    if (direction & DIRECTION_VERTICAL) {
	      actions.push(TOUCH_ACTION_PAN_X);
	    }

	    return actions;
	  };

	  _proto.directionTest = function directionTest(input) {
	    var options = this.options;
	    var hasMoved = true;
	    var distance = input.distance;
	    var direction = input.direction;
	    var x = input.deltaX;
	    var y = input.deltaY; // lock to axis?

	    if (!(direction & options.direction)) {
	      if (options.direction & DIRECTION_HORIZONTAL) {
	        direction = x === 0 ? DIRECTION_NONE : x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
	        hasMoved = x !== this.pX;
	        distance = Math.abs(input.deltaX);
	      } else {
	        direction = y === 0 ? DIRECTION_NONE : y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
	        hasMoved = y !== this.pY;
	        distance = Math.abs(input.deltaY);
	      }
	    }

	    input.direction = direction;
	    return hasMoved && distance > options.threshold && direction & options.direction;
	  };

	  _proto.attrTest = function attrTest(input) {
	    return AttrRecognizer.prototype.attrTest.call(this, input) && ( // replace with a super call
	    this.state & STATE_BEGAN || !(this.state & STATE_BEGAN) && this.directionTest(input));
	  };

	  _proto.emit = function emit(input) {
	    this.pX = input.deltaX;
	    this.pY = input.deltaY;
	    var direction = directionStr(input.direction);

	    if (direction) {
	      input.additionalEvent = this.options.event + direction;
	    }

	    _AttrRecognizer.prototype.emit.call(this, input);
	  };

	  return PanRecognizer;
	}(AttrRecognizer);

	/**
	 * @private
	 * Swipe
	 * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
	 * @constructor
	 * @extends AttrRecognizer
	 */

	var SwipeRecognizer =
	/*#__PURE__*/
	function (_AttrRecognizer) {
	  _inheritsLoose(SwipeRecognizer, _AttrRecognizer);

	  function SwipeRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'swipe',
	      threshold: 10,
	      velocity: 0.3,
	      direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
	      pointers: 1
	    }, options)) || this;
	  }

	  var _proto = SwipeRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return PanRecognizer.prototype.getTouchAction.call(this);
	  };

	  _proto.attrTest = function attrTest(input) {
	    var direction = this.options.direction;
	    var velocity;

	    if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
	      velocity = input.overallVelocity;
	    } else if (direction & DIRECTION_HORIZONTAL) {
	      velocity = input.overallVelocityX;
	    } else if (direction & DIRECTION_VERTICAL) {
	      velocity = input.overallVelocityY;
	    }

	    return _AttrRecognizer.prototype.attrTest.call(this, input) && direction & input.offsetDirection && input.distance > this.options.threshold && input.maxPointers === this.options.pointers && abs$1(velocity) > this.options.velocity && input.eventType & INPUT_END;
	  };

	  _proto.emit = function emit(input) {
	    var direction = directionStr(input.offsetDirection);

	    if (direction) {
	      this.manager.emit(this.options.event + direction, input);
	    }

	    this.manager.emit(this.options.event, input);
	  };

	  return SwipeRecognizer;
	}(AttrRecognizer);

	/**
	 * @private
	 * Pinch
	 * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
	 * @constructor
	 * @extends AttrRecognizer
	 */

	var PinchRecognizer =
	/*#__PURE__*/
	function (_AttrRecognizer) {
	  _inheritsLoose(PinchRecognizer, _AttrRecognizer);

	  function PinchRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'pinch',
	      threshold: 0,
	      pointers: 2
	    }, options)) || this;
	  }

	  var _proto = PinchRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_NONE];
	  };

	  _proto.attrTest = function attrTest(input) {
	    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
	  };

	  _proto.emit = function emit(input) {
	    if (input.scale !== 1) {
	      var inOut = input.scale < 1 ? 'in' : 'out';
	      input.additionalEvent = this.options.event + inOut;
	    }

	    _AttrRecognizer.prototype.emit.call(this, input);
	  };

	  return PinchRecognizer;
	}(AttrRecognizer);

	/**
	 * @private
	 * Rotate
	 * Recognized when two or more pointer are moving in a circular motion.
	 * @constructor
	 * @extends AttrRecognizer
	 */

	var RotateRecognizer =
	/*#__PURE__*/
	function (_AttrRecognizer) {
	  _inheritsLoose(RotateRecognizer, _AttrRecognizer);

	  function RotateRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'rotate',
	      threshold: 0,
	      pointers: 2
	    }, options)) || this;
	  }

	  var _proto = RotateRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_NONE];
	  };

	  _proto.attrTest = function attrTest(input) {
	    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
	  };

	  return RotateRecognizer;
	}(AttrRecognizer);

	/**
	 * @private
	 * Press
	 * Recognized when the pointer is down for x ms without any movement.
	 * @constructor
	 * @extends Recognizer
	 */

	var PressRecognizer =
	/*#__PURE__*/
	function (_Recognizer) {
	  _inheritsLoose(PressRecognizer, _Recognizer);

	  function PressRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _Recognizer.call(this, _extends({
	      event: 'press',
	      pointers: 1,
	      time: 251,
	      // minimal time of the pointer to be pressed
	      threshold: 9
	    }, options)) || this;
	    _this._timer = null;
	    _this._input = null;
	    return _this;
	  }

	  var _proto = PressRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_AUTO];
	  };

	  _proto.process = function process(input) {
	    var _this2 = this;

	    var options = this.options;
	    var validPointers = input.pointers.length === options.pointers;
	    var validMovement = input.distance < options.threshold;
	    var validTime = input.deltaTime > options.time;
	    this._input = input; // we only allow little movement
	    // and we've reached an end event, so a tap is possible

	    if (!validMovement || !validPointers || input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime) {
	      this.reset();
	    } else if (input.eventType & INPUT_START) {
	      this.reset();
	      this._timer = setTimeout(function () {
	        _this2.state = STATE_RECOGNIZED;

	        _this2.tryEmit();
	      }, options.time);
	    } else if (input.eventType & INPUT_END) {
	      return STATE_RECOGNIZED;
	    }

	    return STATE_FAILED;
	  };

	  _proto.reset = function reset() {
	    clearTimeout(this._timer);
	  };

	  _proto.emit = function emit(input) {
	    if (this.state !== STATE_RECOGNIZED) {
	      return;
	    }

	    if (input && input.eventType & INPUT_END) {
	      this.manager.emit(this.options.event + "up", input);
	    } else {
	      this._input.timeStamp = now();
	      this.manager.emit(this.options.event, this._input);
	    }
	  };

	  return PressRecognizer;
	}(Recognizer);

	var defaults = {
	  /**
	   * @private
	   * set if DOM events are being triggered.
	   * But this is slower and unused by simple implementations, so disabled by default.
	   * @type {Boolean}
	   * @default false
	   */
	  domEvents: false,

	  /**
	   * @private
	   * The value for the touchAction property/fallback.
	   * When set to `compute` it will magically set the correct value based on the added recognizers.
	   * @type {String}
	   * @default compute
	   */
	  touchAction: TOUCH_ACTION_COMPUTE,

	  /**
	   * @private
	   * @type {Boolean}
	   * @default true
	   */
	  enable: true,

	  /**
	   * @private
	   * EXPERIMENTAL FEATURE -- can be removed/changed
	   * Change the parent input target element.
	   * If Null, then it is being set the to main element.
	   * @type {Null|EventTarget}
	   * @default null
	   */
	  inputTarget: null,

	  /**
	   * @private
	   * force an input class
	   * @type {Null|Function}
	   * @default null
	   */
	  inputClass: null,

	  /**
	   * @private
	   * Some CSS properties can be used to improve the working of Hammer.
	   * Add them to this method and they will be set when creating a new Manager.
	   * @namespace
	   */
	  cssProps: {
	    /**
	     * @private
	     * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
	     * @type {String}
	     * @default 'none'
	     */
	    userSelect: "none",

	    /**
	     * @private
	     * Disable the Windows Phone grippers when pressing an element.
	     * @type {String}
	     * @default 'none'
	     */
	    touchSelect: "none",

	    /**
	     * @private
	     * Disables the default callout shown when you touch and hold a touch target.
	     * On iOS, when you touch and hold a touch target such as a link, Safari displays
	     * a callout containing information about the link. This property allows you to disable that callout.
	     * @type {String}
	     * @default 'none'
	     */
	    touchCallout: "none",

	    /**
	     * @private
	     * Specifies whether zooming is enabled. Used by IE10>
	     * @type {String}
	     * @default 'none'
	     */
	    contentZooming: "none",

	    /**
	     * @private
	     * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
	     * @type {String}
	     * @default 'none'
	     */
	    userDrag: "none",

	    /**
	     * @private
	     * Overrides the highlight color shown when the user taps a link or a JavaScript
	     * clickable element in iOS. This property obeys the alpha value, if specified.
	     * @type {String}
	     * @default 'rgba(0,0,0,0)'
	     */
	    tapHighlightColor: "rgba(0,0,0,0)"
	  }
	};
	/**
	 * @private
	 * Default recognizer setup when calling `Hammer()`
	 * When creating a new Manager these will be skipped.
	 * This is separated with other defaults because of tree-shaking.
	 * @type {Array}
	 */

	var preset = [[RotateRecognizer, {
	  enable: false
	}], [PinchRecognizer, {
	  enable: false
	}, ['rotate']], [SwipeRecognizer, {
	  direction: DIRECTION_HORIZONTAL
	}], [PanRecognizer, {
	  direction: DIRECTION_HORIZONTAL
	}, ['swipe']], [TapRecognizer], [TapRecognizer, {
	  event: 'doubletap',
	  taps: 2
	}, ['tap']], [PressRecognizer]];

	var STOP = 1;
	var FORCED_STOP = 2;
	/**
	 * @private
	 * add/remove the css properties as defined in manager.options.cssProps
	 * @param {Manager} manager
	 * @param {Boolean} add
	 */

	function toggleCssProps(manager, add) {
	  var element = manager.element;

	  if (!element.style) {
	    return;
	  }

	  var prop;
	  each(manager.options.cssProps, function (value, name) {
	    prop = prefixed(element.style, name);

	    if (add) {
	      manager.oldCssProps[prop] = element.style[prop];
	      element.style[prop] = value;
	    } else {
	      element.style[prop] = manager.oldCssProps[prop] || "";
	    }
	  });

	  if (!add) {
	    manager.oldCssProps = {};
	  }
	}
	/**
	 * @private
	 * trigger dom event
	 * @param {String} event
	 * @param {Object} data
	 */


	function triggerDomEvent(event, data) {
	  var gestureEvent = document.createEvent("Event");
	  gestureEvent.initEvent(event, true, true);
	  gestureEvent.gesture = data;
	  data.target.dispatchEvent(gestureEvent);
	}
	/**
	* @private
	 * Manager
	 * @param {HTMLElement} element
	 * @param {Object} [options]
	 * @constructor
	 */


	var Manager =
	/*#__PURE__*/
	function () {
	  function Manager(element, options) {
	    var _this = this;

	    this.options = assign$1({}, defaults, options || {});
	    this.options.inputTarget = this.options.inputTarget || element;
	    this.handlers = {};
	    this.session = {};
	    this.recognizers = [];
	    this.oldCssProps = {};
	    this.element = element;
	    this.input = createInputInstance(this);
	    this.touchAction = new TouchAction(this, this.options.touchAction);
	    toggleCssProps(this, true);
	    each(this.options.recognizers, function (item) {
	      var recognizer = _this.add(new item[0](item[1]));

	      item[2] && recognizer.recognizeWith(item[2]);
	      item[3] && recognizer.requireFailure(item[3]);
	    }, this);
	  }
	  /**
	   * @private
	   * set options
	   * @param {Object} options
	   * @returns {Manager}
	   */


	  var _proto = Manager.prototype;

	  _proto.set = function set(options) {
	    assign$1(this.options, options); // Options that need a little more setup

	    if (options.touchAction) {
	      this.touchAction.update();
	    }

	    if (options.inputTarget) {
	      // Clean up existing event listeners and reinitialize
	      this.input.destroy();
	      this.input.target = options.inputTarget;
	      this.input.init();
	    }

	    return this;
	  };
	  /**
	   * @private
	   * stop recognizing for this session.
	   * This session will be discarded, when a new [input]start event is fired.
	   * When forced, the recognizer cycle is stopped immediately.
	   * @param {Boolean} [force]
	   */


	  _proto.stop = function stop(force) {
	    this.session.stopped = force ? FORCED_STOP : STOP;
	  };
	  /**
	   * @private
	   * run the recognizers!
	   * called by the inputHandler function on every movement of the pointers (touches)
	   * it walks through all the recognizers and tries to detect the gesture that is being made
	   * @param {Object} inputData
	   */


	  _proto.recognize = function recognize(inputData) {
	    var session = this.session;

	    if (session.stopped) {
	      return;
	    } // run the touch-action polyfill


	    this.touchAction.preventDefaults(inputData);
	    var recognizer;
	    var recognizers = this.recognizers; // this holds the recognizer that is being recognized.
	    // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
	    // if no recognizer is detecting a thing, it is set to `null`

	    var curRecognizer = session.curRecognizer; // reset when the last recognizer is recognized
	    // or when we're in a new session

	    if (!curRecognizer || curRecognizer && curRecognizer.state & STATE_RECOGNIZED) {
	      session.curRecognizer = null;
	      curRecognizer = null;
	    }

	    var i = 0;

	    while (i < recognizers.length) {
	      recognizer = recognizers[i]; // find out if we are allowed try to recognize the input for this one.
	      // 1.   allow if the session is NOT forced stopped (see the .stop() method)
	      // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
	      //      that is being recognized.
	      // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
	      //      this can be setup with the `recognizeWith()` method on the recognizer.

	      if (session.stopped !== FORCED_STOP && ( // 1
	      !curRecognizer || recognizer === curRecognizer || // 2
	      recognizer.canRecognizeWith(curRecognizer))) {
	        // 3
	        recognizer.recognize(inputData);
	      } else {
	        recognizer.reset();
	      } // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
	      // current active recognizer. but only if we don't already have an active recognizer


	      if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
	        session.curRecognizer = recognizer;
	        curRecognizer = recognizer;
	      }

	      i++;
	    }
	  };
	  /**
	   * @private
	   * get a recognizer by its event name.
	   * @param {Recognizer|String} recognizer
	   * @returns {Recognizer|Null}
	   */


	  _proto.get = function get(recognizer) {
	    if (recognizer instanceof Recognizer) {
	      return recognizer;
	    }

	    var recognizers = this.recognizers;

	    for (var i = 0; i < recognizers.length; i++) {
	      if (recognizers[i].options.event === recognizer) {
	        return recognizers[i];
	      }
	    }

	    return null;
	  };
	  /**
	   * @private add a recognizer to the manager
	   * existing recognizers with the same event name will be removed
	   * @param {Recognizer} recognizer
	   * @returns {Recognizer|Manager}
	   */


	  _proto.add = function add(recognizer) {
	    if (invokeArrayArg(recognizer, "add", this)) {
	      return this;
	    } // remove existing


	    var existing = this.get(recognizer.options.event);

	    if (existing) {
	      this.remove(existing);
	    }

	    this.recognizers.push(recognizer);
	    recognizer.manager = this;
	    this.touchAction.update();
	    return recognizer;
	  };
	  /**
	   * @private
	   * remove a recognizer by name or instance
	   * @param {Recognizer|String} recognizer
	   * @returns {Manager}
	   */


	  _proto.remove = function remove(recognizer) {
	    if (invokeArrayArg(recognizer, "remove", this)) {
	      return this;
	    }

	    var targetRecognizer = this.get(recognizer); // let's make sure this recognizer exists

	    if (recognizer) {
	      var recognizers = this.recognizers;
	      var index = inArray(recognizers, targetRecognizer);

	      if (index !== -1) {
	        recognizers.splice(index, 1);
	        this.touchAction.update();
	      }
	    }

	    return this;
	  };
	  /**
	   * @private
	   * bind event
	   * @param {String} events
	   * @param {Function} handler
	   * @returns {EventEmitter} this
	   */


	  _proto.on = function on(events, handler) {
	    if (events === undefined || handler === undefined) {
	      return this;
	    }

	    var handlers = this.handlers;
	    each(splitStr(events), function (event) {
	      handlers[event] = handlers[event] || [];
	      handlers[event].push(handler);
	    });
	    return this;
	  };
	  /**
	   * @private unbind event, leave emit blank to remove all handlers
	   * @param {String} events
	   * @param {Function} [handler]
	   * @returns {EventEmitter} this
	   */


	  _proto.off = function off(events, handler) {
	    if (events === undefined) {
	      return this;
	    }

	    var handlers = this.handlers;
	    each(splitStr(events), function (event) {
	      if (!handler) {
	        delete handlers[event];
	      } else {
	        handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
	      }
	    });
	    return this;
	  };
	  /**
	   * @private emit event to the listeners
	   * @param {String} event
	   * @param {Object} data
	   */


	  _proto.emit = function emit(event, data) {
	    // we also want to trigger dom events
	    if (this.options.domEvents) {
	      triggerDomEvent(event, data);
	    } // no handlers, so skip it all


	    var handlers = this.handlers[event] && this.handlers[event].slice();

	    if (!handlers || !handlers.length) {
	      return;
	    }

	    data.type = event;

	    data.preventDefault = function () {
	      data.srcEvent.preventDefault();
	    };

	    var i = 0;

	    while (i < handlers.length) {
	      handlers[i](data);
	      i++;
	    }
	  };
	  /**
	   * @private
	   * destroy the manager and unbinds all events
	   * it doesn't unbind dom events, that is the user own responsibility
	   */


	  _proto.destroy = function destroy() {
	    this.element && toggleCssProps(this, false);
	    this.handlers = {};
	    this.session = {};
	    this.input.destroy();
	    this.element = null;
	  };

	  return Manager;
	}();

	var SINGLE_TOUCH_INPUT_MAP = {
	  touchstart: INPUT_START,
	  touchmove: INPUT_MOVE,
	  touchend: INPUT_END,
	  touchcancel: INPUT_CANCEL
	};
	var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
	var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';
	/**
	 * @private
	 * Touch events input
	 * @constructor
	 * @extends Input
	 */

	var SingleTouchInput =
	/*#__PURE__*/
	function (_Input) {
	  _inheritsLoose(SingleTouchInput, _Input);

	  function SingleTouchInput() {
	    var _this;

	    var proto = SingleTouchInput.prototype;
	    proto.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
	    proto.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.started = false;
	    return _this;
	  }

	  var _proto = SingleTouchInput.prototype;

	  _proto.handler = function handler(ev) {
	    var type = SINGLE_TOUCH_INPUT_MAP[ev.type]; // should we handle the touch events?

	    if (type === INPUT_START) {
	      this.started = true;
	    }

	    if (!this.started) {
	      return;
	    }

	    var touches = normalizeSingleTouches.call(this, ev, type); // when done, reset the started state

	    if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
	      this.started = false;
	    }

	    this.callback(this.manager, type, {
	      pointers: touches[0],
	      changedPointers: touches[1],
	      pointerType: INPUT_TYPE_TOUCH,
	      srcEvent: ev
	    });
	  };

	  return SingleTouchInput;
	}(Input);

	function normalizeSingleTouches(ev, type) {
	  var all = toArray$1(ev.touches);
	  var changed = toArray$1(ev.changedTouches);

	  if (type & (INPUT_END | INPUT_CANCEL)) {
	    all = uniqueArray(all.concat(changed), 'identifier', true);
	  }

	  return [all, changed];
	}

	/**
	 * @private
	 * wrap a method with a deprecation warning and stack trace
	 * @param {Function} method
	 * @param {String} name
	 * @param {String} message
	 * @returns {Function} A new function wrapping the supplied method.
	 */
	function deprecate(method, name, message) {
	  var deprecationMessage = "DEPRECATED METHOD: " + name + "\n" + message + " AT \n";
	  return function () {
	    var e = new Error('get-stack-trace');
	    var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '').replace(/^\s+at\s+/gm, '').replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';
	    var log = window.console && (window.console.warn || window.console.log);

	    if (log) {
	      log.call(window.console, deprecationMessage, stack);
	    }

	    return method.apply(this, arguments);
	  };
	}

	/**
	 * @private
	 * extend object.
	 * means that properties in dest will be overwritten by the ones in src.
	 * @param {Object} dest
	 * @param {Object} src
	 * @param {Boolean} [merge=false]
	 * @returns {Object} dest
	 */

	var extend$1 = deprecate(function (dest, src, merge) {
	  var keys = Object.keys(src);
	  var i = 0;

	  while (i < keys.length) {
	    if (!merge || merge && dest[keys[i]] === undefined) {
	      dest[keys[i]] = src[keys[i]];
	    }

	    i++;
	  }

	  return dest;
	}, 'extend', 'Use `assign`.');

	/**
	 * @private
	 * merge the values from src in the dest.
	 * means that properties that exist in dest will not be overwritten by src
	 * @param {Object} dest
	 * @param {Object} src
	 * @returns {Object} dest
	 */

	var merge$2 = deprecate(function (dest, src) {
	  return extend$1(dest, src, true);
	}, 'merge', 'Use `assign`.');

	/**
	 * @private
	 * simple class inheritance
	 * @param {Function} child
	 * @param {Function} base
	 * @param {Object} [properties]
	 */

	function inherit(child, base, properties) {
	  var baseP = base.prototype;
	  var childP;
	  childP = child.prototype = Object.create(baseP);
	  childP.constructor = child;
	  childP._super = baseP;

	  if (properties) {
	    assign$1(childP, properties);
	  }
	}

	/**
	 * @private
	 * simple function bind
	 * @param {Function} fn
	 * @param {Object} context
	 * @returns {Function}
	 */
	function bindFn(fn, context) {
	  return function boundFn() {
	    return fn.apply(context, arguments);
	  };
	}

	/**
	 * @private
	 * Simple way to create a manager with a default set of recognizers.
	 * @param {HTMLElement} element
	 * @param {Object} [options]
	 * @constructor
	 */

	var Hammer$2 =
	/*#__PURE__*/
	function () {
	  var Hammer =
	  /**
	    * @private
	    * @const {string}
	    */
	  function Hammer(element, options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return new Manager(element, _extends({
	      recognizers: preset.concat()
	    }, options));
	  };

	  Hammer.VERSION = "2.0.17-rc";
	  Hammer.DIRECTION_ALL = DIRECTION_ALL;
	  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
	  Hammer.DIRECTION_LEFT = DIRECTION_LEFT;
	  Hammer.DIRECTION_RIGHT = DIRECTION_RIGHT;
	  Hammer.DIRECTION_UP = DIRECTION_UP;
	  Hammer.DIRECTION_HORIZONTAL = DIRECTION_HORIZONTAL;
	  Hammer.DIRECTION_VERTICAL = DIRECTION_VERTICAL;
	  Hammer.DIRECTION_NONE = DIRECTION_NONE;
	  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
	  Hammer.INPUT_START = INPUT_START;
	  Hammer.INPUT_MOVE = INPUT_MOVE;
	  Hammer.INPUT_END = INPUT_END;
	  Hammer.INPUT_CANCEL = INPUT_CANCEL;
	  Hammer.STATE_POSSIBLE = STATE_POSSIBLE;
	  Hammer.STATE_BEGAN = STATE_BEGAN;
	  Hammer.STATE_CHANGED = STATE_CHANGED;
	  Hammer.STATE_ENDED = STATE_ENDED;
	  Hammer.STATE_RECOGNIZED = STATE_RECOGNIZED;
	  Hammer.STATE_CANCELLED = STATE_CANCELLED;
	  Hammer.STATE_FAILED = STATE_FAILED;
	  Hammer.Manager = Manager;
	  Hammer.Input = Input;
	  Hammer.TouchAction = TouchAction;
	  Hammer.TouchInput = TouchInput;
	  Hammer.MouseInput = MouseInput;
	  Hammer.PointerEventInput = PointerEventInput;
	  Hammer.TouchMouseInput = TouchMouseInput;
	  Hammer.SingleTouchInput = SingleTouchInput;
	  Hammer.Recognizer = Recognizer;
	  Hammer.AttrRecognizer = AttrRecognizer;
	  Hammer.Tap = TapRecognizer;
	  Hammer.Pan = PanRecognizer;
	  Hammer.Swipe = SwipeRecognizer;
	  Hammer.Pinch = PinchRecognizer;
	  Hammer.Rotate = RotateRecognizer;
	  Hammer.Press = PressRecognizer;
	  Hammer.on = addEventListeners;
	  Hammer.off = removeEventListeners;
	  Hammer.each = each;
	  Hammer.merge = merge$2;
	  Hammer.extend = extend$1;
	  Hammer.bindFn = bindFn;
	  Hammer.assign = assign$1;
	  Hammer.inherit = inherit;
	  Hammer.bindFn = bindFn;
	  Hammer.prefixed = prefixed;
	  Hammer.toArray = toArray$1;
	  Hammer.inArray = inArray;
	  Hammer.uniqueArray = uniqueArray;
	  Hammer.splitStr = splitStr;
	  Hammer.boolOrFn = boolOrFn;
	  Hammer.hasParent = hasParent$1;
	  Hammer.addEventListeners = addEventListeners;
	  Hammer.removeEventListeners = removeEventListeners;
	  Hammer.defaults = assign$1({}, defaults, {
	    preset: preset
	  });
	  return Hammer;
	}();

	//  style loader but by script tag, not by the loader.

	Hammer$2.defaults;

	var RealHammer = Hammer$2;

	function _createForOfIteratorHelper$7(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray(o) || (it = _unsupportedIterableToArray$7(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray$7(o, minLen) { var _context17; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$7(o, minLen); var n = _sliceInstanceProperty(_context17 = Object.prototype.toString.call(o)).call(_context17, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$7(o, minLen); }
	function _arrayLikeToArray$7(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

	/**
	 * Use this symbol to delete properies in deepObjectAssign.
	 */
	var DELETE = _Symbol("DELETE");
	/**
	 * Pure version of deepObjectAssign, it doesn't modify any of it's arguments.
	 *
	 * @param base - The base object that fullfils the whole interface T.
	 * @param updates - Updates that may change or delete props.
	 * @returns A brand new instance with all the supplied objects deeply merged.
	 */
	function pureDeepObjectAssign(base) {
	  var _context;
	  for (var _len = arguments.length, updates = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	    updates[_key - 1] = arguments[_key];
	  }
	  return deepObjectAssign.apply(void 0, _concatInstanceProperty(_context = [{}, base]).call(_context, updates));
	}
	/**
	 * Deep version of object assign with additional deleting by the DELETE symbol.
	 *
	 * @param values - Objects to be deeply merged.
	 * @returns The first object from values.
	 */
	function deepObjectAssign() {
	  var merged = deepObjectAssignNonentry.apply(void 0, arguments);
	  stripDelete(merged);
	  return merged;
	}
	/**
	 * Deep version of object assign with additional deleting by the DELETE symbol.
	 *
	 * @remarks
	 * This doesn't strip the DELETE symbols so they may end up in the final object.
	 * @param values - Objects to be deeply merged.
	 * @returns The first object from values.
	 */
	function deepObjectAssignNonentry() {
	  for (var _len2 = arguments.length, values = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
	    values[_key2] = arguments[_key2];
	  }
	  if (values.length < 2) {
	    return values[0];
	  } else if (values.length > 2) {
	    var _context2;
	    return deepObjectAssignNonentry.apply(void 0, _concatInstanceProperty(_context2 = [deepObjectAssign(values[0], values[1])]).call(_context2, _toConsumableArray(_sliceInstanceProperty(values).call(values, 2))));
	  }
	  var a = values[0];
	  var b = values[1];
	  if (a instanceof Date && b instanceof Date) {
	    a.setTime(b.getTime());
	    return a;
	  }
	  var _iterator = _createForOfIteratorHelper$7(_Reflect$ownKeys(b)),
	    _step;
	  try {
	    for (_iterator.s(); !(_step = _iterator.n()).done;) {
	      var prop = _step.value;
	      if (!Object.prototype.propertyIsEnumerable.call(b, prop)) ;else if (b[prop] === DELETE) {
	        delete a[prop];
	      } else if (a[prop] !== null && b[prop] !== null && _typeof$1(a[prop]) === "object" && _typeof$1(b[prop]) === "object" && !_Array$isArray(a[prop]) && !_Array$isArray(b[prop])) {
	        a[prop] = deepObjectAssignNonentry(a[prop], b[prop]);
	      } else {
	        a[prop] = clone(b[prop]);
	      }
	    }
	  } catch (err) {
	    _iterator.e(err);
	  } finally {
	    _iterator.f();
	  }
	  return a;
	}
	/**
	 * Deep clone given object or array. In case of primitive simply return.
	 *
	 * @param a - Anything.
	 * @returns Deep cloned object/array or unchanged a.
	 */
	function clone(a) {
	  if (_Array$isArray(a)) {
	    return _mapInstanceProperty(a).call(a, function (value) {
	      return clone(value);
	    });
	  } else if (_typeof$1(a) === "object" && a !== null) {
	    if (a instanceof Date) {
	      return new Date(a.getTime());
	    }
	    return deepObjectAssignNonentry({}, a);
	  } else {
	    return a;
	  }
	}
	/**
	 * Strip DELETE from given object.
	 *
	 * @param a - Object which may contain DELETE but won't after this is executed.
	 */
	function stripDelete(a) {
	  for (var _i = 0, _Object$keys$1 = _Object$keys(a); _i < _Object$keys$1.length; _i++) {
	    var prop = _Object$keys$1[_i];
	    if (a[prop] === DELETE) {
	      delete a[prop];
	    } else if (_typeof$1(a[prop]) === "object" && a[prop] !== null) {
	      stripDelete(a[prop]);
	    }
	  }
	}

	/**
	 * Seedable, fast and reasonably good (not crypto but more than okay for our
	 * needs) random number generator.
	 *
	 * @remarks
	 * Adapted from {@link https://web.archive.org/web/20110429100736/http://baagoe.com:80/en/RandomMusings/javascript}.
	 * Original algorithm created by Johannes Baagøe \<baagoe\@baagoe.com\> in 2010.
	 */
	/**
	 * Create a seeded pseudo random generator based on Alea by Johannes Baagøe.
	 *
	 * @param seed - All supplied arguments will be used as a seed. In case nothing
	 * is supplied the current time will be used to seed the generator.
	 * @returns A ready to use seeded generator.
	 */
	function Alea() {
	  for (var _len3 = arguments.length, seed = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
	    seed[_key3] = arguments[_key3];
	  }
	  return AleaImplementation(seed.length ? seed : [_Date$now()]);
	}
	/**
	 * An implementation of [[Alea]] without user input validation.
	 *
	 * @param seed - The data that will be used to seed the generator.
	 * @returns A ready to use seeded generator.
	 */
	function AleaImplementation(seed) {
	  var _mashSeed = mashSeed(seed),
	    _mashSeed2 = _slicedToArray(_mashSeed, 3),
	    s0 = _mashSeed2[0],
	    s1 = _mashSeed2[1],
	    s2 = _mashSeed2[2];
	  var c = 1;
	  var random = function random() {
	    var t = 2091639 * s0 + c * 2.3283064365386963e-10; // 2^-32
	    s0 = s1;
	    s1 = s2;
	    return s2 = t - (c = t | 0);
	  };
	  random.uint32 = function () {
	    return random() * 0x100000000;
	  }; // 2^32
	  random.fract53 = function () {
	    return random() + (random() * 0x200000 | 0) * 1.1102230246251565e-16;
	  }; // 2^-53
	  random.algorithm = "Alea";
	  random.seed = seed;
	  random.version = "0.9";
	  return random;
	}
	/**
	 * Turn arbitrary data into values [[AleaImplementation]] can use to generate
	 * random numbers.
	 *
	 * @param seed - Arbitrary data that will be used as the seed.
	 * @returns Three numbers to use as initial values for [[AleaImplementation]].
	 */
	function mashSeed() {
	  var mash = Mash();
	  var s0 = mash(" ");
	  var s1 = mash(" ");
	  var s2 = mash(" ");
	  for (var i = 0; i < arguments.length; i++) {
	    s0 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);
	    if (s0 < 0) {
	      s0 += 1;
	    }
	    s1 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);
	    if (s1 < 0) {
	      s1 += 1;
	    }
	    s2 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);
	    if (s2 < 0) {
	      s2 += 1;
	    }
	  }
	  return [s0, s1, s2];
	}
	/**
	 * Create a new mash function.
	 *
	 * @returns A nonpure function that takes arbitrary [[Mashable]] data and turns
	 * them into numbers.
	 */
	function Mash() {
	  var n = 0xefc8249d;
	  return function (data) {
	    var string = data.toString();
	    for (var i = 0; i < string.length; i++) {
	      n += string.charCodeAt(i);
	      var h = 0.02519603282416938 * n;
	      n = h >>> 0;
	      h -= n;
	      h *= n;
	      n = h >>> 0;
	      h -= n;
	      n += h * 0x100000000; // 2^32
	    }

	    return (n >>> 0) * 2.3283064365386963e-10; // 2^-32
	  };
	}

	/**
	 * Setup a mock hammer.js object, for unit testing.
	 *
	 * Inspiration: https://github.com/uber/deck.gl/pull/658
	 *
	 * @returns {{on: noop, off: noop, destroy: noop, emit: noop, get: get}}
	 */
	function hammerMock() {
	  var noop = function noop() {};
	  return {
	    on: noop,
	    off: noop,
	    destroy: noop,
	    emit: noop,
	    get: function get() {
	      return {
	        set: noop
	      };
	    }
	  };
	}
	var Hammer$1 = typeof window !== "undefined" ? window.Hammer || RealHammer : function () {
	  // hammer.js is only available in a browser, not in node.js. Replacing it with a mock object.
	  return hammerMock();
	};

	/**
	 * Turn an element into an clickToUse element.
	 * When not active, the element has a transparent overlay. When the overlay is
	 * clicked, the mode is changed to active.
	 * When active, the element is displayed with a blue border around it, and
	 * the interactive contents of the element can be used. When clicked outside
	 * the element, the elements mode is changed to inactive.
	 *
	 * @param {Element} container
	 * @class Activator
	 */
	function Activator$1(container) {
	  var _this = this,
	    _context3;
	  this._cleanupQueue = [];
	  this.active = false;
	  this._dom = {
	    container: container,
	    overlay: document.createElement("div")
	  };
	  this._dom.overlay.classList.add("vis-overlay");
	  this._dom.container.appendChild(this._dom.overlay);
	  this._cleanupQueue.push(function () {
	    _this._dom.overlay.parentNode.removeChild(_this._dom.overlay);
	  });
	  var hammer = Hammer$1(this._dom.overlay);
	  hammer.on("tap", _bindInstanceProperty$1(_context3 = this._onTapOverlay).call(_context3, this));
	  this._cleanupQueue.push(function () {
	    hammer.destroy();
	    // FIXME: cleaning up hammer instances doesn't work (Timeline not removed
	    // from memory)
	  });

	  // block all touch events (except tap)
	  var events = ["tap", "doubletap", "press", "pinch", "pan", "panstart", "panmove", "panend"];
	  _forEachInstanceProperty(events).call(events, function (event) {
	    hammer.on(event, function (event) {
	      event.srcEvent.stopPropagation();
	    });
	  });

	  // attach a click event to the window, in order to deactivate when clicking outside the timeline
	  if (document && document.body) {
	    this._onClick = function (event) {
	      if (!_hasParent(event.target, container)) {
	        _this.deactivate();
	      }
	    };
	    document.body.addEventListener("click", this._onClick);
	    this._cleanupQueue.push(function () {
	      document.body.removeEventListener("click", _this._onClick);
	    });
	  }

	  // prepare escape key listener for deactivating when active
	  this._escListener = function (event) {
	    if ("key" in event ? event.key === "Escape" : event.keyCode === 27 /* the keyCode is for IE11 */) {
	      _this.deactivate();
	    }
	  };
	}

	// turn into an event emitter
	Emitter(Activator$1.prototype);

	// The currently active activator
	Activator$1.current = null;

	/**
	 * Destroy the activator. Cleans up all created DOM and event listeners
	 */
	Activator$1.prototype.destroy = function () {
	  var _context4, _context5;
	  this.deactivate();
	  var _iterator2 = _createForOfIteratorHelper$7(_reverseInstanceProperty(_context4 = _spliceInstanceProperty(_context5 = this._cleanupQueue).call(_context5, 0)).call(_context4)),
	    _step2;
	  try {
	    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
	      var callback = _step2.value;
	      callback();
	    }
	  } catch (err) {
	    _iterator2.e(err);
	  } finally {
	    _iterator2.f();
	  }
	};

	/**
	 * Activate the element
	 * Overlay is hidden, element is decorated with a blue shadow border
	 */
	Activator$1.prototype.activate = function () {
	  // we allow only one active activator at a time
	  if (Activator$1.current) {
	    Activator$1.current.deactivate();
	  }
	  Activator$1.current = this;
	  this.active = true;
	  this._dom.overlay.style.display = "none";
	  this._dom.container.classList.add("vis-active");
	  this.emit("change");
	  this.emit("activate");

	  // ugly hack: bind ESC after emitting the events, as the Network rebinds all
	  // keyboard events on a 'change' event
	  document.body.addEventListener("keydown", this._escListener);
	};

	/**
	 * Deactivate the element
	 * Overlay is displayed on top of the element
	 */
	Activator$1.prototype.deactivate = function () {
	  this.active = false;
	  this._dom.overlay.style.display = "block";
	  this._dom.container.classList.remove("vis-active");
	  document.body.removeEventListener("keydown", this._escListener);
	  this.emit("change");
	  this.emit("deactivate");
	};

	/**
	 * Handle a tap event: activate the container
	 *
	 * @param {Event}  event   The event
	 * @private
	 */
	Activator$1.prototype._onTapOverlay = function (event) {
	  // activate the container
	  this.activate();
	  event.srcEvent.stopPropagation();
	};

	/**
	 * Test whether the element has the requested parent element somewhere in
	 * its chain of parent nodes.
	 *
	 * @param {HTMLElement} element
	 * @param {HTMLElement} parent
	 * @returns {boolean} Returns true when the parent is found somewhere in the
	 *                    chain of parent nodes.
	 * @private
	 */
	function _hasParent(element, parent) {
	  while (element) {
	    if (element === parent) {
	      return true;
	    }
	    element = element.parentNode;
	  }
	  return false;
	}

	// utility functions
	// parse ASP.Net Date pattern,
	// for example '/Date(1198908717056)/' or '/Date(1198908717056-0700)/'
	// code from http://momentjs.com/
	var ASPDateRegex = /^\/?Date\((-?\d+)/i;
	// Color REs
	var fullHexRE = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;
	var shortHexRE = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
	var rgbRE = /^rgb\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *\)$/i;
	var rgbaRE = /^rgba\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *([01]|0?\.\d+) *\)$/i;
	/**
	 * Test whether given object is a number.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if number, false otherwise.
	 */
	function isNumber(value) {
	  return value instanceof Number || typeof value === "number";
	}
	/**
	 * Remove everything in the DOM object.
	 *
	 * @param DOMobject - Node whose child nodes will be recursively deleted.
	 */
	function recursiveDOMDelete(DOMobject) {
	  if (DOMobject) {
	    while (DOMobject.hasChildNodes() === true) {
	      var child = DOMobject.firstChild;
	      if (child) {
	        recursiveDOMDelete(child);
	        DOMobject.removeChild(child);
	      }
	    }
	  }
	}
	/**
	 * Test whether given object is a string.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if string, false otherwise.
	 */
	function isString(value) {
	  return value instanceof String || typeof value === "string";
	}
	/**
	 * Test whether given object is a object (not primitive or null).
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if not null object, false otherwise.
	 */
	function isObject$a(value) {
	  return _typeof$1(value) === "object" && value !== null;
	}
	/**
	 * Test whether given object is a Date, or a String containing a Date.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if Date instance or string date representation, false otherwise.
	 */
	function isDate(value) {
	  if (value instanceof Date) {
	    return true;
	  } else if (isString(value)) {
	    // test whether this string contains a date
	    var match = ASPDateRegex.exec(value);
	    if (match) {
	      return true;
	    } else if (!isNaN(Date.parse(value))) {
	      return true;
	    }
	  }
	  return false;
	}
	/**
	 * Copy property from b to a if property present in a.
	 * If property in b explicitly set to null, delete it if `allowDeletion` set.
	 *
	 * Internal helper routine, should not be exported. Not added to `exports` for that reason.
	 *
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param prop - Name of property to copy from b to a.
	 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
	 */
	function copyOrDelete(a, b, prop, allowDeletion) {
	  var doDeletion = false;
	  if (allowDeletion === true) {
	    doDeletion = b[prop] === null && a[prop] !== undefined;
	  }
	  if (doDeletion) {
	    delete a[prop];
	  } else {
	    a[prop] = b[prop]; // Remember, this is a reference copy!
	  }
	}
	/**
	 * Fill an object with a possibly partially defined other object.
	 *
	 * Only copies values for the properties already present in a.
	 * That means an object is not created on a property if only the b object has it.
	 *
	 * @param a - The object that will have it's properties updated.
	 * @param b - The object with property updates.
	 * @param allowDeletion - If true, delete properties in a that are explicitly set to null in b.
	 */
	function fillIfDefined(a, b) {
	  var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  // NOTE: iteration of properties of a
	  // NOTE: prototype properties iterated over as well
	  for (var prop in a) {
	    if (b[prop] !== undefined) {
	      if (b[prop] === null || _typeof$1(b[prop]) !== "object") {
	        // Note: typeof null === 'object'
	        copyOrDelete(a, b, prop, allowDeletion);
	      } else {
	        var aProp = a[prop];
	        var bProp = b[prop];
	        if (isObject$a(aProp) && isObject$a(bProp)) {
	          fillIfDefined(aProp, bProp, allowDeletion);
	        }
	      }
	    }
	  }
	}
	/**
	 * Copy the values of all of the enumerable own properties from one or more source objects to a
	 * target object. Returns the target object.
	 *
	 * @param target - The target object to copy to.
	 * @param source - The source object from which to copy properties.
	 * @returns The target object.
	 */
	var extend = _Object$assign;
	/**
	 * Extend object a with selected properties of object b or a series of objects.
	 *
	 * @remarks
	 * Only properties with defined values are copied.
	 * @param props - Properties to be copied to a.
	 * @param a - The target.
	 * @param others - The sources.
	 * @returns Argument a.
	 */
	function selectiveExtend(props, a) {
	  if (!_Array$isArray(props)) {
	    throw new Error("Array with property names expected as first argument");
	  }
	  for (var _len4 = arguments.length, others = new Array(_len4 > 2 ? _len4 - 2 : 0), _key4 = 2; _key4 < _len4; _key4++) {
	    others[_key4 - 2] = arguments[_key4];
	  }
	  for (var _i2 = 0, _others = others; _i2 < _others.length; _i2++) {
	    var other = _others[_i2];
	    for (var p = 0; p < props.length; p++) {
	      var prop = props[p];
	      if (other && Object.prototype.hasOwnProperty.call(other, prop)) {
	        a[prop] = other[prop];
	      }
	    }
	  }
	  return a;
	}
	/**
	 * Extend object a with selected properties of object b.
	 * Only properties with defined values are copied.
	 *
	 * @remarks
	 * Previous version of this routine implied that multiple source objects could
	 * be used; however, the implementation was **wrong**. Since multiple (\>1)
	 * sources weren't used anywhere in the `vis.js` code, this has been removed
	 * @param props - Names of first-level properties to copy over.
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
	 * @returns Argument a.
	 */
	function selectiveDeepExtend(props, a, b) {
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	  // TODO: add support for Arrays to deepExtend
	  if (_Array$isArray(b)) {
	    throw new TypeError("Arrays are not supported by deepExtend");
	  }
	  for (var p = 0; p < props.length; p++) {
	    var prop = props[p];
	    if (Object.prototype.hasOwnProperty.call(b, prop)) {
	      if (b[prop] && b[prop].constructor === Object) {
	        if (a[prop] === undefined) {
	          a[prop] = {};
	        }
	        if (a[prop].constructor === Object) {
	          deepExtend(a[prop], b[prop], false, allowDeletion);
	        } else {
	          copyOrDelete(a, b, prop, allowDeletion);
	        }
	      } else if (_Array$isArray(b[prop])) {
	        throw new TypeError("Arrays are not supported by deepExtend");
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    }
	  }
	  return a;
	}
	/**
	 * Extend object `a` with properties of object `b`, ignoring properties which
	 * are explicitly specified to be excluded.
	 *
	 * @remarks
	 * The properties of `b` are considered for copying. Properties which are
	 * themselves objects are are also extended. Only properties with defined
	 * values are copied.
	 * @param propsToExclude - Names of properties which should *not* be copied.
	 * @param a - Object to extend.
	 * @param b - Object to take properties from for extension.
	 * @param allowDeletion - If true, delete properties in a that are explicitly
	 * set to null in b.
	 * @returns Argument a.
	 */
	function selectiveNotDeepExtend(propsToExclude, a, b) {
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	  // TODO: add support for Arrays to deepExtend
	  // NOTE: array properties have an else-below; apparently, there is a problem here.
	  if (_Array$isArray(b)) {
	    throw new TypeError("Arrays are not supported by deepExtend");
	  }
	  for (var prop in b) {
	    if (!Object.prototype.hasOwnProperty.call(b, prop)) {
	      continue;
	    } // Handle local properties only
	    if (_includesInstanceProperty(propsToExclude).call(propsToExclude, prop)) {
	      continue;
	    } // In exclusion list, skip
	    if (b[prop] && b[prop].constructor === Object) {
	      if (a[prop] === undefined) {
	        a[prop] = {};
	      }
	      if (a[prop].constructor === Object) {
	        deepExtend(a[prop], b[prop]); // NOTE: allowDeletion not propagated!
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    } else if (_Array$isArray(b[prop])) {
	      a[prop] = [];
	      for (var i = 0; i < b[prop].length; i++) {
	        a[prop].push(b[prop][i]);
	      }
	    } else {
	      copyOrDelete(a, b, prop, allowDeletion);
	    }
	  }
	  return a;
	}
	/**
	 * Deep extend an object a with the properties of object b.
	 *
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param protoExtend - If true, the prototype values will also be extended.
	 * (That is the options objects that inherit from others will also get the
	 * inherited options).
	 * @param allowDeletion - If true, the values of fields that are null will be deleted.
	 * @returns Argument a.
	 */
	function deepExtend(a, b) {
	  var protoExtend = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	  for (var prop in b) {
	    if (Object.prototype.hasOwnProperty.call(b, prop) || protoExtend === true) {
	      if (_typeof$1(b[prop]) === "object" && b[prop] !== null && _Object$getPrototypeOf$1(b[prop]) === Object.prototype) {
	        if (a[prop] === undefined) {
	          a[prop] = deepExtend({}, b[prop], protoExtend); // NOTE: allowDeletion not propagated!
	        } else if (_typeof$1(a[prop]) === "object" && a[prop] !== null && _Object$getPrototypeOf$1(a[prop]) === Object.prototype) {
	          deepExtend(a[prop], b[prop], protoExtend); // NOTE: allowDeletion not propagated!
	        } else {
	          copyOrDelete(a, b, prop, allowDeletion);
	        }
	      } else if (_Array$isArray(b[prop])) {
	        var _context6;
	        a[prop] = _sliceInstanceProperty(_context6 = b[prop]).call(_context6);
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    }
	  }
	  return a;
	}
	/**
	 * Test whether all elements in two arrays are equal.
	 *
	 * @param a - First array.
	 * @param b - Second array.
	 * @returns True if both arrays have the same length and same elements (1 = '1').
	 */
	function equalArray(a, b) {
	  if (a.length !== b.length) {
	    return false;
	  }
	  for (var i = 0, len = a.length; i < len; i++) {
	    if (a[i] != b[i]) {
	      return false;
	    }
	  }
	  return true;
	}
	/**
	 * Get the type of an object, for example exports.getType([]) returns 'Array'.
	 *
	 * @param object - Input value of unknown type.
	 * @returns Detected type.
	 */
	function getType(object) {
	  var type = _typeof$1(object);
	  if (type === "object") {
	    if (object === null) {
	      return "null";
	    }
	    if (object instanceof Boolean) {
	      return "Boolean";
	    }
	    if (object instanceof Number) {
	      return "Number";
	    }
	    if (object instanceof String) {
	      return "String";
	    }
	    if (_Array$isArray(object)) {
	      return "Array";
	    }
	    if (object instanceof Date) {
	      return "Date";
	    }
	    return "Object";
	  }
	  if (type === "number") {
	    return "Number";
	  }
	  if (type === "boolean") {
	    return "Boolean";
	  }
	  if (type === "string") {
	    return "String";
	  }
	  if (type === undefined) {
	    return "undefined";
	  }
	  return type;
	}
	/**
	 * Used to extend an array and copy it. This is used to propagate paths recursively.
	 *
	 * @param arr - First part.
	 * @param newValue - The value to be aadded into the array.
	 * @returns A new array with all items from arr and newValue (which is last).
	 */
	function copyAndExtendArray(arr, newValue) {
	  var _context7;
	  return _concatInstanceProperty(_context7 = []).call(_context7, _toConsumableArray(arr), [newValue]);
	}
	/**
	 * Used to extend an array and copy it. This is used to propagate paths recursively.
	 *
	 * @param arr - The array to be copied.
	 * @returns Shallow copy of arr.
	 */
	function copyArray(arr) {
	  return _sliceInstanceProperty(arr).call(arr);
	}
	/**
	 * Retrieve the absolute left value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 * @returns The absolute left position of this element in the browser page.
	 */
	function getAbsoluteLeft(elem) {
	  return elem.getBoundingClientRect().left;
	}
	/**
	 * Retrieve the absolute right value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 * @returns The absolute right position of this element in the browser page.
	 */
	function getAbsoluteRight(elem) {
	  return elem.getBoundingClientRect().right;
	}
	/**
	 * Retrieve the absolute top value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 * @returns The absolute top position of this element in the browser page.
	 */
	function getAbsoluteTop(elem) {
	  return elem.getBoundingClientRect().top;
	}
	/**
	 * Add a className to the given elements style.
	 *
	 * @param elem - The element to which the classes will be added.
	 * @param classNames - Space separated list of classes.
	 */
	function addClassName(elem, classNames) {
	  var classes = elem.className.split(" ");
	  var newClasses = classNames.split(" ");
	  classes = _concatInstanceProperty(classes).call(classes, _filterInstanceProperty(newClasses).call(newClasses, function (className) {
	    return !_includesInstanceProperty(classes).call(classes, className);
	  }));
	  elem.className = classes.join(" ");
	}
	/**
	 * Remove a className from the given elements style.
	 *
	 * @param elem - The element from which the classes will be removed.
	 * @param classNames - Space separated list of classes.
	 */
	function removeClassName(elem, classNames) {
	  var classes = elem.className.split(" ");
	  var oldClasses = classNames.split(" ");
	  classes = _filterInstanceProperty(classes).call(classes, function (className) {
	    return !_includesInstanceProperty(oldClasses).call(oldClasses, className);
	  });
	  elem.className = classes.join(" ");
	}
	/**
	 * For each method for both arrays and objects.
	 * In case of an array, the built-in Array.forEach() is applied (**No, it's not!**).
	 * In case of an Object, the method loops over all properties of the object.
	 *
	 * @param object - An Object or Array to be iterated over.
	 * @param callback - Array.forEach-like callback.
	 */
	function forEach$4(object, callback) {
	  if (_Array$isArray(object)) {
	    // array
	    var len = object.length;
	    for (var i = 0; i < len; i++) {
	      callback(object[i], i, object);
	    }
	  } else {
	    // object
	    for (var key in object) {
	      if (Object.prototype.hasOwnProperty.call(object, key)) {
	        callback(object[key], key, object);
	      }
	    }
	  }
	}
	/**
	 * Convert an object into an array: all objects properties are put into the array. The resulting array is unordered.
	 *
	 * @param o - Object that contains the properties and methods.
	 * @returns An array of unordered values.
	 */
	var toArray = _Object$values;
	/**
	 * Update a property in an object.
	 *
	 * @param object - The object whose property will be updated.
	 * @param key - Name of the property to be updated.
	 * @param value - The new value to be assigned.
	 * @returns Whether the value was updated (true) or already strictly the same in the original object (false).
	 */
	function updateProperty(object, key, value) {
	  if (object[key] !== value) {
	    object[key] = value;
	    return true;
	  } else {
	    return false;
	  }
	}
	/**
	 * Throttle the given function to be only executed once per animation frame.
	 *
	 * @param fn - The original function.
	 * @returns The throttled function.
	 */
	function throttle(fn) {
	  var scheduled = false;
	  return function () {
	    if (!scheduled) {
	      scheduled = true;
	      requestAnimationFrame(function () {
	        scheduled = false;
	        fn();
	      });
	    }
	  };
	}
	/**
	 * Add and event listener. Works for all browsers.
	 *
	 * @param element - The element to bind the event listener to.
	 * @param action - Same as Element.addEventListener(action, —, —).
	 * @param listener - Same as Element.addEventListener(—, listener, —).
	 * @param useCapture - Same as Element.addEventListener(—, —, useCapture).
	 */
	function addEventListener(element, action, listener, useCapture) {
	  if (element.addEventListener) {
	    var _context8;
	    if (useCapture === undefined) {
	      useCapture = false;
	    }
	    if (action === "mousewheel" && _includesInstanceProperty(_context8 = navigator.userAgent).call(_context8, "Firefox")) {
	      action = "DOMMouseScroll"; // For Firefox
	    }

	    element.addEventListener(action, listener, useCapture);
	  } else {
	    // @TODO: IE types? Does anyone care?
	    element.attachEvent("on" + action, listener); // IE browsers
	  }
	}
	/**
	 * Remove an event listener from an element.
	 *
	 * @param element - The element to bind the event listener to.
	 * @param action - Same as Element.removeEventListener(action, —, —).
	 * @param listener - Same as Element.removeEventListener(—, listener, —).
	 * @param useCapture - Same as Element.removeEventListener(—, —, useCapture).
	 */
	function removeEventListener(element, action, listener, useCapture) {
	  if (element.removeEventListener) {
	    var _context9;
	    // non-IE browsers
	    if (useCapture === undefined) {
	      useCapture = false;
	    }
	    if (action === "mousewheel" && _includesInstanceProperty(_context9 = navigator.userAgent).call(_context9, "Firefox")) {
	      action = "DOMMouseScroll"; // For Firefox
	    }

	    element.removeEventListener(action, listener, useCapture);
	  } else {
	    // @TODO: IE types? Does anyone care?
	    element.detachEvent("on" + action, listener); // IE browsers
	  }
	}
	/**
	 * Cancels the event's default action if it is cancelable, without stopping further propagation of the event.
	 *
	 * @param event - The event whose default action should be prevented.
	 */
	function preventDefault(event) {
	  if (!event) {
	    event = window.event;
	  }
	  if (!event) ;else if (event.preventDefault) {
	    event.preventDefault(); // non-IE browsers
	  } else {
	    // @TODO: IE types? Does anyone care?
	    event.returnValue = false; // IE browsers
	  }
	}
	/**
	 * Get HTML element which is the target of the event.
	 *
	 * @param event - The event.
	 * @returns The element or null if not obtainable.
	 */
	function getTarget() {
	  var event = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window.event;
	  // code from http://www.quirksmode.org/js/events_properties.html
	  // @TODO: EventTarget can be almost anything, is it okay to return only Elements?
	  var target = null;
	  if (!event) ;else if (event.target) {
	    target = event.target;
	  } else if (event.srcElement) {
	    target = event.srcElement;
	  }
	  if (!(target instanceof Element)) {
	    return null;
	  }
	  if (target.nodeType != null && target.nodeType == 3) {
	    // defeat Safari bug
	    target = target.parentNode;
	    if (!(target instanceof Element)) {
	      return null;
	    }
	  }
	  return target;
	}
	/**
	 * Check if given element contains given parent somewhere in the DOM tree.
	 *
	 * @param element - The element to be tested.
	 * @param parent - The ancestor (not necessarily parent) of the element.
	 * @returns True if parent is an ancestor of the element, false otherwise.
	 */
	function hasParent(element, parent) {
	  var elem = element;
	  while (elem) {
	    if (elem === parent) {
	      return true;
	    } else if (elem.parentNode) {
	      elem = elem.parentNode;
	    } else {
	      return false;
	    }
	  }
	  return false;
	}
	var option = {
	  /**
	   * Convert a value into a boolean.
	   *
	   * @param value - Value to be converted intoboolean, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding boolean value, if none then the default value, if none then null.
	   */
	  asBoolean: function asBoolean(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    if (value != null) {
	      return value != false;
	    }
	    return defaultValue || null;
	  },
	  /**
	   * Convert a value into a number.
	   *
	   * @param value - Value to be converted intonumber, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding **boxed** number value, if none then the default value, if none then null.
	   */
	  asNumber: function asNumber(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    if (value != null) {
	      return Number(value) || defaultValue || null;
	    }
	    return defaultValue || null;
	  },
	  /**
	   * Convert a value into a string.
	   *
	   * @param value - Value to be converted intostring, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding **boxed** string value, if none then the default value, if none then null.
	   */
	  asString: function asString(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    if (value != null) {
	      return String(value);
	    }
	    return defaultValue || null;
	  },
	  /**
	   * Convert a value into a size.
	   *
	   * @param value - Value to be converted intosize, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding string value (number + 'px'), if none then the default value, if none then null.
	   */
	  asSize: function asSize(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    if (isString(value)) {
	      return value;
	    } else if (isNumber(value)) {
	      return value + "px";
	    } else {
	      return defaultValue || null;
	    }
	  },
	  /**
	   * Convert a value into a DOM Element.
	   *
	   * @param value - Value to be converted into DOM Element, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns The DOM Element, if none then the default value, if none then null.
	   */
	  asElement: function asElement(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    return value || defaultValue || null;
	  }
	};
	/**
	 * Convert hex color string into RGB color object.
	 *
	 * @remarks
	 * {@link http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb}
	 * @param hex - Hex color string (3 or 6 digits, with or without #).
	 * @returns RGB color object.
	 */
	function hexToRGB(hex) {
	  var result;
	  switch (hex.length) {
	    case 3:
	    case 4:
	      result = shortHexRE.exec(hex);
	      return result ? {
	        r: _parseInt$1(result[1] + result[1], 16),
	        g: _parseInt$1(result[2] + result[2], 16),
	        b: _parseInt$1(result[3] + result[3], 16)
	      } : null;
	    case 6:
	    case 7:
	      result = fullHexRE.exec(hex);
	      return result ? {
	        r: _parseInt$1(result[1], 16),
	        g: _parseInt$1(result[2], 16),
	        b: _parseInt$1(result[3], 16)
	      } : null;
	    default:
	      return null;
	  }
	}
	/**
	 * This function takes string color in hex or RGB format and adds the opacity, RGBA is passed through unchanged.
	 *
	 * @param color - The color string (hex, RGB, RGBA).
	 * @param opacity - The new opacity.
	 * @returns RGBA string, for example 'rgba(255, 0, 127, 0.3)'.
	 */
	function overrideOpacity(color, opacity) {
	  if (_includesInstanceProperty(color).call(color, "rgba")) {
	    return color;
	  } else if (_includesInstanceProperty(color).call(color, "rgb")) {
	    var rgb = color.substr(_indexOfInstanceProperty(color).call(color, "(") + 1).replace(")", "").split(",");
	    return "rgba(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "," + opacity + ")";
	  } else {
	    var _rgb = hexToRGB(color);
	    if (_rgb == null) {
	      return color;
	    } else {
	      return "rgba(" + _rgb.r + "," + _rgb.g + "," + _rgb.b + "," + opacity + ")";
	    }
	  }
	}
	/**
	 * Convert RGB \<0, 255\> into hex color string.
	 *
	 * @param red - Red channel.
	 * @param green - Green channel.
	 * @param blue - Blue channel.
	 * @returns Hex color string (for example: '#0acdc0').
	 */
	function RGBToHex(red, green, blue) {
	  var _context10;
	  return "#" + _sliceInstanceProperty(_context10 = ((1 << 24) + (red << 16) + (green << 8) + blue).toString(16)).call(_context10, 1);
	}
	/**
	 * Parse a color property into an object with border, background, and highlight colors.
	 *
	 * @param inputColor - Shorthand color string or input color object.
	 * @param defaultColor - Full color object to fill in missing values in inputColor.
	 * @returns Color object.
	 */
	function parseColor(inputColor, defaultColor) {
	  if (isString(inputColor)) {
	    var colorStr = inputColor;
	    if (isValidRGB(colorStr)) {
	      var _context11;
	      var rgb = _mapInstanceProperty(_context11 = colorStr.substr(4).substr(0, colorStr.length - 5).split(",")).call(_context11, function (value) {
	        return _parseInt$1(value);
	      });
	      colorStr = RGBToHex(rgb[0], rgb[1], rgb[2]);
	    }
	    if (isValidHex(colorStr) === true) {
	      var hsv = hexToHSV(colorStr);
	      var lighterColorHSV = {
	        h: hsv.h,
	        s: hsv.s * 0.8,
	        v: Math.min(1, hsv.v * 1.02)
	      };
	      var darkerColorHSV = {
	        h: hsv.h,
	        s: Math.min(1, hsv.s * 1.25),
	        v: hsv.v * 0.8
	      };
	      var darkerColorHex = HSVToHex(darkerColorHSV.h, darkerColorHSV.s, darkerColorHSV.v);
	      var lighterColorHex = HSVToHex(lighterColorHSV.h, lighterColorHSV.s, lighterColorHSV.v);
	      return {
	        background: colorStr,
	        border: darkerColorHex,
	        highlight: {
	          background: lighterColorHex,
	          border: darkerColorHex
	        },
	        hover: {
	          background: lighterColorHex,
	          border: darkerColorHex
	        }
	      };
	    } else {
	      return {
	        background: colorStr,
	        border: colorStr,
	        highlight: {
	          background: colorStr,
	          border: colorStr
	        },
	        hover: {
	          background: colorStr,
	          border: colorStr
	        }
	      };
	    }
	  } else {
	    if (defaultColor) {
	      var color = {
	        background: inputColor.background || defaultColor.background,
	        border: inputColor.border || defaultColor.border,
	        highlight: isString(inputColor.highlight) ? {
	          border: inputColor.highlight,
	          background: inputColor.highlight
	        } : {
	          background: inputColor.highlight && inputColor.highlight.background || defaultColor.highlight.background,
	          border: inputColor.highlight && inputColor.highlight.border || defaultColor.highlight.border
	        },
	        hover: isString(inputColor.hover) ? {
	          border: inputColor.hover,
	          background: inputColor.hover
	        } : {
	          border: inputColor.hover && inputColor.hover.border || defaultColor.hover.border,
	          background: inputColor.hover && inputColor.hover.background || defaultColor.hover.background
	        }
	      };
	      return color;
	    } else {
	      var _color = {
	        background: inputColor.background || undefined,
	        border: inputColor.border || undefined,
	        highlight: isString(inputColor.highlight) ? {
	          border: inputColor.highlight,
	          background: inputColor.highlight
	        } : {
	          background: inputColor.highlight && inputColor.highlight.background || undefined,
	          border: inputColor.highlight && inputColor.highlight.border || undefined
	        },
	        hover: isString(inputColor.hover) ? {
	          border: inputColor.hover,
	          background: inputColor.hover
	        } : {
	          border: inputColor.hover && inputColor.hover.border || undefined,
	          background: inputColor.hover && inputColor.hover.background || undefined
	        }
	      };
	      return _color;
	    }
	  }
	}
	/**
	 * Convert RGB \<0, 255\> into HSV object.
	 *
	 * @remarks
	 * {@link http://www.javascripter.net/faq/rgb2hsv.htm}
	 * @param red - Red channel.
	 * @param green - Green channel.
	 * @param blue - Blue channel.
	 * @returns HSV color object.
	 */
	function RGBToHSV(red, green, blue) {
	  red = red / 255;
	  green = green / 255;
	  blue = blue / 255;
	  var minRGB = Math.min(red, Math.min(green, blue));
	  var maxRGB = Math.max(red, Math.max(green, blue));
	  // Black-gray-white
	  if (minRGB === maxRGB) {
	    return {
	      h: 0,
	      s: 0,
	      v: minRGB
	    };
	  }
	  // Colors other than black-gray-white:
	  var d = red === minRGB ? green - blue : blue === minRGB ? red - green : blue - red;
	  var h = red === minRGB ? 3 : blue === minRGB ? 1 : 5;
	  var hue = 60 * (h - d / (maxRGB - minRGB)) / 360;
	  var saturation = (maxRGB - minRGB) / maxRGB;
	  var value = maxRGB;
	  return {
	    h: hue,
	    s: saturation,
	    v: value
	  };
	}
	/**
	 * Split a string with css styles into an object with key/values.
	 *
	 * @param cssText - CSS source code to split into key/value object.
	 * @returns Key/value object corresponding to {@link cssText}.
	 */
	function splitCSSText(cssText) {
	  var tmpEllement = document.createElement("div");
	  var styles = {};
	  tmpEllement.style.cssText = cssText;
	  for (var i = 0; i < tmpEllement.style.length; ++i) {
	    styles[tmpEllement.style[i]] = tmpEllement.style.getPropertyValue(tmpEllement.style[i]);
	  }
	  return styles;
	}
	/**
	 * Append a string with css styles to an element.
	 *
	 * @param element - The element that will receive new styles.
	 * @param cssText - The styles to be appended.
	 */
	function addCssText(element, cssText) {
	  var cssStyle = splitCSSText(cssText);
	  for (var _i3 = 0, _Object$entries = _Object$entries2(cssStyle); _i3 < _Object$entries.length; _i3++) {
	    var _Object$entries$_i = _slicedToArray(_Object$entries[_i3], 2),
	      key = _Object$entries$_i[0],
	      value = _Object$entries$_i[1];
	    element.style.setProperty(key, value);
	  }
	}
	/**
	 * Remove a string with css styles from an element.
	 *
	 * @param element - The element from which styles should be removed.
	 * @param cssText - The styles to be removed.
	 */
	function removeCssText(element, cssText) {
	  var cssStyle = splitCSSText(cssText);
	  for (var _i4 = 0, _Object$keys3 = _Object$keys(cssStyle); _i4 < _Object$keys3.length; _i4++) {
	    var key = _Object$keys3[_i4];
	    element.style.removeProperty(key);
	  }
	}
	/**
	 * Convert HSV \<0, 1\> into RGB color object.
	 *
	 * @remarks
	 * {@link https://gist.github.com/mjijackson/5311256}
	 * @param h - Hue.
	 * @param s - Saturation.
	 * @param v - Value.
	 * @returns RGB color object.
	 */
	function HSVToRGB(h, s, v) {
	  var r;
	  var g;
	  var b;
	  var i = Math.floor(h * 6);
	  var f = h * 6 - i;
	  var p = v * (1 - s);
	  var q = v * (1 - f * s);
	  var t = v * (1 - (1 - f) * s);
	  switch (i % 6) {
	    case 0:
	      r = v, g = t, b = p;
	      break;
	    case 1:
	      r = q, g = v, b = p;
	      break;
	    case 2:
	      r = p, g = v, b = t;
	      break;
	    case 3:
	      r = p, g = q, b = v;
	      break;
	    case 4:
	      r = t, g = p, b = v;
	      break;
	    case 5:
	      r = v, g = p, b = q;
	      break;
	  }
	  return {
	    r: Math.floor(r * 255),
	    g: Math.floor(g * 255),
	    b: Math.floor(b * 255)
	  };
	}
	/**
	 * Convert HSV \<0, 1\> into hex color string.
	 *
	 * @param h - Hue.
	 * @param s - Saturation.
	 * @param v - Value.
	 * @returns Hex color string.
	 */
	function HSVToHex(h, s, v) {
	  var rgb = HSVToRGB(h, s, v);
	  return RGBToHex(rgb.r, rgb.g, rgb.b);
	}
	/**
	 * Convert hex color string into HSV \<0, 1\>.
	 *
	 * @param hex - Hex color string.
	 * @returns HSV color object.
	 */
	function hexToHSV(hex) {
	  var rgb = hexToRGB(hex);
	  if (!rgb) {
	    throw new TypeError("'".concat(hex, "' is not a valid color."));
	  }
	  return RGBToHSV(rgb.r, rgb.g, rgb.b);
	}
	/**
	 * Validate hex color string.
	 *
	 * @param hex - Unknown string that may contain a color.
	 * @returns True if the string is valid, false otherwise.
	 */
	function isValidHex(hex) {
	  var isOk = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
	  return isOk;
	}
	/**
	 * Validate RGB color string.
	 *
	 * @param rgb - Unknown string that may contain a color.
	 * @returns True if the string is valid, false otherwise.
	 */
	function isValidRGB(rgb) {
	  return rgbRE.test(rgb);
	}
	/**
	 * Validate RGBA color string.
	 *
	 * @param rgba - Unknown string that may contain a color.
	 * @returns True if the string is valid, false otherwise.
	 */
	function isValidRGBA(rgba) {
	  return rgbaRE.test(rgba);
	}
	/**
	 * This recursively redirects the prototype of JSON objects to the referenceObject.
	 * This is used for default options.
	 *
	 * @param fields - Names of properties to be bridged.
	 * @param referenceObject - The original object.
	 * @returns A new object inheriting from the referenceObject.
	 */
	function selectiveBridgeObject(fields, referenceObject) {
	  if (referenceObject !== null && _typeof$1(referenceObject) === "object") {
	    // !!! typeof null === 'object'
	    var objectTo = _Object$create$1(referenceObject);
	    for (var i = 0; i < fields.length; i++) {
	      if (Object.prototype.hasOwnProperty.call(referenceObject, fields[i])) {
	        if (_typeof$1(referenceObject[fields[i]]) == "object") {
	          objectTo[fields[i]] = bridgeObject(referenceObject[fields[i]]);
	        }
	      }
	    }
	    return objectTo;
	  } else {
	    return null;
	  }
	}
	/**
	 * This recursively redirects the prototype of JSON objects to the referenceObject.
	 * This is used for default options.
	 *
	 * @param referenceObject - The original object.
	 * @returns The Element if the referenceObject is an Element, or a new object inheriting from the referenceObject.
	 */
	function bridgeObject(referenceObject) {
	  if (referenceObject === null || _typeof$1(referenceObject) !== "object") {
	    return null;
	  }
	  if (referenceObject instanceof Element) {
	    // Avoid bridging DOM objects
	    return referenceObject;
	  }
	  var objectTo = _Object$create$1(referenceObject);
	  for (var i in referenceObject) {
	    if (Object.prototype.hasOwnProperty.call(referenceObject, i)) {
	      if (_typeof$1(referenceObject[i]) == "object") {
	        objectTo[i] = bridgeObject(referenceObject[i]);
	      }
	    }
	  }
	  return objectTo;
	}
	/**
	 * This method provides a stable sort implementation, very fast for presorted data.
	 *
	 * @param a - The array to be sorted (in-place).
	 * @param compare - An order comparator.
	 * @returns The argument a.
	 */
	function insertSort(a, compare) {
	  for (var i = 0; i < a.length; i++) {
	    var k = a[i];
	    var j = void 0;
	    for (j = i; j > 0 && compare(k, a[j - 1]) < 0; j--) {
	      a[j] = a[j - 1];
	    }
	    a[j] = k;
	  }
	  return a;
	}
	/**
	 * This is used to set the options of subobjects in the options object.
	 *
	 * A requirement of these subobjects is that they have an 'enabled' element
	 * which is optional for the user but mandatory for the program.
	 *
	 * The added value here of the merge is that option 'enabled' is set as required.
	 *
	 * @param mergeTarget - Either this.options or the options used for the groups.
	 * @param options - Options.
	 * @param option - Option key in the options argument.
	 * @param globalOptions - Global options, passed in to determine value of option 'enabled'.
	 */
	function mergeOptions(mergeTarget, options, option) {
	  var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
	  // Local helpers
	  var isPresent = function isPresent(obj) {
	    return obj !== null && obj !== undefined;
	  };
	  var isObject = function isObject(obj) {
	    return obj !== null && _typeof$1(obj) === "object";
	  };
	  // https://stackoverflow.com/a/34491287/1223531
	  var isEmpty = function isEmpty(obj) {
	    for (var x in obj) {
	      if (Object.prototype.hasOwnProperty.call(obj, x)) {
	        return false;
	      }
	    }
	    return true;
	  };
	  // Guards
	  if (!isObject(mergeTarget)) {
	    throw new Error("Parameter mergeTarget must be an object");
	  }
	  if (!isObject(options)) {
	    throw new Error("Parameter options must be an object");
	  }
	  if (!isPresent(option)) {
	    throw new Error("Parameter option must have a value");
	  }
	  if (!isObject(globalOptions)) {
	    throw new Error("Parameter globalOptions must be an object");
	  }
	  //
	  // Actual merge routine, separated from main logic
	  // Only a single level of options is merged. Deeper levels are ref'd. This may actually be an issue.
	  //
	  var doMerge = function doMerge(target, options, option) {
	    if (!isObject(target[option])) {
	      target[option] = {};
	    }
	    var src = options[option];
	    var dst = target[option];
	    for (var prop in src) {
	      if (Object.prototype.hasOwnProperty.call(src, prop)) {
	        dst[prop] = src[prop];
	      }
	    }
	  };
	  // Local initialization
	  var srcOption = options[option];
	  var globalPassed = isObject(globalOptions) && !isEmpty(globalOptions);
	  var globalOption = globalPassed ? globalOptions[option] : undefined;
	  var globalEnabled = globalOption ? globalOption.enabled : undefined;
	  /////////////////////////////////////////
	  // Main routine
	  /////////////////////////////////////////
	  if (srcOption === undefined) {
	    return; // Nothing to do
	  }

	  if (typeof srcOption === "boolean") {
	    if (!isObject(mergeTarget[option])) {
	      mergeTarget[option] = {};
	    }
	    mergeTarget[option].enabled = srcOption;
	    return;
	  }
	  if (srcOption === null && !isObject(mergeTarget[option])) {
	    // If possible, explicit copy from globals
	    if (isPresent(globalOption)) {
	      mergeTarget[option] = _Object$create$1(globalOption);
	    } else {
	      return; // Nothing to do
	    }
	  }

	  if (!isObject(srcOption)) {
	    return;
	  }
	  //
	  // Ensure that 'enabled' is properly set. It is required internally
	  // Note that the value from options will always overwrite the existing value
	  //
	  var enabled = true; // default value
	  if (srcOption.enabled !== undefined) {
	    enabled = srcOption.enabled;
	  } else {
	    // Take from globals, if present
	    if (globalEnabled !== undefined) {
	      enabled = globalOption.enabled;
	    }
	  }
	  doMerge(mergeTarget, options, option);
	  mergeTarget[option].enabled = enabled;
	}
	/**
	 * This function does a binary search for a visible item in a sorted list. If we find a visible item, the code that uses
	 * this function will then iterate in both directions over this sorted list to find all visible items.
	 *
	 * @param orderedItems - Items ordered by start.
	 * @param comparator - -1 is lower, 0 is equal, 1 is higher.
	 * @param field - Property name on an item (That is item[field]).
	 * @param field2 - Second property name on an item (That is item[field][field2]).
	 * @returns Index of the found item or -1 if nothing was found.
	 */
	function binarySearchCustom(orderedItems, comparator, field, field2) {
	  var maxIterations = 10000;
	  var iteration = 0;
	  var low = 0;
	  var high = orderedItems.length - 1;
	  while (low <= high && iteration < maxIterations) {
	    var middle = Math.floor((low + high) / 2);
	    var item = orderedItems[middle];
	    var value = field2 === undefined ? item[field] : item[field][field2];
	    var searchResult = comparator(value);
	    if (searchResult == 0) {
	      // jihaa, found a visible item!
	      return middle;
	    } else if (searchResult == -1) {
	      // it is too small --> increase low
	      low = middle + 1;
	    } else {
	      // it is too big --> decrease high
	      high = middle - 1;
	    }
	    iteration++;
	  }
	  return -1;
	}
	/**
	 * This function does a binary search for a specific value in a sorted array.
	 * If it does not exist but is in between of two values, we return either the
	 * one before or the one after, depending on user input If it is found, we
	 * return the index, else -1.
	 *
	 * @param orderedItems - Sorted array.
	 * @param target - The searched value.
	 * @param field - Name of the property in items to be searched.
	 * @param sidePreference - If the target is between two values, should the index of the before or the after be returned?
	 * @param comparator - An optional comparator, returning -1, 0, 1 for \<, ===, \>.
	 * @returns The index of found value or -1 if nothing was found.
	 */
	function binarySearchValue(orderedItems, target, field, sidePreference, comparator) {
	  var maxIterations = 10000;
	  var iteration = 0;
	  var low = 0;
	  var high = orderedItems.length - 1;
	  var prevValue;
	  var value;
	  var nextValue;
	  var middle;
	  comparator = comparator != undefined ? comparator : function (a, b) {
	    return a == b ? 0 : a < b ? -1 : 1;
	  };
	  while (low <= high && iteration < maxIterations) {
	    // get a new guess
	    middle = Math.floor(0.5 * (high + low));
	    prevValue = orderedItems[Math.max(0, middle - 1)][field];
	    value = orderedItems[middle][field];
	    nextValue = orderedItems[Math.min(orderedItems.length - 1, middle + 1)][field];
	    if (comparator(value, target) == 0) {
	      // we found the target
	      return middle;
	    } else if (comparator(prevValue, target) < 0 && comparator(value, target) > 0) {
	      // target is in between of the previous and the current
	      return sidePreference == "before" ? Math.max(0, middle - 1) : middle;
	    } else if (comparator(value, target) < 0 && comparator(nextValue, target) > 0) {
	      // target is in between of the current and the next
	      return sidePreference == "before" ? middle : Math.min(orderedItems.length - 1, middle + 1);
	    } else {
	      // didnt find the target, we need to change our boundaries.
	      if (comparator(value, target) < 0) {
	        // it is too small --> increase low
	        low = middle + 1;
	      } else {
	        // it is too big --> decrease high
	        high = middle - 1;
	      }
	    }
	    iteration++;
	  }
	  // didnt find anything. Return -1.
	  return -1;
	}
	/*
	 * Easing Functions.
	 * Only considering the t value for the range [0, 1] => [0, 1].
	 *
	 * Inspiration: from http://gizma.com/easing/
	 * https://gist.github.com/gre/1650294
	 */
	var easingFunctions = {
	  /**
	   * Provides no easing and no acceleration.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  linear: function linear(t) {
	    return t;
	  },
	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInQuad: function easeInQuad(t) {
	    return t * t;
	  },
	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutQuad: function easeOutQuad(t) {
	    return t * (2 - t);
	  },
	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutQuad: function easeInOutQuad(t) {
	    return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
	  },
	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInCubic: function easeInCubic(t) {
	    return t * t * t;
	  },
	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutCubic: function easeOutCubic(t) {
	    return --t * t * t + 1;
	  },
	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutCubic: function easeInOutCubic(t) {
	    return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
	  },
	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInQuart: function easeInQuart(t) {
	    return t * t * t * t;
	  },
	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutQuart: function easeOutQuart(t) {
	    return 1 - --t * t * t * t;
	  },
	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutQuart: function easeInOutQuart(t) {
	    return t < 0.5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t;
	  },
	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInQuint: function easeInQuint(t) {
	    return t * t * t * t * t;
	  },
	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutQuint: function easeOutQuint(t) {
	    return 1 + --t * t * t * t * t;
	  },
	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutQuint: function easeInOutQuint(t) {
	    return t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t;
	  }
	};
	/**
	 * Experimentaly compute the width of the scrollbar for this browser.
	 *
	 * @returns The width in pixels.
	 */
	function getScrollBarWidth() {
	  var inner = document.createElement("p");
	  inner.style.width = "100%";
	  inner.style.height = "200px";
	  var outer = document.createElement("div");
	  outer.style.position = "absolute";
	  outer.style.top = "0px";
	  outer.style.left = "0px";
	  outer.style.visibility = "hidden";
	  outer.style.width = "200px";
	  outer.style.height = "150px";
	  outer.style.overflow = "hidden";
	  outer.appendChild(inner);
	  document.body.appendChild(outer);
	  var w1 = inner.offsetWidth;
	  outer.style.overflow = "scroll";
	  var w2 = inner.offsetWidth;
	  if (w1 == w2) {
	    w2 = outer.clientWidth;
	  }
	  document.body.removeChild(outer);
	  return w1 - w2;
	}
	// @TODO: This doesn't work properly.
	// It works only for single property objects,
	// otherwise it combines all of the types in a union.
	// export function topMost<K1 extends string, V1> (
	//   pile: Record<K1, undefined | V1>[],
	//   accessors: K1 | [K1]
	// ): undefined | V1
	// export function topMost<K1 extends string, K2 extends string, V1, V2> (
	//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2>>[],
	//   accessors: [K1, K2]
	// ): undefined | V1 | V2
	// export function topMost<K1 extends string, K2 extends string, K3 extends string, V1, V2, V3> (
	//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2 | Record<K3, undefined | V3>>>[],
	//   accessors: [K1, K2, K3]
	// ): undefined | V1 | V2 | V3
	/**
	 * Get the top most property value from a pile of objects.
	 *
	 * @param pile - Array of objects, no required format.
	 * @param accessors - Array of property names.
	 * For example `object['foo']['bar']` → `['foo', 'bar']`.
	 * @returns Value of the property with given accessors path from the first pile item where it's not undefined.
	 */
	function topMost(pile, accessors) {
	  var candidate;
	  if (!_Array$isArray(accessors)) {
	    accessors = [accessors];
	  }
	  var _iterator3 = _createForOfIteratorHelper$7(pile),
	    _step3;
	  try {
	    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
	      var member = _step3.value;
	      if (member) {
	        candidate = member[accessors[0]];
	        for (var i = 1; i < accessors.length; i++) {
	          if (candidate) {
	            candidate = candidate[accessors[i]];
	          }
	        }
	        if (typeof candidate !== "undefined") {
	          break;
	        }
	      }
	    }
	  } catch (err) {
	    _iterator3.e(err);
	  } finally {
	    _iterator3.f();
	  }
	  return candidate;
	}
	var htmlColors = {
	  black: "#000000",
	  navy: "#000080",
	  darkblue: "#00008B",
	  mediumblue: "#0000CD",
	  blue: "#0000FF",
	  darkgreen: "#006400",
	  green: "#008000",
	  teal: "#008080",
	  darkcyan: "#008B8B",
	  deepskyblue: "#00BFFF",
	  darkturquoise: "#00CED1",
	  mediumspringgreen: "#00FA9A",
	  lime: "#00FF00",
	  springgreen: "#00FF7F",
	  aqua: "#00FFFF",
	  cyan: "#00FFFF",
	  midnightblue: "#191970",
	  dodgerblue: "#1E90FF",
	  lightseagreen: "#20B2AA",
	  forestgreen: "#228B22",
	  seagreen: "#2E8B57",
	  darkslategray: "#2F4F4F",
	  limegreen: "#32CD32",
	  mediumseagreen: "#3CB371",
	  turquoise: "#40E0D0",
	  royalblue: "#4169E1",
	  steelblue: "#4682B4",
	  darkslateblue: "#483D8B",
	  mediumturquoise: "#48D1CC",
	  indigo: "#4B0082",
	  darkolivegreen: "#556B2F",
	  cadetblue: "#5F9EA0",
	  cornflowerblue: "#6495ED",
	  mediumaquamarine: "#66CDAA",
	  dimgray: "#696969",
	  slateblue: "#6A5ACD",
	  olivedrab: "#6B8E23",
	  slategray: "#708090",
	  lightslategray: "#778899",
	  mediumslateblue: "#7B68EE",
	  lawngreen: "#7CFC00",
	  chartreuse: "#7FFF00",
	  aquamarine: "#7FFFD4",
	  maroon: "#800000",
	  purple: "#800080",
	  olive: "#808000",
	  gray: "#808080",
	  skyblue: "#87CEEB",
	  lightskyblue: "#87CEFA",
	  blueviolet: "#8A2BE2",
	  darkred: "#8B0000",
	  darkmagenta: "#8B008B",
	  saddlebrown: "#8B4513",
	  darkseagreen: "#8FBC8F",
	  lightgreen: "#90EE90",
	  mediumpurple: "#9370D8",
	  darkviolet: "#9400D3",
	  palegreen: "#98FB98",
	  darkorchid: "#9932CC",
	  yellowgreen: "#9ACD32",
	  sienna: "#A0522D",
	  brown: "#A52A2A",
	  darkgray: "#A9A9A9",
	  lightblue: "#ADD8E6",
	  greenyellow: "#ADFF2F",
	  paleturquoise: "#AFEEEE",
	  lightsteelblue: "#B0C4DE",
	  powderblue: "#B0E0E6",
	  firebrick: "#B22222",
	  darkgoldenrod: "#B8860B",
	  mediumorchid: "#BA55D3",
	  rosybrown: "#BC8F8F",
	  darkkhaki: "#BDB76B",
	  silver: "#C0C0C0",
	  mediumvioletred: "#C71585",
	  indianred: "#CD5C5C",
	  peru: "#CD853F",
	  chocolate: "#D2691E",
	  tan: "#D2B48C",
	  lightgrey: "#D3D3D3",
	  palevioletred: "#D87093",
	  thistle: "#D8BFD8",
	  orchid: "#DA70D6",
	  goldenrod: "#DAA520",
	  crimson: "#DC143C",
	  gainsboro: "#DCDCDC",
	  plum: "#DDA0DD",
	  burlywood: "#DEB887",
	  lightcyan: "#E0FFFF",
	  lavender: "#E6E6FA",
	  darksalmon: "#E9967A",
	  violet: "#EE82EE",
	  palegoldenrod: "#EEE8AA",
	  lightcoral: "#F08080",
	  khaki: "#F0E68C",
	  aliceblue: "#F0F8FF",
	  honeydew: "#F0FFF0",
	  azure: "#F0FFFF",
	  sandybrown: "#F4A460",
	  wheat: "#F5DEB3",
	  beige: "#F5F5DC",
	  whitesmoke: "#F5F5F5",
	  mintcream: "#F5FFFA",
	  ghostwhite: "#F8F8FF",
	  salmon: "#FA8072",
	  antiquewhite: "#FAEBD7",
	  linen: "#FAF0E6",
	  lightgoldenrodyellow: "#FAFAD2",
	  oldlace: "#FDF5E6",
	  red: "#FF0000",
	  fuchsia: "#FF00FF",
	  magenta: "#FF00FF",
	  deeppink: "#FF1493",
	  orangered: "#FF4500",
	  tomato: "#FF6347",
	  hotpink: "#FF69B4",
	  coral: "#FF7F50",
	  darkorange: "#FF8C00",
	  lightsalmon: "#FFA07A",
	  orange: "#FFA500",
	  lightpink: "#FFB6C1",
	  pink: "#FFC0CB",
	  gold: "#FFD700",
	  peachpuff: "#FFDAB9",
	  navajowhite: "#FFDEAD",
	  moccasin: "#FFE4B5",
	  bisque: "#FFE4C4",
	  mistyrose: "#FFE4E1",
	  blanchedalmond: "#FFEBCD",
	  papayawhip: "#FFEFD5",
	  lavenderblush: "#FFF0F5",
	  seashell: "#FFF5EE",
	  cornsilk: "#FFF8DC",
	  lemonchiffon: "#FFFACD",
	  floralwhite: "#FFFAF0",
	  snow: "#FFFAFA",
	  yellow: "#FFFF00",
	  lightyellow: "#FFFFE0",
	  ivory: "#FFFFF0",
	  white: "#FFFFFF"
	};

	/**
	 * @param {number} [pixelRatio=1]
	 */
	var ColorPicker$1 = /*#__PURE__*/function () {
	  /**
	   * @param {number} [pixelRatio=1]
	   */
	  function ColorPicker() {
	    var pixelRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
	    _classCallCheck(this, ColorPicker);
	    this.pixelRatio = pixelRatio;
	    this.generated = false;
	    this.centerCoordinates = {
	      x: 289 / 2,
	      y: 289 / 2
	    };
	    this.r = 289 * 0.49;
	    this.color = {
	      r: 255,
	      g: 255,
	      b: 255,
	      a: 1.0
	    };
	    this.hueCircle = undefined;
	    this.initialColor = {
	      r: 255,
	      g: 255,
	      b: 255,
	      a: 1.0
	    };
	    this.previousColor = undefined;
	    this.applied = false;

	    // bound by
	    this.updateCallback = function () {};
	    this.closeCallback = function () {};

	    // create all DOM elements
	    this._create();
	  }

	  /**
	   * this inserts the colorPicker into a div from the DOM
	   *
	   * @param {Element} container
	   */
	  _createClass(ColorPicker, [{
	    key: "insertTo",
	    value: function insertTo(container) {
	      if (this.hammer !== undefined) {
	        this.hammer.destroy();
	        this.hammer = undefined;
	      }
	      this.container = container;
	      this.container.appendChild(this.frame);
	      this._bindHammer();
	      this._setSize();
	    }

	    /**
	     * the callback is executed on apply and save. Bind it to the application
	     *
	     * @param {Function} callback
	     */
	  }, {
	    key: "setUpdateCallback",
	    value: function setUpdateCallback(callback) {
	      if (typeof callback === "function") {
	        this.updateCallback = callback;
	      } else {
	        throw new Error("Function attempted to set as colorPicker update callback is not a function.");
	      }
	    }

	    /**
	     * the callback is executed on apply and save. Bind it to the application
	     *
	     * @param {Function} callback
	     */
	  }, {
	    key: "setCloseCallback",
	    value: function setCloseCallback(callback) {
	      if (typeof callback === "function") {
	        this.closeCallback = callback;
	      } else {
	        throw new Error("Function attempted to set as colorPicker closing callback is not a function.");
	      }
	    }

	    /**
	     *
	     * @param {string} color
	     * @returns {string}
	     * @private
	     */
	  }, {
	    key: "_isColorString",
	    value: function _isColorString(color) {
	      if (typeof color === "string") {
	        return htmlColors[color];
	      }
	    }

	    /**
	     * Set the color of the colorPicker
	     * Supported formats:
	     * 'red'                   --> HTML color string
	     * '#ffffff'               --> hex string
	     * 'rgb(255,255,255)'      --> rgb string
	     * 'rgba(255,255,255,1.0)' --> rgba string
	     * {r:255,g:255,b:255}     --> rgb object
	     * {r:255,g:255,b:255,a:1.0} --> rgba object
	     *
	     * @param {string | object} color
	     * @param {boolean} [setInitial=true]
	     */
	  }, {
	    key: "setColor",
	    value: function setColor(color) {
	      var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      if (color === "none") {
	        return;
	      }
	      var rgba;

	      // if a html color shorthand is used, convert to hex
	      var htmlColor = this._isColorString(color);
	      if (htmlColor !== undefined) {
	        color = htmlColor;
	      }

	      // check format
	      if (isString(color) === true) {
	        if (isValidRGB(color) === true) {
	          var rgbaArray = color.substr(4).substr(0, color.length - 5).split(",");
	          rgba = {
	            r: rgbaArray[0],
	            g: rgbaArray[1],
	            b: rgbaArray[2],
	            a: 1.0
	          };
	        } else if (isValidRGBA(color) === true) {
	          var _rgbaArray = color.substr(5).substr(0, color.length - 6).split(",");
	          rgba = {
	            r: _rgbaArray[0],
	            g: _rgbaArray[1],
	            b: _rgbaArray[2],
	            a: _rgbaArray[3]
	          };
	        } else if (isValidHex(color) === true) {
	          var rgbObj = hexToRGB(color);
	          rgba = {
	            r: rgbObj.r,
	            g: rgbObj.g,
	            b: rgbObj.b,
	            a: 1.0
	          };
	        }
	      } else {
	        if (color instanceof Object) {
	          if (color.r !== undefined && color.g !== undefined && color.b !== undefined) {
	            var alpha = color.a !== undefined ? color.a : "1.0";
	            rgba = {
	              r: color.r,
	              g: color.g,
	              b: color.b,
	              a: alpha
	            };
	          }
	        }
	      }

	      // set color
	      if (rgba === undefined) {
	        throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: " + _JSON$stringify(color));
	      } else {
	        this._setColor(rgba, setInitial);
	      }
	    }

	    /**
	     * this shows the color picker.
	     * The hue circle is constructed once and stored.
	     */
	  }, {
	    key: "show",
	    value: function show() {
	      if (this.closeCallback !== undefined) {
	        this.closeCallback();
	        this.closeCallback = undefined;
	      }
	      this.applied = false;
	      this.frame.style.display = "block";
	      this._generateHueCircle();
	    }

	    // ------------------------------------------ PRIVATE ----------------------------- //

	    /**
	     * Hide the picker. Is called by the cancel button.
	     * Optional boolean to store the previous color for easy access later on.
	     *
	     * @param {boolean} [storePrevious=true]
	     * @private
	     */
	  }, {
	    key: "_hide",
	    value: function _hide() {
	      var _this2 = this;
	      var storePrevious = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
	      // store the previous color for next time;
	      if (storePrevious === true) {
	        this.previousColor = _Object$assign({}, this.color);
	      }
	      if (this.applied === true) {
	        this.updateCallback(this.initialColor);
	      }
	      this.frame.style.display = "none";

	      // call the closing callback, restoring the onclick method.
	      // this is in a setTimeout because it will trigger the show again before the click is done.
	      _setTimeout(function () {
	        if (_this2.closeCallback !== undefined) {
	          _this2.closeCallback();
	          _this2.closeCallback = undefined;
	        }
	      }, 0);
	    }

	    /**
	     * bound to the save button. Saves and hides.
	     *
	     * @private
	     */
	  }, {
	    key: "_save",
	    value: function _save() {
	      this.updateCallback(this.color);
	      this.applied = false;
	      this._hide();
	    }

	    /**
	     * Bound to apply button. Saves but does not close. Is undone by the cancel button.
	     *
	     * @private
	     */
	  }, {
	    key: "_apply",
	    value: function _apply() {
	      this.applied = true;
	      this.updateCallback(this.color);
	      this._updatePicker(this.color);
	    }

	    /**
	     * load the color from the previous session.
	     *
	     * @private
	     */
	  }, {
	    key: "_loadLast",
	    value: function _loadLast() {
	      if (this.previousColor !== undefined) {
	        this.setColor(this.previousColor, false);
	      } else {
	        alert("There is no last color to load...");
	      }
	    }

	    /**
	     * set the color, place the picker
	     *
	     * @param {object} rgba
	     * @param {boolean} [setInitial=true]
	     * @private
	     */
	  }, {
	    key: "_setColor",
	    value: function _setColor(rgba) {
	      var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      // store the initial color
	      if (setInitial === true) {
	        this.initialColor = _Object$assign({}, rgba);
	      }
	      this.color = rgba;
	      var hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
	      var angleConvert = 2 * Math.PI;
	      var radius = this.r * hsv.s;
	      var x = this.centerCoordinates.x + radius * Math.sin(angleConvert * hsv.h);
	      var y = this.centerCoordinates.y + radius * Math.cos(angleConvert * hsv.h);
	      this.colorPickerSelector.style.left = x - 0.5 * this.colorPickerSelector.clientWidth + "px";
	      this.colorPickerSelector.style.top = y - 0.5 * this.colorPickerSelector.clientHeight + "px";
	      this._updatePicker(rgba);
	    }

	    /**
	     * bound to opacity control
	     *
	     * @param {number} value
	     * @private
	     */
	  }, {
	    key: "_setOpacity",
	    value: function _setOpacity(value) {
	      this.color.a = value / 100;
	      this._updatePicker(this.color);
	    }

	    /**
	     * bound to brightness control
	     *
	     * @param {number} value
	     * @private
	     */
	  }, {
	    key: "_setBrightness",
	    value: function _setBrightness(value) {
	      var hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
	      hsv.v = value / 100;
	      var rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
	      rgba["a"] = this.color.a;
	      this.color = rgba;
	      this._updatePicker();
	    }

	    /**
	     * update the color picker. A black circle overlays the hue circle to mimic the brightness decreasing.
	     *
	     * @param {object} rgba
	     * @private
	     */
	  }, {
	    key: "_updatePicker",
	    value: function _updatePicker() {
	      var rgba = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.color;
	      var hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
	      var ctx = this.colorPickerCanvas.getContext("2d");
	      if (this.pixelRation === undefined) {
	        this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
	      }
	      ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);

	      // clear the canvas
	      var w = this.colorPickerCanvas.clientWidth;
	      var h = this.colorPickerCanvas.clientHeight;
	      ctx.clearRect(0, 0, w, h);
	      ctx.putImageData(this.hueCircle, 0, 0);
	      ctx.fillStyle = "rgba(0,0,0," + (1 - hsv.v) + ")";
	      ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
	      _fillInstanceProperty(ctx).call(ctx);
	      this.brightnessRange.value = 100 * hsv.v;
	      this.opacityRange.value = 100 * rgba.a;
	      this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
	      this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
	    }

	    /**
	     * used by create to set the size of the canvas.
	     *
	     * @private
	     */
	  }, {
	    key: "_setSize",
	    value: function _setSize() {
	      this.colorPickerCanvas.style.width = "100%";
	      this.colorPickerCanvas.style.height = "100%";
	      this.colorPickerCanvas.width = 289 * this.pixelRatio;
	      this.colorPickerCanvas.height = 289 * this.pixelRatio;
	    }

	    /**
	     * create all dom elements
	     * TODO: cleanup, lots of similar dom elements
	     *
	     * @private
	     */
	  }, {
	    key: "_create",
	    value: function _create() {
	      var _context12, _context13, _context14, _context15;
	      this.frame = document.createElement("div");
	      this.frame.className = "vis-color-picker";
	      this.colorPickerDiv = document.createElement("div");
	      this.colorPickerSelector = document.createElement("div");
	      this.colorPickerSelector.className = "vis-selector";
	      this.colorPickerDiv.appendChild(this.colorPickerSelector);
	      this.colorPickerCanvas = document.createElement("canvas");
	      this.colorPickerDiv.appendChild(this.colorPickerCanvas);
	      if (!this.colorPickerCanvas.getContext) {
	        var noCanvas = document.createElement("DIV");
	        noCanvas.style.color = "red";
	        noCanvas.style.fontWeight = "bold";
	        noCanvas.style.padding = "10px";
	        noCanvas.innerText = "Error: your browser does not support HTML canvas";
	        this.colorPickerCanvas.appendChild(noCanvas);
	      } else {
	        var ctx = this.colorPickerCanvas.getContext("2d");
	        this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
	        this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);
	      }
	      this.colorPickerDiv.className = "vis-color";
	      this.opacityDiv = document.createElement("div");
	      this.opacityDiv.className = "vis-opacity";
	      this.brightnessDiv = document.createElement("div");
	      this.brightnessDiv.className = "vis-brightness";
	      this.arrowDiv = document.createElement("div");
	      this.arrowDiv.className = "vis-arrow";
	      this.opacityRange = document.createElement("input");
	      try {
	        this.opacityRange.type = "range"; // Not supported on IE9
	        this.opacityRange.min = "0";
	        this.opacityRange.max = "100";
	      } catch (err) {
	        // TODO: Add some error handling.
	      }
	      this.opacityRange.value = "100";
	      this.opacityRange.className = "vis-range";
	      this.brightnessRange = document.createElement("input");
	      try {
	        this.brightnessRange.type = "range"; // Not supported on IE9
	        this.brightnessRange.min = "0";
	        this.brightnessRange.max = "100";
	      } catch (err) {
	        // TODO: Add some error handling.
	      }
	      this.brightnessRange.value = "100";
	      this.brightnessRange.className = "vis-range";
	      this.opacityDiv.appendChild(this.opacityRange);
	      this.brightnessDiv.appendChild(this.brightnessRange);
	      var me = this;
	      this.opacityRange.onchange = function () {
	        me._setOpacity(this.value);
	      };
	      this.opacityRange.oninput = function () {
	        me._setOpacity(this.value);
	      };
	      this.brightnessRange.onchange = function () {
	        me._setBrightness(this.value);
	      };
	      this.brightnessRange.oninput = function () {
	        me._setBrightness(this.value);
	      };
	      this.brightnessLabel = document.createElement("div");
	      this.brightnessLabel.className = "vis-label vis-brightness";
	      this.brightnessLabel.innerText = "brightness:";
	      this.opacityLabel = document.createElement("div");
	      this.opacityLabel.className = "vis-label vis-opacity";
	      this.opacityLabel.innerText = "opacity:";
	      this.newColorDiv = document.createElement("div");
	      this.newColorDiv.className = "vis-new-color";
	      this.newColorDiv.innerText = "new";
	      this.initialColorDiv = document.createElement("div");
	      this.initialColorDiv.className = "vis-initial-color";
	      this.initialColorDiv.innerText = "initial";
	      this.cancelButton = document.createElement("div");
	      this.cancelButton.className = "vis-button vis-cancel";
	      this.cancelButton.innerText = "cancel";
	      this.cancelButton.onclick = _bindInstanceProperty$1(_context12 = this._hide).call(_context12, this, false);
	      this.applyButton = document.createElement("div");
	      this.applyButton.className = "vis-button vis-apply";
	      this.applyButton.innerText = "apply";
	      this.applyButton.onclick = _bindInstanceProperty$1(_context13 = this._apply).call(_context13, this);
	      this.saveButton = document.createElement("div");
	      this.saveButton.className = "vis-button vis-save";
	      this.saveButton.innerText = "save";
	      this.saveButton.onclick = _bindInstanceProperty$1(_context14 = this._save).call(_context14, this);
	      this.loadButton = document.createElement("div");
	      this.loadButton.className = "vis-button vis-load";
	      this.loadButton.innerText = "load last";
	      this.loadButton.onclick = _bindInstanceProperty$1(_context15 = this._loadLast).call(_context15, this);
	      this.frame.appendChild(this.colorPickerDiv);
	      this.frame.appendChild(this.arrowDiv);
	      this.frame.appendChild(this.brightnessLabel);
	      this.frame.appendChild(this.brightnessDiv);
	      this.frame.appendChild(this.opacityLabel);
	      this.frame.appendChild(this.opacityDiv);
	      this.frame.appendChild(this.newColorDiv);
	      this.frame.appendChild(this.initialColorDiv);
	      this.frame.appendChild(this.cancelButton);
	      this.frame.appendChild(this.applyButton);
	      this.frame.appendChild(this.saveButton);
	      this.frame.appendChild(this.loadButton);
	    }

	    /**
	     * bind hammer to the color picker
	     *
	     * @private
	     */
	  }, {
	    key: "_bindHammer",
	    value: function _bindHammer() {
	      var _this3 = this;
	      this.drag = {};
	      this.pinch = {};
	      this.hammer = new Hammer$1(this.colorPickerCanvas);
	      this.hammer.get("pinch").set({
	        enable: true
	      });
	      this.hammer.on("hammer.input", function (event) {
	        if (event.isFirst) {
	          _this3._moveSelector(event);
	        }
	      });
	      this.hammer.on("tap", function (event) {
	        _this3._moveSelector(event);
	      });
	      this.hammer.on("panstart", function (event) {
	        _this3._moveSelector(event);
	      });
	      this.hammer.on("panmove", function (event) {
	        _this3._moveSelector(event);
	      });
	      this.hammer.on("panend", function (event) {
	        _this3._moveSelector(event);
	      });
	    }

	    /**
	     * generate the hue circle. This is relatively heavy (200ms) and is done only once on the first time it is shown.
	     *
	     * @private
	     */
	  }, {
	    key: "_generateHueCircle",
	    value: function _generateHueCircle() {
	      if (this.generated === false) {
	        var ctx = this.colorPickerCanvas.getContext("2d");
	        if (this.pixelRation === undefined) {
	          this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
	        }
	        ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);

	        // clear the canvas
	        var w = this.colorPickerCanvas.clientWidth;
	        var h = this.colorPickerCanvas.clientHeight;
	        ctx.clearRect(0, 0, w, h);

	        // draw hue circle
	        var x, y, hue, sat;
	        this.centerCoordinates = {
	          x: w * 0.5,
	          y: h * 0.5
	        };
	        this.r = 0.49 * w;
	        var angleConvert = 2 * Math.PI / 360;
	        var hfac = 1 / 360;
	        var sfac = 1 / this.r;
	        var rgb;
	        for (hue = 0; hue < 360; hue++) {
	          for (sat = 0; sat < this.r; sat++) {
	            x = this.centerCoordinates.x + sat * Math.sin(angleConvert * hue);
	            y = this.centerCoordinates.y + sat * Math.cos(angleConvert * hue);
	            rgb = HSVToRGB(hue * hfac, sat * sfac, 1);
	            ctx.fillStyle = "rgb(" + rgb.r + "," + rgb.g + "," + rgb.b + ")";
	            ctx.fillRect(x - 0.5, y - 0.5, 2, 2);
	          }
	        }
	        ctx.strokeStyle = "rgba(0,0,0,1)";
	        ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
	        ctx.stroke();
	        this.hueCircle = ctx.getImageData(0, 0, w, h);
	      }
	      this.generated = true;
	    }

	    /**
	     * move the selector. This is called by hammer functions.
	     *
	     * @param {Event}  event   The event
	     * @private
	     */
	  }, {
	    key: "_moveSelector",
	    value: function _moveSelector(event) {
	      var rect = this.colorPickerDiv.getBoundingClientRect();
	      var left = event.center.x - rect.left;
	      var top = event.center.y - rect.top;
	      var centerY = 0.5 * this.colorPickerDiv.clientHeight;
	      var centerX = 0.5 * this.colorPickerDiv.clientWidth;
	      var x = left - centerX;
	      var y = top - centerY;
	      var angle = Math.atan2(x, y);
	      var radius = 0.98 * Math.min(Math.sqrt(x * x + y * y), centerX);
	      var newTop = Math.cos(angle) * radius + centerY;
	      var newLeft = Math.sin(angle) * radius + centerX;
	      this.colorPickerSelector.style.top = newTop - 0.5 * this.colorPickerSelector.clientHeight + "px";
	      this.colorPickerSelector.style.left = newLeft - 0.5 * this.colorPickerSelector.clientWidth + "px";

	      // set color
	      var h = angle / (2 * Math.PI);
	      h = h < 0 ? h + 1 : h;
	      var s = radius / this.r;
	      var hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
	      hsv.h = h;
	      hsv.s = s;
	      var rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
	      rgba["a"] = this.color.a;
	      this.color = rgba;

	      // update previews
	      this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
	      this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
	    }
	  }]);
	  return ColorPicker;
	}();

	/**
	 * Wrap given text (last argument) in HTML elements (all preceding arguments).
	 *
	 * @param {...any} rest - List of tag names followed by inner text.
	 * @returns An element or a text node.
	 */
	function wrapInTag() {
	  for (var _len5 = arguments.length, rest = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
	    rest[_key5] = arguments[_key5];
	  }
	  if (rest.length < 1) {
	    throw new TypeError("Invalid arguments.");
	  } else if (rest.length === 1) {
	    return document.createTextNode(rest[0]);
	  } else {
	    var element = document.createElement(rest[0]);
	    element.appendChild(wrapInTag.apply(void 0, _toConsumableArray(_sliceInstanceProperty(rest).call(rest, 1))));
	    return element;
	  }
	}

	/**
	 * The way this works is for all properties of this.possible options, you can supply the property name in any form to list the options.
	 * Boolean options are recognised as Boolean
	 * Number options should be written as array: [default value, min value, max value, stepsize]
	 * Colors should be written as array: ['color', '#ffffff']
	 * Strings with should be written as array: [option1, option2, option3, ..]
	 *
	 * The options are matched with their counterparts in each of the modules and the values used in the configuration are
	 */
	var Configurator$1 = /*#__PURE__*/function () {
	  /**
	   * @param {object} parentModule        | the location where parentModule.setOptions() can be called
	   * @param {object} defaultContainer    | the default container of the module
	   * @param {object} configureOptions    | the fully configured and predefined options set found in allOptions.js
	   * @param {number} pixelRatio          | canvas pixel ratio
	   * @param {Function} hideOption        | custom logic to dynamically hide options
	   */
	  function Configurator(parentModule, defaultContainer, configureOptions) {
	    var pixelRatio = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
	    var hideOption = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : function () {
	      return false;
	    };
	    _classCallCheck(this, Configurator);
	    this.parent = parentModule;
	    this.changedOptions = [];
	    this.container = defaultContainer;
	    this.allowCreation = false;
	    this.hideOption = hideOption;
	    this.options = {};
	    this.initialized = false;
	    this.popupCounter = 0;
	    this.defaultOptions = {
	      enabled: false,
	      filter: true,
	      container: undefined,
	      showButton: true
	    };
	    _Object$assign(this.options, this.defaultOptions);
	    this.configureOptions = configureOptions;
	    this.moduleOptions = {};
	    this.domElements = [];
	    this.popupDiv = {};
	    this.popupLimit = 5;
	    this.popupHistory = {};
	    this.colorPicker = new ColorPicker$1(pixelRatio);
	    this.wrapper = undefined;
	  }

	  /**
	   * refresh all options.
	   * Because all modules parse their options by themselves, we just use their options. We copy them here.
	   *
	   * @param {object} options
	   */
	  _createClass(Configurator, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options !== undefined) {
	        // reset the popup history because the indices may have been changed.
	        this.popupHistory = {};
	        this._removePopup();
	        var enabled = true;
	        if (typeof options === "string") {
	          this.options.filter = options;
	        } else if (_Array$isArray(options)) {
	          this.options.filter = options.join();
	        } else if (_typeof$1(options) === "object") {
	          if (options == null) {
	            throw new TypeError("options cannot be null");
	          }
	          if (options.container !== undefined) {
	            this.options.container = options.container;
	          }
	          if (_filterInstanceProperty(options) !== undefined) {
	            this.options.filter = _filterInstanceProperty(options);
	          }
	          if (options.showButton !== undefined) {
	            this.options.showButton = options.showButton;
	          }
	          if (options.enabled !== undefined) {
	            enabled = options.enabled;
	          }
	        } else if (typeof options === "boolean") {
	          this.options.filter = true;
	          enabled = options;
	        } else if (typeof options === "function") {
	          this.options.filter = options;
	          enabled = true;
	        }
	        if (_filterInstanceProperty(this.options) === false) {
	          enabled = false;
	        }
	        this.options.enabled = enabled;
	      }
	      this._clean();
	    }

	    /**
	     *
	     * @param {object} moduleOptions
	     */
	  }, {
	    key: "setModuleOptions",
	    value: function setModuleOptions(moduleOptions) {
	      this.moduleOptions = moduleOptions;
	      if (this.options.enabled === true) {
	        this._clean();
	        if (this.options.container !== undefined) {
	          this.container = this.options.container;
	        }
	        this._create();
	      }
	    }

	    /**
	     * Create all DOM elements
	     *
	     * @private
	     */
	  }, {
	    key: "_create",
	    value: function _create() {
	      this._clean();
	      this.changedOptions = [];
	      var filter = _filterInstanceProperty(this.options);
	      var counter = 0;
	      var show = false;
	      for (var _option in this.configureOptions) {
	        if (Object.prototype.hasOwnProperty.call(this.configureOptions, _option)) {
	          this.allowCreation = false;
	          show = false;
	          if (typeof filter === "function") {
	            show = filter(_option, []);
	            show = show || this._handleObject(this.configureOptions[_option], [_option], true);
	          } else if (filter === true || _indexOfInstanceProperty(filter).call(filter, _option) !== -1) {
	            show = true;
	          }
	          if (show !== false) {
	            this.allowCreation = true;

	            // linebreak between categories
	            if (counter > 0) {
	              this._makeItem([]);
	            }
	            // a header for the category
	            this._makeHeader(_option);

	            // get the sub options
	            this._handleObject(this.configureOptions[_option], [_option]);
	          }
	          counter++;
	        }
	      }
	      this._makeButton();
	      this._push();
	      //~ this.colorPicker.insertTo(this.container);
	    }

	    /**
	     * draw all DOM elements on the screen
	     *
	     * @private
	     */
	  }, {
	    key: "_push",
	    value: function _push() {
	      this.wrapper = document.createElement("div");
	      this.wrapper.className = "vis-configuration-wrapper";
	      this.container.appendChild(this.wrapper);
	      for (var i = 0; i < this.domElements.length; i++) {
	        this.wrapper.appendChild(this.domElements[i]);
	      }
	      this._showPopupIfNeeded();
	    }

	    /**
	     * delete all DOM elements
	     *
	     * @private
	     */
	  }, {
	    key: "_clean",
	    value: function _clean() {
	      for (var i = 0; i < this.domElements.length; i++) {
	        this.wrapper.removeChild(this.domElements[i]);
	      }
	      if (this.wrapper !== undefined) {
	        this.container.removeChild(this.wrapper);
	        this.wrapper = undefined;
	      }
	      this.domElements = [];
	      this._removePopup();
	    }

	    /**
	     * get the value from the actualOptions if it exists
	     *
	     * @param {Array} path    | where to look for the actual option
	     * @returns {*}
	     * @private
	     */
	  }, {
	    key: "_getValue",
	    value: function _getValue(path) {
	      var base = this.moduleOptions;
	      for (var i = 0; i < path.length; i++) {
	        if (base[path[i]] !== undefined) {
	          base = base[path[i]];
	        } else {
	          base = undefined;
	          break;
	        }
	      }
	      return base;
	    }

	    /**
	     * all option elements are wrapped in an item
	     *
	     * @param {Array} path    | where to look for the actual option
	     * @param {Array.<Element>} domElements
	     * @returns {number}
	     * @private
	     */
	  }, {
	    key: "_makeItem",
	    value: function _makeItem(path) {
	      if (this.allowCreation === true) {
	        var item = document.createElement("div");
	        item.className = "vis-configuration vis-config-item vis-config-s" + path.length;
	        for (var _len6 = arguments.length, domElements = new Array(_len6 > 1 ? _len6 - 1 : 0), _key6 = 1; _key6 < _len6; _key6++) {
	          domElements[_key6 - 1] = arguments[_key6];
	        }
	        _forEachInstanceProperty(domElements).call(domElements, function (element) {
	          item.appendChild(element);
	        });
	        this.domElements.push(item);
	        return this.domElements.length;
	      }
	      return 0;
	    }

	    /**
	     * header for major subjects
	     *
	     * @param {string} name
	     * @private
	     */
	  }, {
	    key: "_makeHeader",
	    value: function _makeHeader(name) {
	      var div = document.createElement("div");
	      div.className = "vis-configuration vis-config-header";
	      div.innerText = name;
	      this._makeItem([], div);
	    }

	    /**
	     * make a label, if it is an object label, it gets different styling.
	     *
	     * @param {string} name
	     * @param {Array} path    | where to look for the actual option
	     * @param {string} objectLabel
	     * @returns {HTMLElement}
	     * @private
	     */
	  }, {
	    key: "_makeLabel",
	    value: function _makeLabel(name, path) {
	      var objectLabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var div = document.createElement("div");
	      div.className = "vis-configuration vis-config-label vis-config-s" + path.length;
	      if (objectLabel === true) {
	        while (div.firstChild) {
	          div.removeChild(div.firstChild);
	        }
	        div.appendChild(wrapInTag("i", "b", name));
	      } else {
	        div.innerText = name + ":";
	      }
	      return div;
	    }

	    /**
	     * make a dropdown list for multiple possible string optoins
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeDropdown",
	    value: function _makeDropdown(arr, value, path) {
	      var select = document.createElement("select");
	      select.className = "vis-configuration vis-config-select";
	      var selectedValue = 0;
	      if (value !== undefined) {
	        if (_indexOfInstanceProperty(arr).call(arr, value) !== -1) {
	          selectedValue = _indexOfInstanceProperty(arr).call(arr, value);
	        }
	      }
	      for (var i = 0; i < arr.length; i++) {
	        var _option2 = document.createElement("option");
	        _option2.value = arr[i];
	        if (i === selectedValue) {
	          _option2.selected = "selected";
	        }
	        _option2.innerText = arr[i];
	        select.appendChild(_option2);
	      }
	      var me = this;
	      select.onchange = function () {
	        me._update(this.value, path);
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      this._makeItem(path, label, select);
	    }

	    /**
	     * make a range object for numeric options
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeRange",
	    value: function _makeRange(arr, value, path) {
	      var defaultValue = arr[0];
	      var min = arr[1];
	      var max = arr[2];
	      var step = arr[3];
	      var range = document.createElement("input");
	      range.className = "vis-configuration vis-config-range";
	      try {
	        range.type = "range"; // not supported on IE9
	        range.min = min;
	        range.max = max;
	      } catch (err) {
	        // TODO: Add some error handling.
	      }
	      range.step = step;

	      // set up the popup settings in case they are needed.
	      var popupString = "";
	      var popupValue = 0;
	      if (value !== undefined) {
	        var factor = 1.2;
	        if (value < 0 && value * factor < min) {
	          range.min = Math.ceil(value * factor);
	          popupValue = range.min;
	          popupString = "range increased";
	        } else if (value / factor < min) {
	          range.min = Math.ceil(value / factor);
	          popupValue = range.min;
	          popupString = "range increased";
	        }
	        if (value * factor > max && max !== 1) {
	          range.max = Math.ceil(value * factor);
	          popupValue = range.max;
	          popupString = "range increased";
	        }
	        range.value = value;
	      } else {
	        range.value = defaultValue;
	      }
	      var input = document.createElement("input");
	      input.className = "vis-configuration vis-config-rangeinput";
	      input.value = range.value;
	      var me = this;
	      range.onchange = function () {
	        input.value = this.value;
	        me._update(Number(this.value), path);
	      };
	      range.oninput = function () {
	        input.value = this.value;
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      var itemIndex = this._makeItem(path, label, range, input);

	      // if a popup is needed AND it has not been shown for this value, show it.
	      if (popupString !== "" && this.popupHistory[itemIndex] !== popupValue) {
	        this.popupHistory[itemIndex] = popupValue;
	        this._setupPopup(popupString, itemIndex);
	      }
	    }

	    /**
	     * make a button object
	     *
	     * @private
	     */
	  }, {
	    key: "_makeButton",
	    value: function _makeButton() {
	      var _this4 = this;
	      if (this.options.showButton === true) {
	        var generateButton = document.createElement("div");
	        generateButton.className = "vis-configuration vis-config-button";
	        generateButton.innerText = "generate options";
	        generateButton.onclick = function () {
	          _this4._printOptions();
	        };
	        generateButton.onmouseover = function () {
	          generateButton.className = "vis-configuration vis-config-button hover";
	        };
	        generateButton.onmouseout = function () {
	          generateButton.className = "vis-configuration vis-config-button";
	        };
	        this.optionsContainer = document.createElement("div");
	        this.optionsContainer.className = "vis-configuration vis-config-option-container";
	        this.domElements.push(this.optionsContainer);
	        this.domElements.push(generateButton);
	      }
	    }

	    /**
	     * prepare the popup
	     *
	     * @param {string} string
	     * @param {number} index
	     * @private
	     */
	  }, {
	    key: "_setupPopup",
	    value: function _setupPopup(string, index) {
	      var _this5 = this;
	      if (this.initialized === true && this.allowCreation === true && this.popupCounter < this.popupLimit) {
	        var div = document.createElement("div");
	        div.id = "vis-configuration-popup";
	        div.className = "vis-configuration-popup";
	        div.innerText = string;
	        div.onclick = function () {
	          _this5._removePopup();
	        };
	        this.popupCounter += 1;
	        this.popupDiv = {
	          html: div,
	          index: index
	        };
	      }
	    }

	    /**
	     * remove the popup from the dom
	     *
	     * @private
	     */
	  }, {
	    key: "_removePopup",
	    value: function _removePopup() {
	      if (this.popupDiv.html !== undefined) {
	        this.popupDiv.html.parentNode.removeChild(this.popupDiv.html);
	        clearTimeout(this.popupDiv.hideTimeout);
	        clearTimeout(this.popupDiv.deleteTimeout);
	        this.popupDiv = {};
	      }
	    }

	    /**
	     * Show the popup if it is needed.
	     *
	     * @private
	     */
	  }, {
	    key: "_showPopupIfNeeded",
	    value: function _showPopupIfNeeded() {
	      var _this6 = this;
	      if (this.popupDiv.html !== undefined) {
	        var correspondingElement = this.domElements[this.popupDiv.index];
	        var rect = correspondingElement.getBoundingClientRect();
	        this.popupDiv.html.style.left = rect.left + "px";
	        this.popupDiv.html.style.top = rect.top - 30 + "px"; // 30 is the height;
	        document.body.appendChild(this.popupDiv.html);
	        this.popupDiv.hideTimeout = _setTimeout(function () {
	          _this6.popupDiv.html.style.opacity = 0;
	        }, 1500);
	        this.popupDiv.deleteTimeout = _setTimeout(function () {
	          _this6._removePopup();
	        }, 1800);
	      }
	    }

	    /**
	     * make a checkbox for boolean options.
	     *
	     * @param {number} defaultValue
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeCheckbox",
	    value: function _makeCheckbox(defaultValue, value, path) {
	      var checkbox = document.createElement("input");
	      checkbox.type = "checkbox";
	      checkbox.className = "vis-configuration vis-config-checkbox";
	      checkbox.checked = defaultValue;
	      if (value !== undefined) {
	        checkbox.checked = value;
	        if (value !== defaultValue) {
	          if (_typeof$1(defaultValue) === "object") {
	            if (value !== defaultValue.enabled) {
	              this.changedOptions.push({
	                path: path,
	                value: value
	              });
	            }
	          } else {
	            this.changedOptions.push({
	              path: path,
	              value: value
	            });
	          }
	        }
	      }
	      var me = this;
	      checkbox.onchange = function () {
	        me._update(this.checked, path);
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      this._makeItem(path, label, checkbox);
	    }

	    /**
	     * make a text input field for string options.
	     *
	     * @param {number} defaultValue
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeTextInput",
	    value: function _makeTextInput(defaultValue, value, path) {
	      var checkbox = document.createElement("input");
	      checkbox.type = "text";
	      checkbox.className = "vis-configuration vis-config-text";
	      checkbox.value = value;
	      if (value !== defaultValue) {
	        this.changedOptions.push({
	          path: path,
	          value: value
	        });
	      }
	      var me = this;
	      checkbox.onchange = function () {
	        me._update(this.value, path);
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      this._makeItem(path, label, checkbox);
	    }

	    /**
	     * make a color field with a color picker for color fields
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeColorField",
	    value: function _makeColorField(arr, value, path) {
	      var _this7 = this;
	      var defaultColor = arr[1];
	      var div = document.createElement("div");
	      value = value === undefined ? defaultColor : value;
	      if (value !== "none") {
	        div.className = "vis-configuration vis-config-colorBlock";
	        div.style.backgroundColor = value;
	      } else {
	        div.className = "vis-configuration vis-config-colorBlock none";
	      }
	      value = value === undefined ? defaultColor : value;
	      div.onclick = function () {
	        _this7._showColorPicker(value, div, path);
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      this._makeItem(path, label, div);
	    }

	    /**
	     * used by the color buttons to call the color picker.
	     *
	     * @param {number} value
	     * @param {HTMLElement} div
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_showColorPicker",
	    value: function _showColorPicker(value, div, path) {
	      var _this8 = this;
	      // clear the callback from this div
	      div.onclick = function () {};
	      this.colorPicker.insertTo(div);
	      this.colorPicker.show();
	      this.colorPicker.setColor(value);
	      this.colorPicker.setUpdateCallback(function (color) {
	        var colorString = "rgba(" + color.r + "," + color.g + "," + color.b + "," + color.a + ")";
	        div.style.backgroundColor = colorString;
	        _this8._update(colorString, path);
	      });

	      // on close of the colorpicker, restore the callback.
	      this.colorPicker.setCloseCallback(function () {
	        div.onclick = function () {
	          _this8._showColorPicker(value, div, path);
	        };
	      });
	    }

	    /**
	     * parse an object and draw the correct items
	     *
	     * @param {object} obj
	     * @param {Array} [path=[]]    | where to look for the actual option
	     * @param {boolean} [checkOnly=false]
	     * @returns {boolean}
	     * @private
	     */
	  }, {
	    key: "_handleObject",
	    value: function _handleObject(obj) {
	      var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
	      var checkOnly = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var show = false;
	      var filter = _filterInstanceProperty(this.options);
	      var visibleInSet = false;
	      for (var subObj in obj) {
	        if (Object.prototype.hasOwnProperty.call(obj, subObj)) {
	          show = true;
	          var item = obj[subObj];
	          var newPath = copyAndExtendArray(path, subObj);
	          if (typeof filter === "function") {
	            show = filter(subObj, path);

	            // if needed we must go deeper into the object.
	            if (show === false) {
	              if (!_Array$isArray(item) && typeof item !== "string" && typeof item !== "boolean" && item instanceof Object) {
	                this.allowCreation = false;
	                show = this._handleObject(item, newPath, true);
	                this.allowCreation = checkOnly === false;
	              }
	            }
	          }
	          if (show !== false) {
	            visibleInSet = true;
	            var value = this._getValue(newPath);
	            if (_Array$isArray(item)) {
	              this._handleArray(item, value, newPath);
	            } else if (typeof item === "string") {
	              this._makeTextInput(item, value, newPath);
	            } else if (typeof item === "boolean") {
	              this._makeCheckbox(item, value, newPath);
	            } else if (item instanceof Object) {
	              // skip the options that are not enabled
	              if (!this.hideOption(path, subObj, this.moduleOptions)) {
	                // initially collapse options with an disabled enabled option.
	                if (item.enabled !== undefined) {
	                  var enabledPath = copyAndExtendArray(newPath, "enabled");
	                  var enabledValue = this._getValue(enabledPath);
	                  if (enabledValue === true) {
	                    var label = this._makeLabel(subObj, newPath, true);
	                    this._makeItem(newPath, label);
	                    visibleInSet = this._handleObject(item, newPath) || visibleInSet;
	                  } else {
	                    this._makeCheckbox(item, enabledValue, newPath);
	                  }
	                } else {
	                  var _label = this._makeLabel(subObj, newPath, true);
	                  this._makeItem(newPath, _label);
	                  visibleInSet = this._handleObject(item, newPath) || visibleInSet;
	                }
	              }
	            } else {
	              console.error("dont know how to handle", item, subObj, newPath);
	            }
	          }
	        }
	      }
	      return visibleInSet;
	    }

	    /**
	     * handle the array type of option
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_handleArray",
	    value: function _handleArray(arr, value, path) {
	      if (typeof arr[0] === "string" && arr[0] === "color") {
	        this._makeColorField(arr, value, path);
	        if (arr[1] !== value) {
	          this.changedOptions.push({
	            path: path,
	            value: value
	          });
	        }
	      } else if (typeof arr[0] === "string") {
	        this._makeDropdown(arr, value, path);
	        if (arr[0] !== value) {
	          this.changedOptions.push({
	            path: path,
	            value: value
	          });
	        }
	      } else if (typeof arr[0] === "number") {
	        this._makeRange(arr, value, path);
	        if (arr[0] !== value) {
	          this.changedOptions.push({
	            path: path,
	            value: Number(value)
	          });
	        }
	      }
	    }

	    /**
	     * called to update the network with the new settings.
	     *
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_update",
	    value: function _update(value, path) {
	      var options = this._constructOptions(value, path);
	      if (this.parent.body && this.parent.body.emitter && this.parent.body.emitter.emit) {
	        this.parent.body.emitter.emit("configChange", options);
	      }
	      this.initialized = true;
	      this.parent.setOptions(options);
	    }

	    /**
	     *
	     * @param {string | boolean} value
	     * @param {Array.<string>} path
	     * @param {{}} optionsObj
	     * @returns {{}}
	     * @private
	     */
	  }, {
	    key: "_constructOptions",
	    value: function _constructOptions(value, path) {
	      var optionsObj = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	      var pointer = optionsObj;

	      // when dropdown boxes can be string or boolean, we typecast it into correct types
	      value = value === "true" ? true : value;
	      value = value === "false" ? false : value;
	      for (var i = 0; i < path.length; i++) {
	        if (path[i] !== "global") {
	          if (pointer[path[i]] === undefined) {
	            pointer[path[i]] = {};
	          }
	          if (i !== path.length - 1) {
	            pointer = pointer[path[i]];
	          } else {
	            pointer[path[i]] = value;
	          }
	        }
	      }
	      return optionsObj;
	    }

	    /**
	     * @private
	     */
	  }, {
	    key: "_printOptions",
	    value: function _printOptions() {
	      var options = this.getOptions();
	      while (this.optionsContainer.firstChild) {
	        this.optionsContainer.removeChild(this.optionsContainer.firstChild);
	      }
	      this.optionsContainer.appendChild(wrapInTag("pre", "const options = " + _JSON$stringify(options, null, 2)));
	    }

	    /**
	     *
	     * @returns {{}} options
	     */
	  }, {
	    key: "getOptions",
	    value: function getOptions() {
	      var options = {};
	      for (var i = 0; i < this.changedOptions.length; i++) {
	        this._constructOptions(this.changedOptions[i].value, this.changedOptions[i].path, options);
	      }
	      return options;
	    }
	  }]);
	  return Configurator;
	}();

	/**
	 * Popup is a class to create a popup window with some text
	 */
	var Popup$1 = /*#__PURE__*/function () {
	  /**
	   * @param {Element} container       The container object.
	   * @param {string}  overflowMethod  How the popup should act to overflowing ('flip' or 'cap')
	   */
	  function Popup(container, overflowMethod) {
	    _classCallCheck(this, Popup);
	    this.container = container;
	    this.overflowMethod = overflowMethod || "cap";
	    this.x = 0;
	    this.y = 0;
	    this.padding = 5;
	    this.hidden = false;

	    // create the frame
	    this.frame = document.createElement("div");
	    this.frame.className = "vis-tooltip";
	    this.container.appendChild(this.frame);
	  }

	  /**
	   * @param {number} x   Horizontal position of the popup window
	   * @param {number} y   Vertical position of the popup window
	   */
	  _createClass(Popup, [{
	    key: "setPosition",
	    value: function setPosition(x, y) {
	      this.x = _parseInt$1(x);
	      this.y = _parseInt$1(y);
	    }

	    /**
	     * Set the content for the popup window. This can be HTML code or text.
	     *
	     * @param {string | Element} content
	     */
	  }, {
	    key: "setText",
	    value: function setText(content) {
	      if (content instanceof Element) {
	        while (this.frame.firstChild) {
	          this.frame.removeChild(this.frame.firstChild);
	        }
	        this.frame.appendChild(content);
	      } else {
	        // String containing literal text, element has to be used for HTML due to
	        // XSS risks associated with innerHTML (i.e. prevent XSS by accident).
	        this.frame.innerText = content;
	      }
	    }

	    /**
	     * Show the popup window
	     *
	     * @param {boolean} [doShow]    Show or hide the window
	     */
	  }, {
	    key: "show",
	    value: function show(doShow) {
	      if (doShow === undefined) {
	        doShow = true;
	      }
	      if (doShow === true) {
	        var height = this.frame.clientHeight;
	        var width = this.frame.clientWidth;
	        var maxHeight = this.frame.parentNode.clientHeight;
	        var maxWidth = this.frame.parentNode.clientWidth;
	        var left = 0,
	          top = 0;
	        if (this.overflowMethod == "flip") {
	          var isLeft = false,
	            isTop = true; // Where around the position it's located

	          if (this.y - height < this.padding) {
	            isTop = false;
	          }
	          if (this.x + width > maxWidth - this.padding) {
	            isLeft = true;
	          }
	          if (isLeft) {
	            left = this.x - width;
	          } else {
	            left = this.x;
	          }
	          if (isTop) {
	            top = this.y - height;
	          } else {
	            top = this.y;
	          }
	        } else {
	          top = this.y - height;
	          if (top + height + this.padding > maxHeight) {
	            top = maxHeight - height - this.padding;
	          }
	          if (top < this.padding) {
	            top = this.padding;
	          }
	          left = this.x;
	          if (left + width + this.padding > maxWidth) {
	            left = maxWidth - width - this.padding;
	          }
	          if (left < this.padding) {
	            left = this.padding;
	          }
	        }
	        this.frame.style.left = left + "px";
	        this.frame.style.top = top + "px";
	        this.frame.style.visibility = "visible";
	        this.hidden = false;
	      } else {
	        this.hide();
	      }
	    }

	    /**
	     * Hide the popup window
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      this.hidden = true;
	      this.frame.style.left = "0";
	      this.frame.style.top = "0";
	      this.frame.style.visibility = "hidden";
	    }

	    /**
	     * Remove the popup window
	     */
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.frame.parentNode.removeChild(this.frame); // Remove element from DOM
	    }
	  }]);
	  return Popup;
	}();
	var errorFound = false;
	var allOptions$2;
	var VALIDATOR_PRINT_STYLE$1 = "background: #FFeeee; color: #dd0000";

	/**
	 *  Used to validate options.
	 */
	var Validator$1 = /*#__PURE__*/function () {
	  function Validator() {
	    _classCallCheck(this, Validator);
	  }
	  _createClass(Validator, null, [{
	    key: "validate",
	    value:
	    /**
	     * Main function to be called
	     *
	     * @param {object} options
	     * @param {object} referenceOptions
	     * @param {object} subObject
	     * @returns {boolean}
	     * @static
	     */
	    function validate(options, referenceOptions, subObject) {
	      errorFound = false;
	      allOptions$2 = referenceOptions;
	      var usedOptions = referenceOptions;
	      if (subObject !== undefined) {
	        usedOptions = referenceOptions[subObject];
	      }
	      Validator.parse(options, usedOptions, []);
	      return errorFound;
	    }

	    /**
	     * Will traverse an object recursively and check every value
	     *
	     * @param {object} options
	     * @param {object} referenceOptions
	     * @param {Array} path    | where to look for the actual option
	     * @static
	     */
	  }, {
	    key: "parse",
	    value: function parse(options, referenceOptions, path) {
	      for (var _option3 in options) {
	        if (Object.prototype.hasOwnProperty.call(options, _option3)) {
	          Validator.check(_option3, options, referenceOptions, path);
	        }
	      }
	    }

	    /**
	     * Check every value. If the value is an object, call the parse function on that object.
	     *
	     * @param {string} option
	     * @param {object} options
	     * @param {object} referenceOptions
	     * @param {Array} path    | where to look for the actual option
	     * @static
	     */
	  }, {
	    key: "check",
	    value: function check(option, options, referenceOptions, path) {
	      if (referenceOptions[option] === undefined && referenceOptions.__any__ === undefined) {
	        Validator.getSuggestion(option, referenceOptions, path);
	        return;
	      }
	      var referenceOption = option;
	      var is_object = true;
	      if (referenceOptions[option] === undefined && referenceOptions.__any__ !== undefined) {
	        // NOTE: This only triggers if the __any__ is in the top level of the options object.
	        //       THAT'S A REALLY BAD PLACE TO ALLOW IT!!!!
	        // TODO: Examine if needed, remove if possible

	        // __any__ is a wildcard. Any value is accepted and will be further analysed by reference.
	        referenceOption = "__any__";

	        // if the any-subgroup is not a predefined object in the configurator,
	        // we do not look deeper into the object.
	        is_object = Validator.getType(options[option]) === "object";
	      }
	      var refOptionObj = referenceOptions[referenceOption];
	      if (is_object && refOptionObj.__type__ !== undefined) {
	        refOptionObj = refOptionObj.__type__;
	      }
	      Validator.checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path);
	    }

	    /**
	     *
	     * @param {string}  option           | the option property
	     * @param {object}  options          | The supplied options object
	     * @param {object}  referenceOptions | The reference options containing all options and their allowed formats
	     * @param {string}  referenceOption  | Usually this is the same as option, except when handling an __any__ tag.
	     * @param {string}  refOptionObj     | This is the type object from the reference options
	     * @param {Array}   path             | where in the object is the option
	     * @static
	     */
	  }, {
	    key: "checkFields",
	    value: function checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path) {
	      var log = function log(message) {
	        console.error("%c" + message + Validator.printLocation(path, option), VALIDATOR_PRINT_STYLE$1);
	      };
	      var optionType = Validator.getType(options[option]);
	      var refOptionType = refOptionObj[optionType];
	      if (refOptionType !== undefined) {
	        // if the type is correct, we check if it is supposed to be one of a few select values
	        if (Validator.getType(refOptionType) === "array" && _indexOfInstanceProperty(refOptionType).call(refOptionType, options[option]) === -1) {
	          log('Invalid option detected in "' + option + '".' + " Allowed values are:" + Validator.print(refOptionType) + ' not "' + options[option] + '". ');
	          errorFound = true;
	        } else if (optionType === "object" && referenceOption !== "__any__") {
	          path = copyAndExtendArray(path, option);
	          Validator.parse(options[option], referenceOptions[referenceOption], path);
	        }
	      } else if (refOptionObj["any"] === undefined) {
	        // type of the field is incorrect and the field cannot be any
	        log('Invalid type received for "' + option + '". Expected: ' + Validator.print(_Object$keys(refOptionObj)) + ". Received [" + optionType + '] "' + options[option] + '"');
	        errorFound = true;
	      }
	    }

	    /**
	     *
	     * @param {object | boolean | number | string | Array.<number> | Date | Node | Moment | undefined | null} object
	     * @returns {string}
	     * @static
	     */
	  }, {
	    key: "getType",
	    value: function getType(object) {
	      var type = _typeof$1(object);
	      if (type === "object") {
	        if (object === null) {
	          return "null";
	        }
	        if (object instanceof Boolean) {
	          return "boolean";
	        }
	        if (object instanceof Number) {
	          return "number";
	        }
	        if (object instanceof String) {
	          return "string";
	        }
	        if (_Array$isArray(object)) {
	          return "array";
	        }
	        if (object instanceof Date) {
	          return "date";
	        }
	        if (object.nodeType !== undefined) {
	          return "dom";
	        }
	        if (object._isAMomentObject === true) {
	          return "moment";
	        }
	        return "object";
	      } else if (type === "number") {
	        return "number";
	      } else if (type === "boolean") {
	        return "boolean";
	      } else if (type === "string") {
	        return "string";
	      } else if (type === undefined) {
	        return "undefined";
	      }
	      return type;
	    }

	    /**
	     * @param {string} option
	     * @param {object} options
	     * @param {Array.<string>} path
	     * @static
	     */
	  }, {
	    key: "getSuggestion",
	    value: function getSuggestion(option, options, path) {
	      var localSearch = Validator.findInOptions(option, options, path, false);
	      var globalSearch = Validator.findInOptions(option, allOptions$2, [], true);
	      var localSearchThreshold = 8;
	      var globalSearchThreshold = 4;
	      var msg;
	      if (localSearch.indexMatch !== undefined) {
	        msg = " in " + Validator.printLocation(localSearch.path, option, "") + 'Perhaps it was incomplete? Did you mean: "' + localSearch.indexMatch + '"?\n\n';
	      } else if (globalSearch.distance <= globalSearchThreshold && localSearch.distance > globalSearch.distance) {
	        msg = " in " + Validator.printLocation(localSearch.path, option, "") + "Perhaps it was misplaced? Matching option found at: " + Validator.printLocation(globalSearch.path, globalSearch.closestMatch, "");
	      } else if (localSearch.distance <= localSearchThreshold) {
	        msg = '. Did you mean "' + localSearch.closestMatch + '"?' + Validator.printLocation(localSearch.path, option);
	      } else {
	        msg = ". Did you mean one of these: " + Validator.print(_Object$keys(options)) + Validator.printLocation(path, option);
	      }
	      console.error('%cUnknown option detected: "' + option + '"' + msg, VALIDATOR_PRINT_STYLE$1);
	      errorFound = true;
	    }

	    /**
	     * traverse the options in search for a match.
	     *
	     * @param {string} option
	     * @param {object} options
	     * @param {Array} path    | where to look for the actual option
	     * @param {boolean} [recursive=false]
	     * @returns {{closestMatch: string, path: Array, distance: number}}
	     * @static
	     */
	  }, {
	    key: "findInOptions",
	    value: function findInOptions(option, options, path) {
	      var recursive = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	      var min = 1e9;
	      var closestMatch = "";
	      var closestMatchPath = [];
	      var lowerCaseOption = option.toLowerCase();
	      var indexMatch = undefined;
	      for (var op in options) {
	        var distance = void 0;
	        if (options[op].__type__ !== undefined && recursive === true) {
	          var result = Validator.findInOptions(option, options[op], copyAndExtendArray(path, op));
	          if (min > result.distance) {
	            closestMatch = result.closestMatch;
	            closestMatchPath = result.path;
	            min = result.distance;
	            indexMatch = result.indexMatch;
	          }
	        } else {
	          var _context16;
	          if (_indexOfInstanceProperty(_context16 = op.toLowerCase()).call(_context16, lowerCaseOption) !== -1) {
	            indexMatch = op;
	          }
	          distance = Validator.levenshteinDistance(option, op);
	          if (min > distance) {
	            closestMatch = op;
	            closestMatchPath = copyArray(path);
	            min = distance;
	          }
	        }
	      }
	      return {
	        closestMatch: closestMatch,
	        path: closestMatchPath,
	        distance: min,
	        indexMatch: indexMatch
	      };
	    }

	    /**
	     * @param {Array.<string>} path
	     * @param {object} option
	     * @param {string} prefix
	     * @returns {string}
	     * @static
	     */
	  }, {
	    key: "printLocation",
	    value: function printLocation(path, option) {
	      var prefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "Problem value found at: \n";
	      var str = "\n\n" + prefix + "options = {\n";
	      for (var i = 0; i < path.length; i++) {
	        for (var j = 0; j < i + 1; j++) {
	          str += "  ";
	        }
	        str += path[i] + ": {\n";
	      }
	      for (var _j = 0; _j < path.length + 1; _j++) {
	        str += "  ";
	      }
	      str += option + "\n";
	      for (var _i5 = 0; _i5 < path.length + 1; _i5++) {
	        for (var _j2 = 0; _j2 < path.length - _i5; _j2++) {
	          str += "  ";
	        }
	        str += "}\n";
	      }
	      return str + "\n\n";
	    }

	    /**
	     * @param {object} options
	     * @returns {string}
	     * @static
	     */
	  }, {
	    key: "print",
	    value: function print(options) {
	      return _JSON$stringify(options).replace(/(")|(\[)|(\])|(,"__type__")/g, "").replace(/(,)/g, ", ");
	    }

	    /**
	     *  Compute the edit distance between the two given strings
	     * http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Levenshtein_distance#JavaScript
	     *
	     * Copyright (c) 2011 Andrei Mackenzie
	     *
	     * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
	     *
	     * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
	     *
	     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
	     *
	     * @param {string} a
	     * @param {string} b
	     * @returns {Array.<Array.<number>>}}
	     * @static
	     */
	  }, {
	    key: "levenshteinDistance",
	    value: function levenshteinDistance(a, b) {
	      if (a.length === 0) return b.length;
	      if (b.length === 0) return a.length;
	      var matrix = [];

	      // increment along the first column of each row
	      var i;
	      for (i = 0; i <= b.length; i++) {
	        matrix[i] = [i];
	      }

	      // increment each column in the first row
	      var j;
	      for (j = 0; j <= a.length; j++) {
	        matrix[0][j] = j;
	      }

	      // Fill in the rest of the matrix
	      for (i = 1; i <= b.length; i++) {
	        for (j = 1; j <= a.length; j++) {
	          if (b.charAt(i - 1) == a.charAt(j - 1)) {
	            matrix[i][j] = matrix[i - 1][j - 1];
	          } else {
	            matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1,
	            // substitution
	            Math.min(matrix[i][j - 1] + 1,
	            // insertion
	            matrix[i - 1][j] + 1)); // deletion
	          }
	        }
	      }

	      return matrix[b.length][a.length];
	    }
	  }]);
	  return Validator;
	}();
	var Activator = Activator$1;
	var ColorPicker = ColorPicker$1;
	var Configurator = Configurator$1;
	var Hammer = Hammer$1;
	var Popup = Popup$1;
	var VALIDATOR_PRINT_STYLE = VALIDATOR_PRINT_STYLE$1;
	var Validator = Validator$1;

	var index$2 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		Activator: Activator,
		Alea: Alea,
		ColorPicker: ColorPicker,
		Configurator: Configurator,
		DELETE: DELETE,
		HSVToHex: HSVToHex,
		HSVToRGB: HSVToRGB,
		Hammer: Hammer,
		Popup: Popup,
		RGBToHSV: RGBToHSV,
		RGBToHex: RGBToHex,
		VALIDATOR_PRINT_STYLE: VALIDATOR_PRINT_STYLE,
		Validator: Validator,
		addClassName: addClassName,
		addCssText: addCssText,
		addEventListener: addEventListener,
		binarySearchCustom: binarySearchCustom,
		binarySearchValue: binarySearchValue,
		bridgeObject: bridgeObject,
		copyAndExtendArray: copyAndExtendArray,
		copyArray: copyArray,
		deepExtend: deepExtend,
		deepObjectAssign: deepObjectAssign,
		easingFunctions: easingFunctions,
		equalArray: equalArray,
		extend: extend,
		fillIfDefined: fillIfDefined,
		forEach: forEach$4,
		getAbsoluteLeft: getAbsoluteLeft,
		getAbsoluteRight: getAbsoluteRight,
		getAbsoluteTop: getAbsoluteTop,
		getScrollBarWidth: getScrollBarWidth,
		getTarget: getTarget,
		getType: getType,
		hasParent: hasParent,
		hexToHSV: hexToHSV,
		hexToRGB: hexToRGB,
		insertSort: insertSort,
		isDate: isDate,
		isNumber: isNumber,
		isObject: isObject$a,
		isString: isString,
		isValidHex: isValidHex,
		isValidRGB: isValidRGB,
		isValidRGBA: isValidRGBA,
		mergeOptions: mergeOptions,
		option: option,
		overrideOpacity: overrideOpacity,
		parseColor: parseColor,
		preventDefault: preventDefault,
		pureDeepObjectAssign: pureDeepObjectAssign,
		recursiveDOMDelete: recursiveDOMDelete,
		removeClassName: removeClassName,
		removeCssText: removeCssText,
		removeEventListener: removeEventListener,
		selectiveBridgeObject: selectiveBridgeObject,
		selectiveDeepExtend: selectiveDeepExtend,
		selectiveExtend: selectiveExtend,
		selectiveNotDeepExtend: selectiveNotDeepExtend,
		throttle: throttle,
		toArray: toArray,
		topMost: topMost,
		updateProperty: updateProperty
	});

	/* eslint-disable no-prototype-builtins */
	/* eslint-disable no-unused-vars */
	/* eslint-disable no-var */

	/**
	 * Parse a text source containing data in DOT language into a JSON object.
	 * The object contains two lists: one with nodes and one with edges.
	 *
	 * DOT language reference: http://www.graphviz.org/doc/info/lang.html
	 *
	 * DOT language attributes: http://graphviz.org/content/attrs
	 *
	 * @param {string} data     Text containing a graph in DOT-notation
	 * @returns {object} graph   An object containing two parameters:
	 *                          {Object[]} nodes
	 *                          {Object[]} edges
	 *
	 * -------------------------------------------
	 * TODO
	 * ====
	 *
	 * For label handling, this is an incomplete implementation. From docs (quote #3015):
	 *
	 * > the escape sequences "\n", "\l" and "\r" divide the label into lines, centered,
	 * > left-justified, and right-justified, respectively.
	 *
	 * Source: http://www.graphviz.org/content/attrs#kescString
	 *
	 * > As another aid for readability, dot allows double-quoted strings to span multiple physical
	 * > lines using the standard C convention of a backslash immediately preceding a newline
	 * > character
	 * > In addition, double-quoted strings can be concatenated using a '+' operator.
	 * > As HTML strings can contain newline characters, which are used solely for formatting,
	 * > the language does not allow escaped newlines or concatenation operators to be used
	 * > within them.
	 *
	 * - Currently, only '\\n' is handled
	 * - Note that text explicitly says 'labels'; the dot parser currently handles escape
	 *   sequences in **all** strings.
	 */
	function parseDOT(data) {
	  dot = data;
	  return parseGraph();
	}

	// mapping of attributes from DOT (the keys) to vis.js (the values)
	var NODE_ATTR_MAPPING = {
	  fontsize: "font.size",
	  fontcolor: "font.color",
	  labelfontcolor: "font.color",
	  fontname: "font.face",
	  color: ["color.border", "color.background"],
	  fillcolor: "color.background",
	  tooltip: "title",
	  labeltooltip: "title"
	};
	var EDGE_ATTR_MAPPING = _Object$create$1(NODE_ATTR_MAPPING);
	EDGE_ATTR_MAPPING.color = "color.color";
	EDGE_ATTR_MAPPING.style = "dashes";

	// token types enumeration
	var TOKENTYPE = {
	  NULL: 0,
	  DELIMITER: 1,
	  IDENTIFIER: 2,
	  UNKNOWN: 3
	};

	// map with all delimiters
	var DELIMITERS = {
	  "{": true,
	  "}": true,
	  "[": true,
	  "]": true,
	  ";": true,
	  "=": true,
	  ",": true,
	  "->": true,
	  "--": true
	};
	var dot = ""; // current dot file
	var index$1 = 0; // current index in dot file
	var c = ""; // current token character in expr
	var token = ""; // current token
	var tokenType = TOKENTYPE.NULL; // type of the token

	/**
	 * Get the first character from the dot file.
	 * The character is stored into the char c. If the end of the dot file is
	 * reached, the function puts an empty string in c.
	 */
	function first() {
	  index$1 = 0;
	  c = dot.charAt(0);
	}

	/**
	 * Get the next character from the dot file.
	 * The character is stored into the char c. If the end of the dot file is
	 * reached, the function puts an empty string in c.
	 */
	function next() {
	  index$1++;
	  c = dot.charAt(index$1);
	}

	/**
	 * Preview the next character from the dot file.
	 *
	 * @returns {string} cNext
	 */
	function nextPreview() {
	  return dot.charAt(index$1 + 1);
	}

	/**
	 * Test whether given character is alphabetic or numeric ( a-zA-Z_0-9.:# )
	 *
	 * @param {string} c
	 * @returns {boolean} isAlphaNumeric
	 */
	function isAlphaNumeric(c) {
	  var charCode = c.charCodeAt(0);
	  if (charCode < 47) {
	    // #.
	    return charCode === 35 || charCode === 46;
	  }
	  if (charCode < 59) {
	    // 0-9 and :
	    return charCode > 47;
	  }
	  if (charCode < 91) {
	    // A-Z
	    return charCode > 64;
	  }
	  if (charCode < 96) {
	    // _
	    return charCode === 95;
	  }
	  if (charCode < 123) {
	    // a-z
	    return charCode > 96;
	  }
	  return false;
	}

	/**
	 * Merge all options of object b into object b
	 *
	 * @param {object} a
	 * @param {object} b
	 * @returns {object} a
	 */
	function merge$1(a, b) {
	  if (!a) {
	    a = {};
	  }
	  if (b) {
	    for (var name in b) {
	      if (b.hasOwnProperty(name)) {
	        a[name] = b[name];
	      }
	    }
	  }
	  return a;
	}

	/**
	 * Set a value in an object, where the provided parameter name can be a
	 * path with nested parameters. For example:
	 *
	 *     var obj = {a: 2};
	 *     setValue(obj, 'b.c', 3);     // obj = {a: 2, b: {c: 3}}
	 *
	 * @param {object} obj
	 * @param {string} path  A parameter name or dot-separated parameter path,
	 *                      like "color.highlight.border".
	 * @param {*} value
	 */
	function setValue(obj, path, value) {
	  var keys = path.split(".");
	  var o = obj;
	  while (keys.length) {
	    var key = keys.shift();
	    if (keys.length) {
	      // this isn't the end point
	      if (!o[key]) {
	        o[key] = {};
	      }
	      o = o[key];
	    } else {
	      // this is the end point
	      o[key] = value;
	    }
	  }
	}

	/**
	 * Add a node to a graph object. If there is already a node with
	 * the same id, their attributes will be merged.
	 *
	 * @param {object} graph
	 * @param {object} node
	 */
	function addNode(graph, node) {
	  var i, len;
	  var current = null;

	  // find root graph (in case of subgraph)
	  var graphs = [graph]; // list with all graphs from current graph to root graph
	  var root = graph;
	  while (root.parent) {
	    graphs.push(root.parent);
	    root = root.parent;
	  }

	  // find existing node (at root level) by its id
	  if (root.nodes) {
	    for (i = 0, len = root.nodes.length; i < len; i++) {
	      if (node.id === root.nodes[i].id) {
	        current = root.nodes[i];
	        break;
	      }
	    }
	  }
	  if (!current) {
	    // this is a new node
	    current = {
	      id: node.id
	    };
	    if (graph.node) {
	      // clone default attributes
	      current.attr = merge$1(current.attr, graph.node);
	    }
	  }

	  // add node to this (sub)graph and all its parent graphs
	  for (i = graphs.length - 1; i >= 0; i--) {
	    var _context;
	    var g = graphs[i];
	    if (!g.nodes) {
	      g.nodes = [];
	    }
	    if (_indexOfInstanceProperty(_context = g.nodes).call(_context, current) === -1) {
	      g.nodes.push(current);
	    }
	  }

	  // merge attributes
	  if (node.attr) {
	    current.attr = merge$1(current.attr, node.attr);
	  }
	}

	/**
	 * Add an edge to a graph object
	 *
	 * @param {object} graph
	 * @param {object} edge
	 */
	function addEdge(graph, edge) {
	  if (!graph.edges) {
	    graph.edges = [];
	  }
	  graph.edges.push(edge);
	  if (graph.edge) {
	    var attr = merge$1({}, graph.edge); // clone default attributes
	    edge.attr = merge$1(attr, edge.attr); // merge attributes
	  }
	}

	/**
	 * Create an edge to a graph object
	 *
	 * @param {object} graph
	 * @param {string | number | object} from
	 * @param {string | number | object} to
	 * @param {string} type
	 * @param {object | null} attr
	 * @returns {object} edge
	 */
	function createEdge(graph, from, to, type, attr) {
	  var edge = {
	    from: from,
	    to: to,
	    type: type
	  };
	  if (graph.edge) {
	    edge.attr = merge$1({}, graph.edge); // clone default attributes
	  }

	  edge.attr = merge$1(edge.attr || {}, attr); // merge attributes

	  // Move arrows attribute from attr to edge temporally created in
	  // parseAttributeList().
	  if (attr != null) {
	    if (attr.hasOwnProperty("arrows") && attr["arrows"] != null) {
	      edge["arrows"] = {
	        to: {
	          enabled: true,
	          type: attr.arrows.type
	        }
	      };
	      attr["arrows"] = null;
	    }
	  }
	  return edge;
	}

	/**
	 * Get next token in the current dot file.
	 * The token and token type are available as token and tokenType
	 */
	function getToken() {
	  tokenType = TOKENTYPE.NULL;
	  token = "";

	  // skip over whitespaces
	  while (c === " " || c === "\t" || c === "\n" || c === "\r") {
	    // space, tab, enter
	    next();
	  }
	  do {
	    var isComment = false;

	    // skip comment
	    if (c === "#") {
	      // find the previous non-space character
	      var i = index$1 - 1;
	      while (dot.charAt(i) === " " || dot.charAt(i) === "\t") {
	        i--;
	      }
	      if (dot.charAt(i) === "\n" || dot.charAt(i) === "") {
	        // the # is at the start of a line, this is indeed a line comment
	        while (c != "" && c != "\n") {
	          next();
	        }
	        isComment = true;
	      }
	    }
	    if (c === "/" && nextPreview() === "/") {
	      // skip line comment
	      while (c != "" && c != "\n") {
	        next();
	      }
	      isComment = true;
	    }
	    if (c === "/" && nextPreview() === "*") {
	      // skip block comment
	      while (c != "") {
	        if (c === "*" && nextPreview() === "/") {
	          // end of block comment found. skip these last two characters
	          next();
	          next();
	          break;
	        } else {
	          next();
	        }
	      }
	      isComment = true;
	    }

	    // skip over whitespaces
	    while (c === " " || c === "\t" || c === "\n" || c === "\r") {
	      // space, tab, enter
	      next();
	    }
	  } while (isComment);

	  // check for end of dot file
	  if (c === "") {
	    // token is still empty
	    tokenType = TOKENTYPE.DELIMITER;
	    return;
	  }

	  // check for delimiters consisting of 2 characters
	  var c2 = c + nextPreview();
	  if (DELIMITERS[c2]) {
	    tokenType = TOKENTYPE.DELIMITER;
	    token = c2;
	    next();
	    next();
	    return;
	  }

	  // check for delimiters consisting of 1 character
	  if (DELIMITERS[c]) {
	    tokenType = TOKENTYPE.DELIMITER;
	    token = c;
	    next();
	    return;
	  }

	  // check for an identifier (number or string)
	  // TODO: more precise parsing of numbers/strings (and the port separator ':')
	  if (isAlphaNumeric(c) || c === "-") {
	    token += c;
	    next();
	    while (isAlphaNumeric(c)) {
	      token += c;
	      next();
	    }
	    if (token === "false") {
	      token = false; // convert to boolean
	    } else if (token === "true") {
	      token = true; // convert to boolean
	    } else if (!isNaN(Number(token))) {
	      token = Number(token); // convert to number
	    }

	    tokenType = TOKENTYPE.IDENTIFIER;
	    return;
	  }

	  // check for a string enclosed by double quotes
	  if (c === '"') {
	    next();
	    while (c != "" && (c != '"' || c === '"' && nextPreview() === '"')) {
	      if (c === '"') {
	        // skip the escape character
	        token += c;
	        next();
	      } else if (c === "\\" && nextPreview() === "n") {
	        // Honor a newline escape sequence
	        token += "\n";
	        next();
	      } else {
	        token += c;
	      }
	      next();
	    }
	    if (c != '"') {
	      throw newSyntaxError('End of string " expected');
	    }
	    next();
	    tokenType = TOKENTYPE.IDENTIFIER;
	    return;
	  }

	  // something unknown is found, wrong characters, a syntax error
	  tokenType = TOKENTYPE.UNKNOWN;
	  while (c != "") {
	    token += c;
	    next();
	  }
	  throw new SyntaxError('Syntax error in part "' + chop(token, 30) + '"');
	}

	/**
	 * Parse a graph.
	 *
	 * @returns {object} graph
	 */
	function parseGraph() {
	  var graph = {};
	  first();
	  getToken();

	  // optional strict keyword
	  if (token === "strict") {
	    graph.strict = true;
	    getToken();
	  }

	  // graph or digraph keyword
	  if (token === "graph" || token === "digraph") {
	    graph.type = token;
	    getToken();
	  }

	  // optional graph id
	  if (tokenType === TOKENTYPE.IDENTIFIER) {
	    graph.id = token;
	    getToken();
	  }

	  // open angle bracket
	  if (token != "{") {
	    throw newSyntaxError("Angle bracket { expected");
	  }
	  getToken();

	  // statements
	  parseStatements(graph);

	  // close angle bracket
	  if (token != "}") {
	    throw newSyntaxError("Angle bracket } expected");
	  }
	  getToken();

	  // end of file
	  if (token !== "") {
	    throw newSyntaxError("End of file expected");
	  }
	  getToken();

	  // remove temporary default options
	  delete graph.node;
	  delete graph.edge;
	  delete graph.graph;
	  return graph;
	}

	/**
	 * Parse a list with statements.
	 *
	 * @param {object} graph
	 */
	function parseStatements(graph) {
	  while (token !== "" && token != "}") {
	    parseStatement(graph);
	    if (token === ";") {
	      getToken();
	    }
	  }
	}

	/**
	 * Parse a single statement. Can be a an attribute statement, node
	 * statement, a series of node statements and edge statements, or a
	 * parameter.
	 *
	 * @param {object} graph
	 */
	function parseStatement(graph) {
	  // parse subgraph
	  var subgraph = parseSubgraph(graph);
	  if (subgraph) {
	    // edge statements
	    parseEdge(graph, subgraph);
	    return;
	  }

	  // parse an attribute statement
	  var attr = parseAttributeStatement(graph);
	  if (attr) {
	    return;
	  }

	  // parse node
	  if (tokenType != TOKENTYPE.IDENTIFIER) {
	    throw newSyntaxError("Identifier expected");
	  }
	  var id = token; // id can be a string or a number
	  getToken();
	  if (token === "=") {
	    // id statement
	    getToken();
	    if (tokenType != TOKENTYPE.IDENTIFIER) {
	      throw newSyntaxError("Identifier expected");
	    }
	    graph[id] = token;
	    getToken();
	    // TODO: implement comma separated list with "a_list: ID=ID [','] [a_list] "
	  } else {
	    parseNodeStatement(graph, id);
	  }
	}

	/**
	 * Parse a subgraph
	 *
	 * @param {object} graph    parent graph object
	 * @returns {object | null} subgraph
	 */
	function parseSubgraph(graph) {
	  var subgraph = null;

	  // optional subgraph keyword
	  if (token === "subgraph") {
	    subgraph = {};
	    subgraph.type = "subgraph";
	    getToken();

	    // optional graph id
	    if (tokenType === TOKENTYPE.IDENTIFIER) {
	      subgraph.id = token;
	      getToken();
	    }
	  }

	  // open angle bracket
	  if (token === "{") {
	    getToken();
	    if (!subgraph) {
	      subgraph = {};
	    }
	    subgraph.parent = graph;
	    subgraph.node = graph.node;
	    subgraph.edge = graph.edge;
	    subgraph.graph = graph.graph;

	    // statements
	    parseStatements(subgraph);

	    // close angle bracket
	    if (token != "}") {
	      throw newSyntaxError("Angle bracket } expected");
	    }
	    getToken();

	    // remove temporary default options
	    delete subgraph.node;
	    delete subgraph.edge;
	    delete subgraph.graph;
	    delete subgraph.parent;

	    // register at the parent graph
	    if (!graph.subgraphs) {
	      graph.subgraphs = [];
	    }
	    graph.subgraphs.push(subgraph);
	  }
	  return subgraph;
	}

	/**
	 * parse an attribute statement like "node [shape=circle fontSize=16]".
	 * Available keywords are 'node', 'edge', 'graph'.
	 * The previous list with default attributes will be replaced
	 *
	 * @param {object} graph
	 * @returns {string | null} keyword Returns the name of the parsed attribute
	 *                                  (node, edge, graph), or null if nothing
	 *                                  is parsed.
	 */
	function parseAttributeStatement(graph) {
	  // attribute statements
	  if (token === "node") {
	    getToken();

	    // node attributes
	    graph.node = parseAttributeList();
	    return "node";
	  } else if (token === "edge") {
	    getToken();

	    // edge attributes
	    graph.edge = parseAttributeList();
	    return "edge";
	  } else if (token === "graph") {
	    getToken();

	    // graph attributes
	    graph.graph = parseAttributeList();
	    return "graph";
	  }
	  return null;
	}

	/**
	 * parse a node statement
	 *
	 * @param {object} graph
	 * @param {string | number} id
	 */
	function parseNodeStatement(graph, id) {
	  // node statement
	  var node = {
	    id: id
	  };
	  var attr = parseAttributeList();
	  if (attr) {
	    node.attr = attr;
	  }
	  addNode(graph, node);

	  // edge statements
	  parseEdge(graph, id);
	}

	/**
	 * Parse an edge or a series of edges
	 *
	 * @param {object} graph
	 * @param {string | number} from        Id of the from node
	 */
	function parseEdge(graph, from) {
	  while (token === "->" || token === "--") {
	    var to;
	    var type = token;
	    getToken();
	    var subgraph = parseSubgraph(graph);
	    if (subgraph) {
	      to = subgraph;
	    } else {
	      if (tokenType != TOKENTYPE.IDENTIFIER) {
	        throw newSyntaxError("Identifier or subgraph expected");
	      }
	      to = token;
	      addNode(graph, {
	        id: to
	      });
	      getToken();
	    }

	    // parse edge attributes
	    var attr = parseAttributeList();

	    // create edge
	    var edge = createEdge(graph, from, to, type, attr);
	    addEdge(graph, edge);
	    from = to;
	  }
	}

	/**
	 * Parse a set with attributes,
	 * for example [label="1.000", shape=solid]
	 *
	 * @returns {object | null} attr
	 */
	function parseAttributeList() {
	  var i;
	  var attr = null;

	  // edge styles of dot and vis
	  var edgeStyles = {
	    dashed: true,
	    solid: false,
	    dotted: [1, 5]
	  };

	  /**
	   * Define arrow types.
	   * vis currently supports types defined in 'arrowTypes'.
	   * Details of arrow shapes are described in
	   * http://www.graphviz.org/content/arrow-shapes
	   */
	  var arrowTypes = {
	    dot: "circle",
	    box: "box",
	    crow: "crow",
	    curve: "curve",
	    icurve: "inv_curve",
	    normal: "triangle",
	    inv: "inv_triangle",
	    diamond: "diamond",
	    tee: "bar",
	    vee: "vee"
	  };

	  /**
	   * 'attr_list' contains attributes for checking if some of them are affected
	   * later. For instance, both of 'arrowhead' and 'dir' (edge style defined
	   * in DOT) make changes to 'arrows' attribute in vis.
	   */
	  var attr_list = new Array();
	  var attr_names = new Array(); // used for checking the case.

	  // parse attributes
	  while (token === "[") {
	    getToken();
	    attr = {};
	    while (token !== "" && token != "]") {
	      if (tokenType != TOKENTYPE.IDENTIFIER) {
	        throw newSyntaxError("Attribute name expected");
	      }
	      var name = token;
	      getToken();
	      if (token != "=") {
	        throw newSyntaxError("Equal sign = expected");
	      }
	      getToken();
	      if (tokenType != TOKENTYPE.IDENTIFIER) {
	        throw newSyntaxError("Attribute value expected");
	      }
	      var value = token;

	      // convert from dot style to vis
	      if (name === "style") {
	        value = edgeStyles[value];
	      }
	      var arrowType;
	      if (name === "arrowhead") {
	        arrowType = arrowTypes[value];
	        name = "arrows";
	        value = {
	          to: {
	            enabled: true,
	            type: arrowType
	          }
	        };
	      }
	      if (name === "arrowtail") {
	        arrowType = arrowTypes[value];
	        name = "arrows";
	        value = {
	          from: {
	            enabled: true,
	            type: arrowType
	          }
	        };
	      }
	      attr_list.push({
	        attr: attr,
	        name: name,
	        value: value
	      });
	      attr_names.push(name);
	      getToken();
	      if (token == ",") {
	        getToken();
	      }
	    }
	    if (token != "]") {
	      throw newSyntaxError("Bracket ] expected");
	    }
	    getToken();
	  }

	  /**
	   * As explained in [1], graphviz has limitations for combination of
	   * arrow[head|tail] and dir. If attribute list includes 'dir',
	   * following cases just be supported.
	   *   1. both or none + arrowhead, arrowtail
	   *   2. forward + arrowhead (arrowtail is not affedted)
	   *   3. back + arrowtail (arrowhead is not affected)
	   * [1] https://www.graphviz.org/doc/info/attrs.html#h:undir_note
	   */
	  if (_includesInstanceProperty(attr_names).call(attr_names, "dir")) {
	    var idx = {}; // get index of 'arrows' and 'dir'
	    idx.arrows = {};
	    for (i = 0; i < attr_list.length; i++) {
	      if (attr_list[i].name === "arrows") {
	        if (attr_list[i].value.to != null) {
	          idx.arrows.to = i;
	        } else if (attr_list[i].value.from != null) {
	          idx.arrows.from = i;
	        } else {
	          throw newSyntaxError("Invalid value of arrows");
	        }
	      } else if (attr_list[i].name === "dir") {
	        idx.dir = i;
	      }
	    }

	    // first, add default arrow shape if it is not assigned to avoid error
	    var dir_type = attr_list[idx.dir].value;
	    if (!_includesInstanceProperty(attr_names).call(attr_names, "arrows")) {
	      if (dir_type === "both") {
	        attr_list.push({
	          attr: attr_list[idx.dir].attr,
	          name: "arrows",
	          value: {
	            to: {
	              enabled: true
	            }
	          }
	        });
	        idx.arrows.to = attr_list.length - 1;
	        attr_list.push({
	          attr: attr_list[idx.dir].attr,
	          name: "arrows",
	          value: {
	            from: {
	              enabled: true
	            }
	          }
	        });
	        idx.arrows.from = attr_list.length - 1;
	      } else if (dir_type === "forward") {
	        attr_list.push({
	          attr: attr_list[idx.dir].attr,
	          name: "arrows",
	          value: {
	            to: {
	              enabled: true
	            }
	          }
	        });
	        idx.arrows.to = attr_list.length - 1;
	      } else if (dir_type === "back") {
	        attr_list.push({
	          attr: attr_list[idx.dir].attr,
	          name: "arrows",
	          value: {
	            from: {
	              enabled: true
	            }
	          }
	        });
	        idx.arrows.from = attr_list.length - 1;
	      } else if (dir_type === "none") {
	        attr_list.push({
	          attr: attr_list[idx.dir].attr,
	          name: "arrows",
	          value: ""
	        });
	        idx.arrows.to = attr_list.length - 1;
	      } else {
	        throw newSyntaxError('Invalid dir type "' + dir_type + '"');
	      }
	    }
	    var from_type;
	    var to_type;
	    // update 'arrows' attribute from 'dir'.
	    if (dir_type === "both") {
	      // both of shapes of 'from' and 'to' are given
	      if (idx.arrows.to && idx.arrows.from) {
	        to_type = attr_list[idx.arrows.to].value.to.type;
	        from_type = attr_list[idx.arrows.from].value.from.type;
	        attr_list[idx.arrows.to] = {
	          attr: attr_list[idx.arrows.to].attr,
	          name: attr_list[idx.arrows.to].name,
	          value: {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };
	        _spliceInstanceProperty(attr_list).call(attr_list, idx.arrows.from, 1);

	        // shape of 'to' is assigned and use default to 'from'
	      } else if (idx.arrows.to) {
	        to_type = attr_list[idx.arrows.to].value.to.type;
	        from_type = "arrow";
	        attr_list[idx.arrows.to] = {
	          attr: attr_list[idx.arrows.to].attr,
	          name: attr_list[idx.arrows.to].name,
	          value: {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };

	        // only shape of 'from' is assigned and use default for 'to'
	      } else if (idx.arrows.from) {
	        to_type = "arrow";
	        from_type = attr_list[idx.arrows.from].value.from.type;
	        attr_list[idx.arrows.from] = {
	          attr: attr_list[idx.arrows.from].attr,
	          name: attr_list[idx.arrows.from].name,
	          value: {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };
	      }
	    } else if (dir_type === "back") {
	      // given both of shapes, but use only 'from'
	      if (idx.arrows.to && idx.arrows.from) {
	        to_type = "";
	        from_type = attr_list[idx.arrows.from].value.from.type;
	        attr_list[idx.arrows.from] = {
	          attr: attr_list[idx.arrows.from].attr,
	          name: attr_list[idx.arrows.from].name,
	          value: {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };

	        // given shape of 'to', but does not use it
	      } else if (idx.arrows.to) {
	        to_type = "";
	        from_type = "arrow";
	        idx.arrows.from = idx.arrows.to;
	        attr_list[idx.arrows.from] = {
	          attr: attr_list[idx.arrows.from].attr,
	          name: attr_list[idx.arrows.from].name,
	          value: {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };

	        // assign given 'from' shape
	      } else if (idx.arrows.from) {
	        to_type = "";
	        from_type = attr_list[idx.arrows.from].value.from.type;
	        attr_list[idx.arrows.to] = {
	          attr: attr_list[idx.arrows.from].attr,
	          name: attr_list[idx.arrows.from].name,
	          value: {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };
	      }
	      attr_list[idx.arrows.from] = {
	        attr: attr_list[idx.arrows.from].attr,
	        name: attr_list[idx.arrows.from].name,
	        value: {
	          from: {
	            enabled: true,
	            type: attr_list[idx.arrows.from].value.from.type
	          }
	        }
	      };
	    } else if (dir_type === "none") {
	      var idx_arrow;
	      if (idx.arrows.to) {
	        idx_arrow = idx.arrows.to;
	      } else {
	        idx_arrow = idx.arrows.from;
	      }
	      attr_list[idx_arrow] = {
	        attr: attr_list[idx_arrow].attr,
	        name: attr_list[idx_arrow].name,
	        value: ""
	      };
	    } else if (dir_type === "forward") {
	      // given both of shapes, but use only 'to'
	      if (idx.arrows.to && idx.arrows.from) {
	        to_type = attr_list[idx.arrows.to].value.to.type;
	        from_type = "";
	        attr_list[idx.arrows.to] = {
	          attr: attr_list[idx.arrows.to].attr,
	          name: attr_list[idx.arrows.to].name,
	          value: {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };

	        // assign given 'to' shape
	      } else if (idx.arrows.to) {
	        to_type = attr_list[idx.arrows.to].value.to.type;
	        from_type = "";
	        attr_list[idx.arrows.to] = {
	          attr: attr_list[idx.arrows.to].attr,
	          name: attr_list[idx.arrows.to].name,
	          value: {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };

	        // given shape of 'from', but does not use it
	      } else if (idx.arrows.from) {
	        to_type = "arrow";
	        from_type = "";
	        idx.arrows.to = idx.arrows.from;
	        attr_list[idx.arrows.to] = {
	          attr: attr_list[idx.arrows.to].attr,
	          name: attr_list[idx.arrows.to].name,
	          value: {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };
	      }
	      attr_list[idx.arrows.to] = {
	        attr: attr_list[idx.arrows.to].attr,
	        name: attr_list[idx.arrows.to].name,
	        value: {
	          to: {
	            enabled: true,
	            type: attr_list[idx.arrows.to].value.to.type
	          }
	        }
	      };
	    } else {
	      throw newSyntaxError('Invalid dir type "' + dir_type + '"');
	    }

	    // remove 'dir' attribute no need anymore
	    _spliceInstanceProperty(attr_list).call(attr_list, idx.dir, 1);
	  }

	  // parse 'penwidth'
	  var nof_attr_list;
	  if (_includesInstanceProperty(attr_names).call(attr_names, "penwidth")) {
	    var tmp_attr_list = [];
	    nof_attr_list = attr_list.length;
	    for (i = 0; i < nof_attr_list; i++) {
	      // exclude 'width' from attr_list if 'penwidth' exists
	      if (attr_list[i].name !== "width") {
	        if (attr_list[i].name === "penwidth") {
	          attr_list[i].name = "width";
	        }
	        tmp_attr_list.push(attr_list[i]);
	      }
	    }
	    attr_list = tmp_attr_list;
	  }
	  nof_attr_list = attr_list.length;
	  for (i = 0; i < nof_attr_list; i++) {
	    setValue(attr_list[i].attr, attr_list[i].name, attr_list[i].value);
	  }
	  return attr;
	}

	/**
	 * Create a syntax error with extra information on current token and index.
	 *
	 * @param {string} message
	 * @returns {SyntaxError} err
	 */
	function newSyntaxError(message) {
	  return new SyntaxError(message + ', got "' + chop(token, 30) + '" (char ' + index$1 + ")");
	}

	/**
	 * Chop off text after a maximum length
	 *
	 * @param {string} text
	 * @param {number} maxLength
	 * @returns {string}
	 */
	function chop(text, maxLength) {
	  return text.length <= maxLength ? text : text.substr(0, 27) + "...";
	}

	/**
	 * Execute a function fn for each pair of elements in two arrays
	 *
	 * @param {Array | *} array1
	 * @param {Array | *} array2
	 * @param {Function} fn
	 */
	function forEach2(array1, array2, fn) {
	  if (_Array$isArray(array1)) {
	    _forEachInstanceProperty(array1).call(array1, function (elem1) {
	      if (_Array$isArray(array2)) {
	        _forEachInstanceProperty(array2).call(array2, function (elem2) {
	          fn(elem1, elem2);
	        });
	      } else {
	        fn(elem1, array2);
	      }
	    });
	  } else {
	    if (_Array$isArray(array2)) {
	      _forEachInstanceProperty(array2).call(array2, function (elem2) {
	        fn(array1, elem2);
	      });
	    } else {
	      fn(array1, array2);
	    }
	  }
	}

	/**
	 * Set a nested property on an object
	 * When nested objects are missing, they will be created.
	 * For example setProp({}, 'font.color', 'red') will return {font: {color: 'red'}}
	 *
	 * @param {object} object
	 * @param {string} path   A dot separated string like 'font.color'
	 * @param {*} value       Value for the property
	 * @returns {object} Returns the original object, allows for chaining.
	 */
	function setProp(object, path, value) {
	  var names = path.split(".");
	  var prop = names.pop();

	  // traverse over the nested objects
	  var obj = object;
	  for (var i = 0; i < names.length; i++) {
	    var name = names[i];
	    if (!(name in obj)) {
	      obj[name] = {};
	    }
	    obj = obj[name];
	  }

	  // set the property value
	  obj[prop] = value;
	  return object;
	}

	/**
	 * Convert an object with DOT attributes to their vis.js equivalents.
	 *
	 * @param {object} attr     Object with DOT attributes
	 * @param {object} mapping
	 * @returns {object}         Returns an object with vis.js attributes
	 */
	function convertAttr(attr, mapping) {
	  var converted = {};
	  for (var prop in attr) {
	    if (attr.hasOwnProperty(prop)) {
	      var visProp = mapping[prop];
	      if (_Array$isArray(visProp)) {
	        _forEachInstanceProperty(visProp).call(visProp, function (visPropI) {
	          setProp(converted, visPropI, attr[prop]);
	        });
	      } else if (typeof visProp === "string") {
	        setProp(converted, visProp, attr[prop]);
	      } else {
	        setProp(converted, prop, attr[prop]);
	      }
	    }
	  }
	  return converted;
	}

	/**
	 * Convert a string containing a graph in DOT language into a map containing
	 * with nodes and edges in the format of graph.
	 *
	 * @param {string} data         Text containing a graph in DOT-notation
	 * @returns {object} graphData
	 */
	function DOTToGraph(data) {
	  // parse the DOT file
	  var dotData = parseDOT(data);
	  var graphData = {
	    nodes: [],
	    edges: [],
	    options: {}
	  };

	  // copy the nodes
	  if (dotData.nodes) {
	    var _context2;
	    _forEachInstanceProperty(_context2 = dotData.nodes).call(_context2, function (dotNode) {
	      var graphNode = {
	        id: dotNode.id,
	        label: String(dotNode.label || dotNode.id)
	      };
	      merge$1(graphNode, convertAttr(dotNode.attr, NODE_ATTR_MAPPING));
	      if (graphNode.image) {
	        graphNode.shape = "image";
	      }
	      graphData.nodes.push(graphNode);
	    });
	  }

	  // copy the edges
	  if (dotData.edges) {
	    var _context3;
	    /**
	     * Convert an edge in DOT format to an edge with VisGraph format
	     *
	     * @param {object} dotEdge
	     * @returns {object} graphEdge
	     */
	    var convertEdge = function convertEdge(dotEdge) {
	      var graphEdge = {
	        from: dotEdge.from,
	        to: dotEdge.to
	      };
	      merge$1(graphEdge, convertAttr(dotEdge.attr, EDGE_ATTR_MAPPING));

	      // Add arrows attribute to default styled arrow.
	      // The reason why default style is not added in parseAttributeList() is
	      // because only default is cleared before here.
	      if (graphEdge.arrows == null && dotEdge.type === "->") {
	        graphEdge.arrows = "to";
	      }
	      return graphEdge;
	    };
	    _forEachInstanceProperty(_context3 = dotData.edges).call(_context3, function (dotEdge) {
	      var from, to;
	      if (dotEdge.from instanceof Object) {
	        from = dotEdge.from.nodes;
	      } else {
	        from = {
	          id: dotEdge.from
	        };
	      }
	      if (dotEdge.to instanceof Object) {
	        to = dotEdge.to.nodes;
	      } else {
	        to = {
	          id: dotEdge.to
	        };
	      }
	      if (dotEdge.from instanceof Object && dotEdge.from.edges) {
	        var _context4;
	        _forEachInstanceProperty(_context4 = dotEdge.from.edges).call(_context4, function (subEdge) {
	          var graphEdge = convertEdge(subEdge);
	          graphData.edges.push(graphEdge);
	        });
	      }
	      forEach2(from, to, function (from, to) {
	        var subEdge = createEdge(graphData, from.id, to.id, dotEdge.type, dotEdge.attr);
	        var graphEdge = convertEdge(subEdge);
	        graphData.edges.push(graphEdge);
	      });
	      if (dotEdge.to instanceof Object && dotEdge.to.edges) {
	        var _context5;
	        _forEachInstanceProperty(_context5 = dotEdge.to.edges).call(_context5, function (subEdge) {
	          var graphEdge = convertEdge(subEdge);
	          graphData.edges.push(graphEdge);
	        });
	      }
	    });
	  }

	  // copy the options
	  if (dotData.attr) {
	    graphData.options = dotData.attr;
	  }
	  return graphData;
	}

	/* eslint-enable no-var */
	/* eslint-enable no-unused-vars */
	/* eslint-enable no-prototype-builtins */

	var dotparser = /*#__PURE__*/Object.freeze({
		__proto__: null,
		DOTToGraph: DOTToGraph,
		parseDOT: parseDOT
	});

	/**
	 * Convert Gephi to Vis.
	 *
	 * @param gephiJSON - The parsed JSON data in Gephi format.
	 * @param optionsObj - Additional options.
	 * @returns The converted data ready to be used in Vis.
	 */
	function parseGephi(gephiJSON, optionsObj) {
	  var _context;
	  var options = {
	    edges: {
	      inheritColor: false
	    },
	    nodes: {
	      fixed: false,
	      parseColor: false
	    }
	  };
	  if (optionsObj != null) {
	    if (optionsObj.fixed != null) {
	      options.nodes.fixed = optionsObj.fixed;
	    }
	    if (optionsObj.parseColor != null) {
	      options.nodes.parseColor = optionsObj.parseColor;
	    }
	    if (optionsObj.inheritColor != null) {
	      options.edges.inheritColor = optionsObj.inheritColor;
	    }
	  }
	  var gEdges = gephiJSON.edges;
	  var vEdges = _mapInstanceProperty(gEdges).call(gEdges, function (gEdge) {
	    var vEdge = {
	      from: gEdge.source,
	      id: gEdge.id,
	      to: gEdge.target
	    };
	    if (gEdge.attributes != null) {
	      vEdge.attributes = gEdge.attributes;
	    }
	    if (gEdge.label != null) {
	      vEdge.label = gEdge.label;
	    }
	    if (gEdge.attributes != null && gEdge.attributes.title != null) {
	      vEdge.title = gEdge.attributes.title;
	    }
	    if (gEdge.type === "Directed") {
	      vEdge.arrows = "to";
	    }
	    // edge['value'] = gEdge.attributes != null ? gEdge.attributes.Weight : undefined;
	    // edge['width'] = edge['value'] != null ? undefined : edgegEdge.size;
	    if (gEdge.color && options.edges.inheritColor === false) {
	      vEdge.color = gEdge.color;
	    }
	    return vEdge;
	  });
	  var vNodes = _mapInstanceProperty(_context = gephiJSON.nodes).call(_context, function (gNode) {
	    var vNode = {
	      id: gNode.id,
	      fixed: options.nodes.fixed && gNode.x != null && gNode.y != null
	    };
	    if (gNode.attributes != null) {
	      vNode.attributes = gNode.attributes;
	    }
	    if (gNode.label != null) {
	      vNode.label = gNode.label;
	    }
	    if (gNode.size != null) {
	      vNode.size = gNode.size;
	    }
	    if (gNode.attributes != null && gNode.attributes.title != null) {
	      vNode.title = gNode.attributes.title;
	    }
	    if (gNode.title != null) {
	      vNode.title = gNode.title;
	    }
	    if (gNode.x != null) {
	      vNode.x = gNode.x;
	    }
	    if (gNode.y != null) {
	      vNode.y = gNode.y;
	    }
	    if (gNode.color != null) {
	      if (options.nodes.parseColor === true) {
	        vNode.color = gNode.color;
	      } else {
	        vNode.color = {
	          background: gNode.color,
	          border: gNode.color,
	          highlight: {
	            background: gNode.color,
	            border: gNode.color
	          },
	          hover: {
	            background: gNode.color,
	            border: gNode.color
	          }
	        };
	      }
	    }
	    return vNode;
	  });
	  return {
	    nodes: vNodes,
	    edges: vEdges
	  };
	}

	var gephiParser = /*#__PURE__*/Object.freeze({
		__proto__: null,
		parseGephi: parseGephi
	});

	// English
	var en = {
	  addDescription: "Click in an empty space to place a new node.",
	  addEdge: "Add Edge",
	  addNode: "Add Node",
	  back: "Back",
	  close: "Close",
	  createEdgeError: "Cannot link edges to a cluster.",
	  del: "Delete selected",
	  deleteClusterError: "Clusters cannot be deleted.",
	  edgeDescription: "Click on a node and drag the edge to another node to connect them.",
	  edit: "Edit",
	  editClusterError: "Clusters cannot be edited.",
	  editEdge: "Edit Edge",
	  editEdgeDescription: "Click on the control points and drag them to a node to connect to it.",
	  editNode: "Edit Node"
	};
	// German
	var de = {
	  addDescription: "Klicke auf eine freie Stelle, um einen neuen Knoten zu plazieren.",
	  addEdge: "Kante hinzuf\xFCgen",
	  addNode: "Knoten hinzuf\xFCgen",
	  back: "Zur\xFCck",
	  close: "Schließen",
	  createEdgeError: "Es ist nicht m\xF6glich, Kanten mit Clustern zu verbinden.",
	  del: "L\xF6sche Auswahl",
	  deleteClusterError: "Cluster k\xF6nnen nicht gel\xF6scht werden.",
	  edgeDescription: "Klicke auf einen Knoten und ziehe die Kante zu einem anderen Knoten, um diese zu verbinden.",
	  edit: "Editieren",
	  editClusterError: "Cluster k\xF6nnen nicht editiert werden.",
	  editEdge: "Kante editieren",
	  editEdgeDescription: "Klicke auf die Verbindungspunkte und ziehe diese auf einen Knoten, um sie zu verbinden.",
	  editNode: "Knoten editieren"
	};
	// Spanish
	var es = {
	  addDescription: "Haga clic en un lugar vac\xEDo para colocar un nuevo nodo.",
	  addEdge: "A\xF1adir arista",
	  addNode: "A\xF1adir nodo",
	  back: "Atr\xE1s",
	  close: "Cerrar",
	  createEdgeError: "No se puede conectar una arista a un grupo.",
	  del: "Eliminar selecci\xF3n",
	  deleteClusterError: "No es posible eliminar grupos.",
	  edgeDescription: "Haga clic en un nodo y arrastre la arista hacia otro nodo para conectarlos.",
	  edit: "Editar",
	  editClusterError: "No es posible editar grupos.",
	  editEdge: "Editar arista",
	  editEdgeDescription: "Haga clic en un punto de control y arrastrelo a un nodo para conectarlo.",
	  editNode: "Editar nodo"
	};
	//Italiano
	var it = {
	  addDescription: "Clicca per aggiungere un nuovo nodo",
	  addEdge: "Aggiungi un vertice",
	  addNode: "Aggiungi un nodo",
	  back: "Indietro",
	  close: "Chiudere",
	  createEdgeError: "Non si possono collegare vertici ad un cluster",
	  del: "Cancella la selezione",
	  deleteClusterError: "I cluster non possono essere cancellati",
	  edgeDescription: "Clicca su un nodo e trascinalo ad un altro nodo per connetterli.",
	  edit: "Modifica",
	  editClusterError: "I clusters non possono essere modificati.",
	  editEdge: "Modifica il vertice",
	  editEdgeDescription: "Clicca sui Punti di controllo e trascinali ad un nodo per connetterli.",
	  editNode: "Modifica il nodo"
	};
	// Dutch
	var nl = {
	  addDescription: "Klik op een leeg gebied om een nieuwe node te maken.",
	  addEdge: "Link toevoegen",
	  addNode: "Node toevoegen",
	  back: "Terug",
	  close: "Sluiten",
	  createEdgeError: "Kan geen link maken naar een cluster.",
	  del: "Selectie verwijderen",
	  deleteClusterError: "Clusters kunnen niet worden verwijderd.",
	  edgeDescription: "Klik op een node en sleep de link naar een andere node om ze te verbinden.",
	  edit: "Wijzigen",
	  editClusterError: "Clusters kunnen niet worden aangepast.",
	  editEdge: "Link wijzigen",
	  editEdgeDescription: "Klik op de verbindingspunten en sleep ze naar een node om daarmee te verbinden.",
	  editNode: "Node wijzigen"
	};
	// Portuguese Brazil
	var pt = {
	  addDescription: "Clique em um espaço em branco para adicionar um novo nó",
	  addEdge: "Adicionar aresta",
	  addNode: "Adicionar nó",
	  back: "Voltar",
	  close: "Fechar",
	  createEdgeError: "Não foi possível linkar arestas a um cluster.",
	  del: "Remover selecionado",
	  deleteClusterError: "Clusters não puderam ser removidos.",
	  edgeDescription: "Clique em um nó e arraste a aresta até outro nó para conectá-los",
	  edit: "Editar",
	  editClusterError: "Clusters não puderam ser editados.",
	  editEdge: "Editar aresta",
	  editEdgeDescription: "Clique nos pontos de controle e os arraste para um nó para conectá-los",
	  editNode: "Editar nó"
	};
	// Russian
	var ru = {
	  addDescription: "Кликните в свободное место, чтобы добавить новый узел.",
	  addEdge: "Добавить ребро",
	  addNode: "Добавить узел",
	  back: "Назад",
	  close: "Закрывать",
	  createEdgeError: "Невозможно соединить ребра в кластер.",
	  del: "Удалить выбранное",
	  deleteClusterError: "Кластеры не могут быть удалены",
	  edgeDescription: "Кликните на узел и протяните ребро к другому узлу, чтобы соединить их.",
	  edit: "Редактировать",
	  editClusterError: "Кластеры недоступны для редактирования.",
	  editEdge: "Редактировать ребро",
	  editEdgeDescription: "Кликните на контрольные точки и перетащите их в узел, чтобы подключиться к нему.",
	  editNode: "Редактировать узел"
	};
	// Chinese
	var cn = {
	  addDescription: "单击空白处放置新节点。",
	  addEdge: "添加连接线",
	  addNode: "添加节点",
	  back: "返回",
	  close: "關閉",
	  createEdgeError: "无法将连接线连接到群集。",
	  del: "删除选定",
	  deleteClusterError: "无法删除群集。",
	  edgeDescription: "单击某个节点并将该连接线拖动到另一个节点以连接它们。",
	  edit: "编辑",
	  editClusterError: "无法编辑群集。",
	  editEdge: "编辑连接线",
	  editEdgeDescription: "单击控制节点并将它们拖到节点上连接。",
	  editNode: "编辑节点"
	};
	// Ukrainian
	var uk = {
	  addDescription: "Kлікніть на вільне місце, щоб додати новий вузол.",
	  addEdge: "Додати край",
	  addNode: "Додати вузол",
	  back: "Назад",
	  close: "Закрити",
	  createEdgeError: "Не можливо об'єднати краї в групу.",
	  del: "Видалити обране",
	  deleteClusterError: "Групи не можуть бути видалені.",
	  edgeDescription: "Клікніть на вузол і перетягніть край до іншого вузла, щоб їх з'єднати.",
	  edit: "Редагувати",
	  editClusterError: "Групи недоступні для редагування.",
	  editEdge: "Редагувати край",
	  editEdgeDescription: "Клікніть на контрольні точки і перетягніть їх у вузол, щоб підключитися до нього.",
	  editNode: "Редагувати вузол"
	};
	// French
	var fr = {
	  addDescription: "Cliquez dans un endroit vide pour placer un nœud.",
	  addEdge: "Ajouter un lien",
	  addNode: "Ajouter un nœud",
	  back: "Retour",
	  close: "Fermer",
	  createEdgeError: "Impossible de créer un lien vers un cluster.",
	  del: "Effacer la sélection",
	  deleteClusterError: "Les clusters ne peuvent pas être effacés.",
	  edgeDescription: "Cliquez sur un nœud et glissez le lien vers un autre nœud pour les connecter.",
	  edit: "Éditer",
	  editClusterError: "Les clusters ne peuvent pas être édités.",
	  editEdge: "Éditer le lien",
	  editEdgeDescription: "Cliquez sur les points de contrôle et glissez-les pour connecter un nœud.",
	  editNode: "Éditer le nœud"
	};
	// Czech
	var cs = {
	  addDescription: "Kluknutím do prázdného prostoru můžete přidat nový vrchol.",
	  addEdge: "Přidat hranu",
	  addNode: "Přidat vrchol",
	  back: "Zpět",
	  close: "Zavřít",
	  createEdgeError: "Nelze připojit hranu ke shluku.",
	  del: "Smazat výběr",
	  deleteClusterError: "Nelze mazat shluky.",
	  edgeDescription: "Přetažením z jednoho vrcholu do druhého můžete spojit tyto vrcholy novou hranou.",
	  edit: "Upravit",
	  editClusterError: "Nelze upravovat shluky.",
	  editEdge: "Upravit hranu",
	  editEdgeDescription: "Přetažením kontrolního vrcholu hrany ji můžete připojit k jinému vrcholu.",
	  editNode: "Upravit vrchol"
	};

	var locales = /*#__PURE__*/Object.freeze({
		__proto__: null,
		cn: cn,
		cs: cs,
		de: de,
		en: en,
		es: es,
		fr: fr,
		it: it,
		nl: nl,
		pt: pt,
		ru: ru,
		uk: uk
	});

	/**
	 * Normalizes language code into the format used internally.
	 *
	 * @param locales - All the available locales.
	 * @param rawCode - The original code as supplied by the user.
	 * @returns Language code in the format language-COUNTRY or language, eventually
	 * fallbacks to en.
	 */
	function normalizeLanguageCode(locales, rawCode) {
	  try {
	    var _rawCode$split = rawCode.split(/[-_ /]/, 2),
	      _rawCode$split2 = _slicedToArray(_rawCode$split, 2),
	      rawLanguage = _rawCode$split2[0],
	      rawCountry = _rawCode$split2[1];
	    var language = rawLanguage != null ? rawLanguage.toLowerCase() : null;
	    var country = rawCountry != null ? rawCountry.toUpperCase() : null;
	    if (language && country) {
	      var code = language + "-" + country;
	      if (Object.prototype.hasOwnProperty.call(locales, code)) {
	        return code;
	      } else {
	        var _context;
	        console.warn(_concatInstanceProperty(_context = "Unknown variant ".concat(country, " of language ")).call(_context, language, "."));
	      }
	    }
	    if (language) {
	      var _code = language;
	      if (Object.prototype.hasOwnProperty.call(locales, _code)) {
	        return _code;
	      } else {
	        console.warn("Unknown language ".concat(language));
	      }
	    }
	    console.warn("Unknown locale ".concat(rawCode, ", falling back to English."));
	    return "en";
	  } catch (error) {
	    console.error(error);
	    console.warn("Unexpected error while normalizing locale ".concat(rawCode, ", falling back to English."));
	    return "en";
	  }
	}

	/**
	 * Associates a canvas to a given image, containing a number of renderings
	 * of the image at various sizes.
	 *
	 * This technique is known as 'mipmapping'.
	 *
	 * NOTE: Images can also be of type 'data:svg+xml`. This code also works
	 *       for svg, but the mipmapping may not be necessary.
	 *
	 * @param {Image} image
	 */
	var CachedImage = /*#__PURE__*/function () {
	  /**
	   * @ignore
	   */
	  function CachedImage() {
	    _classCallCheck(this, CachedImage);
	    this.NUM_ITERATIONS = 4; // Number of items in the coordinates array

	    this.image = new Image();
	    this.canvas = document.createElement("canvas");
	  }

	  /**
	   * Called when the image has been successfully loaded.
	   */
	  _createClass(CachedImage, [{
	    key: "init",
	    value: function init() {
	      if (this.initialized()) return;
	      this.src = this.image.src; // For same interface with Image
	      var w = this.image.width;
	      var h = this.image.height;

	      // Ease external access
	      this.width = w;
	      this.height = h;
	      var h2 = Math.floor(h / 2);
	      var h4 = Math.floor(h / 4);
	      var h8 = Math.floor(h / 8);
	      var h16 = Math.floor(h / 16);
	      var w2 = Math.floor(w / 2);
	      var w4 = Math.floor(w / 4);
	      var w8 = Math.floor(w / 8);
	      var w16 = Math.floor(w / 16);

	      // Make canvas as small as possible
	      this.canvas.width = 3 * w4;
	      this.canvas.height = h2;

	      // Coordinates and sizes of images contained in the canvas
	      // Values per row:  [top x, left y, width, height]

	      this.coordinates = [[0, 0, w2, h2], [w2, 0, w4, h4], [w2, h4, w8, h8], [5 * w8, h4, w16, h16]];
	      this._fillMipMap();
	    }

	    /**
	     * @returns {boolean} true if init() has been called, false otherwise.
	     */
	  }, {
	    key: "initialized",
	    value: function initialized() {
	      return this.coordinates !== undefined;
	    }

	    /**
	     * Redraw main image in various sizes to the context.
	     *
	     * The rationale behind this is to reduce artefacts due to interpolation
	     * at differing zoom levels.
	     *
	     * Source: http://stackoverflow.com/q/18761404/1223531
	     *
	     * This methods takes the resizing out of the drawing loop, in order to
	     * reduce performance overhead.
	     *
	     * TODO: The code assumes that a 2D context can always be gotten. This is
	     *       not necessarily true! OTOH, if not true then usage of this class
	     *       is senseless.
	     *
	     * @private
	     */
	  }, {
	    key: "_fillMipMap",
	    value: function _fillMipMap() {
	      var ctx = this.canvas.getContext("2d");

	      // First zoom-level comes from the image
	      var to = this.coordinates[0];
	      ctx.drawImage(this.image, to[0], to[1], to[2], to[3]);

	      // The rest are copy actions internal to the canvas/context
	      for (var iterations = 1; iterations < this.NUM_ITERATIONS; iterations++) {
	        var from = this.coordinates[iterations - 1];
	        var _to = this.coordinates[iterations];
	        ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], _to[0], _to[1], _to[2], _to[3]);
	      }
	    }

	    /**
	     * Draw the image, using the mipmap if necessary.
	     *
	     * MipMap is only used if param factor > 2; otherwise, original bitmap
	     * is resized. This is also used to skip mipmap usage, e.g. by setting factor = 1
	     *
	     * Credits to 'Alex de Mulder' for original implementation.
	     *
	     * @param {CanvasRenderingContext2D} ctx  context on which to draw zoomed image
	     * @param {Float} factor scale factor at which to draw
	     * @param {number} left
	     * @param {number} top
	     * @param {number} width
	     * @param {number} height
	     */
	  }, {
	    key: "drawImageAtPosition",
	    value: function drawImageAtPosition(ctx, factor, left, top, width, height) {
	      if (!this.initialized()) return; //can't draw image yet not intialized

	      if (factor > 2) {
	        // Determine which zoomed image to use
	        factor *= 0.5;
	        var iterations = 0;
	        while (factor > 2 && iterations < this.NUM_ITERATIONS) {
	          factor *= 0.5;
	          iterations += 1;
	        }
	        if (iterations >= this.NUM_ITERATIONS) {
	          iterations = this.NUM_ITERATIONS - 1;
	        }
	        //console.log("iterations: " + iterations);

	        var from = this.coordinates[iterations];
	        ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], left, top, width, height);
	      } else {
	        // Draw image directly
	        ctx.drawImage(this.image, left, top, width, height);
	      }
	    }
	  }]);
	  return CachedImage;
	}();

	/**
	 * This callback is a callback that accepts an Image.
	 *
	 * @callback ImageCallback
	 * @param {Image} image
	 */

	/**
	 * This class loads images and keeps them stored.
	 *
	 * @param {ImageCallback} callback
	 */
	var Images = /*#__PURE__*/function () {
	  /**
	   * @param {ImageCallback} callback
	   */
	  function Images(callback) {
	    _classCallCheck(this, Images);
	    this.images = {};
	    this.imageBroken = {};
	    this.callback = callback;
	  }

	  /**
	   * @param {string} url                      The original Url that failed to load, if the broken image is successfully loaded it will be added to the cache using this Url as the key so that subsequent requests for this Url will return the broken image
	   * @param {string} brokenUrl                Url the broken image to try and load
	   * @param {Image} imageToLoadBrokenUrlOn   The image object
	   */
	  _createClass(Images, [{
	    key: "_tryloadBrokenUrl",
	    value: function _tryloadBrokenUrl(url, brokenUrl, imageToLoadBrokenUrlOn) {
	      //If these parameters aren't specified then exit the function because nothing constructive can be done
	      if (url === undefined || imageToLoadBrokenUrlOn === undefined) return;
	      if (brokenUrl === undefined) {
	        console.warn("No broken url image defined");
	        return;
	      }

	      //Clear the old subscription to the error event and put a new in place that only handle errors in loading the brokenImageUrl
	      imageToLoadBrokenUrlOn.image.onerror = function () {
	        console.error("Could not load brokenImage:", brokenUrl);
	        // cache item will contain empty image, this should be OK for default
	      };

	      //Set the source of the image to the brokenUrl, this is actually what kicks off the loading of the broken image
	      imageToLoadBrokenUrlOn.image.src = brokenUrl;
	    }

	    /**
	     *
	     * @param {vis.Image} imageToRedrawWith
	     * @private
	     */
	  }, {
	    key: "_redrawWithImage",
	    value: function _redrawWithImage(imageToRedrawWith) {
	      if (this.callback) {
	        this.callback(imageToRedrawWith);
	      }
	    }

	    /**
	     * @param {string} url          Url of the image
	     * @param {string} brokenUrl    Url of an image to use if the url image is not found
	     * @returns {Image} img          The image object
	     */
	  }, {
	    key: "load",
	    value: function load(url, brokenUrl) {
	      var _this = this;
	      //Try and get the image from the cache, if successful then return the cached image
	      var cachedImage = this.images[url];
	      if (cachedImage) return cachedImage;

	      //Create a new image
	      var img = new CachedImage();

	      // Need to add to cache here, otherwise final return will spawn different copies of the same image,
	      // Also, there will be multiple loads of the same image.
	      this.images[url] = img;

	      //Subscribe to the event that is raised if the image loads successfully
	      img.image.onload = function () {
	        // Properly init the cached item and then request a redraw
	        _this._fixImageCoordinates(img.image);
	        img.init();
	        _this._redrawWithImage(img);
	      };

	      //Subscribe to the event that is raised if the image fails to load
	      img.image.onerror = function () {
	        console.error("Could not load image:", url);
	        //Try and load the image specified by the brokenUrl using
	        _this._tryloadBrokenUrl(url, brokenUrl, img);
	      };

	      //Set the source of the image to the url, this is what actually kicks off the loading of the image
	      img.image.src = url;

	      //Return the new image
	      return img;
	    }

	    /**
	     * IE11 fix -- thanks dponch!
	     *
	     * Local helper function
	     *
	     * @param {vis.Image} imageToCache
	     * @private
	     */
	  }, {
	    key: "_fixImageCoordinates",
	    value: function _fixImageCoordinates(imageToCache) {
	      if (imageToCache.width === 0) {
	        document.body.appendChild(imageToCache);
	        imageToCache.width = imageToCache.offsetWidth;
	        imageToCache.height = imageToCache.offsetHeight;
	        document.body.removeChild(imageToCache);
	      }
	    }
	  }]);
	  return Images;
	}();

	var internalMetadata = {exports: {}};

	// FF26- bug: ArrayBuffers are non-extensible, but Object.isExtensible does not report it
	var fails$c = fails$A;

	var arrayBufferNonExtensible = fails$c(function () {
	  if (typeof ArrayBuffer == 'function') {
	    var buffer = new ArrayBuffer(8);
	    // eslint-disable-next-line es/no-object-isextensible, es/no-object-defineproperty -- safe
	    if (Object.isExtensible(buffer)) Object.defineProperty(buffer, 'a', { value: 8 });
	  }
	});

	var fails$b = fails$A;
	var isObject$9 = isObject$m;
	var classof$4 = classofRaw$2;
	var ARRAY_BUFFER_NON_EXTENSIBLE = arrayBufferNonExtensible;

	// eslint-disable-next-line es/no-object-isextensible -- safe
	var $isExtensible = Object.isExtensible;
	var FAILS_ON_PRIMITIVES$1 = fails$b(function () { $isExtensible(1); });

	// `Object.isExtensible` method
	// https://tc39.es/ecma262/#sec-object.isextensible
	var objectIsExtensible = (FAILS_ON_PRIMITIVES$1 || ARRAY_BUFFER_NON_EXTENSIBLE) ? function isExtensible(it) {
	  if (!isObject$9(it)) return false;
	  if (ARRAY_BUFFER_NON_EXTENSIBLE && classof$4(it) === 'ArrayBuffer') return false;
	  return $isExtensible ? $isExtensible(it) : true;
	} : $isExtensible;

	var fails$a = fails$A;

	var freezing = !fails$a(function () {
	  // eslint-disable-next-line es/no-object-isextensible, es/no-object-preventextensions -- required for testing
	  return Object.isExtensible(Object.preventExtensions({}));
	});

	var $$t = _export;
	var uncurryThis$5 = functionUncurryThis;
	var hiddenKeys = hiddenKeys$6;
	var isObject$8 = isObject$m;
	var hasOwn$7 = hasOwnProperty_1;
	var defineProperty$2 = objectDefineProperty.f;
	var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
	var getOwnPropertyNamesExternalModule = objectGetOwnPropertyNamesExternal;
	var isExtensible$1 = objectIsExtensible;
	var uid = uid$4;
	var FREEZING$1 = freezing;

	var REQUIRED = false;
	var METADATA = uid('meta');
	var id$1 = 0;

	var setMetadata = function (it) {
	  defineProperty$2(it, METADATA, { value: {
	    objectID: 'O' + id$1++, // object ID
	    weakData: {}          // weak collections IDs
	  } });
	};

	var fastKey$1 = function (it, create) {
	  // return a primitive with prefix
	  if (!isObject$8(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
	  if (!hasOwn$7(it, METADATA)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible$1(it)) return 'F';
	    // not necessary to add metadata
	    if (!create) return 'E';
	    // add missing metadata
	    setMetadata(it);
	  // return object ID
	  } return it[METADATA].objectID;
	};

	var getWeakData$1 = function (it, create) {
	  if (!hasOwn$7(it, METADATA)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible$1(it)) return true;
	    // not necessary to add metadata
	    if (!create) return false;
	    // add missing metadata
	    setMetadata(it);
	  // return the store of weak collections IDs
	  } return it[METADATA].weakData;
	};

	// add metadata on freeze-family methods calling
	var onFreeze = function (it) {
	  if (FREEZING$1 && REQUIRED && isExtensible$1(it) && !hasOwn$7(it, METADATA)) setMetadata(it);
	  return it;
	};

	var enable = function () {
	  meta.enable = function () { /* empty */ };
	  REQUIRED = true;
	  var getOwnPropertyNames = getOwnPropertyNamesModule.f;
	  var splice = uncurryThis$5([].splice);
	  var test = {};
	  test[METADATA] = 1;

	  // prevent exposing of metadata key
	  if (getOwnPropertyNames(test).length) {
	    getOwnPropertyNamesModule.f = function (it) {
	      var result = getOwnPropertyNames(it);
	      for (var i = 0, length = result.length; i < length; i++) {
	        if (result[i] === METADATA) {
	          splice(result, i, 1);
	          break;
	        }
	      } return result;
	    };

	    $$t({ target: 'Object', stat: true, forced: true }, {
	      getOwnPropertyNames: getOwnPropertyNamesExternalModule.f
	    });
	  }
	};

	var meta = internalMetadata.exports = {
	  enable: enable,
	  fastKey: fastKey$1,
	  getWeakData: getWeakData$1,
	  onFreeze: onFreeze
	};

	hiddenKeys[METADATA] = true;

	var internalMetadataExports = internalMetadata.exports;

	var bind$9 = functionBindContext;
	var call$7 = functionCall;
	var anObject$5 = anObject$f;
	var tryToString$1 = tryToString$6;
	var isArrayIteratorMethod = isArrayIteratorMethod$2;
	var lengthOfArrayLike$4 = lengthOfArrayLike$e;
	var isPrototypeOf$a = objectIsPrototypeOf;
	var getIterator$6 = getIterator$8;
	var getIteratorMethod = getIteratorMethod$9;
	var iteratorClose = iteratorClose$2;

	var $TypeError$4 = TypeError;

	var Result = function (stopped, result) {
	  this.stopped = stopped;
	  this.result = result;
	};

	var ResultPrototype = Result.prototype;

	var iterate$8 = function (iterable, unboundFunction, options) {
	  var that = options && options.that;
	  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
	  var IS_RECORD = !!(options && options.IS_RECORD);
	  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
	  var INTERRUPTED = !!(options && options.INTERRUPTED);
	  var fn = bind$9(unboundFunction, that);
	  var iterator, iterFn, index, length, result, next, step;

	  var stop = function (condition) {
	    if (iterator) iteratorClose(iterator, 'normal', condition);
	    return new Result(true, condition);
	  };

	  var callFn = function (value) {
	    if (AS_ENTRIES) {
	      anObject$5(value);
	      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
	    } return INTERRUPTED ? fn(value, stop) : fn(value);
	  };

	  if (IS_RECORD) {
	    iterator = iterable.iterator;
	  } else if (IS_ITERATOR) {
	    iterator = iterable;
	  } else {
	    iterFn = getIteratorMethod(iterable);
	    if (!iterFn) throw new $TypeError$4(tryToString$1(iterable) + ' is not iterable');
	    // optimisation for array iterators
	    if (isArrayIteratorMethod(iterFn)) {
	      for (index = 0, length = lengthOfArrayLike$4(iterable); length > index; index++) {
	        result = callFn(iterable[index]);
	        if (result && isPrototypeOf$a(ResultPrototype, result)) return result;
	      } return new Result(false);
	    }
	    iterator = getIterator$6(iterable, iterFn);
	  }

	  next = IS_RECORD ? iterable.next : iterator.next;
	  while (!(step = call$7(next, iterator)).done) {
	    try {
	      result = callFn(step.value);
	    } catch (error) {
	      iteratorClose(iterator, 'throw', error);
	    }
	    if (typeof result == 'object' && result && isPrototypeOf$a(ResultPrototype, result)) return result;
	  } return new Result(false);
	};

	var isPrototypeOf$9 = objectIsPrototypeOf;

	var $TypeError$3 = TypeError;

	var anInstance$4 = function (it, Prototype) {
	  if (isPrototypeOf$9(Prototype, it)) return it;
	  throw new $TypeError$3('Incorrect invocation');
	};

	var $$s = _export;
	var global$a = global$s;
	var InternalMetadataModule$1 = internalMetadataExports;
	var fails$9 = fails$A;
	var createNonEnumerableProperty$3 = createNonEnumerableProperty$9;
	var iterate$7 = iterate$8;
	var anInstance$3 = anInstance$4;
	var isCallable$4 = isCallable$m;
	var isObject$7 = isObject$m;
	var isNullOrUndefined$3 = isNullOrUndefined$7;
	var setToStringTag$1 = setToStringTag$7;
	var defineProperty$1 = objectDefineProperty.f;
	var forEach$3 = arrayIteration.forEach;
	var DESCRIPTORS$5 = descriptors;
	var InternalStateModule$3 = internalState;

	var setInternalState$3 = InternalStateModule$3.set;
	var internalStateGetterFor$2 = InternalStateModule$3.getterFor;

	var collection$3 = function (CONSTRUCTOR_NAME, wrapper, common) {
	  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
	  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
	  var ADDER = IS_MAP ? 'set' : 'add';
	  var NativeConstructor = global$a[CONSTRUCTOR_NAME];
	  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
	  var exported = {};
	  var Constructor;

	  if (!DESCRIPTORS$5 || !isCallable$4(NativeConstructor)
	    || !(IS_WEAK || NativePrototype.forEach && !fails$9(function () { new NativeConstructor().entries().next(); }))
	  ) {
	    // create collection constructor
	    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
	    InternalMetadataModule$1.enable();
	  } else {
	    Constructor = wrapper(function (target, iterable) {
	      setInternalState$3(anInstance$3(target, Prototype), {
	        type: CONSTRUCTOR_NAME,
	        collection: new NativeConstructor()
	      });
	      if (!isNullOrUndefined$3(iterable)) iterate$7(iterable, target[ADDER], { that: target, AS_ENTRIES: IS_MAP });
	    });

	    var Prototype = Constructor.prototype;

	    var getInternalState = internalStateGetterFor$2(CONSTRUCTOR_NAME);

	    forEach$3(['add', 'clear', 'delete', 'forEach', 'get', 'has', 'set', 'keys', 'values', 'entries'], function (KEY) {
	      var IS_ADDER = KEY === 'add' || KEY === 'set';
	      if (KEY in NativePrototype && !(IS_WEAK && KEY === 'clear')) {
	        createNonEnumerableProperty$3(Prototype, KEY, function (a, b) {
	          var collection = getInternalState(this).collection;
	          if (!IS_ADDER && IS_WEAK && !isObject$7(a)) return KEY === 'get' ? undefined : false;
	          var result = collection[KEY](a === 0 ? 0 : a, b);
	          return IS_ADDER ? this : result;
	        });
	      }
	    });

	    IS_WEAK || defineProperty$1(Prototype, 'size', {
	      configurable: true,
	      get: function () {
	        return getInternalState(this).collection.size;
	      }
	    });
	  }

	  setToStringTag$1(Constructor, CONSTRUCTOR_NAME, false, true);

	  exported[CONSTRUCTOR_NAME] = Constructor;
	  $$s({ global: true, forced: true }, exported);

	  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);

	  return Constructor;
	};

	var defineBuiltIn$1 = defineBuiltIn$6;

	var defineBuiltIns$3 = function (target, src, options) {
	  for (var key in src) {
	    if (options && options.unsafe && target[key]) target[key] = src[key];
	    else defineBuiltIn$1(target, key, src[key], options);
	  } return target;
	};

	var getBuiltIn$4 = getBuiltIn$f;
	var defineBuiltInAccessor$1 = defineBuiltInAccessor$3;
	var wellKnownSymbol$3 = wellKnownSymbol$p;
	var DESCRIPTORS$4 = descriptors;

	var SPECIES$2 = wellKnownSymbol$3('species');

	var setSpecies$2 = function (CONSTRUCTOR_NAME) {
	  var Constructor = getBuiltIn$4(CONSTRUCTOR_NAME);

	  if (DESCRIPTORS$4 && Constructor && !Constructor[SPECIES$2]) {
	    defineBuiltInAccessor$1(Constructor, SPECIES$2, {
	      configurable: true,
	      get: function () { return this; }
	    });
	  }
	};

	var create$5 = objectCreate;
	var defineBuiltInAccessor = defineBuiltInAccessor$3;
	var defineBuiltIns$2 = defineBuiltIns$3;
	var bind$8 = functionBindContext;
	var anInstance$2 = anInstance$4;
	var isNullOrUndefined$2 = isNullOrUndefined$7;
	var iterate$6 = iterate$8;
	var defineIterator = iteratorDefine;
	var createIterResultObject = createIterResultObject$3;
	var setSpecies$1 = setSpecies$2;
	var DESCRIPTORS$3 = descriptors;
	var fastKey = internalMetadataExports.fastKey;
	var InternalStateModule$2 = internalState;

	var setInternalState$2 = InternalStateModule$2.set;
	var internalStateGetterFor$1 = InternalStateModule$2.getterFor;

	var collectionStrong$2 = {
	  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
	    var Constructor = wrapper(function (that, iterable) {
	      anInstance$2(that, Prototype);
	      setInternalState$2(that, {
	        type: CONSTRUCTOR_NAME,
	        index: create$5(null),
	        first: undefined,
	        last: undefined,
	        size: 0
	      });
	      if (!DESCRIPTORS$3) that.size = 0;
	      if (!isNullOrUndefined$2(iterable)) iterate$6(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
	    });

	    var Prototype = Constructor.prototype;

	    var getInternalState = internalStateGetterFor$1(CONSTRUCTOR_NAME);

	    var define = function (that, key, value) {
	      var state = getInternalState(that);
	      var entry = getEntry(that, key);
	      var previous, index;
	      // change existing entry
	      if (entry) {
	        entry.value = value;
	      // create new entry
	      } else {
	        state.last = entry = {
	          index: index = fastKey(key, true),
	          key: key,
	          value: value,
	          previous: previous = state.last,
	          next: undefined,
	          removed: false
	        };
	        if (!state.first) state.first = entry;
	        if (previous) previous.next = entry;
	        if (DESCRIPTORS$3) state.size++;
	        else that.size++;
	        // add to index
	        if (index !== 'F') state.index[index] = entry;
	      } return that;
	    };

	    var getEntry = function (that, key) {
	      var state = getInternalState(that);
	      // fast case
	      var index = fastKey(key);
	      var entry;
	      if (index !== 'F') return state.index[index];
	      // frozen object case
	      for (entry = state.first; entry; entry = entry.next) {
	        if (entry.key === key) return entry;
	      }
	    };

	    defineBuiltIns$2(Prototype, {
	      // `{ Map, Set }.prototype.clear()` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.clear
	      // https://tc39.es/ecma262/#sec-set.prototype.clear
	      clear: function clear() {
	        var that = this;
	        var state = getInternalState(that);
	        var data = state.index;
	        var entry = state.first;
	        while (entry) {
	          entry.removed = true;
	          if (entry.previous) entry.previous = entry.previous.next = undefined;
	          delete data[entry.index];
	          entry = entry.next;
	        }
	        state.first = state.last = undefined;
	        if (DESCRIPTORS$3) state.size = 0;
	        else that.size = 0;
	      },
	      // `{ Map, Set }.prototype.delete(key)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.delete
	      // https://tc39.es/ecma262/#sec-set.prototype.delete
	      'delete': function (key) {
	        var that = this;
	        var state = getInternalState(that);
	        var entry = getEntry(that, key);
	        if (entry) {
	          var next = entry.next;
	          var prev = entry.previous;
	          delete state.index[entry.index];
	          entry.removed = true;
	          if (prev) prev.next = next;
	          if (next) next.previous = prev;
	          if (state.first === entry) state.first = next;
	          if (state.last === entry) state.last = prev;
	          if (DESCRIPTORS$3) state.size--;
	          else that.size--;
	        } return !!entry;
	      },
	      // `{ Map, Set }.prototype.forEach(callbackfn, thisArg = undefined)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.foreach
	      // https://tc39.es/ecma262/#sec-set.prototype.foreach
	      forEach: function forEach(callbackfn /* , that = undefined */) {
	        var state = getInternalState(this);
	        var boundFunction = bind$8(callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	        var entry;
	        while (entry = entry ? entry.next : state.first) {
	          boundFunction(entry.value, entry.key, this);
	          // revert to the last existing entry
	          while (entry && entry.removed) entry = entry.previous;
	        }
	      },
	      // `{ Map, Set}.prototype.has(key)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.has
	      // https://tc39.es/ecma262/#sec-set.prototype.has
	      has: function has(key) {
	        return !!getEntry(this, key);
	      }
	    });

	    defineBuiltIns$2(Prototype, IS_MAP ? {
	      // `Map.prototype.get(key)` method
	      // https://tc39.es/ecma262/#sec-map.prototype.get
	      get: function get(key) {
	        var entry = getEntry(this, key);
	        return entry && entry.value;
	      },
	      // `Map.prototype.set(key, value)` method
	      // https://tc39.es/ecma262/#sec-map.prototype.set
	      set: function set(key, value) {
	        return define(this, key === 0 ? 0 : key, value);
	      }
	    } : {
	      // `Set.prototype.add(value)` method
	      // https://tc39.es/ecma262/#sec-set.prototype.add
	      add: function add(value) {
	        return define(this, value = value === 0 ? 0 : value, value);
	      }
	    });
	    if (DESCRIPTORS$3) defineBuiltInAccessor(Prototype, 'size', {
	      configurable: true,
	      get: function () {
	        return getInternalState(this).size;
	      }
	    });
	    return Constructor;
	  },
	  setStrong: function (Constructor, CONSTRUCTOR_NAME, IS_MAP) {
	    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
	    var getInternalCollectionState = internalStateGetterFor$1(CONSTRUCTOR_NAME);
	    var getInternalIteratorState = internalStateGetterFor$1(ITERATOR_NAME);
	    // `{ Map, Set }.prototype.{ keys, values, entries, @@iterator }()` methods
	    // https://tc39.es/ecma262/#sec-map.prototype.entries
	    // https://tc39.es/ecma262/#sec-map.prototype.keys
	    // https://tc39.es/ecma262/#sec-map.prototype.values
	    // https://tc39.es/ecma262/#sec-map.prototype-@@iterator
	    // https://tc39.es/ecma262/#sec-set.prototype.entries
	    // https://tc39.es/ecma262/#sec-set.prototype.keys
	    // https://tc39.es/ecma262/#sec-set.prototype.values
	    // https://tc39.es/ecma262/#sec-set.prototype-@@iterator
	    defineIterator(Constructor, CONSTRUCTOR_NAME, function (iterated, kind) {
	      setInternalState$2(this, {
	        type: ITERATOR_NAME,
	        target: iterated,
	        state: getInternalCollectionState(iterated),
	        kind: kind,
	        last: undefined
	      });
	    }, function () {
	      var state = getInternalIteratorState(this);
	      var kind = state.kind;
	      var entry = state.last;
	      // revert to the last existing entry
	      while (entry && entry.removed) entry = entry.previous;
	      // get next entry
	      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
	        // or finish the iteration
	        state.target = undefined;
	        return createIterResultObject(undefined, true);
	      }
	      // return step by kind
	      if (kind === 'keys') return createIterResultObject(entry.key, false);
	      if (kind === 'values') return createIterResultObject(entry.value, false);
	      return createIterResultObject([entry.key, entry.value], false);
	    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

	    // `{ Map, Set }.prototype[@@species]` accessors
	    // https://tc39.es/ecma262/#sec-get-map-@@species
	    // https://tc39.es/ecma262/#sec-get-set-@@species
	    setSpecies$1(CONSTRUCTOR_NAME);
	  }
	};

	var collection$2 = collection$3;
	var collectionStrong$1 = collectionStrong$2;

	// `Map` constructor
	// https://tc39.es/ecma262/#sec-map-objects
	collection$2('Map', function (init) {
	  return function Map() { return init(this, arguments.length ? arguments[0] : undefined); };
	}, collectionStrong$1);

	var path$g = path$A;

	var map$2 = path$g.Map;

	var parent$I = map$2;


	var map$1 = parent$I;

	var map = map$1;

	var _Map = /*@__PURE__*/getDefaultExportFromCjs(map);

	/**
	 * This class can store groups and options specific for groups.
	 */
	var Groups = /*#__PURE__*/function () {
	  /**
	   * @ignore
	   */
	  function Groups() {
	    _classCallCheck(this, Groups);
	    this.clear();
	    this._defaultIndex = 0;
	    this._groupIndex = 0;
	    this._defaultGroups = [{
	      border: "#2B7CE9",
	      background: "#97C2FC",
	      highlight: {
	        border: "#2B7CE9",
	        background: "#D2E5FF"
	      },
	      hover: {
	        border: "#2B7CE9",
	        background: "#D2E5FF"
	      }
	    },
	    // 0: blue
	    {
	      border: "#FFA500",
	      background: "#FFFF00",
	      highlight: {
	        border: "#FFA500",
	        background: "#FFFFA3"
	      },
	      hover: {
	        border: "#FFA500",
	        background: "#FFFFA3"
	      }
	    },
	    // 1: yellow
	    {
	      border: "#FA0A10",
	      background: "#FB7E81",
	      highlight: {
	        border: "#FA0A10",
	        background: "#FFAFB1"
	      },
	      hover: {
	        border: "#FA0A10",
	        background: "#FFAFB1"
	      }
	    },
	    // 2: red
	    {
	      border: "#41A906",
	      background: "#7BE141",
	      highlight: {
	        border: "#41A906",
	        background: "#A1EC76"
	      },
	      hover: {
	        border: "#41A906",
	        background: "#A1EC76"
	      }
	    },
	    // 3: green
	    {
	      border: "#E129F0",
	      background: "#EB7DF4",
	      highlight: {
	        border: "#E129F0",
	        background: "#F0B3F5"
	      },
	      hover: {
	        border: "#E129F0",
	        background: "#F0B3F5"
	      }
	    },
	    // 4: magenta
	    {
	      border: "#7C29F0",
	      background: "#AD85E4",
	      highlight: {
	        border: "#7C29F0",
	        background: "#D3BDF0"
	      },
	      hover: {
	        border: "#7C29F0",
	        background: "#D3BDF0"
	      }
	    },
	    // 5: purple
	    {
	      border: "#C37F00",
	      background: "#FFA807",
	      highlight: {
	        border: "#C37F00",
	        background: "#FFCA66"
	      },
	      hover: {
	        border: "#C37F00",
	        background: "#FFCA66"
	      }
	    },
	    // 6: orange
	    {
	      border: "#4220FB",
	      background: "#6E6EFD",
	      highlight: {
	        border: "#4220FB",
	        background: "#9B9BFD"
	      },
	      hover: {
	        border: "#4220FB",
	        background: "#9B9BFD"
	      }
	    },
	    // 7: darkblue
	    {
	      border: "#FD5A77",
	      background: "#FFC0CB",
	      highlight: {
	        border: "#FD5A77",
	        background: "#FFD1D9"
	      },
	      hover: {
	        border: "#FD5A77",
	        background: "#FFD1D9"
	      }
	    },
	    // 8: pink
	    {
	      border: "#4AD63A",
	      background: "#C2FABC",
	      highlight: {
	        border: "#4AD63A",
	        background: "#E6FFE3"
	      },
	      hover: {
	        border: "#4AD63A",
	        background: "#E6FFE3"
	      }
	    },
	    // 9: mint

	    {
	      border: "#990000",
	      background: "#EE0000",
	      highlight: {
	        border: "#BB0000",
	        background: "#FF3333"
	      },
	      hover: {
	        border: "#BB0000",
	        background: "#FF3333"
	      }
	    },
	    // 10:bright red

	    {
	      border: "#FF6000",
	      background: "#FF6000",
	      highlight: {
	        border: "#FF6000",
	        background: "#FF6000"
	      },
	      hover: {
	        border: "#FF6000",
	        background: "#FF6000"
	      }
	    },
	    // 12: real orange
	    {
	      border: "#97C2FC",
	      background: "#2B7CE9",
	      highlight: {
	        border: "#D2E5FF",
	        background: "#2B7CE9"
	      },
	      hover: {
	        border: "#D2E5FF",
	        background: "#2B7CE9"
	      }
	    },
	    // 13: blue
	    {
	      border: "#399605",
	      background: "#255C03",
	      highlight: {
	        border: "#399605",
	        background: "#255C03"
	      },
	      hover: {
	        border: "#399605",
	        background: "#255C03"
	      }
	    },
	    // 14: green
	    {
	      border: "#B70054",
	      background: "#FF007E",
	      highlight: {
	        border: "#B70054",
	        background: "#FF007E"
	      },
	      hover: {
	        border: "#B70054",
	        background: "#FF007E"
	      }
	    },
	    // 15: magenta
	    {
	      border: "#AD85E4",
	      background: "#7C29F0",
	      highlight: {
	        border: "#D3BDF0",
	        background: "#7C29F0"
	      },
	      hover: {
	        border: "#D3BDF0",
	        background: "#7C29F0"
	      }
	    },
	    // 16: purple
	    {
	      border: "#4557FA",
	      background: "#000EA1",
	      highlight: {
	        border: "#6E6EFD",
	        background: "#000EA1"
	      },
	      hover: {
	        border: "#6E6EFD",
	        background: "#000EA1"
	      }
	    },
	    // 17: darkblue
	    {
	      border: "#FFC0CB",
	      background: "#FD5A77",
	      highlight: {
	        border: "#FFD1D9",
	        background: "#FD5A77"
	      },
	      hover: {
	        border: "#FFD1D9",
	        background: "#FD5A77"
	      }
	    },
	    // 18: pink
	    {
	      border: "#C2FABC",
	      background: "#74D66A",
	      highlight: {
	        border: "#E6FFE3",
	        background: "#74D66A"
	      },
	      hover: {
	        border: "#E6FFE3",
	        background: "#74D66A"
	      }
	    },
	    // 19: mint

	    {
	      border: "#EE0000",
	      background: "#990000",
	      highlight: {
	        border: "#FF3333",
	        background: "#BB0000"
	      },
	      hover: {
	        border: "#FF3333",
	        background: "#BB0000"
	      }
	    } // 20:bright red
	    ];

	    this.options = {};
	    this.defaultOptions = {
	      useDefaultGroups: true
	    };
	    _Object$assign(this.options, this.defaultOptions);
	  }

	  /**
	   *
	   * @param {object} options
	   */
	  _createClass(Groups, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      var optionFields = ["useDefaultGroups"];
	      if (options !== undefined) {
	        for (var groupName in options) {
	          if (Object.prototype.hasOwnProperty.call(options, groupName)) {
	            if (_indexOfInstanceProperty(optionFields).call(optionFields, groupName) === -1) {
	              var group = options[groupName];
	              this.add(groupName, group);
	            }
	          }
	        }
	      }
	    }

	    /**
	     * Clear all groups
	     */
	  }, {
	    key: "clear",
	    value: function clear() {
	      this._groups = new _Map();
	      this._groupNames = [];
	    }

	    /**
	     * Get group options of a groupname.
	     * If groupname is not found, a new group may be created.
	     *
	     * @param {*}       groupname     Can be a number, string, Date, etc.
	     * @param {boolean} [shouldCreate=true] If true, create a new group
	     * @returns {object} The found or created group
	     */
	  }, {
	    key: "get",
	    value: function get(groupname) {
	      var shouldCreate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      var group = this._groups.get(groupname);
	      if (group === undefined && shouldCreate) {
	        if (this.options.useDefaultGroups === false && this._groupNames.length > 0) {
	          // create new group
	          var index = this._groupIndex % this._groupNames.length;
	          ++this._groupIndex;
	          group = {};
	          group.color = this._groups.get(this._groupNames[index]);
	          this._groups.set(groupname, group);
	        } else {
	          // create new group
	          var _index = this._defaultIndex % this._defaultGroups.length;
	          this._defaultIndex++;
	          group = {};
	          group.color = this._defaultGroups[_index];
	          this._groups.set(groupname, group);
	        }
	      }
	      return group;
	    }

	    /**
	     * Add custom group style.
	     *
	     * @param {string} groupName - The name of the group, a new group will be
	     * created if a group with the same name doesn't exist, otherwise the old
	     * groups style will be overwritten.
	     * @param {object} style - An object containing borderColor, backgroundColor,
	     * etc.
	     * @returns {object} The created group object.
	     */
	  }, {
	    key: "add",
	    value: function add(groupName, style) {
	      // Only push group name once to prevent duplicates which would consume more
	      // RAM and also skew the distribution towards more often updated groups,
	      // neither of which is desirable.
	      if (!this._groups.has(groupName)) {
	        this._groupNames.push(groupName);
	      }
	      this._groups.set(groupName, style);
	      return style;
	    }
	  }]);
	  return Groups;
	}();

	var $$r = _export;

	// `Number.isNaN` method
	// https://tc39.es/ecma262/#sec-number.isnan
	$$r({ target: 'Number', stat: true }, {
	  isNaN: function isNaN(number) {
	    // eslint-disable-next-line no-self-compare -- NaN check
	    return number !== number;
	  }
	});

	var path$f = path$A;

	var isNan$2 = path$f.Number.isNaN;

	var parent$H = isNan$2;

	var isNan$1 = parent$H;

	var isNan = isNan$1;

	var _Number$isNaN = /*@__PURE__*/getDefaultExportFromCjs(isNan);

	var global$9 = global$s;

	var globalIsFinite = global$9.isFinite;

	// `Number.isFinite` method
	// https://tc39.es/ecma262/#sec-number.isfinite
	// eslint-disable-next-line es/no-number-isfinite -- safe
	var numberIsFinite$1 = Number.isFinite || function isFinite(it) {
	  return typeof it == 'number' && globalIsFinite(it);
	};

	var $$q = _export;
	var numberIsFinite = numberIsFinite$1;

	// `Number.isFinite` method
	// https://tc39.es/ecma262/#sec-number.isfinite
	$$q({ target: 'Number', stat: true }, { isFinite: numberIsFinite });

	var path$e = path$A;

	var _isFinite$2 = path$e.Number.isFinite;

	var parent$G = _isFinite$2;

	var _isFinite$1 = parent$G;

	var _isFinite = _isFinite$1;

	var _Number$isFinite = /*@__PURE__*/getDefaultExportFromCjs(_isFinite);

	var $$p = _export;
	var $some = arrayIteration.some;
	var arrayMethodIsStrict$3 = arrayMethodIsStrict$6;

	var STRICT_METHOD$2 = arrayMethodIsStrict$3('some');

	// `Array.prototype.some` method
	// https://tc39.es/ecma262/#sec-array.prototype.some
	$$p({ target: 'Array', proto: true, forced: !STRICT_METHOD$2 }, {
	  some: function some(callbackfn /* , thisArg */) {
	    return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$7 = entryVirtual$l;

	var some$3 = entryVirtual$7('Array').some;

	var isPrototypeOf$8 = objectIsPrototypeOf;
	var method$7 = some$3;

	var ArrayPrototype$7 = Array.prototype;

	var some$2 = function (it) {
	  var own = it.some;
	  return it === ArrayPrototype$7 || (isPrototypeOf$8(ArrayPrototype$7, it) && own === ArrayPrototype$7.some) ? method$7 : own;
	};

	var parent$F = some$2;

	var some$1 = parent$F;

	var some = some$1;

	var _someInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(some);

	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }
	  return self;
	}

	var parent$E = create$7;

	var create$4 = parent$E;

	var parent$D = create$4;

	var create$3 = parent$D;

	var create$2 = create$3;

	var _Object$create = /*@__PURE__*/getDefaultExportFromCjs(create$2);

	var $$o = _export;
	var setPrototypeOf$6 = objectSetPrototypeOf;

	// `Object.setPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.setprototypeof
	$$o({ target: 'Object', stat: true }, {
	  setPrototypeOf: setPrototypeOf$6
	});

	var path$d = path$A;

	var setPrototypeOf$5 = path$d.Object.setPrototypeOf;

	var parent$C = setPrototypeOf$5;

	var setPrototypeOf$4 = parent$C;

	var parent$B = setPrototypeOf$4;

	var setPrototypeOf$3 = parent$B;

	var parent$A = setPrototypeOf$3;

	var setPrototypeOf$2 = parent$A;

	var setPrototypeOf$1 = setPrototypeOf$2;

	var _Object$setPrototypeOf = /*@__PURE__*/getDefaultExportFromCjs(setPrototypeOf$1);

	var parent$z = bind$d;

	var bind$7 = parent$z;

	var parent$y = bind$7;

	var bind$6 = parent$y;

	var bind$5 = bind$6;

	var _bindInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(bind$5);

	function _setPrototypeOf(o, p) {
	  var _context;
	  _setPrototypeOf = _Object$setPrototypeOf ? _bindInstanceProperty(_context = _Object$setPrototypeOf).call(_context) : function _setPrototypeOf(o, p) {
	    o.__proto__ = p;
	    return o;
	  };
	  return _setPrototypeOf(o, p);
	}

	function _inherits(subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function");
	  }
	  subClass.prototype = _Object$create(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      writable: true,
	      configurable: true
	    }
	  });
	  _Object$defineProperty$1(subClass, "prototype", {
	    writable: false
	  });
	  if (superClass) _setPrototypeOf(subClass, superClass);
	}

	function _possibleConstructorReturn(self, call) {
	  if (call && (_typeof$1(call) === "object" || typeof call === "function")) {
	    return call;
	  } else if (call !== void 0) {
	    throw new TypeError("Derived constructors may only return object or undefined");
	  }
	  return _assertThisInitialized(self);
	}

	var parent$x = getPrototypeOf$6;

	var getPrototypeOf$4 = parent$x;

	var parent$w = getPrototypeOf$4;

	var getPrototypeOf$3 = parent$w;

	var getPrototypeOf$2 = getPrototypeOf$3;

	var _Object$getPrototypeOf = /*@__PURE__*/getDefaultExportFromCjs(getPrototypeOf$2);

	function _getPrototypeOf(o) {
	  var _context;
	  _getPrototypeOf = _Object$setPrototypeOf ? _bindInstanceProperty(_context = _Object$getPrototypeOf).call(_context) : function _getPrototypeOf(o) {
	    return o.__proto__ || _Object$getPrototypeOf(o);
	  };
	  return _getPrototypeOf(o);
	}

	function _defineProperty(obj, key, value) {
	  key = _toPropertyKey(key);
	  if (key in obj) {
	    _Object$defineProperty$1(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }
	  return obj;
	}

	var regeneratorRuntime$1 = {exports: {}};

	var _typeof = {exports: {}};

	(function (module) {
		var _Symbol = symbol$1;
		var _Symbol$iterator = iterator$1;
		function _typeof(o) {
		  "@babel/helpers - typeof";

		  return (module.exports = _typeof = "function" == typeof _Symbol && "symbol" == typeof _Symbol$iterator ? function (o) {
		    return typeof o;
		  } : function (o) {
		    return o && "function" == typeof _Symbol && o.constructor === _Symbol && o !== _Symbol.prototype ? "symbol" : typeof o;
		  }, module.exports.__esModule = true, module.exports["default"] = module.exports), _typeof(o);
		}
		module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports; 
	} (_typeof));

	var _typeofExports = _typeof.exports;

	var parent$v = forEach$6;

	var forEach$2 = parent$v;

	var parent$u = forEach$2;

	var forEach$1 = parent$u;

	var forEach = forEach$1;

	var hasOwn$6 = hasOwnProperty_1;
	var ownKeys$6 = ownKeys$b;
	var getOwnPropertyDescriptorModule$2 = objectGetOwnPropertyDescriptor;
	var definePropertyModule = objectDefineProperty;

	var copyConstructorProperties$1 = function (target, source, exceptions) {
	  var keys = ownKeys$6(source);
	  var defineProperty = definePropertyModule.f;
	  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule$2.f;
	  for (var i = 0; i < keys.length; i++) {
	    var key = keys[i];
	    if (!hasOwn$6(target, key) && !(exceptions && hasOwn$6(exceptions, key))) {
	      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
	    }
	  }
	};

	var isObject$6 = isObject$m;
	var createNonEnumerableProperty$2 = createNonEnumerableProperty$9;

	// `InstallErrorCause` abstract operation
	// https://tc39.es/proposal-error-cause/#sec-errorobjects-install-error-cause
	var installErrorCause$1 = function (O, options) {
	  if (isObject$6(options) && 'cause' in options) {
	    createNonEnumerableProperty$2(O, 'cause', options.cause);
	  }
	};

	var uncurryThis$4 = functionUncurryThis;

	var $Error$1 = Error;
	var replace = uncurryThis$4(''.replace);

	var TEST = (function (arg) { return String(new $Error$1(arg).stack); })('zxcasd');
	// eslint-disable-next-line redos/no-vulnerable -- safe
	var V8_OR_CHAKRA_STACK_ENTRY = /\n\s*at [^:]*:[^\n]*/;
	var IS_V8_OR_CHAKRA_STACK = V8_OR_CHAKRA_STACK_ENTRY.test(TEST);

	var errorStackClear = function (stack, dropEntries) {
	  if (IS_V8_OR_CHAKRA_STACK && typeof stack == 'string' && !$Error$1.prepareStackTrace) {
	    while (dropEntries--) stack = replace(stack, V8_OR_CHAKRA_STACK_ENTRY, '');
	  } return stack;
	};

	var fails$8 = fails$A;
	var createPropertyDescriptor$1 = createPropertyDescriptor$7;

	var errorStackInstallable = !fails$8(function () {
	  var error = new Error('a');
	  if (!('stack' in error)) return true;
	  // eslint-disable-next-line es/no-object-defineproperty -- safe
	  Object.defineProperty(error, 'stack', createPropertyDescriptor$1(1, 7));
	  return error.stack !== 7;
	});

	var createNonEnumerableProperty$1 = createNonEnumerableProperty$9;
	var clearErrorStack = errorStackClear;
	var ERROR_STACK_INSTALLABLE = errorStackInstallable;

	// non-standard V8
	var captureStackTrace = Error.captureStackTrace;

	var errorStackInstall = function (error, C, stack, dropEntries) {
	  if (ERROR_STACK_INSTALLABLE) {
	    if (captureStackTrace) captureStackTrace(error, C);
	    else createNonEnumerableProperty$1(error, 'stack', clearErrorStack(stack, dropEntries));
	  }
	};

	var toString$2 = toString$b;

	var normalizeStringArgument$1 = function (argument, $default) {
	  return argument === undefined ? arguments.length < 2 ? '' : $default : toString$2(argument);
	};

	var $$n = _export;
	var isPrototypeOf$7 = objectIsPrototypeOf;
	var getPrototypeOf$1 = objectGetPrototypeOf$1;
	var setPrototypeOf = objectSetPrototypeOf;
	var copyConstructorProperties = copyConstructorProperties$1;
	var create$1 = objectCreate;
	var createNonEnumerableProperty = createNonEnumerableProperty$9;
	var createPropertyDescriptor = createPropertyDescriptor$7;
	var installErrorCause = installErrorCause$1;
	var installErrorStack = errorStackInstall;
	var iterate$5 = iterate$8;
	var normalizeStringArgument = normalizeStringArgument$1;
	var wellKnownSymbol$2 = wellKnownSymbol$p;

	var TO_STRING_TAG = wellKnownSymbol$2('toStringTag');
	var $Error = Error;
	var push$2 = [].push;

	var $AggregateError = function AggregateError(errors, message /* , options */) {
	  var isInstance = isPrototypeOf$7(AggregateErrorPrototype, this);
	  var that;
	  if (setPrototypeOf) {
	    that = setPrototypeOf(new $Error(), isInstance ? getPrototypeOf$1(this) : AggregateErrorPrototype);
	  } else {
	    that = isInstance ? this : create$1(AggregateErrorPrototype);
	    createNonEnumerableProperty(that, TO_STRING_TAG, 'Error');
	  }
	  if (message !== undefined) createNonEnumerableProperty(that, 'message', normalizeStringArgument(message));
	  installErrorStack(that, $AggregateError, that.stack, 1);
	  if (arguments.length > 2) installErrorCause(that, arguments[2]);
	  var errorsArray = [];
	  iterate$5(errors, push$2, { that: errorsArray });
	  createNonEnumerableProperty(that, 'errors', errorsArray);
	  return that;
	};

	if (setPrototypeOf) setPrototypeOf($AggregateError, $Error);
	else copyConstructorProperties($AggregateError, $Error, { name: true });

	var AggregateErrorPrototype = $AggregateError.prototype = create$1($Error.prototype, {
	  constructor: createPropertyDescriptor(1, $AggregateError),
	  message: createPropertyDescriptor(1, ''),
	  name: createPropertyDescriptor(1, 'AggregateError')
	});

	// `AggregateError` constructor
	// https://tc39.es/ecma262/#sec-aggregate-error-constructor
	$$n({ global: true, constructor: true, arity: 2 }, {
	  AggregateError: $AggregateError
	});

	var global$8 = global$s;
	var classof$3 = classofRaw$2;

	var engineIsNode = classof$3(global$8.process) === 'process';

	var isConstructor = isConstructor$4;
	var tryToString = tryToString$6;

	var $TypeError$2 = TypeError;

	// `Assert: IsConstructor(argument) is true`
	var aConstructor$2 = function (argument) {
	  if (isConstructor(argument)) return argument;
	  throw new $TypeError$2(tryToString(argument) + ' is not a constructor');
	};

	var anObject$4 = anObject$f;
	var aConstructor$1 = aConstructor$2;
	var isNullOrUndefined$1 = isNullOrUndefined$7;
	var wellKnownSymbol$1 = wellKnownSymbol$p;

	var SPECIES$1 = wellKnownSymbol$1('species');

	// `SpeciesConstructor` abstract operation
	// https://tc39.es/ecma262/#sec-speciesconstructor
	var speciesConstructor$2 = function (O, defaultConstructor) {
	  var C = anObject$4(O).constructor;
	  var S;
	  return C === undefined || isNullOrUndefined$1(S = anObject$4(C)[SPECIES$1]) ? defaultConstructor : aConstructor$1(S);
	};

	var userAgent$4 = engineUserAgent;

	// eslint-disable-next-line redos/no-vulnerable -- safe
	var engineIsIos = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent$4);

	var global$7 = global$s;
	var apply$1 = functionApply;
	var bind$4 = functionBindContext;
	var isCallable$3 = isCallable$m;
	var hasOwn$5 = hasOwnProperty_1;
	var fails$7 = fails$A;
	var html = html$2;
	var arraySlice$1 = arraySlice$6;
	var createElement = documentCreateElement$1;
	var validateArgumentsLength = validateArgumentsLength$2;
	var IS_IOS$1 = engineIsIos;
	var IS_NODE$4 = engineIsNode;

	var set$3 = global$7.setImmediate;
	var clear = global$7.clearImmediate;
	var process$2 = global$7.process;
	var Dispatch = global$7.Dispatch;
	var Function$1 = global$7.Function;
	var MessageChannel = global$7.MessageChannel;
	var String$1 = global$7.String;
	var counter = 0;
	var queue$2 = {};
	var ONREADYSTATECHANGE = 'onreadystatechange';
	var $location, defer, channel, port;

	fails$7(function () {
	  // Deno throws a ReferenceError on `location` access without `--location` flag
	  $location = global$7.location;
	});

	var run = function (id) {
	  if (hasOwn$5(queue$2, id)) {
	    var fn = queue$2[id];
	    delete queue$2[id];
	    fn();
	  }
	};

	var runner = function (id) {
	  return function () {
	    run(id);
	  };
	};

	var eventListener = function (event) {
	  run(event.data);
	};

	var globalPostMessageDefer = function (id) {
	  // old engines have not location.origin
	  global$7.postMessage(String$1(id), $location.protocol + '//' + $location.host);
	};

	// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
	if (!set$3 || !clear) {
	  set$3 = function setImmediate(handler) {
	    validateArgumentsLength(arguments.length, 1);
	    var fn = isCallable$3(handler) ? handler : Function$1(handler);
	    var args = arraySlice$1(arguments, 1);
	    queue$2[++counter] = function () {
	      apply$1(fn, undefined, args);
	    };
	    defer(counter);
	    return counter;
	  };
	  clear = function clearImmediate(id) {
	    delete queue$2[id];
	  };
	  // Node.js 0.8-
	  if (IS_NODE$4) {
	    defer = function (id) {
	      process$2.nextTick(runner(id));
	    };
	  // Sphere (JS game engine) Dispatch API
	  } else if (Dispatch && Dispatch.now) {
	    defer = function (id) {
	      Dispatch.now(runner(id));
	    };
	  // Browsers with MessageChannel, includes WebWorkers
	  // except iOS - https://github.com/zloirock/core-js/issues/624
	  } else if (MessageChannel && !IS_IOS$1) {
	    channel = new MessageChannel();
	    port = channel.port2;
	    channel.port1.onmessage = eventListener;
	    defer = bind$4(port.postMessage, port);
	  // Browsers with postMessage, skip WebWorkers
	  // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
	  } else if (
	    global$7.addEventListener &&
	    isCallable$3(global$7.postMessage) &&
	    !global$7.importScripts &&
	    $location && $location.protocol !== 'file:' &&
	    !fails$7(globalPostMessageDefer)
	  ) {
	    defer = globalPostMessageDefer;
	    global$7.addEventListener('message', eventListener, false);
	  // IE8-
	  } else if (ONREADYSTATECHANGE in createElement('script')) {
	    defer = function (id) {
	      html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
	        html.removeChild(this);
	        run(id);
	      };
	    };
	  // Rest old browsers
	  } else {
	    defer = function (id) {
	      setTimeout(runner(id), 0);
	    };
	  }
	}

	var task$1 = {
	  set: set$3,
	  clear: clear
	};

	var Queue$3 = function () {
	  this.head = null;
	  this.tail = null;
	};

	Queue$3.prototype = {
	  add: function (item) {
	    var entry = { item: item, next: null };
	    var tail = this.tail;
	    if (tail) tail.next = entry;
	    else this.head = entry;
	    this.tail = entry;
	  },
	  get: function () {
	    var entry = this.head;
	    if (entry) {
	      var next = this.head = entry.next;
	      if (next === null) this.tail = null;
	      return entry.item;
	    }
	  }
	};

	var queue$1 = Queue$3;

	var userAgent$3 = engineUserAgent;

	var engineIsIosPebble = /ipad|iphone|ipod/i.test(userAgent$3) && typeof Pebble != 'undefined';

	var userAgent$2 = engineUserAgent;

	var engineIsWebosWebkit = /web0s(?!.*chrome)/i.test(userAgent$2);

	var global$6 = global$s;
	var bind$3 = functionBindContext;
	var getOwnPropertyDescriptor$7 = objectGetOwnPropertyDescriptor.f;
	var macrotask = task$1.set;
	var Queue$2 = queue$1;
	var IS_IOS = engineIsIos;
	var IS_IOS_PEBBLE = engineIsIosPebble;
	var IS_WEBOS_WEBKIT = engineIsWebosWebkit;
	var IS_NODE$3 = engineIsNode;

	var MutationObserver = global$6.MutationObserver || global$6.WebKitMutationObserver;
	var document$2 = global$6.document;
	var process$1 = global$6.process;
	var Promise$1 = global$6.Promise;
	// Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`
	var queueMicrotaskDescriptor = getOwnPropertyDescriptor$7(global$6, 'queueMicrotask');
	var microtask$1 = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
	var notify$1, toggle, node, promise$5, then;

	// modern engines have queueMicrotask method
	if (!microtask$1) {
	  var queue = new Queue$2();

	  var flush = function () {
	    var parent, fn;
	    if (IS_NODE$3 && (parent = process$1.domain)) parent.exit();
	    while (fn = queue.get()) try {
	      fn();
	    } catch (error) {
	      if (queue.head) notify$1();
	      throw error;
	    }
	    if (parent) parent.enter();
	  };

	  // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
	  // also except WebOS Webkit https://github.com/zloirock/core-js/issues/898
	  if (!IS_IOS && !IS_NODE$3 && !IS_WEBOS_WEBKIT && MutationObserver && document$2) {
	    toggle = true;
	    node = document$2.createTextNode('');
	    new MutationObserver(flush).observe(node, { characterData: true });
	    notify$1 = function () {
	      node.data = toggle = !toggle;
	    };
	  // environments with maybe non-completely correct, but existent Promise
	  } else if (!IS_IOS_PEBBLE && Promise$1 && Promise$1.resolve) {
	    // Promise.resolve without an argument throws an error in LG WebOS 2
	    promise$5 = Promise$1.resolve(undefined);
	    // workaround of WebKit ~ iOS Safari 10.1 bug
	    promise$5.constructor = Promise$1;
	    then = bind$3(promise$5.then, promise$5);
	    notify$1 = function () {
	      then(flush);
	    };
	  // Node.js without promises
	  } else if (IS_NODE$3) {
	    notify$1 = function () {
	      process$1.nextTick(flush);
	    };
	  // for other environments - macrotask based on:
	  // - setImmediate
	  // - MessageChannel
	  // - window.postMessage
	  // - onreadystatechange
	  // - setTimeout
	  } else {
	    // `webpack` dev server bug on IE global methods - use bind(fn, global)
	    macrotask = bind$3(macrotask, global$6);
	    notify$1 = function () {
	      macrotask(flush);
	    };
	  }

	  microtask$1 = function (fn) {
	    if (!queue.head) notify$1();
	    queue.add(fn);
	  };
	}

	var microtask_1 = microtask$1;

	var hostReportErrors$1 = function (a, b) {
	  try {
	    // eslint-disable-next-line no-console -- safe
	    arguments.length === 1 ? console.error(a) : console.error(a, b);
	  } catch (error) { /* empty */ }
	};

	var perform$6 = function (exec) {
	  try {
	    return { error: false, value: exec() };
	  } catch (error) {
	    return { error: true, value: error };
	  }
	};

	var global$5 = global$s;

	var promiseNativeConstructor = global$5.Promise;

	/* global Deno -- Deno case */
	var engineIsDeno = typeof Deno == 'object' && Deno && typeof Deno.version == 'object';

	var IS_DENO$1 = engineIsDeno;
	var IS_NODE$2 = engineIsNode;

	var engineIsBrowser = !IS_DENO$1 && !IS_NODE$2
	  && typeof window == 'object'
	  && typeof document == 'object';

	var global$4 = global$s;
	var NativePromiseConstructor$5 = promiseNativeConstructor;
	var isCallable$2 = isCallable$m;
	var isForced = isForced_1;
	var inspectSource = inspectSource$2;
	var wellKnownSymbol = wellKnownSymbol$p;
	var IS_BROWSER = engineIsBrowser;
	var IS_DENO = engineIsDeno;
	var V8_VERSION = engineV8Version;

	var NativePromisePrototype$2 = NativePromiseConstructor$5 && NativePromiseConstructor$5.prototype;
	var SPECIES = wellKnownSymbol('species');
	var SUBCLASSING = false;
	var NATIVE_PROMISE_REJECTION_EVENT$1 = isCallable$2(global$4.PromiseRejectionEvent);

	var FORCED_PROMISE_CONSTRUCTOR$5 = isForced('Promise', function () {
	  var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(NativePromiseConstructor$5);
	  var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(NativePromiseConstructor$5);
	  // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
	  // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
	  // We can't detect it synchronously, so just check versions
	  if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true;
	  // We need Promise#{ catch, finally } in the pure version for preventing prototype pollution
	  if (!(NativePromisePrototype$2['catch'] && NativePromisePrototype$2['finally'])) return true;
	  // We can't use @@species feature detection in V8 since it causes
	  // deoptimization and performance degradation
	  // https://github.com/zloirock/core-js/issues/679
	  if (!V8_VERSION || V8_VERSION < 51 || !/native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) {
	    // Detect correctness of subclassing with @@species support
	    var promise = new NativePromiseConstructor$5(function (resolve) { resolve(1); });
	    var FakePromise = function (exec) {
	      exec(function () { /* empty */ }, function () { /* empty */ });
	    };
	    var constructor = promise.constructor = {};
	    constructor[SPECIES] = FakePromise;
	    SUBCLASSING = promise.then(function () { /* empty */ }) instanceof FakePromise;
	    if (!SUBCLASSING) return true;
	  // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test
	  } return !GLOBAL_CORE_JS_PROMISE && (IS_BROWSER || IS_DENO) && !NATIVE_PROMISE_REJECTION_EVENT$1;
	});

	var promiseConstructorDetection = {
	  CONSTRUCTOR: FORCED_PROMISE_CONSTRUCTOR$5,
	  REJECTION_EVENT: NATIVE_PROMISE_REJECTION_EVENT$1,
	  SUBCLASSING: SUBCLASSING
	};

	var newPromiseCapability$2 = {};

	var aCallable$8 = aCallable$e;

	var $TypeError$1 = TypeError;

	var PromiseCapability = function (C) {
	  var resolve, reject;
	  this.promise = new C(function ($$resolve, $$reject) {
	    if (resolve !== undefined || reject !== undefined) throw new $TypeError$1('Bad Promise constructor');
	    resolve = $$resolve;
	    reject = $$reject;
	  });
	  this.resolve = aCallable$8(resolve);
	  this.reject = aCallable$8(reject);
	};

	// `NewPromiseCapability` abstract operation
	// https://tc39.es/ecma262/#sec-newpromisecapability
	newPromiseCapability$2.f = function (C) {
	  return new PromiseCapability(C);
	};

	var $$m = _export;
	var IS_NODE$1 = engineIsNode;
	var global$3 = global$s;
	var call$6 = functionCall;
	var defineBuiltIn = defineBuiltIn$6;
	var setToStringTag = setToStringTag$7;
	var setSpecies = setSpecies$2;
	var aCallable$7 = aCallable$e;
	var isCallable$1 = isCallable$m;
	var isObject$5 = isObject$m;
	var anInstance$1 = anInstance$4;
	var speciesConstructor$1 = speciesConstructor$2;
	var task = task$1.set;
	var microtask = microtask_1;
	var hostReportErrors = hostReportErrors$1;
	var perform$5 = perform$6;
	var Queue$1 = queue$1;
	var InternalStateModule$1 = internalState;
	var NativePromiseConstructor$4 = promiseNativeConstructor;
	var PromiseConstructorDetection = promiseConstructorDetection;
	var newPromiseCapabilityModule$7 = newPromiseCapability$2;

	var PROMISE = 'Promise';
	var FORCED_PROMISE_CONSTRUCTOR$4 = PromiseConstructorDetection.CONSTRUCTOR;
	var NATIVE_PROMISE_REJECTION_EVENT = PromiseConstructorDetection.REJECTION_EVENT;
	PromiseConstructorDetection.SUBCLASSING;
	var getInternalPromiseState = InternalStateModule$1.getterFor(PROMISE);
	var setInternalState$1 = InternalStateModule$1.set;
	var NativePromisePrototype$1 = NativePromiseConstructor$4 && NativePromiseConstructor$4.prototype;
	var PromiseConstructor = NativePromiseConstructor$4;
	var PromisePrototype = NativePromisePrototype$1;
	var TypeError$1 = global$3.TypeError;
	var document$1 = global$3.document;
	var process = global$3.process;
	var newPromiseCapability$1 = newPromiseCapabilityModule$7.f;
	var newGenericPromiseCapability = newPromiseCapability$1;

	var DISPATCH_EVENT = !!(document$1 && document$1.createEvent && global$3.dispatchEvent);
	var UNHANDLED_REJECTION = 'unhandledrejection';
	var REJECTION_HANDLED = 'rejectionhandled';
	var PENDING = 0;
	var FULFILLED = 1;
	var REJECTED = 2;
	var HANDLED = 1;
	var UNHANDLED = 2;

	var Internal, OwnPromiseCapability, PromiseWrapper;

	// helpers
	var isThenable = function (it) {
	  var then;
	  return isObject$5(it) && isCallable$1(then = it.then) ? then : false;
	};

	var callReaction = function (reaction, state) {
	  var value = state.value;
	  var ok = state.state === FULFILLED;
	  var handler = ok ? reaction.ok : reaction.fail;
	  var resolve = reaction.resolve;
	  var reject = reaction.reject;
	  var domain = reaction.domain;
	  var result, then, exited;
	  try {
	    if (handler) {
	      if (!ok) {
	        if (state.rejection === UNHANDLED) onHandleUnhandled(state);
	        state.rejection = HANDLED;
	      }
	      if (handler === true) result = value;
	      else {
	        if (domain) domain.enter();
	        result = handler(value); // can throw
	        if (domain) {
	          domain.exit();
	          exited = true;
	        }
	      }
	      if (result === reaction.promise) {
	        reject(new TypeError$1('Promise-chain cycle'));
	      } else if (then = isThenable(result)) {
	        call$6(then, result, resolve, reject);
	      } else resolve(result);
	    } else reject(value);
	  } catch (error) {
	    if (domain && !exited) domain.exit();
	    reject(error);
	  }
	};

	var notify = function (state, isReject) {
	  if (state.notified) return;
	  state.notified = true;
	  microtask(function () {
	    var reactions = state.reactions;
	    var reaction;
	    while (reaction = reactions.get()) {
	      callReaction(reaction, state);
	    }
	    state.notified = false;
	    if (isReject && !state.rejection) onUnhandled(state);
	  });
	};

	var dispatchEvent = function (name, promise, reason) {
	  var event, handler;
	  if (DISPATCH_EVENT) {
	    event = document$1.createEvent('Event');
	    event.promise = promise;
	    event.reason = reason;
	    event.initEvent(name, false, true);
	    global$3.dispatchEvent(event);
	  } else event = { promise: promise, reason: reason };
	  if (!NATIVE_PROMISE_REJECTION_EVENT && (handler = global$3['on' + name])) handler(event);
	  else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
	};

	var onUnhandled = function (state) {
	  call$6(task, global$3, function () {
	    var promise = state.facade;
	    var value = state.value;
	    var IS_UNHANDLED = isUnhandled(state);
	    var result;
	    if (IS_UNHANDLED) {
	      result = perform$5(function () {
	        if (IS_NODE$1) {
	          process.emit('unhandledRejection', value, promise);
	        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
	      });
	      // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
	      state.rejection = IS_NODE$1 || isUnhandled(state) ? UNHANDLED : HANDLED;
	      if (result.error) throw result.value;
	    }
	  });
	};

	var isUnhandled = function (state) {
	  return state.rejection !== HANDLED && !state.parent;
	};

	var onHandleUnhandled = function (state) {
	  call$6(task, global$3, function () {
	    var promise = state.facade;
	    if (IS_NODE$1) {
	      process.emit('rejectionHandled', promise);
	    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
	  });
	};

	var bind$2 = function (fn, state, unwrap) {
	  return function (value) {
	    fn(state, value, unwrap);
	  };
	};

	var internalReject = function (state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;
	  state.value = value;
	  state.state = REJECTED;
	  notify(state, true);
	};

	var internalResolve = function (state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;
	  try {
	    if (state.facade === value) throw new TypeError$1("Promise can't be resolved itself");
	    var then = isThenable(value);
	    if (then) {
	      microtask(function () {
	        var wrapper = { done: false };
	        try {
	          call$6(then, value,
	            bind$2(internalResolve, wrapper, state),
	            bind$2(internalReject, wrapper, state)
	          );
	        } catch (error) {
	          internalReject(wrapper, error, state);
	        }
	      });
	    } else {
	      state.value = value;
	      state.state = FULFILLED;
	      notify(state, false);
	    }
	  } catch (error) {
	    internalReject({ done: false }, error, state);
	  }
	};

	// constructor polyfill
	if (FORCED_PROMISE_CONSTRUCTOR$4) {
	  // 25.4.3.1 Promise(executor)
	  PromiseConstructor = function Promise(executor) {
	    anInstance$1(this, PromisePrototype);
	    aCallable$7(executor);
	    call$6(Internal, this);
	    var state = getInternalPromiseState(this);
	    try {
	      executor(bind$2(internalResolve, state), bind$2(internalReject, state));
	    } catch (error) {
	      internalReject(state, error);
	    }
	  };

	  PromisePrototype = PromiseConstructor.prototype;

	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  Internal = function Promise(executor) {
	    setInternalState$1(this, {
	      type: PROMISE,
	      done: false,
	      notified: false,
	      parent: false,
	      reactions: new Queue$1(),
	      rejection: false,
	      state: PENDING,
	      value: undefined
	    });
	  };

	  // `Promise.prototype.then` method
	  // https://tc39.es/ecma262/#sec-promise.prototype.then
	  Internal.prototype = defineBuiltIn(PromisePrototype, 'then', function then(onFulfilled, onRejected) {
	    var state = getInternalPromiseState(this);
	    var reaction = newPromiseCapability$1(speciesConstructor$1(this, PromiseConstructor));
	    state.parent = true;
	    reaction.ok = isCallable$1(onFulfilled) ? onFulfilled : true;
	    reaction.fail = isCallable$1(onRejected) && onRejected;
	    reaction.domain = IS_NODE$1 ? process.domain : undefined;
	    if (state.state === PENDING) state.reactions.add(reaction);
	    else microtask(function () {
	      callReaction(reaction, state);
	    });
	    return reaction.promise;
	  });

	  OwnPromiseCapability = function () {
	    var promise = new Internal();
	    var state = getInternalPromiseState(promise);
	    this.promise = promise;
	    this.resolve = bind$2(internalResolve, state);
	    this.reject = bind$2(internalReject, state);
	  };

	  newPromiseCapabilityModule$7.f = newPromiseCapability$1 = function (C) {
	    return C === PromiseConstructor || C === PromiseWrapper
	      ? new OwnPromiseCapability(C)
	      : newGenericPromiseCapability(C);
	  };
	}

	$$m({ global: true, constructor: true, wrap: true, forced: FORCED_PROMISE_CONSTRUCTOR$4 }, {
	  Promise: PromiseConstructor
	});

	setToStringTag(PromiseConstructor, PROMISE, false, true);
	setSpecies(PROMISE);

	var NativePromiseConstructor$3 = promiseNativeConstructor;
	var checkCorrectnessOfIteration = checkCorrectnessOfIteration$2;
	var FORCED_PROMISE_CONSTRUCTOR$3 = promiseConstructorDetection.CONSTRUCTOR;

	var promiseStaticsIncorrectIteration = FORCED_PROMISE_CONSTRUCTOR$3 || !checkCorrectnessOfIteration(function (iterable) {
	  NativePromiseConstructor$3.all(iterable).then(undefined, function () { /* empty */ });
	});

	var $$l = _export;
	var call$5 = functionCall;
	var aCallable$6 = aCallable$e;
	var newPromiseCapabilityModule$6 = newPromiseCapability$2;
	var perform$4 = perform$6;
	var iterate$4 = iterate$8;
	var PROMISE_STATICS_INCORRECT_ITERATION$3 = promiseStaticsIncorrectIteration;

	// `Promise.all` method
	// https://tc39.es/ecma262/#sec-promise.all
	$$l({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION$3 }, {
	  all: function all(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule$6.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform$4(function () {
	      var $promiseResolve = aCallable$6(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate$4(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        remaining++;
	        call$5($promiseResolve, C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = value;
	          --remaining || resolve(values);
	        }, reject);
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var $$k = _export;
	var FORCED_PROMISE_CONSTRUCTOR$2 = promiseConstructorDetection.CONSTRUCTOR;
	var NativePromiseConstructor$2 = promiseNativeConstructor;

	NativePromiseConstructor$2 && NativePromiseConstructor$2.prototype;

	// `Promise.prototype.catch` method
	// https://tc39.es/ecma262/#sec-promise.prototype.catch
	$$k({ target: 'Promise', proto: true, forced: FORCED_PROMISE_CONSTRUCTOR$2, real: true }, {
	  'catch': function (onRejected) {
	    return this.then(undefined, onRejected);
	  }
	});

	var $$j = _export;
	var call$4 = functionCall;
	var aCallable$5 = aCallable$e;
	var newPromiseCapabilityModule$5 = newPromiseCapability$2;
	var perform$3 = perform$6;
	var iterate$3 = iterate$8;
	var PROMISE_STATICS_INCORRECT_ITERATION$2 = promiseStaticsIncorrectIteration;

	// `Promise.race` method
	// https://tc39.es/ecma262/#sec-promise.race
	$$j({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION$2 }, {
	  race: function race(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule$5.f(C);
	    var reject = capability.reject;
	    var result = perform$3(function () {
	      var $promiseResolve = aCallable$5(C.resolve);
	      iterate$3(iterable, function (promise) {
	        call$4($promiseResolve, C, promise).then(capability.resolve, reject);
	      });
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var $$i = _export;
	var call$3 = functionCall;
	var newPromiseCapabilityModule$4 = newPromiseCapability$2;
	var FORCED_PROMISE_CONSTRUCTOR$1 = promiseConstructorDetection.CONSTRUCTOR;

	// `Promise.reject` method
	// https://tc39.es/ecma262/#sec-promise.reject
	$$i({ target: 'Promise', stat: true, forced: FORCED_PROMISE_CONSTRUCTOR$1 }, {
	  reject: function reject(r) {
	    var capability = newPromiseCapabilityModule$4.f(this);
	    call$3(capability.reject, undefined, r);
	    return capability.promise;
	  }
	});

	var anObject$3 = anObject$f;
	var isObject$4 = isObject$m;
	var newPromiseCapability = newPromiseCapability$2;

	var promiseResolve$2 = function (C, x) {
	  anObject$3(C);
	  if (isObject$4(x) && x.constructor === C) return x;
	  var promiseCapability = newPromiseCapability.f(C);
	  var resolve = promiseCapability.resolve;
	  resolve(x);
	  return promiseCapability.promise;
	};

	var $$h = _export;
	var getBuiltIn$3 = getBuiltIn$f;
	var IS_PURE = isPure;
	var NativePromiseConstructor$1 = promiseNativeConstructor;
	var FORCED_PROMISE_CONSTRUCTOR = promiseConstructorDetection.CONSTRUCTOR;
	var promiseResolve$1 = promiseResolve$2;

	var PromiseConstructorWrapper = getBuiltIn$3('Promise');
	var CHECK_WRAPPER = !FORCED_PROMISE_CONSTRUCTOR;

	// `Promise.resolve` method
	// https://tc39.es/ecma262/#sec-promise.resolve
	$$h({ target: 'Promise', stat: true, forced: IS_PURE  }, {
	  resolve: function resolve(x) {
	    return promiseResolve$1(CHECK_WRAPPER && this === PromiseConstructorWrapper ? NativePromiseConstructor$1 : this, x);
	  }
	});

	var $$g = _export;
	var call$2 = functionCall;
	var aCallable$4 = aCallable$e;
	var newPromiseCapabilityModule$3 = newPromiseCapability$2;
	var perform$2 = perform$6;
	var iterate$2 = iterate$8;
	var PROMISE_STATICS_INCORRECT_ITERATION$1 = promiseStaticsIncorrectIteration;

	// `Promise.allSettled` method
	// https://tc39.es/ecma262/#sec-promise.allsettled
	$$g({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION$1 }, {
	  allSettled: function allSettled(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule$3.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform$2(function () {
	      var promiseResolve = aCallable$4(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate$2(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        remaining++;
	        call$2(promiseResolve, C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = { status: 'fulfilled', value: value };
	          --remaining || resolve(values);
	        }, function (error) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = { status: 'rejected', reason: error };
	          --remaining || resolve(values);
	        });
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var $$f = _export;
	var call$1 = functionCall;
	var aCallable$3 = aCallable$e;
	var getBuiltIn$2 = getBuiltIn$f;
	var newPromiseCapabilityModule$2 = newPromiseCapability$2;
	var perform$1 = perform$6;
	var iterate$1 = iterate$8;
	var PROMISE_STATICS_INCORRECT_ITERATION = promiseStaticsIncorrectIteration;

	var PROMISE_ANY_ERROR = 'No one promise resolved';

	// `Promise.any` method
	// https://tc39.es/ecma262/#sec-promise.any
	$$f({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
	  any: function any(iterable) {
	    var C = this;
	    var AggregateError = getBuiltIn$2('AggregateError');
	    var capability = newPromiseCapabilityModule$2.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform$1(function () {
	      var promiseResolve = aCallable$3(C.resolve);
	      var errors = [];
	      var counter = 0;
	      var remaining = 1;
	      var alreadyResolved = false;
	      iterate$1(iterable, function (promise) {
	        var index = counter++;
	        var alreadyRejected = false;
	        remaining++;
	        call$1(promiseResolve, C, promise).then(function (value) {
	          if (alreadyRejected || alreadyResolved) return;
	          alreadyResolved = true;
	          resolve(value);
	        }, function (error) {
	          if (alreadyRejected || alreadyResolved) return;
	          alreadyRejected = true;
	          errors[index] = error;
	          --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
	        });
	      });
	      --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});

	var $$e = _export;
	var NativePromiseConstructor = promiseNativeConstructor;
	var fails$6 = fails$A;
	var getBuiltIn$1 = getBuiltIn$f;
	var isCallable = isCallable$m;
	var speciesConstructor = speciesConstructor$2;
	var promiseResolve = promiseResolve$2;

	var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;

	// Safari bug https://bugs.webkit.org/show_bug.cgi?id=200829
	var NON_GENERIC = !!NativePromiseConstructor && fails$6(function () {
	  // eslint-disable-next-line unicorn/no-thenable -- required for testing
	  NativePromisePrototype['finally'].call({ then: function () { /* empty */ } }, function () { /* empty */ });
	});

	// `Promise.prototype.finally` method
	// https://tc39.es/ecma262/#sec-promise.prototype.finally
	$$e({ target: 'Promise', proto: true, real: true, forced: NON_GENERIC }, {
	  'finally': function (onFinally) {
	    var C = speciesConstructor(this, getBuiltIn$1('Promise'));
	    var isFunction = isCallable(onFinally);
	    return this.then(
	      isFunction ? function (x) {
	        return promiseResolve(C, onFinally()).then(function () { return x; });
	      } : onFinally,
	      isFunction ? function (e) {
	        return promiseResolve(C, onFinally()).then(function () { throw e; });
	      } : onFinally
	    );
	  }
	});

	var path$c = path$A;

	var promise$4 = path$c.Promise;

	var parent$t = promise$4;


	var promise$3 = parent$t;

	var $$d = _export;
	var newPromiseCapabilityModule$1 = newPromiseCapability$2;

	// `Promise.withResolvers` method
	// https://github.com/tc39/proposal-promise-with-resolvers
	$$d({ target: 'Promise', stat: true }, {
	  withResolvers: function withResolvers() {
	    var promiseCapability = newPromiseCapabilityModule$1.f(this);
	    return {
	      promise: promiseCapability.promise,
	      resolve: promiseCapability.resolve,
	      reject: promiseCapability.reject
	    };
	  }
	});

	var parent$s = promise$3;


	var promise$2 = parent$s;

	// TODO: Remove from `core-js@4`
	var $$c = _export;
	var newPromiseCapabilityModule = newPromiseCapability$2;
	var perform = perform$6;

	// `Promise.try` method
	// https://github.com/tc39/proposal-promise-try
	$$c({ target: 'Promise', stat: true, forced: true }, {
	  'try': function (callbackfn) {
	    var promiseCapability = newPromiseCapabilityModule.f(this);
	    var result = perform(callbackfn);
	    (result.error ? promiseCapability.reject : promiseCapability.resolve)(result.value);
	    return promiseCapability.promise;
	  }
	});

	var parent$r = promise$2;
	// TODO: Remove from `core-js@4`





	var promise$1 = parent$r;

	var promise = promise$1;

	var parent$q = reverse$4;

	var reverse$2 = parent$q;

	var parent$p = reverse$2;

	var reverse$1 = parent$p;

	var reverse = reverse$1;

	(function (module) {
		var _typeof = _typeofExports["default"];
		var _Object$defineProperty = defineProperty$6;
		var _Symbol = symbol$1;
		var _Object$create = create$2;
		var _Object$getPrototypeOf = getPrototypeOf$2;
		var _forEachInstanceProperty = forEach;
		var _pushInstanceProperty = push$4;
		var _Object$setPrototypeOf = setPrototypeOf$1;
		var _Promise = promise;
		var _reverseInstanceProperty = reverse;
		var _sliceInstanceProperty = slice$1;
		function _regeneratorRuntime() {
		  module.exports = _regeneratorRuntime = function _regeneratorRuntime() {
		    return e;
		  }, module.exports.__esModule = true, module.exports["default"] = module.exports;
		  var t,
		    e = {},
		    r = Object.prototype,
		    n = r.hasOwnProperty,
		    o = _Object$defineProperty || function (t, e, r) {
		      t[e] = r.value;
		    },
		    i = "function" == typeof _Symbol ? _Symbol : {},
		    a = i.iterator || "@@iterator",
		    c = i.asyncIterator || "@@asyncIterator",
		    u = i.toStringTag || "@@toStringTag";
		  function define(t, e, r) {
		    return _Object$defineProperty(t, e, {
		      value: r,
		      enumerable: !0,
		      configurable: !0,
		      writable: !0
		    }), t[e];
		  }
		  try {
		    define({}, "");
		  } catch (t) {
		    define = function define(t, e, r) {
		      return t[e] = r;
		    };
		  }
		  function wrap(t, e, r, n) {
		    var i = e && e.prototype instanceof Generator ? e : Generator,
		      a = _Object$create(i.prototype),
		      c = new Context(n || []);
		    return o(a, "_invoke", {
		      value: makeInvokeMethod(t, r, c)
		    }), a;
		  }
		  function tryCatch(t, e, r) {
		    try {
		      return {
		        type: "normal",
		        arg: t.call(e, r)
		      };
		    } catch (t) {
		      return {
		        type: "throw",
		        arg: t
		      };
		    }
		  }
		  e.wrap = wrap;
		  var h = "suspendedStart",
		    l = "suspendedYield",
		    f = "executing",
		    s = "completed",
		    y = {};
		  function Generator() {}
		  function GeneratorFunction() {}
		  function GeneratorFunctionPrototype() {}
		  var p = {};
		  define(p, a, function () {
		    return this;
		  });
		  var d = _Object$getPrototypeOf,
		    v = d && d(d(values([])));
		  v && v !== r && n.call(v, a) && (p = v);
		  var g = GeneratorFunctionPrototype.prototype = Generator.prototype = _Object$create(p);
		  function defineIteratorMethods(t) {
		    var _context;
		    _forEachInstanceProperty(_context = ["next", "throw", "return"]).call(_context, function (e) {
		      define(t, e, function (t) {
		        return this._invoke(e, t);
		      });
		    });
		  }
		  function AsyncIterator(t, e) {
		    function invoke(r, o, i, a) {
		      var c = tryCatch(t[r], t, o);
		      if ("throw" !== c.type) {
		        var u = c.arg,
		          h = u.value;
		        return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) {
		          invoke("next", t, i, a);
		        }, function (t) {
		          invoke("throw", t, i, a);
		        }) : e.resolve(h).then(function (t) {
		          u.value = t, i(u);
		        }, function (t) {
		          return invoke("throw", t, i, a);
		        });
		      }
		      a(c.arg);
		    }
		    var r;
		    o(this, "_invoke", {
		      value: function value(t, n) {
		        function callInvokeWithMethodAndArg() {
		          return new e(function (e, r) {
		            invoke(t, n, e, r);
		          });
		        }
		        return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
		      }
		    });
		  }
		  function makeInvokeMethod(e, r, n) {
		    var o = h;
		    return function (i, a) {
		      if (o === f) throw new Error("Generator is already running");
		      if (o === s) {
		        if ("throw" === i) throw a;
		        return {
		          value: t,
		          done: !0
		        };
		      }
		      for (n.method = i, n.arg = a;;) {
		        var c = n.delegate;
		        if (c) {
		          var u = maybeInvokeDelegate(c, n);
		          if (u) {
		            if (u === y) continue;
		            return u;
		          }
		        }
		        if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) {
		          if (o === h) throw o = s, n.arg;
		          n.dispatchException(n.arg);
		        } else "return" === n.method && n.abrupt("return", n.arg);
		        o = f;
		        var p = tryCatch(e, r, n);
		        if ("normal" === p.type) {
		          if (o = n.done ? s : l, p.arg === y) continue;
		          return {
		            value: p.arg,
		            done: n.done
		          };
		        }
		        "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg);
		      }
		    };
		  }
		  function maybeInvokeDelegate(e, r) {
		    var n = r.method,
		      o = e.iterator[n];
		    if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y;
		    var i = tryCatch(o, e.iterator, r.arg);
		    if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y;
		    var a = i.arg;
		    return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y);
		  }
		  function pushTryEntry(t) {
		    var _context2;
		    var e = {
		      tryLoc: t[0]
		    };
		    1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), _pushInstanceProperty(_context2 = this.tryEntries).call(_context2, e);
		  }
		  function resetTryEntry(t) {
		    var e = t.completion || {};
		    e.type = "normal", delete e.arg, t.completion = e;
		  }
		  function Context(t) {
		    this.tryEntries = [{
		      tryLoc: "root"
		    }], _forEachInstanceProperty(t).call(t, pushTryEntry, this), this.reset(!0);
		  }
		  function values(e) {
		    if (e || "" === e) {
		      var r = e[a];
		      if (r) return r.call(e);
		      if ("function" == typeof e.next) return e;
		      if (!isNaN(e.length)) {
		        var o = -1,
		          i = function next() {
		            for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next;
		            return next.value = t, next.done = !0, next;
		          };
		        return i.next = i;
		      }
		    }
		    throw new TypeError(_typeof(e) + " is not iterable");
		  }
		  return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", {
		    value: GeneratorFunctionPrototype,
		    configurable: !0
		  }), o(GeneratorFunctionPrototype, "constructor", {
		    value: GeneratorFunction,
		    configurable: !0
		  }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) {
		    var e = "function" == typeof t && t.constructor;
		    return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name));
		  }, e.mark = function (t) {
		    return _Object$setPrototypeOf ? _Object$setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = _Object$create(g), t;
		  }, e.awrap = function (t) {
		    return {
		      __await: t
		    };
		  }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () {
		    return this;
		  }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) {
		    void 0 === i && (i = _Promise);
		    var a = new AsyncIterator(wrap(t, r, n, o), i);
		    return e.isGeneratorFunction(r) ? a : a.next().then(function (t) {
		      return t.done ? t.value : a.next();
		    });
		  }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () {
		    return this;
		  }), define(g, "toString", function () {
		    return "[object Generator]";
		  }), e.keys = function (t) {
		    var e = Object(t),
		      r = [];
		    for (var n in e) _pushInstanceProperty(r).call(r, n);
		    return _reverseInstanceProperty(r).call(r), function next() {
		      for (; r.length;) {
		        var t = r.pop();
		        if (t in e) return next.value = t, next.done = !1, next;
		      }
		      return next.done = !0, next;
		    };
		  }, e.values = values, Context.prototype = {
		    constructor: Context,
		    reset: function reset(e) {
		      var _context3;
		      if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, _forEachInstanceProperty(_context3 = this.tryEntries).call(_context3, resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+_sliceInstanceProperty(r).call(r, 1)) && (this[r] = t);
		    },
		    stop: function stop() {
		      this.done = !0;
		      var t = this.tryEntries[0].completion;
		      if ("throw" === t.type) throw t.arg;
		      return this.rval;
		    },
		    dispatchException: function dispatchException(e) {
		      if (this.done) throw e;
		      var r = this;
		      function handle(n, o) {
		        return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o;
		      }
		      for (var o = this.tryEntries.length - 1; o >= 0; --o) {
		        var i = this.tryEntries[o],
		          a = i.completion;
		        if ("root" === i.tryLoc) return handle("end");
		        if (i.tryLoc <= this.prev) {
		          var c = n.call(i, "catchLoc"),
		            u = n.call(i, "finallyLoc");
		          if (c && u) {
		            if (this.prev < i.catchLoc) return handle(i.catchLoc, !0);
		            if (this.prev < i.finallyLoc) return handle(i.finallyLoc);
		          } else if (c) {
		            if (this.prev < i.catchLoc) return handle(i.catchLoc, !0);
		          } else {
		            if (!u) throw new Error("try statement without catch or finally");
		            if (this.prev < i.finallyLoc) return handle(i.finallyLoc);
		          }
		        }
		      }
		    },
		    abrupt: function abrupt(t, e) {
		      for (var r = this.tryEntries.length - 1; r >= 0; --r) {
		        var o = this.tryEntries[r];
		        if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) {
		          var i = o;
		          break;
		        }
		      }
		      i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null);
		      var a = i ? i.completion : {};
		      return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a);
		    },
		    complete: function complete(t, e) {
		      if ("throw" === t.type) throw t.arg;
		      return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y;
		    },
		    finish: function finish(t) {
		      for (var e = this.tryEntries.length - 1; e >= 0; --e) {
		        var r = this.tryEntries[e];
		        if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y;
		      }
		    },
		    "catch": function _catch(t) {
		      for (var e = this.tryEntries.length - 1; e >= 0; --e) {
		        var r = this.tryEntries[e];
		        if (r.tryLoc === t) {
		          var n = r.completion;
		          if ("throw" === n.type) {
		            var o = n.arg;
		            resetTryEntry(r);
		          }
		          return o;
		        }
		      }
		      throw new Error("illegal catch attempt");
		    },
		    delegateYield: function delegateYield(e, r, n) {
		      return this.delegate = {
		        iterator: values(e),
		        resultName: r,
		        nextLoc: n
		      }, "next" === this.method && (this.arg = t), y;
		    }
		  }, e;
		}
		module.exports = _regeneratorRuntime, module.exports.__esModule = true, module.exports["default"] = module.exports; 
	} (regeneratorRuntime$1));

	var regeneratorRuntimeExports = regeneratorRuntime$1.exports;

	// TODO(Babel 8): Remove this file.

	var runtime = regeneratorRuntimeExports();
	var regenerator = runtime;

	// Copied from https://github.com/facebook/regenerator/blob/main/packages/runtime/runtime.js#L736=
	try {
	  regeneratorRuntime = runtime;
	} catch (accidentalStrictMode) {
	  if (typeof globalThis === "object") {
	    globalThis.regeneratorRuntime = runtime;
	  } else {
	    Function("r", "regeneratorRuntime = r")(runtime);
	  }
	}

	var _regeneratorRuntime = /*@__PURE__*/getDefaultExportFromCjs(regenerator);

	var aCallable$2 = aCallable$e;
	var toObject$2 = toObject$f;
	var IndexedObject = indexedObject;
	var lengthOfArrayLike$3 = lengthOfArrayLike$e;

	var $TypeError = TypeError;

	// `Array.prototype.{ reduce, reduceRight }` methods implementation
	var createMethod = function (IS_RIGHT) {
	  return function (that, callbackfn, argumentsLength, memo) {
	    aCallable$2(callbackfn);
	    var O = toObject$2(that);
	    var self = IndexedObject(O);
	    var length = lengthOfArrayLike$3(O);
	    var index = IS_RIGHT ? length - 1 : 0;
	    var i = IS_RIGHT ? -1 : 1;
	    if (argumentsLength < 2) while (true) {
	      if (index in self) {
	        memo = self[index];
	        index += i;
	        break;
	      }
	      index += i;
	      if (IS_RIGHT ? index < 0 : length <= index) {
	        throw new $TypeError('Reduce of empty array with no initial value');
	      }
	    }
	    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
	      memo = callbackfn(memo, self[index], index, O);
	    }
	    return memo;
	  };
	};

	var arrayReduce = {
	  // `Array.prototype.reduce` method
	  // https://tc39.es/ecma262/#sec-array.prototype.reduce
	  left: createMethod(false),
	  // `Array.prototype.reduceRight` method
	  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
	  right: createMethod(true)
	};

	var $$b = _export;
	var $reduce = arrayReduce.left;
	var arrayMethodIsStrict$2 = arrayMethodIsStrict$6;
	var CHROME_VERSION = engineV8Version;
	var IS_NODE = engineIsNode;

	// Chrome 80-82 has a critical bug
	// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
	var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83;
	var FORCED$5 = CHROME_BUG || !arrayMethodIsStrict$2('reduce');

	// `Array.prototype.reduce` method
	// https://tc39.es/ecma262/#sec-array.prototype.reduce
	$$b({ target: 'Array', proto: true, forced: FORCED$5 }, {
	  reduce: function reduce(callbackfn /* , initialValue */) {
	    var length = arguments.length;
	    return $reduce(this, callbackfn, length, length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$6 = entryVirtual$l;

	var reduce$3 = entryVirtual$6('Array').reduce;

	var isPrototypeOf$6 = objectIsPrototypeOf;
	var method$6 = reduce$3;

	var ArrayPrototype$6 = Array.prototype;

	var reduce$2 = function (it) {
	  var own = it.reduce;
	  return it === ArrayPrototype$6 || (isPrototypeOf$6(ArrayPrototype$6, it) && own === ArrayPrototype$6.reduce) ? method$6 : own;
	};

	var parent$o = reduce$2;

	var reduce$1 = parent$o;

	var reduce = reduce$1;

	var _reduceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reduce);

	var isArray$1 = isArray$f;
	var lengthOfArrayLike$2 = lengthOfArrayLike$e;
	var doesNotExceedSafeInteger = doesNotExceedSafeInteger$4;
	var bind$1 = functionBindContext;

	// `FlattenIntoArray` abstract operation
	// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray
	var flattenIntoArray$1 = function (target, original, source, sourceLen, start, depth, mapper, thisArg) {
	  var targetIndex = start;
	  var sourceIndex = 0;
	  var mapFn = mapper ? bind$1(mapper, thisArg) : false;
	  var element, elementLen;

	  while (sourceIndex < sourceLen) {
	    if (sourceIndex in source) {
	      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

	      if (depth > 0 && isArray$1(element)) {
	        elementLen = lengthOfArrayLike$2(element);
	        targetIndex = flattenIntoArray$1(target, original, element, elementLen, targetIndex, depth - 1) - 1;
	      } else {
	        doesNotExceedSafeInteger(targetIndex + 1);
	        target[targetIndex] = element;
	      }

	      targetIndex++;
	    }
	    sourceIndex++;
	  }
	  return targetIndex;
	};

	var flattenIntoArray_1 = flattenIntoArray$1;

	var $$a = _export;
	var flattenIntoArray = flattenIntoArray_1;
	var aCallable$1 = aCallable$e;
	var toObject$1 = toObject$f;
	var lengthOfArrayLike$1 = lengthOfArrayLike$e;
	var arraySpeciesCreate = arraySpeciesCreate$4;

	// `Array.prototype.flatMap` method
	// https://tc39.es/ecma262/#sec-array.prototype.flatmap
	$$a({ target: 'Array', proto: true }, {
	  flatMap: function flatMap(callbackfn /* , thisArg */) {
	    var O = toObject$1(this);
	    var sourceLen = lengthOfArrayLike$1(O);
	    var A;
	    aCallable$1(callbackfn);
	    A = arraySpeciesCreate(O, 0);
	    A.length = flattenIntoArray(A, O, O, sourceLen, 0, 1, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	    return A;
	  }
	});

	var entryVirtual$5 = entryVirtual$l;

	var flatMap$3 = entryVirtual$5('Array').flatMap;

	var isPrototypeOf$5 = objectIsPrototypeOf;
	var method$5 = flatMap$3;

	var ArrayPrototype$5 = Array.prototype;

	var flatMap$2 = function (it) {
	  var own = it.flatMap;
	  return it === ArrayPrototype$5 || (isPrototypeOf$5(ArrayPrototype$5, it) && own === ArrayPrototype$5.flatMap) ? method$5 : own;
	};

	var parent$n = flatMap$2;

	var flatMap$1 = parent$n;

	var flatMap = flatMap$1;

	var _flatMapInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(flatMap);

	var collection$1 = collection$3;
	var collectionStrong = collectionStrong$2;

	// `Set` constructor
	// https://tc39.es/ecma262/#sec-set-objects
	collection$1('Set', function (init) {
	  return function Set() { return init(this, arguments.length ? arguments[0] : undefined); };
	}, collectionStrong);

	var path$b = path$A;

	var set$2 = path$b.Set;

	var parent$m = set$2;


	var set$1 = parent$m;

	var set = set$1;

	var _Set = /*@__PURE__*/getDefaultExportFromCjs(set);

	var iterator = iterator$4;

	var _Symbol$iterator2 = /*@__PURE__*/getDefaultExportFromCjs(iterator);

	var getIterator$5 = getIterator$8;

	var getIterator_1 = getIterator$5;

	var parent$l = getIterator_1;


	var getIterator$4 = parent$l;

	var parent$k = getIterator$4;

	var getIterator$3 = parent$k;

	var parent$j = getIterator$3;

	var getIterator$2 = parent$j;

	var getIterator$1 = getIterator$2;

	var getIterator = getIterator$1;

	var _getIterator = /*@__PURE__*/getDefaultExportFromCjs(getIterator);

	var arraySlice = arraySliceSimple;

	var floor = Math.floor;

	var mergeSort = function (array, comparefn) {
	  var length = array.length;
	  var middle = floor(length / 2);
	  return length < 8 ? insertionSort(array, comparefn) : merge(
	    array,
	    mergeSort(arraySlice(array, 0, middle), comparefn),
	    mergeSort(arraySlice(array, middle), comparefn),
	    comparefn
	  );
	};

	var insertionSort = function (array, comparefn) {
	  var length = array.length;
	  var i = 1;
	  var element, j;

	  while (i < length) {
	    j = i;
	    element = array[i];
	    while (j && comparefn(array[j - 1], element) > 0) {
	      array[j] = array[--j];
	    }
	    if (j !== i++) array[j] = element;
	  } return array;
	};

	var merge = function (array, left, right, comparefn) {
	  var llength = left.length;
	  var rlength = right.length;
	  var lindex = 0;
	  var rindex = 0;

	  while (lindex < llength || rindex < rlength) {
	    array[lindex + rindex] = (lindex < llength && rindex < rlength)
	      ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++]
	      : lindex < llength ? left[lindex++] : right[rindex++];
	  } return array;
	};

	var arraySort = mergeSort;

	var userAgent$1 = engineUserAgent;

	var firefox = userAgent$1.match(/firefox\/(\d+)/i);

	var engineFfVersion = !!firefox && +firefox[1];

	var UA = engineUserAgent;

	var engineIsIeOrEdge = /MSIE|Trident/.test(UA);

	var userAgent = engineUserAgent;

	var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);

	var engineWebkitVersion = !!webkit && +webkit[1];

	var $$9 = _export;
	var uncurryThis$3 = functionUncurryThis;
	var aCallable = aCallable$e;
	var toObject = toObject$f;
	var lengthOfArrayLike = lengthOfArrayLike$e;
	var deletePropertyOrThrow = deletePropertyOrThrow$2;
	var toString$1 = toString$b;
	var fails$5 = fails$A;
	var internalSort = arraySort;
	var arrayMethodIsStrict$1 = arrayMethodIsStrict$6;
	var FF = engineFfVersion;
	var IE_OR_EDGE = engineIsIeOrEdge;
	var V8 = engineV8Version;
	var WEBKIT = engineWebkitVersion;

	var test = [];
	var nativeSort = uncurryThis$3(test.sort);
	var push$1 = uncurryThis$3(test.push);

	// IE8-
	var FAILS_ON_UNDEFINED = fails$5(function () {
	  test.sort(undefined);
	});
	// V8 bug
	var FAILS_ON_NULL = fails$5(function () {
	  test.sort(null);
	});
	// Old WebKit
	var STRICT_METHOD$1 = arrayMethodIsStrict$1('sort');

	var STABLE_SORT = !fails$5(function () {
	  // feature detection can be too slow, so check engines versions
	  if (V8) return V8 < 70;
	  if (FF && FF > 3) return;
	  if (IE_OR_EDGE) return true;
	  if (WEBKIT) return WEBKIT < 603;

	  var result = '';
	  var code, chr, value, index;

	  // generate an array with more 512 elements (Chakra and old V8 fails only in this case)
	  for (code = 65; code < 76; code++) {
	    chr = String.fromCharCode(code);

	    switch (code) {
	      case 66: case 69: case 70: case 72: value = 3; break;
	      case 68: case 71: value = 4; break;
	      default: value = 2;
	    }

	    for (index = 0; index < 47; index++) {
	      test.push({ k: chr + index, v: value });
	    }
	  }

	  test.sort(function (a, b) { return b.v - a.v; });

	  for (index = 0; index < test.length; index++) {
	    chr = test[index].k.charAt(0);
	    if (result.charAt(result.length - 1) !== chr) result += chr;
	  }

	  return result !== 'DGBEFHACIJK';
	});

	var FORCED$4 = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD$1 || !STABLE_SORT;

	var getSortCompare = function (comparefn) {
	  return function (x, y) {
	    if (y === undefined) return -1;
	    if (x === undefined) return 1;
	    if (comparefn !== undefined) return +comparefn(x, y) || 0;
	    return toString$1(x) > toString$1(y) ? 1 : -1;
	  };
	};

	// `Array.prototype.sort` method
	// https://tc39.es/ecma262/#sec-array.prototype.sort
	$$9({ target: 'Array', proto: true, forced: FORCED$4 }, {
	  sort: function sort(comparefn) {
	    if (comparefn !== undefined) aCallable(comparefn);

	    var array = toObject(this);

	    if (STABLE_SORT) return comparefn === undefined ? nativeSort(array) : nativeSort(array, comparefn);

	    var items = [];
	    var arrayLength = lengthOfArrayLike(array);
	    var itemsLength, index;

	    for (index = 0; index < arrayLength; index++) {
	      if (index in array) push$1(items, array[index]);
	    }

	    internalSort(items, getSortCompare(comparefn));

	    itemsLength = lengthOfArrayLike(items);
	    index = 0;

	    while (index < itemsLength) array[index] = items[index++];
	    while (index < arrayLength) deletePropertyOrThrow(array, index++);

	    return array;
	  }
	});

	var entryVirtual$4 = entryVirtual$l;

	var sort$3 = entryVirtual$4('Array').sort;

	var isPrototypeOf$4 = objectIsPrototypeOf;
	var method$4 = sort$3;

	var ArrayPrototype$4 = Array.prototype;

	var sort$2 = function (it) {
	  var own = it.sort;
	  return it === ArrayPrototype$4 || (isPrototypeOf$4(ArrayPrototype$4, it) && own === ArrayPrototype$4.sort) ? method$4 : own;
	};

	var parent$i = sort$2;

	var sort$1 = parent$i;

	var sort = sort$1;

	var _sortInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(sort);

	var entryVirtual$3 = entryVirtual$l;

	var keys$3 = entryVirtual$3('Array').keys;

	var parent$h = keys$3;

	var keys$2 = parent$h;

	var classof$2 = classof$f;
	var hasOwn$4 = hasOwnProperty_1;
	var isPrototypeOf$3 = objectIsPrototypeOf;
	var method$3 = keys$2;

	var ArrayPrototype$3 = Array.prototype;

	var DOMIterables$2 = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var keys$1 = function (it) {
	  var own = it.keys;
	  return it === ArrayPrototype$3 || (isPrototypeOf$3(ArrayPrototype$3, it) && own === ArrayPrototype$3.keys)
	    || hasOwn$4(DOMIterables$2, classof$2(it)) ? method$3 : own;
	};

	var keys = keys$1;

	var _keysInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(keys);

	var entryVirtual$2 = entryVirtual$l;

	var values$3 = entryVirtual$2('Array').values;

	var parent$g = values$3;

	var values$2 = parent$g;

	var classof$1 = classof$f;
	var hasOwn$3 = hasOwnProperty_1;
	var isPrototypeOf$2 = objectIsPrototypeOf;
	var method$2 = values$2;

	var ArrayPrototype$2 = Array.prototype;

	var DOMIterables$1 = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var values$1 = function (it) {
	  var own = it.values;
	  return it === ArrayPrototype$2 || (isPrototypeOf$2(ArrayPrototype$2, it) && own === ArrayPrototype$2.values)
	    || hasOwn$3(DOMIterables$1, classof$1(it)) ? method$2 : own;
	};

	var values = values$1;

	var _valuesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(values);

	var entryVirtual$1 = entryVirtual$l;

	var entries$3 = entryVirtual$1('Array').entries;

	var parent$f = entries$3;

	var entries$2 = parent$f;

	var classof = classof$f;
	var hasOwn$2 = hasOwnProperty_1;
	var isPrototypeOf$1 = objectIsPrototypeOf;
	var method$1 = entries$2;

	var ArrayPrototype$1 = Array.prototype;

	var DOMIterables = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var entries$1 = function (it) {
	  var own = it.entries;
	  return it === ArrayPrototype$1 || (isPrototypeOf$1(ArrayPrototype$1, it) && own === ArrayPrototype$1.entries)
	    || hasOwn$2(DOMIterables, classof(it)) ? method$1 : own;
	};

	var entries = entries$1;

	var _entriesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(entries);

	var defineProperty = defineProperty$9;

	var _Object$defineProperty = /*@__PURE__*/getDefaultExportFromCjs(defineProperty);

	var $$8 = _export;
	var getBuiltIn = getBuiltIn$f;
	var apply = functionApply;
	var bind = functionBind;
	var aConstructor = aConstructor$2;
	var anObject$2 = anObject$f;
	var isObject$3 = isObject$m;
	var create = objectCreate;
	var fails$4 = fails$A;

	var nativeConstruct = getBuiltIn('Reflect', 'construct');
	var ObjectPrototype = Object.prototype;
	var push = [].push;

	// `Reflect.construct` method
	// https://tc39.es/ecma262/#sec-reflect.construct
	// MS Edge supports only 2 arguments and argumentsList argument is optional
	// FF Nightly sets third argument as `new.target`, but does not create `this` from it
	var NEW_TARGET_BUG = fails$4(function () {
	  function F() { /* empty */ }
	  return !(nativeConstruct(function () { /* empty */ }, [], F) instanceof F);
	});

	var ARGS_BUG = !fails$4(function () {
	  nativeConstruct(function () { /* empty */ });
	});

	var FORCED$3 = NEW_TARGET_BUG || ARGS_BUG;

	$$8({ target: 'Reflect', stat: true, forced: FORCED$3, sham: FORCED$3 }, {
	  construct: function construct(Target, args /* , newTarget */) {
	    aConstructor(Target);
	    anObject$2(args);
	    var newTarget = arguments.length < 3 ? Target : aConstructor(arguments[2]);
	    if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);
	    if (Target === newTarget) {
	      // w/o altered newTarget, optimization for 0-4 arguments
	      switch (args.length) {
	        case 0: return new Target();
	        case 1: return new Target(args[0]);
	        case 2: return new Target(args[0], args[1]);
	        case 3: return new Target(args[0], args[1], args[2]);
	        case 4: return new Target(args[0], args[1], args[2], args[3]);
	      }
	      // w/o altered newTarget, lot of arguments case
	      var $args = [null];
	      apply(push, $args, args);
	      return new (apply(bind, Target, $args))();
	    }
	    // with altered newTarget, not support built-in constructors
	    var proto = newTarget.prototype;
	    var instance = create(isObject$3(proto) ? proto : ObjectPrototype);
	    var result = apply(Target, instance, args);
	    return isObject$3(result) ? result : instance;
	  }
	});

	var path$a = path$A;

	var construct$2 = path$a.Reflect.construct;

	var parent$e = construct$2;

	var construct$1 = parent$e;

	var construct = construct$1;

	var _Reflect$construct = /*@__PURE__*/getDefaultExportFromCjs(construct);

	var path$9 = path$A;

	var getOwnPropertySymbols$2 = path$9.Object.getOwnPropertySymbols;

	var parent$d = getOwnPropertySymbols$2;

	var getOwnPropertySymbols$1 = parent$d;

	var getOwnPropertySymbols = getOwnPropertySymbols$1;

	var _Object$getOwnPropertySymbols = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertySymbols);

	var getOwnPropertyDescriptor$6 = {exports: {}};

	var $$7 = _export;
	var fails$3 = fails$A;
	var toIndexedObject$1 = toIndexedObject$b;
	var nativeGetOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
	var DESCRIPTORS$2 = descriptors;

	var FORCED$2 = !DESCRIPTORS$2 || fails$3(function () { nativeGetOwnPropertyDescriptor(1); });

	// `Object.getOwnPropertyDescriptor` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
	$$7({ target: 'Object', stat: true, forced: FORCED$2, sham: !DESCRIPTORS$2 }, {
	  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
	    return nativeGetOwnPropertyDescriptor(toIndexedObject$1(it), key);
	  }
	});

	var path$8 = path$A;

	var Object$3 = path$8.Object;

	var getOwnPropertyDescriptor$5 = getOwnPropertyDescriptor$6.exports = function getOwnPropertyDescriptor(it, key) {
	  return Object$3.getOwnPropertyDescriptor(it, key);
	};

	if (Object$3.getOwnPropertyDescriptor.sham) getOwnPropertyDescriptor$5.sham = true;

	var getOwnPropertyDescriptorExports = getOwnPropertyDescriptor$6.exports;

	var parent$c = getOwnPropertyDescriptorExports;

	var getOwnPropertyDescriptor$4 = parent$c;

	var getOwnPropertyDescriptor$3 = getOwnPropertyDescriptor$4;

	var _Object$getOwnPropertyDescriptor$1 = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptor$3);

	var $$6 = _export;
	var DESCRIPTORS$1 = descriptors;
	var ownKeys$5 = ownKeys$b;
	var toIndexedObject = toIndexedObject$b;
	var getOwnPropertyDescriptorModule$1 = objectGetOwnPropertyDescriptor;
	var createProperty = createProperty$6;

	// `Object.getOwnPropertyDescriptors` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
	$$6({ target: 'Object', stat: true, sham: !DESCRIPTORS$1 }, {
	  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
	    var O = toIndexedObject(object);
	    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule$1.f;
	    var keys = ownKeys$5(O);
	    var result = {};
	    var index = 0;
	    var key, descriptor;
	    while (keys.length > index) {
	      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
	      if (descriptor !== undefined) createProperty(result, key, descriptor);
	    }
	    return result;
	  }
	});

	var path$7 = path$A;

	var getOwnPropertyDescriptors$2 = path$7.Object.getOwnPropertyDescriptors;

	var parent$b = getOwnPropertyDescriptors$2;

	var getOwnPropertyDescriptors$1 = parent$b;

	var getOwnPropertyDescriptors = getOwnPropertyDescriptors$1;

	var _Object$getOwnPropertyDescriptors = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptors);

	var defineProperties$4 = {exports: {}};

	var $$5 = _export;
	var DESCRIPTORS = descriptors;
	var defineProperties$3 = objectDefineProperties.f;

	// `Object.defineProperties` method
	// https://tc39.es/ecma262/#sec-object.defineproperties
	// eslint-disable-next-line es/no-object-defineproperties -- safe
	$$5({ target: 'Object', stat: true, forced: Object.defineProperties !== defineProperties$3, sham: !DESCRIPTORS }, {
	  defineProperties: defineProperties$3
	});

	var path$6 = path$A;

	var Object$2 = path$6.Object;

	var defineProperties$2 = defineProperties$4.exports = function defineProperties(T, D) {
	  return Object$2.defineProperties(T, D);
	};

	if (Object$2.defineProperties.sham) defineProperties$2.sham = true;

	var definePropertiesExports = defineProperties$4.exports;

	var parent$a = definePropertiesExports;

	var defineProperties$1 = parent$a;

	var defineProperties = defineProperties$1;

	var _Object$defineProperties = /*@__PURE__*/getDefaultExportFromCjs(defineProperties);

	// Unique ID creation requires a high quality random # generator. In the browser we therefore
	// require the crypto API and do not support built-in fallback to lower quality random number
	// generators (like Math.random()).
	let getRandomValues;
	const rnds8 = new Uint8Array(16);
	function rng() {
	  // lazy load so that environments that need to polyfill have a chance to do so
	  if (!getRandomValues) {
	    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
	    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto);

	    if (!getRandomValues) {
	      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
	    }
	  }

	  return getRandomValues(rnds8);
	}

	/**
	 * Convert array of 16 byte values to UUID string format of the form:
	 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
	 */

	const byteToHex = [];

	for (let i = 0; i < 256; ++i) {
	  byteToHex.push((i + 0x100).toString(16).slice(1));
	}

	function unsafeStringify(arr, offset = 0) {
	  // Note: Be careful editing this code!  It's been tuned for performance
	  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
	  return byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]];
	}

	const randomUUID = typeof crypto !== 'undefined' && crypto.randomUUID && crypto.randomUUID.bind(crypto);
	var native = {
	  randomUUID
	};

	function v4(options, buf, offset) {
	  if (native.randomUUID && !buf && !options) {
	    return native.randomUUID();
	  }

	  options = options || {};
	  const rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

	  rnds[6] = rnds[6] & 0x0f | 0x40;
	  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

	  if (buf) {
	    offset = offset || 0;

	    for (let i = 0; i < 16; ++i) {
	      buf[offset + i] = rnds[i];
	    }

	    return buf;
	  }

	  return unsafeStringify(rnds);
	}

	var _Symbol$iterator;
	function ownKeys$4(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols) { var o = _Object$getOwnPropertySymbols(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor$1(e, r).enumerable; })), t.push.apply(t, o); } return t; }
	function _objectSpread$4(e) { for (var r = 1; r < arguments.length; r++) { var _context32, _context33; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context32 = ownKeys$4(Object(t), !0)).call(_context32, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context33 = ownKeys$4(Object(t))).call(_context33, function (r) { _Object$defineProperty(e, r, _Object$getOwnPropertyDescriptor$1(t, r)); }); } return e; }
	function _createSuper$t(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$t(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$t() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	function _createForOfIteratorHelper$6(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray(o) || (it = _unsupportedIterableToArray$6(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray$6(o, minLen) { var _context31; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$6(o, minLen); var n = _sliceInstanceProperty(_context31 = Object.prototype.toString.call(o)).call(_context31, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$6(o, minLen); }
	function _arrayLikeToArray$6(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

	/**
	 * Create new data pipe.
	 *
	 * @param from - The source data set or data view.
	 * @remarks
	 * Example usage:
	 * ```typescript
	 * interface AppItem {
	 *   whoami: string;
	 *   appData: unknown;
	 *   visData: VisItem;
	 * }
	 * interface VisItem {
	 *   id: number;
	 *   label: string;
	 *   color: string;
	 *   x: number;
	 *   y: number;
	 * }
	 *
	 * const ds1 = new DataSet<AppItem, "whoami">([], { fieldId: "whoami" });
	 * const ds2 = new DataSet<VisItem, "id">();
	 *
	 * const pipe = createNewDataPipeFrom(ds1)
	 *   .filter((item): boolean => item.enabled === true)
	 *   .map<VisItem, "id">((item): VisItem => item.visData)
	 *   .to(ds2);
	 *
	 * pipe.start();
	 * ```
	 * @returns A factory whose methods can be used to configure the pipe.
	 */
	function createNewDataPipeFrom(from) {
	  return new DataPipeUnderConstruction(from);
	}
	/**
	 * Internal implementation of the pipe. This should be accessible only through
	 * `createNewDataPipeFrom` from the outside.
	 *
	 * @typeParam SI - Source item type.
	 * @typeParam SP - Source item type's id property name.
	 * @typeParam TI - Target item type.
	 * @typeParam TP - Target item type's id property name.
	 */
	var SimpleDataPipe = /*#__PURE__*/function () {
	  /**
	   * Create a new data pipe.
	   *
	   * @param _source - The data set or data view that will be observed.
	   * @param _transformers - An array of transforming functions to be used to
	   * filter or transform the items in the pipe.
	   * @param _target - The data set or data view that will receive the items.
	   */
	  function SimpleDataPipe(_source, _transformers, _target) {
	    var _context, _context2, _context3;
	    _classCallCheck(this, SimpleDataPipe);
	    _defineProperty(this, "_source", void 0);
	    _defineProperty(this, "_transformers", void 0);
	    _defineProperty(this, "_target", void 0);
	    /**
	     * Bound listeners for use with `DataInterface['on' | 'off']`.
	     */
	    _defineProperty(this, "_listeners", {
	      add: _bindInstanceProperty$1(_context = this._add).call(_context, this),
	      remove: _bindInstanceProperty$1(_context2 = this._remove).call(_context2, this),
	      update: _bindInstanceProperty$1(_context3 = this._update).call(_context3, this)
	    });
	    this._source = _source;
	    this._transformers = _transformers;
	    this._target = _target;
	  }
	  /** @inheritDoc */
	  _createClass(SimpleDataPipe, [{
	    key: "all",
	    value: function all() {
	      this._target.update(this._transformItems(this._source.get()));
	      return this;
	    }
	    /** @inheritDoc */
	  }, {
	    key: "start",
	    value: function start() {
	      this._source.on("add", this._listeners.add);
	      this._source.on("remove", this._listeners.remove);
	      this._source.on("update", this._listeners.update);
	      return this;
	    }
	    /** @inheritDoc */
	  }, {
	    key: "stop",
	    value: function stop() {
	      this._source.off("add", this._listeners.add);
	      this._source.off("remove", this._listeners.remove);
	      this._source.off("update", this._listeners.update);
	      return this;
	    }
	    /**
	     * Apply the transformers to the items.
	     *
	     * @param items - The items to be transformed.
	     * @returns The transformed items.
	     */
	  }, {
	    key: "_transformItems",
	    value: function _transformItems(items) {
	      var _context4;
	      return _reduceInstanceProperty(_context4 = this._transformers).call(_context4, function (items, transform) {
	        return transform(items);
	      }, items);
	    }
	    /**
	     * Handle an add event.
	     *
	     * @param _name - Ignored.
	     * @param payload - The payload containing the ids of the added items.
	     */
	  }, {
	    key: "_add",
	    value: function _add(_name, payload) {
	      if (payload == null) {
	        return;
	      }
	      this._target.add(this._transformItems(this._source.get(payload.items)));
	    }
	    /**
	     * Handle an update event.
	     *
	     * @param _name - Ignored.
	     * @param payload - The payload containing the ids of the updated items.
	     */
	  }, {
	    key: "_update",
	    value: function _update(_name, payload) {
	      if (payload == null) {
	        return;
	      }
	      this._target.update(this._transformItems(this._source.get(payload.items)));
	    }
	    /**
	     * Handle a remove event.
	     *
	     * @param _name - Ignored.
	     * @param payload - The payload containing the data of the removed items.
	     */
	  }, {
	    key: "_remove",
	    value: function _remove(_name, payload) {
	      if (payload == null) {
	        return;
	      }
	      this._target.remove(this._transformItems(payload.oldData));
	    }
	  }]);
	  return SimpleDataPipe;
	}();
	/**
	 * Internal implementation of the pipe factory. This should be accessible
	 * only through `createNewDataPipeFrom` from the outside.
	 *
	 * @typeParam TI - Target item type.
	 * @typeParam TP - Target item type's id property name.
	 */
	var DataPipeUnderConstruction = /*#__PURE__*/function () {
	  /**
	   * Create a new data pipe factory. This is an internal constructor that
	   * should never be called from outside of this file.
	   *
	   * @param _source - The source data set or data view for this pipe.
	   */
	  function DataPipeUnderConstruction(_source) {
	    _classCallCheck(this, DataPipeUnderConstruction);
	    _defineProperty(this, "_source", void 0);
	    /**
	     * Array transformers used to transform items within the pipe. This is typed
	     * as any for the sake of simplicity.
	     */
	    _defineProperty(this, "_transformers", []);
	    this._source = _source;
	  }
	  /**
	   * Filter the items.
	   *
	   * @param callback - A filtering function that returns true if given item
	   * should be piped and false if not.
	   * @returns This factory for further configuration.
	   */
	  _createClass(DataPipeUnderConstruction, [{
	    key: "filter",
	    value: function filter(callback) {
	      this._transformers.push(function (input) {
	        return _filterInstanceProperty(input).call(input, callback);
	      });
	      return this;
	    }
	    /**
	     * Map each source item to a new type.
	     *
	     * @param callback - A mapping function that takes a source item and returns
	     * corresponding mapped item.
	     * @typeParam TI - Target item type.
	     * @typeParam TP - Target item type's id property name.
	     * @returns This factory for further configuration.
	     */
	  }, {
	    key: "map",
	    value: function map(callback) {
	      this._transformers.push(function (input) {
	        return _mapInstanceProperty(input).call(input, callback);
	      });
	      return this;
	    }
	    /**
	     * Map each source item to zero or more items of a new type.
	     *
	     * @param callback - A mapping function that takes a source item and returns
	     * an array of corresponding mapped items.
	     * @typeParam TI - Target item type.
	     * @typeParam TP - Target item type's id property name.
	     * @returns This factory for further configuration.
	     */
	  }, {
	    key: "flatMap",
	    value: function flatMap(callback) {
	      this._transformers.push(function (input) {
	        return _flatMapInstanceProperty(input).call(input, callback);
	      });
	      return this;
	    }
	    /**
	     * Connect this pipe to given data set.
	     *
	     * @param target - The data set that will receive the items from this pipe.
	     * @returns The pipe connected between given data sets and performing
	     * configured transformation on the processed items.
	     */
	  }, {
	    key: "to",
	    value: function to(target) {
	      return new SimpleDataPipe(this._source, this._transformers, target);
	    }
	  }]);
	  return DataPipeUnderConstruction;
	}();
	/**
	 * Determine whether a value can be used as an id.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if the value is valid id, false otherwise.
	 */
	function isId(value) {
	  return typeof value === "string" || typeof value === "number";
	}

	/**
	 * A queue.
	 *
	 * @typeParam T - The type of method names to be replaced by queued versions.
	 */
	var Queue = /*#__PURE__*/function () {
	  /**
	   * Construct a new Queue.
	   *
	   * @param options - Queue configuration.
	   */
	  function Queue(options) {
	    _classCallCheck(this, Queue);
	    /** Delay in milliseconds. If defined the queue will be periodically flushed. */
	    _defineProperty(this, "delay", void 0);
	    /** Maximum number of entries in the queue before it will be flushed. */
	    _defineProperty(this, "max", void 0);
	    _defineProperty(this, "_queue", []);
	    _defineProperty(this, "_timeout", null);
	    _defineProperty(this, "_extended", null);
	    // options
	    this.delay = null;
	    this.max = Infinity;
	    this.setOptions(options);
	  }
	  /**
	   * Update the configuration of the queue.
	   *
	   * @param options - Queue configuration.
	   */
	  _createClass(Queue, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options && typeof options.delay !== "undefined") {
	        this.delay = options.delay;
	      }
	      if (options && typeof options.max !== "undefined") {
	        this.max = options.max;
	      }
	      this._flushIfNeeded();
	    }
	    /**
	     * Extend an object with queuing functionality.
	     * The object will be extended with a function flush, and the methods provided in options.replace will be replaced with queued ones.
	     *
	     * @param object - The object to be extended.
	     * @param options - Additional options.
	     * @returns The created queue.
	     */
	  }, {
	    key: "destroy",
	    value:
	    /**
	     * Destroy the queue. The queue will first flush all queued actions, and in case it has extended an object, will restore the original object.
	     */
	    function destroy() {
	      this.flush();
	      if (this._extended) {
	        var object = this._extended.object;
	        var methods = this._extended.methods;
	        for (var i = 0; i < methods.length; i++) {
	          var method = methods[i];
	          if (method.original) {
	            // @TODO: better solution?
	            object[method.name] = method.original;
	          } else {
	            // @TODO: better solution?
	            delete object[method.name];
	          }
	        }
	        this._extended = null;
	      }
	    }
	    /**
	     * Replace a method on an object with a queued version.
	     *
	     * @param object - Object having the method.
	     * @param method - The method name.
	     */
	  }, {
	    key: "replace",
	    value: function replace(object, method) {
	      /* eslint-disable-next-line @typescript-eslint/no-this-alias -- Function this is necessary in the function bellow, so class this has to be saved into a variable here. */
	      var me = this;
	      var original = object[method];
	      if (!original) {
	        throw new Error("Method " + method + " undefined");
	      }
	      object[method] = function () {
	        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	          args[_key] = arguments[_key];
	        }
	        // add this call to the queue
	        me.queue({
	          args: args,
	          fn: original,
	          context: this
	        });
	      };
	    }
	    /**
	     * Queue a call.
	     *
	     * @param entry - The function or entry to be queued.
	     */
	  }, {
	    key: "queue",
	    value: function queue(entry) {
	      if (typeof entry === "function") {
	        this._queue.push({
	          fn: entry
	        });
	      } else {
	        this._queue.push(entry);
	      }
	      this._flushIfNeeded();
	    }
	    /**
	     * Check whether the queue needs to be flushed.
	     */
	  }, {
	    key: "_flushIfNeeded",
	    value: function _flushIfNeeded() {
	      var _this = this;
	      // flush when the maximum is exceeded.
	      if (this._queue.length > this.max) {
	        this.flush();
	      }
	      // flush after a period of inactivity when a delay is configured
	      if (this._timeout != null) {
	        clearTimeout(this._timeout);
	        this._timeout = null;
	      }
	      if (this.queue.length > 0 && typeof this.delay === "number") {
	        this._timeout = _setTimeout(function () {
	          _this.flush();
	        }, this.delay);
	      }
	    }
	    /**
	     * Flush all queued calls
	     */
	  }, {
	    key: "flush",
	    value: function flush() {
	      var _context5, _context6;
	      _forEachInstanceProperty(_context5 = _spliceInstanceProperty(_context6 = this._queue).call(_context6, 0)).call(_context5, function (entry) {
	        entry.fn.apply(entry.context || entry.fn, entry.args || []);
	      });
	    }
	  }], [{
	    key: "extend",
	    value: function extend(object, options) {
	      var queue = new Queue(options);
	      if (object.flush !== undefined) {
	        throw new Error("Target object already has a property flush");
	      }
	      object.flush = function () {
	        queue.flush();
	      };
	      var methods = [{
	        name: "flush",
	        original: undefined
	      }];
	      if (options && options.replace) {
	        for (var i = 0; i < options.replace.length; i++) {
	          var name = options.replace[i];
	          methods.push({
	            name: name,
	            // @TODO: better solution?
	            original: object[name]
	          });
	          // @TODO: better solution?
	          queue.replace(object, name);
	        }
	      }
	      queue._extended = {
	        object: object,
	        methods: methods
	      };
	      return queue;
	    }
	  }]);
	  return Queue;
	}();
	/**
	 * {@link DataSet} code that can be reused in {@link DataView} or other similar implementations of {@link DataInterface}.
	 *
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 */
	var DataSetPart = /*#__PURE__*/function () {
	  function DataSetPart() {
	    _classCallCheck(this, DataSetPart);
	    _defineProperty(this, "_subscribers", {
	      "*": [],
	      add: [],
	      remove: [],
	      update: []
	    });
	    /**
	     * @deprecated Use on instead (PS: DataView.subscribe === DataView.on).
	     */
	    _defineProperty(this, "subscribe", DataSetPart.prototype.on);
	    /**
	     * @deprecated Use off instead (PS: DataView.unsubscribe === DataView.off).
	     */
	    _defineProperty(this, "unsubscribe", DataSetPart.prototype.off);
	  }
	  _createClass(DataSetPart, [{
	    key: "_trigger",
	    value:
	    /**
	     * Trigger an event
	     *
	     * @param event - Event name.
	     * @param payload - Event payload.
	     * @param senderId - Id of the sender.
	     */
	    function _trigger(event, payload, senderId) {
	      var _context7, _context8;
	      if (event === "*") {
	        throw new Error("Cannot trigger event *");
	      }
	      _forEachInstanceProperty(_context7 = _concatInstanceProperty(_context8 = []).call(_context8, _toConsumableArray(this._subscribers[event]), _toConsumableArray(this._subscribers["*"]))).call(_context7, function (subscriber) {
	        subscriber(event, payload, senderId != null ? senderId : null);
	      });
	    }
	    /**
	     * Subscribe to an event, add an event listener.
	     *
	     * @remarks Non-function callbacks are ignored.
	     * @param event - Event name.
	     * @param callback - Callback method.
	     */
	  }, {
	    key: "on",
	    value: function on(event, callback) {
	      if (typeof callback === "function") {
	        this._subscribers[event].push(callback);
	      }
	      // @TODO: Maybe throw for invalid callbacks?
	    }
	    /**
	     * Unsubscribe from an event, remove an event listener.
	     *
	     * @remarks If the same callback was subscribed more than once **all** occurences will be removed.
	     * @param event - Event name.
	     * @param callback - Callback method.
	     */
	  }, {
	    key: "off",
	    value: function off(event, callback) {
	      var _context9;
	      this._subscribers[event] = _filterInstanceProperty(_context9 = this._subscribers[event]).call(_context9, function (subscriber) {
	        return subscriber !== callback;
	      });
	    }
	  }]);
	  return DataSetPart;
	}();
	/**
	 * Data stream
	 *
	 * @remarks
	 * {@link DataStream} offers an always up to date stream of items from a {@link DataSet} or {@link DataView}.
	 * That means that the stream is evaluated at the time of iteration, conversion to another data type or when {@link cache} is called, not when the {@link DataStream} was created.
	 * Multiple invocations of for example {@link toItemArray} may yield different results (if the data source like for example {@link DataSet} gets modified).
	 * @typeParam Item - The item type this stream is going to work with.
	 */
	_Symbol$iterator = _Symbol$iterator2;
	var DataStream = /*#__PURE__*/function () {
	  /**
	   * Create a new data stream.
	   *
	   * @param pairs - The id, item pairs.
	   */
	  function DataStream(pairs) {
	    _classCallCheck(this, DataStream);
	    _defineProperty(this, "_pairs", void 0);
	    this._pairs = pairs;
	  }
	  /**
	   * Return an iterable of key, value pairs for every entry in the stream.
	   */
	  _createClass(DataStream, [{
	    key: _Symbol$iterator,
	    value:
	    /*#__PURE__*/
	    _regeneratorRuntime.mark(function value() {
	      var _iterator, _step, _step$value, id, item;
	      return _regeneratorRuntime.wrap(function value$(_context10) {
	        while (1) switch (_context10.prev = _context10.next) {
	          case 0:
	            _iterator = _createForOfIteratorHelper$6(this._pairs);
	            _context10.prev = 1;
	            _iterator.s();
	          case 3:
	            if ((_step = _iterator.n()).done) {
	              _context10.next = 9;
	              break;
	            }
	            _step$value = _slicedToArray(_step.value, 2), id = _step$value[0], item = _step$value[1];
	            _context10.next = 7;
	            return [id, item];
	          case 7:
	            _context10.next = 3;
	            break;
	          case 9:
	            _context10.next = 14;
	            break;
	          case 11:
	            _context10.prev = 11;
	            _context10.t0 = _context10["catch"](1);
	            _iterator.e(_context10.t0);
	          case 14:
	            _context10.prev = 14;
	            _iterator.f();
	            return _context10.finish(14);
	          case 17:
	          case "end":
	            return _context10.stop();
	        }
	      }, value, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an iterable of key, value pairs for every entry in the stream.
	     */
	  }, {
	    key: "entries",
	    value:
	    /*#__PURE__*/
	    _regeneratorRuntime.mark(function entries() {
	      var _iterator2, _step2, _step2$value, id, item;
	      return _regeneratorRuntime.wrap(function entries$(_context11) {
	        while (1) switch (_context11.prev = _context11.next) {
	          case 0:
	            _iterator2 = _createForOfIteratorHelper$6(this._pairs);
	            _context11.prev = 1;
	            _iterator2.s();
	          case 3:
	            if ((_step2 = _iterator2.n()).done) {
	              _context11.next = 9;
	              break;
	            }
	            _step2$value = _slicedToArray(_step2.value, 2), id = _step2$value[0], item = _step2$value[1];
	            _context11.next = 7;
	            return [id, item];
	          case 7:
	            _context11.next = 3;
	            break;
	          case 9:
	            _context11.next = 14;
	            break;
	          case 11:
	            _context11.prev = 11;
	            _context11.t0 = _context11["catch"](1);
	            _iterator2.e(_context11.t0);
	          case 14:
	            _context11.prev = 14;
	            _iterator2.f();
	            return _context11.finish(14);
	          case 17:
	          case "end":
	            return _context11.stop();
	        }
	      }, entries, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an iterable of keys in the stream.
	     */
	  }, {
	    key: "keys",
	    value:
	    /*#__PURE__*/
	    _regeneratorRuntime.mark(function keys() {
	      var _iterator3, _step3, _step3$value, id;
	      return _regeneratorRuntime.wrap(function keys$(_context12) {
	        while (1) switch (_context12.prev = _context12.next) {
	          case 0:
	            _iterator3 = _createForOfIteratorHelper$6(this._pairs);
	            _context12.prev = 1;
	            _iterator3.s();
	          case 3:
	            if ((_step3 = _iterator3.n()).done) {
	              _context12.next = 9;
	              break;
	            }
	            _step3$value = _slicedToArray(_step3.value, 1), id = _step3$value[0];
	            _context12.next = 7;
	            return id;
	          case 7:
	            _context12.next = 3;
	            break;
	          case 9:
	            _context12.next = 14;
	            break;
	          case 11:
	            _context12.prev = 11;
	            _context12.t0 = _context12["catch"](1);
	            _iterator3.e(_context12.t0);
	          case 14:
	            _context12.prev = 14;
	            _iterator3.f();
	            return _context12.finish(14);
	          case 17:
	          case "end":
	            return _context12.stop();
	        }
	      }, keys, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an iterable of values in the stream.
	     */
	  }, {
	    key: "values",
	    value:
	    /*#__PURE__*/
	    _regeneratorRuntime.mark(function values() {
	      var _iterator4, _step4, _step4$value, item;
	      return _regeneratorRuntime.wrap(function values$(_context13) {
	        while (1) switch (_context13.prev = _context13.next) {
	          case 0:
	            _iterator4 = _createForOfIteratorHelper$6(this._pairs);
	            _context13.prev = 1;
	            _iterator4.s();
	          case 3:
	            if ((_step4 = _iterator4.n()).done) {
	              _context13.next = 9;
	              break;
	            }
	            _step4$value = _slicedToArray(_step4.value, 2), item = _step4$value[1];
	            _context13.next = 7;
	            return item;
	          case 7:
	            _context13.next = 3;
	            break;
	          case 9:
	            _context13.next = 14;
	            break;
	          case 11:
	            _context13.prev = 11;
	            _context13.t0 = _context13["catch"](1);
	            _iterator4.e(_context13.t0);
	          case 14:
	            _context13.prev = 14;
	            _iterator4.f();
	            return _context13.finish(14);
	          case 17:
	          case "end":
	            return _context13.stop();
	        }
	      }, values, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an array containing all the ids in this stream.
	     *
	     * @remarks
	     * The array may contain duplicities.
	     * @returns The array with all ids from this stream.
	     */
	  }, {
	    key: "toIdArray",
	    value: function toIdArray() {
	      var _context14;
	      return _mapInstanceProperty(_context14 = _toConsumableArray(this._pairs)).call(_context14, function (pair) {
	        return pair[0];
	      });
	    }
	    /**
	     * Return an array containing all the items in this stream.
	     *
	     * @remarks
	     * The array may contain duplicities.
	     * @returns The array with all items from this stream.
	     */
	  }, {
	    key: "toItemArray",
	    value: function toItemArray() {
	      var _context15;
	      return _mapInstanceProperty(_context15 = _toConsumableArray(this._pairs)).call(_context15, function (pair) {
	        return pair[1];
	      });
	    }
	    /**
	     * Return an array containing all the entries in this stream.
	     *
	     * @remarks
	     * The array may contain duplicities.
	     * @returns The array with all entries from this stream.
	     */
	  }, {
	    key: "toEntryArray",
	    value: function toEntryArray() {
	      return _toConsumableArray(this._pairs);
	    }
	    /**
	     * Return an object map containing all the items in this stream accessible by ids.
	     *
	     * @remarks
	     * In case of duplicate ids (coerced to string so `7 == '7'`) the last encoutered appears in the returned object.
	     * @returns The object map of all id → item pairs from this stream.
	     */
	  }, {
	    key: "toObjectMap",
	    value: function toObjectMap() {
	      var map = _Object$create$1(null);
	      var _iterator5 = _createForOfIteratorHelper$6(this._pairs),
	        _step5;
	      try {
	        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
	          var _step5$value = _slicedToArray(_step5.value, 2),
	            id = _step5$value[0],
	            item = _step5$value[1];
	          map[id] = item;
	        }
	      } catch (err) {
	        _iterator5.e(err);
	      } finally {
	        _iterator5.f();
	      }
	      return map;
	    }
	    /**
	     * Return a map containing all the items in this stream accessible by ids.
	     *
	     * @returns The map of all id → item pairs from this stream.
	     */
	  }, {
	    key: "toMap",
	    value: function toMap() {
	      return new _Map(this._pairs);
	    }
	    /**
	     * Return a set containing all the (unique) ids in this stream.
	     *
	     * @returns The set of all ids from this stream.
	     */
	  }, {
	    key: "toIdSet",
	    value: function toIdSet() {
	      return new _Set(this.toIdArray());
	    }
	    /**
	     * Return a set containing all the (unique) items in this stream.
	     *
	     * @returns The set of all items from this stream.
	     */
	  }, {
	    key: "toItemSet",
	    value: function toItemSet() {
	      return new _Set(this.toItemArray());
	    }
	    /**
	     * Cache the items from this stream.
	     *
	     * @remarks
	     * This method allows for items to be fetched immediatelly and used (possibly multiple times) later.
	     * It can also be used to optimize performance as {@link DataStream} would otherwise reevaluate everything upon each iteration.
	     *
	     * ## Example
	     * ```javascript
	     * const ds = new DataSet([…])
	     *
	     * const cachedStream = ds.stream()
	     *   .filter(…)
	     *   .sort(…)
	     *   .map(…)
	     *   .cached(…) // Data are fetched, processed and cached here.
	     *
	     * ds.clear()
	     * chachedStream // Still has all the items.
	     * ```
	     * @returns A new {@link DataStream} with cached items (detached from the original {@link DataSet}).
	     */
	  }, {
	    key: "cache",
	    value: function cache() {
	      return new DataStream(_toConsumableArray(this._pairs));
	    }
	    /**
	     * Get the distinct values of given property.
	     *
	     * @param callback - The function that picks and possibly converts the property.
	     * @typeParam T - The type of the distinct value.
	     * @returns A set of all distinct properties.
	     */
	  }, {
	    key: "distinct",
	    value: function distinct(callback) {
	      var set = new _Set();
	      var _iterator6 = _createForOfIteratorHelper$6(this._pairs),
	        _step6;
	      try {
	        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
	          var _step6$value = _slicedToArray(_step6.value, 2),
	            id = _step6$value[0],
	            item = _step6$value[1];
	          set.add(callback(item, id));
	        }
	      } catch (err) {
	        _iterator6.e(err);
	      } finally {
	        _iterator6.f();
	      }
	      return set;
	    }
	    /**
	     * Filter the items of the stream.
	     *
	     * @param callback - The function that decides whether an item will be included.
	     * @returns A new data stream with the filtered items.
	     */
	  }, {
	    key: "filter",
	    value: function filter(callback) {
	      var pairs = this._pairs;
	      return new DataStream(_defineProperty({}, _Symbol$iterator2, /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
	        var _iterator7, _step7, _step7$value, id, item;
	        return _regeneratorRuntime.wrap(function _callee$(_context16) {
	          while (1) switch (_context16.prev = _context16.next) {
	            case 0:
	              _iterator7 = _createForOfIteratorHelper$6(pairs);
	              _context16.prev = 1;
	              _iterator7.s();
	            case 3:
	              if ((_step7 = _iterator7.n()).done) {
	                _context16.next = 10;
	                break;
	              }
	              _step7$value = _slicedToArray(_step7.value, 2), id = _step7$value[0], item = _step7$value[1];
	              if (!callback(item, id)) {
	                _context16.next = 8;
	                break;
	              }
	              _context16.next = 8;
	              return [id, item];
	            case 8:
	              _context16.next = 3;
	              break;
	            case 10:
	              _context16.next = 15;
	              break;
	            case 12:
	              _context16.prev = 12;
	              _context16.t0 = _context16["catch"](1);
	              _iterator7.e(_context16.t0);
	            case 15:
	              _context16.prev = 15;
	              _iterator7.f();
	              return _context16.finish(15);
	            case 18:
	            case "end":
	              return _context16.stop();
	          }
	        }, _callee, null, [[1, 12, 15, 18]]);
	      })));
	    }
	    /**
	     * Execute a callback for each item of the stream.
	     *
	     * @param callback - The function that will be invoked for each item.
	     */
	  }, {
	    key: "forEach",
	    value: function forEach(callback) {
	      var _iterator8 = _createForOfIteratorHelper$6(this._pairs),
	        _step8;
	      try {
	        for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
	          var _step8$value = _slicedToArray(_step8.value, 2),
	            id = _step8$value[0],
	            item = _step8$value[1];
	          callback(item, id);
	        }
	      } catch (err) {
	        _iterator8.e(err);
	      } finally {
	        _iterator8.f();
	      }
	    }
	    /**
	     * Map the items into a different type.
	     *
	     * @param callback - The function that does the conversion.
	     * @typeParam Mapped - The type of the item after mapping.
	     * @returns A new data stream with the mapped items.
	     */
	  }, {
	    key: "map",
	    value: function map(callback) {
	      var pairs = this._pairs;
	      return new DataStream(_defineProperty({}, _Symbol$iterator2, /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
	        var _iterator9, _step9, _step9$value, id, item;
	        return _regeneratorRuntime.wrap(function _callee2$(_context17) {
	          while (1) switch (_context17.prev = _context17.next) {
	            case 0:
	              _iterator9 = _createForOfIteratorHelper$6(pairs);
	              _context17.prev = 1;
	              _iterator9.s();
	            case 3:
	              if ((_step9 = _iterator9.n()).done) {
	                _context17.next = 9;
	                break;
	              }
	              _step9$value = _slicedToArray(_step9.value, 2), id = _step9$value[0], item = _step9$value[1];
	              _context17.next = 7;
	              return [id, callback(item, id)];
	            case 7:
	              _context17.next = 3;
	              break;
	            case 9:
	              _context17.next = 14;
	              break;
	            case 11:
	              _context17.prev = 11;
	              _context17.t0 = _context17["catch"](1);
	              _iterator9.e(_context17.t0);
	            case 14:
	              _context17.prev = 14;
	              _iterator9.f();
	              return _context17.finish(14);
	            case 17:
	            case "end":
	              return _context17.stop();
	          }
	        }, _callee2, null, [[1, 11, 14, 17]]);
	      })));
	    }
	    /**
	     * Get the item with the maximum value of given property.
	     *
	     * @param callback - The function that picks and possibly converts the property.
	     * @returns The item with the maximum if found otherwise null.
	     */
	  }, {
	    key: "max",
	    value: function max(callback) {
	      var iter = _getIterator(this._pairs);
	      var curr = iter.next();
	      if (curr.done) {
	        return null;
	      }
	      var maxItem = curr.value[1];
	      var maxValue = callback(curr.value[1], curr.value[0]);
	      while (!(curr = iter.next()).done) {
	        var _curr$value = _slicedToArray(curr.value, 2),
	          id = _curr$value[0],
	          item = _curr$value[1];
	        var _value = callback(item, id);
	        if (_value > maxValue) {
	          maxValue = _value;
	          maxItem = item;
	        }
	      }
	      return maxItem;
	    }
	    /**
	     * Get the item with the minimum value of given property.
	     *
	     * @param callback - The function that picks and possibly converts the property.
	     * @returns The item with the minimum if found otherwise null.
	     */
	  }, {
	    key: "min",
	    value: function min(callback) {
	      var iter = _getIterator(this._pairs);
	      var curr = iter.next();
	      if (curr.done) {
	        return null;
	      }
	      var minItem = curr.value[1];
	      var minValue = callback(curr.value[1], curr.value[0]);
	      while (!(curr = iter.next()).done) {
	        var _curr$value2 = _slicedToArray(curr.value, 2),
	          id = _curr$value2[0],
	          item = _curr$value2[1];
	        var _value2 = callback(item, id);
	        if (_value2 < minValue) {
	          minValue = _value2;
	          minItem = item;
	        }
	      }
	      return minItem;
	    }
	    /**
	     * Reduce the items into a single value.
	     *
	     * @param callback - The function that does the reduction.
	     * @param accumulator - The initial value of the accumulator.
	     * @typeParam T - The type of the accumulated value.
	     * @returns The reduced value.
	     */
	  }, {
	    key: "reduce",
	    value: function reduce(callback, accumulator) {
	      var _iterator10 = _createForOfIteratorHelper$6(this._pairs),
	        _step10;
	      try {
	        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
	          var _step10$value = _slicedToArray(_step10.value, 2),
	            id = _step10$value[0],
	            item = _step10$value[1];
	          accumulator = callback(accumulator, item, id);
	        }
	      } catch (err) {
	        _iterator10.e(err);
	      } finally {
	        _iterator10.f();
	      }
	      return accumulator;
	    }
	    /**
	     * Sort the items.
	     *
	     * @param callback - Item comparator.
	     * @returns A new stream with sorted items.
	     */
	  }, {
	    key: "sort",
	    value: function sort(callback) {
	      var _this2 = this;
	      return new DataStream(_defineProperty({}, _Symbol$iterator2, function () {
	        var _context18;
	        return _getIterator(_sortInstanceProperty(_context18 = _toConsumableArray(_this2._pairs)).call(_context18, function (_ref, _ref2) {
	          var _ref3 = _slicedToArray(_ref, 2),
	            idA = _ref3[0],
	            itemA = _ref3[1];
	          var _ref4 = _slicedToArray(_ref2, 2),
	            idB = _ref4[0],
	            itemB = _ref4[1];
	          return callback(itemA, itemB, idA, idB);
	        }));
	      }));
	    }
	  }]);
	  return DataStream;
	}();
	/**
	 * Add an id to given item if it doesn't have one already.
	 *
	 * @remarks
	 * The item will be modified.
	 * @param item - The item that will have an id after a call to this function.
	 * @param idProp - The key of the id property.
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 * @returns true
	 */
	function ensureFullItem(item, idProp) {
	  if (item[idProp] == null) {
	    // generate an id
	    item[idProp] = v4();
	  }
	  return item;
	}
	/**
	 * # DataSet
	 *
	 * Vis.js comes with a flexible DataSet, which can be used to hold and
	 * manipulate unstructured data and listen for changes in the data. The DataSet
	 * is key/value based. Data items can be added, updated and removed from the
	 * DataSet, and one can subscribe to changes in the DataSet. The data in the
	 * DataSet can be filtered and ordered. Data can be normalized when appending it
	 * to the DataSet as well.
	 *
	 * ## Example
	 *
	 * The following example shows how to use a DataSet.
	 *
	 * ```javascript
	 * // create a DataSet
	 * var options = {};
	 * var data = new vis.DataSet(options);
	 *
	 * // add items
	 * // note that the data items can contain different properties and data formats
	 * data.add([
	 *   {id: 1, text: 'item 1', date: new Date(2013, 6, 20), group: 1, first: true},
	 *   {id: 2, text: 'item 2', date: '2013-06-23', group: 2},
	 *   {id: 3, text: 'item 3', date: '2013-06-25', group: 2},
	 *   {id: 4, text: 'item 4'}
	 * ]);
	 *
	 * // subscribe to any change in the DataSet
	 * data.on('*', function (event, properties, senderId) {
	 *   console.log('event', event, properties);
	 * });
	 *
	 * // update an existing item
	 * data.update({id: 2, group: 1});
	 *
	 * // remove an item
	 * data.remove(4);
	 *
	 * // get all ids
	 * var ids = data.getIds();
	 * console.log('ids', ids);
	 *
	 * // get a specific item
	 * var item1 = data.get(1);
	 * console.log('item1', item1);
	 *
	 * // retrieve a filtered subset of the data
	 * var items = data.get({
	 *   filter: function (item) {
	 *     return item.group == 1;
	 *   }
	 * });
	 * console.log('filtered items', items);
	 * ```
	 *
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 */
	var DataSet = /*#__PURE__*/function (_DataSetPart) {
	  _inherits(DataSet, _DataSetPart);
	  var _super = _createSuper$t(DataSet);
	  /**
	   * Construct a new DataSet.
	   *
	   * @param data - Initial data or options.
	   * @param options - Options (type error if data is also options).
	   */
	  function DataSet(data, options) {
	    var _this3;
	    _classCallCheck(this, DataSet);
	    _this3 = _super.call(this);
	    // correctly read optional arguments
	    /** Flush all queued calls. */
	    _defineProperty(_assertThisInitialized(_this3), "flush", void 0);
	    /** @inheritDoc */
	    _defineProperty(_assertThisInitialized(_this3), "length", void 0);
	    _defineProperty(_assertThisInitialized(_this3), "_options", void 0);
	    _defineProperty(_assertThisInitialized(_this3), "_data", void 0);
	    _defineProperty(_assertThisInitialized(_this3), "_idProp", void 0);
	    _defineProperty(_assertThisInitialized(_this3), "_queue", null);
	    if (data && !_Array$isArray(data)) {
	      options = data;
	      data = [];
	    }
	    _this3._options = options || {};
	    _this3._data = new _Map(); // map with data indexed by id
	    _this3.length = 0; // number of items in the DataSet
	    _this3._idProp = _this3._options.fieldId || "id"; // name of the field containing id
	    // add initial data when provided
	    if (data && data.length) {
	      _this3.add(data);
	    }
	    _this3.setOptions(options);
	    return _this3;
	  }
	  /**
	   * Set new options.
	   *
	   * @param options - The new options.
	   */
	  _createClass(DataSet, [{
	    key: "idProp",
	    get: /** @inheritDoc */
	    function get() {
	      return this._idProp;
	    }
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options && options.queue !== undefined) {
	        if (options.queue === false) {
	          // delete queue if loaded
	          if (this._queue) {
	            this._queue.destroy();
	            this._queue = null;
	          }
	        } else {
	          // create queue and update its options
	          if (!this._queue) {
	            this._queue = Queue.extend(this, {
	              replace: ["add", "update", "remove"]
	            });
	          }
	          if (options.queue && _typeof$1(options.queue) === "object") {
	            this._queue.setOptions(options.queue);
	          }
	        }
	      }
	    }
	    /**
	     * Add a data item or an array with items.
	     *
	     * After the items are added to the DataSet, the DataSet will trigger an event `add`. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     *
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet()
	     *
	     * // add items
	     * const ids = data.add([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { text: 'item without an id' }
	     * ])
	     *
	     * console.log(ids) // [1, 2, '<UUIDv4>']
	     * ```
	     *
	     * @param data - Items to be added (ids will be generated if missing).
	     * @param senderId - Sender id.
	     * @returns addedIds - Array with the ids (generated if not present) of the added items.
	     * @throws When an item with the same id as any of the added items already exists.
	     */
	  }, {
	    key: "add",
	    value: function add(data, senderId) {
	      var _this4 = this;
	      var addedIds = [];
	      var id;
	      if (_Array$isArray(data)) {
	        // Array
	        var idsToAdd = _mapInstanceProperty(data).call(data, function (d) {
	          return d[_this4._idProp];
	        });
	        if (_someInstanceProperty(idsToAdd).call(idsToAdd, function (id) {
	          return _this4._data.has(id);
	        })) {
	          throw new Error("A duplicate id was found in the parameter array.");
	        }
	        for (var i = 0, len = data.length; i < len; i++) {
	          id = this._addItem(data[i]);
	          addedIds.push(id);
	        }
	      } else if (data && _typeof$1(data) === "object") {
	        // Single item
	        id = this._addItem(data);
	        addedIds.push(id);
	      } else {
	        throw new Error("Unknown dataType");
	      }
	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        }, senderId);
	      }
	      return addedIds;
	    }
	    /**
	     * Update existing items. When an item does not exist, it will be created.
	     *
	     * @remarks
	     * The provided properties will be merged in the existing item. When an item does not exist, it will be created.
	     *
	     * After the items are updated, the DataSet will trigger an event `add` for the added items, and an event `update`. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     *
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { id: 3, text: 'item 3' }
	     * ])
	     *
	     * // update items
	     * const ids = data.update([
	     *   { id: 2, text: 'item 2 (updated)' },
	     *   { id: 4, text: 'item 4 (new)' }
	     * ])
	     *
	     * console.log(ids) // [2, 4]
	     * ```
	     *
	     * ## Warning for TypeScript users
	     * This method may introduce partial items into the data set. Use add or updateOnly instead for better type safety.
	     * @param data - Items to be updated (if the id is already present) or added (if the id is missing).
	     * @param senderId - Sender id.
	     * @returns updatedIds - The ids of the added (these may be newly generated if there was no id in the item from the data) or updated items.
	     * @throws When the supplied data is neither an item nor an array of items.
	     */
	  }, {
	    key: "update",
	    value: function update(data, senderId) {
	      var _this5 = this;
	      var addedIds = [];
	      var updatedIds = [];
	      var oldData = [];
	      var updatedData = [];
	      var idProp = this._idProp;
	      var addOrUpdate = function addOrUpdate(item) {
	        var origId = item[idProp];
	        if (origId != null && _this5._data.has(origId)) {
	          var fullItem = item; // it has an id, therefore it is a fullitem
	          var oldItem = _Object$assign({}, _this5._data.get(origId));
	          // update item
	          var id = _this5._updateItem(fullItem);
	          updatedIds.push(id);
	          updatedData.push(fullItem);
	          oldData.push(oldItem);
	        } else {
	          // add new item
	          var _id = _this5._addItem(item);
	          addedIds.push(_id);
	        }
	      };
	      if (_Array$isArray(data)) {
	        // Array
	        for (var i = 0, len = data.length; i < len; i++) {
	          if (data[i] && _typeof$1(data[i]) === "object") {
	            addOrUpdate(data[i]);
	          } else {
	            console.warn("Ignoring input item, which is not an object at index " + i);
	          }
	        }
	      } else if (data && _typeof$1(data) === "object") {
	        // Single item
	        addOrUpdate(data);
	      } else {
	        throw new Error("Unknown dataType");
	      }
	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        }, senderId);
	      }
	      if (updatedIds.length) {
	        var props = {
	          items: updatedIds,
	          oldData: oldData,
	          data: updatedData
	        };
	        // TODO: remove deprecated property 'data' some day
	        //Object.defineProperty(props, 'data', {
	        //  'get': (function() {
	        //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
	        //    return updatedData;
	        //  }).bind(this)
	        //});
	        this._trigger("update", props, senderId);
	      }
	      return _concatInstanceProperty(addedIds).call(addedIds, updatedIds);
	    }
	    /**
	     * Update existing items. When an item does not exist, an error will be thrown.
	     *
	     * @remarks
	     * The provided properties will be deeply merged into the existing item.
	     * When an item does not exist (id not present in the data set or absent), an error will be thrown and nothing will be changed.
	     *
	     * After the items are updated, the DataSet will trigger an event `update`.
	     * When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     *
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { id: 3, text: 'item 3' },
	     * ])
	     *
	     * // update items
	     * const ids = data.update([
	     *   { id: 2, text: 'item 2 (updated)' }, // works
	     *   // { id: 4, text: 'item 4 (new)' }, // would throw
	     *   // { text: 'item 4 (new)' }, // would also throw
	     * ])
	     *
	     * console.log(ids) // [2]
	     * ```
	     * @param data - Updates (the id and optionally other props) to the items in this data set.
	     * @param senderId - Sender id.
	     * @returns updatedIds - The ids of the updated items.
	     * @throws When the supplied data is neither an item nor an array of items, when the ids are missing.
	     */
	  }, {
	    key: "updateOnly",
	    value: function updateOnly(data, senderId) {
	      var _context19,
	        _this6 = this;
	      if (!_Array$isArray(data)) {
	        data = [data];
	      }
	      var updateEventData = _mapInstanceProperty(_context19 = _mapInstanceProperty(data).call(data, function (update) {
	        var oldData = _this6._data.get(update[_this6._idProp]);
	        if (oldData == null) {
	          throw new Error("Updating non-existent items is not allowed.");
	        }
	        return {
	          oldData: oldData,
	          update: update
	        };
	      })).call(_context19, function (_ref5) {
	        var oldData = _ref5.oldData,
	          update = _ref5.update;
	        var id = oldData[_this6._idProp];
	        var updatedData = pureDeepObjectAssign(oldData, update);
	        _this6._data.set(id, updatedData);
	        return {
	          id: id,
	          oldData: oldData,
	          updatedData: updatedData
	        };
	      });
	      if (updateEventData.length) {
	        var props = {
	          items: _mapInstanceProperty(updateEventData).call(updateEventData, function (value) {
	            return value.id;
	          }),
	          oldData: _mapInstanceProperty(updateEventData).call(updateEventData, function (value) {
	            return value.oldData;
	          }),
	          data: _mapInstanceProperty(updateEventData).call(updateEventData, function (value) {
	            return value.updatedData;
	          })
	        };
	        // TODO: remove deprecated property 'data' some day
	        //Object.defineProperty(props, 'data', {
	        //  'get': (function() {
	        //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
	        //    return updatedData;
	        //  }).bind(this)
	        //});
	        this._trigger("update", props, senderId);
	        return props.items;
	      } else {
	        return [];
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "get",
	    value: function get(first, second) {
	      // @TODO: Woudn't it be better to split this into multiple methods?
	      // parse the arguments
	      var id = undefined;
	      var ids = undefined;
	      var options = undefined;
	      if (isId(first)) {
	        // get(id [, options])
	        id = first;
	        options = second;
	      } else if (_Array$isArray(first)) {
	        // get(ids [, options])
	        ids = first;
	        options = second;
	      } else {
	        // get([, options])
	        options = first;
	      }
	      // determine the return type
	      var returnType = options && options.returnType === "Object" ? "Object" : "Array";
	      // @TODO: WTF is this? Or am I missing something?
	      // var returnType
	      // if (options && options.returnType) {
	      //   var allowedValues = ['Array', 'Object']
	      //   returnType =
	      //     allowedValues.indexOf(options.returnType) == -1
	      //       ? 'Array'
	      //       : options.returnType
	      // } else {
	      //   returnType = 'Array'
	      // }
	      // build options
	      var filter = options && _filterInstanceProperty(options);
	      var items = [];
	      var item = undefined;
	      var itemIds = undefined;
	      var itemId = undefined;
	      // convert items
	      if (id != null) {
	        // return a single item
	        item = this._data.get(id);
	        if (item && filter && !filter(item)) {
	          item = undefined;
	        }
	      } else if (ids != null) {
	        // return a subset of items
	        for (var i = 0, len = ids.length; i < len; i++) {
	          item = this._data.get(ids[i]);
	          if (item != null && (!filter || filter(item))) {
	            items.push(item);
	          }
	        }
	      } else {
	        var _context20;
	        // return all items
	        itemIds = _toConsumableArray(_keysInstanceProperty(_context20 = this._data).call(_context20));
	        for (var _i = 0, _len2 = itemIds.length; _i < _len2; _i++) {
	          itemId = itemIds[_i];
	          item = this._data.get(itemId);
	          if (item != null && (!filter || filter(item))) {
	            items.push(item);
	          }
	        }
	      }
	      // order the results
	      if (options && options.order && id == undefined) {
	        this._sort(items, options.order);
	      }
	      // filter fields of the items
	      if (options && options.fields) {
	        var fields = options.fields;
	        if (id != undefined && item != null) {
	          item = this._filterFields(item, fields);
	        } else {
	          for (var _i2 = 0, _len3 = items.length; _i2 < _len3; _i2++) {
	            items[_i2] = this._filterFields(items[_i2], fields);
	          }
	        }
	      }
	      // return the results
	      if (returnType == "Object") {
	        var result = {};
	        for (var _i3 = 0, _len4 = items.length; _i3 < _len4; _i3++) {
	          var resultant = items[_i3];
	          // @TODO: Shoudn't this be this._fieldId?
	          // result[resultant.id] = resultant
	          var _id2 = resultant[this._idProp];
	          result[_id2] = resultant;
	        }
	        return result;
	      } else {
	        if (id != null) {
	          var _item;
	          // a single item
	          return (_item = item) !== null && _item !== void 0 ? _item : null;
	        } else {
	          // just return our array
	          return items;
	        }
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getIds",
	    value: function getIds(options) {
	      var data = this._data;
	      var filter = options && _filterInstanceProperty(options);
	      var order = options && options.order;
	      var itemIds = _toConsumableArray(_keysInstanceProperty(data).call(data));
	      var ids = [];
	      if (filter) {
	        // get filtered items
	        if (order) {
	          // create ordered list
	          var items = [];
	          for (var i = 0, len = itemIds.length; i < len; i++) {
	            var id = itemIds[i];
	            var item = this._data.get(id);
	            if (item != null && filter(item)) {
	              items.push(item);
	            }
	          }
	          this._sort(items, order);
	          for (var _i4 = 0, _len5 = items.length; _i4 < _len5; _i4++) {
	            ids.push(items[_i4][this._idProp]);
	          }
	        } else {
	          // create unordered list
	          for (var _i5 = 0, _len6 = itemIds.length; _i5 < _len6; _i5++) {
	            var _id3 = itemIds[_i5];
	            var _item2 = this._data.get(_id3);
	            if (_item2 != null && filter(_item2)) {
	              ids.push(_item2[this._idProp]);
	            }
	          }
	        }
	      } else {
	        // get all items
	        if (order) {
	          // create an ordered list
	          var _items = [];
	          for (var _i6 = 0, _len7 = itemIds.length; _i6 < _len7; _i6++) {
	            var _id4 = itemIds[_i6];
	            _items.push(data.get(_id4));
	          }
	          this._sort(_items, order);
	          for (var _i7 = 0, _len8 = _items.length; _i7 < _len8; _i7++) {
	            ids.push(_items[_i7][this._idProp]);
	          }
	        } else {
	          // create unordered list
	          for (var _i8 = 0, _len9 = itemIds.length; _i8 < _len9; _i8++) {
	            var _id5 = itemIds[_i8];
	            var _item3 = data.get(_id5);
	            if (_item3 != null) {
	              ids.push(_item3[this._idProp]);
	            }
	          }
	        }
	      }
	      return ids;
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getDataSet",
	    value: function getDataSet() {
	      return this;
	    }
	    /** @inheritDoc */
	  }, {
	    key: "forEach",
	    value: function forEach(callback, options) {
	      var filter = options && _filterInstanceProperty(options);
	      var data = this._data;
	      var itemIds = _toConsumableArray(_keysInstanceProperty(data).call(data));
	      if (options && options.order) {
	        // execute forEach on ordered list
	        var items = this.get(options);
	        for (var i = 0, len = items.length; i < len; i++) {
	          var item = items[i];
	          var id = item[this._idProp];
	          callback(item, id);
	        }
	      } else {
	        // unordered
	        for (var _i9 = 0, _len10 = itemIds.length; _i9 < _len10; _i9++) {
	          var _id6 = itemIds[_i9];
	          var _item4 = this._data.get(_id6);
	          if (_item4 != null && (!filter || filter(_item4))) {
	            callback(_item4, _id6);
	          }
	        }
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "map",
	    value: function map(callback, options) {
	      var filter = options && _filterInstanceProperty(options);
	      var mappedItems = [];
	      var data = this._data;
	      var itemIds = _toConsumableArray(_keysInstanceProperty(data).call(data));
	      // convert and filter items
	      for (var i = 0, len = itemIds.length; i < len; i++) {
	        var id = itemIds[i];
	        var item = this._data.get(id);
	        if (item != null && (!filter || filter(item))) {
	          mappedItems.push(callback(item, id));
	        }
	      }
	      // order items
	      if (options && options.order) {
	        this._sort(mappedItems, options.order);
	      }
	      return mappedItems;
	    }
	    /**
	     * Filter the fields of an item.
	     *
	     * @param item - The item whose fields should be filtered.
	     * @param fields - The names of the fields that will be kept.
	     * @typeParam K - Field name type.
	     * @returns The item without any additional fields.
	     */
	  }, {
	    key: "_filterFields",
	    value: function _filterFields(item, fields) {
	      var _context21;
	      if (!item) {
	        // item is null
	        return item;
	      }
	      return _reduceInstanceProperty(_context21 = _Array$isArray(fields) ?
	      // Use the supplied array
	      fields :
	      // Use the keys of the supplied object
	      _Object$keys(fields)).call(_context21, function (filteredItem, field) {
	        filteredItem[field] = item[field];
	        return filteredItem;
	      }, {});
	    }
	    /**
	     * Sort the provided array with items.
	     *
	     * @param items - Items to be sorted in place.
	     * @param order - A field name or custom sort function.
	     * @typeParam T - The type of the items in the items array.
	     */
	  }, {
	    key: "_sort",
	    value: function _sort(items, order) {
	      if (typeof order === "string") {
	        // order by provided field name
	        var name = order; // field name
	        _sortInstanceProperty(items).call(items, function (a, b) {
	          // @TODO: How to treat missing properties?
	          var av = a[name];
	          var bv = b[name];
	          return av > bv ? 1 : av < bv ? -1 : 0;
	        });
	      } else if (typeof order === "function") {
	        // order by sort function
	        _sortInstanceProperty(items).call(items, order);
	      } else {
	        // TODO: extend order by an Object {field:string, direction:string}
	        //       where direction can be 'asc' or 'desc'
	        throw new TypeError("Order must be a function or a string");
	      }
	    }
	    /**
	     * Remove an item or multiple items by “reference” (only the id is used) or by id.
	     *
	     * The method ignores removal of non-existing items, and returns an array containing the ids of the items which are actually removed from the DataSet.
	     *
	     * After the items are removed, the DataSet will trigger an event `remove` for the removed items. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { id: 3, text: 'item 3' }
	     * ])
	     *
	     * // remove items
	     * const ids = data.remove([2, { id: 3 }, 4])
	     *
	     * console.log(ids) // [2, 3]
	     * ```
	     *
	     * @param id - One or more items or ids of items to be removed.
	     * @param senderId - Sender id.
	     * @returns The ids of the removed items.
	     */
	  }, {
	    key: "remove",
	    value: function remove(id, senderId) {
	      var removedIds = [];
	      var removedItems = [];
	      // force everything to be an array for simplicity
	      var ids = _Array$isArray(id) ? id : [id];
	      for (var i = 0, len = ids.length; i < len; i++) {
	        var item = this._remove(ids[i]);
	        if (item) {
	          var itemId = item[this._idProp];
	          if (itemId != null) {
	            removedIds.push(itemId);
	            removedItems.push(item);
	          }
	        }
	      }
	      if (removedIds.length) {
	        this._trigger("remove", {
	          items: removedIds,
	          oldData: removedItems
	        }, senderId);
	      }
	      return removedIds;
	    }
	    /**
	     * Remove an item by its id or reference.
	     *
	     * @param id - Id of an item or the item itself.
	     * @returns The removed item if removed, null otherwise.
	     */
	  }, {
	    key: "_remove",
	    value: function _remove(id) {
	      // @TODO: It origianlly returned the item although the docs say id.
	      // The code expects the item, so probably an error in the docs.
	      var ident;
	      // confirm the id to use based on the args type
	      if (isId(id)) {
	        ident = id;
	      } else if (id && _typeof$1(id) === "object") {
	        ident = id[this._idProp]; // look for the identifier field using ._idProp
	      }
	      // do the removing if the item is found
	      if (ident != null && this._data.has(ident)) {
	        var item = this._data.get(ident) || null;
	        this._data.delete(ident);
	        --this.length;
	        return item;
	      }
	      return null;
	    }
	    /**
	     * Clear the entire data set.
	     *
	     * After the items are removed, the {@link DataSet} will trigger an event `remove` for all removed items. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * @param senderId - Sender id.
	     * @returns removedIds - The ids of all removed items.
	     */
	  }, {
	    key: "clear",
	    value: function clear(senderId) {
	      var _context22;
	      var ids = _toConsumableArray(_keysInstanceProperty(_context22 = this._data).call(_context22));
	      var items = [];
	      for (var i = 0, len = ids.length; i < len; i++) {
	        items.push(this._data.get(ids[i]));
	      }
	      this._data.clear();
	      this.length = 0;
	      this._trigger("remove", {
	        items: ids,
	        oldData: items
	      }, senderId);
	      return ids;
	    }
	    /**
	     * Find the item with maximum value of a specified field.
	     *
	     * @param field - Name of the property that should be searched for max value.
	     * @returns Item containing max value, or null if no items.
	     */
	  }, {
	    key: "max",
	    value: function max(field) {
	      var _context23;
	      var max = null;
	      var maxField = null;
	      var _iterator11 = _createForOfIteratorHelper$6(_valuesInstanceProperty(_context23 = this._data).call(_context23)),
	        _step11;
	      try {
	        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
	          var item = _step11.value;
	          var itemField = item[field];
	          if (typeof itemField === "number" && (maxField == null || itemField > maxField)) {
	            max = item;
	            maxField = itemField;
	          }
	        }
	      } catch (err) {
	        _iterator11.e(err);
	      } finally {
	        _iterator11.f();
	      }
	      return max || null;
	    }
	    /**
	     * Find the item with minimum value of a specified field.
	     *
	     * @param field - Name of the property that should be searched for min value.
	     * @returns Item containing min value, or null if no items.
	     */
	  }, {
	    key: "min",
	    value: function min(field) {
	      var _context24;
	      var min = null;
	      var minField = null;
	      var _iterator12 = _createForOfIteratorHelper$6(_valuesInstanceProperty(_context24 = this._data).call(_context24)),
	        _step12;
	      try {
	        for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
	          var item = _step12.value;
	          var itemField = item[field];
	          if (typeof itemField === "number" && (minField == null || itemField < minField)) {
	            min = item;
	            minField = itemField;
	          }
	        }
	      } catch (err) {
	        _iterator12.e(err);
	      } finally {
	        _iterator12.f();
	      }
	      return min || null;
	    }
	    /**
	     * Find all distinct values of a specified field
	     *
	     * @param prop - The property name whose distinct values should be returned.
	     * @returns Unordered array containing all distinct values. Items without specified property are ignored.
	     */
	  }, {
	    key: "distinct",
	    value: function distinct(prop) {
	      var data = this._data;
	      var itemIds = _toConsumableArray(_keysInstanceProperty(data).call(data));
	      var values = [];
	      var count = 0;
	      for (var i = 0, len = itemIds.length; i < len; i++) {
	        var id = itemIds[i];
	        var item = data.get(id);
	        var _value3 = item[prop];
	        var exists = false;
	        for (var j = 0; j < count; j++) {
	          if (values[j] == _value3) {
	            exists = true;
	            break;
	          }
	        }
	        if (!exists && _value3 !== undefined) {
	          values[count] = _value3;
	          count++;
	        }
	      }
	      return values;
	    }
	    /**
	     * Add a single item. Will fail when an item with the same id already exists.
	     *
	     * @param item - A new item to be added.
	     * @returns Added item's id. An id is generated when it is not present in the item.
	     */
	  }, {
	    key: "_addItem",
	    value: function _addItem(item) {
	      var fullItem = ensureFullItem(item, this._idProp);
	      var id = fullItem[this._idProp];
	      // check whether this id is already taken
	      if (this._data.has(id)) {
	        // item already exists
	        throw new Error("Cannot add item: item with id " + id + " already exists");
	      }
	      this._data.set(id, fullItem);
	      ++this.length;
	      return id;
	    }
	    /**
	     * Update a single item: merge with existing item.
	     * Will fail when the item has no id, or when there does not exist an item with the same id.
	     *
	     * @param update - The new item
	     * @returns The id of the updated item.
	     */
	  }, {
	    key: "_updateItem",
	    value: function _updateItem(update) {
	      var id = update[this._idProp];
	      if (id == null) {
	        throw new Error("Cannot update item: item has no id (item: " + _JSON$stringify(update) + ")");
	      }
	      var item = this._data.get(id);
	      if (!item) {
	        // item doesn't exist
	        throw new Error("Cannot update item: no item with id " + id + " found");
	      }
	      this._data.set(id, _objectSpread$4(_objectSpread$4({}, item), update));
	      return id;
	    }
	    /** @inheritDoc */
	  }, {
	    key: "stream",
	    value: function stream(ids) {
	      if (ids) {
	        var data = this._data;
	        return new DataStream(_defineProperty({}, _Symbol$iterator2, /*#__PURE__*/_regeneratorRuntime.mark(function _callee3() {
	          var _iterator13, _step13, id, item;
	          return _regeneratorRuntime.wrap(function _callee3$(_context25) {
	            while (1) switch (_context25.prev = _context25.next) {
	              case 0:
	                _iterator13 = _createForOfIteratorHelper$6(ids);
	                _context25.prev = 1;
	                _iterator13.s();
	              case 3:
	                if ((_step13 = _iterator13.n()).done) {
	                  _context25.next = 11;
	                  break;
	                }
	                id = _step13.value;
	                item = data.get(id);
	                if (!(item != null)) {
	                  _context25.next = 9;
	                  break;
	                }
	                _context25.next = 9;
	                return [id, item];
	              case 9:
	                _context25.next = 3;
	                break;
	              case 11:
	                _context25.next = 16;
	                break;
	              case 13:
	                _context25.prev = 13;
	                _context25.t0 = _context25["catch"](1);
	                _iterator13.e(_context25.t0);
	              case 16:
	                _context25.prev = 16;
	                _iterator13.f();
	                return _context25.finish(16);
	              case 19:
	              case "end":
	                return _context25.stop();
	            }
	          }, _callee3, null, [[1, 13, 16, 19]]);
	        })));
	      } else {
	        var _context26;
	        return new DataStream(_defineProperty({}, _Symbol$iterator2, _bindInstanceProperty$1(_context26 = _entriesInstanceProperty(this._data)).call(_context26, this._data)));
	      }
	    }
	  }]);
	  return DataSet;
	}(DataSetPart);
	/**
	 * DataView
	 *
	 * A DataView offers a filtered and/or formatted view on a DataSet. One can subscribe to changes in a DataView, and easily get filtered or formatted data without having to specify filters and field types all the time.
	 *
	 * ## Example
	 * ```javascript
	 * // create a DataSet
	 * var data = new vis.DataSet();
	 * data.add([
	 *   {id: 1, text: 'item 1', date: new Date(2013, 6, 20), group: 1, first: true},
	 *   {id: 2, text: 'item 2', date: '2013-06-23', group: 2},
	 *   {id: 3, text: 'item 3', date: '2013-06-25', group: 2},
	 *   {id: 4, text: 'item 4'}
	 * ]);
	 *
	 * // create a DataView
	 * // the view will only contain items having a property group with value 1,
	 * // and will only output fields id, text, and date.
	 * var view = new vis.DataView(data, {
	 *   filter: function (item) {
	 *     return (item.group == 1);
	 *   },
	 *   fields: ['id', 'text', 'date']
	 * });
	 *
	 * // subscribe to any change in the DataView
	 * view.on('*', function (event, properties, senderId) {
	 *   console.log('event', event, properties);
	 * });
	 *
	 * // update an item in the data set
	 * data.update({id: 2, group: 1});
	 *
	 * // get all ids in the view
	 * var ids = view.getIds();
	 * console.log('ids', ids); // will output [1, 2]
	 *
	 * // get all items in the view
	 * var items = view.get();
	 * ```
	 *
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 */
	var DataView = /*#__PURE__*/function (_DataSetPart2) {
	  _inherits(DataView, _DataSetPart2);
	  var _super2 = _createSuper$t(DataView);
	  /**
	   * Create a DataView.
	   *
	   * @param data - The instance containing data (directly or indirectly).
	   * @param options - Options to configure this data view.
	   */
	  function DataView(data, options) {
	    var _context27;
	    var _this7;
	    _classCallCheck(this, DataView);
	    _this7 = _super2.call(this);
	    /** @inheritDoc */
	    _defineProperty(_assertThisInitialized(_this7), "length", 0);
	    _defineProperty(_assertThisInitialized(_this7), "_listener", void 0);
	    _defineProperty(_assertThisInitialized(_this7), "_data", void 0);
	    // constructor → setData
	    _defineProperty(_assertThisInitialized(_this7), "_ids", new _Set());
	    // ids of the items currently in memory (just contains a boolean true)
	    _defineProperty(_assertThisInitialized(_this7), "_options", void 0);
	    _this7._options = options || {};
	    _this7._listener = _bindInstanceProperty$1(_context27 = _this7._onEvent).call(_context27, _assertThisInitialized(_this7));
	    _this7.setData(data);
	    return _this7;
	  }
	  // TODO: implement a function .config() to dynamically update things like configured filter
	  // and trigger changes accordingly
	  /**
	   * Set a data source for the view.
	   *
	   * @param data - The instance containing data (directly or indirectly).
	   * @remarks
	   * Note that when the data view is bound to a data set it won't be garbage
	   * collected unless the data set is too. Use `dataView.setData(null)` or
	   * `dataView.dispose()` to enable garbage collection before you lose the last
	   * reference.
	   */
	  _createClass(DataView, [{
	    key: "idProp",
	    get: /** @inheritDoc */
	    function get() {
	      return this.getDataSet().idProp;
	    }
	  }, {
	    key: "setData",
	    value: function setData(data) {
	      if (this._data) {
	        // unsubscribe from current dataset
	        if (this._data.off) {
	          this._data.off("*", this._listener);
	        }
	        // trigger a remove of all items in memory
	        var ids = this._data.getIds({
	          filter: _filterInstanceProperty(this._options)
	        });
	        var items = this._data.get(ids);
	        this._ids.clear();
	        this.length = 0;
	        this._trigger("remove", {
	          items: ids,
	          oldData: items
	        });
	      }
	      if (data != null) {
	        this._data = data;
	        // trigger an add of all added items
	        var _ids = this._data.getIds({
	          filter: _filterInstanceProperty(this._options)
	        });
	        for (var i = 0, len = _ids.length; i < len; i++) {
	          var id = _ids[i];
	          this._ids.add(id);
	        }
	        this.length = _ids.length;
	        this._trigger("add", {
	          items: _ids
	        });
	      } else {
	        this._data = new DataSet();
	      }
	      // subscribe to new dataset
	      if (this._data.on) {
	        this._data.on("*", this._listener);
	      }
	    }
	    /**
	     * Refresh the DataView.
	     * Useful when the DataView has a filter function containing a variable parameter.
	     */
	  }, {
	    key: "refresh",
	    value: function refresh() {
	      var ids = this._data.getIds({
	        filter: _filterInstanceProperty(this._options)
	      });
	      var oldIds = _toConsumableArray(this._ids);
	      var newIds = {};
	      var addedIds = [];
	      var removedIds = [];
	      var removedItems = [];
	      // check for additions
	      for (var i = 0, len = ids.length; i < len; i++) {
	        var id = ids[i];
	        newIds[id] = true;
	        if (!this._ids.has(id)) {
	          addedIds.push(id);
	          this._ids.add(id);
	        }
	      }
	      // check for removals
	      for (var _i10 = 0, _len11 = oldIds.length; _i10 < _len11; _i10++) {
	        var _id7 = oldIds[_i10];
	        var item = this._data.get(_id7);
	        if (item == null) {
	          // @TODO: Investigate.
	          // Doesn't happen during tests or examples.
	          // Is it really impossible or could it eventually happen?
	          // How to handle it if it does? The types guarantee non-nullable items.
	          console.error("If you see this, report it please.");
	        } else if (!newIds[_id7]) {
	          removedIds.push(_id7);
	          removedItems.push(item);
	          this._ids.delete(_id7);
	        }
	      }
	      this.length += addedIds.length - removedIds.length;
	      // trigger events
	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        });
	      }
	      if (removedIds.length) {
	        this._trigger("remove", {
	          items: removedIds,
	          oldData: removedItems
	        });
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "get",
	    value: function get(first, second) {
	      if (this._data == null) {
	        return null;
	      }
	      // parse the arguments
	      var ids = null;
	      var options;
	      if (isId(first) || _Array$isArray(first)) {
	        ids = first;
	        options = second;
	      } else {
	        options = first;
	      }
	      // extend the options with the default options and provided options
	      var viewOptions = _Object$assign({}, this._options, options);
	      // create a combined filter method when needed
	      var thisFilter = _filterInstanceProperty(this._options);
	      var optionsFilter = options && _filterInstanceProperty(options);
	      if (thisFilter && optionsFilter) {
	        viewOptions.filter = function (item) {
	          return thisFilter(item) && optionsFilter(item);
	        };
	      }
	      if (ids == null) {
	        return this._data.get(viewOptions);
	      } else {
	        return this._data.get(ids, viewOptions);
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getIds",
	    value: function getIds(options) {
	      if (this._data.length) {
	        var defaultFilter = _filterInstanceProperty(this._options);
	        var optionsFilter = options != null ? _filterInstanceProperty(options) : null;
	        var filter;
	        if (optionsFilter) {
	          if (defaultFilter) {
	            filter = function filter(item) {
	              return defaultFilter(item) && optionsFilter(item);
	            };
	          } else {
	            filter = optionsFilter;
	          }
	        } else {
	          filter = defaultFilter;
	        }
	        return this._data.getIds({
	          filter: filter,
	          order: options && options.order
	        });
	      } else {
	        return [];
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "forEach",
	    value: function forEach(callback, options) {
	      if (this._data) {
	        var _context28;
	        var defaultFilter = _filterInstanceProperty(this._options);
	        var optionsFilter = options && _filterInstanceProperty(options);
	        var filter;
	        if (optionsFilter) {
	          if (defaultFilter) {
	            filter = function filter(item) {
	              return defaultFilter(item) && optionsFilter(item);
	            };
	          } else {
	            filter = optionsFilter;
	          }
	        } else {
	          filter = defaultFilter;
	        }
	        _forEachInstanceProperty(_context28 = this._data).call(_context28, callback, {
	          filter: filter,
	          order: options && options.order
	        });
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "map",
	    value: function map(callback, options) {
	      if (this._data) {
	        var _context29;
	        var defaultFilter = _filterInstanceProperty(this._options);
	        var optionsFilter = options && _filterInstanceProperty(options);
	        var filter;
	        if (optionsFilter) {
	          if (defaultFilter) {
	            filter = function filter(item) {
	              return defaultFilter(item) && optionsFilter(item);
	            };
	          } else {
	            filter = optionsFilter;
	          }
	        } else {
	          filter = defaultFilter;
	        }
	        return _mapInstanceProperty(_context29 = this._data).call(_context29, callback, {
	          filter: filter,
	          order: options && options.order
	        });
	      } else {
	        return [];
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getDataSet",
	    value: function getDataSet() {
	      return this._data.getDataSet();
	    }
	    /** @inheritDoc */
	  }, {
	    key: "stream",
	    value: function stream(ids) {
	      var _context30;
	      return this._data.stream(ids || _defineProperty({}, _Symbol$iterator2, _bindInstanceProperty$1(_context30 = _keysInstanceProperty(this._ids)).call(_context30, this._ids)));
	    }
	    /**
	     * Render the instance unusable prior to garbage collection.
	     *
	     * @remarks
	     * The intention of this method is to help discover scenarios where the data
	     * view is being used when the programmer thinks it has been garbage collected
	     * already. It's stricter version of `dataView.setData(null)`.
	     */
	  }, {
	    key: "dispose",
	    value: function dispose() {
	      var _this$_data;
	      if ((_this$_data = this._data) !== null && _this$_data !== void 0 && _this$_data.off) {
	        this._data.off("*", this._listener);
	      }
	      var message = "This data view has already been disposed of.";
	      var replacement = {
	        get: function get() {
	          throw new Error(message);
	        },
	        set: function set() {
	          throw new Error(message);
	        },
	        configurable: false
	      };
	      var _iterator14 = _createForOfIteratorHelper$6(_Reflect$ownKeys(DataView.prototype)),
	        _step14;
	      try {
	        for (_iterator14.s(); !(_step14 = _iterator14.n()).done;) {
	          var key = _step14.value;
	          _Object$defineProperty(this, key, replacement);
	        }
	      } catch (err) {
	        _iterator14.e(err);
	      } finally {
	        _iterator14.f();
	      }
	    }
	    /**
	     * Event listener. Will propagate all events from the connected data set to the subscribers of the DataView, but will filter the items and only trigger when there are changes in the filtered data set.
	     *
	     * @param event - The name of the event.
	     * @param params - Parameters of the event.
	     * @param senderId - Id supplied by the sender.
	     */
	  }, {
	    key: "_onEvent",
	    value: function _onEvent(event, params, senderId) {
	      if (!params || !params.items || !this._data) {
	        return;
	      }
	      var ids = params.items;
	      var addedIds = [];
	      var updatedIds = [];
	      var removedIds = [];
	      var oldItems = [];
	      var updatedItems = [];
	      var removedItems = [];
	      switch (event) {
	        case "add":
	          // filter the ids of the added items
	          for (var i = 0, len = ids.length; i < len; i++) {
	            var id = ids[i];
	            var item = this.get(id);
	            if (item) {
	              this._ids.add(id);
	              addedIds.push(id);
	            }
	          }
	          break;
	        case "update":
	          // determine the event from the views viewpoint: an updated
	          // item can be added, updated, or removed from this view.
	          for (var _i11 = 0, _len12 = ids.length; _i11 < _len12; _i11++) {
	            var _id8 = ids[_i11];
	            var _item5 = this.get(_id8);
	            if (_item5) {
	              if (this._ids.has(_id8)) {
	                updatedIds.push(_id8);
	                updatedItems.push(params.data[_i11]);
	                oldItems.push(params.oldData[_i11]);
	              } else {
	                this._ids.add(_id8);
	                addedIds.push(_id8);
	              }
	            } else {
	              if (this._ids.has(_id8)) {
	                this._ids.delete(_id8);
	                removedIds.push(_id8);
	                removedItems.push(params.oldData[_i11]);
	              }
	            }
	          }
	          break;
	        case "remove":
	          // filter the ids of the removed items
	          for (var _i12 = 0, _len13 = ids.length; _i12 < _len13; _i12++) {
	            var _id9 = ids[_i12];
	            if (this._ids.has(_id9)) {
	              this._ids.delete(_id9);
	              removedIds.push(_id9);
	              removedItems.push(params.oldData[_i12]);
	            }
	          }
	          break;
	      }
	      this.length += addedIds.length - removedIds.length;
	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        }, senderId);
	      }
	      if (updatedIds.length) {
	        this._trigger("update", {
	          items: updatedIds,
	          oldData: oldItems,
	          data: updatedItems
	        }, senderId);
	      }
	      if (removedIds.length) {
	        this._trigger("remove", {
	          items: removedIds,
	          oldData: removedItems
	        }, senderId);
	      }
	    }
	  }]);
	  return DataView;
	}(DataSetPart);
	/**
	 * Check that given value is compatible with Vis Data Set interface.
	 *
	 * @param idProp - The expected property to contain item id.
	 * @param v - The value to be tested.
	 * @returns True if all expected values and methods match, false otherwise.
	 */
	function isDataSetLike(idProp, v) {
	  return _typeof$1(v) === "object" && v !== null && idProp === v.idProp && typeof v.add === "function" && typeof v.clear === "function" && typeof v.distinct === "function" && typeof _forEachInstanceProperty(v) === "function" && typeof v.get === "function" && typeof v.getDataSet === "function" && typeof v.getIds === "function" && typeof v.length === "number" && typeof _mapInstanceProperty(v) === "function" && typeof v.max === "function" && typeof v.min === "function" && typeof v.off === "function" && typeof v.on === "function" && typeof v.remove === "function" && typeof v.setOptions === "function" && typeof v.stream === "function" && typeof v.update === "function" && typeof v.updateOnly === "function";
	}

	/**
	 * Check that given value is compatible with Vis Data View interface.
	 *
	 * @param idProp - The expected property to contain item id.
	 * @param v - The value to be tested.
	 * @returns True if all expected values and methods match, false otherwise.
	 */
	function isDataViewLike(idProp, v) {
	  return _typeof$1(v) === "object" && v !== null && idProp === v.idProp && typeof _forEachInstanceProperty(v) === "function" && typeof v.get === "function" && typeof v.getDataSet === "function" && typeof v.getIds === "function" && typeof v.length === "number" && typeof _mapInstanceProperty(v) === "function" && typeof v.off === "function" && typeof v.on === "function" && typeof v.stream === "function" && isDataSetLike(idProp, v.getDataSet());
	}

	var index = /*#__PURE__*/Object.freeze({
		__proto__: null,
		DELETE: DELETE,
		DataSet: DataSet,
		DataStream: DataStream,
		DataView: DataView,
		Queue: Queue,
		createNewDataPipeFrom: createNewDataPipeFrom,
		isDataSetLike: isDataSetLike,
		isDataViewLike: isDataViewLike
	});

	var global$2 = global$s;
	var fails$2 = fails$A;
	var uncurryThis$2 = functionUncurryThis;
	var toString = toString$b;
	var trim = stringTrim.trim;
	var whitespaces = whitespaces$3;

	var charAt = uncurryThis$2(''.charAt);
	var $parseFloat$1 = global$2.parseFloat;
	var Symbol$1 = global$2.Symbol;
	var ITERATOR = Symbol$1 && Symbol$1.iterator;
	var FORCED$1 = 1 / $parseFloat$1(whitespaces + '-0') !== -Infinity
	  // MS Edge 18- broken with boxed symbols
	  || (ITERATOR && !fails$2(function () { $parseFloat$1(Object(ITERATOR)); }));

	// `parseFloat` method
	// https://tc39.es/ecma262/#sec-parsefloat-string
	var numberParseFloat = FORCED$1 ? function parseFloat(string) {
	  var trimmedString = trim(toString(string));
	  var result = $parseFloat$1(trimmedString);
	  return result === 0 && charAt(trimmedString, 0) === '-' ? -0 : result;
	} : $parseFloat$1;

	var $$4 = _export;
	var $parseFloat = numberParseFloat;

	// `parseFloat` method
	// https://tc39.es/ecma262/#sec-parsefloat-string
	$$4({ global: true, forced: parseFloat !== $parseFloat }, {
	  parseFloat: $parseFloat
	});

	var path$5 = path$A;

	var _parseFloat$3 = path$5.parseFloat;

	var parent$9 = _parseFloat$3;

	var _parseFloat$2 = parent$9;

	var _parseFloat = _parseFloat$2;

	var _parseFloat$1 = /*@__PURE__*/getDefaultExportFromCjs(_parseFloat);

	var $$3 = _export;
	var fails$1 = fails$A;
	var getOwnPropertyNames$3 = objectGetOwnPropertyNamesExternal.f;

	// eslint-disable-next-line es/no-object-getownpropertynames -- required for testing
	var FAILS_ON_PRIMITIVES = fails$1(function () { return !Object.getOwnPropertyNames(1); });

	// `Object.getOwnPropertyNames` method
	// https://tc39.es/ecma262/#sec-object.getownpropertynames
	$$3({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
	  getOwnPropertyNames: getOwnPropertyNames$3
	});

	var path$4 = path$A;

	var Object$1 = path$4.Object;

	var getOwnPropertyNames$2 = function getOwnPropertyNames(it) {
	  return Object$1.getOwnPropertyNames(it);
	};

	var parent$8 = getOwnPropertyNames$2;

	var getOwnPropertyNames$1 = parent$8;

	var getOwnPropertyNames = getOwnPropertyNames$1;

	var _Object$getOwnPropertyNames = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyNames);

	/**
	 * Helper functions for components
	 */

	/**
	 * Determine values to use for (sub)options of 'chosen'.
	 *
	 * This option is either a boolean or an object whose values should be examined further.
	 * The relevant structures are:
	 *
	 * - chosen: <boolean value>
	 * - chosen: { subOption: <boolean or function> }
	 *
	 * Where subOption is 'node', 'edge' or 'label'.
	 *
	 * The intention of this method appears to be to set a specific priority to the options;
	 * Since most properties are either bridged or merged into the local options objects, there
	 * is not much point in handling them separately.
	 * TODO: examine if 'most' in previous sentence can be replaced with 'all'. In that case, we
	 *       should be able to get rid of this method.
	 *
	 * @param {string}  subOption  option within object 'chosen' to consider; either 'node', 'edge' or 'label'
	 * @param {object}  pile       array of options objects to consider
	 * @returns {boolean | Function}  value for passed subOption of 'chosen' to use
	 */
	function choosify(subOption, pile) {
	  // allowed values for subOption
	  var allowed = ["node", "edge", "label"];
	  var value = true;
	  var chosen = topMost(pile, "chosen");
	  if (typeof chosen === "boolean") {
	    value = chosen;
	  } else if (_typeof$1(chosen) === "object") {
	    if (_indexOfInstanceProperty(allowed).call(allowed, subOption) === -1) {
	      throw new Error("choosify: subOption '" + subOption + "' should be one of " + "'" + allowed.join("', '") + "'");
	    }
	    var chosenEdge = topMost(pile, ["chosen", subOption]);
	    if (typeof chosenEdge === "boolean" || typeof chosenEdge === "function") {
	      value = chosenEdge;
	    }
	  }
	  return value;
	}

	/**
	 * Check if the point falls within the given rectangle.
	 *
	 * @param {rect} rect
	 * @param {point} point
	 * @param {rotationPoint} [rotationPoint] if specified, the rotation that applies to the rectangle.
	 * @returns {boolean}  true if point within rectangle, false otherwise
	 */
	function pointInRect(rect, point, rotationPoint) {
	  if (rect.width <= 0 || rect.height <= 0) {
	    return false; // early out
	  }

	  if (rotationPoint !== undefined) {
	    // Rotate the point the same amount as the rectangle
	    var tmp = {
	      x: point.x - rotationPoint.x,
	      y: point.y - rotationPoint.y
	    };
	    if (rotationPoint.angle !== 0) {
	      // In order to get the coordinates the same, you need to
	      // rotate in the reverse direction
	      var angle = -rotationPoint.angle;
	      var tmp2 = {
	        x: Math.cos(angle) * tmp.x - Math.sin(angle) * tmp.y,
	        y: Math.sin(angle) * tmp.x + Math.cos(angle) * tmp.y
	      };
	      point = tmp2;
	    } else {
	      point = tmp;
	    }

	    // Note that if a rotation is specified, the rectangle coordinates
	    // are **not* the full canvas coordinates. They are relative to the
	    // rotationPoint. Hence, the point coordinates need not be translated
	    // back in this case.
	  }

	  var right = rect.x + rect.width;
	  var bottom = rect.y + rect.width;
	  return rect.left < point.x && right > point.x && rect.top < point.y && bottom > point.y;
	}

	/**
	 * Check if given value is acceptable as a label text.
	 *
	 * @param {*} text value to check; can be anything at this point
	 * @returns {boolean} true if valid label value, false otherwise
	 */
	function isValidLabel(text) {
	  // Note that this is quite strict: types that *might* be converted to string are disallowed
	  return typeof text === "string" && text !== "";
	}

	/**
	 * Returns x, y of self reference circle based on provided angle
	 *
	 * @param {object} ctx
	 * @param {number} angle
	 * @param {number} radius
	 * @param {VisNode} node
	 * @returns {object} x and y coordinates
	 */
	function getSelfRefCoordinates(ctx, angle, radius, node) {
	  var x = node.x;
	  var y = node.y;
	  if (typeof node.distanceToBorder === "function") {
	    //calculating opposite and adjacent
	    //distaneToBorder becomes Hypotenuse.
	    //Formulas sin(a) = Opposite / Hypotenuse and cos(a) = Adjacent / Hypotenuse
	    var toBorderDist = node.distanceToBorder(ctx, angle);
	    var yFromNodeCenter = Math.sin(angle) * toBorderDist;
	    var xFromNodeCenter = Math.cos(angle) * toBorderDist;
	    //xFromNodeCenter is basically x and if xFromNodeCenter equals to the distance to border then it means
	    //that y does not need calculation because it is equal node.height / 2 or node.y
	    //same thing with yFromNodeCenter and if yFromNodeCenter equals to the distance to border then it means
	    //that x is equal node.width / 2 or node.x
	    if (xFromNodeCenter === toBorderDist) {
	      x += toBorderDist;
	      y = node.y;
	    } else if (yFromNodeCenter === toBorderDist) {
	      x = node.x;
	      y -= toBorderDist;
	    } else {
	      x += xFromNodeCenter;
	      y -= yFromNodeCenter;
	    }
	  } else if (node.shape.width > node.shape.height) {
	    x = node.x + node.shape.width * 0.5;
	    y = node.y - radius;
	  } else {
	    x = node.x + radius;
	    y = node.y - node.shape.height * 0.5;
	  }
	  return {
	    x: x,
	    y: y
	  };
	}

	/**
	 * Callback to determine text dimensions, using the parent label settings.
	 *
	 * @callback MeasureText
	 * @param {text} text
	 * @param {text} mod
	 * @returns {object} { width, values} width in pixels and font attributes
	 */
	/**
	 * Helper class for Label which collects results of splitting labels into lines and blocks.
	 *
	 * @private
	 */
	var LabelAccumulator = /*#__PURE__*/function () {
	  /**
	   * @param {MeasureText} measureText
	   */
	  function LabelAccumulator(measureText) {
	    _classCallCheck(this, LabelAccumulator);
	    this.measureText = measureText;
	    this.current = 0;
	    this.width = 0;
	    this.height = 0;
	    this.lines = [];
	  }

	  /**
	   * Append given text to the given line.
	   *
	   * @param {number}  l    index of line to add to
	   * @param {string}  text string to append to line
	   * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
	   * @private
	   */
	  _createClass(LabelAccumulator, [{
	    key: "_add",
	    value: function _add(l, text) {
	      var mod = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "normal";
	      if (this.lines[l] === undefined) {
	        this.lines[l] = {
	          width: 0,
	          height: 0,
	          blocks: []
	        };
	      }

	      // We still need to set a block for undefined and empty texts, hence return at this point
	      // This is necessary because we don't know at this point if we're at the
	      // start of an empty line or not.
	      // To compensate, empty blocks are removed in `finalize()`.
	      //
	      // Empty strings should still have a height
	      var tmpText = text;
	      if (text === undefined || text === "") tmpText = " ";

	      // Determine width and get the font properties
	      var result = this.measureText(tmpText, mod);
	      var block = _Object$assign({}, _valuesInstanceProperty(result));
	      block.text = text;
	      block.width = result.width;
	      block.mod = mod;
	      if (text === undefined || text === "") {
	        block.width = 0;
	      }
	      this.lines[l].blocks.push(block);

	      // Update the line width. We need this for determining if a string goes over max width
	      this.lines[l].width += block.width;
	    }

	    /**
	     * Returns the width in pixels of the current line.
	     *
	     * @returns {number}
	     */
	  }, {
	    key: "curWidth",
	    value: function curWidth() {
	      var line = this.lines[this.current];
	      if (line === undefined) return 0;
	      return line.width;
	    }

	    /**
	     * Add text in block to current line
	     *
	     * @param {string} text
	     * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
	     */
	  }, {
	    key: "append",
	    value: function append(text) {
	      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "normal";
	      this._add(this.current, text, mod);
	    }

	    /**
	     * Add text in block to current line and start a new line
	     *
	     * @param {string} text
	     * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
	     */
	  }, {
	    key: "newLine",
	    value: function newLine(text) {
	      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "normal";
	      this._add(this.current, text, mod);
	      this.current++;
	    }

	    /**
	     * Determine and set the heights of all the lines currently contained in this instance
	     *
	     * Note that width has already been set.
	     *
	     * @private
	     */
	  }, {
	    key: "determineLineHeights",
	    value: function determineLineHeights() {
	      for (var k = 0; k < this.lines.length; k++) {
	        var line = this.lines[k];

	        // Looking for max height of blocks in line
	        var height = 0;
	        if (line.blocks !== undefined) {
	          // Can happen if text contains e.g. '\n '
	          for (var l = 0; l < line.blocks.length; l++) {
	            var block = line.blocks[l];
	            if (height < block.height) {
	              height = block.height;
	            }
	          }
	        }
	        line.height = height;
	      }
	    }

	    /**
	     * Determine the full size of the label text, as determined by current lines and blocks
	     *
	     * @private
	     */
	  }, {
	    key: "determineLabelSize",
	    value: function determineLabelSize() {
	      var width = 0;
	      var height = 0;
	      for (var k = 0; k < this.lines.length; k++) {
	        var line = this.lines[k];
	        if (line.width > width) {
	          width = line.width;
	        }
	        height += line.height;
	      }
	      this.width = width;
	      this.height = height;
	    }

	    /**
	     * Remove all empty blocks and empty lines we don't need
	     *
	     * This must be done after the width/height determination,
	     * so that these are set properly for processing here.
	     *
	     * @returns {Array<Line>} Lines with empty blocks (and some empty lines) removed
	     * @private
	     */
	  }, {
	    key: "removeEmptyBlocks",
	    value: function removeEmptyBlocks() {
	      var tmpLines = [];
	      for (var k = 0; k < this.lines.length; k++) {
	        var line = this.lines[k];

	        // Note: an empty line in between text has width zero but is still relevant to layout.
	        // So we can't use width for testing empty line here
	        if (line.blocks.length === 0) continue;

	        // Discard final empty line always
	        if (k === this.lines.length - 1) {
	          if (line.width === 0) continue;
	        }
	        var tmpLine = {};
	        _Object$assign(tmpLine, line);
	        tmpLine.blocks = [];
	        var firstEmptyBlock = void 0;
	        var tmpBlocks = [];
	        for (var l = 0; l < line.blocks.length; l++) {
	          var block = line.blocks[l];
	          if (block.width !== 0) {
	            tmpBlocks.push(block);
	          } else {
	            if (firstEmptyBlock === undefined) {
	              firstEmptyBlock = block;
	            }
	          }
	        }

	        // Ensure that there is *some* text present
	        if (tmpBlocks.length === 0 && firstEmptyBlock !== undefined) {
	          tmpBlocks.push(firstEmptyBlock);
	        }
	        tmpLine.blocks = tmpBlocks;
	        tmpLines.push(tmpLine);
	      }
	      return tmpLines;
	    }

	    /**
	     * Set the sizes for all lines and the whole thing.
	     *
	     * @returns {{width: (number|*), height: (number|*), lines: Array}}
	     */
	  }, {
	    key: "finalize",
	    value: function finalize() {
	      //console.log(JSON.stringify(this.lines, null, 2));

	      this.determineLineHeights();
	      this.determineLabelSize();
	      var tmpLines = this.removeEmptyBlocks();

	      // Return a simple hash object for further processing.
	      return {
	        width: this.width,
	        height: this.height,
	        lines: tmpLines
	      };
	    }
	  }]);
	  return LabelAccumulator;
	}();

	// Hash of prepared regexp's for tags
	var tagPattern = {
	  // HTML
	  "<b>": /<b>/,
	  "<i>": /<i>/,
	  "<code>": /<code>/,
	  "</b>": /<\/b>/,
	  "</i>": /<\/i>/,
	  "</code>": /<\/code>/,
	  // Markdown
	  "*": /\*/,
	  // bold
	  _: /_/,
	  // ital
	  "`": /`/,
	  // mono
	  afterBold: /[^*]/,
	  afterItal: /[^_]/,
	  afterMono: /[^`]/
	};

	/**
	 * Internal helper class for parsing the markup tags for HTML and Markdown.
	 *
	 * NOTE: Sequences of tabs and spaces are reduced to single space.
	 *       Scan usage of `this.spacing` within method
	 */
	var MarkupAccumulator = /*#__PURE__*/function () {
	  /**
	   * Create an instance
	   *
	   * @param {string} text  text to parse for markup
	   */
	  function MarkupAccumulator(text) {
	    _classCallCheck(this, MarkupAccumulator);
	    this.text = text;
	    this.bold = false;
	    this.ital = false;
	    this.mono = false;
	    this.spacing = false;
	    this.position = 0;
	    this.buffer = "";
	    this.modStack = [];
	    this.blocks = [];
	  }

	  /**
	   * Return the mod label currently on the top of the stack
	   *
	   * @returns {string}  label of topmost mod
	   * @private
	   */
	  _createClass(MarkupAccumulator, [{
	    key: "mod",
	    value: function mod() {
	      return this.modStack.length === 0 ? "normal" : this.modStack[0];
	    }

	    /**
	     * Return the mod label currently active
	     *
	     * @returns {string}  label of active mod
	     * @private
	     */
	  }, {
	    key: "modName",
	    value: function modName() {
	      if (this.modStack.length === 0) return "normal";else if (this.modStack[0] === "mono") return "mono";else {
	        if (this.bold && this.ital) {
	          return "boldital";
	        } else if (this.bold) {
	          return "bold";
	        } else if (this.ital) {
	          return "ital";
	        }
	      }
	    }

	    /**
	     * @private
	     */
	  }, {
	    key: "emitBlock",
	    value: function emitBlock() {
	      if (this.spacing) {
	        this.add(" ");
	        this.spacing = false;
	      }
	      if (this.buffer.length > 0) {
	        this.blocks.push({
	          text: this.buffer,
	          mod: this.modName()
	        });
	        this.buffer = "";
	      }
	    }

	    /**
	     * Output text to buffer
	     *
	     * @param {string} text  text to add
	     * @private
	     */
	  }, {
	    key: "add",
	    value: function add(text) {
	      if (text === " ") {
	        this.spacing = true;
	      }
	      if (this.spacing) {
	        this.buffer += " ";
	        this.spacing = false;
	      }
	      if (text != " ") {
	        this.buffer += text;
	      }
	    }

	    /**
	     * Handle parsing of whitespace
	     *
	     * @param {string} ch  the character to check
	     * @returns {boolean} true if the character was processed as whitespace, false otherwise
	     */
	  }, {
	    key: "parseWS",
	    value: function parseWS(ch) {
	      if (/[ \t]/.test(ch)) {
	        if (!this.mono) {
	          this.spacing = true;
	        } else {
	          this.add(ch);
	        }
	        return true;
	      }
	      return false;
	    }

	    /**
	     * @param {string} tagName  label for block type to set
	     * @private
	     */
	  }, {
	    key: "setTag",
	    value: function setTag(tagName) {
	      this.emitBlock();
	      this[tagName] = true;
	      this.modStack.unshift(tagName);
	    }

	    /**
	     * @param {string} tagName  label for block type to unset
	     * @private
	     */
	  }, {
	    key: "unsetTag",
	    value: function unsetTag(tagName) {
	      this.emitBlock();
	      this[tagName] = false;
	      this.modStack.shift();
	    }

	    /**
	     * @param {string} tagName label for block type we are currently processing
	     * @param {string|RegExp} tag string to match in text
	     * @returns {boolean} true if the tag was processed, false otherwise
	     */
	  }, {
	    key: "parseStartTag",
	    value: function parseStartTag(tagName, tag) {
	      // Note: if 'mono' passed as tagName, there is a double check here. This is OK
	      if (!this.mono && !this[tagName] && this.match(tag)) {
	        this.setTag(tagName);
	        return true;
	      }
	      return false;
	    }

	    /**
	     * @param {string|RegExp} tag
	     * @param {number} [advance=true] if set, advance current position in text
	     * @returns {boolean} true if match at given position, false otherwise
	     * @private
	     */
	  }, {
	    key: "match",
	    value: function match(tag) {
	      var advance = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      var _this$prepareRegExp = this.prepareRegExp(tag),
	        _this$prepareRegExp2 = _slicedToArray(_this$prepareRegExp, 2),
	        regExp = _this$prepareRegExp2[0],
	        length = _this$prepareRegExp2[1];
	      var matched = regExp.test(this.text.substr(this.position, length));
	      if (matched && advance) {
	        this.position += length - 1;
	      }
	      return matched;
	    }

	    /**
	     * @param {string} tagName label for block type we are currently processing
	     * @param {string|RegExp} tag string to match in text
	     * @param {RegExp} [nextTag] regular expression to match for characters *following* the current tag
	     * @returns {boolean} true if the tag was processed, false otherwise
	     */
	  }, {
	    key: "parseEndTag",
	    value: function parseEndTag(tagName, tag, nextTag) {
	      var checkTag = this.mod() === tagName;
	      if (tagName === "mono") {
	        // special handling for 'mono'
	        checkTag = checkTag && this.mono;
	      } else {
	        checkTag = checkTag && !this.mono;
	      }
	      if (checkTag && this.match(tag)) {
	        if (nextTag !== undefined) {
	          // Purpose of the following match is to prevent a direct unset/set of a given tag
	          // E.g. '*bold **still bold*' => '*bold still bold*'
	          if (this.position === this.text.length - 1 || this.match(nextTag, false)) {
	            this.unsetTag(tagName);
	          }
	        } else {
	          this.unsetTag(tagName);
	        }
	        return true;
	      }
	      return false;
	    }

	    /**
	     * @param {string|RegExp} tag  string to match in text
	     * @param {value} value  string to replace tag with, if found at current position
	     * @returns {boolean} true if the tag was processed, false otherwise
	     */
	  }, {
	    key: "replace",
	    value: function replace(tag, value) {
	      if (this.match(tag)) {
	        this.add(value);
	        this.position += length - 1;
	        return true;
	      }
	      return false;
	    }

	    /**
	     * Create a regular expression for the tag if it isn't already one.
	     *
	     * The return value is an array `[RegExp, number]`, with exactly two value, where:
	     *  - RegExp is the regular expression to use
	     *  - number is the lenth of the input string to match
	     *
	     * @param {string|RegExp} tag  string to match in text
	     * @returns {Array}  regular expression to use and length of input string to match
	     * @private
	     */
	  }, {
	    key: "prepareRegExp",
	    value: function prepareRegExp(tag) {
	      var length;
	      var regExp;
	      if (tag instanceof RegExp) {
	        regExp = tag;
	        length = 1; // ASSUMPTION: regexp only tests one character
	      } else {
	        // use prepared regexp if present
	        var prepared = tagPattern[tag];
	        if (prepared !== undefined) {
	          regExp = prepared;
	        } else {
	          regExp = new RegExp(tag);
	        }
	        length = tag.length;
	      }
	      return [regExp, length];
	    }
	  }]);
	  return MarkupAccumulator;
	}();
	/**
	 * Helper class for Label which explodes the label text into lines and blocks within lines
	 *
	 * @private
	 */
	var LabelSplitter = /*#__PURE__*/function () {
	  /**
	   * @param {CanvasRenderingContext2D} ctx Canvas rendering context
	   * @param {Label} parent reference to the Label instance using current instance
	   * @param {boolean} selected
	   * @param {boolean} hover
	   */
	  function LabelSplitter(ctx, parent, selected, hover) {
	    var _this = this;
	    _classCallCheck(this, LabelSplitter);
	    this.ctx = ctx;
	    this.parent = parent;
	    this.selected = selected;
	    this.hover = hover;

	    /**
	     * Callback to determine text width; passed to LabelAccumulator instance
	     *
	     * @param  {string} text string to determine width of
	     * @param  {string} mod  font type to use for this text
	     * @returns {object} { width, values} width in pixels and font attributes
	     */
	    var textWidth = function textWidth(text, mod) {
	      if (text === undefined) return 0;

	      // TODO: This can be done more efficiently with caching
	      // This will set the ctx.font correctly, depending on selected/hover and mod - so that ctx.measureText() will be accurate.
	      var values = _this.parent.getFormattingValues(ctx, selected, hover, mod);
	      var width = 0;
	      if (text !== "") {
	        var measure = _this.ctx.measureText(text);
	        width = measure.width;
	      }
	      return {
	        width: width,
	        values: values
	      };
	    };
	    this.lines = new LabelAccumulator(textWidth);
	  }

	  /**
	   * Split passed text of a label into lines and blocks.
	   *
	   * # NOTE
	   *
	   * The handling of spacing is option dependent:
	   *
	   * - if `font.multi : false`, all spaces are retained
	   * - if `font.multi : true`, every sequence of spaces is compressed to a single space
	   *
	   * This might not be the best way to do it, but this is as it has been working till now.
	   * In order not to break existing functionality, for the time being this behaviour will
	   * be retained in any code changes.
	   *
	   * @param {string} text  text to split
	   * @returns {Array<line>}
	   */
	  _createClass(LabelSplitter, [{
	    key: "process",
	    value: function process(text) {
	      if (!isValidLabel(text)) {
	        return this.lines.finalize();
	      }
	      var font = this.parent.fontOptions;

	      // Normalize the end-of-line's to a single representation - order important
	      text = text.replace(/\r\n/g, "\n"); // Dos EOL's
	      text = text.replace(/\r/g, "\n"); // Mac EOL's

	      // Note that at this point, there can be no \r's in the text.
	      // This is used later on splitStringIntoLines() to split multifont texts.

	      var nlLines = String(text).split("\n");
	      var lineCount = nlLines.length;
	      if (font.multi) {
	        // Multi-font case: styling tags active
	        for (var i = 0; i < lineCount; i++) {
	          var blocks = this.splitBlocks(nlLines[i], font.multi);
	          // Post: Sequences of tabs and spaces are reduced to single space

	          if (blocks === undefined) continue;
	          if (blocks.length === 0) {
	            this.lines.newLine("");
	            continue;
	          }
	          if (font.maxWdt > 0) {
	            // widthConstraint.maximum defined
	            //console.log('Running widthConstraint multi, max: ' + this.fontOptions.maxWdt);
	            for (var j = 0; j < blocks.length; j++) {
	              var mod = blocks[j].mod;
	              var _text = blocks[j].text;
	              this.splitStringIntoLines(_text, mod, true);
	            }
	          } else {
	            // widthConstraint.maximum NOT defined
	            for (var _j = 0; _j < blocks.length; _j++) {
	              var _mod = blocks[_j].mod;
	              var _text2 = blocks[_j].text;
	              this.lines.append(_text2, _mod);
	            }
	          }
	          this.lines.newLine();
	        }
	      } else {
	        // Single-font case
	        if (font.maxWdt > 0) {
	          // widthConstraint.maximum defined
	          // console.log('Running widthConstraint normal, max: ' + this.fontOptions.maxWdt);
	          for (var _i = 0; _i < lineCount; _i++) {
	            this.splitStringIntoLines(nlLines[_i]);
	          }
	        } else {
	          // widthConstraint.maximum NOT defined
	          for (var _i2 = 0; _i2 < lineCount; _i2++) {
	            this.lines.newLine(nlLines[_i2]);
	          }
	        }
	      }
	      return this.lines.finalize();
	    }

	    /**
	     * normalize the markup system
	     *
	     * @param {boolean|'md'|'markdown'|'html'} markupSystem
	     * @returns {string}
	     */
	  }, {
	    key: "decodeMarkupSystem",
	    value: function decodeMarkupSystem(markupSystem) {
	      var system = "none";
	      if (markupSystem === "markdown" || markupSystem === "md") {
	        system = "markdown";
	      } else if (markupSystem === true || markupSystem === "html") {
	        system = "html";
	      }
	      return system;
	    }

	    /**
	     *
	     * @param {string} text
	     * @returns {Array}
	     */
	  }, {
	    key: "splitHtmlBlocks",
	    value: function splitHtmlBlocks(text) {
	      var s = new MarkupAccumulator(text);
	      var parseEntities = function parseEntities(ch) {
	        if (/&/.test(ch)) {
	          var parsed = s.replace(s.text, "&lt;", "<") || s.replace(s.text, "&amp;", "&");
	          if (!parsed) {
	            s.add("&");
	          }
	          return true;
	        }
	        return false;
	      };
	      while (s.position < s.text.length) {
	        var ch = s.text.charAt(s.position);
	        var parsed = s.parseWS(ch) || /</.test(ch) && (s.parseStartTag("bold", "<b>") || s.parseStartTag("ital", "<i>") || s.parseStartTag("mono", "<code>") || s.parseEndTag("bold", "</b>") || s.parseEndTag("ital", "</i>") || s.parseEndTag("mono", "</code>")) || parseEntities(ch);
	        if (!parsed) {
	          s.add(ch);
	        }
	        s.position++;
	      }
	      s.emitBlock();
	      return s.blocks;
	    }

	    /**
	     *
	     * @param {string} text
	     * @returns {Array}
	     */
	  }, {
	    key: "splitMarkdownBlocks",
	    value: function splitMarkdownBlocks(text) {
	      var _this2 = this;
	      var s = new MarkupAccumulator(text);
	      var beginable = true;
	      var parseOverride = function parseOverride(ch) {
	        if (/\\/.test(ch)) {
	          if (s.position < _this2.text.length + 1) {
	            s.position++;
	            ch = _this2.text.charAt(s.position);
	            if (/ \t/.test(ch)) {
	              s.spacing = true;
	            } else {
	              s.add(ch);
	              beginable = false;
	            }
	          }
	          return true;
	        }
	        return false;
	      };
	      while (s.position < s.text.length) {
	        var ch = s.text.charAt(s.position);
	        var parsed = s.parseWS(ch) || parseOverride(ch) || (beginable || s.spacing) && (s.parseStartTag("bold", "*") || s.parseStartTag("ital", "_") || s.parseStartTag("mono", "`")) || s.parseEndTag("bold", "*", "afterBold") || s.parseEndTag("ital", "_", "afterItal") || s.parseEndTag("mono", "`", "afterMono");
	        if (!parsed) {
	          s.add(ch);
	          beginable = false;
	        }
	        s.position++;
	      }
	      s.emitBlock();
	      return s.blocks;
	    }

	    /**
	     * Explodes a piece of text into single-font blocks using a given markup
	     *
	     * @param {string} text
	     * @param {boolean|'md'|'markdown'|'html'} markupSystem
	     * @returns {Array.<{text: string, mod: string}>}
	     * @private
	     */
	  }, {
	    key: "splitBlocks",
	    value: function splitBlocks(text, markupSystem) {
	      var system = this.decodeMarkupSystem(markupSystem);
	      if (system === "none") {
	        return [{
	          text: text,
	          mod: "normal"
	        }];
	      } else if (system === "markdown") {
	        return this.splitMarkdownBlocks(text);
	      } else if (system === "html") {
	        return this.splitHtmlBlocks(text);
	      }
	    }

	    /**
	     * @param {string} text
	     * @returns {boolean} true if text length over the current max with
	     * @private
	     */
	  }, {
	    key: "overMaxWidth",
	    value: function overMaxWidth(text) {
	      var width = this.ctx.measureText(text).width;
	      return this.lines.curWidth() + width > this.parent.fontOptions.maxWdt;
	    }

	    /**
	     * Determine the longest part of the sentence which still fits in the
	     * current max width.
	     *
	     * @param {Array} words  Array of strings signifying a text lines
	     * @returns {number}      index of first item in string making string go over max
	     * @private
	     */
	  }, {
	    key: "getLongestFit",
	    value: function getLongestFit(words) {
	      var text = "";
	      var w = 0;
	      while (w < words.length) {
	        var pre = text === "" ? "" : " ";
	        var newText = text + pre + words[w];
	        if (this.overMaxWidth(newText)) break;
	        text = newText;
	        w++;
	      }
	      return w;
	    }

	    /**
	     * Determine the longest part of the string which still fits in the
	     * current max width.
	     *
	     * @param {Array} words Array of strings signifying a text lines
	     * @returns {number} index of first item in string making string go over max
	     */
	  }, {
	    key: "getLongestFitWord",
	    value: function getLongestFitWord(words) {
	      var w = 0;
	      while (w < words.length) {
	        if (this.overMaxWidth(_sliceInstanceProperty(words).call(words, 0, w))) break;
	        w++;
	      }
	      return w;
	    }

	    /**
	     * Split the passed text into lines, according to width constraint (if any).
	     *
	     * The method assumes that the input string is a single line, i.e. without lines break.
	     *
	     * This method retains spaces, if still present (case `font.multi: false`).
	     * A space which falls on an internal line break, will be replaced by a newline.
	     * There is no special handling of tabs; these go along with the flow.
	     *
	     * @param {string} str
	     * @param {string} [mod='normal']
	     * @param {boolean} [appendLast=false]
	     * @private
	     */
	  }, {
	    key: "splitStringIntoLines",
	    value: function splitStringIntoLines(str) {
	      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "normal";
	      var appendLast = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      // Set the canvas context font, based upon the current selected/hover state
	      // and the provided mod, so the text measurement performed by getLongestFit
	      // will be accurate - and not just use the font of whoever last used the canvas.
	      this.parent.getFormattingValues(this.ctx, this.selected, this.hover, mod);

	      // Still-present spaces are relevant, retain them
	      str = str.replace(/^( +)/g, "$1\r");
	      str = str.replace(/([^\r][^ ]*)( +)/g, "$1\r$2\r");
	      var words = str.split("\r");
	      while (words.length > 0) {
	        var w = this.getLongestFit(words);
	        if (w === 0) {
	          // Special case: the first word is already larger than the max width.
	          var word = words[0];

	          // Break the word to the largest part that fits the line
	          var x = this.getLongestFitWord(word);
	          this.lines.newLine(_sliceInstanceProperty(word).call(word, 0, x), mod);

	          // Adjust the word, so that the rest will be done next iteration
	          words[0] = _sliceInstanceProperty(word).call(word, x);
	        } else {
	          // skip any space that is replaced by a newline
	          var newW = w;
	          if (words[w - 1] === " ") {
	            w--;
	          } else if (words[newW] === " ") {
	            newW++;
	          }
	          var text = _sliceInstanceProperty(words).call(words, 0, w).join("");
	          if (w == words.length && appendLast) {
	            this.lines.append(text, mod);
	          } else {
	            this.lines.newLine(text, mod);
	          }

	          // Adjust the word, so that the rest will be done next iteration
	          words = _sliceInstanceProperty(words).call(words, newW);
	        }
	      }
	    }
	  }]);
	  return LabelSplitter;
	}();

	/**
	 * List of special styles for multi-fonts
	 *
	 * @private
	 */
	var multiFontStyle = ["bold", "ital", "boldital", "mono"];

	/**
	 * A Label to be used for Nodes or Edges.
	 */
	var Label = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   * @param {object} options
	   * @param {boolean} [edgelabel=false]
	   */
	  function Label(body, options) {
	    var edgelabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	    _classCallCheck(this, Label);
	    this.body = body;
	    this.pointToSelf = false;
	    this.baseSize = undefined;
	    this.fontOptions = {}; // instance variable containing the *instance-local* font options
	    this.setOptions(options);
	    this.size = {
	      top: 0,
	      left: 0,
	      width: 0,
	      height: 0,
	      yLine: 0
	    };
	    this.isEdgeLabel = edgelabel;
	  }

	  /**
	   * @param {object} options the options of the parent Node-instance
	   */
	  _createClass(Label, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.elementOptions = options; // Reference to the options of the parent Node-instance

	      this.initFontOptions(options.font);
	      if (isValidLabel(options.label)) {
	        this.labelDirty = true;
	      } else {
	        // Bad label! Change the option value to prevent bad stuff happening
	        options.label = undefined;
	      }
	      if (options.font !== undefined && options.font !== null) {
	        // font options can be deleted at various levels
	        if (typeof options.font === "string") {
	          this.baseSize = this.fontOptions.size;
	        } else if (_typeof$1(options.font) === "object") {
	          var size = options.font.size;
	          if (size !== undefined) {
	            this.baseSize = size;
	          }
	        }
	      }
	    }

	    /**
	     * Init the font Options structure.
	     *
	     * Member fontOptions serves as an accumulator for the current font options.
	     * As such, it needs to be completely separated from the node options.
	     *
	     * @param {object} newFontOptions the new font options to process
	     * @private
	     */
	  }, {
	    key: "initFontOptions",
	    value: function initFontOptions(newFontOptions) {
	      var _this = this;
	      // Prepare the multi-font option objects.
	      // These will be filled in propagateFonts(), if required
	      forEach$4(multiFontStyle, function (style) {
	        _this.fontOptions[style] = {};
	      });

	      // Handle shorthand option, if present
	      if (Label.parseFontString(this.fontOptions, newFontOptions)) {
	        this.fontOptions.vadjust = 0;
	        return;
	      }

	      // Copy over the non-multifont options, if specified
	      forEach$4(newFontOptions, function (prop, n) {
	        if (prop !== undefined && prop !== null && _typeof$1(prop) !== "object") {
	          _this.fontOptions[n] = prop;
	        }
	      });
	    }

	    /**
	     * If in-variable is a string, parse it as a font specifier.
	     *
	     * Note that following is not done here and have to be done after the call:
	     * - Not all font options are set (vadjust, mod)
	     *
	     * @param {object} outOptions  out-parameter, object in which to store the parse results (if any)
	     * @param {object} inOptions  font options to parse
	     * @returns {boolean} true if font parsed as string, false otherwise
	     * @static
	     */
	  }, {
	    key: "constrain",
	    value:
	    /**
	     * Set the width and height constraints based on 'nearest' value
	     *
	     * @param {Array} pile array of option objects to consider
	     * @returns {object} the actual constraint values to use
	     * @private
	     */
	    function constrain(pile) {
	      // NOTE: constrainWidth and  constrainHeight never set!
	      // NOTE: for edge labels, only 'maxWdt' set
	      // Node labels can set all the fields
	      var fontOptions = {
	        constrainWidth: false,
	        maxWdt: -1,
	        minWdt: -1,
	        constrainHeight: false,
	        minHgt: -1,
	        valign: "middle"
	      };
	      var widthConstraint = topMost(pile, "widthConstraint");
	      if (typeof widthConstraint === "number") {
	        fontOptions.maxWdt = Number(widthConstraint);
	        fontOptions.minWdt = Number(widthConstraint);
	      } else if (_typeof$1(widthConstraint) === "object") {
	        var widthConstraintMaximum = topMost(pile, ["widthConstraint", "maximum"]);
	        if (typeof widthConstraintMaximum === "number") {
	          fontOptions.maxWdt = Number(widthConstraintMaximum);
	        }
	        var widthConstraintMinimum = topMost(pile, ["widthConstraint", "minimum"]);
	        if (typeof widthConstraintMinimum === "number") {
	          fontOptions.minWdt = Number(widthConstraintMinimum);
	        }
	      }
	      var heightConstraint = topMost(pile, "heightConstraint");
	      if (typeof heightConstraint === "number") {
	        fontOptions.minHgt = Number(heightConstraint);
	      } else if (_typeof$1(heightConstraint) === "object") {
	        var heightConstraintMinimum = topMost(pile, ["heightConstraint", "minimum"]);
	        if (typeof heightConstraintMinimum === "number") {
	          fontOptions.minHgt = Number(heightConstraintMinimum);
	        }
	        var heightConstraintValign = topMost(pile, ["heightConstraint", "valign"]);
	        if (typeof heightConstraintValign === "string") {
	          if (heightConstraintValign === "top" || heightConstraintValign === "bottom") {
	            fontOptions.valign = heightConstraintValign;
	          }
	        }
	      }
	      return fontOptions;
	    }

	    /**
	     * Set options and update internal state
	     *
	     * @param {object} options  options to set
	     * @param {Array}  pile     array of option objects to consider for option 'chosen'
	     */
	  }, {
	    key: "update",
	    value: function update(options, pile) {
	      this.setOptions(options, true);
	      this.propagateFonts(pile);
	      deepExtend(this.fontOptions, this.constrain(pile));
	      this.fontOptions.chooser = choosify("label", pile);
	    }

	    /**
	     * When margins are set in an element, adjust sizes is called to remove them
	     * from the width/height constraints. This must be done prior to label sizing.
	     *
	     * @param {{top: number, right: number, bottom: number, left: number}} margins
	     */
	  }, {
	    key: "adjustSizes",
	    value: function adjustSizes(margins) {
	      var widthBias = margins ? margins.right + margins.left : 0;
	      if (this.fontOptions.constrainWidth) {
	        this.fontOptions.maxWdt -= widthBias;
	        this.fontOptions.minWdt -= widthBias;
	      }
	      var heightBias = margins ? margins.top + margins.bottom : 0;
	      if (this.fontOptions.constrainHeight) {
	        this.fontOptions.minHgt -= heightBias;
	      }
	    }

	    /////////////////////////////////////////////////////////
	    // Methods for handling options piles
	    // Eventually, these will be moved to a separate class
	    /////////////////////////////////////////////////////////

	    /**
	     * Add the font members of the passed list of option objects to the pile.
	     *
	     * @param {Pile} dstPile  pile of option objects add to
	     * @param {Pile} srcPile  pile of option objects to take font options from
	     * @private
	     */
	  }, {
	    key: "addFontOptionsToPile",
	    value: function addFontOptionsToPile(dstPile, srcPile) {
	      for (var i = 0; i < srcPile.length; ++i) {
	        this.addFontToPile(dstPile, srcPile[i]);
	      }
	    }

	    /**
	     * Add given font option object to the list of objects (the 'pile') to consider for determining
	     * multi-font option values.
	     *
	     * @param {Pile} pile  pile of option objects to use
	     * @param {object} options  instance to add to pile
	     * @private
	     */
	  }, {
	    key: "addFontToPile",
	    value: function addFontToPile(pile, options) {
	      if (options === undefined) return;
	      if (options.font === undefined || options.font === null) return;
	      var item = options.font;
	      pile.push(item);
	    }

	    /**
	     * Collect all own-property values from the font pile that aren't multi-font option objectss.
	     *
	     * @param {Pile} pile  pile of option objects to use
	     * @returns {object} object with all current own basic font properties
	     * @private
	     */
	  }, {
	    key: "getBasicOptions",
	    value: function getBasicOptions(pile) {
	      var ret = {};

	      // Scans the whole pile to get all options present
	      for (var n = 0; n < pile.length; ++n) {
	        var fontOptions = pile[n];

	        // Convert shorthand if necessary
	        var tmpShorthand = {};
	        if (Label.parseFontString(tmpShorthand, fontOptions)) {
	          fontOptions = tmpShorthand;
	        }
	        forEach$4(fontOptions, function (opt, name) {
	          if (opt === undefined) return; // multi-font option need not be present
	          if (Object.prototype.hasOwnProperty.call(ret, name)) return; // Keep first value we encounter

	          if (_indexOfInstanceProperty(multiFontStyle).call(multiFontStyle, name) !== -1) {
	            // Skip multi-font properties but we do need the structure
	            ret[name] = {};
	          } else {
	            ret[name] = opt;
	          }
	        });
	      }
	      return ret;
	    }

	    /**
	     * Return the value for given option for the given multi-font.
	     *
	     * All available option objects are trawled in the set order to construct the option values.
	     *
	     * ---------------------------------------------------------------------
	     * ## Traversal of pile for multi-fonts
	     *
	     * The determination of multi-font option values is a special case, because any values not
	     * present in the multi-font options should by definition be taken from the main font options,
	     * i.e. from the current 'parent' object of the multi-font option.
	     *
	     * ### Search order for multi-fonts
	     *
	     * 'bold' used as example:
	     *
	     *   - search in option group 'bold' in local properties
	     *   - search in main font option group in local properties
	     *
	     * ---------------------------------------------------------------------
	     *
	     * @param {Pile} pile  pile of option objects to use
	     * @param {MultiFontStyle} multiName sub path for the multi-font
	     * @param {string} option  the option to search for, for the given multi-font
	     * @returns {string|number} the value for the given option
	     * @private
	     */
	  }, {
	    key: "getFontOption",
	    value: function getFontOption(pile, multiName, option) {
	      var multiFont;

	      // Search multi font in local properties
	      for (var n = 0; n < pile.length; ++n) {
	        var fontOptions = pile[n];
	        if (Object.prototype.hasOwnProperty.call(fontOptions, multiName)) {
	          multiFont = fontOptions[multiName];
	          if (multiFont === undefined || multiFont === null) continue;

	          // Convert shorthand if necessary
	          // TODO: inefficient to do this conversion every time; find a better way.
	          var tmpShorthand = {};
	          if (Label.parseFontString(tmpShorthand, multiFont)) {
	            multiFont = tmpShorthand;
	          }
	          if (Object.prototype.hasOwnProperty.call(multiFont, option)) {
	            return multiFont[option];
	          }
	        }
	      }

	      // Option is not mentioned in the multi font options; take it from the parent font options.
	      // These have already been converted with getBasicOptions(), so use the converted values.
	      if (Object.prototype.hasOwnProperty.call(this.fontOptions, option)) {
	        return this.fontOptions[option];
	      }

	      // A value **must** be found; you should never get here.
	      throw new Error("Did not find value for multi-font for property: '" + option + "'");
	    }

	    /**
	     * Return all options values for the given multi-font.
	     *
	     * All available option objects are trawled in the set order to construct the option values.
	     *
	     * @param {Pile} pile  pile of option objects to use
	     * @param {MultiFontStyle} multiName sub path for the mod-font
	     * @returns {MultiFontOptions}
	     * @private
	     */
	  }, {
	    key: "getFontOptions",
	    value: function getFontOptions(pile, multiName) {
	      var result = {};
	      var optionNames = ["color", "size", "face", "mod", "vadjust"]; // List of allowed options per multi-font

	      for (var i = 0; i < optionNames.length; ++i) {
	        var mod = optionNames[i];
	        result[mod] = this.getFontOption(pile, multiName, mod);
	      }
	      return result;
	    }

	    /////////////////////////////////////////////////////////
	    // End methods for handling options piles
	    /////////////////////////////////////////////////////////

	    /**
	     * Collapse the font options for the multi-font to single objects, from
	     * the chain of option objects passed (the 'pile').
	     *
	     * @param {Pile} pile  sequence of option objects to consider.
	     *                     First item in list assumed to be the newly set options.
	     */
	  }, {
	    key: "propagateFonts",
	    value: function propagateFonts(pile) {
	      var _this2 = this;
	      var fontPile = []; // sequence of font objects to consider, order important

	      // Note that this.elementOptions is not used here.
	      this.addFontOptionsToPile(fontPile, pile);
	      this.fontOptions = this.getBasicOptions(fontPile);

	      // We set multifont values even if multi === false, for consistency (things break otherwise)
	      var _loop = function _loop() {
	        var mod = multiFontStyle[i];
	        var modOptions = _this2.fontOptions[mod];
	        var tmpMultiFontOptions = _this2.getFontOptions(fontPile, mod);

	        // Copy over found values
	        forEach$4(tmpMultiFontOptions, function (option, n) {
	          modOptions[n] = option;
	        });
	        modOptions.size = Number(modOptions.size);
	        modOptions.vadjust = Number(modOptions.vadjust);
	      };
	      for (var i = 0; i < multiFontStyle.length; ++i) {
	        _loop();
	      }
	    }

	    /**
	     * Main function. This is called from anything that wants to draw a label.
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x
	     * @param {number} y
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {string} [baseline='middle']
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover) {
	      var baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : "middle";
	      // if no label, return
	      if (this.elementOptions.label === undefined) return;

	      // check if we have to render the label
	      var viewFontSize = this.fontOptions.size * this.body.view.scale;
	      if (this.elementOptions.label && viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) return;

	      // This ensures that there will not be HUGE letters on screen
	      // by setting an upper limit on the visible text size (regardless of zoomLevel)
	      if (viewFontSize >= this.elementOptions.scaling.label.maxVisible) {
	        viewFontSize = Number(this.elementOptions.scaling.label.maxVisible) / this.body.view.scale;
	      }

	      // update the size cache if required
	      this.calculateLabelSize(ctx, selected, hover, x, y, baseline);
	      this._drawBackground(ctx);
	      this._drawText(ctx, x, this.size.yLine, baseline, viewFontSize);
	    }

	    /**
	     * Draws the label background
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @private
	     */
	  }, {
	    key: "_drawBackground",
	    value: function _drawBackground(ctx) {
	      if (this.fontOptions.background !== undefined && this.fontOptions.background !== "none") {
	        ctx.fillStyle = this.fontOptions.background;
	        var size = this.getSize();
	        ctx.fillRect(size.left, size.top, size.width, size.height);
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x
	     * @param {number} y
	     * @param {string} [baseline='middle']
	     * @param {number} viewFontSize
	     * @private
	     */
	  }, {
	    key: "_drawText",
	    value: function _drawText(ctx, x, y) {
	      var baseline = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "middle";
	      var viewFontSize = arguments.length > 4 ? arguments[4] : undefined;
	      var _this$_setAlignment = this._setAlignment(ctx, x, y, baseline);
	      var _this$_setAlignment2 = _slicedToArray(_this$_setAlignment, 2);
	      x = _this$_setAlignment2[0];
	      y = _this$_setAlignment2[1];
	      ctx.textAlign = "left";
	      x = x - this.size.width / 2; // Shift label 1/2-distance to the left
	      if (this.fontOptions.valign && this.size.height > this.size.labelHeight) {
	        if (this.fontOptions.valign === "top") {
	          y -= (this.size.height - this.size.labelHeight) / 2;
	        }
	        if (this.fontOptions.valign === "bottom") {
	          y += (this.size.height - this.size.labelHeight) / 2;
	        }
	      }

	      // draw the text
	      for (var i = 0; i < this.lineCount; i++) {
	        var line = this.lines[i];
	        if (line && line.blocks) {
	          var width = 0;
	          if (this.isEdgeLabel || this.fontOptions.align === "center") {
	            width += (this.size.width - line.width) / 2;
	          } else if (this.fontOptions.align === "right") {
	            width += this.size.width - line.width;
	          }
	          for (var j = 0; j < line.blocks.length; j++) {
	            var block = line.blocks[j];
	            ctx.font = block.font;
	            var _this$_getColor = this._getColor(block.color, viewFontSize, block.strokeColor),
	              _this$_getColor2 = _slicedToArray(_this$_getColor, 2),
	              fontColor = _this$_getColor2[0],
	              strokeColor = _this$_getColor2[1];
	            if (block.strokeWidth > 0) {
	              ctx.lineWidth = block.strokeWidth;
	              ctx.strokeStyle = strokeColor;
	              ctx.lineJoin = "round";
	            }
	            ctx.fillStyle = fontColor;
	            if (block.strokeWidth > 0) {
	              ctx.strokeText(block.text, x + width, y + block.vadjust);
	            }
	            ctx.fillText(block.text, x + width, y + block.vadjust);
	            width += block.width;
	          }
	          y += line.height;
	        }
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x
	     * @param {number} y
	     * @param {string} baseline
	     * @returns {Array.<number>}
	     * @private
	     */
	  }, {
	    key: "_setAlignment",
	    value: function _setAlignment(ctx, x, y, baseline) {
	      // check for label alignment (for edges)
	      // TODO: make alignment for nodes
	      if (this.isEdgeLabel && this.fontOptions.align !== "horizontal" && this.pointToSelf === false) {
	        x = 0;
	        y = 0;
	        var lineMargin = 2;
	        if (this.fontOptions.align === "top") {
	          ctx.textBaseline = "alphabetic";
	          y -= 2 * lineMargin; // distance from edge, required because we use alphabetic. Alphabetic has less difference between browsers
	        } else if (this.fontOptions.align === "bottom") {
	          ctx.textBaseline = "hanging";
	          y += 2 * lineMargin; // distance from edge, required because we use hanging. Hanging has less difference between browsers
	        } else {
	          ctx.textBaseline = "middle";
	        }
	      } else {
	        ctx.textBaseline = baseline;
	      }
	      return [x, y];
	    }

	    /**
	     * fade in when relative scale is between threshold and threshold - 1.
	     * If the relative scale would be smaller than threshold -1 the draw function would have returned before coming here.
	     *
	     * @param {string} color  The font color to use
	     * @param {number} viewFontSize
	     * @param {string} initialStrokeColor
	     * @returns {Array.<string>} An array containing the font color and stroke color
	     * @private
	     */
	  }, {
	    key: "_getColor",
	    value: function _getColor(color, viewFontSize, initialStrokeColor) {
	      var fontColor = color || "#000000";
	      var strokeColor = initialStrokeColor || "#ffffff";
	      if (viewFontSize <= this.elementOptions.scaling.label.drawThreshold) {
	        var opacity = Math.max(0, Math.min(1, 1 - (this.elementOptions.scaling.label.drawThreshold - viewFontSize)));
	        fontColor = overrideOpacity(fontColor, opacity);
	        strokeColor = overrideOpacity(strokeColor, opacity);
	      }
	      return [fontColor, strokeColor];
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @returns {{width: number, height: number}}
	     */
	  }, {
	    key: "getTextSize",
	    value: function getTextSize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      this._processLabel(ctx, selected, hover);
	      return {
	        width: this.size.width,
	        height: this.size.height,
	        lineCount: this.lineCount
	      };
	    }

	    /**
	     * Get the current dimensions of the label
	     *
	     * @returns {rect}
	     */
	  }, {
	    key: "getSize",
	    value: function getSize() {
	      var lineMargin = 2;
	      var x = this.size.left; // default values which might be overridden below
	      var y = this.size.top - 0.5 * lineMargin; // idem

	      if (this.isEdgeLabel) {
	        var x2 = -this.size.width * 0.5;
	        switch (this.fontOptions.align) {
	          case "middle":
	            x = x2;
	            y = -this.size.height * 0.5;
	            break;
	          case "top":
	            x = x2;
	            y = -(this.size.height + lineMargin);
	            break;
	          case "bottom":
	            x = x2;
	            y = lineMargin;
	            break;
	        }
	      }
	      var ret = {
	        left: x,
	        top: y,
	        width: this.size.width,
	        height: this.size.height
	      };
	      return ret;
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {number} [x=0]
	     * @param {number} [y=0]
	     * @param {'middle'|'hanging'} [baseline='middle']
	     */
	  }, {
	    key: "calculateLabelSize",
	    value: function calculateLabelSize(ctx, selected, hover) {
	      var x = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
	      var y = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
	      var baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : "middle";
	      this._processLabel(ctx, selected, hover);
	      this.size.left = x - this.size.width * 0.5;
	      this.size.top = y - this.size.height * 0.5;
	      this.size.yLine = y + (1 - this.lineCount) * 0.5 * this.fontOptions.size;
	      if (baseline === "hanging") {
	        this.size.top += 0.5 * this.fontOptions.size;
	        this.size.top += 4; // distance from node, required because we use hanging. Hanging has less difference between browsers
	        this.size.yLine += 4; // distance from node
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {string} mod
	     * @returns {{color, size, face, mod, vadjust, strokeWidth: *, strokeColor: (*|string|allOptions.edges.font.strokeColor|{string}|allOptions.nodes.font.strokeColor|Array)}}
	     */
	  }, {
	    key: "getFormattingValues",
	    value: function getFormattingValues(ctx, selected, hover, mod) {
	      var getValue = function getValue(fontOptions, mod, option) {
	        if (mod === "normal") {
	          if (option === "mod") return "";
	          return fontOptions[option];
	        }
	        if (fontOptions[mod][option] !== undefined) {
	          // Grumbl leaving out test on undefined equals false for ""
	          return fontOptions[mod][option];
	        } else {
	          // Take from parent font option
	          return fontOptions[option];
	        }
	      };
	      var values = {
	        color: getValue(this.fontOptions, mod, "color"),
	        size: getValue(this.fontOptions, mod, "size"),
	        face: getValue(this.fontOptions, mod, "face"),
	        mod: getValue(this.fontOptions, mod, "mod"),
	        vadjust: getValue(this.fontOptions, mod, "vadjust"),
	        strokeWidth: this.fontOptions.strokeWidth,
	        strokeColor: this.fontOptions.strokeColor
	      };
	      if (selected || hover) {
	        if (mod === "normal" && this.fontOptions.chooser === true && this.elementOptions.labelHighlightBold) {
	          values.mod = "bold";
	        } else {
	          if (typeof this.fontOptions.chooser === "function") {
	            this.fontOptions.chooser(values, this.elementOptions.id, selected, hover);
	          }
	        }
	      }
	      var fontString = "";
	      if (values.mod !== undefined && values.mod !== "") {
	        // safeguard for undefined - this happened
	        fontString += values.mod + " ";
	      }
	      fontString += values.size + "px " + values.face;
	      ctx.font = fontString.replace(/"/g, "");
	      values.font = ctx.font;
	      values.height = values.size;
	      return values;
	    }

	    /**
	     *
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @returns {boolean}
	     */
	  }, {
	    key: "differentState",
	    value: function differentState(selected, hover) {
	      return selected !== this.selectedState || hover !== this.hoverState;
	    }

	    /**
	     * This explodes the passed text into lines and determines the width, height and number of lines.
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {string} inText  the text to explode
	     * @returns {{width, height, lines}|*}
	     * @private
	     */
	  }, {
	    key: "_processLabelText",
	    value: function _processLabelText(ctx, selected, hover, inText) {
	      var splitter = new LabelSplitter(ctx, this, selected, hover);
	      return splitter.process(inText);
	    }

	    /**
	     * This explodes the label string into lines and sets the width, height and number of lines.
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @private
	     */
	  }, {
	    key: "_processLabel",
	    value: function _processLabel(ctx, selected, hover) {
	      if (this.labelDirty === false && !this.differentState(selected, hover)) return;
	      var state = this._processLabelText(ctx, selected, hover, this.elementOptions.label);
	      if (this.fontOptions.minWdt > 0 && state.width < this.fontOptions.minWdt) {
	        state.width = this.fontOptions.minWdt;
	      }
	      this.size.labelHeight = state.height;
	      if (this.fontOptions.minHgt > 0 && state.height < this.fontOptions.minHgt) {
	        state.height = this.fontOptions.minHgt;
	      }
	      this.lines = state.lines;
	      this.lineCount = state.lines.length;
	      this.size.width = state.width;
	      this.size.height = state.height;
	      this.selectedState = selected;
	      this.hoverState = hover;
	      this.labelDirty = false;
	    }

	    /**
	     * Check if this label is visible
	     *
	     * @returns {boolean} true if this label will be show, false otherwise
	     */
	  }, {
	    key: "visible",
	    value: function visible() {
	      if (this.size.width === 0 || this.size.height === 0 || this.elementOptions.label === undefined) {
	        return false; // nothing to display
	      }

	      var viewFontSize = this.fontOptions.size * this.body.view.scale;
	      if (viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) {
	        return false; // Too small or too far away to show
	      }

	      return true;
	    }
	  }], [{
	    key: "parseFontString",
	    value: function parseFontString(outOptions, inOptions) {
	      if (!inOptions || typeof inOptions !== "string") return false;
	      var newOptionsArray = inOptions.split(" ");
	      outOptions.size = +newOptionsArray[0].replace("px", "");
	      outOptions.face = newOptionsArray[1];
	      outOptions.color = newOptionsArray[2];
	      return true;
	    }
	  }]);
	  return Label;
	}();

	/**
	 * The Base class for all Nodes.
	 */
	var NodeBase = /*#__PURE__*/function () {
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function NodeBase(options, body, labelModule) {
	    _classCallCheck(this, NodeBase);
	    this.body = body;
	    this.labelModule = labelModule;
	    this.setOptions(options);
	    this.top = undefined;
	    this.left = undefined;
	    this.height = undefined;
	    this.width = undefined;
	    this.radius = undefined;
	    this.margin = undefined;
	    this.refreshNeeded = true;
	    this.boundingBox = {
	      top: 0,
	      left: 0,
	      right: 0,
	      bottom: 0
	    };
	  }

	  /**
	   *
	   * @param {object} options
	   */
	  _createClass(NodeBase, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	    }

	    /**
	     *
	     * @param {Label} labelModule
	     * @private
	     */
	  }, {
	    key: "_setMargins",
	    value: function _setMargins(labelModule) {
	      this.margin = {};
	      if (this.options.margin) {
	        if (_typeof$1(this.options.margin) == "object") {
	          this.margin.top = this.options.margin.top;
	          this.margin.right = this.options.margin.right;
	          this.margin.bottom = this.options.margin.bottom;
	          this.margin.left = this.options.margin.left;
	        } else {
	          this.margin.top = this.options.margin;
	          this.margin.right = this.options.margin;
	          this.margin.bottom = this.options.margin;
	          this.margin.left = this.options.margin;
	        }
	      }
	      labelModule.adjustSizes(this.margin);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     * @private
	     */
	  }, {
	    key: "_distanceToBorder",
	    value: function _distanceToBorder(ctx, angle) {
	      var borderWidth = this.options.borderWidth;
	      if (ctx) {
	        this.resize(ctx);
	      }
	      return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "enableShadow",
	    value: function enableShadow(ctx, values) {
	      if (values.shadow) {
	        ctx.shadowColor = values.shadowColor;
	        ctx.shadowBlur = values.shadowSize;
	        ctx.shadowOffsetX = values.shadowX;
	        ctx.shadowOffsetY = values.shadowY;
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "disableShadow",
	    value: function disableShadow(ctx, values) {
	      if (values.shadow) {
	        ctx.shadowColor = "rgba(0,0,0,0)";
	        ctx.shadowBlur = 0;
	        ctx.shadowOffsetX = 0;
	        ctx.shadowOffsetY = 0;
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "enableBorderDashes",
	    value: function enableBorderDashes(ctx, values) {
	      if (values.borderDashes !== false) {
	        if (ctx.setLineDash !== undefined) {
	          var dashes = values.borderDashes;
	          if (dashes === true) {
	            dashes = [5, 15];
	          }
	          ctx.setLineDash(dashes);
	        } else {
	          console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used.");
	          this.options.shapeProperties.borderDashes = false;
	          values.borderDashes = false;
	        }
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "disableBorderDashes",
	    value: function disableBorderDashes(ctx, values) {
	      if (values.borderDashes !== false) {
	        if (ctx.setLineDash !== undefined) {
	          ctx.setLineDash([0]);
	        } else {
	          console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used.");
	          this.options.shapeProperties.borderDashes = false;
	          values.borderDashes = false;
	        }
	      }
	    }

	    /**
	     * Determine if the shape of a node needs to be recalculated.
	     *
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @returns {boolean}
	     * @protected
	     */
	  }, {
	    key: "needsRefresh",
	    value: function needsRefresh(selected, hover) {
	      if (this.refreshNeeded === true) {
	        // This is probably not the best location to reset this member.
	        // However, in the current logic, it is the most convenient one.
	        this.refreshNeeded = false;
	        return true;
	      }
	      return this.width === undefined || this.labelModule.differentState(selected, hover);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "initContextForDraw",
	    value: function initContextForDraw(ctx, values) {
	      var borderWidth = values.borderWidth / this.body.view.scale;
	      ctx.lineWidth = Math.min(this.width, borderWidth);
	      ctx.strokeStyle = values.borderColor;
	      ctx.fillStyle = values.color;
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "performStroke",
	    value: function performStroke(ctx, values) {
	      var borderWidth = values.borderWidth / this.body.view.scale;

	      //draw dashed border if enabled, save and restore is required for firefox not to crash on unix.
	      ctx.save();
	      // if borders are zero width, they will be drawn with width 1 by default. This prevents that
	      if (borderWidth > 0) {
	        this.enableBorderDashes(ctx, values);
	        //draw the border
	        ctx.stroke();
	        //disable dashed border for other elements
	        this.disableBorderDashes(ctx, values);
	      }
	      ctx.restore();
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "performFill",
	    value: function performFill(ctx, values) {
	      ctx.save();
	      ctx.fillStyle = values.color;
	      // draw shadow if enabled
	      this.enableShadow(ctx, values);
	      // draw the background
	      _fillInstanceProperty(ctx).call(ctx);
	      // disable shadows for other elements.
	      this.disableShadow(ctx, values);
	      ctx.restore();
	      this.performStroke(ctx, values);
	    }

	    /**
	     *
	     * @param {number} margin
	     * @private
	     */
	  }, {
	    key: "_addBoundingBoxMargin",
	    value: function _addBoundingBoxMargin(margin) {
	      this.boundingBox.left -= margin;
	      this.boundingBox.top -= margin;
	      this.boundingBox.bottom += margin;
	      this.boundingBox.right += margin;
	    }

	    /**
	     * Actual implementation of this method call.
	     *
	     * Doing it like this makes it easier to override
	     * in the child classes.
	     *
	     * @param {number} x width
	     * @param {number} y height
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @private
	     */
	  }, {
	    key: "_updateBoundingBox",
	    value: function _updateBoundingBox(x, y, ctx, selected, hover) {
	      if (ctx !== undefined) {
	        this.resize(ctx, selected, hover);
	      }
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this.boundingBox.left = this.left;
	      this.boundingBox.top = this.top;
	      this.boundingBox.bottom = this.top + this.height;
	      this.boundingBox.right = this.left + this.width;
	    }

	    /**
	     * Default implementation of this method call.
	     * This acts as a stub which can be overridden.
	     *
	     * @param {number} x width
	     * @param {number} y height
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     */
	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y, ctx, selected, hover) {
	      this._updateBoundingBox(x, y, ctx, selected, hover);
	    }

	    /**
	     * Determine the dimensions to use for nodes with an internal label
	     *
	     * Currently, these are: Circle, Ellipse, Database, Box
	     * The other nodes have external labels, and will not call this method
	     *
	     * If there is no label, decent default values are supplied.
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} [selected]
	     * @param {boolean} [hover]
	     * @returns {{width:number, height:number}}
	     */
	  }, {
	    key: "getDimensionsFromLabel",
	    value: function getDimensionsFromLabel(ctx, selected, hover) {
	      // NOTE: previously 'textSize' was not put in 'this' for Ellipse
	      // TODO: examine the consequences.
	      this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
	      var width = this.textSize.width;
	      var height = this.textSize.height;
	      var DEFAULT_SIZE = 14;
	      if (width === 0) {
	        // This happens when there is no label text set
	        width = DEFAULT_SIZE; // use a decent default
	        height = DEFAULT_SIZE; // if width zero, then height also always zero
	      }

	      return {
	        width: width,
	        height: height
	      };
	    }
	  }]);
	  return NodeBase;
	}();

	function _createSuper$s(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$s(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$s() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Box Node/Cluster shape.
	 *
	 * @augments NodeBase
	 */
	var Box$1 = /*#__PURE__*/function (_NodeBase) {
	  _inherits(Box, _NodeBase);
	  var _super = _createSuper$s(Box);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Box(options, body, labelModule) {
	    var _this;
	    _classCallCheck(this, Box);
	    _this = _super.call(this, options, body, labelModule);
	    _this._setMargins(labelModule);
	    return _this;
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */
	  _createClass(Box, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
	      if (this.needsRefresh(selected, hover)) {
	        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
	        this.width = dimensions.width + this.margin.right + this.margin.left;
	        this.height = dimensions.height + this.margin.top + this.margin.bottom;
	        this.radius = this.width / 2;
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this.initContextForDraw(ctx, values);
	      drawRoundRect(ctx, this.left, this.top, this.width, this.height, values.borderRadius);
	      this.performFill(ctx, values);
	      this.updateBoundingBox(x, y, ctx, selected, hover);
	      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
	    }

	    /**
	     *
	     * @param {number} x width
	     * @param {number} y height
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     */
	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y, ctx, selected, hover) {
	      this._updateBoundingBox(x, y, ctx, selected, hover);
	      var borderRadius = this.options.shapeProperties.borderRadius; // only effective for box
	      this._addBoundingBoxMargin(borderRadius);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      if (ctx) {
	        this.resize(ctx);
	      }
	      var borderWidth = this.options.borderWidth;
	      return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
	    }
	  }]);
	  return Box;
	}(NodeBase);

	function _createSuper$r(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$r(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$r() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * NOTE: This is a bad base class
	 *
	 * Child classes are:
	 *
	 *   Image       - uses *only* image methods
	 *   Circle      - uses *only* _drawRawCircle
	 *   CircleImage - uses all
	 *
	 * TODO: Refactor, move _drawRawCircle to different module, derive Circle from NodeBase
	 *       Rename this to ImageBase
	 *       Consolidate common code in Image and CircleImage to base class
	 *
	 * @augments NodeBase
	 */
	var CircleImageBase = /*#__PURE__*/function (_NodeBase) {
	  _inherits(CircleImageBase, _NodeBase);
	  var _super = _createSuper$r(CircleImageBase);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function CircleImageBase(options, body, labelModule) {
	    var _this;
	    _classCallCheck(this, CircleImageBase);
	    _this = _super.call(this, options, body, labelModule);
	    _this.labelOffset = 0;
	    _this.selected = false;
	    return _this;
	  }

	  /**
	   *
	   * @param {object} options
	   * @param {object} [imageObj]
	   * @param {object} [imageObjAlt]
	   */
	  _createClass(CircleImageBase, [{
	    key: "setOptions",
	    value: function setOptions(options, imageObj, imageObjAlt) {
	      this.options = options;
	      if (!(imageObj === undefined && imageObjAlt === undefined)) {
	        this.setImages(imageObj, imageObjAlt);
	      }
	    }

	    /**
	     * Set the images for this node.
	     *
	     * The images can be updated after the initial setting of options;
	     * therefore, this method needs to be reentrant.
	     *
	     * For correct working in error cases, it is necessary to properly set
	     * field 'nodes.brokenImage' in the options.
	     *
	     * @param {Image} imageObj  required; main image to show for this node
	     * @param {Image|undefined} imageObjAlt optional; image to show when node is selected
	     */
	  }, {
	    key: "setImages",
	    value: function setImages(imageObj, imageObjAlt) {
	      if (imageObjAlt && this.selected) {
	        this.imageObj = imageObjAlt;
	        this.imageObjAlt = imageObj;
	      } else {
	        this.imageObj = imageObj;
	        this.imageObjAlt = imageObjAlt;
	      }
	    }

	    /**
	     * Set selection and switch between the base and the selected image.
	     *
	     * Do the switch only if imageObjAlt exists.
	     *
	     * @param {boolean} selected value of new selected state for current node
	     */
	  }, {
	    key: "switchImages",
	    value: function switchImages(selected) {
	      var selection_changed = selected && !this.selected || !selected && this.selected;
	      this.selected = selected; // Remember new selection

	      if (this.imageObjAlt !== undefined && selection_changed) {
	        var imageTmp = this.imageObj;
	        this.imageObj = this.imageObjAlt;
	        this.imageObjAlt = imageTmp;
	      }
	    }

	    /**
	     * Returns Image Padding from node options
	     *
	     * @returns {{top: number,left: number,bottom: number,right: number}} image padding inside this shape
	     * @private
	     */
	  }, {
	    key: "_getImagePadding",
	    value: function _getImagePadding() {
	      var imgPadding = {
	        top: 0,
	        right: 0,
	        bottom: 0,
	        left: 0
	      };
	      if (this.options.imagePadding) {
	        var optImgPadding = this.options.imagePadding;
	        if (_typeof$1(optImgPadding) == "object") {
	          imgPadding.top = optImgPadding.top;
	          imgPadding.right = optImgPadding.right;
	          imgPadding.bottom = optImgPadding.bottom;
	          imgPadding.left = optImgPadding.left;
	        } else {
	          imgPadding.top = optImgPadding;
	          imgPadding.right = optImgPadding;
	          imgPadding.bottom = optImgPadding;
	          imgPadding.left = optImgPadding;
	        }
	      }
	      return imgPadding;
	    }

	    /**
	     * Adjust the node dimensions for a loaded image.
	     *
	     * Pre: this.imageObj is valid
	     */
	  }, {
	    key: "_resizeImage",
	    value: function _resizeImage() {
	      var width, height;
	      if (this.options.shapeProperties.useImageSize === false) {
	        // Use the size property
	        var ratio_width = 1;
	        var ratio_height = 1;

	        // Only calculate the proper ratio if both width and height not zero
	        if (this.imageObj.width && this.imageObj.height) {
	          if (this.imageObj.width > this.imageObj.height) {
	            ratio_width = this.imageObj.width / this.imageObj.height;
	          } else {
	            ratio_height = this.imageObj.height / this.imageObj.width;
	          }
	        }
	        width = this.options.size * 2 * ratio_width;
	        height = this.options.size * 2 * ratio_height;
	      } else {
	        // Use the image size with image padding
	        var imgPadding = this._getImagePadding();
	        width = this.imageObj.width + imgPadding.left + imgPadding.right;
	        height = this.imageObj.height + imgPadding.top + imgPadding.bottom;
	      }
	      this.width = width;
	      this.height = height;
	      this.radius = 0.5 * this.width;
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {ArrowOptions} values
	     * @private
	     */
	  }, {
	    key: "_drawRawCircle",
	    value: function _drawRawCircle(ctx, x, y, values) {
	      this.initContextForDraw(ctx, values);
	      drawCircle(ctx, x, y, values.size);
	      this.performFill(ctx, values);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     * @private
	     */
	  }, {
	    key: "_drawImageAtPosition",
	    value: function _drawImageAtPosition(ctx, values) {
	      if (this.imageObj.width != 0) {
	        // draw the image
	        ctx.globalAlpha = values.opacity !== undefined ? values.opacity : 1;

	        // draw shadow if enabled
	        this.enableShadow(ctx, values);
	        var factor = 1;
	        if (this.options.shapeProperties.interpolation === true) {
	          factor = this.imageObj.width / this.width / this.body.view.scale;
	        }
	        var imgPadding = this._getImagePadding();
	        var imgPosLeft = this.left + imgPadding.left;
	        var imgPosTop = this.top + imgPadding.top;
	        var imgWidth = this.width - imgPadding.left - imgPadding.right;
	        var imgHeight = this.height - imgPadding.top - imgPadding.bottom;
	        this.imageObj.drawImageAtPosition(ctx, factor, imgPosLeft, imgPosTop, imgWidth, imgHeight);

	        // disable shadows for other elements.
	        this.disableShadow(ctx, values);
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @private
	     */
	  }, {
	    key: "_drawImageLabel",
	    value: function _drawImageLabel(ctx, x, y, selected, hover) {
	      var offset = 0;
	      if (this.height !== undefined) {
	        offset = this.height * 0.5;
	        var labelDimensions = this.labelModule.getTextSize(ctx, selected, hover);
	        if (labelDimensions.lineCount >= 1) {
	          offset += labelDimensions.height / 2;
	        }
	      }
	      var yLabel = y + offset;
	      if (this.options.label) {
	        this.labelOffset = offset;
	      }
	      this.labelModule.draw(ctx, x, yLabel, selected, hover, "hanging");
	    }
	  }]);
	  return CircleImageBase;
	}(NodeBase);

	function _createSuper$q(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$q(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$q() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Circle Node/Cluster shape.
	 *
	 * @augments CircleImageBase
	 */
	var Circle$1 = /*#__PURE__*/function (_CircleImageBase) {
	  _inherits(Circle, _CircleImageBase);
	  var _super = _createSuper$q(Circle);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Circle(options, body, labelModule) {
	    var _this;
	    _classCallCheck(this, Circle);
	    _this = _super.call(this, options, body, labelModule);
	    _this._setMargins(labelModule);
	    return _this;
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */
	  _createClass(Circle, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
	      if (this.needsRefresh(selected, hover)) {
	        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
	        var diameter = Math.max(dimensions.width + this.margin.right + this.margin.left, dimensions.height + this.margin.top + this.margin.bottom);
	        this.options.size = diameter / 2; // NOTE: this size field only set here, not in Ellipse, Database, Box
	        this.width = diameter;
	        this.height = diameter;
	        this.radius = this.width / 2;
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this._drawRawCircle(ctx, x, y, values);
	      this.updateBoundingBox(x, y);
	      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, y, selected, hover);
	    }

	    /**
	     *
	     * @param {number} x width
	     * @param {number} y height
	     */
	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      this.boundingBox.top = y - this.options.size;
	      this.boundingBox.left = x - this.options.size;
	      this.boundingBox.right = x + this.options.size;
	      this.boundingBox.bottom = y + this.options.size;
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx) {
	      if (ctx) {
	        this.resize(ctx);
	      }
	      return this.width * 0.5;
	    }
	  }]);
	  return Circle;
	}(CircleImageBase);

	function _createSuper$p(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$p(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$p() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A CircularImage Node/Cluster shape.
	 *
	 * @augments CircleImageBase
	 */
	var CircularImage = /*#__PURE__*/function (_CircleImageBase) {
	  _inherits(CircularImage, _CircleImageBase);
	  var _super = _createSuper$p(CircularImage);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   * @param {Image} imageObj
	   * @param {Image} imageObjAlt
	   */
	  function CircularImage(options, body, labelModule, imageObj, imageObjAlt) {
	    var _this;
	    _classCallCheck(this, CircularImage);
	    _this = _super.call(this, options, body, labelModule);
	    _this.setImages(imageObj, imageObjAlt);
	    return _this;
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */
	  _createClass(CircularImage, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
	      var imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;
	      if (imageAbsent) {
	        var diameter = this.options.size * 2;
	        this.width = diameter;
	        this.height = diameter;
	        this.radius = 0.5 * this.width;
	        return;
	      }

	      // At this point, an image is present, i.e. this.imageObj is valid.
	      if (this.needsRefresh(selected, hover)) {
	        this._resizeImage();
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.switchImages(selected);
	      this.resize();
	      var labelX = x,
	        labelY = y;
	      if (this.options.shapeProperties.coordinateOrigin === "top-left") {
	        this.left = x;
	        this.top = y;
	        labelX += this.width / 2;
	        labelY += this.height / 2;
	      } else {
	        this.left = x - this.width / 2;
	        this.top = y - this.height / 2;
	      }

	      // draw the background circle. IMPORTANT: the stroke in this method is used by the clip method below.
	      this._drawRawCircle(ctx, labelX, labelY, values);

	      // now we draw in the circle, we save so we can revert the clip operation after drawing.
	      ctx.save();
	      // clip is used to use the stroke in drawRawCircle as an area that we can draw in.
	      ctx.clip();
	      // draw the image
	      this._drawImageAtPosition(ctx, values);
	      // restore so we can again draw on the full canvas
	      ctx.restore();
	      this._drawImageLabel(ctx, labelX, labelY, selected, hover);
	      this.updateBoundingBox(x, y);
	    }

	    // TODO: compare with Circle.updateBoundingBox(), consolidate? More stuff is happening here
	    /**
	     *
	     * @param {number} x width
	     * @param {number} y height
	     */
	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      if (this.options.shapeProperties.coordinateOrigin === "top-left") {
	        this.boundingBox.top = y;
	        this.boundingBox.left = x;
	        this.boundingBox.right = x + this.options.size * 2;
	        this.boundingBox.bottom = y + this.options.size * 2;
	      } else {
	        this.boundingBox.top = y - this.options.size;
	        this.boundingBox.left = x - this.options.size;
	        this.boundingBox.right = x + this.options.size;
	        this.boundingBox.bottom = y + this.options.size;
	      }

	      // TODO: compare with Image.updateBoundingBox(), consolidate?
	      this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
	      this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
	      this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx) {
	      if (ctx) {
	        this.resize(ctx);
	      }
	      return this.width * 0.5;
	    }
	  }]);
	  return CircularImage;
	}(CircleImageBase);

	function _createSuper$o(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$o(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$o() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * Base class for constructing Node/Cluster Shapes.
	 *
	 * @augments NodeBase
	 */
	var ShapeBase = /*#__PURE__*/function (_NodeBase) {
	  _inherits(ShapeBase, _NodeBase);
	  var _super = _createSuper$o(ShapeBase);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function ShapeBase(options, body, labelModule) {
	    _classCallCheck(this, ShapeBase);
	    return _super.call(this, options, body, labelModule);
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   * @param {object} [values={size: this.options.size}]
	   */
	  _createClass(ShapeBase, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
	      var values = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {
	        size: this.options.size
	      };
	      if (this.needsRefresh(selected, hover)) {
	        var _this$customSizeWidth, _this$customSizeHeigh;
	        this.labelModule.getTextSize(ctx, selected, hover);
	        var size = 2 * values.size;
	        this.width = (_this$customSizeWidth = this.customSizeWidth) !== null && _this$customSizeWidth !== void 0 ? _this$customSizeWidth : size;
	        this.height = (_this$customSizeHeigh = this.customSizeHeight) !== null && _this$customSizeHeigh !== void 0 ? _this$customSizeHeigh : size;
	        this.radius = 0.5 * this.width;
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {string} shape
	     * @param {number} sizeMultiplier - Unused! TODO: Remove next major release
	     * @param {number} x
	     * @param {number} y
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     * @private
	     * @returns {object} Callbacks to draw later on higher layers.
	     */
	  }, {
	    key: "_drawShape",
	    value: function _drawShape(ctx, shape, sizeMultiplier, x, y, selected, hover, values) {
	      var _this = this;
	      this.resize(ctx, selected, hover, values);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this.initContextForDraw(ctx, values);
	      getShape(shape)(ctx, x, y, values.size);
	      this.performFill(ctx, values);
	      if (this.options.icon !== undefined) {
	        if (this.options.icon.code !== undefined) {
	          ctx.font = (selected ? "bold " : "") + this.height / 2 + "px " + (this.options.icon.face || "FontAwesome");
	          ctx.fillStyle = this.options.icon.color || "black";
	          ctx.textAlign = "center";
	          ctx.textBaseline = "middle";
	          ctx.fillText(this.options.icon.code, x, y);
	        }
	      }
	      return {
	        drawExternalLabel: function drawExternalLabel() {
	          if (_this.options.label !== undefined) {
	            // Need to call following here in order to ensure value for
	            // `this.labelModule.size.height`.
	            _this.labelModule.calculateLabelSize(ctx, selected, hover, x, y, "hanging");
	            var yLabel = y + 0.5 * _this.height + 0.5 * _this.labelModule.size.height;
	            _this.labelModule.draw(ctx, x, yLabel, selected, hover, "hanging");
	          }
	          _this.updateBoundingBox(x, y);
	        }
	      };
	    }

	    /**
	     *
	     * @param {number} x
	     * @param {number} y
	     */
	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      this.boundingBox.top = y - this.options.size;
	      this.boundingBox.left = x - this.options.size;
	      this.boundingBox.right = x + this.options.size;
	      this.boundingBox.bottom = y + this.options.size;
	      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
	        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
	        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
	        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height);
	      }
	    }
	  }]);
	  return ShapeBase;
	}(NodeBase);

	function ownKeys$3(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols) { var o = _Object$getOwnPropertySymbols(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor$1(e, r).enumerable; })), t.push.apply(t, o); } return t; }
	function _objectSpread$3(e) { for (var r = 1; r < arguments.length; r++) { var _context, _context2; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context = ownKeys$3(Object(t), !0)).call(_context, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context2 = ownKeys$3(Object(t))).call(_context2, function (r) { _Object$defineProperty(e, r, _Object$getOwnPropertyDescriptor$1(t, r)); }); } return e; }
	function _createSuper$n(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$n(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$n() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A CustomShape Node/Cluster shape.
	 *
	 * @augments ShapeBase
	 */
	var CustomShape = /*#__PURE__*/function (_ShapeBase) {
	  _inherits(CustomShape, _ShapeBase);
	  var _super = _createSuper$n(CustomShape);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   * @param {Function} ctxRenderer
	   */
	  function CustomShape(options, body, labelModule, ctxRenderer) {
	    var _this;
	    _classCallCheck(this, CustomShape);
	    _this = _super.call(this, options, body, labelModule, ctxRenderer);
	    _this.ctxRenderer = ctxRenderer;
	    return _this;
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   * @returns {object} Callbacks to draw later on different layers.
	   */
	  _createClass(CustomShape, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover, values);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;

	      // Guard right away because someone may just draw in the function itself.
	      ctx.save();
	      var drawLater = this.ctxRenderer({
	        ctx: ctx,
	        id: this.options.id,
	        x: x,
	        y: y,
	        state: {
	          selected: selected,
	          hover: hover
	        },
	        style: _objectSpread$3({}, values),
	        label: this.options.label
	      });
	      // Render the node shape bellow arrows.
	      if (drawLater.drawNode != null) {
	        drawLater.drawNode();
	      }
	      ctx.restore();
	      if (drawLater.drawExternalLabel) {
	        // Guard the external label (above arrows) drawing function.
	        var drawExternalLabel = drawLater.drawExternalLabel;
	        drawLater.drawExternalLabel = function () {
	          ctx.save();
	          drawExternalLabel();
	          ctx.restore();
	        };
	      }
	      if (drawLater.nodeDimensions) {
	        this.customSizeWidth = drawLater.nodeDimensions.width;
	        this.customSizeHeight = drawLater.nodeDimensions.height;
	      }
	      return drawLater;
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return CustomShape;
	}(ShapeBase);

	function _createSuper$m(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$m(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$m() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Database Node/Cluster shape.
	 *
	 * @augments NodeBase
	 */
	var Database = /*#__PURE__*/function (_NodeBase) {
	  _inherits(Database, _NodeBase);
	  var _super = _createSuper$m(Database);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Database(options, body, labelModule) {
	    var _this;
	    _classCallCheck(this, Database);
	    _this = _super.call(this, options, body, labelModule);
	    _this._setMargins(labelModule);
	    return _this;
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} selected
	   * @param {boolean} hover
	   */
	  _createClass(Database, [{
	    key: "resize",
	    value: function resize(ctx, selected, hover) {
	      if (this.needsRefresh(selected, hover)) {
	        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
	        var size = dimensions.width + this.margin.right + this.margin.left;
	        this.width = size;
	        this.height = size;
	        this.radius = this.width / 2;
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this.initContextForDraw(ctx, values);
	      drawDatabase(ctx, x - this.width / 2, y - this.height / 2, this.width, this.height);
	      this.performFill(ctx, values);
	      this.updateBoundingBox(x, y, ctx, selected, hover);
	      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return Database;
	}(NodeBase);

	function _createSuper$l(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$l(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$l() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Diamond Node/Cluster shape.
	 *
	 * @augments ShapeBase
	 */
	var Diamond$1 = /*#__PURE__*/function (_ShapeBase) {
	  _inherits(Diamond, _ShapeBase);
	  var _super = _createSuper$l(Diamond);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Diamond(options, body, labelModule) {
	    _classCallCheck(this, Diamond);
	    return _super.call(this, options, body, labelModule);
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   * @returns {object} Callbacks to draw later on higher layers.
	   */
	  _createClass(Diamond, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      return this._drawShape(ctx, "diamond", 4, x, y, selected, hover, values);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return Diamond;
	}(ShapeBase);

	function _createSuper$k(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$k(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$k() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Dot Node/Cluster shape.
	 *
	 * @augments ShapeBase
	 */
	var Dot = /*#__PURE__*/function (_ShapeBase) {
	  _inherits(Dot, _ShapeBase);
	  var _super = _createSuper$k(Dot);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Dot(options, body, labelModule) {
	    _classCallCheck(this, Dot);
	    return _super.call(this, options, body, labelModule);
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   * @returns {object} Callbacks to draw later on higher layers.
	   */
	  _createClass(Dot, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      return this._drawShape(ctx, "circle", 2, x, y, selected, hover, values);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx) {
	      if (ctx) {
	        this.resize(ctx);
	      }
	      return this.options.size;
	    }
	  }]);
	  return Dot;
	}(ShapeBase);

	function _createSuper$j(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$j(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$j() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * Am Ellipse Node/Cluster shape.
	 *
	 * @augments NodeBase
	 */
	var Ellipse = /*#__PURE__*/function (_NodeBase) {
	  _inherits(Ellipse, _NodeBase);
	  var _super = _createSuper$j(Ellipse);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Ellipse(options, body, labelModule) {
	    _classCallCheck(this, Ellipse);
	    return _super.call(this, options, body, labelModule);
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */
	  _createClass(Ellipse, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
	      if (this.needsRefresh(selected, hover)) {
	        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
	        this.height = dimensions.height * 2;
	        this.width = dimensions.width + dimensions.height;
	        this.radius = 0.5 * this.width;
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width * 0.5;
	      this.top = y - this.height * 0.5;
	      this.initContextForDraw(ctx, values);
	      drawEllipse(ctx, this.left, this.top, this.width, this.height);
	      this.performFill(ctx, values);
	      this.updateBoundingBox(x, y, ctx, selected, hover);
	      this.labelModule.draw(ctx, x, y, selected, hover);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      if (ctx) {
	        this.resize(ctx);
	      }
	      var a = this.width * 0.5;
	      var b = this.height * 0.5;
	      var w = Math.sin(angle) * a;
	      var h = Math.cos(angle) * b;
	      return a * b / Math.sqrt(w * w + h * h);
	    }
	  }]);
	  return Ellipse;
	}(NodeBase);

	function _createSuper$i(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$i(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$i() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * An icon replacement for the default Node shape.
	 *
	 * @augments NodeBase
	 */
	var Icon = /*#__PURE__*/function (_NodeBase) {
	  _inherits(Icon, _NodeBase);
	  var _super = _createSuper$i(Icon);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Icon(options, body, labelModule) {
	    var _this;
	    _classCallCheck(this, Icon);
	    _this = _super.call(this, options, body, labelModule);
	    _this._setMargins(labelModule);
	    return _this;
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx - Unused.
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */
	  _createClass(Icon, [{
	    key: "resize",
	    value: function resize(ctx, selected, hover) {
	      if (this.needsRefresh(selected, hover)) {
	        this.iconSize = {
	          width: Number(this.options.icon.size),
	          height: Number(this.options.icon.size)
	        };
	        this.width = this.iconSize.width + this.margin.right + this.margin.left;
	        this.height = this.iconSize.height + this.margin.top + this.margin.bottom;
	        this.radius = 0.5 * this.width;
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     * @returns {object} Callbacks to draw later on higher layers.
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      var _this2 = this;
	      this.resize(ctx, selected, hover);
	      this.options.icon.size = this.options.icon.size || 50;
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this._icon(ctx, x, y, selected, hover, values);
	      return {
	        drawExternalLabel: function drawExternalLabel() {
	          if (_this2.options.label !== undefined) {
	            var iconTextSpacing = 5;
	            _this2.labelModule.draw(ctx, _this2.left + _this2.iconSize.width / 2 + _this2.margin.left, y + _this2.height / 2 + iconTextSpacing, selected);
	          }
	          _this2.updateBoundingBox(x, y);
	        }
	      };
	    }

	    /**
	     *
	     * @param {number} x
	     * @param {number} y
	     */
	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      this.boundingBox.top = y - this.options.icon.size * 0.5;
	      this.boundingBox.left = x - this.options.icon.size * 0.5;
	      this.boundingBox.right = x + this.options.icon.size * 0.5;
	      this.boundingBox.bottom = y + this.options.icon.size * 0.5;
	      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
	        var iconTextSpacing = 5;
	        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
	        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
	        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height + iconTextSpacing);
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover - Unused
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "_icon",
	    value: function _icon(ctx, x, y, selected, hover, values) {
	      var iconSize = Number(this.options.icon.size);
	      if (this.options.icon.code !== undefined) {
	        ctx.font = [this.options.icon.weight != null ? this.options.icon.weight : selected ? "bold" : "",
	        // If the weight is forced (for example to make Font Awesome 5 work
	        // properly) substitute slightly bigger size for bold font face.
	        (this.options.icon.weight != null && selected ? 5 : 0) + iconSize + "px", this.options.icon.face].join(" ");

	        // draw icon
	        ctx.fillStyle = this.options.icon.color || "black";
	        ctx.textAlign = "center";
	        ctx.textBaseline = "middle";

	        // draw shadow if enabled
	        this.enableShadow(ctx, values);
	        ctx.fillText(this.options.icon.code, x, y);

	        // disable shadows for other elements.
	        this.disableShadow(ctx, values);
	      } else {
	        console.error("When using the icon shape, you need to define the code in the icon options object. This can be done per node or globally.");
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return Icon;
	}(NodeBase);

	function _createSuper$h(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$h(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$h() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * An image-based replacement for the default Node shape.
	 *
	 * @augments CircleImageBase
	 */
	var Image$2 = /*#__PURE__*/function (_CircleImageBase) {
	  _inherits(Image, _CircleImageBase);
	  var _super = _createSuper$h(Image);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   * @param {Image} imageObj
	   * @param {Image} imageObjAlt
	   */
	  function Image(options, body, labelModule, imageObj, imageObjAlt) {
	    var _this;
	    _classCallCheck(this, Image);
	    _this = _super.call(this, options, body, labelModule);
	    _this.setImages(imageObj, imageObjAlt);
	    return _this;
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx - Unused.
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */
	  _createClass(Image, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
	      var imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;
	      if (imageAbsent) {
	        var side = this.options.size * 2;
	        this.width = side;
	        this.height = side;
	        return;
	      }
	      if (this.needsRefresh(selected, hover)) {
	        this._resizeImage();
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      ctx.save();
	      this.switchImages(selected);
	      this.resize();
	      var labelX = x,
	        labelY = y;
	      if (this.options.shapeProperties.coordinateOrigin === "top-left") {
	        this.left = x;
	        this.top = y;
	        labelX += this.width / 2;
	        labelY += this.height / 2;
	      } else {
	        this.left = x - this.width / 2;
	        this.top = y - this.height / 2;
	      }
	      if (this.options.shapeProperties.useBorderWithImage === true) {
	        var neutralborderWidth = this.options.borderWidth;
	        var selectionLineWidth = this.options.borderWidthSelected || 2 * this.options.borderWidth;
	        var borderWidth = (selected ? selectionLineWidth : neutralborderWidth) / this.body.view.scale;
	        ctx.lineWidth = Math.min(this.width, borderWidth);
	        ctx.beginPath();
	        var strokeStyle = selected ? this.options.color.highlight.border : hover ? this.options.color.hover.border : this.options.color.border;
	        var fillStyle = selected ? this.options.color.highlight.background : hover ? this.options.color.hover.background : this.options.color.background;
	        if (values.opacity !== undefined) {
	          strokeStyle = overrideOpacity(strokeStyle, values.opacity);
	          fillStyle = overrideOpacity(fillStyle, values.opacity);
	        }
	        // setup the line properties.
	        ctx.strokeStyle = strokeStyle;

	        // set a fillstyle
	        ctx.fillStyle = fillStyle;

	        // draw a rectangle to form the border around. This rectangle is filled so the opacity of a picture (in future vis releases?) can be used to tint the image
	        ctx.rect(this.left - 0.5 * ctx.lineWidth, this.top - 0.5 * ctx.lineWidth, this.width + ctx.lineWidth, this.height + ctx.lineWidth);
	        _fillInstanceProperty(ctx).call(ctx);
	        this.performStroke(ctx, values);
	        ctx.closePath();
	      }
	      this._drawImageAtPosition(ctx, values);
	      this._drawImageLabel(ctx, labelX, labelY, selected, hover);
	      this.updateBoundingBox(x, y);
	      ctx.restore();
	    }

	    /**
	     *
	     * @param {number} x
	     * @param {number} y
	     */
	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      this.resize();
	      if (this.options.shapeProperties.coordinateOrigin === "top-left") {
	        this.left = x;
	        this.top = y;
	      } else {
	        this.left = x - this.width / 2;
	        this.top = y - this.height / 2;
	      }
	      this.boundingBox.left = this.left;
	      this.boundingBox.top = this.top;
	      this.boundingBox.bottom = this.top + this.height;
	      this.boundingBox.right = this.left + this.width;
	      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
	        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
	        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
	        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return Image;
	}(CircleImageBase);

	function _createSuper$g(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$g(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$g() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Square Node/Cluster shape.
	 *
	 * @augments ShapeBase
	 */
	var Square = /*#__PURE__*/function (_ShapeBase) {
	  _inherits(Square, _ShapeBase);
	  var _super = _createSuper$g(Square);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Square(options, body, labelModule) {
	    _classCallCheck(this, Square);
	    return _super.call(this, options, body, labelModule);
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   * @returns {object} Callbacks to draw later on higher layers.
	   */
	  _createClass(Square, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      return this._drawShape(ctx, "square", 2, x, y, selected, hover, values);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return Square;
	}(ShapeBase);

	function _createSuper$f(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$f(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$f() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Hexagon Node/Cluster shape.
	 *
	 * @augments ShapeBase
	 */
	var Hexagon = /*#__PURE__*/function (_ShapeBase) {
	  _inherits(Hexagon, _ShapeBase);
	  var _super = _createSuper$f(Hexagon);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Hexagon(options, body, labelModule) {
	    _classCallCheck(this, Hexagon);
	    return _super.call(this, options, body, labelModule);
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   * @returns {object} Callbacks to draw later on higher layers.
	   */
	  _createClass(Hexagon, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      return this._drawShape(ctx, "hexagon", 4, x, y, selected, hover, values);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return Hexagon;
	}(ShapeBase);

	function _createSuper$e(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$e(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$e() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Star Node/Cluster shape.
	 *
	 * @augments ShapeBase
	 */
	var Star = /*#__PURE__*/function (_ShapeBase) {
	  _inherits(Star, _ShapeBase);
	  var _super = _createSuper$e(Star);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Star(options, body, labelModule) {
	    _classCallCheck(this, Star);
	    return _super.call(this, options, body, labelModule);
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   * @returns {object} Callbacks to draw later on higher layers.
	   */
	  _createClass(Star, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      return this._drawShape(ctx, "star", 4, x, y, selected, hover, values);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return Star;
	}(ShapeBase);

	function _createSuper$d(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$d(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$d() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A text-based replacement for the default Node shape.
	 *
	 * @augments NodeBase
	 */
	var Text = /*#__PURE__*/function (_NodeBase) {
	  _inherits(Text, _NodeBase);
	  var _super = _createSuper$d(Text);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Text(options, body, labelModule) {
	    var _this;
	    _classCallCheck(this, Text);
	    _this = _super.call(this, options, body, labelModule);
	    _this._setMargins(labelModule);
	    return _this;
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} selected
	   * @param {boolean} hover
	   */
	  _createClass(Text, [{
	    key: "resize",
	    value: function resize(ctx, selected, hover) {
	      if (this.needsRefresh(selected, hover)) {
	        this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
	        this.width = this.textSize.width + this.margin.right + this.margin.left;
	        this.height = this.textSize.height + this.margin.top + this.margin.bottom;
	        this.radius = 0.5 * this.width;
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;

	      // draw shadow if enabled
	      this.enableShadow(ctx, values);
	      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);

	      // disable shadows for other elements.
	      this.disableShadow(ctx, values);
	      this.updateBoundingBox(x, y, ctx, selected, hover);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return Text;
	}(NodeBase);

	function _createSuper$c(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$c(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$c() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Triangle Node/Cluster shape.
	 *
	 * @augments ShapeBase
	 */
	var Triangle$1 = /*#__PURE__*/function (_ShapeBase) {
	  _inherits(Triangle, _ShapeBase);
	  var _super = _createSuper$c(Triangle);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function Triangle(options, body, labelModule) {
	    _classCallCheck(this, Triangle);
	    return _super.call(this, options, body, labelModule);
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x
	   * @param {number} y
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   * @returns {object} Callbacks to draw later on higher layers.
	   */
	  _createClass(Triangle, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      return this._drawShape(ctx, "triangle", 3, x, y, selected, hover, values);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return Triangle;
	}(ShapeBase);

	function _createSuper$b(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$b(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$b() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A downward facing Triangle Node/Cluster shape.
	 *
	 * @augments ShapeBase
	 */
	var TriangleDown = /*#__PURE__*/function (_ShapeBase) {
	  _inherits(TriangleDown, _ShapeBase);
	  var _super = _createSuper$b(TriangleDown);
	  /**
	   * @param {object} options
	   * @param {object} body
	   * @param {Label} labelModule
	   */
	  function TriangleDown(options, body, labelModule) {
	    _classCallCheck(this, TriangleDown);
	    return _super.call(this, options, body, labelModule);
	  }

	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x
	   * @param {number} y
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   * @returns {object} Callbacks to draw later on higher layers.
	   */
	  _createClass(TriangleDown, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      return this._drawShape(ctx, "triangleDown", 3, x, y, selected, hover, values);
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);
	  return TriangleDown;
	}(ShapeBase);

	function ownKeys$2(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols) { var o = _Object$getOwnPropertySymbols(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor$1(e, r).enumerable; })), t.push.apply(t, o); } return t; }
	function _objectSpread$2(e) { for (var r = 1; r < arguments.length; r++) { var _context5, _context6; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context5 = ownKeys$2(Object(t), !0)).call(_context5, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context6 = ownKeys$2(Object(t))).call(_context6, function (r) { _Object$defineProperty(e, r, _Object$getOwnPropertyDescriptor$1(t, r)); }); } return e; }

	/**
	 * A node. A node can be connected to other nodes via one or multiple edges.
	 */
	var Node = /*#__PURE__*/function () {
	  /**
	   *
	   * @param {object} options An object containing options for the node. All
	   *                            options are optional, except for the id.
	   *                              {number} id     Id of the node. Required
	   *                              {string} label  Text label for the node
	   *                              {number} x      Horizontal position of the node
	   *                              {number} y      Vertical position of the node
	   *                              {string} shape  Node shape
	   *                              {string} image  An image url
	   *                              {string} title  A title text, can be HTML
	   *                              {anytype} group A group name or number
	   * @param {object} body               Shared state of current network instance
	   * @param {Network.Images} imagelist  A list with images. Only needed when the node has an image
	   * @param {Groups} grouplist          A list with groups. Needed for retrieving group options
	   * @param {object} globalOptions      Current global node options; these serve as defaults for the node instance
	   * @param {object} defaultOptions     Global default options for nodes; note that this is also the prototype
	   *                                    for parameter `globalOptions`.
	   */
	  function Node(options, body, imagelist, grouplist, globalOptions, defaultOptions) {
	    _classCallCheck(this, Node);
	    this.options = bridgeObject(globalOptions);
	    this.globalOptions = globalOptions;
	    this.defaultOptions = defaultOptions;
	    this.body = body;
	    this.edges = []; // all edges connected to this node

	    // set defaults for the options
	    this.id = undefined;
	    this.imagelist = imagelist;
	    this.grouplist = grouplist;

	    // state options
	    this.x = undefined;
	    this.y = undefined;
	    this.baseSize = this.options.size;
	    this.baseFontSize = this.options.font.size;
	    this.predefinedPosition = false; // used to check if initial fit should just take the range or approximate
	    this.selected = false;
	    this.hover = false;
	    this.labelModule = new Label(this.body, this.options, false /* Not edge label */);

	    this.setOptions(options);
	  }

	  /**
	   * Attach a edge to the node
	   *
	   * @param {Edge} edge
	   */
	  _createClass(Node, [{
	    key: "attachEdge",
	    value: function attachEdge(edge) {
	      var _context;
	      if (_indexOfInstanceProperty(_context = this.edges).call(_context, edge) === -1) {
	        this.edges.push(edge);
	      }
	    }

	    /**
	     * Detach a edge from the node
	     *
	     * @param {Edge} edge
	     */
	  }, {
	    key: "detachEdge",
	    value: function detachEdge(edge) {
	      var _context2;
	      var index = _indexOfInstanceProperty(_context2 = this.edges).call(_context2, edge);
	      if (index != -1) {
	        var _context3;
	        _spliceInstanceProperty(_context3 = this.edges).call(_context3, index, 1);
	      }
	    }

	    /**
	     * Set or overwrite options for the node
	     *
	     * @param {object} options an object with options
	     * @returns {null|boolean}
	     */
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      var currentShape = this.options.shape;
	      if (!options) {
	        return; // Note that the return value will be 'undefined'! This is OK.
	      }

	      // Save the color for later.
	      // This is necessary in order to prevent local color from being overwritten by group color.
	      // TODO: To prevent such workarounds the way options are handled should be rewritten from scratch.
	      // This is not the only problem with current options handling.
	      if (typeof options.color !== "undefined") {
	        this._localColor = options.color;
	      }

	      // basic options
	      if (options.id !== undefined) {
	        this.id = options.id;
	      }
	      if (this.id === undefined) {
	        throw new Error("Node must have an id");
	      }
	      Node.checkMass(options, this.id);

	      // set these options locally
	      // clear x and y positions
	      if (options.x !== undefined) {
	        if (options.x === null) {
	          this.x = undefined;
	          this.predefinedPosition = false;
	        } else {
	          this.x = _parseInt$1(options.x);
	          this.predefinedPosition = true;
	        }
	      }
	      if (options.y !== undefined) {
	        if (options.y === null) {
	          this.y = undefined;
	          this.predefinedPosition = false;
	        } else {
	          this.y = _parseInt$1(options.y);
	          this.predefinedPosition = true;
	        }
	      }
	      if (options.size !== undefined) {
	        this.baseSize = options.size;
	      }
	      if (options.value !== undefined) {
	        options.value = _parseFloat$1(options.value);
	      }

	      // this transforms all shorthands into fully defined options
	      Node.parseOptions(this.options, options, true, this.globalOptions, this.grouplist);
	      var pile = [options, this.options, this.defaultOptions];
	      this.chooser = choosify("node", pile);
	      this._load_images();
	      this.updateLabelModule(options);

	      // Need to set local opacity after `this.updateLabelModule(options);` because `this.updateLabelModule(options);` overrites local opacity with group opacity
	      if (options.opacity !== undefined && Node.checkOpacity(options.opacity)) {
	        this.options.opacity = options.opacity;
	      }
	      this.updateShape(currentShape);
	      return options.hidden !== undefined || options.physics !== undefined;
	    }

	    /**
	     * Load the images from the options, for the nodes that need them.
	     *
	     * Images are always loaded, even if they are not used in the current shape.
	     * The user may switch to an image shape later on.
	     *
	     * @private
	     */
	  }, {
	    key: "_load_images",
	    value: function _load_images() {
	      if (this.options.shape === "circularImage" || this.options.shape === "image") {
	        if (this.options.image === undefined) {
	          throw new Error("Option image must be defined for node type '" + this.options.shape + "'");
	        }
	      }
	      if (this.options.image === undefined) {
	        return;
	      }
	      if (this.imagelist === undefined) {
	        throw new Error("Internal Error: No images provided");
	      }
	      if (typeof this.options.image === "string") {
	        this.imageObj = this.imagelist.load(this.options.image, this.options.brokenImage, this.id);
	      } else {
	        if (this.options.image.unselected === undefined) {
	          throw new Error("No unselected image provided");
	        }
	        this.imageObj = this.imagelist.load(this.options.image.unselected, this.options.brokenImage, this.id);
	        if (this.options.image.selected !== undefined) {
	          this.imageObjAlt = this.imagelist.load(this.options.image.selected, this.options.brokenImage, this.id);
	        } else {
	          this.imageObjAlt = undefined;
	        }
	      }
	    }

	    /**
	     * Check that opacity is only between 0 and 1
	     *
	     * @param {number} opacity
	     * @returns {boolean}
	     */
	  }, {
	    key: "getFormattingValues",
	    value:
	    /**
	     *
	     * @returns {{color: *, borderWidth: *, borderColor: *, size: *, borderDashes: (boolean|Array|allOptions.nodes.shapeProperties.borderDashes|{boolean, array}), borderRadius: (number|allOptions.nodes.shapeProperties.borderRadius|{number}|Array), shadow: *, shadowColor: *, shadowSize: *, shadowX: *, shadowY: *}}
	     */
	    function getFormattingValues() {
	      var values = {
	        color: this.options.color.background,
	        opacity: this.options.opacity,
	        borderWidth: this.options.borderWidth,
	        borderColor: this.options.color.border,
	        size: this.options.size,
	        borderDashes: this.options.shapeProperties.borderDashes,
	        borderRadius: this.options.shapeProperties.borderRadius,
	        shadow: this.options.shadow.enabled,
	        shadowColor: this.options.shadow.color,
	        shadowSize: this.options.shadow.size,
	        shadowX: this.options.shadow.x,
	        shadowY: this.options.shadow.y
	      };
	      if (this.selected || this.hover) {
	        if (this.chooser === true) {
	          if (this.selected) {
	            if (this.options.borderWidthSelected != null) {
	              values.borderWidth = this.options.borderWidthSelected;
	            } else {
	              values.borderWidth *= 2;
	            }
	            values.color = this.options.color.highlight.background;
	            values.borderColor = this.options.color.highlight.border;
	            values.shadow = this.options.shadow.enabled;
	          } else if (this.hover) {
	            values.color = this.options.color.hover.background;
	            values.borderColor = this.options.color.hover.border;
	            values.shadow = this.options.shadow.enabled;
	          }
	        } else if (typeof this.chooser === "function") {
	          this.chooser(values, this.options.id, this.selected, this.hover);
	          if (values.shadow === false) {
	            if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
	              values.shadow = true;
	            }
	          }
	        }
	      } else {
	        values.shadow = this.options.shadow.enabled;
	      }
	      if (this.options.opacity !== undefined) {
	        var opacity = this.options.opacity;
	        values.borderColor = overrideOpacity(values.borderColor, opacity);
	        values.color = overrideOpacity(values.color, opacity);
	        values.shadowColor = overrideOpacity(values.shadowColor, opacity);
	      }
	      return values;
	    }

	    /**
	     *
	     * @param {object} options
	     */
	  }, {
	    key: "updateLabelModule",
	    value: function updateLabelModule(options) {
	      if (this.options.label === undefined || this.options.label === null) {
	        this.options.label = "";
	      }
	      Node.updateGroupOptions(this.options, _objectSpread$2(_objectSpread$2({}, options), {}, {
	        color: options && options.color || this._localColor || undefined
	      }), this.grouplist);

	      //
	      // Note:The prototype chain for this.options is:
	      //
	      // this.options ->    NodesHandler.options    -> NodesHandler.defaultOptions
	      //                 (also: this.globalOptions)
	      //
	      // Note that the prototypes are mentioned explicitly in the pile list below;
	      // WE DON'T WANT THE ORDER OF THE PROTOTYPES!!!! At least, not for font handling of labels.
	      // This is a good indication that the prototype usage of options is deficient.
	      //
	      var currentGroup = this.grouplist.get(this.options.group, false);
	      var pile = [options,
	      // new options
	      this.options,
	      // current node options, see comment above for prototype
	      currentGroup,
	      // group options, if any
	      this.globalOptions,
	      // Currently set global node options
	      this.defaultOptions // Default global node options
	      ];

	      this.labelModule.update(this.options, pile);
	      if (this.labelModule.baseSize !== undefined) {
	        this.baseFontSize = this.labelModule.baseSize;
	      }
	    }

	    /**
	     *
	     * @param {string} currentShape
	     */
	  }, {
	    key: "updateShape",
	    value: function updateShape(currentShape) {
	      if (currentShape === this.options.shape && this.shape) {
	        this.shape.setOptions(this.options, this.imageObj, this.imageObjAlt);
	      } else {
	        // choose draw method depending on the shape
	        switch (this.options.shape) {
	          case "box":
	            this.shape = new Box$1(this.options, this.body, this.labelModule);
	            break;
	          case "circle":
	            this.shape = new Circle$1(this.options, this.body, this.labelModule);
	            break;
	          case "circularImage":
	            this.shape = new CircularImage(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
	            break;
	          case "custom":
	            this.shape = new CustomShape(this.options, this.body, this.labelModule, this.options.ctxRenderer);
	            break;
	          case "database":
	            this.shape = new Database(this.options, this.body, this.labelModule);
	            break;
	          case "diamond":
	            this.shape = new Diamond$1(this.options, this.body, this.labelModule);
	            break;
	          case "dot":
	            this.shape = new Dot(this.options, this.body, this.labelModule);
	            break;
	          case "ellipse":
	            this.shape = new Ellipse(this.options, this.body, this.labelModule);
	            break;
	          case "icon":
	            this.shape = new Icon(this.options, this.body, this.labelModule);
	            break;
	          case "image":
	            this.shape = new Image$2(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
	            break;
	          case "square":
	            this.shape = new Square(this.options, this.body, this.labelModule);
	            break;
	          case "hexagon":
	            this.shape = new Hexagon(this.options, this.body, this.labelModule);
	            break;
	          case "star":
	            this.shape = new Star(this.options, this.body, this.labelModule);
	            break;
	          case "text":
	            this.shape = new Text(this.options, this.body, this.labelModule);
	            break;
	          case "triangle":
	            this.shape = new Triangle$1(this.options, this.body, this.labelModule);
	            break;
	          case "triangleDown":
	            this.shape = new TriangleDown(this.options, this.body, this.labelModule);
	            break;
	          default:
	            this.shape = new Ellipse(this.options, this.body, this.labelModule);
	            break;
	        }
	      }
	      this.needsRefresh();
	    }

	    /**
	     * select this node
	     */
	  }, {
	    key: "select",
	    value: function select() {
	      this.selected = true;
	      this.needsRefresh();
	    }

	    /**
	     * unselect this node
	     */
	  }, {
	    key: "unselect",
	    value: function unselect() {
	      this.selected = false;
	      this.needsRefresh();
	    }

	    /**
	     * Reset the calculated size of the node, forces it to recalculate its size
	     */
	  }, {
	    key: "needsRefresh",
	    value: function needsRefresh() {
	      this.shape.refreshNeeded = true;
	    }

	    /**
	     * get the title of this node.
	     *
	     * @returns {string} title    The title of the node, or undefined when no title
	     *                           has been set.
	     */
	  }, {
	    key: "getTitle",
	    value: function getTitle() {
	      return this.options.title;
	    }

	    /**
	     * Calculate the distance to the border of the Node
	     *
	     * @param {CanvasRenderingContext2D}   ctx
	     * @param {number} angle        Angle in radians
	     * @returns {number} distance   Distance to the border in pixels
	     */
	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this.shape.distanceToBorder(ctx, angle);
	    }

	    /**
	     * Check if this node has a fixed x and y position
	     *
	     * @returns {boolean}      true if fixed, false if not
	     */
	  }, {
	    key: "isFixed",
	    value: function isFixed() {
	      return this.options.fixed.x && this.options.fixed.y;
	    }

	    /**
	     * check if this node is selecte
	     *
	     * @returns {boolean} selected   True if node is selected, else false
	     */
	  }, {
	    key: "isSelected",
	    value: function isSelected() {
	      return this.selected;
	    }

	    /**
	     * Retrieve the value of the node. Can be undefined
	     *
	     * @returns {number} value
	     */
	  }, {
	    key: "getValue",
	    value: function getValue() {
	      return this.options.value;
	    }

	    /**
	     * Get the current dimensions of the label
	     *
	     * @returns {rect}
	     */
	  }, {
	    key: "getLabelSize",
	    value: function getLabelSize() {
	      return this.labelModule.size();
	    }

	    /**
	     * Adjust the value range of the node. The node will adjust it's size
	     * based on its value.
	     *
	     * @param {number} min
	     * @param {number} max
	     * @param {number} total
	     */
	  }, {
	    key: "setValueRange",
	    value: function setValueRange(min, max, total) {
	      if (this.options.value !== undefined) {
	        var scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
	        var sizeDiff = this.options.scaling.max - this.options.scaling.min;
	        if (this.options.scaling.label.enabled === true) {
	          var fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
	          this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
	        }
	        this.options.size = this.options.scaling.min + scale * sizeDiff;
	      } else {
	        this.options.size = this.baseSize;
	        this.options.font.size = this.baseFontSize;
	      }
	      this.updateLabelModule();
	    }

	    /**
	     * Draw this node in the given canvas
	     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
	     *
	     * @param {CanvasRenderingContext2D}   ctx
	     * @returns {object} Callbacks to draw later on higher layers.
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx) {
	      var values = this.getFormattingValues();
	      return this.shape.draw(ctx, this.x, this.y, this.selected, this.hover, values) || {};
	    }

	    /**
	     * Update the bounding box of the shape
	     *
	     * @param {CanvasRenderingContext2D}   ctx
	     */
	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(ctx) {
	      this.shape.updateBoundingBox(this.x, this.y, ctx);
	    }

	    /**
	     * Recalculate the size of this node in the given canvas
	     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
	     *
	     * @param {CanvasRenderingContext2D}   ctx
	     */
	  }, {
	    key: "resize",
	    value: function resize(ctx) {
	      var values = this.getFormattingValues();
	      this.shape.resize(ctx, this.selected, this.hover, values);
	    }

	    /**
	     * Determine all visual elements of this node instance, in which the given
	     * point falls within the bounding shape.
	     *
	     * @param {point} point
	     * @returns {Array.<nodeClickItem|nodeLabelClickItem>} list with the items which are on the point
	     */
	  }, {
	    key: "getItemsOnPoint",
	    value: function getItemsOnPoint(point) {
	      var ret = [];
	      if (this.labelModule.visible()) {
	        if (pointInRect(this.labelModule.getSize(), point)) {
	          ret.push({
	            nodeId: this.id,
	            labelId: 0
	          });
	        }
	      }
	      if (pointInRect(this.shape.boundingBox, point)) {
	        ret.push({
	          nodeId: this.id
	        });
	      }
	      return ret;
	    }

	    /**
	     * Check if this object is overlapping with the provided object
	     *
	     * @param {object} obj   an object with parameters left, top, right, bottom
	     * @returns {boolean}     True if location is located on node
	     */
	  }, {
	    key: "isOverlappingWith",
	    value: function isOverlappingWith(obj) {
	      return this.shape.left < obj.right && this.shape.left + this.shape.width > obj.left && this.shape.top < obj.bottom && this.shape.top + this.shape.height > obj.top;
	    }

	    /**
	     * Check if this object is overlapping with the provided object
	     *
	     * @param {object} obj   an object with parameters left, top, right, bottom
	     * @returns {boolean}     True if location is located on node
	     */
	  }, {
	    key: "isBoundingBoxOverlappingWith",
	    value: function isBoundingBoxOverlappingWith(obj) {
	      return this.shape.boundingBox.left < obj.right && this.shape.boundingBox.right > obj.left && this.shape.boundingBox.top < obj.bottom && this.shape.boundingBox.bottom > obj.top;
	    }

	    /**
	     * Check valid values for mass
	     *
	     * The mass may not be negative or zero. If it is, reset to 1
	     *
	     * @param {object} options
	     * @param {Node.id} id
	     * @static
	     */
	  }], [{
	    key: "checkOpacity",
	    value: function checkOpacity(opacity) {
	      return 0 <= opacity && opacity <= 1;
	    }

	    /**
	     * Check that origin is 'center' or 'top-left'
	     *
	     * @param {string} origin
	     * @returns {boolean}
	     */
	  }, {
	    key: "checkCoordinateOrigin",
	    value: function checkCoordinateOrigin(origin) {
	      return origin === undefined || origin === "center" || origin === "top-left";
	    }

	    /**
	     * Copy group option values into the node options.
	     *
	     * The group options override the global node options, so the copy of group options
	     *  must happen *after* the global node options have been set.
	     *
	     * This method must also be called also if the global node options have changed and the group options did not.
	     *
	     * @param {object} parentOptions
	     * @param {object} newOptions  new values for the options, currently only passed in for check
	     * @param {object} groupList
	     */
	  }, {
	    key: "updateGroupOptions",
	    value: function updateGroupOptions(parentOptions, newOptions, groupList) {
	      var _context4;
	      if (groupList === undefined) return; // No groups, nothing to do

	      var group = parentOptions.group;

	      // paranoia: the selected group is already merged into node options, check.
	      if (newOptions !== undefined && newOptions.group !== undefined && group !== newOptions.group) {
	        throw new Error("updateGroupOptions: group values in options don't match.");
	      }
	      var hasGroup = typeof group === "number" || typeof group === "string" && group != "";
	      if (!hasGroup) return; // current node has no group, no need to merge

	      var groupObj = groupList.get(group);
	      if (groupObj.opacity !== undefined && newOptions.opacity === undefined) {
	        if (!Node.checkOpacity(groupObj.opacity)) {
	          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + groupObj.opacity);
	          groupObj.opacity = undefined;
	        }
	      }

	      // Skip any new option to avoid them being overridden by the group options.
	      var skipProperties = _filterInstanceProperty(_context4 = _Object$getOwnPropertyNames(newOptions)).call(_context4, function (p) {
	        return newOptions[p] != null;
	      });
	      // Always skip merging group font options into parent; these are required to be distinct for labels
	      skipProperties.push("font");
	      selectiveNotDeepExtend(skipProperties, parentOptions, groupObj);

	      // the color object needs to be completely defined.
	      // Since groups can partially overwrite the colors, we parse it again, just in case.
	      parentOptions.color = parseColor(parentOptions.color);
	    }

	    /**
	     * This process all possible shorthands in the new options and makes sure that the parentOptions are fully defined.
	     * Static so it can also be used by the handler.
	     *
	     * @param {object} parentOptions
	     * @param {object} newOptions
	     * @param {boolean} [allowDeletion=false]
	     * @param {object} [globalOptions={}]
	     * @param {object} [groupList]
	     * @static
	     */
	  }, {
	    key: "parseOptions",
	    value: function parseOptions(parentOptions, newOptions) {
	      var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
	      var groupList = arguments.length > 4 ? arguments[4] : undefined;
	      var fields = ["color", "fixed", "shadow"];
	      selectiveNotDeepExtend(fields, parentOptions, newOptions, allowDeletion);
	      Node.checkMass(newOptions);
	      if (parentOptions.opacity !== undefined) {
	        if (!Node.checkOpacity(parentOptions.opacity)) {
	          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + parentOptions.opacity);
	          parentOptions.opacity = undefined;
	        }
	      }
	      if (newOptions.opacity !== undefined) {
	        if (!Node.checkOpacity(newOptions.opacity)) {
	          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + newOptions.opacity);
	          newOptions.opacity = undefined;
	        }
	      }
	      if (newOptions.shapeProperties && !Node.checkCoordinateOrigin(newOptions.shapeProperties.coordinateOrigin)) {
	        console.error("Invalid option for node coordinateOrigin, found: " + newOptions.shapeProperties.coordinateOrigin);
	      }

	      // merge the shadow options into the parent.
	      mergeOptions(parentOptions, newOptions, "shadow", globalOptions);

	      // individual shape newOptions
	      if (newOptions.color !== undefined && newOptions.color !== null) {
	        var parsedColor = parseColor(newOptions.color);
	        fillIfDefined(parentOptions.color, parsedColor);
	      } else if (allowDeletion === true && newOptions.color === null) {
	        parentOptions.color = bridgeObject(globalOptions.color); // set the object back to the global options
	      }

	      // handle the fixed options
	      if (newOptions.fixed !== undefined && newOptions.fixed !== null) {
	        if (typeof newOptions.fixed === "boolean") {
	          parentOptions.fixed.x = newOptions.fixed;
	          parentOptions.fixed.y = newOptions.fixed;
	        } else {
	          if (newOptions.fixed.x !== undefined && typeof newOptions.fixed.x === "boolean") {
	            parentOptions.fixed.x = newOptions.fixed.x;
	          }
	          if (newOptions.fixed.y !== undefined && typeof newOptions.fixed.y === "boolean") {
	            parentOptions.fixed.y = newOptions.fixed.y;
	          }
	        }
	      }
	      if (allowDeletion === true && newOptions.font === null) {
	        parentOptions.font = bridgeObject(globalOptions.font); // set the object back to the global options
	      }

	      Node.updateGroupOptions(parentOptions, newOptions, groupList);

	      // handle the scaling options, specifically the label part
	      if (newOptions.scaling !== undefined) {
	        mergeOptions(parentOptions.scaling, newOptions.scaling, "label", globalOptions.scaling);
	      }
	    }
	  }, {
	    key: "checkMass",
	    value: function checkMass(options, id) {
	      if (options.mass !== undefined && options.mass <= 0) {
	        var strId = "";
	        if (id !== undefined) {
	          strId = " in node id: " + id;
	        }
	        console.error("%cNegative or zero mass disallowed" + strId + ", setting mass to 1.", VALIDATOR_PRINT_STYLE);
	        options.mass = 1;
	      }
	    }
	  }]);
	  return Node;
	}();

	function _createForOfIteratorHelper$5(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray(o) || (it = _unsupportedIterableToArray$5(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray$5(o, minLen) { var _context4; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$5(o, minLen); var n = _sliceInstanceProperty(_context4 = Object.prototype.toString.call(o)).call(_context4, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$5(o, minLen); }
	function _arrayLikeToArray$5(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

	/**
	 * Handler for Nodes
	 */
	var NodesHandler = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   * @param {Images} images
	   * @param {Array.<Group>} groups
	   * @param {LayoutEngine} layoutEngine
	   */
	  function NodesHandler(body, images, groups, layoutEngine) {
	    var _context,
	      _this = this;
	    _classCallCheck(this, NodesHandler);
	    this.body = body;
	    this.images = images;
	    this.groups = groups;
	    this.layoutEngine = layoutEngine;

	    // create the node API in the body container
	    this.body.functions.createNode = _bindInstanceProperty$1(_context = this.create).call(_context, this);
	    this.nodesListeners = {
	      add: function add(event, params) {
	        _this.add(params.items);
	      },
	      update: function update(event, params) {
	        _this.update(params.items, params.data, params.oldData);
	      },
	      remove: function remove(event, params) {
	        _this.remove(params.items);
	      }
	    };
	    this.defaultOptions = {
	      borderWidth: 1,
	      borderWidthSelected: undefined,
	      brokenImage: undefined,
	      color: {
	        border: "#2B7CE9",
	        background: "#97C2FC",
	        highlight: {
	          border: "#2B7CE9",
	          background: "#D2E5FF"
	        },
	        hover: {
	          border: "#2B7CE9",
	          background: "#D2E5FF"
	        }
	      },
	      opacity: undefined,
	      // number between 0 and 1
	      fixed: {
	        x: false,
	        y: false
	      },
	      font: {
	        color: "#343434",
	        size: 14,
	        // px
	        face: "arial",
	        background: "none",
	        strokeWidth: 0,
	        // px
	        strokeColor: "#ffffff",
	        align: "center",
	        vadjust: 0,
	        multi: false,
	        bold: {
	          mod: "bold"
	        },
	        boldital: {
	          mod: "bold italic"
	        },
	        ital: {
	          mod: "italic"
	        },
	        mono: {
	          mod: "",
	          size: 15,
	          // px
	          face: "monospace",
	          vadjust: 2
	        }
	      },
	      group: undefined,
	      hidden: false,
	      icon: {
	        face: "FontAwesome",
	        //'FontAwesome',
	        code: undefined,
	        //'\uf007',
	        size: 50,
	        //50,
	        color: "#2B7CE9" //'#aa00ff'
	      },

	      image: undefined,
	      // --> URL
	      imagePadding: {
	        // only for image shape
	        top: 0,
	        right: 0,
	        bottom: 0,
	        left: 0
	      },
	      label: undefined,
	      labelHighlightBold: true,
	      level: undefined,
	      margin: {
	        top: 5,
	        right: 5,
	        bottom: 5,
	        left: 5
	      },
	      mass: 1,
	      physics: true,
	      scaling: {
	        min: 10,
	        max: 30,
	        label: {
	          enabled: false,
	          min: 14,
	          max: 30,
	          maxVisible: 30,
	          drawThreshold: 5
	        },
	        customScalingFunction: function customScalingFunction(min, max, total, value) {
	          if (max === min) {
	            return 0.5;
	          } else {
	            var scale = 1 / (max - min);
	            return Math.max(0, (value - min) * scale);
	          }
	        }
	      },
	      shadow: {
	        enabled: false,
	        color: "rgba(0,0,0,0.5)",
	        size: 10,
	        x: 5,
	        y: 5
	      },
	      shape: "ellipse",
	      shapeProperties: {
	        borderDashes: false,
	        // only for borders
	        borderRadius: 6,
	        // only for box shape
	        interpolation: true,
	        // only for image and circularImage shapes
	        useImageSize: false,
	        // only for image and circularImage shapes
	        useBorderWithImage: false,
	        // only for image shape
	        coordinateOrigin: "center" // only for image and circularImage shapes
	      },

	      size: 25,
	      title: undefined,
	      value: undefined,
	      x: undefined,
	      y: undefined
	    };

	    // Protect from idiocy
	    if (this.defaultOptions.mass <= 0) {
	      throw "Internal error: mass in defaultOptions of NodesHandler may not be zero or negative";
	    }
	    this.options = bridgeObject(this.defaultOptions);
	    this.bindEventListeners();
	  }

	  /**
	   * Binds event listeners
	   */
	  _createClass(NodesHandler, [{
	    key: "bindEventListeners",
	    value: function bindEventListeners() {
	      var _context2,
	        _context3,
	        _this2 = this;
	      // refresh the nodes. Used when reverting from hierarchical layout
	      this.body.emitter.on("refreshNodes", _bindInstanceProperty$1(_context2 = this.refresh).call(_context2, this));
	      this.body.emitter.on("refresh", _bindInstanceProperty$1(_context3 = this.refresh).call(_context3, this));
	      this.body.emitter.on("destroy", function () {
	        forEach$4(_this2.nodesListeners, function (callback, event) {
	          if (_this2.body.data.nodes) _this2.body.data.nodes.off(event, callback);
	        });
	        delete _this2.body.functions.createNode;
	        delete _this2.nodesListeners.add;
	        delete _this2.nodesListeners.update;
	        delete _this2.nodesListeners.remove;
	        delete _this2.nodesListeners;
	      });
	    }

	    /**
	     *
	     * @param {object} options
	     */
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options !== undefined) {
	        Node.parseOptions(this.options, options);

	        // Need to set opacity here because Node.parseOptions is also used for groups,
	        // if you set opacity in Node.parseOptions it overwrites group opacity.
	        if (options.opacity !== undefined) {
	          if (_Number$isNaN(options.opacity) || !_Number$isFinite(options.opacity) || options.opacity < 0 || options.opacity > 1) {
	            console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + options.opacity);
	          } else {
	            this.options.opacity = options.opacity;
	          }
	        }

	        // update the shape in all nodes
	        if (options.shape !== undefined) {
	          for (var nodeId in this.body.nodes) {
	            if (Object.prototype.hasOwnProperty.call(this.body.nodes, nodeId)) {
	              this.body.nodes[nodeId].updateShape();
	            }
	          }
	        }

	        // Update the labels of nodes if any relevant options changed.
	        if (typeof options.font !== "undefined" || typeof options.widthConstraint !== "undefined" || typeof options.heightConstraint !== "undefined") {
	          for (var _i = 0, _Object$keys$1 = _Object$keys(this.body.nodes); _i < _Object$keys$1.length; _i++) {
	            var _nodeId = _Object$keys$1[_i];
	            this.body.nodes[_nodeId].updateLabelModule();
	            this.body.nodes[_nodeId].needsRefresh();
	          }
	        }

	        // update the shape size in all nodes
	        if (options.size !== undefined) {
	          for (var _nodeId2 in this.body.nodes) {
	            if (Object.prototype.hasOwnProperty.call(this.body.nodes, _nodeId2)) {
	              this.body.nodes[_nodeId2].needsRefresh();
	            }
	          }
	        }

	        // update the state of the variables if needed
	        if (options.hidden !== undefined || options.physics !== undefined) {
	          this.body.emitter.emit("_dataChanged");
	        }
	      }
	    }

	    /**
	     * Set a data set with nodes for the network
	     *
	     * @param {Array | DataSet | DataView} nodes         The data containing the nodes.
	     * @param {boolean} [doNotEmit=false] - Suppress data changed event.
	     * @private
	     */
	  }, {
	    key: "setData",
	    value: function setData(nodes) {
	      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var oldNodesData = this.body.data.nodes;
	      if (isDataViewLike("id", nodes)) {
	        this.body.data.nodes = nodes;
	      } else if (_Array$isArray(nodes)) {
	        this.body.data.nodes = new DataSet();
	        this.body.data.nodes.add(nodes);
	      } else if (!nodes) {
	        this.body.data.nodes = new DataSet();
	      } else {
	        throw new TypeError("Array or DataSet expected");
	      }
	      if (oldNodesData) {
	        // unsubscribe from old dataset
	        forEach$4(this.nodesListeners, function (callback, event) {
	          oldNodesData.off(event, callback);
	        });
	      }

	      // remove drawn nodes
	      this.body.nodes = {};
	      if (this.body.data.nodes) {
	        // subscribe to new dataset
	        var me = this;
	        forEach$4(this.nodesListeners, function (callback, event) {
	          me.body.data.nodes.on(event, callback);
	        });

	        // draw all new nodes
	        var ids = this.body.data.nodes.getIds();
	        this.add(ids, true);
	      }
	      if (doNotEmit === false) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }

	    /**
	     * Add nodes
	     *
	     * @param {number[] | string[]} ids
	     * @param {boolean} [doNotEmit=false]
	     * @private
	     */
	  }, {
	    key: "add",
	    value: function add(ids) {
	      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var id;
	      var newNodes = [];
	      for (var i = 0; i < ids.length; i++) {
	        id = ids[i];
	        var properties = this.body.data.nodes.get(id);
	        var node = this.create(properties);
	        newNodes.push(node);
	        this.body.nodes[id] = node; // note: this may replace an existing node
	      }

	      this.layoutEngine.positionInitially(newNodes);
	      if (doNotEmit === false) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }

	    /**
	     * Update existing nodes, or create them when not yet existing
	     *
	     * @param {number[] | string[]} ids id's of changed nodes
	     * @param {Array} changedData array with changed data
	     * @param {Array|undefined} oldData optional; array with previous data
	     * @private
	     */
	  }, {
	    key: "update",
	    value: function update(ids, changedData, oldData) {
	      var nodes = this.body.nodes;
	      var dataChanged = false;
	      for (var i = 0; i < ids.length; i++) {
	        var id = ids[i];
	        var node = nodes[id];
	        var data = changedData[i];
	        if (node !== undefined) {
	          // update node
	          if (node.setOptions(data)) {
	            dataChanged = true;
	          }
	        } else {
	          dataChanged = true;
	          // create node
	          node = this.create(data);
	          nodes[id] = node;
	        }
	      }
	      if (!dataChanged && oldData !== undefined) {
	        // Check for any changes which should trigger a layout recalculation
	        // For now, this is just 'level' for hierarchical layout
	        // Assumption: old and new data arranged in same order; at time of writing, this holds.
	        dataChanged = _someInstanceProperty(changedData).call(changedData, function (newValue, index) {
	          var oldValue = oldData[index];
	          return oldValue && oldValue.level !== newValue.level;
	        });
	      }
	      if (dataChanged === true) {
	        this.body.emitter.emit("_dataChanged");
	      } else {
	        this.body.emitter.emit("_dataUpdated");
	      }
	    }

	    /**
	     * Remove existing nodes. If nodes do not exist, the method will just ignore it.
	     *
	     * @param {number[] | string[]} ids
	     * @private
	     */
	  }, {
	    key: "remove",
	    value: function remove(ids) {
	      var nodes = this.body.nodes;
	      for (var i = 0; i < ids.length; i++) {
	        var id = ids[i];
	        delete nodes[id];
	      }
	      this.body.emitter.emit("_dataChanged");
	    }

	    /**
	     * create a node
	     *
	     * @param {object} properties
	     * @param {class} [constructorClass=Node.default]
	     * @returns {*}
	     */
	  }, {
	    key: "create",
	    value: function create(properties) {
	      var constructorClass = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Node;
	      return new constructorClass(properties, this.body, this.images, this.groups, this.options, this.defaultOptions);
	    }

	    /**
	     *
	     * @param {boolean} [clearPositions=false]
	     */
	  }, {
	    key: "refresh",
	    value: function refresh() {
	      var _this3 = this;
	      var clearPositions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
	      forEach$4(this.body.nodes, function (node, nodeId) {
	        var data = _this3.body.data.nodes.get(nodeId);
	        if (data !== undefined) {
	          if (clearPositions === true) {
	            node.setOptions({
	              x: null,
	              y: null
	            });
	          }
	          node.setOptions({
	            fixed: false
	          });
	          node.setOptions(data);
	        }
	      });
	    }

	    /**
	     * Returns the positions of the nodes.
	     *
	     * @param {Array.<Node.id> | string} [ids]  --> optional, can be array of nodeIds, can be string
	     * @returns {{}}
	     */
	  }, {
	    key: "getPositions",
	    value: function getPositions(ids) {
	      var dataArray = {};
	      if (ids !== undefined) {
	        if (_Array$isArray(ids) === true) {
	          for (var i = 0; i < ids.length; i++) {
	            if (this.body.nodes[ids[i]] !== undefined) {
	              var node = this.body.nodes[ids[i]];
	              dataArray[ids[i]] = {
	                x: Math.round(node.x),
	                y: Math.round(node.y)
	              };
	            }
	          }
	        } else {
	          if (this.body.nodes[ids] !== undefined) {
	            var _node = this.body.nodes[ids];
	            dataArray[ids] = {
	              x: Math.round(_node.x),
	              y: Math.round(_node.y)
	            };
	          }
	        }
	      } else {
	        for (var _i2 = 0; _i2 < this.body.nodeIndices.length; _i2++) {
	          var _node2 = this.body.nodes[this.body.nodeIndices[_i2]];
	          dataArray[this.body.nodeIndices[_i2]] = {
	            x: Math.round(_node2.x),
	            y: Math.round(_node2.y)
	          };
	        }
	      }
	      return dataArray;
	    }

	    /**
	     * Retrieves the x y position of a specific id.
	     *
	     * @param {string} id The id to retrieve.
	     * @throws {TypeError} If no id is included.
	     * @throws {ReferenceError} If an invalid id is provided.
	     * @returns {{ x: number, y: number }} Returns X, Y canvas position of the node with given id.
	     */
	  }, {
	    key: "getPosition",
	    value: function getPosition(id) {
	      if (id == undefined) {
	        throw new TypeError("No id was specified for getPosition method.");
	      } else if (this.body.nodes[id] == undefined) {
	        throw new ReferenceError("NodeId provided for getPosition does not exist. Provided: ".concat(id));
	      } else {
	        return {
	          x: Math.round(this.body.nodes[id].x),
	          y: Math.round(this.body.nodes[id].y)
	        };
	      }
	    }

	    /**
	     * Load the XY positions of the nodes into the dataset.
	     */
	  }, {
	    key: "storePositions",
	    value: function storePositions() {
	      // todo: add support for clusters and hierarchical.
	      var dataArray = [];
	      var dataset = this.body.data.nodes.getDataSet();
	      var _iterator = _createForOfIteratorHelper$5(dataset.get()),
	        _step;
	      try {
	        for (_iterator.s(); !(_step = _iterator.n()).done;) {
	          var dsNode = _step.value;
	          var id = dsNode.id;
	          var bodyNode = this.body.nodes[id];
	          var x = Math.round(bodyNode.x);
	          var y = Math.round(bodyNode.y);
	          if (dsNode.x !== x || dsNode.y !== y) {
	            dataArray.push({
	              id: id,
	              x: x,
	              y: y
	            });
	          }
	        }
	      } catch (err) {
	        _iterator.e(err);
	      } finally {
	        _iterator.f();
	      }
	      dataset.update(dataArray);
	    }

	    /**
	     * get the bounding box of a node.
	     *
	     * @param {Node.id} nodeId
	     * @returns {j|*}
	     */
	  }, {
	    key: "getBoundingBox",
	    value: function getBoundingBox(nodeId) {
	      if (this.body.nodes[nodeId] !== undefined) {
	        return this.body.nodes[nodeId].shape.boundingBox;
	      }
	    }

	    /**
	     * Get the Ids of nodes connected to this node.
	     *
	     * @param {Node.id} nodeId
	     * @param {'to'|'from'|undefined} direction values 'from' and 'to' select respectively parent and child nodes only.
	     *                                          Any other value returns both parent and child nodes.
	     * @returns {Array}
	     */
	  }, {
	    key: "getConnectedNodes",
	    value: function getConnectedNodes(nodeId, direction) {
	      var nodeList = [];
	      if (this.body.nodes[nodeId] !== undefined) {
	        var node = this.body.nodes[nodeId];
	        var nodeObj = {}; // used to quickly check if node already exists
	        for (var i = 0; i < node.edges.length; i++) {
	          var edge = node.edges[i];
	          if (direction !== "to" && edge.toId == node.id) {
	            // these are double equals since ids can be numeric or string
	            if (nodeObj[edge.fromId] === undefined) {
	              nodeList.push(edge.fromId);
	              nodeObj[edge.fromId] = true;
	            }
	          } else if (direction !== "from" && edge.fromId == node.id) {
	            // these are double equals since ids can be numeric or string
	            if (nodeObj[edge.toId] === undefined) {
	              nodeList.push(edge.toId);
	              nodeObj[edge.toId] = true;
	            }
	          }
	        }
	      }
	      return nodeList;
	    }

	    /**
	     * Get the ids of the edges connected to this node.
	     *
	     * @param {Node.id} nodeId
	     * @returns {*}
	     */
	  }, {
	    key: "getConnectedEdges",
	    value: function getConnectedEdges(nodeId) {
	      var edgeList = [];
	      if (this.body.nodes[nodeId] !== undefined) {
	        var node = this.body.nodes[nodeId];
	        for (var i = 0; i < node.edges.length; i++) {
	          edgeList.push(node.edges[i].id);
	        }
	      } else {
	        console.error("NodeId provided for getConnectedEdges does not exist. Provided: ", nodeId);
	      }
	      return edgeList;
	    }

	    /**
	     * Move a node.
	     *
	     * @param {Node.id} nodeId
	     * @param {number} x
	     * @param {number} y
	     */
	  }, {
	    key: "moveNode",
	    value: function moveNode(nodeId, x, y) {
	      var _this4 = this;
	      if (this.body.nodes[nodeId] !== undefined) {
	        this.body.nodes[nodeId].x = Number(x);
	        this.body.nodes[nodeId].y = Number(y);
	        _setTimeout(function () {
	          _this4.body.emitter.emit("startSimulation");
	        }, 0);
	      } else {
	        console.error("Node id supplied to moveNode does not exist. Provided: ", nodeId);
	      }
	    }
	  }]);
	  return NodesHandler;
	}();

	var hasOwn$1 = hasOwnProperty_1;

	var isDataDescriptor$1 = function (descriptor) {
	  return descriptor !== undefined && (hasOwn$1(descriptor, 'value') || hasOwn$1(descriptor, 'writable'));
	};

	var $$2 = _export;
	var call = functionCall;
	var isObject$2 = isObject$m;
	var anObject$1 = anObject$f;
	var isDataDescriptor = isDataDescriptor$1;
	var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
	var getPrototypeOf = objectGetPrototypeOf$1;

	// `Reflect.get` method
	// https://tc39.es/ecma262/#sec-reflect.get
	function get$5(target, propertyKey /* , receiver */) {
	  var receiver = arguments.length < 3 ? target : arguments[2];
	  var descriptor, prototype;
	  if (anObject$1(target) === receiver) return target[propertyKey];
	  descriptor = getOwnPropertyDescriptorModule.f(target, propertyKey);
	  if (descriptor) return isDataDescriptor(descriptor)
	    ? descriptor.value
	    : descriptor.get === undefined ? undefined : call(descriptor.get, receiver);
	  if (isObject$2(prototype = getPrototypeOf(target))) return get$5(prototype, propertyKey, receiver);
	}

	$$2({ target: 'Reflect', stat: true }, {
	  get: get$5
	});

	var path$3 = path$A;

	var get$4 = path$3.Reflect.get;

	var parent$7 = get$4;

	var get$3 = parent$7;

	var parent$6 = get$3;

	var get$2 = parent$6;

	var parent$5 = get$2;

	var get$1 = parent$5;

	var get = get$1;

	var _Reflect$get = /*@__PURE__*/getDefaultExportFromCjs(get);

	var parent$4 = getOwnPropertyDescriptor$4;

	var getOwnPropertyDescriptor$2 = parent$4;

	var parent$3 = getOwnPropertyDescriptor$2;

	var getOwnPropertyDescriptor$1 = parent$3;

	var getOwnPropertyDescriptor = getOwnPropertyDescriptor$1;

	var _Object$getOwnPropertyDescriptor = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptor);

	function _superPropBase(object, property) {
	  while (!Object.prototype.hasOwnProperty.call(object, property)) {
	    object = _getPrototypeOf(object);
	    if (object === null) break;
	  }
	  return object;
	}

	function _get() {
	  if (typeof Reflect !== "undefined" && _Reflect$get) {
	    var _context;
	    _get = _bindInstanceProperty(_context = _Reflect$get).call(_context);
	  } else {
	    _get = function _get(target, property, receiver) {
	      var base = _superPropBase(target, property);
	      if (!base) return;
	      var desc = _Object$getOwnPropertyDescriptor(base, property);
	      if (desc.get) {
	        return desc.get.call(arguments.length < 3 ? target : receiver);
	      }
	      return desc.value;
	    };
	  }
	  return _get.apply(this, arguments);
	}

	var $$1 = _export;

	// eslint-disable-next-line es/no-math-hypot -- required for testing
	var $hypot = Math.hypot;
	var abs = Math.abs;
	var sqrt = Math.sqrt;

	// Chrome 77 bug
	// https://bugs.chromium.org/p/v8/issues/detail?id=9546
	var FORCED = !!$hypot && $hypot(Infinity, NaN) !== Infinity;

	// `Math.hypot` method
	// https://tc39.es/ecma262/#sec-math.hypot
	$$1({ target: 'Math', stat: true, arity: 2, forced: FORCED }, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  hypot: function hypot(value1, value2) {
	    var sum = 0;
	    var i = 0;
	    var aLen = arguments.length;
	    var larg = 0;
	    var arg, div;
	    while (i < aLen) {
	      arg = abs(arguments[i++]);
	      if (larg < arg) {
	        div = larg / arg;
	        sum = sum * div * div + 1;
	        larg = arg;
	      } else if (arg > 0) {
	        div = arg / larg;
	        sum += div * div;
	      } else sum += arg;
	    }
	    return larg === Infinity ? Infinity : larg * sqrt(sum);
	  }
	});

	var path$2 = path$A;

	var hypot$2 = path$2.Math.hypot;

	var parent$2 = hypot$2;

	var hypot$1 = parent$2;

	var hypot = hypot$1;

	var _Math$hypot = /*@__PURE__*/getDefaultExportFromCjs(hypot);

	function _createSuper$a(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$a(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$a() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * Common methods for endpoints
	 *
	 * @class
	 */
	var EndPoint = /*#__PURE__*/function () {
	  function EndPoint() {
	    _classCallCheck(this, EndPoint);
	  }
	  _createClass(EndPoint, null, [{
	    key: "transform",
	    value:
	    /**
	     * Apply transformation on points for display.
	     *
	     * The following is done:
	     * - rotate by the specified angle
	     * - multiply the (normalized) coordinates by the passed length
	     * - offset by the target coordinates
	     *
	     * @param points - The point(s) to be transformed.
	     * @param arrowData - The data determining the result of the transformation.
	     */
	    function transform(points, arrowData) {
	      if (!_Array$isArray(points)) {
	        points = [points];
	      }
	      var x = arrowData.point.x;
	      var y = arrowData.point.y;
	      var angle = arrowData.angle;
	      var length = arrowData.length;
	      for (var i = 0; i < points.length; ++i) {
	        var p = points[i];
	        var xt = p.x * Math.cos(angle) - p.y * Math.sin(angle);
	        var yt = p.x * Math.sin(angle) + p.y * Math.cos(angle);
	        p.x = x + length * xt;
	        p.y = y + length * yt;
	      }
	    }
	    /**
	     * Draw a closed path using the given real coordinates.
	     *
	     * @param ctx - The path will be rendered into this context.
	     * @param points - The points of the path.
	     */
	  }, {
	    key: "drawPath",
	    value: function drawPath(ctx, points) {
	      ctx.beginPath();
	      ctx.moveTo(points[0].x, points[0].y);
	      for (var i = 1; i < points.length; ++i) {
	        ctx.lineTo(points[i].x, points[i].y);
	      }
	      ctx.closePath();
	    }
	  }]);
	  return EndPoint;
	}();
	/**
	 * Drawing methods for the arrow endpoint.
	 */
	var Image$1 = /*#__PURE__*/function (_EndPoint) {
	  _inherits(Image, _EndPoint);
	  var _super = _createSuper$a(Image);
	  function Image() {
	    _classCallCheck(this, Image);
	    return _super.apply(this, arguments);
	  }
	  _createClass(Image, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns False as there is no way to fill an image.
	     */
	    function draw(ctx, arrowData) {
	      if (arrowData.image) {
	        ctx.save();
	        ctx.translate(arrowData.point.x, arrowData.point.y);
	        ctx.rotate(Math.PI / 2 + arrowData.angle);
	        var width = arrowData.imageWidth != null ? arrowData.imageWidth : arrowData.image.width;
	        var height = arrowData.imageHeight != null ? arrowData.imageHeight : arrowData.image.height;
	        arrowData.image.drawImageAtPosition(ctx, 1,
	        // scale
	        -width / 2,
	        // x
	        0,
	        // y
	        width, height);
	        ctx.restore();
	      }
	      return false;
	    }
	  }]);
	  return Image;
	}(EndPoint);
	/**
	 * Drawing methods for the arrow endpoint.
	 */
	var Arrow = /*#__PURE__*/function (_EndPoint2) {
	  _inherits(Arrow, _EndPoint2);
	  var _super2 = _createSuper$a(Arrow);
	  function Arrow() {
	    _classCallCheck(this, Arrow);
	    return _super2.apply(this, arguments);
	  }
	  _createClass(Arrow, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: 0,
	        y: 0
	      }, {
	        x: -1,
	        y: 0.3
	      }, {
	        x: -0.9,
	        y: 0
	      }, {
	        x: -1,
	        y: -0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);
	  return Arrow;
	}(EndPoint);
	/**
	 * Drawing methods for the crow endpoint.
	 */
	var Crow = /*#__PURE__*/function () {
	  function Crow() {
	    _classCallCheck(this, Crow);
	  }
	  _createClass(Crow, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: -1,
	        y: 0
	      }, {
	        x: 0,
	        y: 0.3
	      }, {
	        x: -0.4,
	        y: 0
	      }, {
	        x: 0,
	        y: -0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);
	  return Crow;
	}();
	/**
	 * Drawing methods for the curve endpoint.
	 */
	var Curve = /*#__PURE__*/function () {
	  function Curve() {
	    _classCallCheck(this, Curve);
	  }
	  _createClass(Curve, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var point = {
	        x: -0.4,
	        y: 0
	      };
	      EndPoint.transform(point, arrowData);
	      // Update endpoint style for drawing transparent arc.
	      ctx.strokeStyle = ctx.fillStyle;
	      ctx.fillStyle = "rgba(0, 0, 0, 0)";
	      // Define curve endpoint as semicircle.
	      var pi = Math.PI;
	      var startAngle = arrowData.angle - pi / 2;
	      var endAngle = arrowData.angle + pi / 2;
	      ctx.beginPath();
	      ctx.arc(point.x, point.y, arrowData.length * 0.4, startAngle, endAngle, false);
	      ctx.stroke();
	      return true;
	    }
	  }]);
	  return Curve;
	}();
	/**
	 * Drawing methods for the inverted curve endpoint.
	 */
	var InvertedCurve = /*#__PURE__*/function () {
	  function InvertedCurve() {
	    _classCallCheck(this, InvertedCurve);
	  }
	  _createClass(InvertedCurve, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var point = {
	        x: -0.3,
	        y: 0
	      };
	      EndPoint.transform(point, arrowData);
	      // Update endpoint style for drawing transparent arc.
	      ctx.strokeStyle = ctx.fillStyle;
	      ctx.fillStyle = "rgba(0, 0, 0, 0)";
	      // Define inverted curve endpoint as semicircle.
	      var pi = Math.PI;
	      var startAngle = arrowData.angle + pi / 2;
	      var endAngle = arrowData.angle + 3 * pi / 2;
	      ctx.beginPath();
	      ctx.arc(point.x, point.y, arrowData.length * 0.4, startAngle, endAngle, false);
	      ctx.stroke();
	      return true;
	    }
	  }]);
	  return InvertedCurve;
	}();
	/**
	 * Drawing methods for the trinagle endpoint.
	 */
	var Triangle = /*#__PURE__*/function () {
	  function Triangle() {
	    _classCallCheck(this, Triangle);
	  }
	  _createClass(Triangle, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: 0.02,
	        y: 0
	      }, {
	        x: -1,
	        y: 0.3
	      }, {
	        x: -1,
	        y: -0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);
	  return Triangle;
	}();
	/**
	 * Drawing methods for the inverted trinagle endpoint.
	 */
	var InvertedTriangle = /*#__PURE__*/function () {
	  function InvertedTriangle() {
	    _classCallCheck(this, InvertedTriangle);
	  }
	  _createClass(InvertedTriangle, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: 0,
	        y: 0.3
	      }, {
	        x: 0,
	        y: -0.3
	      }, {
	        x: -1,
	        y: 0
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);
	  return InvertedTriangle;
	}();
	/**
	 * Drawing methods for the circle endpoint.
	 */
	var Circle = /*#__PURE__*/function () {
	  function Circle() {
	    _classCallCheck(this, Circle);
	  }
	  _createClass(Circle, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      var point = {
	        x: -0.4,
	        y: 0
	      };
	      EndPoint.transform(point, arrowData);
	      drawCircle(ctx, point.x, point.y, arrowData.length * 0.4);
	      return true;
	    }
	  }]);
	  return Circle;
	}();
	/**
	 * Drawing methods for the bar endpoint.
	 */
	var Bar = /*#__PURE__*/function () {
	  function Bar() {
	    _classCallCheck(this, Bar);
	  }
	  _createClass(Bar, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      /*
	      var points = [
	        {x:0, y:0.5},
	        {x:0, y:-0.5}
	      ];
	           EndPoint.transform(points, arrowData);
	      ctx.beginPath();
	      ctx.moveTo(points[0].x, points[0].y);
	      ctx.lineTo(points[1].x, points[1].y);
	      ctx.stroke();
	      */
	      var points = [{
	        x: 0,
	        y: 0.5
	      }, {
	        x: 0,
	        y: -0.5
	      }, {
	        x: -0.15,
	        y: -0.5
	      }, {
	        x: -0.15,
	        y: 0.5
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);
	  return Bar;
	}();
	/**
	 * Drawing methods for the box endpoint.
	 */
	var Box = /*#__PURE__*/function () {
	  function Box() {
	    _classCallCheck(this, Box);
	  }
	  _createClass(Box, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      var points = [{
	        x: 0,
	        y: 0.3
	      }, {
	        x: 0,
	        y: -0.3
	      }, {
	        x: -0.6,
	        y: -0.3
	      }, {
	        x: -0.6,
	        y: 0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);
	  return Box;
	}();
	/**
	 * Drawing methods for the diamond endpoint.
	 */
	var Diamond = /*#__PURE__*/function () {
	  function Diamond() {
	    _classCallCheck(this, Diamond);
	  }
	  _createClass(Diamond, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      var points = [{
	        x: 0,
	        y: 0
	      }, {
	        x: -0.5,
	        y: -0.3
	      }, {
	        x: -1,
	        y: 0
	      }, {
	        x: -0.5,
	        y: 0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);
	  return Diamond;
	}();
	/**
	 * Drawing methods for the vee endpoint.
	 */
	var Vee = /*#__PURE__*/function () {
	  function Vee() {
	    _classCallCheck(this, Vee);
	  }
	  _createClass(Vee, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: -1,
	        y: 0.3
	      }, {
	        x: -0.5,
	        y: 0
	      }, {
	        x: -1,
	        y: -0.3
	      }, {
	        x: 0,
	        y: 0
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);
	  return Vee;
	}();
	/**
	 * Drawing methods for the endpoints.
	 */
	var EndPoints = /*#__PURE__*/function () {
	  function EndPoints() {
	    _classCallCheck(this, EndPoints);
	  }
	  _createClass(EndPoints, null, [{
	    key: "draw",
	    value:
	    /**
	     * Draw an endpoint.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     * @returns True if ctx.fill() can be used to fill the arrow, false otherwise.
	     */
	    function draw(ctx, arrowData) {
	      var type;
	      if (arrowData.type) {
	        type = arrowData.type.toLowerCase();
	      }
	      switch (type) {
	        case "image":
	          return Image$1.draw(ctx, arrowData);
	        case "circle":
	          return Circle.draw(ctx, arrowData);
	        case "box":
	          return Box.draw(ctx, arrowData);
	        case "crow":
	          return Crow.draw(ctx, arrowData);
	        case "curve":
	          return Curve.draw(ctx, arrowData);
	        case "diamond":
	          return Diamond.draw(ctx, arrowData);
	        case "inv_curve":
	          return InvertedCurve.draw(ctx, arrowData);
	        case "triangle":
	          return Triangle.draw(ctx, arrowData);
	        case "inv_triangle":
	          return InvertedTriangle.draw(ctx, arrowData);
	        case "bar":
	          return Bar.draw(ctx, arrowData);
	        case "vee":
	          return Vee.draw(ctx, arrowData);
	        case "arrow": // fall-through
	        default:
	          return Arrow.draw(ctx, arrowData);
	      }
	    }
	  }]);
	  return EndPoints;
	}();

	function ownKeys$1(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols) { var o = _Object$getOwnPropertySymbols(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor$1(e, r).enumerable; })), t.push.apply(t, o); } return t; }
	function _objectSpread$1(e) { for (var r = 1; r < arguments.length; r++) { var _context2, _context3; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context2 = ownKeys$1(Object(t), !0)).call(_context2, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context3 = ownKeys$1(Object(t))).call(_context3, function (r) { _Object$defineProperty(e, r, _Object$getOwnPropertyDescriptor$1(t, r)); }); } return e; }
	/**
	 * The Base Class for all edges.
	 */
	var EdgeBase = /*#__PURE__*/function () {
	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param _body - The body of the network.
	   * @param _labelModule - Label module.
	   */
	  function EdgeBase(options, _body, _labelModule) {
	    _classCallCheck(this, EdgeBase);
	    this._body = _body;
	    this._labelModule = _labelModule;
	    this.color = {};
	    this.colorDirty = true;
	    this.hoverWidth = 1.5;
	    this.selectionWidth = 2;
	    this.setOptions(options);
	    this.fromPoint = this.from;
	    this.toPoint = this.to;
	  }
	  /** @inheritDoc */
	  _createClass(EdgeBase, [{
	    key: "connect",
	    value: function connect() {
	      this.from = this._body.nodes[this.options.from];
	      this.to = this._body.nodes[this.options.to];
	    }
	    /** @inheritDoc */
	  }, {
	    key: "cleanup",
	    value: function cleanup() {
	      return false;
	    }
	    /**
	     * Set new edge options.
	     *
	     * @param options - The new edge options object.
	     */
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	      this.from = this._body.nodes[this.options.from];
	      this.to = this._body.nodes[this.options.to];
	      this.id = this.options.id;
	    }
	    /** @inheritDoc */
	  }, {
	    key: "drawLine",
	    value: function drawLine(ctx, values, _selected, _hover) {
	      var viaNode = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : this.getViaNode();
	      // set style
	      ctx.strokeStyle = this.getColor(ctx, values);
	      ctx.lineWidth = values.width;
	      if (values.dashes !== false) {
	        this._drawDashedLine(ctx, values, viaNode);
	      } else {
	        this._drawLine(ctx, values, viaNode);
	      }
	    }
	    /**
	     * Draw a line with given style between two nodes through supplied node(s).
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values like color, opacity or shadow.
	     * @param viaNode - Additional control point(s) for the edge.
	     * @param fromPoint - TODO: Seems ignored, remove?
	     * @param toPoint - TODO: Seems ignored, remove?
	     */
	  }, {
	    key: "_drawLine",
	    value: function _drawLine(ctx, values, viaNode, fromPoint, toPoint) {
	      if (this.from != this.to) {
	        // draw line
	        this._line(ctx, values, viaNode, fromPoint, toPoint);
	      } else {
	        var _this$_getCircleData = this._getCircleData(ctx),
	          _this$_getCircleData2 = _slicedToArray(_this$_getCircleData, 3),
	          x = _this$_getCircleData2[0],
	          y = _this$_getCircleData2[1],
	          radius = _this$_getCircleData2[2];
	        this._circle(ctx, values, x, y, radius);
	      }
	    }
	    /**
	     * Draw a dashed line with given style between two nodes through supplied node(s).
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values like color, opacity or shadow.
	     * @param viaNode - Additional control point(s) for the edge.
	     * @param _fromPoint - Ignored (TODO: remove in the future).
	     * @param _toPoint - Ignored (TODO: remove in the future).
	     */
	  }, {
	    key: "_drawDashedLine",
	    value: function _drawDashedLine(ctx, values, viaNode, _fromPoint, _toPoint) {
	      ctx.lineCap = "round";
	      var pattern = _Array$isArray(values.dashes) ? values.dashes : [5, 5];
	      // only firefox and chrome support this method, else we use the legacy one.
	      if (ctx.setLineDash !== undefined) {
	        ctx.save();
	        // set dash settings for chrome or firefox
	        ctx.setLineDash(pattern);
	        ctx.lineDashOffset = 0;
	        // draw the line
	        if (this.from != this.to) {
	          // draw line
	          this._line(ctx, values, viaNode);
	        } else {
	          var _this$_getCircleData3 = this._getCircleData(ctx),
	            _this$_getCircleData4 = _slicedToArray(_this$_getCircleData3, 3),
	            x = _this$_getCircleData4[0],
	            y = _this$_getCircleData4[1],
	            radius = _this$_getCircleData4[2];
	          this._circle(ctx, values, x, y, radius);
	        }
	        // restore the dash settings.
	        ctx.setLineDash([0]);
	        ctx.lineDashOffset = 0;
	        ctx.restore();
	      } else {
	        // unsupporting smooth lines
	        if (this.from != this.to) {
	          // draw line
	          drawDashedLine(ctx, this.from.x, this.from.y, this.to.x, this.to.y, pattern);
	        } else {
	          var _this$_getCircleData5 = this._getCircleData(ctx),
	            _this$_getCircleData6 = _slicedToArray(_this$_getCircleData5, 3),
	            _x = _this$_getCircleData6[0],
	            _y = _this$_getCircleData6[1],
	            _radius = _this$_getCircleData6[2];
	          this._circle(ctx, values, _x, _y, _radius);
	        }
	        // draw shadow if enabled
	        this.enableShadow(ctx, values);
	        ctx.stroke();
	        // disable shadows for other elements.
	        this.disableShadow(ctx, values);
	      }
	    }
	    /**
	     * Find the intersection between the border of the node and the edge.
	     *
	     * @param node - The node (either from or to node of the edge).
	     * @param ctx - The context that will be used for rendering.
	     * @param options - Additional options.
	     * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
	     */
	  }, {
	    key: "findBorderPosition",
	    value: function findBorderPosition(node, ctx, options) {
	      if (this.from != this.to) {
	        return this._findBorderPosition(node, ctx, options);
	      } else {
	        return this._findBorderPositionCircle(node, ctx, options);
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "findBorderPositions",
	    value: function findBorderPositions(ctx) {
	      if (this.from != this.to) {
	        return {
	          from: this._findBorderPosition(this.from, ctx),
	          to: this._findBorderPosition(this.to, ctx)
	        };
	      } else {
	        var _context;
	        var _this$_getCircleData$ = _sliceInstanceProperty(_context = this._getCircleData(ctx)).call(_context, 0, 2),
	          _this$_getCircleData$2 = _slicedToArray(_this$_getCircleData$, 2),
	          x = _this$_getCircleData$2[0],
	          y = _this$_getCircleData$2[1];
	        return {
	          from: this._findBorderPositionCircle(this.from, ctx, {
	            x: x,
	            y: y,
	            low: 0.25,
	            high: 0.6,
	            direction: -1
	          }),
	          to: this._findBorderPositionCircle(this.from, ctx, {
	            x: x,
	            y: y,
	            low: 0.6,
	            high: 0.8,
	            direction: 1
	          })
	        };
	      }
	    }
	    /**
	     * Compute the center point and radius of an edge connected to the same node at both ends.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @returns `[x, y, radius]`
	     */
	  }, {
	    key: "_getCircleData",
	    value: function _getCircleData(ctx) {
	      var radius = this.options.selfReference.size;
	      if (ctx !== undefined) {
	        if (this.from.shape.width === undefined) {
	          this.from.shape.resize(ctx);
	        }
	      }
	      // get circle coordinates
	      var coordinates = getSelfRefCoordinates(ctx, this.options.selfReference.angle, radius, this.from);
	      return [coordinates.x, coordinates.y, radius];
	    }
	    /**
	     * Get a point on a circle.
	     *
	     * @param x - Center of the circle on the x axis.
	     * @param y - Center of the circle on the y axis.
	     * @param radius - Radius of the circle.
	     * @param position - Value between 0 (line start) and 1 (line end).
	     * @returns Cartesian coordinates of requested point on the circle.
	     */
	  }, {
	    key: "_pointOnCircle",
	    value: function _pointOnCircle(x, y, radius, position) {
	      var angle = position * 2 * Math.PI;
	      return {
	        x: x + radius * Math.cos(angle),
	        y: y - radius * Math.sin(angle)
	      };
	    }
	    /**
	     * Find the intersection between the border of the node and the edge.
	     *
	     * @remarks
	     * This function uses binary search to look for the point where the circle crosses the border of the node.
	     * @param nearNode - The node (either from or to node of the edge).
	     * @param ctx - The context that will be used for rendering.
	     * @param options - Additional options.
	     * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
	     */
	  }, {
	    key: "_findBorderPositionCircle",
	    value: function _findBorderPositionCircle(nearNode, ctx, options) {
	      var x = options.x;
	      var y = options.y;
	      var low = options.low;
	      var high = options.high;
	      var direction = options.direction;
	      var maxIterations = 10;
	      var radius = this.options.selfReference.size;
	      var threshold = 0.05;
	      var pos;
	      var middle = (low + high) * 0.5;
	      var endPointOffset = 0;
	      if (this.options.arrowStrikethrough === true) {
	        if (direction === -1) {
	          endPointOffset = this.options.endPointOffset.from;
	        } else if (direction === 1) {
	          endPointOffset = this.options.endPointOffset.to;
	        }
	      }
	      var iteration = 0;
	      do {
	        middle = (low + high) * 0.5;
	        pos = this._pointOnCircle(x, y, radius, middle);
	        var angle = Math.atan2(nearNode.y - pos.y, nearNode.x - pos.x);
	        var distanceToBorder = nearNode.distanceToBorder(ctx, angle) + endPointOffset;
	        var distanceToPoint = Math.sqrt(Math.pow(pos.x - nearNode.x, 2) + Math.pow(pos.y - nearNode.y, 2));
	        var difference = distanceToBorder - distanceToPoint;
	        if (Math.abs(difference) < threshold) {
	          break; // found
	        } else if (difference > 0) {
	          // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
	          if (direction > 0) {
	            low = middle;
	          } else {
	            high = middle;
	          }
	        } else {
	          if (direction > 0) {
	            high = middle;
	          } else {
	            low = middle;
	          }
	        }
	        ++iteration;
	      } while (low <= high && iteration < maxIterations);
	      return _objectSpread$1(_objectSpread$1({}, pos), {}, {
	        t: middle
	      });
	    }
	    /**
	     * Get the line width of the edge. Depends on width and whether one of the connected nodes is selected.
	     *
	     * @param selected - Determines wheter the line is selected.
	     * @param hover - Determines wheter the line is being hovered, only applies if selected is false.
	     * @returns The width of the line.
	     */
	  }, {
	    key: "getLineWidth",
	    value: function getLineWidth(selected, hover) {
	      if (selected === true) {
	        return Math.max(this.selectionWidth, 0.3 / this._body.view.scale);
	      } else if (hover === true) {
	        return Math.max(this.hoverWidth, 0.3 / this._body.view.scale);
	      } else {
	        return Math.max(this.options.width, 0.3 / this._body.view.scale);
	      }
	    }
	    /**
	     * Compute the color or gradient for given edge.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values like color, opacity or shadow.
	     * @param _selected - Ignored (TODO: remove in the future).
	     * @param _hover - Ignored (TODO: remove in the future).
	     * @returns Color string if single color is inherited or gradient if two.
	     */
	  }, {
	    key: "getColor",
	    value: function getColor(ctx, values) {
	      if (values.inheritsColor !== false) {
	        // when this is a loop edge, just use the 'from' method
	        if (values.inheritsColor === "both" && this.from.id !== this.to.id) {
	          var grd = ctx.createLinearGradient(this.from.x, this.from.y, this.to.x, this.to.y);
	          var fromColor = this.from.options.color.highlight.border;
	          var toColor = this.to.options.color.highlight.border;
	          if (this.from.selected === false && this.to.selected === false) {
	            fromColor = overrideOpacity(this.from.options.color.border, values.opacity);
	            toColor = overrideOpacity(this.to.options.color.border, values.opacity);
	          } else if (this.from.selected === true && this.to.selected === false) {
	            toColor = this.to.options.color.border;
	          } else if (this.from.selected === false && this.to.selected === true) {
	            fromColor = this.from.options.color.border;
	          }
	          grd.addColorStop(0, fromColor);
	          grd.addColorStop(1, toColor);
	          // -------------------- this returns -------------------- //
	          return grd;
	        }
	        if (values.inheritsColor === "to") {
	          return overrideOpacity(this.to.options.color.border, values.opacity);
	        } else {
	          // "from"
	          return overrideOpacity(this.from.options.color.border, values.opacity);
	        }
	      } else {
	        return overrideOpacity(values.color, values.opacity);
	      }
	    }
	    /**
	     * Draw a line from a node to itself, a circle.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values like color, opacity or shadow.
	     * @param x - Center of the circle on the x axis.
	     * @param y - Center of the circle on the y axis.
	     * @param radius - Radius of the circle.
	     */
	  }, {
	    key: "_circle",
	    value: function _circle(ctx, values, x, y, radius) {
	      // draw shadow if enabled
	      this.enableShadow(ctx, values);
	      //full circle
	      var angleFrom = 0;
	      var angleTo = Math.PI * 2;
	      if (!this.options.selfReference.renderBehindTheNode) {
	        //render only parts which are not overlaping with parent node
	        //need to find x,y of from point and x,y to point
	        //calculating radians
	        var low = this.options.selfReference.angle;
	        var high = this.options.selfReference.angle + Math.PI;
	        var pointTFrom = this._findBorderPositionCircle(this.from, ctx, {
	          x: x,
	          y: y,
	          low: low,
	          high: high,
	          direction: -1
	        });
	        var pointTTo = this._findBorderPositionCircle(this.from, ctx, {
	          x: x,
	          y: y,
	          low: low,
	          high: high,
	          direction: 1
	        });
	        angleFrom = Math.atan2(pointTFrom.y - y, pointTFrom.x - x);
	        angleTo = Math.atan2(pointTTo.y - y, pointTTo.x - x);
	      }
	      // draw a circle
	      ctx.beginPath();
	      ctx.arc(x, y, radius, angleFrom, angleTo, false);
	      ctx.stroke();
	      // disable shadows for other elements.
	      this.disableShadow(ctx, values);
	    }
	    /**
	     * @inheritDoc
	     * @remarks
	     * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
	     */
	  }, {
	    key: "getDistanceToEdge",
	    value: function getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      if (this.from != this.to) {
	        return this._getDistanceToEdge(x1, y1, x2, y2, x3, y3);
	      } else {
	        var _this$_getCircleData7 = this._getCircleData(undefined),
	          _this$_getCircleData8 = _slicedToArray(_this$_getCircleData7, 3),
	          x = _this$_getCircleData8[0],
	          y = _this$_getCircleData8[1],
	          radius = _this$_getCircleData8[2];
	        var dx = x - x3;
	        var dy = y - y3;
	        return Math.abs(Math.sqrt(dx * dx + dy * dy) - radius);
	      }
	    }
	    /**
	     * Calculate the distance between a point (x3, y3) and a line segment from (x1, y1) to (x2, y2).
	     *
	     * @param x1 - First end of the line segment on the x axis.
	     * @param y1 - First end of the line segment on the y axis.
	     * @param x2 - Second end of the line segment on the x axis.
	     * @param y2 - Second end of the line segment on the y axis.
	     * @param x3 - Position of the point on the x axis.
	     * @param y3 - Position of the point on the y axis.
	     * @returns The distance between the line segment and the point.
	     */
	  }, {
	    key: "_getDistanceToLine",
	    value: function _getDistanceToLine(x1, y1, x2, y2, x3, y3) {
	      var px = x2 - x1;
	      var py = y2 - y1;
	      var something = px * px + py * py;
	      var u = ((x3 - x1) * px + (y3 - y1) * py) / something;
	      if (u > 1) {
	        u = 1;
	      } else if (u < 0) {
	        u = 0;
	      }
	      var x = x1 + u * px;
	      var y = y1 + u * py;
	      var dx = x - x3;
	      var dy = y - y3;
	      //# Note: If the actual distance does not matter,
	      //# if you only want to compare what this function
	      //# returns to other results of this function, you
	      //# can just return the squared distance instead
	      //# (i.e. remove the sqrt) to gain a little performance
	      return Math.sqrt(dx * dx + dy * dy);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getArrowData",
	    value: function getArrowData(ctx, position, viaNode, _selected, _hover, values) {
	      // set lets
	      var angle;
	      var arrowPoint;
	      var node1;
	      var node2;
	      var reversed;
	      var scaleFactor;
	      var type;
	      var lineWidth = values.width;
	      if (position === "from") {
	        node1 = this.from;
	        node2 = this.to;
	        reversed = values.fromArrowScale < 0;
	        scaleFactor = Math.abs(values.fromArrowScale);
	        type = values.fromArrowType;
	      } else if (position === "to") {
	        node1 = this.to;
	        node2 = this.from;
	        reversed = values.toArrowScale < 0;
	        scaleFactor = Math.abs(values.toArrowScale);
	        type = values.toArrowType;
	      } else {
	        node1 = this.to;
	        node2 = this.from;
	        reversed = values.middleArrowScale < 0;
	        scaleFactor = Math.abs(values.middleArrowScale);
	        type = values.middleArrowType;
	      }
	      var length = 15 * scaleFactor + 3 * lineWidth; // 3* lineWidth is the width of the edge.
	      // if not connected to itself
	      if (node1 != node2) {
	        var approximateEdgeLength = _Math$hypot(node1.x - node2.x, node1.y - node2.y);
	        var relativeLength = length / approximateEdgeLength;
	        if (position !== "middle") {
	          // draw arrow head
	          if (this.options.smooth.enabled === true) {
	            var pointT = this._findBorderPosition(node1, ctx, {
	              via: viaNode
	            });
	            var guidePos = this.getPoint(pointT.t + relativeLength * (position === "from" ? 1 : -1), viaNode);
	            angle = Math.atan2(pointT.y - guidePos.y, pointT.x - guidePos.x);
	            arrowPoint = pointT;
	          } else {
	            angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
	            arrowPoint = this._findBorderPosition(node1, ctx);
	          }
	        } else {
	          // Negative half length reverses arrow direction.
	          var halfLength = (reversed ? -relativeLength : relativeLength) / 2;
	          var guidePos1 = this.getPoint(0.5 + halfLength, viaNode);
	          var guidePos2 = this.getPoint(0.5 - halfLength, viaNode);
	          angle = Math.atan2(guidePos1.y - guidePos2.y, guidePos1.x - guidePos2.x);
	          arrowPoint = this.getPoint(0.5, viaNode);
	        }
	      } else {
	        // draw circle
	        var _this$_getCircleData9 = this._getCircleData(ctx),
	          _this$_getCircleData10 = _slicedToArray(_this$_getCircleData9, 3),
	          x = _this$_getCircleData10[0],
	          y = _this$_getCircleData10[1],
	          radius = _this$_getCircleData10[2];
	        if (position === "from") {
	          var low = this.options.selfReference.angle;
	          var high = this.options.selfReference.angle + Math.PI;
	          var _pointT = this._findBorderPositionCircle(this.from, ctx, {
	            x: x,
	            y: y,
	            low: low,
	            high: high,
	            direction: -1
	          });
	          angle = _pointT.t * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
	          arrowPoint = _pointT;
	        } else if (position === "to") {
	          var _low = this.options.selfReference.angle;
	          var _high = this.options.selfReference.angle + Math.PI;
	          var _pointT2 = this._findBorderPositionCircle(this.from, ctx, {
	            x: x,
	            y: y,
	            low: _low,
	            high: _high,
	            direction: 1
	          });
	          angle = _pointT2.t * -2 * Math.PI + 1.5 * Math.PI - 1.1 * Math.PI;
	          arrowPoint = _pointT2;
	        } else {
	          var pos = this.options.selfReference.angle / (2 * Math.PI);
	          arrowPoint = this._pointOnCircle(x, y, radius, pos);
	          angle = pos * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
	        }
	      }
	      var xi = arrowPoint.x - length * 0.9 * Math.cos(angle);
	      var yi = arrowPoint.y - length * 0.9 * Math.sin(angle);
	      var arrowCore = {
	        x: xi,
	        y: yi
	      };
	      return {
	        point: arrowPoint,
	        core: arrowCore,
	        angle: angle,
	        length: length,
	        type: type
	      };
	    }
	    /** @inheritDoc */
	  }, {
	    key: "drawArrowHead",
	    value: function drawArrowHead(ctx, values, _selected, _hover, arrowData) {
	      // set style
	      ctx.strokeStyle = this.getColor(ctx, values);
	      ctx.fillStyle = ctx.strokeStyle;
	      ctx.lineWidth = values.width;
	      var canFill = EndPoints.draw(ctx, arrowData);
	      if (canFill) {
	        // draw shadow if enabled
	        this.enableShadow(ctx, values);
	        _fillInstanceProperty(ctx).call(ctx);
	        // disable shadows for other elements.
	        this.disableShadow(ctx, values);
	      }
	    }
	    /**
	     * Set the shadow formatting values in the context if enabled, do nothing otherwise.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values for the shadow.
	     */
	  }, {
	    key: "enableShadow",
	    value: function enableShadow(ctx, values) {
	      if (values.shadow === true) {
	        ctx.shadowColor = values.shadowColor;
	        ctx.shadowBlur = values.shadowSize;
	        ctx.shadowOffsetX = values.shadowX;
	        ctx.shadowOffsetY = values.shadowY;
	      }
	    }
	    /**
	     * Reset the shadow formatting values in the context if enabled, do nothing otherwise.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values for the shadow.
	     */
	  }, {
	    key: "disableShadow",
	    value: function disableShadow(ctx, values) {
	      if (values.shadow === true) {
	        ctx.shadowColor = "rgba(0,0,0,0)";
	        ctx.shadowBlur = 0;
	        ctx.shadowOffsetX = 0;
	        ctx.shadowOffsetY = 0;
	      }
	    }
	    /**
	     * Render the background according to the formatting values.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values for the background.
	     */
	  }, {
	    key: "drawBackground",
	    value: function drawBackground(ctx, values) {
	      if (values.background !== false) {
	        // save original line attrs
	        var origCtxAttr = {
	          strokeStyle: ctx.strokeStyle,
	          lineWidth: ctx.lineWidth,
	          dashes: ctx.dashes
	        };
	        ctx.strokeStyle = values.backgroundColor;
	        ctx.lineWidth = values.backgroundSize;
	        this.setStrokeDashed(ctx, values.backgroundDashes);
	        ctx.stroke();
	        // restore original line attrs
	        ctx.strokeStyle = origCtxAttr.strokeStyle;
	        ctx.lineWidth = origCtxAttr.lineWidth;
	        ctx.dashes = origCtxAttr.dashes;
	        this.setStrokeDashed(ctx, values.dashes);
	      }
	    }
	    /**
	     * Set the line dash pattern if supported. Logs a warning to the console if it isn't supported.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param dashes - The pattern [line, space, line…], true for default dashed line or false for normal line.
	     */
	  }, {
	    key: "setStrokeDashed",
	    value: function setStrokeDashed(ctx, dashes) {
	      if (dashes !== false) {
	        if (ctx.setLineDash !== undefined) {
	          var pattern = _Array$isArray(dashes) ? dashes : [5, 5];
	          ctx.setLineDash(pattern);
	        } else {
	          console.warn("setLineDash is not supported in this browser. The dashed stroke cannot be used.");
	        }
	      } else {
	        if (ctx.setLineDash !== undefined) {
	          ctx.setLineDash([]);
	        } else {
	          console.warn("setLineDash is not supported in this browser. The dashed stroke cannot be used.");
	        }
	      }
	    }
	  }]);
	  return EdgeBase;
	}();

	function ownKeys(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols) { var o = _Object$getOwnPropertySymbols(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor$1(e, r).enumerable; })), t.push.apply(t, o); } return t; }
	function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var _context, _context2; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context = ownKeys(Object(t), !0)).call(_context, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context2 = ownKeys(Object(t))).call(_context2, function (r) { _Object$defineProperty(e, r, _Object$getOwnPropertyDescriptor$1(t, r)); }); } return e; }
	function _createSuper$9(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$9(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$9() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * The Base Class for all Bezier edges.
	 * Bezier curves are used to model smooth gradual curves in paths between nodes.
	 */
	var BezierEdgeBase = /*#__PURE__*/function (_EdgeBase) {
	  _inherits(BezierEdgeBase, _EdgeBase);
	  var _super = _createSuper$9(BezierEdgeBase);
	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function BezierEdgeBase(options, body, labelModule) {
	    _classCallCheck(this, BezierEdgeBase);
	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   * Find the intersection between the border of the node and the edge.
	   *
	   * @remarks
	   * This function uses binary search to look for the point where the bezier curve crosses the border of the node.
	   * @param nearNode - The node (either from or to node of the edge).
	   * @param ctx - The context that will be used for rendering.
	   * @param viaNode - Additional node(s) the edge passes through.
	   * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
	   */
	  _createClass(BezierEdgeBase, [{
	    key: "_findBorderPositionBezier",
	    value: function _findBorderPositionBezier(nearNode, ctx) {
	      var viaNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this._getViaCoordinates();
	      var maxIterations = 10;
	      var threshold = 0.2;
	      var from = false;
	      var high = 1;
	      var low = 0;
	      var node = this.to;
	      var pos;
	      var middle;
	      var endPointOffset = this.options.endPointOffset ? this.options.endPointOffset.to : 0;
	      if (nearNode.id === this.from.id) {
	        node = this.from;
	        from = true;
	        endPointOffset = this.options.endPointOffset ? this.options.endPointOffset.from : 0;
	      }
	      if (this.options.arrowStrikethrough === false) {
	        endPointOffset = 0;
	      }
	      var iteration = 0;
	      do {
	        middle = (low + high) * 0.5;
	        pos = this.getPoint(middle, viaNode);
	        var angle = Math.atan2(node.y - pos.y, node.x - pos.x);
	        var distanceToBorder = node.distanceToBorder(ctx, angle) + endPointOffset;
	        var distanceToPoint = Math.sqrt(Math.pow(pos.x - node.x, 2) + Math.pow(pos.y - node.y, 2));
	        var difference = distanceToBorder - distanceToPoint;
	        if (Math.abs(difference) < threshold) {
	          break; // found
	        } else if (difference < 0) {
	          // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
	          if (from === false) {
	            low = middle;
	          } else {
	            high = middle;
	          }
	        } else {
	          if (from === false) {
	            high = middle;
	          } else {
	            low = middle;
	          }
	        }
	        ++iteration;
	      } while (low <= high && iteration < maxIterations);
	      return _objectSpread(_objectSpread({}, pos), {}, {
	        t: middle
	      });
	    }
	    /**
	     * Calculate the distance between a point (x3,y3) and a line segment from (x1,y1) to (x2,y2).
	     *
	     * @remarks
	     * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
	     * @param x1 - First end of the line segment on the x axis.
	     * @param y1 - First end of the line segment on the y axis.
	     * @param x2 - Second end of the line segment on the x axis.
	     * @param y2 - Second end of the line segment on the y axis.
	     * @param x3 - Position of the point on the x axis.
	     * @param y3 - Position of the point on the y axis.
	     * @param via - The control point for the edge.
	     * @returns The distance between the line segment and the point.
	     */
	  }, {
	    key: "_getDistanceToBezierEdge",
	    value: function _getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, via) {
	      // x3,y3 is the point
	      var minDistance = 1e9;
	      var distance;
	      var i, t, x, y;
	      var lastX = x1;
	      var lastY = y1;
	      for (i = 1; i < 10; i++) {
	        t = 0.1 * i;
	        x = Math.pow(1 - t, 2) * x1 + 2 * t * (1 - t) * via.x + Math.pow(t, 2) * x2;
	        y = Math.pow(1 - t, 2) * y1 + 2 * t * (1 - t) * via.y + Math.pow(t, 2) * y2;
	        if (i > 0) {
	          distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);
	          minDistance = distance < minDistance ? distance : minDistance;
	        }
	        lastX = x;
	        lastY = y;
	      }
	      return minDistance;
	    }
	    /**
	     * Render a bezier curve between two nodes.
	     *
	     * @remarks
	     * The method accepts zero, one or two control points.
	     * Passing zero control points just draws a straight line.
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Style options for edge drawing.
	     * @param viaNode1 - First control point for curve drawing.
	     * @param viaNode2 - Second control point for curve drawing.
	     */
	  }, {
	    key: "_bezierCurve",
	    value: function _bezierCurve(ctx, values, viaNode1, viaNode2) {
	      ctx.beginPath();
	      ctx.moveTo(this.fromPoint.x, this.fromPoint.y);
	      if (viaNode1 != null && viaNode1.x != null) {
	        if (viaNode2 != null && viaNode2.x != null) {
	          ctx.bezierCurveTo(viaNode1.x, viaNode1.y, viaNode2.x, viaNode2.y, this.toPoint.x, this.toPoint.y);
	        } else {
	          ctx.quadraticCurveTo(viaNode1.x, viaNode1.y, this.toPoint.x, this.toPoint.y);
	        }
	      } else {
	        // fallback to normal straight edge
	        ctx.lineTo(this.toPoint.x, this.toPoint.y);
	      }
	      // draw a background
	      this.drawBackground(ctx, values);
	      // draw shadow if enabled
	      this.enableShadow(ctx, values);
	      ctx.stroke();
	      this.disableShadow(ctx, values);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return this._getViaCoordinates();
	    }
	  }]);
	  return BezierEdgeBase;
	}(EdgeBase);

	function _createSuper$8(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$8(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$8() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Dynamic Bezier Edge. Bezier curves are used to model smooth gradual
	 * curves in paths between nodes. The Dynamic piece refers to how the curve
	 * reacts to physics changes.
	 *
	 * @augments BezierEdgeBase
	 */
	var BezierEdgeDynamic = /*#__PURE__*/function (_BezierEdgeBase) {
	  _inherits(BezierEdgeDynamic, _BezierEdgeBase);
	  var _super = _createSuper$8(BezierEdgeDynamic);
	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function BezierEdgeDynamic(options, body, labelModule) {
	    var _this;
	    _classCallCheck(this, BezierEdgeDynamic);
	    //this.via = undefined; // Here for completeness but not allowed to defined before super() is invoked.
	    _this = _super.call(this, options, body, labelModule); // --> this calls the setOptions below
	    _this.via = _this.via; // constructor → super → super → setOptions → setupSupportNode
	    _this._boundFunction = function () {
	      _this.positionBezierNode();
	    };
	    _this._body.emitter.on("_repositionBezierNodes", _this._boundFunction);
	    return _this;
	  }
	  /** @inheritDoc */
	  _createClass(BezierEdgeDynamic, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      _get(_getPrototypeOf(BezierEdgeDynamic.prototype), "setOptions", this).call(this, options);
	      // check if the physics has changed.
	      var physicsChange = false;
	      if (this.options.physics !== options.physics) {
	        physicsChange = true;
	      }
	      // set the options and the to and from nodes
	      this.options = options;
	      this.id = this.options.id;
	      this.from = this._body.nodes[this.options.from];
	      this.to = this._body.nodes[this.options.to];
	      // setup the support node and connect
	      this.setupSupportNode();
	      this.connect();
	      // when we change the physics state of the edge, we reposition the support node.
	      if (physicsChange === true) {
	        this.via.setOptions({
	          physics: this.options.physics
	        });
	        this.positionBezierNode();
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "connect",
	    value: function connect() {
	      this.from = this._body.nodes[this.options.from];
	      this.to = this._body.nodes[this.options.to];
	      if (this.from === undefined || this.to === undefined || this.options.physics === false) {
	        this.via.setOptions({
	          physics: false
	        });
	      } else {
	        // fix weird behaviour where a self referencing node has physics enabled
	        if (this.from.id === this.to.id) {
	          this.via.setOptions({
	            physics: false
	          });
	        } else {
	          this.via.setOptions({
	            physics: true
	          });
	        }
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "cleanup",
	    value: function cleanup() {
	      this._body.emitter.off("_repositionBezierNodes", this._boundFunction);
	      if (this.via !== undefined) {
	        delete this._body.nodes[this.via.id];
	        this.via = undefined;
	        return true;
	      }
	      return false;
	    }
	    /**
	     * Create and add a support node if not already present.
	     *
	     * @remarks
	     * Bezier curves require an anchor point to calculate the smooth flow.
	     * These points are nodes.
	     * These nodes are invisible but are used for the force calculation.
	     *
	     * The changed data is not called, if needed, it is returned by the main edge constructor.
	     */
	  }, {
	    key: "setupSupportNode",
	    value: function setupSupportNode() {
	      if (this.via === undefined) {
	        var nodeId = "edgeId:" + this.id;
	        var node = this._body.functions.createNode({
	          id: nodeId,
	          shape: "circle",
	          physics: true,
	          hidden: true
	        });
	        this._body.nodes[nodeId] = node;
	        this.via = node;
	        this.via.parentEdgeId = this.id;
	        this.positionBezierNode();
	      }
	    }
	    /**
	     * Position bezier node.
	     */
	  }, {
	    key: "positionBezierNode",
	    value: function positionBezierNode() {
	      if (this.via !== undefined && this.from !== undefined && this.to !== undefined) {
	        this.via.x = 0.5 * (this.from.x + this.to.x);
	        this.via.y = 0.5 * (this.from.y + this.to.y);
	      } else if (this.via !== undefined) {
	        this.via.x = 0;
	        this.via.y = 0;
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_line",
	    value: function _line(ctx, values, viaNode) {
	      this._bezierCurve(ctx, values, viaNode);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_getViaCoordinates",
	    value: function _getViaCoordinates() {
	      return this.via;
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return this.via;
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getPoint",
	    value: function getPoint(position) {
	      var viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.via;
	      if (this.from === this.to) {
	        var _this$_getCircleData = this._getCircleData(),
	          _this$_getCircleData2 = _slicedToArray(_this$_getCircleData, 3),
	          cx = _this$_getCircleData2[0],
	          cy = _this$_getCircleData2[1],
	          cr = _this$_getCircleData2[2];
	        var a = 2 * Math.PI * (1 - position);
	        return {
	          x: cx + cr * Math.sin(a),
	          y: cy + cr - cr * (1 - Math.cos(a))
	        };
	      } else {
	        return {
	          x: Math.pow(1 - position, 2) * this.fromPoint.x + 2 * position * (1 - position) * viaNode.x + Math.pow(position, 2) * this.toPoint.x,
	          y: Math.pow(1 - position, 2) * this.fromPoint.y + 2 * position * (1 - position) * viaNode.y + Math.pow(position, 2) * this.toPoint.y
	        };
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_findBorderPosition",
	    value: function _findBorderPosition(nearNode, ctx) {
	      return this._findBorderPositionBezier(nearNode, ctx, this.via);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_getDistanceToEdge",
	    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      // x3,y3 is the point
	      return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, this.via);
	    }
	  }]);
	  return BezierEdgeDynamic;
	}(BezierEdgeBase);

	function _createSuper$7(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$7(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$7() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Static Bezier Edge. Bezier curves are used to model smooth gradual curves in paths between nodes.
	 */
	var BezierEdgeStatic = /*#__PURE__*/function (_BezierEdgeBase) {
	  _inherits(BezierEdgeStatic, _BezierEdgeBase);
	  var _super = _createSuper$7(BezierEdgeStatic);
	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function BezierEdgeStatic(options, body, labelModule) {
	    _classCallCheck(this, BezierEdgeStatic);
	    return _super.call(this, options, body, labelModule);
	  }
	  /** @inheritDoc */
	  _createClass(BezierEdgeStatic, [{
	    key: "_line",
	    value: function _line(ctx, values, viaNode) {
	      this._bezierCurve(ctx, values, viaNode);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return this._getViaCoordinates();
	    }
	    /**
	     * Compute the coordinates of the via node.
	     *
	     * @remarks
	     * We do not use the to and fromPoints here to make the via nodes the same as edges without arrows.
	     * @returns Cartesian coordinates of the via node.
	     */
	  }, {
	    key: "_getViaCoordinates",
	    value: function _getViaCoordinates() {
	      // Assumption: x/y coordinates in from/to always defined
	      var factor = this.options.smooth.roundness;
	      var type = this.options.smooth.type;
	      var dx = Math.abs(this.from.x - this.to.x);
	      var dy = Math.abs(this.from.y - this.to.y);
	      if (type === "discrete" || type === "diagonalCross") {
	        var stepX;
	        var stepY;
	        if (dx <= dy) {
	          stepX = stepY = factor * dy;
	        } else {
	          stepX = stepY = factor * dx;
	        }
	        if (this.from.x > this.to.x) {
	          stepX = -stepX;
	        }
	        if (this.from.y >= this.to.y) {
	          stepY = -stepY;
	        }
	        var xVia = this.from.x + stepX;
	        var yVia = this.from.y + stepY;
	        if (type === "discrete") {
	          if (dx <= dy) {
	            xVia = dx < factor * dy ? this.from.x : xVia;
	          } else {
	            yVia = dy < factor * dx ? this.from.y : yVia;
	          }
	        }
	        return {
	          x: xVia,
	          y: yVia
	        };
	      } else if (type === "straightCross") {
	        var _stepX = (1 - factor) * dx;
	        var _stepY = (1 - factor) * dy;
	        if (dx <= dy) {
	          // up - down
	          _stepX = 0;
	          if (this.from.y < this.to.y) {
	            _stepY = -_stepY;
	          }
	        } else {
	          // left - right
	          if (this.from.x < this.to.x) {
	            _stepX = -_stepX;
	          }
	          _stepY = 0;
	        }
	        return {
	          x: this.to.x + _stepX,
	          y: this.to.y + _stepY
	        };
	      } else if (type === "horizontal") {
	        var _stepX2 = (1 - factor) * dx;
	        if (this.from.x < this.to.x) {
	          _stepX2 = -_stepX2;
	        }
	        return {
	          x: this.to.x + _stepX2,
	          y: this.from.y
	        };
	      } else if (type === "vertical") {
	        var _stepY2 = (1 - factor) * dy;
	        if (this.from.y < this.to.y) {
	          _stepY2 = -_stepY2;
	        }
	        return {
	          x: this.from.x,
	          y: this.to.y + _stepY2
	        };
	      } else if (type === "curvedCW") {
	        dx = this.to.x - this.from.x;
	        dy = this.from.y - this.to.y;
	        var radius = Math.sqrt(dx * dx + dy * dy);
	        var pi = Math.PI;
	        var originalAngle = Math.atan2(dy, dx);
	        var myAngle = (originalAngle + (factor * 0.5 + 0.5) * pi) % (2 * pi);
	        return {
	          x: this.from.x + (factor * 0.5 + 0.5) * radius * Math.sin(myAngle),
	          y: this.from.y + (factor * 0.5 + 0.5) * radius * Math.cos(myAngle)
	        };
	      } else if (type === "curvedCCW") {
	        dx = this.to.x - this.from.x;
	        dy = this.from.y - this.to.y;
	        var _radius = Math.sqrt(dx * dx + dy * dy);
	        var _pi = Math.PI;
	        var _originalAngle = Math.atan2(dy, dx);
	        var _myAngle = (_originalAngle + (-factor * 0.5 + 0.5) * _pi) % (2 * _pi);
	        return {
	          x: this.from.x + (factor * 0.5 + 0.5) * _radius * Math.sin(_myAngle),
	          y: this.from.y + (factor * 0.5 + 0.5) * _radius * Math.cos(_myAngle)
	        };
	      } else {
	        // continuous
	        var _stepX3;
	        var _stepY3;
	        if (dx <= dy) {
	          _stepX3 = _stepY3 = factor * dy;
	        } else {
	          _stepX3 = _stepY3 = factor * dx;
	        }
	        if (this.from.x > this.to.x) {
	          _stepX3 = -_stepX3;
	        }
	        if (this.from.y >= this.to.y) {
	          _stepY3 = -_stepY3;
	        }
	        var _xVia = this.from.x + _stepX3;
	        var _yVia = this.from.y + _stepY3;
	        if (dx <= dy) {
	          if (this.from.x <= this.to.x) {
	            _xVia = this.to.x < _xVia ? this.to.x : _xVia;
	          } else {
	            _xVia = this.to.x > _xVia ? this.to.x : _xVia;
	          }
	        } else {
	          if (this.from.y >= this.to.y) {
	            _yVia = this.to.y > _yVia ? this.to.y : _yVia;
	          } else {
	            _yVia = this.to.y < _yVia ? this.to.y : _yVia;
	          }
	        }
	        return {
	          x: _xVia,
	          y: _yVia
	        };
	      }
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_findBorderPosition",
	    value: function _findBorderPosition(nearNode, ctx) {
	      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	      return this._findBorderPositionBezier(nearNode, ctx, options.via);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_getDistanceToEdge",
	    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      var viaNode = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates();
	      // x3,y3 is the point
	      return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, viaNode);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getPoint",
	    value: function getPoint(position) {
	      var viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates();
	      var t = position;
	      var x = Math.pow(1 - t, 2) * this.fromPoint.x + 2 * t * (1 - t) * viaNode.x + Math.pow(t, 2) * this.toPoint.x;
	      var y = Math.pow(1 - t, 2) * this.fromPoint.y + 2 * t * (1 - t) * viaNode.y + Math.pow(t, 2) * this.toPoint.y;
	      return {
	        x: x,
	        y: y
	      };
	    }
	  }]);
	  return BezierEdgeStatic;
	}(BezierEdgeBase);

	function _createSuper$6(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$6(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$6() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Base Class for all Cubic Bezier Edges. Bezier curves are used to model
	 * smooth gradual curves in paths between nodes.
	 *
	 * @augments BezierEdgeBase
	 */
	var CubicBezierEdgeBase = /*#__PURE__*/function (_BezierEdgeBase) {
	  _inherits(CubicBezierEdgeBase, _BezierEdgeBase);
	  var _super = _createSuper$6(CubicBezierEdgeBase);
	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function CubicBezierEdgeBase(options, body, labelModule) {
	    _classCallCheck(this, CubicBezierEdgeBase);
	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   * Calculate the distance between a point (x3,y3) and a line segment from (x1,y1) to (x2,y2).
	   *
	   * @remarks
	   * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
	   * https://en.wikipedia.org/wiki/B%C3%A9zier_curve
	   * @param x1 - First end of the line segment on the x axis.
	   * @param y1 - First end of the line segment on the y axis.
	   * @param x2 - Second end of the line segment on the x axis.
	   * @param y2 - Second end of the line segment on the y axis.
	   * @param x3 - Position of the point on the x axis.
	   * @param y3 - Position of the point on the y axis.
	   * @param via1 - The first point this edge passes through.
	   * @param via2 - The second point this edge passes through.
	   * @returns The distance between the line segment and the point.
	   */
	  _createClass(CubicBezierEdgeBase, [{
	    key: "_getDistanceToBezierEdge2",
	    value: function _getDistanceToBezierEdge2(x1, y1, x2, y2, x3, y3, via1, via2) {
	      // x3,y3 is the point
	      var minDistance = 1e9;
	      var lastX = x1;
	      var lastY = y1;
	      var vec = [0, 0, 0, 0];
	      for (var i = 1; i < 10; i++) {
	        var t = 0.1 * i;
	        vec[0] = Math.pow(1 - t, 3);
	        vec[1] = 3 * t * Math.pow(1 - t, 2);
	        vec[2] = 3 * Math.pow(t, 2) * (1 - t);
	        vec[3] = Math.pow(t, 3);
	        var x = vec[0] * x1 + vec[1] * via1.x + vec[2] * via2.x + vec[3] * x2;
	        var y = vec[0] * y1 + vec[1] * via1.y + vec[2] * via2.y + vec[3] * y2;
	        if (i > 0) {
	          var distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);
	          minDistance = distance < minDistance ? distance : minDistance;
	        }
	        lastX = x;
	        lastY = y;
	      }
	      return minDistance;
	    }
	  }]);
	  return CubicBezierEdgeBase;
	}(BezierEdgeBase);

	function _createSuper$5(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$5(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$5() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Cubic Bezier Edge. Bezier curves are used to model smooth gradual curves in paths between nodes.
	 */
	var CubicBezierEdge = /*#__PURE__*/function (_CubicBezierEdgeBase) {
	  _inherits(CubicBezierEdge, _CubicBezierEdgeBase);
	  var _super = _createSuper$5(CubicBezierEdge);
	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function CubicBezierEdge(options, body, labelModule) {
	    _classCallCheck(this, CubicBezierEdge);
	    return _super.call(this, options, body, labelModule);
	  }
	  /** @inheritDoc */
	  _createClass(CubicBezierEdge, [{
	    key: "_line",
	    value: function _line(ctx, values, viaNodes) {
	      // get the coordinates of the support points.
	      var via1 = viaNodes[0];
	      var via2 = viaNodes[1];
	      this._bezierCurve(ctx, values, via1, via2);
	    }
	    /**
	     * Compute the additional points the edge passes through.
	     *
	     * @returns Cartesian coordinates of the points the edge passes through.
	     */
	  }, {
	    key: "_getViaCoordinates",
	    value: function _getViaCoordinates() {
	      var dx = this.from.x - this.to.x;
	      var dy = this.from.y - this.to.y;
	      var x1;
	      var y1;
	      var x2;
	      var y2;
	      var roundness = this.options.smooth.roundness;
	      // horizontal if x > y or if direction is forced or if direction is horizontal
	      if ((Math.abs(dx) > Math.abs(dy) || this.options.smooth.forceDirection === true || this.options.smooth.forceDirection === "horizontal") && this.options.smooth.forceDirection !== "vertical") {
	        y1 = this.from.y;
	        y2 = this.to.y;
	        x1 = this.from.x - roundness * dx;
	        x2 = this.to.x + roundness * dx;
	      } else {
	        y1 = this.from.y - roundness * dy;
	        y2 = this.to.y + roundness * dy;
	        x1 = this.from.x;
	        x2 = this.to.x;
	      }
	      return [{
	        x: x1,
	        y: y1
	      }, {
	        x: x2,
	        y: y2
	      }];
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return this._getViaCoordinates();
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_findBorderPosition",
	    value: function _findBorderPosition(nearNode, ctx) {
	      return this._findBorderPositionBezier(nearNode, ctx);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_getDistanceToEdge",
	    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      var _ref = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates(),
	        _ref2 = _slicedToArray(_ref, 2),
	        via1 = _ref2[0],
	        via2 = _ref2[1];
	      // x3,y3 is the point
	      return this._getDistanceToBezierEdge2(x1, y1, x2, y2, x3, y3, via1, via2);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getPoint",
	    value: function getPoint(position) {
	      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates(),
	        _ref4 = _slicedToArray(_ref3, 2),
	        via1 = _ref4[0],
	        via2 = _ref4[1];
	      var t = position;
	      var vec = [Math.pow(1 - t, 3), 3 * t * Math.pow(1 - t, 2), 3 * Math.pow(t, 2) * (1 - t), Math.pow(t, 3)];
	      var x = vec[0] * this.fromPoint.x + vec[1] * via1.x + vec[2] * via2.x + vec[3] * this.toPoint.x;
	      var y = vec[0] * this.fromPoint.y + vec[1] * via1.y + vec[2] * via2.y + vec[3] * this.toPoint.y;
	      return {
	        x: x,
	        y: y
	      };
	    }
	  }]);
	  return CubicBezierEdge;
	}(CubicBezierEdgeBase);

	function _createSuper$4(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$4(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$4() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Straight Edge.
	 */
	var StraightEdge = /*#__PURE__*/function (_EdgeBase) {
	  _inherits(StraightEdge, _EdgeBase);
	  var _super = _createSuper$4(StraightEdge);
	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function StraightEdge(options, body, labelModule) {
	    _classCallCheck(this, StraightEdge);
	    return _super.call(this, options, body, labelModule);
	  }
	  /** @inheritDoc */
	  _createClass(StraightEdge, [{
	    key: "_line",
	    value: function _line(ctx, values) {
	      // draw a straight line
	      ctx.beginPath();
	      ctx.moveTo(this.fromPoint.x, this.fromPoint.y);
	      ctx.lineTo(this.toPoint.x, this.toPoint.y);
	      // draw shadow if enabled
	      this.enableShadow(ctx, values);
	      ctx.stroke();
	      this.disableShadow(ctx, values);
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return undefined;
	    }
	    /** @inheritDoc */
	  }, {
	    key: "getPoint",
	    value: function getPoint(position) {
	      return {
	        x: (1 - position) * this.fromPoint.x + position * this.toPoint.x,
	        y: (1 - position) * this.fromPoint.y + position * this.toPoint.y
	      };
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_findBorderPosition",
	    value: function _findBorderPosition(nearNode, ctx) {
	      var node1 = this.to;
	      var node2 = this.from;
	      if (nearNode.id === this.from.id) {
	        node1 = this.from;
	        node2 = this.to;
	      }
	      var angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
	      var dx = node1.x - node2.x;
	      var dy = node1.y - node2.y;
	      var edgeSegmentLength = Math.sqrt(dx * dx + dy * dy);
	      var toBorderDist = nearNode.distanceToBorder(ctx, angle);
	      var toBorderPoint = (edgeSegmentLength - toBorderDist) / edgeSegmentLength;
	      return {
	        x: (1 - toBorderPoint) * node2.x + toBorderPoint * node1.x,
	        y: (1 - toBorderPoint) * node2.y + toBorderPoint * node1.y,
	        t: 0
	      };
	    }
	    /** @inheritDoc */
	  }, {
	    key: "_getDistanceToEdge",
	    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      // x3,y3 is the point
	      return this._getDistanceToLine(x1, y1, x2, y2, x3, y3);
	    }
	  }]);
	  return StraightEdge;
	}(EdgeBase);

	/**
	 * An edge connects two nodes and has a specific direction.
	 */
	var Edge = /*#__PURE__*/function () {
	  /**
	   * @param {object} options        values specific to this edge, must contain at least 'from' and 'to'
	   * @param {object} body           shared state from Network instance
	   * @param {Network.Images} imagelist  A list with images. Only needed when the edge has image arrows.
	   * @param {object} globalOptions  options from the EdgesHandler instance
	   * @param {object} defaultOptions default options from the EdgeHandler instance. Value and reference are constant
	   */
	  function Edge(options, body, imagelist, globalOptions, defaultOptions) {
	    _classCallCheck(this, Edge);
	    if (body === undefined) {
	      throw new Error("No body provided");
	    }

	    // Since globalOptions is constant in values as well as reference,
	    // Following needs to be done only once.

	    this.options = bridgeObject(globalOptions);
	    this.globalOptions = globalOptions;
	    this.defaultOptions = defaultOptions;
	    this.body = body;
	    this.imagelist = imagelist;

	    // initialize variables
	    this.id = undefined;
	    this.fromId = undefined;
	    this.toId = undefined;
	    this.selected = false;
	    this.hover = false;
	    this.labelDirty = true;
	    this.baseWidth = this.options.width;
	    this.baseFontSize = this.options.font.size;
	    this.from = undefined; // a node
	    this.to = undefined; // a node

	    this.edgeType = undefined;
	    this.connected = false;
	    this.labelModule = new Label(this.body, this.options, true /* It's an edge label */);

	    this.setOptions(options);
	  }

	  /**
	   * Set or overwrite options for the edge
	   *
	   * @param {object} options  an object with options
	   * @returns {undefined|boolean} undefined if no options, true if layout affecting data changed, false otherwise.
	   */
	  _createClass(Edge, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (!options) {
	        return;
	      }

	      // Following options if changed affect the layout.
	      var affectsLayout = typeof options.physics !== "undefined" && this.options.physics !== options.physics || typeof options.hidden !== "undefined" && (this.options.hidden || false) !== (options.hidden || false) || typeof options.from !== "undefined" && this.options.from !== options.from || typeof options.to !== "undefined" && this.options.to !== options.to;
	      Edge.parseOptions(this.options, options, true, this.globalOptions);
	      if (options.id !== undefined) {
	        this.id = options.id;
	      }
	      if (options.from !== undefined) {
	        this.fromId = options.from;
	      }
	      if (options.to !== undefined) {
	        this.toId = options.to;
	      }
	      if (options.title !== undefined) {
	        this.title = options.title;
	      }
	      if (options.value !== undefined) {
	        options.value = _parseFloat$1(options.value);
	      }
	      var pile = [options, this.options, this.defaultOptions];
	      this.chooser = choosify("edge", pile);

	      // update label Module
	      this.updateLabelModule(options);

	      // Update edge type, this if changed affects the layout.
	      affectsLayout = this.updateEdgeType() || affectsLayout;

	      // if anything has been updates, reset the selection width and the hover width
	      this._setInteractionWidths();

	      // A node is connected when it has a from and to node that both exist in the network.body.nodes.
	      this.connect();
	      return affectsLayout;
	    }

	    /**
	     *
	     * @param {object} parentOptions
	     * @param {object} newOptions
	     * @param {boolean} [allowDeletion=false]
	     * @param {object} [globalOptions={}]
	     * @param {boolean} [copyFromGlobals=false]
	     */
	  }, {
	    key: "getFormattingValues",
	    value:
	    /**
	     *
	     * @returns {ArrowOptions}
	     */
	    function getFormattingValues() {
	      var toArrow = this.options.arrows.to === true || this.options.arrows.to.enabled === true;
	      var fromArrow = this.options.arrows.from === true || this.options.arrows.from.enabled === true;
	      var middleArrow = this.options.arrows.middle === true || this.options.arrows.middle.enabled === true;
	      var inheritsColor = this.options.color.inherit;
	      var values = {
	        toArrow: toArrow,
	        toArrowScale: this.options.arrows.to.scaleFactor,
	        toArrowType: this.options.arrows.to.type,
	        toArrowSrc: this.options.arrows.to.src,
	        toArrowImageWidth: this.options.arrows.to.imageWidth,
	        toArrowImageHeight: this.options.arrows.to.imageHeight,
	        middleArrow: middleArrow,
	        middleArrowScale: this.options.arrows.middle.scaleFactor,
	        middleArrowType: this.options.arrows.middle.type,
	        middleArrowSrc: this.options.arrows.middle.src,
	        middleArrowImageWidth: this.options.arrows.middle.imageWidth,
	        middleArrowImageHeight: this.options.arrows.middle.imageHeight,
	        fromArrow: fromArrow,
	        fromArrowScale: this.options.arrows.from.scaleFactor,
	        fromArrowType: this.options.arrows.from.type,
	        fromArrowSrc: this.options.arrows.from.src,
	        fromArrowImageWidth: this.options.arrows.from.imageWidth,
	        fromArrowImageHeight: this.options.arrows.from.imageHeight,
	        arrowStrikethrough: this.options.arrowStrikethrough,
	        color: inheritsColor ? undefined : this.options.color.color,
	        inheritsColor: inheritsColor,
	        opacity: this.options.color.opacity,
	        hidden: this.options.hidden,
	        length: this.options.length,
	        shadow: this.options.shadow.enabled,
	        shadowColor: this.options.shadow.color,
	        shadowSize: this.options.shadow.size,
	        shadowX: this.options.shadow.x,
	        shadowY: this.options.shadow.y,
	        dashes: this.options.dashes,
	        width: this.options.width,
	        background: this.options.background.enabled,
	        backgroundColor: this.options.background.color,
	        backgroundSize: this.options.background.size,
	        backgroundDashes: this.options.background.dashes
	      };
	      if (this.selected || this.hover) {
	        if (this.chooser === true) {
	          if (this.selected) {
	            var selectedWidth = this.options.selectionWidth;
	            if (typeof selectedWidth === "function") {
	              values.width = selectedWidth(values.width);
	            } else if (typeof selectedWidth === "number") {
	              values.width += selectedWidth;
	            }
	            values.width = Math.max(values.width, 0.3 / this.body.view.scale);
	            values.color = this.options.color.highlight;
	            values.shadow = this.options.shadow.enabled;
	          } else if (this.hover) {
	            var hoverWidth = this.options.hoverWidth;
	            if (typeof hoverWidth === "function") {
	              values.width = hoverWidth(values.width);
	            } else if (typeof hoverWidth === "number") {
	              values.width += hoverWidth;
	            }
	            values.width = Math.max(values.width, 0.3 / this.body.view.scale);
	            values.color = this.options.color.hover;
	            values.shadow = this.options.shadow.enabled;
	          }
	        } else if (typeof this.chooser === "function") {
	          this.chooser(values, this.options.id, this.selected, this.hover);
	          if (values.color !== undefined) {
	            values.inheritsColor = false;
	          }
	          if (values.shadow === false) {
	            if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
	              values.shadow = true;
	            }
	          }
	        }
	      } else {
	        values.shadow = this.options.shadow.enabled;
	        values.width = Math.max(values.width, 0.3 / this.body.view.scale);
	      }
	      return values;
	    }

	    /**
	     * update the options in the label module
	     *
	     * @param {object} options
	     */
	  }, {
	    key: "updateLabelModule",
	    value: function updateLabelModule(options) {
	      var pile = [options, this.options, this.globalOptions,
	      // Currently set global edge options
	      this.defaultOptions];
	      this.labelModule.update(this.options, pile);
	      if (this.labelModule.baseSize !== undefined) {
	        this.baseFontSize = this.labelModule.baseSize;
	      }
	    }

	    /**
	     * update the edge type, set the options
	     *
	     * @returns {boolean}
	     */
	  }, {
	    key: "updateEdgeType",
	    value: function updateEdgeType() {
	      var smooth = this.options.smooth;
	      var dataChanged = false;
	      var changeInType = true;
	      if (this.edgeType !== undefined) {
	        if (this.edgeType instanceof BezierEdgeDynamic && smooth.enabled === true && smooth.type === "dynamic" || this.edgeType instanceof CubicBezierEdge && smooth.enabled === true && smooth.type === "cubicBezier" || this.edgeType instanceof BezierEdgeStatic && smooth.enabled === true && smooth.type !== "dynamic" && smooth.type !== "cubicBezier" || this.edgeType instanceof StraightEdge && smooth.type.enabled === false) {
	          changeInType = false;
	        }
	        if (changeInType === true) {
	          dataChanged = this.cleanup();
	        }
	      }
	      if (changeInType === true) {
	        if (smooth.enabled === true) {
	          if (smooth.type === "dynamic") {
	            dataChanged = true;
	            this.edgeType = new BezierEdgeDynamic(this.options, this.body, this.labelModule);
	          } else if (smooth.type === "cubicBezier") {
	            this.edgeType = new CubicBezierEdge(this.options, this.body, this.labelModule);
	          } else {
	            this.edgeType = new BezierEdgeStatic(this.options, this.body, this.labelModule);
	          }
	        } else {
	          this.edgeType = new StraightEdge(this.options, this.body, this.labelModule);
	        }
	      } else {
	        // if nothing changes, we just set the options.
	        this.edgeType.setOptions(this.options);
	      }
	      return dataChanged;
	    }

	    /**
	     * Connect an edge to its nodes
	     */
	  }, {
	    key: "connect",
	    value: function connect() {
	      this.disconnect();
	      this.from = this.body.nodes[this.fromId] || undefined;
	      this.to = this.body.nodes[this.toId] || undefined;
	      this.connected = this.from !== undefined && this.to !== undefined;
	      if (this.connected === true) {
	        this.from.attachEdge(this);
	        this.to.attachEdge(this);
	      } else {
	        if (this.from) {
	          this.from.detachEdge(this);
	        }
	        if (this.to) {
	          this.to.detachEdge(this);
	        }
	      }
	      this.edgeType.connect();
	    }

	    /**
	     * Disconnect an edge from its nodes
	     */
	  }, {
	    key: "disconnect",
	    value: function disconnect() {
	      if (this.from) {
	        this.from.detachEdge(this);
	        this.from = undefined;
	      }
	      if (this.to) {
	        this.to.detachEdge(this);
	        this.to = undefined;
	      }
	      this.connected = false;
	    }

	    /**
	     * get the title of this edge.
	     *
	     * @returns {string} title    The title of the edge, or undefined when no title
	     *                           has been set.
	     */
	  }, {
	    key: "getTitle",
	    value: function getTitle() {
	      return this.title;
	    }

	    /**
	     * check if this node is selecte
	     *
	     * @returns {boolean} selected   True if node is selected, else false
	     */
	  }, {
	    key: "isSelected",
	    value: function isSelected() {
	      return this.selected;
	    }

	    /**
	     * Retrieve the value of the edge. Can be undefined
	     *
	     * @returns {number} value
	     */
	  }, {
	    key: "getValue",
	    value: function getValue() {
	      return this.options.value;
	    }

	    /**
	     * Adjust the value range of the edge. The edge will adjust it's width
	     * based on its value.
	     *
	     * @param {number} min
	     * @param {number} max
	     * @param {number} total
	     */
	  }, {
	    key: "setValueRange",
	    value: function setValueRange(min, max, total) {
	      if (this.options.value !== undefined) {
	        var scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
	        var widthDiff = this.options.scaling.max - this.options.scaling.min;
	        if (this.options.scaling.label.enabled === true) {
	          var fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
	          this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
	        }
	        this.options.width = this.options.scaling.min + scale * widthDiff;
	      } else {
	        this.options.width = this.baseWidth;
	        this.options.font.size = this.baseFontSize;
	      }
	      this._setInteractionWidths();
	      this.updateLabelModule();
	    }

	    /**
	     *
	     * @private
	     */
	  }, {
	    key: "_setInteractionWidths",
	    value: function _setInteractionWidths() {
	      if (typeof this.options.hoverWidth === "function") {
	        this.edgeType.hoverWidth = this.options.hoverWidth(this.options.width);
	      } else {
	        this.edgeType.hoverWidth = this.options.hoverWidth + this.options.width;
	      }
	      if (typeof this.options.selectionWidth === "function") {
	        this.edgeType.selectionWidth = this.options.selectionWidth(this.options.width);
	      } else {
	        this.edgeType.selectionWidth = this.options.selectionWidth + this.options.width;
	      }
	    }

	    /**
	     * Redraw a edge
	     * Draw this edge in the given canvas
	     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
	     *
	     * @param {CanvasRenderingContext2D}   ctx
	     */
	  }, {
	    key: "draw",
	    value: function draw(ctx) {
	      var values = this.getFormattingValues();
	      if (values.hidden) {
	        return;
	      }

	      // get the via node from the edge type
	      var viaNode = this.edgeType.getViaNode();

	      // draw line and label
	      this.edgeType.drawLine(ctx, values, this.selected, this.hover, viaNode);
	      this.drawLabel(ctx, viaNode);
	    }

	    /**
	     * Redraw arrows
	     * Draw this arrows in the given canvas
	     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
	     *
	     * @param {CanvasRenderingContext2D}   ctx
	     */
	  }, {
	    key: "drawArrows",
	    value: function drawArrows(ctx) {
	      var values = this.getFormattingValues();
	      if (values.hidden) {
	        return;
	      }

	      // get the via node from the edge type
	      var viaNode = this.edgeType.getViaNode();
	      var arrowData = {};

	      // restore edge targets to defaults
	      this.edgeType.fromPoint = this.edgeType.from;
	      this.edgeType.toPoint = this.edgeType.to;

	      // from and to arrows give a different end point for edges. we set them here
	      if (values.fromArrow) {
	        arrowData.from = this.edgeType.getArrowData(ctx, "from", viaNode, this.selected, this.hover, values);
	        if (values.arrowStrikethrough === false) this.edgeType.fromPoint = arrowData.from.core;
	        if (values.fromArrowSrc) {
	          arrowData.from.image = this.imagelist.load(values.fromArrowSrc);
	        }
	        if (values.fromArrowImageWidth) {
	          arrowData.from.imageWidth = values.fromArrowImageWidth;
	        }
	        if (values.fromArrowImageHeight) {
	          arrowData.from.imageHeight = values.fromArrowImageHeight;
	        }
	      }
	      if (values.toArrow) {
	        arrowData.to = this.edgeType.getArrowData(ctx, "to", viaNode, this.selected, this.hover, values);
	        if (values.arrowStrikethrough === false) this.edgeType.toPoint = arrowData.to.core;
	        if (values.toArrowSrc) {
	          arrowData.to.image = this.imagelist.load(values.toArrowSrc);
	        }
	        if (values.toArrowImageWidth) {
	          arrowData.to.imageWidth = values.toArrowImageWidth;
	        }
	        if (values.toArrowImageHeight) {
	          arrowData.to.imageHeight = values.toArrowImageHeight;
	        }
	      }

	      // the middle arrow depends on the line, which can depend on the to and from arrows so we do this one lastly.
	      if (values.middleArrow) {
	        arrowData.middle = this.edgeType.getArrowData(ctx, "middle", viaNode, this.selected, this.hover, values);
	        if (values.middleArrowSrc) {
	          arrowData.middle.image = this.imagelist.load(values.middleArrowSrc);
	        }
	        if (values.middleArrowImageWidth) {
	          arrowData.middle.imageWidth = values.middleArrowImageWidth;
	        }
	        if (values.middleArrowImageHeight) {
	          arrowData.middle.imageHeight = values.middleArrowImageHeight;
	        }
	      }
	      if (values.fromArrow) {
	        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.from);
	      }
	      if (values.middleArrow) {
	        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.middle);
	      }
	      if (values.toArrow) {
	        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.to);
	      }
	    }

	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {Node} viaNode
	     */
	  }, {
	    key: "drawLabel",
	    value: function drawLabel(ctx, viaNode) {
	      if (this.options.label !== undefined) {
	        // set style
	        var node1 = this.from;
	        var node2 = this.to;
	        if (this.labelModule.differentState(this.selected, this.hover)) {
	          this.labelModule.getTextSize(ctx, this.selected, this.hover);
	        }
	        var point;
	        if (node1.id != node2.id) {
	          this.labelModule.pointToSelf = false;
	          point = this.edgeType.getPoint(0.5, viaNode);
	          ctx.save();
	          var rotationPoint = this._getRotation(ctx);
	          if (rotationPoint.angle != 0) {
	            ctx.translate(rotationPoint.x, rotationPoint.y);
	            ctx.rotate(rotationPoint.angle);
	          }

	          // draw the label
	          this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);

	          /*
	          // Useful debug code: draw a border around the label
	          // This should **not** be enabled in production!
	          var size = this.labelModule.getSize();; // ;; intentional so lint catches it
	          ctx.strokeStyle = "#ff0000";
	          ctx.strokeRect(size.left, size.top, size.width, size.height);
	          // End  debug code
	          */

	          ctx.restore();
	        } else {
	          // Ignore the orientations.
	          this.labelModule.pointToSelf = true;

	          // get circle coordinates
	          var coordinates = getSelfRefCoordinates(ctx, this.options.selfReference.angle, this.options.selfReference.size, node1);
	          point = this._pointOnCircle(coordinates.x, coordinates.y, this.options.selfReference.size, this.options.selfReference.angle);
	          this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);
	        }
	      }
	    }

	    /**
	     * Determine all visual elements of this edge instance, in which the given
	     * point falls within the bounding shape.
	     *
	     * @param {point} point
	     * @returns {Array.<edgeClickItem|edgeLabelClickItem>} list with the items which are on the point
	     */
	  }, {
	    key: "getItemsOnPoint",
	    value: function getItemsOnPoint(point) {
	      var ret = [];
	      if (this.labelModule.visible()) {
	        var rotationPoint = this._getRotation();
	        if (pointInRect(this.labelModule.getSize(), point, rotationPoint)) {
	          ret.push({
	            edgeId: this.id,
	            labelId: 0
	          });
	        }
	      }
	      var obj = {
	        left: point.x,
	        top: point.y
	      };
	      if (this.isOverlappingWith(obj)) {
	        ret.push({
	          edgeId: this.id
	        });
	      }
	      return ret;
	    }

	    /**
	     * Check if this object is overlapping with the provided object
	     *
	     * @param {object} obj   an object with parameters left, top
	     * @returns {boolean}     True if location is located on the edge
	     */
	  }, {
	    key: "isOverlappingWith",
	    value: function isOverlappingWith(obj) {
	      if (this.connected) {
	        var distMax = 10;
	        var xFrom = this.from.x;
	        var yFrom = this.from.y;
	        var xTo = this.to.x;
	        var yTo = this.to.y;
	        var xObj = obj.left;
	        var yObj = obj.top;
	        var dist = this.edgeType.getDistanceToEdge(xFrom, yFrom, xTo, yTo, xObj, yObj);
	        return dist < distMax;
	      } else {
	        return false;
	      }
	    }

	    /**
	     * Determine the rotation point, if any.
	     *
	     * @param {CanvasRenderingContext2D} [ctx] if passed, do a recalculation of the label size
	     * @returns {rotationPoint} the point to rotate around and the angle in radians to rotate
	     * @private
	     */
	  }, {
	    key: "_getRotation",
	    value: function _getRotation(ctx) {
	      var viaNode = this.edgeType.getViaNode();
	      var point = this.edgeType.getPoint(0.5, viaNode);
	      if (ctx !== undefined) {
	        this.labelModule.calculateLabelSize(ctx, this.selected, this.hover, point.x, point.y);
	      }
	      var ret = {
	        x: point.x,
	        y: this.labelModule.size.yLine,
	        angle: 0
	      };
	      if (!this.labelModule.visible()) {
	        return ret; // Don't even bother doing the atan2, there's nothing to draw
	      }

	      if (this.options.font.align === "horizontal") {
	        return ret; // No need to calculate angle
	      }

	      var dy = this.from.y - this.to.y;
	      var dx = this.from.x - this.to.x;
	      var angle = Math.atan2(dy, dx); // radians

	      // rotate so that label is readable
	      if (angle < -1 && dx < 0 || angle > 0 && dx < 0) {
	        angle += Math.PI;
	      }
	      ret.angle = angle;
	      return ret;
	    }

	    /**
	     * Get a point on a circle
	     *
	     * @param {number} x
	     * @param {number} y
	     * @param {number} radius
	     * @param {number} angle
	     * @returns {object} point
	     * @private
	     */
	  }, {
	    key: "_pointOnCircle",
	    value: function _pointOnCircle(x, y, radius, angle) {
	      return {
	        x: x + radius * Math.cos(angle),
	        y: y - radius * Math.sin(angle)
	      };
	    }

	    /**
	     * Sets selected state to true
	     */
	  }, {
	    key: "select",
	    value: function select() {
	      this.selected = true;
	    }

	    /**
	     * Sets selected state to false
	     */
	  }, {
	    key: "unselect",
	    value: function unselect() {
	      this.selected = false;
	    }

	    /**
	     * cleans all required things on delete
	     *
	     * @returns {*}
	     */
	  }, {
	    key: "cleanup",
	    value: function cleanup() {
	      return this.edgeType.cleanup();
	    }

	    /**
	     * Remove edge from the list and perform necessary cleanup.
	     */
	  }, {
	    key: "remove",
	    value: function remove() {
	      this.cleanup();
	      this.disconnect();
	      delete this.body.edges[this.id];
	    }

	    /**
	     * Check if both connecting nodes exist
	     *
	     * @returns {boolean}
	     */
	  }, {
	    key: "endPointsValid",
	    value: function endPointsValid() {
	      return this.body.nodes[this.fromId] !== undefined && this.body.nodes[this.toId] !== undefined;
	    }
	  }], [{
	    key: "parseOptions",
	    value: function parseOptions(parentOptions, newOptions) {
	      var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
	      var copyFromGlobals = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
	      var fields = ["endPointOffset", "arrowStrikethrough", "id", "from", "hidden", "hoverWidth", "labelHighlightBold", "length", "line", "opacity", "physics", "scaling", "selectionWidth", "selfReferenceSize", "selfReference", "to", "title", "value", "width", "font", "chosen", "widthConstraint"];

	      // only deep extend the items in the field array. These do not have shorthand.
	      selectiveDeepExtend(fields, parentOptions, newOptions, allowDeletion);

	      // Only use endPointOffset values (from and to) if it's valid values
	      if (newOptions.endPointOffset !== undefined && newOptions.endPointOffset.from !== undefined) {
	        if (_Number$isFinite(newOptions.endPointOffset.from)) {
	          parentOptions.endPointOffset.from = newOptions.endPointOffset.from;
	        } else {
	          parentOptions.endPointOffset.from = globalOptions.endPointOffset.from !== undefined ? globalOptions.endPointOffset.from : 0;
	          console.error("endPointOffset.from is not a valid number");
	        }
	      }
	      if (newOptions.endPointOffset !== undefined && newOptions.endPointOffset.to !== undefined) {
	        if (_Number$isFinite(newOptions.endPointOffset.to)) {
	          parentOptions.endPointOffset.to = newOptions.endPointOffset.to;
	        } else {
	          parentOptions.endPointOffset.to = globalOptions.endPointOffset.to !== undefined ? globalOptions.endPointOffset.to : 0;
	          console.error("endPointOffset.to is not a valid number");
	        }
	      }

	      // Only copy label if it's a legal value.
	      if (isValidLabel(newOptions.label)) {
	        parentOptions.label = newOptions.label;
	      } else if (!isValidLabel(parentOptions.label)) {
	        parentOptions.label = undefined;
	      }
	      mergeOptions(parentOptions, newOptions, "smooth", globalOptions);
	      mergeOptions(parentOptions, newOptions, "shadow", globalOptions);
	      mergeOptions(parentOptions, newOptions, "background", globalOptions);
	      if (newOptions.dashes !== undefined && newOptions.dashes !== null) {
	        parentOptions.dashes = newOptions.dashes;
	      } else if (allowDeletion === true && newOptions.dashes === null) {
	        parentOptions.dashes = _Object$create$1(globalOptions.dashes); // this sets the pointer of the option back to the global option.
	      }

	      // set the scaling newOptions
	      if (newOptions.scaling !== undefined && newOptions.scaling !== null) {
	        if (newOptions.scaling.min !== undefined) {
	          parentOptions.scaling.min = newOptions.scaling.min;
	        }
	        if (newOptions.scaling.max !== undefined) {
	          parentOptions.scaling.max = newOptions.scaling.max;
	        }
	        mergeOptions(parentOptions.scaling, newOptions.scaling, "label", globalOptions.scaling);
	      } else if (allowDeletion === true && newOptions.scaling === null) {
	        parentOptions.scaling = _Object$create$1(globalOptions.scaling); // this sets the pointer of the option back to the global option.
	      }

	      // handle multiple input cases for arrows
	      if (newOptions.arrows !== undefined && newOptions.arrows !== null) {
	        if (typeof newOptions.arrows === "string") {
	          var arrows = newOptions.arrows.toLowerCase();
	          parentOptions.arrows.to.enabled = _indexOfInstanceProperty(arrows).call(arrows, "to") != -1;
	          parentOptions.arrows.middle.enabled = _indexOfInstanceProperty(arrows).call(arrows, "middle") != -1;
	          parentOptions.arrows.from.enabled = _indexOfInstanceProperty(arrows).call(arrows, "from") != -1;
	        } else if (_typeof$1(newOptions.arrows) === "object") {
	          mergeOptions(parentOptions.arrows, newOptions.arrows, "to", globalOptions.arrows);
	          mergeOptions(parentOptions.arrows, newOptions.arrows, "middle", globalOptions.arrows);
	          mergeOptions(parentOptions.arrows, newOptions.arrows, "from", globalOptions.arrows);
	        } else {
	          throw new Error("The arrow newOptions can only be an object or a string. Refer to the documentation. You used:" + _JSON$stringify(newOptions.arrows));
	        }
	      } else if (allowDeletion === true && newOptions.arrows === null) {
	        parentOptions.arrows = _Object$create$1(globalOptions.arrows); // this sets the pointer of the option back to the global option.
	      }

	      // handle multiple input cases for color
	      if (newOptions.color !== undefined && newOptions.color !== null) {
	        var fromColor = isString(newOptions.color) ? {
	          color: newOptions.color,
	          highlight: newOptions.color,
	          hover: newOptions.color,
	          inherit: false,
	          opacity: 1
	        } : newOptions.color;
	        var toColor = parentOptions.color;

	        // If passed, fill in values from default options - required in the case of no prototype bridging
	        if (copyFromGlobals) {
	          deepExtend(toColor, globalOptions.color, false, allowDeletion);
	        } else {
	          // Clear local properties - need to do it like this in order to retain prototype bridges
	          for (var i in toColor) {
	            if (Object.prototype.hasOwnProperty.call(toColor, i)) {
	              delete toColor[i];
	            }
	          }
	        }
	        if (isString(toColor)) {
	          toColor.color = toColor;
	          toColor.highlight = toColor;
	          toColor.hover = toColor;
	          toColor.inherit = false;
	          if (fromColor.opacity === undefined) {
	            toColor.opacity = 1.0; // set default
	          }
	        } else {
	          var colorsDefined = false;
	          if (fromColor.color !== undefined) {
	            toColor.color = fromColor.color;
	            colorsDefined = true;
	          }
	          if (fromColor.highlight !== undefined) {
	            toColor.highlight = fromColor.highlight;
	            colorsDefined = true;
	          }
	          if (fromColor.hover !== undefined) {
	            toColor.hover = fromColor.hover;
	            colorsDefined = true;
	          }
	          if (fromColor.inherit !== undefined) {
	            toColor.inherit = fromColor.inherit;
	          }
	          if (fromColor.opacity !== undefined) {
	            toColor.opacity = Math.min(1, Math.max(0, fromColor.opacity));
	          }
	          if (colorsDefined === true) {
	            toColor.inherit = false;
	          } else {
	            if (toColor.inherit === undefined) {
	              toColor.inherit = "from"; // Set default
	            }
	          }
	        }
	      } else if (allowDeletion === true && newOptions.color === null) {
	        parentOptions.color = bridgeObject(globalOptions.color); // set the object back to the global options
	      }

	      if (allowDeletion === true && newOptions.font === null) {
	        parentOptions.font = bridgeObject(globalOptions.font); // set the object back to the global options
	      }

	      if (Object.prototype.hasOwnProperty.call(newOptions, "selfReferenceSize")) {
	        console.warn("The selfReferenceSize property has been deprecated. Please use selfReference property instead. The selfReference can be set like thise selfReference:{size:30, angle:Math.PI / 4}");
	        parentOptions.selfReference.size = newOptions.selfReferenceSize;
	      }
	    }
	  }]);
	  return Edge;
	}();

	/**
	 * Handler for Edges
	 */
	var EdgesHandler = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   * @param {Array.<Image>} images
	   * @param {Array.<Group>} groups
	   */
	  function EdgesHandler(body, images, groups) {
	    var _context,
	      _this = this;
	    _classCallCheck(this, EdgesHandler);
	    this.body = body;
	    this.images = images;
	    this.groups = groups;

	    // create the edge API in the body container
	    this.body.functions.createEdge = _bindInstanceProperty$1(_context = this.create).call(_context, this);
	    this.edgesListeners = {
	      add: function add(event, params) {
	        _this.add(params.items);
	      },
	      update: function update(event, params) {
	        _this.update(params.items);
	      },
	      remove: function remove(event, params) {
	        _this.remove(params.items);
	      }
	    };
	    this.options = {};
	    this.defaultOptions = {
	      arrows: {
	        to: {
	          enabled: false,
	          scaleFactor: 1,
	          type: "arrow"
	        },
	        // boolean / {arrowScaleFactor:1} / {enabled: false, arrowScaleFactor:1}
	        middle: {
	          enabled: false,
	          scaleFactor: 1,
	          type: "arrow"
	        },
	        from: {
	          enabled: false,
	          scaleFactor: 1,
	          type: "arrow"
	        }
	      },
	      endPointOffset: {
	        from: 0,
	        to: 0
	      },
	      arrowStrikethrough: true,
	      color: {
	        color: "#848484",
	        highlight: "#848484",
	        hover: "#848484",
	        inherit: "from",
	        opacity: 1.0
	      },
	      dashes: false,
	      font: {
	        color: "#343434",
	        size: 14,
	        // px
	        face: "arial",
	        background: "none",
	        strokeWidth: 2,
	        // px
	        strokeColor: "#ffffff",
	        align: "horizontal",
	        multi: false,
	        vadjust: 0,
	        bold: {
	          mod: "bold"
	        },
	        boldital: {
	          mod: "bold italic"
	        },
	        ital: {
	          mod: "italic"
	        },
	        mono: {
	          mod: "",
	          size: 15,
	          // px
	          face: "courier new",
	          vadjust: 2
	        }
	      },
	      hidden: false,
	      hoverWidth: 1.5,
	      label: undefined,
	      labelHighlightBold: true,
	      length: undefined,
	      physics: true,
	      scaling: {
	        min: 1,
	        max: 15,
	        label: {
	          enabled: true,
	          min: 14,
	          max: 30,
	          maxVisible: 30,
	          drawThreshold: 5
	        },
	        customScalingFunction: function customScalingFunction(min, max, total, value) {
	          if (max === min) {
	            return 0.5;
	          } else {
	            var scale = 1 / (max - min);
	            return Math.max(0, (value - min) * scale);
	          }
	        }
	      },
	      selectionWidth: 1.5,
	      selfReference: {
	        size: 20,
	        angle: Math.PI / 4,
	        renderBehindTheNode: true
	      },
	      shadow: {
	        enabled: false,
	        color: "rgba(0,0,0,0.5)",
	        size: 10,
	        x: 5,
	        y: 5
	      },
	      background: {
	        enabled: false,
	        color: "rgba(111,111,111,1)",
	        size: 10,
	        dashes: false
	      },
	      smooth: {
	        enabled: true,
	        type: "dynamic",
	        forceDirection: "none",
	        roundness: 0.5
	      },
	      title: undefined,
	      width: 1,
	      value: undefined
	    };
	    deepExtend(this.options, this.defaultOptions);
	    this.bindEventListeners();
	  }

	  /**
	   * Binds event listeners
	   */
	  _createClass(EdgesHandler, [{
	    key: "bindEventListeners",
	    value: function bindEventListeners() {
	      var _this2 = this,
	        _context2,
	        _context3;
	      // this allows external modules to force all dynamic curves to turn static.
	      this.body.emitter.on("_forceDisableDynamicCurves", function (type) {
	        var emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	        if (type === "dynamic") {
	          type = "continuous";
	        }
	        var dataChanged = false;
	        for (var edgeId in _this2.body.edges) {
	          if (Object.prototype.hasOwnProperty.call(_this2.body.edges, edgeId)) {
	            var edge = _this2.body.edges[edgeId];
	            var edgeData = _this2.body.data.edges.get(edgeId);

	            // only forcibly remove the smooth curve if the data has been set of the edge has the smooth curves defined.
	            // this is because a change in the global would not affect these curves.
	            if (edgeData != null) {
	              var smoothOptions = edgeData.smooth;
	              if (smoothOptions !== undefined) {
	                if (smoothOptions.enabled === true && smoothOptions.type === "dynamic") {
	                  if (type === undefined) {
	                    edge.setOptions({
	                      smooth: false
	                    });
	                  } else {
	                    edge.setOptions({
	                      smooth: {
	                        type: type
	                      }
	                    });
	                  }
	                  dataChanged = true;
	                }
	              }
	            }
	          }
	        }
	        if (emit === true && dataChanged === true) {
	          _this2.body.emitter.emit("_dataChanged");
	        }
	      });

	      // this is called when options of EXISTING nodes or edges have changed.
	      //
	      // NOTE: Not true, called when options have NOT changed, for both existing as well as new nodes.
	      //       See update() for logic.
	      // TODO: Verify and examine the consequences of this. It might still trigger when
	      //       non-option fields have changed, but then reconnecting edges is still useless.
	      //       Alternatively, it might also be called when edges are removed.
	      //
	      this.body.emitter.on("_dataUpdated", function () {
	        _this2.reconnectEdges();
	      });

	      // refresh the edges. Used when reverting from hierarchical layout
	      this.body.emitter.on("refreshEdges", _bindInstanceProperty$1(_context2 = this.refresh).call(_context2, this));
	      this.body.emitter.on("refresh", _bindInstanceProperty$1(_context3 = this.refresh).call(_context3, this));
	      this.body.emitter.on("destroy", function () {
	        forEach$4(_this2.edgesListeners, function (callback, event) {
	          if (_this2.body.data.edges) _this2.body.data.edges.off(event, callback);
	        });
	        delete _this2.body.functions.createEdge;
	        delete _this2.edgesListeners.add;
	        delete _this2.edgesListeners.update;
	        delete _this2.edgesListeners.remove;
	        delete _this2.edgesListeners;
	      });
	    }

	    /**
	     *
	     * @param {object} options
	     */
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options !== undefined) {
	        // use the parser from the Edge class to fill in all shorthand notations
	        Edge.parseOptions(this.options, options, true, this.defaultOptions, true);

	        // update smooth settings in all edges
	        var dataChanged = false;
	        if (options.smooth !== undefined) {
	          for (var edgeId in this.body.edges) {
	            if (Object.prototype.hasOwnProperty.call(this.body.edges, edgeId)) {
	              dataChanged = this.body.edges[edgeId].updateEdgeType() || dataChanged;
	            }
	          }
	        }

	        // update fonts in all edges
	        if (options.font !== undefined) {
	          for (var _edgeId in this.body.edges) {
	            if (Object.prototype.hasOwnProperty.call(this.body.edges, _edgeId)) {
	              this.body.edges[_edgeId].updateLabelModule();
	            }
	          }
	        }

	        // update the state of the variables if needed
	        if (options.hidden !== undefined || options.physics !== undefined || dataChanged === true) {
	          this.body.emitter.emit("_dataChanged");
	        }
	      }
	    }

	    /**
	     * Load edges by reading the data table
	     *
	     * @param {Array | DataSet | DataView} edges    The data containing the edges.
	     * @param {boolean} [doNotEmit=false] - Suppress data changed event.
	     * @private
	     */
	  }, {
	    key: "setData",
	    value: function setData(edges) {
	      var _this3 = this;
	      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var oldEdgesData = this.body.data.edges;
	      if (isDataViewLike("id", edges)) {
	        this.body.data.edges = edges;
	      } else if (_Array$isArray(edges)) {
	        this.body.data.edges = new DataSet();
	        this.body.data.edges.add(edges);
	      } else if (!edges) {
	        this.body.data.edges = new DataSet();
	      } else {
	        throw new TypeError("Array or DataSet expected");
	      }

	      // TODO: is this null or undefined or false?
	      if (oldEdgesData) {
	        // unsubscribe from old dataset
	        forEach$4(this.edgesListeners, function (callback, event) {
	          oldEdgesData.off(event, callback);
	        });
	      }

	      // remove drawn edges
	      this.body.edges = {};

	      // TODO: is this null or undefined or false?
	      if (this.body.data.edges) {
	        // subscribe to new dataset
	        forEach$4(this.edgesListeners, function (callback, event) {
	          _this3.body.data.edges.on(event, callback);
	        });

	        // draw all new nodes
	        var ids = this.body.data.edges.getIds();
	        this.add(ids, true);
	      }
	      this.body.emitter.emit("_adjustEdgesForHierarchicalLayout");
	      if (doNotEmit === false) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }

	    /**
	     * Add edges
	     *
	     * @param {number[] | string[]} ids
	     * @param {boolean} [doNotEmit=false]
	     * @private
	     */
	  }, {
	    key: "add",
	    value: function add(ids) {
	      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var edges = this.body.edges;
	      var edgesData = this.body.data.edges;
	      for (var i = 0; i < ids.length; i++) {
	        var id = ids[i];
	        var oldEdge = edges[id];
	        if (oldEdge) {
	          oldEdge.disconnect();
	        }
	        var data = edgesData.get(id, {
	          showInternalIds: true
	        });
	        edges[id] = this.create(data);
	      }
	      this.body.emitter.emit("_adjustEdgesForHierarchicalLayout");
	      if (doNotEmit === false) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }

	    /**
	     * Update existing edges, or create them when not yet existing
	     *
	     * @param {number[] | string[]} ids
	     * @private
	     */
	  }, {
	    key: "update",
	    value: function update(ids) {
	      var edges = this.body.edges;
	      var edgesData = this.body.data.edges;
	      var dataChanged = false;
	      for (var i = 0; i < ids.length; i++) {
	        var id = ids[i];
	        var data = edgesData.get(id);
	        var edge = edges[id];
	        if (edge !== undefined) {
	          // update edge
	          edge.disconnect();
	          dataChanged = edge.setOptions(data) || dataChanged; // if a support node is added, data can be changed.
	          edge.connect();
	        } else {
	          // create edge
	          this.body.edges[id] = this.create(data);
	          dataChanged = true;
	        }
	      }
	      if (dataChanged === true) {
	        this.body.emitter.emit("_adjustEdgesForHierarchicalLayout");
	        this.body.emitter.emit("_dataChanged");
	      } else {
	        this.body.emitter.emit("_dataUpdated");
	      }
	    }

	    /**
	     * Remove existing edges. Non existing ids will be ignored
	     *
	     * @param {number[] | string[]} ids
	     * @param {boolean} [emit=true]
	     * @private
	     */
	  }, {
	    key: "remove",
	    value: function remove(ids) {
	      var emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      if (ids.length === 0) return; // early out

	      var edges = this.body.edges;
	      forEach$4(ids, function (id) {
	        var edge = edges[id];
	        if (edge !== undefined) {
	          edge.remove();
	        }
	      });
	      if (emit) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }

	    /**
	     * Refreshes Edge Handler
	     */
	  }, {
	    key: "refresh",
	    value: function refresh() {
	      var _this4 = this;
	      forEach$4(this.body.edges, function (edge, edgeId) {
	        var data = _this4.body.data.edges.get(edgeId);
	        if (data !== undefined) {
	          edge.setOptions(data);
	        }
	      });
	    }

	    /**
	     *
	     * @param {object} properties
	     * @returns {Edge}
	     */
	  }, {
	    key: "create",
	    value: function create(properties) {
	      return new Edge(properties, this.body, this.images, this.options, this.defaultOptions);
	    }

	    /**
	     * Reconnect all edges
	     *
	     * @private
	     */
	  }, {
	    key: "reconnectEdges",
	    value: function reconnectEdges() {
	      var id;
	      var nodes = this.body.nodes;
	      var edges = this.body.edges;
	      for (id in nodes) {
	        if (Object.prototype.hasOwnProperty.call(nodes, id)) {
	          nodes[id].edges = [];
	        }
	      }
	      for (id in edges) {
	        if (Object.prototype.hasOwnProperty.call(edges, id)) {
	          var edge = edges[id];
	          edge.from = null;
	          edge.to = null;
	          edge.connect();
	        }
	      }
	    }

	    /**
	     *
	     * @param {Edge.id} edgeId
	     * @returns {Array}
	     */
	  }, {
	    key: "getConnectedNodes",
	    value: function getConnectedNodes(edgeId) {
	      var nodeList = [];
	      if (this.body.edges[edgeId] !== undefined) {
	        var edge = this.body.edges[edgeId];
	        if (edge.fromId !== undefined) {
	          nodeList.push(edge.fromId);
	        }
	        if (edge.toId !== undefined) {
	          nodeList.push(edge.toId);
	        }
	      }
	      return nodeList;
	    }

	    /**
	     * There is no direct relation between the nodes and the edges DataSet,
	     * so the right place to do call this is in the handler for event `_dataUpdated`.
	     */
	  }, {
	    key: "_updateState",
	    value: function _updateState() {
	      this._addMissingEdges();
	      this._removeInvalidEdges();
	    }

	    /**
	     * Scan for missing nodes and remove corresponding edges, if any.
	     *
	     * @private
	     */
	  }, {
	    key: "_removeInvalidEdges",
	    value: function _removeInvalidEdges() {
	      var _this5 = this;
	      var edgesToDelete = [];
	      forEach$4(this.body.edges, function (edge, id) {
	        var toNode = _this5.body.nodes[edge.toId];
	        var fromNode = _this5.body.nodes[edge.fromId];

	        // Skip clustering edges here, let the Clustering module handle those
	        if (toNode !== undefined && toNode.isCluster === true || fromNode !== undefined && fromNode.isCluster === true) {
	          return;
	        }
	        if (toNode === undefined || fromNode === undefined) {
	          edgesToDelete.push(id);
	        }
	      });
	      this.remove(edgesToDelete, false);
	    }

	    /**
	     * add all edges from dataset that are not in the cached state
	     *
	     * @private
	     */
	  }, {
	    key: "_addMissingEdges",
	    value: function _addMissingEdges() {
	      var edgesData = this.body.data.edges;
	      if (edgesData === undefined || edgesData === null) {
	        return; // No edges DataSet yet; can happen on startup
	      }

	      var edges = this.body.edges;
	      var addIds = [];
	      _forEachInstanceProperty(edgesData).call(edgesData, function (edgeData, edgeId) {
	        var edge = edges[edgeId];
	        if (edge === undefined) {
	          addIds.push(edgeId);
	        }
	      });
	      this.add(addIds, true);
	    }
	  }]);
	  return EdgesHandler;
	}();

	/**
	 * Barnes Hut Solver
	 */
	var BarnesHutSolver = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
	   * @param {object} options
	   */
	  function BarnesHutSolver(body, physicsBody, options) {
	    _classCallCheck(this, BarnesHutSolver);
	    this.body = body;
	    this.physicsBody = physicsBody;
	    this.barnesHutTree;
	    this.setOptions(options);
	    this._rng = Alea("BARNES HUT SOLVER");

	    // debug: show grid
	    // this.body.emitter.on("afterDrawing", (ctx) => {this._debug(ctx,'#ff0000')})
	  }

	  /**
	   *
	   * @param {object} options
	   */
	  _createClass(BarnesHutSolver, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	      this.thetaInversed = 1 / this.options.theta;

	      // if 1 then min distance = 0.5, if 0.5 then min distance = 0.5 + 0.5*node.shape.radius
	      this.overlapAvoidanceFactor = 1 - Math.max(0, Math.min(1, this.options.avoidOverlap));
	    }

	    /**
	     * This function calculates the forces the nodes apply on each other based on a gravitational model.
	     * The Barnes Hut method is used to speed up this N-body simulation.
	     *
	     * @private
	     */
	  }, {
	    key: "solve",
	    value: function solve() {
	      if (this.options.gravitationalConstant !== 0 && this.physicsBody.physicsNodeIndices.length > 0) {
	        var node;
	        var nodes = this.body.nodes;
	        var nodeIndices = this.physicsBody.physicsNodeIndices;
	        var nodeCount = nodeIndices.length;

	        // create the tree
	        var barnesHutTree = this._formBarnesHutTree(nodes, nodeIndices);

	        // for debugging
	        this.barnesHutTree = barnesHutTree;

	        // place the nodes one by one recursively
	        for (var i = 0; i < nodeCount; i++) {
	          node = nodes[nodeIndices[i]];
	          if (node.options.mass > 0) {
	            // starting with root is irrelevant, it never passes the BarnesHutSolver condition
	            this._getForceContributions(barnesHutTree.root, node);
	          }
	        }
	      }
	    }

	    /**
	     * @param {object} parentBranch
	     * @param {Node} node
	     * @private
	     */
	  }, {
	    key: "_getForceContributions",
	    value: function _getForceContributions(parentBranch, node) {
	      this._getForceContribution(parentBranch.children.NW, node);
	      this._getForceContribution(parentBranch.children.NE, node);
	      this._getForceContribution(parentBranch.children.SW, node);
	      this._getForceContribution(parentBranch.children.SE, node);
	    }

	    /**
	     * This function traverses the barnesHutTree. It checks when it can approximate distant nodes with their center of mass.
	     * If a region contains a single node, we check if it is not itself, then we apply the force.
	     *
	     * @param {object} parentBranch
	     * @param {Node} node
	     * @private
	     */
	  }, {
	    key: "_getForceContribution",
	    value: function _getForceContribution(parentBranch, node) {
	      // we get no force contribution from an empty region
	      if (parentBranch.childrenCount > 0) {
	        // get the distance from the center of mass to the node.
	        var dx = parentBranch.centerOfMass.x - node.x;
	        var dy = parentBranch.centerOfMass.y - node.y;
	        var distance = Math.sqrt(dx * dx + dy * dy);

	        // BarnesHutSolver condition
	        // original condition : s/d < theta = passed  ===  d/s > 1/theta = passed
	        // calcSize = 1/s --> d * 1/s > 1/theta = passed
	        if (distance * parentBranch.calcSize > this.thetaInversed) {
	          this._calculateForces(distance, dx, dy, node, parentBranch);
	        } else {
	          // Did not pass the condition, go into children if available
	          if (parentBranch.childrenCount === 4) {
	            this._getForceContributions(parentBranch, node);
	          } else {
	            // parentBranch must have only one node, if it was empty we wouldnt be here
	            if (parentBranch.children.data.id != node.id) {
	              // if it is not self
	              this._calculateForces(distance, dx, dy, node, parentBranch);
	            }
	          }
	        }
	      }
	    }

	    /**
	     * Calculate the forces based on the distance.
	     *
	     * @param {number} distance
	     * @param {number} dx
	     * @param {number} dy
	     * @param {Node} node
	     * @param {object} parentBranch
	     * @private
	     */
	  }, {
	    key: "_calculateForces",
	    value: function _calculateForces(distance, dx, dy, node, parentBranch) {
	      if (distance === 0) {
	        distance = 0.1;
	        dx = distance;
	      }
	      if (this.overlapAvoidanceFactor < 1 && node.shape.radius) {
	        distance = Math.max(0.1 + this.overlapAvoidanceFactor * node.shape.radius, distance - node.shape.radius);
	      }

	      // the dividing by the distance cubed instead of squared allows us to get the fx and fy components without sines and cosines
	      // it is shorthand for gravityforce with distance squared and fx = dx/distance * gravityForce
	      var gravityForce = this.options.gravitationalConstant * parentBranch.mass * node.options.mass / Math.pow(distance, 3);
	      var fx = dx * gravityForce;
	      var fy = dy * gravityForce;
	      this.physicsBody.forces[node.id].x += fx;
	      this.physicsBody.forces[node.id].y += fy;
	    }

	    /**
	     * This function constructs the barnesHut tree recursively. It creates the root, splits it and starts placing the nodes.
	     *
	     * @param {Array.<Node>} nodes
	     * @param {Array.<number>} nodeIndices
	     * @returns {{root: {centerOfMass: {x: number, y: number}, mass: number, range: {minX: number, maxX: number, minY: number, maxY: number}, size: number, calcSize: number, children: {data: null}, maxWidth: number, level: number, childrenCount: number}}} BarnesHutTree
	     * @private
	     */
	  }, {
	    key: "_formBarnesHutTree",
	    value: function _formBarnesHutTree(nodes, nodeIndices) {
	      var node;
	      var nodeCount = nodeIndices.length;
	      var minX = nodes[nodeIndices[0]].x;
	      var minY = nodes[nodeIndices[0]].y;
	      var maxX = nodes[nodeIndices[0]].x;
	      var maxY = nodes[nodeIndices[0]].y;

	      // get the range of the nodes
	      for (var i = 1; i < nodeCount; i++) {
	        var _node = nodes[nodeIndices[i]];
	        var x = _node.x;
	        var y = _node.y;
	        if (_node.options.mass > 0) {
	          if (x < minX) {
	            minX = x;
	          }
	          if (x > maxX) {
	            maxX = x;
	          }
	          if (y < minY) {
	            minY = y;
	          }
	          if (y > maxY) {
	            maxY = y;
	          }
	        }
	      }
	      // make the range a square
	      var sizeDiff = Math.abs(maxX - minX) - Math.abs(maxY - minY); // difference between X and Y
	      if (sizeDiff > 0) {
	        minY -= 0.5 * sizeDiff;
	        maxY += 0.5 * sizeDiff;
	      } // xSize > ySize
	      else {
	        minX += 0.5 * sizeDiff;
	        maxX -= 0.5 * sizeDiff;
	      } // xSize < ySize

	      var minimumTreeSize = 1e-5;
	      var rootSize = Math.max(minimumTreeSize, Math.abs(maxX - minX));
	      var halfRootSize = 0.5 * rootSize;
	      var centerX = 0.5 * (minX + maxX),
	        centerY = 0.5 * (minY + maxY);

	      // construct the barnesHutTree
	      var barnesHutTree = {
	        root: {
	          centerOfMass: {
	            x: 0,
	            y: 0
	          },
	          mass: 0,
	          range: {
	            minX: centerX - halfRootSize,
	            maxX: centerX + halfRootSize,
	            minY: centerY - halfRootSize,
	            maxY: centerY + halfRootSize
	          },
	          size: rootSize,
	          calcSize: 1 / rootSize,
	          children: {
	            data: null
	          },
	          maxWidth: 0,
	          level: 0,
	          childrenCount: 4
	        }
	      };
	      this._splitBranch(barnesHutTree.root);

	      // place the nodes one by one recursively
	      for (var _i = 0; _i < nodeCount; _i++) {
	        node = nodes[nodeIndices[_i]];
	        if (node.options.mass > 0) {
	          this._placeInTree(barnesHutTree.root, node);
	        }
	      }

	      // make global
	      return barnesHutTree;
	    }

	    /**
	     * this updates the mass of a branch. this is increased by adding a node.
	     *
	     * @param {object} parentBranch
	     * @param {Node} node
	     * @private
	     */
	  }, {
	    key: "_updateBranchMass",
	    value: function _updateBranchMass(parentBranch, node) {
	      var centerOfMass = parentBranch.centerOfMass;
	      var totalMass = parentBranch.mass + node.options.mass;
	      var totalMassInv = 1 / totalMass;
	      centerOfMass.x = centerOfMass.x * parentBranch.mass + node.x * node.options.mass;
	      centerOfMass.x *= totalMassInv;
	      centerOfMass.y = centerOfMass.y * parentBranch.mass + node.y * node.options.mass;
	      centerOfMass.y *= totalMassInv;
	      parentBranch.mass = totalMass;
	      var biggestSize = Math.max(Math.max(node.height, node.radius), node.width);
	      parentBranch.maxWidth = parentBranch.maxWidth < biggestSize ? biggestSize : parentBranch.maxWidth;
	    }

	    /**
	     * determine in which branch the node will be placed.
	     *
	     * @param {object} parentBranch
	     * @param {Node} node
	     * @param {boolean} skipMassUpdate
	     * @private
	     */
	  }, {
	    key: "_placeInTree",
	    value: function _placeInTree(parentBranch, node, skipMassUpdate) {
	      if (skipMassUpdate != true || skipMassUpdate === undefined) {
	        // update the mass of the branch.
	        this._updateBranchMass(parentBranch, node);
	      }
	      var range = parentBranch.children.NW.range;
	      var region;
	      if (range.maxX > node.x) {
	        // in NW or SW
	        if (range.maxY > node.y) {
	          region = "NW";
	        } else {
	          region = "SW";
	        }
	      } else {
	        // in NE or SE
	        if (range.maxY > node.y) {
	          region = "NE";
	        } else {
	          region = "SE";
	        }
	      }
	      this._placeInRegion(parentBranch, node, region);
	    }

	    /**
	     * actually place the node in a region (or branch)
	     *
	     * @param {object} parentBranch
	     * @param {Node} node
	     * @param {'NW'| 'NE' | 'SW' | 'SE'} region
	     * @private
	     */
	  }, {
	    key: "_placeInRegion",
	    value: function _placeInRegion(parentBranch, node, region) {
	      var children = parentBranch.children[region];
	      switch (children.childrenCount) {
	        case 0:
	          // place node here
	          children.children.data = node;
	          children.childrenCount = 1;
	          this._updateBranchMass(children, node);
	          break;
	        case 1:
	          // convert into children
	          // if there are two nodes exactly overlapping (on init, on opening of cluster etc.)
	          // we move one node a little bit and we do not put it in the tree.
	          if (children.children.data.x === node.x && children.children.data.y === node.y) {
	            node.x += this._rng();
	            node.y += this._rng();
	          } else {
	            this._splitBranch(children);
	            this._placeInTree(children, node);
	          }
	          break;
	        case 4:
	          // place in branch
	          this._placeInTree(children, node);
	          break;
	      }
	    }

	    /**
	     * this function splits a branch into 4 sub branches. If the branch contained a node, we place it in the subbranch
	     * after the split is complete.
	     *
	     * @param {object} parentBranch
	     * @private
	     */
	  }, {
	    key: "_splitBranch",
	    value: function _splitBranch(parentBranch) {
	      // if the branch is shaded with a node, replace the node in the new subset.
	      var containedNode = null;
	      if (parentBranch.childrenCount === 1) {
	        containedNode = parentBranch.children.data;
	        parentBranch.mass = 0;
	        parentBranch.centerOfMass.x = 0;
	        parentBranch.centerOfMass.y = 0;
	      }
	      parentBranch.childrenCount = 4;
	      parentBranch.children.data = null;
	      this._insertRegion(parentBranch, "NW");
	      this._insertRegion(parentBranch, "NE");
	      this._insertRegion(parentBranch, "SW");
	      this._insertRegion(parentBranch, "SE");
	      if (containedNode != null) {
	        this._placeInTree(parentBranch, containedNode);
	      }
	    }

	    /**
	     * This function subdivides the region into four new segments.
	     * Specifically, this inserts a single new segment.
	     * It fills the children section of the parentBranch
	     *
	     * @param {object} parentBranch
	     * @param {'NW'| 'NE' | 'SW' | 'SE'} region
	     * @private
	     */
	  }, {
	    key: "_insertRegion",
	    value: function _insertRegion(parentBranch, region) {
	      var minX, maxX, minY, maxY;
	      var childSize = 0.5 * parentBranch.size;
	      switch (region) {
	        case "NW":
	          minX = parentBranch.range.minX;
	          maxX = parentBranch.range.minX + childSize;
	          minY = parentBranch.range.minY;
	          maxY = parentBranch.range.minY + childSize;
	          break;
	        case "NE":
	          minX = parentBranch.range.minX + childSize;
	          maxX = parentBranch.range.maxX;
	          minY = parentBranch.range.minY;
	          maxY = parentBranch.range.minY + childSize;
	          break;
	        case "SW":
	          minX = parentBranch.range.minX;
	          maxX = parentBranch.range.minX + childSize;
	          minY = parentBranch.range.minY + childSize;
	          maxY = parentBranch.range.maxY;
	          break;
	        case "SE":
	          minX = parentBranch.range.minX + childSize;
	          maxX = parentBranch.range.maxX;
	          minY = parentBranch.range.minY + childSize;
	          maxY = parentBranch.range.maxY;
	          break;
	      }
	      parentBranch.children[region] = {
	        centerOfMass: {
	          x: 0,
	          y: 0
	        },
	        mass: 0,
	        range: {
	          minX: minX,
	          maxX: maxX,
	          minY: minY,
	          maxY: maxY
	        },
	        size: 0.5 * parentBranch.size,
	        calcSize: 2 * parentBranch.calcSize,
	        children: {
	          data: null
	        },
	        maxWidth: 0,
	        level: parentBranch.level + 1,
	        childrenCount: 0
	      };
	    }

	    //---------------------------  DEBUGGING BELOW  ---------------------------//

	    /**
	     * This function is for debugging purposed, it draws the tree.
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {string} color
	     * @private
	     */
	  }, {
	    key: "_debug",
	    value: function _debug(ctx, color) {
	      if (this.barnesHutTree !== undefined) {
	        ctx.lineWidth = 1;
	        this._drawBranch(this.barnesHutTree.root, ctx, color);
	      }
	    }

	    /**
	     * This function is for debugging purposes. It draws the branches recursively.
	     *
	     * @param {object} branch
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {string} color
	     * @private
	     */
	  }, {
	    key: "_drawBranch",
	    value: function _drawBranch(branch, ctx, color) {
	      if (color === undefined) {
	        color = "#FF0000";
	      }
	      if (branch.childrenCount === 4) {
	        this._drawBranch(branch.children.NW, ctx);
	        this._drawBranch(branch.children.NE, ctx);
	        this._drawBranch(branch.children.SE, ctx);
	        this._drawBranch(branch.children.SW, ctx);
	      }
	      ctx.strokeStyle = color;
	      ctx.beginPath();
	      ctx.moveTo(branch.range.minX, branch.range.minY);
	      ctx.lineTo(branch.range.maxX, branch.range.minY);
	      ctx.stroke();
	      ctx.beginPath();
	      ctx.moveTo(branch.range.maxX, branch.range.minY);
	      ctx.lineTo(branch.range.maxX, branch.range.maxY);
	      ctx.stroke();
	      ctx.beginPath();
	      ctx.moveTo(branch.range.maxX, branch.range.maxY);
	      ctx.lineTo(branch.range.minX, branch.range.maxY);
	      ctx.stroke();
	      ctx.beginPath();
	      ctx.moveTo(branch.range.minX, branch.range.maxY);
	      ctx.lineTo(branch.range.minX, branch.range.minY);
	      ctx.stroke();

	      /*
	       if (branch.mass > 0) {
	       ctx.circle(branch.centerOfMass.x, branch.centerOfMass.y, 3*branch.mass);
	       ctx.stroke();
	       }
	       */
	    }
	  }]);
	  return BarnesHutSolver;
	}();

	/**
	 * Repulsion Solver
	 */
	var RepulsionSolver = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
	   * @param {object} options
	   */
	  function RepulsionSolver(body, physicsBody, options) {
	    _classCallCheck(this, RepulsionSolver);
	    this._rng = Alea("REPULSION SOLVER");
	    this.body = body;
	    this.physicsBody = physicsBody;
	    this.setOptions(options);
	  }

	  /**
	   *
	   * @param {object} options
	   */
	  _createClass(RepulsionSolver, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	    }

	    /**
	     * Calculate the forces the nodes apply on each other based on a repulsion field.
	     * This field is linearly approximated.
	     *
	     * @private
	     */
	  }, {
	    key: "solve",
	    value: function solve() {
	      var dx, dy, distance, fx, fy, repulsingForce, node1, node2;
	      var nodes = this.body.nodes;
	      var nodeIndices = this.physicsBody.physicsNodeIndices;
	      var forces = this.physicsBody.forces;

	      // repulsing forces between nodes
	      var nodeDistance = this.options.nodeDistance;

	      // approximation constants
	      var a = -2 / 3 / nodeDistance;
	      var b = 4 / 3;

	      // we loop from i over all but the last entree in the array
	      // j loops from i+1 to the last. This way we do not double count any of the indices, nor i === j
	      for (var i = 0; i < nodeIndices.length - 1; i++) {
	        node1 = nodes[nodeIndices[i]];
	        for (var j = i + 1; j < nodeIndices.length; j++) {
	          node2 = nodes[nodeIndices[j]];
	          dx = node2.x - node1.x;
	          dy = node2.y - node1.y;
	          distance = Math.sqrt(dx * dx + dy * dy);

	          // same condition as BarnesHutSolver, making sure nodes are never 100% overlapping.
	          if (distance === 0) {
	            distance = 0.1 * this._rng();
	            dx = distance;
	          }
	          if (distance < 2 * nodeDistance) {
	            if (distance < 0.5 * nodeDistance) {
	              repulsingForce = 1.0;
	            } else {
	              repulsingForce = a * distance + b; // linear approx of  1 / (1 + Math.exp((distance / nodeDistance - 1) * steepness))
	            }

	            repulsingForce = repulsingForce / distance;
	            fx = dx * repulsingForce;
	            fy = dy * repulsingForce;
	            forces[node1.id].x -= fx;
	            forces[node1.id].y -= fy;
	            forces[node2.id].x += fx;
	            forces[node2.id].y += fy;
	          }
	        }
	      }
	    }
	  }]);
	  return RepulsionSolver;
	}();

	/**
	 * Hierarchical Repulsion Solver
	 */
	var HierarchicalRepulsionSolver = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
	   * @param {object} options
	   */
	  function HierarchicalRepulsionSolver(body, physicsBody, options) {
	    _classCallCheck(this, HierarchicalRepulsionSolver);
	    this.body = body;
	    this.physicsBody = physicsBody;
	    this.setOptions(options);
	  }

	  /**
	   *
	   * @param {object} options
	   */
	  _createClass(HierarchicalRepulsionSolver, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	      this.overlapAvoidanceFactor = Math.max(0, Math.min(1, this.options.avoidOverlap || 0));
	    }

	    /**
	     * Calculate the forces the nodes apply on each other based on a repulsion field.
	     * This field is linearly approximated.
	     *
	     * @private
	     */
	  }, {
	    key: "solve",
	    value: function solve() {
	      var nodes = this.body.nodes;
	      var nodeIndices = this.physicsBody.physicsNodeIndices;
	      var forces = this.physicsBody.forces;

	      // repulsing forces between nodes
	      var nodeDistance = this.options.nodeDistance;

	      // we loop from i over all but the last entree in the array
	      // j loops from i+1 to the last. This way we do not double count any of the indices, nor i === j
	      for (var i = 0; i < nodeIndices.length - 1; i++) {
	        var node1 = nodes[nodeIndices[i]];
	        for (var j = i + 1; j < nodeIndices.length; j++) {
	          var node2 = nodes[nodeIndices[j]];

	          // nodes only affect nodes on their level
	          if (node1.level === node2.level) {
	            var theseNodesDistance = nodeDistance + this.overlapAvoidanceFactor * ((node1.shape.radius || 0) / 2 + (node2.shape.radius || 0) / 2);
	            var dx = node2.x - node1.x;
	            var dy = node2.y - node1.y;
	            var distance = Math.sqrt(dx * dx + dy * dy);
	            var steepness = 0.05;
	            var repulsingForce = void 0;
	            if (distance < theseNodesDistance) {
	              repulsingForce = -Math.pow(steepness * distance, 2) + Math.pow(steepness * theseNodesDistance, 2);
	            } else {
	              repulsingForce = 0;
	            }
	            // normalize force with
	            if (distance !== 0) {
	              repulsingForce = repulsingForce / distance;
	            }
	            var fx = dx * repulsingForce;
	            var fy = dy * repulsingForce;
	            forces[node1.id].x -= fx;
	            forces[node1.id].y -= fy;
	            forces[node2.id].x += fx;
	            forces[node2.id].y += fy;
	          }
	        }
	      }
	    }
	  }]);
	  return HierarchicalRepulsionSolver;
	}();

	/**
	 * Spring Solver
	 */
	var SpringSolver = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
	   * @param {object} options
	   */
	  function SpringSolver(body, physicsBody, options) {
	    _classCallCheck(this, SpringSolver);
	    this.body = body;
	    this.physicsBody = physicsBody;
	    this.setOptions(options);
	  }

	  /**
	   *
	   * @param {object} options
	   */
	  _createClass(SpringSolver, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	    }

	    /**
	     * This function calculates the springforces on the nodes, accounting for the support nodes.
	     *
	     * @private
	     */
	  }, {
	    key: "solve",
	    value: function solve() {
	      var edgeLength, edge;
	      var edgeIndices = this.physicsBody.physicsEdgeIndices;
	      var edges = this.body.edges;
	      var node1, node2, node3;

	      // forces caused by the edges, modelled as springs
	      for (var i = 0; i < edgeIndices.length; i++) {
	        edge = edges[edgeIndices[i]];
	        if (edge.connected === true && edge.toId !== edge.fromId) {
	          // only calculate forces if nodes are in the same sector
	          if (this.body.nodes[edge.toId] !== undefined && this.body.nodes[edge.fromId] !== undefined) {
	            if (edge.edgeType.via !== undefined) {
	              edgeLength = edge.options.length === undefined ? this.options.springLength : edge.options.length;
	              node1 = edge.to;
	              node2 = edge.edgeType.via;
	              node3 = edge.from;
	              this._calculateSpringForce(node1, node2, 0.5 * edgeLength);
	              this._calculateSpringForce(node2, node3, 0.5 * edgeLength);
	            } else {
	              // the * 1.5 is here so the edge looks as large as a smooth edge. It does not initially because the smooth edges use
	              // the support nodes which exert a repulsive force on the to and from nodes, making the edge appear larger.
	              edgeLength = edge.options.length === undefined ? this.options.springLength * 1.5 : edge.options.length;
	              this._calculateSpringForce(edge.from, edge.to, edgeLength);
	            }
	          }
	        }
	      }
	    }

	    /**
	     * This is the code actually performing the calculation for the function above.
	     *
	     * @param {Node} node1
	     * @param {Node} node2
	     * @param {number} edgeLength
	     * @private
	     */
	  }, {
	    key: "_calculateSpringForce",
	    value: function _calculateSpringForce(node1, node2, edgeLength) {
	      var dx = node1.x - node2.x;
	      var dy = node1.y - node2.y;
	      var distance = Math.max(Math.sqrt(dx * dx + dy * dy), 0.01);

	      // the 1/distance is so the fx and fy can be calculated without sine or cosine.
	      var springForce = this.options.springConstant * (edgeLength - distance) / distance;
	      var fx = dx * springForce;
	      var fy = dy * springForce;

	      // handle the case where one node is not part of the physcis
	      if (this.physicsBody.forces[node1.id] !== undefined) {
	        this.physicsBody.forces[node1.id].x += fx;
	        this.physicsBody.forces[node1.id].y += fy;
	      }
	      if (this.physicsBody.forces[node2.id] !== undefined) {
	        this.physicsBody.forces[node2.id].x -= fx;
	        this.physicsBody.forces[node2.id].y -= fy;
	      }
	    }
	  }]);
	  return SpringSolver;
	}();

	/**
	 * Hierarchical Spring Solver
	 */
	var HierarchicalSpringSolver = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
	   * @param {object} options
	   */
	  function HierarchicalSpringSolver(body, physicsBody, options) {
	    _classCallCheck(this, HierarchicalSpringSolver);
	    this.body = body;
	    this.physicsBody = physicsBody;
	    this.setOptions(options);
	  }

	  /**
	   *
	   * @param {object} options
	   */
	  _createClass(HierarchicalSpringSolver, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	    }

	    /**
	     * This function calculates the springforces on the nodes, accounting for the support nodes.
	     *
	     * @private
	     */
	  }, {
	    key: "solve",
	    value: function solve() {
	      var edgeLength, edge;
	      var dx, dy, fx, fy, springForce, distance;
	      var edges = this.body.edges;
	      var factor = 0.5;
	      var edgeIndices = this.physicsBody.physicsEdgeIndices;
	      var nodeIndices = this.physicsBody.physicsNodeIndices;
	      var forces = this.physicsBody.forces;

	      // initialize the spring force counters
	      for (var i = 0; i < nodeIndices.length; i++) {
	        var nodeId = nodeIndices[i];
	        forces[nodeId].springFx = 0;
	        forces[nodeId].springFy = 0;
	      }

	      // forces caused by the edges, modelled as springs
	      for (var _i = 0; _i < edgeIndices.length; _i++) {
	        edge = edges[edgeIndices[_i]];
	        if (edge.connected === true) {
	          edgeLength = edge.options.length === undefined ? this.options.springLength : edge.options.length;
	          dx = edge.from.x - edge.to.x;
	          dy = edge.from.y - edge.to.y;
	          distance = Math.sqrt(dx * dx + dy * dy);
	          distance = distance === 0 ? 0.01 : distance;

	          // the 1/distance is so the fx and fy can be calculated without sine or cosine.
	          springForce = this.options.springConstant * (edgeLength - distance) / distance;
	          fx = dx * springForce;
	          fy = dy * springForce;
	          if (edge.to.level != edge.from.level) {
	            if (forces[edge.toId] !== undefined) {
	              forces[edge.toId].springFx -= fx;
	              forces[edge.toId].springFy -= fy;
	            }
	            if (forces[edge.fromId] !== undefined) {
	              forces[edge.fromId].springFx += fx;
	              forces[edge.fromId].springFy += fy;
	            }
	          } else {
	            if (forces[edge.toId] !== undefined) {
	              forces[edge.toId].x -= factor * fx;
	              forces[edge.toId].y -= factor * fy;
	            }
	            if (forces[edge.fromId] !== undefined) {
	              forces[edge.fromId].x += factor * fx;
	              forces[edge.fromId].y += factor * fy;
	            }
	          }
	        }
	      }

	      // normalize spring forces
	      springForce = 1;
	      var springFx, springFy;
	      for (var _i2 = 0; _i2 < nodeIndices.length; _i2++) {
	        var _nodeId = nodeIndices[_i2];
	        springFx = Math.min(springForce, Math.max(-springForce, forces[_nodeId].springFx));
	        springFy = Math.min(springForce, Math.max(-springForce, forces[_nodeId].springFy));
	        forces[_nodeId].x += springFx;
	        forces[_nodeId].y += springFy;
	      }

	      // retain energy balance
	      var totalFx = 0;
	      var totalFy = 0;
	      for (var _i3 = 0; _i3 < nodeIndices.length; _i3++) {
	        var _nodeId2 = nodeIndices[_i3];
	        totalFx += forces[_nodeId2].x;
	        totalFy += forces[_nodeId2].y;
	      }
	      var correctionFx = totalFx / nodeIndices.length;
	      var correctionFy = totalFy / nodeIndices.length;
	      for (var _i4 = 0; _i4 < nodeIndices.length; _i4++) {
	        var _nodeId3 = nodeIndices[_i4];
	        forces[_nodeId3].x -= correctionFx;
	        forces[_nodeId3].y -= correctionFy;
	      }
	    }
	  }]);
	  return HierarchicalSpringSolver;
	}();

	/**
	 * Central Gravity Solver
	 */
	var CentralGravitySolver = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
	   * @param {object} options
	   */
	  function CentralGravitySolver(body, physicsBody, options) {
	    _classCallCheck(this, CentralGravitySolver);
	    this.body = body;
	    this.physicsBody = physicsBody;
	    this.setOptions(options);
	  }

	  /**
	   *
	   * @param {object} options
	   */
	  _createClass(CentralGravitySolver, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	    }

	    /**
	     * Calculates forces for each node
	     */
	  }, {
	    key: "solve",
	    value: function solve() {
	      var dx, dy, distance, node;
	      var nodes = this.body.nodes;
	      var nodeIndices = this.physicsBody.physicsNodeIndices;
	      var forces = this.physicsBody.forces;
	      for (var i = 0; i < nodeIndices.length; i++) {
	        var nodeId = nodeIndices[i];
	        node = nodes[nodeId];
	        dx = -node.x;
	        dy = -node.y;
	        distance = Math.sqrt(dx * dx + dy * dy);
	        this._calculateForces(distance, dx, dy, forces, node);
	      }
	    }

	    /**
	     * Calculate the forces based on the distance.
	     *
	     * @param {number} distance
	     * @param {number} dx
	     * @param {number} dy
	     * @param {Object<Node.id, vis.Node>} forces
	     * @param {Node} node
	     * @private
	     */
	  }, {
	    key: "_calculateForces",
	    value: function _calculateForces(distance, dx, dy, forces, node) {
	      var gravityForce = distance === 0 ? 0 : this.options.centralGravity / distance;
	      forces[node.id].x = dx * gravityForce;
	      forces[node.id].y = dy * gravityForce;
	    }
	  }]);
	  return CentralGravitySolver;
	}();

	function _createSuper$3(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$3(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$3() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * @augments BarnesHutSolver
	 */
	var ForceAtlas2BasedRepulsionSolver = /*#__PURE__*/function (_BarnesHutSolver) {
	  _inherits(ForceAtlas2BasedRepulsionSolver, _BarnesHutSolver);
	  var _super = _createSuper$3(ForceAtlas2BasedRepulsionSolver);
	  /**
	   * @param {object} body
	   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
	   * @param {object} options
	   */
	  function ForceAtlas2BasedRepulsionSolver(body, physicsBody, options) {
	    var _this;
	    _classCallCheck(this, ForceAtlas2BasedRepulsionSolver);
	    _this = _super.call(this, body, physicsBody, options);
	    _this._rng = Alea("FORCE ATLAS 2 BASED REPULSION SOLVER");
	    return _this;
	  }

	  /**
	   * Calculate the forces based on the distance.
	   *
	   * @param {number} distance
	   * @param {number} dx
	   * @param {number} dy
	   * @param {Node} node
	   * @param {object} parentBranch
	   * @private
	   */
	  _createClass(ForceAtlas2BasedRepulsionSolver, [{
	    key: "_calculateForces",
	    value: function _calculateForces(distance, dx, dy, node, parentBranch) {
	      if (distance === 0) {
	        distance = 0.1 * this._rng();
	        dx = distance;
	      }
	      if (this.overlapAvoidanceFactor < 1 && node.shape.radius) {
	        distance = Math.max(0.1 + this.overlapAvoidanceFactor * node.shape.radius, distance - node.shape.radius);
	      }
	      var degree = node.edges.length + 1;
	      // the dividing by the distance cubed instead of squared allows us to get the fx and fy components without sines and cosines
	      // it is shorthand for gravityforce with distance squared and fx = dx/distance * gravityForce
	      var gravityForce = this.options.gravitationalConstant * parentBranch.mass * node.options.mass * degree / Math.pow(distance, 2);
	      var fx = dx * gravityForce;
	      var fy = dy * gravityForce;
	      this.physicsBody.forces[node.id].x += fx;
	      this.physicsBody.forces[node.id].y += fy;
	    }
	  }]);
	  return ForceAtlas2BasedRepulsionSolver;
	}(BarnesHutSolver);

	function _createSuper$2(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$2() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * @augments CentralGravitySolver
	 */
	var ForceAtlas2BasedCentralGravitySolver = /*#__PURE__*/function (_CentralGravitySolver) {
	  _inherits(ForceAtlas2BasedCentralGravitySolver, _CentralGravitySolver);
	  var _super = _createSuper$2(ForceAtlas2BasedCentralGravitySolver);
	  /**
	   * @param {object} body
	   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
	   * @param {object} options
	   */
	  function ForceAtlas2BasedCentralGravitySolver(body, physicsBody, options) {
	    _classCallCheck(this, ForceAtlas2BasedCentralGravitySolver);
	    return _super.call(this, body, physicsBody, options);
	  }

	  /**
	   * Calculate the forces based on the distance.
	   *
	   * @param {number} distance
	   * @param {number} dx
	   * @param {number} dy
	   * @param {Object<Node.id, Node>} forces
	   * @param {Node} node
	   * @private
	   */
	  _createClass(ForceAtlas2BasedCentralGravitySolver, [{
	    key: "_calculateForces",
	    value: function _calculateForces(distance, dx, dy, forces, node) {
	      if (distance > 0) {
	        var degree = node.edges.length + 1;
	        var gravityForce = this.options.centralGravity * degree * node.options.mass;
	        forces[node.id].x = dx * gravityForce;
	        forces[node.id].y = dy * gravityForce;
	      }
	    }
	  }]);
	  return ForceAtlas2BasedCentralGravitySolver;
	}(CentralGravitySolver);

	/**
	 * The physics engine
	 */
	var PhysicsEngine = /*#__PURE__*/function () {
	  /**
	   * @param {object} body
	   */
	  function PhysicsEngine(body) {
	    _classCallCheck(this, PhysicsEngine);
	    this.body = body;
	    this.physicsBody = {
	      physicsNodeIndices: [],
	      physicsEdgeIndices: [],
	      forces: {},
	      velocities: {}
	    };
	    this.physicsEnabled = true;
	    this.simulationInterval = 1000 / 60;
	    this.requiresTimeout = true;
	    this.previousStates = {};
	    this.referenceState = {};
	    this.freezeCache = {};
	    this.renderTimer = undefined;

	    // parameters for the adaptive timestep
	    this.adaptiveTimestep = false;
	    this.adaptiveTimestepEnabled = false;
	    this.adaptiveCounter = 0;
	    this.adaptiveInterval = 3;
	    this.stabilized = false;
	    this.startedStabilization = false;
	    this.stabilizationIterations = 0;
	    this.ready = false; // will be set to true if the stabilize

	    // default options
	    this.options = {};
	    this.defaultOptions = {
	      enabled: true,
	      barnesHut: {
	        theta: 0.5,
	        gravitationalConstant: -2000,
	        centralGravity: 0.3,
	        springLength: 95,
	        springConstant: 0.04,
	        damping: 0.09,
	        avoidOverlap: 0
	      },
	      forceAtlas2Based: {
	        theta: 0.5,
	        gravitationalConstant: -50,
	        centralGravity: 0.01,
	        springConstant: 0.08,
	        springLength: 100,
	        damping: 0.4,
	        avoidOverlap: 0
	      },
	      repulsion: {
	        centralGravity: 0.2,
	        springLength: 200,
	        springConstant: 0.05,
	        nodeDistance: 100,
	        damping: 0.09,
	        avoidOverlap: 0
	      },
	      hierarchicalRepulsion: {
	        centralGravity: 0.0,
	        springLength: 100,
	        springConstant: 0.01,
	        nodeDistance: 120,
	        damping: 0.09
	      },
	      maxVelocity: 50,
	      minVelocity: 0.75,
	      // px/s
	      solver: "barnesHut",
	      stabilization: {
	        enabled: true,
	        iterations: 1000,
	        // maximum number of iteration to stabilize
	        updateInterval: 50,
	        onlyDynamicEdges: false,
	        fit: true
	      },
	      timestep: 0.5,
	      adaptiveTimestep: true,
	      wind: {
	        x: 0,
	        y: 0
	      }
	    };
	    _Object$assign(this.options, this.defaultOptions);
	    this.timestep = 0.5;
	    this.layoutFailed = false;
	    this.bindEventListeners();
	  }

	  /**
	   * Binds event listeners
	   */
	  _createClass(PhysicsEngine, [{
	    key: "bindEventListeners",
	    value: function bindEventListeners() {
	      var _this = this;
	      this.body.emitter.on("initPhysics", function () {
	        _this.initPhysics();
	      });
	      this.body.emitter.on("_layoutFailed", function () {
	        _this.layoutFailed = true;
	      });
	      this.body.emitter.on("resetPhysics", function () {
	        _this.stopSimulation();
	        _this.ready = false;
	      });
	      this.body.emitter.on("disablePhysics", function () {
	        _this.physicsEnabled = false;
	        _this.stopSimulation();
	      });
	      this.body.emitter.on("restorePhysics", function () {
	        _this.setOptions(_this.options);
	        if (_this.ready === true) {
	          _this.startSimulation();
	        }
	      });
	      this.body.emitter.on("startSimulation", function () {
	        if (_this.ready === true) {
	          _this.startSimulation();
	        }
	      });
	      this.body.emitter.on("stopSimulation", function () {
	        _this.stopSimulation();
	      });
	      this.body.emitter.on("destroy", function () {
	        _this.stopSimulation(false);
	        _this.body.emitter.off();
	      });
	      this.body.emitter.on("_dataChanged", function () {
	        // Nodes and/or edges have been added or removed, update shortcut lists.
	        _this.updatePhysicsData();
	      });

	      // debug: show forces
	      // this.body.emitter.on("afterDrawing", (ctx) => {this._drawForces(ctx);});
	    }

	    /**
	     * set the physics options
	     *
	     * @param {object} options
	     */
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options !== undefined) {
	        if (options === false) {
	          this.options.enabled = false;
	          this.physicsEnabled = false;
	          this.stopSimulation();
	        } else if (options === true) {
	          this.options.enabled = true;
	          this.physicsEnabled = true;
	          this.startSimulation();
	        } else {
	          this.physicsEnabled = true;
	          selectiveNotDeepExtend(["stabilization"], this.options, options);
	          mergeOptions(this.options, options, "stabilization");
	          if (options.enabled === undefined) {
	            this.options.enabled = true;
	          }
	          if (this.options.enabled === false) {
	            this.physicsEnabled = false;
	            this.stopSimulation();
	          }
	          var wind = this.options.wind;
	          if (wind) {
	            if (typeof wind.x !== "number" || _Number$isNaN(wind.x)) {
	              wind.x = 0;
	            }
	            if (typeof wind.y !== "number" || _Number$isNaN(wind.y)) {
	              wind.y = 0;
	            }
	          }

	          // set the timestep
	          this.timestep = this.options.timestep;
	        }
	      }
	      this.init();
	    }

	    /**
	     * configure the engine.
	     */
	  }, {
	    key: "init",
	    value: function init() {
	      var options;
	      if (this.options.solver === "forceAtlas2Based") {
	        options = this.options.forceAtlas2Based;
	        this.nodesSolver = new ForceAtlas2BasedRepulsionSolver(this.body, this.physicsBody, options);
	        this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
	        this.gravitySolver = new ForceAtlas2BasedCentralGravitySolver(this.body, this.physicsBody, options);
	      } else if (this.options.solver === "repulsion") {
	        options = this.options.repulsion;
	        this.nodesSolver = new RepulsionSolver(this.body, this.physicsBody, options);
	        this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
	        this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
	      } else if (this.options.solver === "hierarchicalRepulsion") {
	        options = this.options.hierarchicalRepulsion;
	        this.nodesSolver = new HierarchicalRepulsionSolver(this.body, this.physicsBody, options);
	        this.edgesSolver = new HierarchicalSpringSolver(this.body, this.physicsBody, options);
	        this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
	      } else {
	        // barnesHut
	        options = this.options.barnesHut;
	        this.nodesSolver = new BarnesHutSolver(this.body, this.physicsBody, options);
	        this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
	        this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
	      }
	      this.modelOptions = options;
	    }

	    /**
	     * initialize the engine
	     */
	  }, {
	    key: "initPhysics",
	    value: function initPhysics() {
	      if (this.physicsEnabled === true && this.options.enabled === true) {
	        if (this.options.stabilization.enabled === true) {
	          this.stabilize();
	        } else {
	          this.stabilized = false;
	          this.ready = true;
	          this.body.emitter.emit("fit", {}, this.layoutFailed); // if the layout failed, we use the approximation for the zoom
	          this.startSimulation();
	        }
	      } else {
	        this.ready = true;
	        this.body.emitter.emit("fit");
	      }
	    }

	    /**
	     * Start the simulation
	     */
	  }, {
	    key: "startSimulation",
	    value: function startSimulation() {
	      if (this.physicsEnabled === true && this.options.enabled === true) {
	        this.stabilized = false;

	        // when visible, adaptivity is disabled.
	        this.adaptiveTimestep = false;

	        // this sets the width of all nodes initially which could be required for the avoidOverlap
	        this.body.emitter.emit("_resizeNodes");
	        if (this.viewFunction === undefined) {
	          var _context;
	          this.viewFunction = _bindInstanceProperty$1(_context = this.simulationStep).call(_context, this);
	          this.body.emitter.on("initRedraw", this.viewFunction);
	          this.body.emitter.emit("_startRendering");
	        }
	      } else {
	        this.body.emitter.emit("_redraw");
	      }
	    }

	    /**
	     * Stop the simulation, force stabilization.
	     *
	     * @param {boolean} [emit=true]
	     */
	  }, {
	    key: "stopSimulation",
	    value: function stopSimulation() {
	      var emit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
	      this.stabilized = true;
	      if (emit === true) {
	        this._emitStabilized();
	      }
	      if (this.viewFunction !== undefined) {
	        this.body.emitter.off("initRedraw", this.viewFunction);
	        this.viewFunction = undefined;
	        if (emit === true) {
	          this.body.emitter.emit("_stopRendering");
	        }
	      }
	    }

	    /**
	     * The viewFunction inserts this step into each render loop. It calls the physics tick and handles the cleanup at stabilized.
	     *
	     */
	  }, {
	    key: "simulationStep",
	    value: function simulationStep() {
	      // check if the physics have settled
	      var startTime = _Date$now();
	      this.physicsTick();
	      var physicsTime = _Date$now() - startTime;

	      // run double speed if it is a little graph
	      if ((physicsTime < 0.4 * this.simulationInterval || this.runDoubleSpeed === true) && this.stabilized === false) {
	        this.physicsTick();

	        // this makes sure there is no jitter. The decision is taken once to run it at double speed.
	        this.runDoubleSpeed = true;
	      }
	      if (this.stabilized === true) {
	        this.stopSimulation();
	      }
	    }

	    /**
	     * trigger the stabilized event.
	     *
	     * @param {number} [amountOfIterations=this.stabilizationIterations]
	     * @private
	     */
	  }, {
	    key: "_emitStabilized",
	    value: function _emitStabilized() {
	      var _this2 = this;
	      var amountOfIterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.stabilizationIterations;
	      if (this.stabilizationIterations > 1 || this.startedStabilization === true) {
	        _setTimeout(function () {
	          _this2.body.emitter.emit("stabilized", {
	            iterations: amountOfIterations
	          });
	          _this2.startedStabilization = false;
	          _this2.stabilizationIterations = 0;
	        }, 0);
	      }
	    }

	    /**
	     * Calculate the forces for one physics iteration and move the nodes.
	     *
	     * @private
	     */
	  }, {
	    key: "physicsStep",
	    value: function physicsStep() {
	      this.gravitySolver.solve();
	      this.nodesSolver.solve();
	      this.edgesSolver.solve();
	      this.moveNodes();
	    }

	    /**
	     * Make dynamic adjustments to the timestep, based on current state.
	     *
	     * Helper function for physicsTick().
	     *
	     * @private
	     */
	  }, {
	    key: "adjustTimeStep",
	    value: function adjustTimeStep() {
	      var factor = 1.2; // Factor for increasing the timestep on success.

	      // we compare the two steps. if it is acceptable we double the step.
	      if (this._evaluateStepQuality() === true) {
	        this.timestep = factor * this.timestep;
	      } else {
	        // if not, we decrease the step to a minimum of the options timestep.
	        // if the decreased timestep is smaller than the options step, we do not reset the counter
	        // we assume that the options timestep is stable enough.
	        if (this.timestep / factor < this.options.timestep) {
	          this.timestep = this.options.timestep;
	        } else {
	          // if the timestep was larger than 2 times the option one we check the adaptivity again to ensure
	          // that large instabilities do not form.
	          this.adaptiveCounter = -1; // check again next iteration
	          this.timestep = Math.max(this.options.timestep, this.timestep / factor);
	        }
	      }
	    }

	    /**
	     * A single simulation step (or 'tick') in the physics simulation
	     *
	     * @private
	     */
	  }, {
	    key: "physicsTick",
	    value: function physicsTick() {
	      this._startStabilizing(); // this ensures that there is no start event when the network is already stable.
	      if (this.stabilized === true) return;

	      // adaptivity means the timestep adapts to the situation, only applicable for stabilization
	      if (this.adaptiveTimestep === true && this.adaptiveTimestepEnabled === true) {
	        // timestep remains stable for "interval" iterations.
	        var doAdaptive = this.adaptiveCounter % this.adaptiveInterval === 0;
	        if (doAdaptive) {
	          // first the big step and revert.
	          this.timestep = 2 * this.timestep;
	          this.physicsStep();
	          this.revert(); // saves the reference state

	          // now the normal step. Since this is the last step, it is the more stable one and we will take this.
	          this.timestep = 0.5 * this.timestep;

	          // since it's half the step, we do it twice.
	          this.physicsStep();
	          this.physicsStep();
	          this.adjustTimeStep();
	        } else {
	          this.physicsStep(); // normal step, keeping timestep constant
	        }

	        this.adaptiveCounter += 1;
	      } else {
	        // case for the static timestep, we reset it to the one in options and take a normal step.
	        this.timestep = this.options.timestep;
	        this.physicsStep();
	      }
	      if (this.stabilized === true) this.revert();
	      this.stabilizationIterations++;
	    }

	    /**
	     * Nodes and edges can have the physics toggles on or off. A collection of indices is created here so we can skip the check all the time.
	     *
	     * @private
	     */
	  }, {
	    key: "updatePhysicsData",
	    value: function updatePhysicsData() {
	      this.physicsBody.forces = {};
	      this.physicsBody.physicsNodeIndices = [];
	      this.physicsBody.physicsEdgeIndices = [];
	      var nodes = this.body.nodes;
	      var edges = this.body.edges;

	      // get node indices for physics
	      for (var nodeId in nodes) {
	        if (Object.prototype.hasOwnProperty.call(nodes, nodeId)) {
	          if (nodes[nodeId].options.physics === true) {
	            this.physicsBody.physicsNodeIndices.push(nodes[nodeId].id);
	          }
	        }
	      }

	      // get edge indices for physics
	      for (var edgeId in edges) {
	        if (Object.prototype.hasOwnProperty.call(edges, edgeId)) {
	          if (edges[edgeId].options.physics === true) {
	            this.physicsBody.physicsEdgeIndices.push(edges[edgeId].id);
	          }
	        }
	      }

	      // get the velocity and the forces vector
	      for (var i = 0; i < this.physicsBody.physicsNodeIndices.length; i++) {
	        var _nodeId = this.physicsBody.physicsNodeIndices[i];
	        this.physicsBody.forces[_nodeId] = {
	          x: 0,
	          y: 0
	        };

	        // forces can be reset because they are recalculated. Velocities have to persist.
	        if (this.physicsBody.velocities[_nodeId] === undefined) {
	          this.physicsBody.velocities[_nodeId] = {
	            x: 0,
	            y: 0
	          };
	        }
	      }

	      // clean deleted nodes from the velocity vector
	      for (var _nodeId2 in this.physicsBody.velocities) {
	        if (nodes[_nodeId2] === undefined) {
	          delete this.physicsBody.velocities[_nodeId2];
	        }
	      }
	    }

	    /**
	     * Revert the simulation one step. This is done so after stabilization, every new start of the simulation will also say stabilized.
	     */
	  }, {
	    key: "revert",
	    value: function revert() {
	      var nodeIds = _Object$keys(this.previousStates);
	      var nodes = this.body.nodes;
	      var velocities = this.physicsBody.velocities;
	      this.referenceState = {};
	      for (var i = 0; i < nodeIds.length; i++) {
	        var nodeId = nodeIds[i];
	        if (nodes[nodeId] !== undefined) {
	          if (nodes[nodeId].options.physics === true) {
	            this.referenceState[nodeId] = {
	              positions: {
	                x: nodes[nodeId].x,
	                y: nodes[nodeId].y
	              }
	            };
	            velocities[nodeId].x = this.previousStates[nodeId].vx;
	            velocities[nodeId].y = this.previousStates[nodeId].vy;
	            nodes[nodeId].x = this.previousStates[nodeId].x;
	            nodes[nodeId].y = this.previousStates[nodeId].y;
	          }
	        } else {
	          delete this.previousStates[nodeId];
	        }
	      }
	    }

	    /**
	     * This compares the reference state to the current state
	     *
	     * @returns {boolean}
	     * @private
	     */
	  }, {
	    key: "_evaluateStepQuality",
	    value: function _evaluateStepQuality() {
	      var dx, dy, dpos;
	      var nodes = this.body.nodes;
	      var reference = this.referenceState;
	      var posThreshold = 0.3;
	      for (var nodeId in this.referenceState) {
	        if (Object.prototype.hasOwnProperty.call(this.referenceState, nodeId) && nodes[nodeId] !== undefined) {
	          dx = nodes[nodeId].x - reference[nodeId].positions.x;
	          dy = nodes[nodeId].y - reference[nodeId].positions.y;
	          dpos = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));
	          if (dpos > posThreshold) {
	            return false;
	          }
	        }
	      }
	      return true;
	    }

	    /**
	     * move the nodes one timestep and check if they are stabilized
	     */
	  }, {
	    key: "moveNodes",
	    value: function moveNodes() {
	      var nodeIndices = this.physicsBody.physicsNodeIndices;
	      var maxNodeVelocity = 0;
	      var averageNodeVelocity = 0;

	      // the velocity threshold (energy in the system) for the adaptivity toggle
	      var velocityAdaptiveThreshold = 5;
	      for (var i = 0; i < nodeIndices.length; i++) {
	        var nodeId = nodeIndices[i];
	        var nodeVelocity = this._performStep(nodeId);
	        // stabilized is true if stabilized is true and velocity is smaller than vmin --> all nodes must be stabilized
	        maxNodeVelocity = Math.max(maxNodeVelocity, nodeVelocity);
	        averageNodeVelocity += nodeVelocity;
	      }

	      // evaluating the stabilized and adaptiveTimestepEnabled conditions
	      this.adaptiveTimestepEnabled = averageNodeVelocity / nodeIndices.length < velocityAdaptiveThreshold;
	      this.stabilized = maxNodeVelocity < this.options.minVelocity;
	    }

	    /**
	     * Calculate new velocity for a coordinate direction
	     *
	     * @param {number} v  velocity for current coordinate
	     * @param {number} f  regular force for current coordinate
	     * @param {number} m  mass of current node
	     * @returns {number} new velocity for current coordinate
	     * @private
	     */
	  }, {
	    key: "calculateComponentVelocity",
	    value: function calculateComponentVelocity(v, f, m) {
	      var df = this.modelOptions.damping * v; // damping force
	      var a = (f - df) / m; // acceleration

	      v += a * this.timestep;

	      // Put a limit on the velocities if it is really high
	      var maxV = this.options.maxVelocity || 1e9;
	      if (Math.abs(v) > maxV) {
	        v = v > 0 ? maxV : -maxV;
	      }
	      return v;
	    }

	    /**
	     * Perform the actual step
	     *
	     * @param {Node.id} nodeId
	     * @returns {number} the new velocity of given node
	     * @private
	     */
	  }, {
	    key: "_performStep",
	    value: function _performStep(nodeId) {
	      var node = this.body.nodes[nodeId];
	      var force = this.physicsBody.forces[nodeId];
	      if (this.options.wind) {
	        force.x += this.options.wind.x;
	        force.y += this.options.wind.y;
	      }
	      var velocity = this.physicsBody.velocities[nodeId];

	      // store the state so we can revert
	      this.previousStates[nodeId] = {
	        x: node.x,
	        y: node.y,
	        vx: velocity.x,
	        vy: velocity.y
	      };
	      if (node.options.fixed.x === false) {
	        velocity.x = this.calculateComponentVelocity(velocity.x, force.x, node.options.mass);
	        node.x += velocity.x * this.timestep;
	      } else {
	        force.x = 0;
	        velocity.x = 0;
	      }
	      if (node.options.fixed.y === false) {
	        velocity.y = this.calculateComponentVelocity(velocity.y, force.y, node.options.mass);
	        node.y += velocity.y * this.timestep;
	      } else {
	        force.y = 0;
	        velocity.y = 0;
	      }
	      var totalVelocity = Math.sqrt(Math.pow(velocity.x, 2) + Math.pow(velocity.y, 2));
	      return totalVelocity;
	    }

	    /**
	     * When initializing and stabilizing, we can freeze nodes with a predefined position.
	     * This greatly speeds up stabilization because only the supportnodes for the smoothCurves have to settle.
	     *
	     * @private
	     */
	  }, {
	    key: "_freezeNodes",
	    value: function _freezeNodes() {
	      var nodes = this.body.nodes;
	      for (var id in nodes) {
	        if (Object.prototype.hasOwnProperty.call(nodes, id)) {
	          if (nodes[id].x && nodes[id].y) {
	            var fixed = nodes[id].options.fixed;
	            this.freezeCache[id] = {
	              x: fixed.x,
	              y: fixed.y
	            };
	            fixed.x = true;
	            fixed.y = true;
	          }
	        }
	      }
	    }

	    /**
	     * Unfreezes the nodes that have been frozen by _freezeDefinedNodes.
	     *
	     * @private
	     */
	  }, {
	    key: "_restoreFrozenNodes",
	    value: function _restoreFrozenNodes() {
	      var nodes = this.body.nodes;
	      for (var id in nodes) {
	        if (Object.prototype.hasOwnProperty.call(nodes, id)) {
	          if (this.freezeCache[id] !== undefined) {
	            nodes[id].options.fixed.x = this.freezeCache[id].x;
	            nodes[id].options.fixed.y = this.freezeCache[id].y;
	          }
	        }
	      }
	      this.freezeCache = {};
	    }

	    /**
	     * Find a stable position for all nodes
	     *
	     * @param {number} [iterations=this.options.stabilization.iterations]
	     */
	  }, {
	    key: "stabilize",
	    value: function stabilize() {
	      var _this3 = this;
	      var iterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.options.stabilization.iterations;
	      if (typeof iterations !== "number") {
	        iterations = this.options.stabilization.iterations;
	        console.error("The stabilize method needs a numeric amount of iterations. Switching to default: ", iterations);
	      }
	      if (this.physicsBody.physicsNodeIndices.length === 0) {
	        this.ready = true;
	        return;
	      }

	      // enable adaptive timesteps
	      this.adaptiveTimestep = this.options.adaptiveTimestep;

	      // this sets the width of all nodes initially which could be required for the avoidOverlap
	      this.body.emitter.emit("_resizeNodes");
	      this.stopSimulation(); // stop the render loop
	      this.stabilized = false;

	      // block redraw requests
	      this.body.emitter.emit("_blockRedraw");
	      this.targetIterations = iterations;

	      // start the stabilization
	      if (this.options.stabilization.onlyDynamicEdges === true) {
	        this._freezeNodes();
	      }
	      this.stabilizationIterations = 0;
	      _setTimeout(function () {
	        return _this3._stabilizationBatch();
	      }, 0);
	    }

	    /**
	     * If not already stabilizing, start it and emit a start event.
	     *
	     * @returns {boolean} true if stabilization started with this call
	     * @private
	     */
	  }, {
	    key: "_startStabilizing",
	    value: function _startStabilizing() {
	      if (this.startedStabilization === true) return false;
	      this.body.emitter.emit("startStabilizing");
	      this.startedStabilization = true;
	      return true;
	    }

	    /**
	     * One batch of stabilization
	     *
	     * @private
	     */
	  }, {
	    key: "_stabilizationBatch",
	    value: function _stabilizationBatch() {
	      var _this4 = this;
	      var running = function running() {
	        return _this4.stabilized === false && _this4.stabilizationIterations < _this4.targetIterations;
	      };
	      var sendProgress = function sendProgress() {
	        _this4.body.emitter.emit("stabilizationProgress", {
	          iterations: _this4.stabilizationIterations,
	          total: _this4.targetIterations
	        });
	      };
	      if (this._startStabilizing()) {
	        sendProgress(); // Ensure that there is at least one start event.
	      }

	      var count = 0;
	      while (running() && count < this.options.stabilization.updateInterval) {
	        this.physicsTick();
	        count++;
	      }
	      sendProgress();
	      if (running()) {
	        var _context2;
	        _setTimeout(_bindInstanceProperty$1(_context2 = this._stabilizationBatch).call(_context2, this), 0);
	      } else {
	        this._finalizeStabilization();
	      }
	    }

	    /**
	     * Wrap up the stabilization, fit and emit the events.
	     *
	     * @private
	     */
	  }, {
	    key: "_finalizeStabilization",
	    value: function _finalizeStabilization() {
	      this.body.emitter.emit("_allowRedraw");
	      if (this.options.stabilization.fit === true) {
	        this.body.emitter.emit("fit");
	      }
	      if (this.options.stabilization.onlyDynamicEdges === true) {
	        this._restoreFrozenNodes();
	      }
	      this.body.emitter.emit("stabilizationIterationsDone");
	      this.body.emitter.emit("_requestRedraw");
	      if (this.stabilized === true) {
	        this._emitStabilized();
	      } else {
	        this.startSimulation();
	      }
	      this.ready = true;
	    }

	    //---------------------------  DEBUGGING BELOW  ---------------------------//

	    /**
	     * Debug function that display arrows for the forces currently active in the network.
	     *
	     * Use this when debugging 