/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util.prefs;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.util.prefs.ToolBarPrefsHandler;

public class PreferencesUtil
extends Preferences {
    private HashMap<String, Object> map = new HashMap();
    private boolean isUserNode;
    private static HashMap<Package, Preferences> systemNodes;
    private static HashMap<Package, Preferences> userNodes;

    public PreferencesUtil(boolean bl) {
        this.isUserNode = bl;
    }

    @Override
    public void put(String string, String string2) {
        this.map.put(string, string2);
    }

    @Override
    public String get(String string, String string2) {
        return this.map.containsKey(string) ? this.map.get(string) : string2;
    }

    @Override
    public void remove(String string) {
        this.map.remove(string);
    }

    @Override
    public void clear() throws BackingStoreException {
        this.map.clear();
    }

    @Override
    public void putInt(String string, int n) {
        this.map.put(string, n);
    }

    @Override
    public int getInt(String string, int n) {
        return (Integer)(this.map.containsKey(string) ? this.map.get(string) : Integer.valueOf(n));
    }

    @Override
    public void putLong(String string, long l) {
        this.map.put(string, l);
    }

    @Override
    public long getLong(String string, long l) {
        return (Long)(this.map.containsKey(string) ? this.map.get(string) : Long.valueOf(l));
    }

    @Override
    public void putBoolean(String string, boolean bl) {
        this.map.put(string, bl);
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        return (Boolean)(this.map.containsKey(string) ? this.map.get(string) : Boolean.valueOf(bl));
    }

    @Override
    public void putFloat(String string, float f) {
        this.map.put(string, Float.valueOf(f));
    }

    @Override
    public float getFloat(String string, float f) {
        return ((Float)(this.map.containsKey(string) ? this.map.get(string) : Float.valueOf(f))).floatValue();
    }

    @Override
    public void putDouble(String string, double d) {
        this.map.put(string, d);
    }

    @Override
    public double getDouble(String string, double d) {
        return (Double)(this.map.containsKey(string) ? this.map.get(string) : Double.valueOf(d));
    }

    @Override
    public void putByteArray(String string, byte[] byArray) {
        this.map.put(string, byArray);
    }

    @Override
    public byte[] getByteArray(String string, byte[] byArray) {
        return this.map.containsKey(string) ? (Object)this.map.get(string) : byArray;
    }

    @Override
    public String[] keys() throws BackingStoreException {
        return this.map.keySet().toArray(new String[this.map.keySet().size()]);
    }

    @Override
    public String[] childrenNames() throws BackingStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Preferences parent() {
        return null;
    }

    @Override
    public Preferences node(String string) {
        return null;
    }

    @Override
    public boolean nodeExists(String string) throws BackingStoreException {
        return false;
    }

    @Override
    public void removeNode() throws BackingStoreException {
    }

    @Override
    public String name() {
        return "Dummy";
    }

    @Override
    public String absolutePath() {
        return "Dummy";
    }

    @Override
    public boolean isUserNode() {
        return this.isUserNode;
    }

    @Override
    public String toString() {
        return "Dummy";
    }

    @Override
    public void flush() throws BackingStoreException {
        this.clear();
    }

    @Override
    public void sync() throws BackingStoreException {
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
    }

    @Override
    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener nodeChangeListener) {
    }

    @Override
    public void exportNode(OutputStream outputStream) throws IOException, BackingStoreException {
    }

    @Override
    public void exportSubtree(OutputStream outputStream) throws IOException, BackingStoreException {
    }

    public static Preferences systemNodeForPackage(Class<?> clazz) {
        if (systemNodes != null) {
            if (!systemNodes.containsKey(clazz.getPackage())) {
                systemNodes.put(clazz.getPackage(), new PreferencesUtil(false));
            }
            return systemNodes.get(clazz.getPackage());
        }
        try {
            return Preferences.systemNodeForPackage(clazz);
        }
        catch (Throwable throwable) {
            if (systemNodes == null) {
                systemNodes = new HashMap();
            }
            return PreferencesUtil.systemNodeForPackage(clazz);
        }
    }

    public static Preferences userNodeForPackage(Class<?> clazz) {
        if (userNodes != null) {
            if (!userNodes.containsKey(clazz.getPackage())) {
                userNodes.put(clazz.getPackage(), new PreferencesUtil(false));
            }
            return userNodes.get(clazz.getPackage());
        }
        try {
            return Preferences.userNodeForPackage(clazz);
        }
        catch (Throwable throwable) {
            if (userNodes == null) {
                userNodes = new HashMap();
            }
            return PreferencesUtil.userNodeForPackage(clazz);
        }
    }

    public static void installPrefsHandler(Preferences preferences, String string, JTabbedPane jTabbedPane) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private PreferencesUtil() {
    }

    public static void installFramePrefsHandler(final Preferences preferences, final String string, Window window) {
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = window.getToolkit().getScreenInsets(graphicsConfiguration);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        Dimension dimension = window.getPreferredSize();
        Dimension dimension2 = window.getMinimumSize();
        Rectangle rectangle2 = new Rectangle(preferences.getInt(string + ".x", 0), preferences.getInt(string + ".y", 0), Math.max(dimension2.width, preferences.getInt(string + ".width", dimension.width)), Math.max(dimension2.height, preferences.getInt(string + ".height", dimension.height)));
        if (!rectangle.contains(rectangle2)) {
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            Rectangle.intersect(rectangle, rectangle2, rectangle2);
        }
        window.setBounds(rectangle2);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                preferences.putInt(string + ".x", componentEvent.getComponent().getX());
                preferences.putInt(string + ".y", componentEvent.getComponent().getY());
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                preferences.putInt(string + ".width", componentEvent.getComponent().getWidth());
                preferences.putInt(string + ".height", componentEvent.getComponent().getHeight());
            }
        });
    }

    public static void installPalettePrefsHandler(Preferences preferences, String string, Window window) {
        PreferencesUtil.installPalettePrefsHandler(preferences, string, window, 0);
    }

    public static void installPalettePrefsHandler(final Preferences preferences, final String string, Window window, int n) {
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = window.getToolkit().getScreenInsets(graphicsConfiguration);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        Dimension dimension = window.getPreferredSize();
        Rectangle rectangle2 = new Rectangle(preferences.getInt(string + ".x", n + rectangle.x), preferences.getInt(string + ".y", 0 + rectangle.y), dimension.width, dimension.height);
        if (!rectangle.contains(rectangle2)) {
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y;
        }
        window.setBounds(rectangle2);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                preferences.putInt(string + ".x", componentEvent.getComponent().getX());
                preferences.putInt(string + ".y", componentEvent.getComponent().getY());
            }
        });
    }

    public static void installInternalFramePrefsHandler(final Preferences preferences, final String string, JInternalFrame jInternalFrame, JDesktopPane jDesktopPane) {
        Rectangle rectangle = jDesktopPane.getBounds();
        rectangle.setLocation(0, 0);
        Insets insets = jDesktopPane.getInsets();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        Dimension dimension = jInternalFrame.getPreferredSize();
        Dimension dimension2 = jInternalFrame.getMinimumSize();
        Rectangle rectangle2 = new Rectangle(preferences.getInt(string + ".x", 0), preferences.getInt(string + ".y", 0), Math.max(dimension2.width, preferences.getInt(string + ".width", dimension.width)), Math.max(dimension2.height, preferences.getInt(string + ".height", dimension.height)));
        if (!rectangle.contains(rectangle2)) {
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            Rectangle.intersect(rectangle, rectangle2, rectangle2);
        }
        jInternalFrame.setBounds(rectangle2);
        jInternalFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                preferences.putInt(string + ".x", componentEvent.getComponent().getX());
                preferences.putInt(string + ".y", componentEvent.getComponent().getY());
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                preferences.putInt(string + ".width", componentEvent.getComponent().getWidth());
                preferences.putInt(string + ".height", componentEvent.getComponent().getHeight());
            }
        });
    }

    public static void installToolBarPrefsHandler(Preferences preferences, String string, JToolBar jToolBar) {
        new ToolBarPrefsHandler(jToolBar, string, preferences);
    }

    public static void installTabbedPanePrefsHandler(final Preferences preferences, final String string, final JTabbedPane jTabbedPane) {
        int n = preferences.getInt(string, 0);
        try {
            jTabbedPane.setSelectedIndex(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                preferences.putInt(string, jTabbedPane.getSelectedIndex());
            }
        });
    }
}

