/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DirectoryEmptyStrings;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileNotFoundStrings;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.MLSXEntryParser;
import com.enterprisedt.net.ftp.TransferCompleteStrings;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class FTPClient
implements FTPClientInterface {
    public static String cvsId = "@(#)$Id: FTPClient.java,v 1.66 2007/01/15 23:05:14 bruceb Exp $";
    private static final int DEFAULT_MONITOR_INTERVAL = 65535;
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int MAX_PORT = 65535;
    private static final int SHORT_TIMEOUT = 500;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final String SOCKS_PORT = "socksProxyPort";
    private static final String SOCKS_HOST = "socksProxyHost";
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte LINE_FEED = 10;
    private static final String STOU_FILENAME_MARKER = "FILE:";
    private static Logger log = Logger.getLogger("FTPClient");
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected FTPControlSocket control;
    protected FTPDataSocket data;
    protected int timeout;
    protected int serverWakeupInterval;
    protected InetAddress remoteAddr;
    protected String remoteHost;
    protected String id;
    protected int controlPort = 21;
    private boolean autoPassiveIPSubstitution = false;
    protected String controlEncoding = "US-ASCII";
    private boolean strictReturnCodes = true;
    protected DirectoryEmptyStrings dirEmptyStrings = new DirectoryEmptyStrings();
    protected TransferCompleteStrings transferCompleteStrings = new TransferCompleteStrings();
    protected FileNotFoundStrings fileNotFoundStrings = new FileNotFoundStrings();
    private boolean cancelTransfer = false;
    private boolean resume = false;
    private boolean mdtmSupported = true;
    private boolean sizeSupported = true;
    private long resumeMarker;
    private boolean detectTransferMode = false;
    private long monitorInterval = 65535L;
    private int transferBufferSize = 16384;
    private FTPFileFactory fileFactory;
    private Locale listingLocale = Locale.getDefault();
    private MLSXEntryParser mlsxParser = new MLSXEntryParser();
    private FTPProgressMonitor monitor;
    protected FTPMessageListener messageListener;
    private FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;
    protected FTPReply lastValidReply;

    public static int[] getVersion() {
        return VersionDetails.getVersion();
    }

    public static String getBuildTimestamp() {
        return VersionDetails.getBuildTimestamp();
    }

    public FTPClient(String remoteHost) throws IOException, FTPException {
        this(remoteHost, 21, 0);
    }

    public FTPClient(String remoteHost, int controlPort) throws IOException, FTPException {
        this(remoteHost, controlPort, 0);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout, encoding);
    }

    public FTPClient(InetAddress remoteAddr) throws IOException, FTPException {
        this(remoteAddr, 21, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this(remoteAddr, controlPort, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout) throws IOException, FTPException {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, DEFAULT_ENCODING, null));
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, encoding, null));
    }

    public FTPClient() {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        log.debug(VersionDetails.report(this));
    }

    public void connect() throws IOException, FTPException {
        this.checkConnection(false);
        log.debug("Connecting to " + this.remoteAddr + ":" + this.controlPort);
        this.initialize(new FTPControlSocket(this.remoteAddr, this.controlPort, this.timeout, this.controlEncoding, this.messageListener));
    }

    public boolean connected() {
        return this.control != null;
    }

    protected void checkConnection(boolean shouldBeConnected) throws FTPException {
        if (shouldBeConnected && !this.connected()) {
            throw new FTPException("The FTP client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!shouldBeConnected && this.connected()) {
            throw new FTPException("The FTP client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    protected void initialize(FTPControlSocket control) throws IOException {
        this.control = control;
        control.setMessageListener(this.messageListener);
        control.setStrictReturnCodes(this.strictReturnCodes);
        control.setTimeout(this.timeout);
        control.setAutoPassiveIPSubstitution(this.autoPassiveIPSubstitution);
    }

    public void debugResponses(boolean on) {
        if (on) {
            Logger.setLevel(Level.DEBUG);
        } else {
            Logger.setLevel(Level.OFF);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStrictReturnCodes(boolean strict) {
        this.strictReturnCodes = strict;
        if (this.control != null) {
            this.control.setStrictReturnCodes(strict);
        }
    }

    public boolean isStrictReturnCodes() {
        return this.strictReturnCodes;
    }

    public void setDetectTransferMode(boolean detectTransferMode) {
        this.detectTransferMode = detectTransferMode;
    }

    public boolean getDetectTransferMode() {
        return this.detectTransferMode;
    }

    private void chooseTransferMode(String filename) {
        if (filename == null) {
            log.warn("Cannot choose transfer mode as filename not supplied");
            return;
        }
        if (this.detectTransferMode) {
            if (FileTypes.ASCII.matches(filename) && this.transferType.equals(FTPTransferType.BINARY)) {
                this.transferType = FTPTransferType.ASCII;
                log.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(filename) && this.transferType.equals(FTPTransferType.ASCII)) {
                this.transferType = FTPTransferType.BINARY;
                log.debug("Autodetect on - changed transfer type to binary");
            }
        }
    }

    public void setTimeout(int millis) throws IOException {
        this.timeout = millis;
        if (this.control != null) {
            this.control.setTimeout(millis);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRemotePort() {
        return this.controlPort;
    }

    public void setRemotePort(int remotePort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = remotePort;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(int controlPort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = controlPort;
    }

    public InetAddress getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(InetAddress remoteAddr) throws FTPException {
        this.checkConnection(false);
        this.remoteAddr = remoteAddr;
        this.remoteHost = remoteAddr.getHostName();
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) throws IOException, FTPException {
        this.checkConnection(false);
        this.remoteHost = remoteHost;
        this.remoteAddr = InetAddress.getByName(remoteHost);
    }

    public boolean isAutoPassiveIPSubstitution() {
        return this.autoPassiveIPSubstitution;
    }

    public void setAutoPassiveIPSubstitution(boolean autoPassiveIPSubstitution) {
        this.autoPassiveIPSubstitution = autoPassiveIPSubstitution;
        if (this.control != null) {
            this.control.setAutoPassiveIPSubstitution(autoPassiveIPSubstitution);
        }
    }

    public int getServerWakeupInterval() {
        return this.serverWakeupInterval;
    }

    public void setServerWakeupInterval(int interval) {
        this.serverWakeupInterval = interval;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.checkConnection(false);
        this.controlEncoding = controlEncoding;
    }

    public FTPMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(FTPMessageListener listener) {
        this.messageListener = listener;
        if (this.control != null) {
            this.control.setMessageListener(listener);
        }
    }

    public void setConnectMode(FTPConnectMode mode) {
        this.connectMode = mode;
    }

    public FTPConnectMode getConnectMode() {
        return this.connectMode;
    }

    public void setProgressMonitor(FTPProgressMonitor monitor, long interval) {
        this.monitor = monitor;
        this.monitorInterval = interval;
    }

    public void setProgressMonitor(FTPProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setTransferBufferSize(int size) {
        this.transferBufferSize = size;
    }

    public int getTransferBufferSize() {
        return this.transferBufferSize;
    }

    public void cancelTransfer() {
        this.cancelTransfer = true;
        log.warn("cancelTransfer() called");
    }

    public void setPORTIP(String IPAddress) throws FTPException {
        this.setActiveIPAddress(IPAddress);
    }

    public void setActiveIPAddress(String forcedActiveIP) throws FTPException {
        this.checkConnection(true);
        this.control.setActivePortIPAddress(forcedActiveIP);
    }

    public void setActivePortRange(int lowest, int highest) throws FTPException {
        this.checkConnection(true);
        if (lowest < 0 || lowest > highest || highest > 65535) {
            throw new FTPException("Invalid port range specified");
        }
        this.control.setActivePortRange(lowest, highest);
        log.debug("setActivePortRange(" + lowest + "," + highest + ")");
    }

    public void login(String user, String password) throws IOException, FTPException {
        this.checkConnection(true);
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230")) {
            return;
        }
        this.password(password);
    }

    public void login(String user, String password, String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230")) {
            return;
        }
        this.password(password);
        if (this.lastValidReply.getReplyCode().equals("332")) {
            this.account(accountInfo);
        }
    }

    public void user(String user) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "331"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void password(String password) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("PASS " + password);
        String[] validCodes = new String[]{"230", "202", "332"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void account(String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("ACCT " + accountInfo);
        String[] validCodes = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public static void initSOCKS(String port, String host) {
        Properties props = System.getProperties();
        ((Hashtable)props).put(SOCKS_PORT, port);
        ((Hashtable)props).put(SOCKS_HOST, host);
        System.setProperties(props);
    }

    public static void initSOCKSAuthentication(String username, String password) {
        Properties props = System.getProperties();
        ((Hashtable)props).put("java.net.socks.username", username);
        ((Hashtable)props).put("java.net.socks.password", password);
        System.setProperties(props);
    }

    public static void clearSOCKS() {
        Properties prop = System.getProperties();
        ((Hashtable)prop).remove(SOCKS_HOST);
        ((Hashtable)prop).remove(SOCKS_PORT);
        System.setProperties(prop);
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public String quote(String command, String[] validCodes) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand(command);
        this.lastValidReply = validCodes != null ? this.control.validateReply(reply, validCodes) : reply;
        return this.lastValidReply.getReplyText();
    }

    public boolean exists(String remoteFile) throws IOException, FTPException {
        char ch;
        FTPReply reply;
        this.checkConnection(true);
        if (this.sizeSupported) {
            reply = this.control.sendCommand("SIZE " + remoteFile);
            ch = reply.getReplyCode().charAt(0);
            if (ch == '2') {
                return true;
            }
            if (ch == '5' && this.fileNotFoundStrings.matches(reply.getReplyText())) {
                return false;
            }
            this.sizeSupported = false;
            log.debug("SIZE not supported - trying MDTM");
        }
        if (this.mdtmSupported) {
            reply = this.control.sendCommand("MDTM " + remoteFile);
            ch = reply.getReplyCode().charAt(0);
            if (ch == '2') {
                return true;
            }
            if (ch == '5' && this.fileNotFoundStrings.matches(reply.getReplyText())) {
                return false;
            }
            this.mdtmSupported = false;
            log.debug("MDTM not supported - trying RETR");
        }
        ServerSocket sock = new ServerSocket(0);
        short port = (short)sock.getLocalPort();
        sock.close();
        this.control.sendPORTCommand(port);
        FTPReply reply2 = this.control.sendCommand("RETR " + remoteFile);
        char ch2 = reply2.getReplyCode().charAt(0);
        if (ch2 == '1' || ch2 == '2' || ch2 == '4') {
            return true;
        }
        if (ch2 == '5' && this.fileNotFoundStrings.matches(reply2.getReplyText())) {
            return false;
        }
        String msg = "Unable to determine if file '" + remoteFile + "' exists.";
        log.warn(msg);
        throw new FTPException(msg);
    }

    public long size(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("SIZE " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, "213");
        String replyText = this.lastValidReply.getReplyText();
        int spacePos = replyText.indexOf(32);
        if (spacePos >= 0) {
            replyText = replyText.substring(0, spacePos);
        }
        try {
            return Long.parseLong(replyText);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FTPException("Failed to parse reply: " + replyText);
        }
    }

    public void resume() throws FTPException {
        if (this.transferType.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.resume = true;
        log.info("Resume=true");
    }

    public void cancelResume() throws IOException, FTPException {
        this.restart(0L);
        this.resume = false;
    }

    public void restart(long size) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("REST " + size);
        this.lastValidReply = this.control.validateReply(reply, "350");
    }

    public String put(String localPath, String remoteFile) throws IOException, FTPException {
        return this.put(localPath, remoteFile, false);
    }

    public String put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        return this.put(srcStream, remoteFile, false);
    }

    public String put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        FileInputStream srcStream = new FileInputStream(localPath);
        return this.put(srcStream, remoteFile, append);
    }

    public String put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            try {
                remoteFile = this.putData(srcStream, remoteFile, append);
                this.validateTransfer();
            }
            catch (IOException ex) {
                this.validateTransferOnError();
                throw ex;
            }
            Object var6_6 = null;
            this.transferType = currentType;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.transferType = currentType;
            throw throwable;
        }
        return remoteFile;
    }

    public void validateTransfer() throws IOException, FTPException {
        this.checkConnection(true);
        String[] validCodes = new String[]{"225", "226", "250", "426", "450"};
        FTPReply reply = this.control.readReply();
        String code = reply.getReplyCode();
        if ((code.equals("426") || code.equals("450")) && !this.cancelTransfer) {
            throw new FTPException(reply);
        }
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    private void validateTransferOnError() throws IOException, FTPException {
        this.checkConnection(true);
        this.control.setTimeout(500);
        try {
            this.validateTransfer();
        }
        finally {
            Object var2_1 = null;
            this.control.setTimeout(this.timeout);
        }
    }

    private void closeDataSocket() {
        block2: {
            if (this.data == null) break block2;
            try {
                this.data.close();
                this.data = null;
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
    }

    private void closeDataSocket(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
        this.closeDataSocket();
    }

    private void closeDataSocket(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
        this.closeDataSocket();
    }

    protected void setupDataSocket() throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
    }

    private String initPut(String remoteFile, boolean append) throws IOException, FTPException {
        boolean storeUnique;
        this.checkConnection(true);
        boolean bl = storeUnique = remoteFile == null || remoteFile.length() == 0;
        if (storeUnique) {
            remoteFile = "";
            if (append) {
                String msg = "A remote filename must be supplied when appending";
                log.error(msg);
                throw new FTPException(msg);
            }
        }
        this.cancelTransfer = false;
        boolean close = false;
        try {
            try {
                this.setupDataSocket();
                if (this.resume) {
                    if (this.transferType.equals(FTPTransferType.ASCII)) {
                        throw new FTPException("Resume only supported for BINARY transfers");
                    }
                    this.resumeMarker = this.size(remoteFile);
                    this.restart(this.resumeMarker);
                }
                String cmd = append ? "APPE " : (storeUnique ? "STOU" : "STOR ");
                FTPReply reply = this.control.sendCommand(String.valueOf(cmd) + remoteFile);
                String[] validCodes = new String[]{"125", "150", "350"};
                this.lastValidReply = this.control.validateReply(reply, validCodes);
                String replyText = this.lastValidReply.getReplyText();
                if (storeUnique) {
                    int pos = replyText.indexOf(STOU_FILENAME_MARKER);
                    if (pos >= 0) {
                        remoteFile = replyText.substring(pos += STOU_FILENAME_MARKER.length()).trim();
                    } else {
                        log.debug("Could not find FILE: in reply - using last word instead.");
                        pos = replyText.lastIndexOf(32);
                        remoteFile = replyText.substring(++pos);
                        int len = remoteFile.length();
                        if (len > 0 && remoteFile.charAt(len - 1) == '.') {
                            remoteFile = remoteFile.substring(0, len - 1);
                        }
                    }
                }
                String string = remoteFile;
                Object var7_15 = null;
                if (close) {
                    this.resume = false;
                    this.closeDataSocket();
                }
                return string;
            }
            catch (IOException ex) {
                close = true;
                throw ex;
            }
            catch (FTPException ex) {
                close = true;
                throw ex;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var7_16 = null;
                if (!close) break block14;
                this.resume = false;
                this.closeDataSocket();
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String putData(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        in = null;
        out = null;
        size = 0L;
        try {
            in = new BufferedInputStream(srcStream);
            remoteFile = this.initPut(remoteFile, append);
            out = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()), this.transferBufferSize * 2);
            if (this.resume) {
                in.skip(this.resumeMarker);
            }
            buf = new byte[this.transferBufferSize];
            prevBuf = null;
            monitorCount = 0L;
            count = 0;
            isASCII = this.getType() == FTPTransferType.ASCII;
            separatorPos = 0;
            start = System.currentTimeMillis();
            if (true) ** GOTO lbl74
            do {
                if (isASCII) {
                    i = 0;
                    while (i < count) {
                        found = true;
                        skip = 0;
                        while (separatorPos < FTPClient.LINE_SEPARATOR.length && i + separatorPos < count) {
                            if (buf[i + separatorPos] != FTPClient.LINE_SEPARATOR[separatorPos]) {
                                found = false;
                                break;
                            }
                            ++skip;
                            ++separatorPos;
                        }
                        if (found) {
                            if (separatorPos == FTPClient.LINE_SEPARATOR.length) {
                                out.write(13);
                                out.write(10);
                                size += 2L;
                                monitorCount += 2L;
                                separatorPos = 0;
                                i += skip - 1;
                                prevBuf = null;
                            } else {
                                prevBuf = new byte[skip];
                                k = 0;
                                while (k < skip) {
                                    prevBuf[k] = buf[i + k];
                                    ++k;
                                }
                            }
                        } else {
                            if (prevBuf != null) {
                                out.write(prevBuf);
                                size += (long)prevBuf.length;
                                monitorCount += (long)prevBuf.length;
                                prevBuf = null;
                            }
                            out.write(buf[i]);
                            ++size;
                            ++monitorCount;
                            separatorPos = 0;
                        }
                        ++i;
                    }
                } else {
                    out.write(buf, 0, count);
                    size += (long)count;
                    monitorCount += (long)count;
                }
                if (prevBuf != null) {
                    out.write(prevBuf);
                    size += (long)prevBuf.length;
                    monitorCount += (long)prevBuf.length;
                }
                if (this.monitor != null && monitorCount > this.monitorInterval) {
                    this.monitor.bytesTransferred(size);
                    monitorCount = 0L;
                }
                if (this.serverWakeupInterval > 0 && System.currentTimeMillis() - start > (long)(this.serverWakeupInterval * 1000)) {
                    start = System.currentTimeMillis();
                    this.sendServerWakeup();
                }
lbl74:
                // 4 sources

                count = in.read(buf);
                if (count <= 0) break;
            } while (!this.cancelTransfer);
        }
        catch (Throwable var8_21) {
            var9_20 = null;
            this.resume = false;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                FTPClient.log.warn("Caught exception closing input stream", ex);
            }
            this.closeDataSocket(out);
            if (this.monitor != null) {
                this.monitor.bytesTransferred(size);
            }
            FTPClient.log.debug("Transferred " + size + " bytes to remote host");
            throw var8_21;
        }
        var9_19 = null;
        this.resume = false;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ex) {
            FTPClient.log.warn("Caught exception closing input stream", ex);
        }
        this.closeDataSocket(out);
        if (this.monitor != null) {
            this.monitor.bytesTransferred(size);
        }
        FTPClient.log.debug("Transferred " + size + " bytes to remote host");
        return remoteFile;
    }

    public String put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        return this.put(bytes, remoteFile, false);
    }

    public String put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            String string = this.put(input, remoteFile, append);
            Object var7_7 = null;
            this.transferType = currentType;
            return string;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.transferType = currentType;
            throw throwable;
        }
    }

    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            try {
                this.getData(localPath, remoteFile);
                this.validateTransfer();
            }
            catch (IOException ex) {
                this.validateTransferOnError();
                throw ex;
            }
            Object var5_5 = null;
            this.transferType = currentType;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.transferType = currentType;
            throw throwable;
        }
    }

    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            try {
                this.getData(destStream, remoteFile);
                this.validateTransfer();
            }
            catch (IOException ex) {
                this.validateTransferOnError();
                throw ex;
            }
            Object var5_5 = null;
            this.transferType = currentType;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.transferType = currentType;
            throw throwable;
        }
    }

    private void initGet(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.cancelTransfer = false;
        boolean close = false;
        try {
            try {
                this.setupDataSocket();
                if (this.resume) {
                    if (this.transferType.equals(FTPTransferType.ASCII)) {
                        throw new FTPException("Resume only supported for BINARY transfers");
                    }
                    this.restart(this.resumeMarker);
                }
                FTPReply reply = this.control.sendCommand("RETR " + remoteFile);
                String[] validCodes1 = new String[]{"125", "150"};
                this.lastValidReply = this.control.validateReply(reply, validCodes1);
            }
            catch (IOException ex) {
                close = true;
                throw ex;
            }
            catch (FTPException ex) {
                close = true;
                throw ex;
            }
            Object var4_7 = null;
            if (close) {
                this.resume = false;
                this.closeDataSocket();
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (close) {
                this.resume = false;
                this.closeDataSocket();
            }
            throw throwable;
        }
    }

    private void getData(String localPath, String remoteFile) throws IOException, FTPException {
        File localFile = new File(localPath);
        if (localFile.exists()) {
            if (!localFile.canWrite()) {
                throw new FTPException(String.valueOf(localPath) + " is readonly - cannot write");
            }
            if (this.resume) {
                this.resumeMarker = localFile.length();
            }
        }
        this.initGet(remoteFile);
        FileOutputStream out = new FileOutputStream(localPath, this.resume);
        try {
            this.getDataAfterInitGet(out);
        }
        catch (IOException ex) {
            localFile.delete();
            log.debug("Deleting local file '" + localFile.getAbsolutePath() + "'");
            throw ex;
        }
    }

    private void getData(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        this.initGet(remoteFile);
        this.getDataAfterInitGet(destStream);
    }

    private void getDataAfterInitGet(OutputStream destStream) throws IOException, FTPException {
        BufferedOutputStream out = new BufferedOutputStream(destStream);
        BufferedInputStream in = null;
        long size = 0L;
        IOException storedEx = null;
        try {
            try {
                int count;
                in = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
                long monitorCount = 0L;
                byte[] chunk = new byte[this.transferBufferSize];
                boolean isASCII = this.getType() == FTPTransferType.ASCII;
                boolean crFound = false;
                long start = System.currentTimeMillis();
                while ((count = this.readChunk(in, chunk, this.transferBufferSize)) >= 0 && !this.cancelTransfer) {
                    if (isASCII) {
                        boolean lfFound = false;
                        int i = 0;
                        while (i < count) {
                            boolean bl = lfFound = chunk[i] == 10;
                            if (crFound) {
                                if (lfFound) {
                                    out.write(LINE_SEPARATOR, 0, LINE_SEPARATOR.length);
                                    size += (long)LINE_SEPARATOR.length;
                                    monitorCount += (long)LINE_SEPARATOR.length;
                                } else {
                                    out.write(13);
                                    ++size;
                                    ++monitorCount;
                                }
                            }
                            boolean bl2 = crFound = chunk[i] == 13;
                            if (!lfFound && !crFound) {
                                out.write(chunk[i]);
                                ++size;
                                ++monitorCount;
                            }
                            ++i;
                        }
                    } else {
                        out.write(chunk, 0, count);
                        size += (long)count;
                        monitorCount += (long)count;
                    }
                    if (this.monitor != null && monitorCount > this.monitorInterval) {
                        this.monitor.bytesTransferred(size);
                        monitorCount = 0L;
                    }
                    if (this.serverWakeupInterval <= 0 || System.currentTimeMillis() - start <= (long)(this.serverWakeupInterval * 1000)) continue;
                    start = System.currentTimeMillis();
                    this.sendServerWakeup();
                }
                if (isASCII && crFound) {
                    out.write(13);
                    ++size;
                    ++monitorCount;
                }
            }
            catch (IOException ex) {
                storedEx = ex;
            }
            Object var8_17 = null;
        }
        catch (Throwable throwable) {
            Object var8_18 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                log.warn("Caught exception closing output stream", ex);
            }
            this.resume = false;
            this.closeDataSocket(in);
            if (storedEx != null) {
                throw storedEx;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(size);
            }
            log.debug("Transferred " + size + " bytes from remote host");
            throw throwable;
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ex) {
            log.warn("Caught exception closing output stream", ex);
        }
        this.resume = false;
        this.closeDataSocket(in);
        if (storedEx != null) {
            throw storedEx;
        }
        if (this.monitor != null) {
            this.monitor.bytesTransferred(size);
        }
        log.debug("Transferred " + size + " bytes from remote host");
    }

    public byte[] get(String remoteFile) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            try {
                ByteArrayOutputStream result = new ByteArrayOutputStream(this.transferBufferSize);
                this.getData(result, remoteFile);
                this.validateTransfer();
                byte[] byArray = result == null ? null : result.toByteArray();
                Object var5_6 = null;
                this.transferType = currentType;
                return byArray;
            }
            catch (IOException ex) {
                this.validateTransferOnError();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.transferType = currentType;
            throw throwable;
        }
    }

    public boolean site(String command) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("SITE " + command);
        String[] validCodes = new String[]{"200", "202", "502"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return reply.getReplyCode().equals("200");
    }

    public String list(String dirname) throws IOException, FTPException {
        return this.list(dirname, false);
    }

    public String list(String dirname, boolean full) throws IOException, FTPException {
        String[] list = this.dir(dirname, full);
        StringBuffer result = new StringBuffer();
        String sep = System.getProperty("line.separator");
        int i = 0;
        while (i < list.length) {
            result.append(list[i]);
            result.append(sep);
            ++i;
        }
        return result.toString();
    }

    public void setFTPFileFactory(FTPFileFactory fileFactory) {
        this.fileFactory = fileFactory;
    }

    public void setParserLocale(Locale locale) {
        this.listingLocale = locale;
    }

    public FTPFile fileDetails(String name) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("MLST " + name);
        this.lastValidReply = this.control.validateReply(reply, "250");
        if (reply.getReplyData() != null) {
            return this.mlsxParser.parse(reply.getReplyData()[0]);
        }
        log.warn("No file data returned from MLST");
        return null;
    }

    public FTPFile[] dirDetails(String dirname) throws IOException, FTPException, ParseException {
        if (this.fileFactory == null) {
            this.fileFactory = new FTPFileFactory(this.system());
        }
        this.fileFactory.setLocale(this.listingLocale);
        return this.fileFactory.parse(this.dir(dirname, true));
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(null, false);
    }

    public String[] dir(String dirname) throws IOException, FTPException {
        return this.dir(dirname, false);
    }

    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        this.checkConnection(true);
        try {
            String command;
            this.setupDataSocket();
            String string = command = full ? "LIST " : "NLST ";
            if (dirname != null) {
                command = String.valueOf(command) + dirname;
            }
            command = command.trim();
            FTPReply reply = this.control.sendCommand(command);
            String[] validCodes1 = new String[]{"125", "150", "226", "450", "550"};
            this.lastValidReply = this.control.validateReply(reply, validCodes1);
            Object[] result = new String[]{};
            String replyCode = this.lastValidReply.getReplyCode();
            if (!(replyCode.equals("450") || replyCode.equals("550") || replyCode.equals("226"))) {
                BufferedReader in = null;
                Vector<String> lines = new Vector<String>();
                try {
                    in = new LineNumberReader(new InputStreamReader(this.data.getInputStream(), this.controlEncoding));
                    String line = null;
                    while ((line = this.readLine((LineNumberReader)in)) != null) {
                        lines.addElement(line);
                        log.log(Level.ALL, line, null);
                    }
                }
                finally {
                    Object var14_13 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        log.error("Failed to close socket in dir()", ex);
                    }
                    this.closeDataSocket();
                }
                String[] validCodes2 = new String[]{"226", "250"};
                reply = this.control.readReply();
                this.lastValidReply = this.control.validateReply(reply, validCodes2);
                if (!lines.isEmpty()) {
                    result = new String[lines.size()];
                    lines.copyInto(result);
                }
            } else {
                String replyText = this.lastValidReply.getReplyText().toUpperCase();
                if (!this.dirEmptyStrings.matches(replyText) && !this.transferCompleteStrings.matches(replyText)) {
                    throw new FTPException(reply);
                }
            }
            Object[] objectArray = result;
            Object var5_18 = null;
            this.closeDataSocket();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var5_19 = null;
            this.closeDataSocket();
            throw throwable;
        }
    }

    protected int readChunk(BufferedInputStream in, byte[] chunk, int chunksize) throws IOException {
        return in.read(chunk, 0, chunksize);
    }

    protected int readChar(LineNumberReader in) throws IOException {
        return in.read();
    }

    protected String readLine(LineNumberReader in) throws IOException {
        return in.readLine();
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    public void setType(FTPTransferType type) throws IOException, FTPException {
        this.checkConnection(true);
        String typeStr = FTPTransferType.ASCII_CHAR;
        if (type.equals(FTPTransferType.BINARY)) {
            typeStr = FTPTransferType.BINARY_CHAR;
        }
        FTPReply reply = this.control.sendCommand("TYPE " + typeStr);
        this.lastValidReply = this.control.validateReply(reply, "200");
        this.transferType = type;
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        String[] validCodes = new String[]{"200", "250"};
        FTPReply reply = this.control.sendCommand("DELE " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void rename(String from, String to) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("RNFR " + from);
        this.lastValidReply = this.control.validateReply(reply, "350");
        reply = this.control.sendCommand("RNTO " + to);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public void rmdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("RMD " + dir);
        String[] validCodes = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void mkdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("MKD " + dir);
        String[] validCodes = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void chdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("CWD " + dir);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public void cdup() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("CDUP");
        String[] validCodes = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public Date modtime(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("MDTM " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, "213");
        Date ts = this.tsFormat.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return ts;
    }

    public String pwd() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(reply, "257");
        String text = this.lastValidReply.getReplyText();
        int start = text.indexOf(34);
        int end = text.lastIndexOf(34);
        if (start >= 0 && end > start) {
            return text.substring(start + 1, end);
        }
        return text;
    }

    public String[] features() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("FEAT");
        String[] validCodes = new String[]{"211", "500", "502"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        if (this.lastValidReply.getReplyCode().equals("211")) {
            return this.lastValidReply.getReplyData();
        }
        throw new FTPException(reply);
    }

    public String system() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("SYST");
        String[] validCodes = new String[]{"200", "213", "215"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    public void noOperation() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("NOOP");
        this.lastValidReply = this.control.validateReply(reply, "200");
    }

    public String stat() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("STAT");
        String[] validCodes = new String[]{"211", "212", "213"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    public void sendServerWakeup() throws IOException, FTPException {
        this.noOperation();
    }

    public String help(String command) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("HELP " + command);
        String[] validCodes = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    protected void abort() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("ABOR");
        String[] validCodes = new String[]{"426", "226"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void quit() throws IOException, FTPException {
        this.checkConnection(true);
        try {
            FTPReply reply = this.control.sendCommand("QUIT");
            String[] validCodes = new String[]{"221", "226"};
            this.lastValidReply = this.control.validateReply(reply, validCodes);
        }
        finally {
            Object var2_3 = null;
            this.control.logout();
            this.control = null;
        }
    }

    public void quitImmediately() throws IOException, FTPException {
        this.checkConnection(true);
        this.cancelTransfer();
        this.control.controlSock.close();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        result.append("FTP").append(",").append(this.remoteHost).append(",").append(this.controlPort).append(",").append(this.getId()).append("]");
        return result.toString();
    }
}

