/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.rememberme;

import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.security.Authentication;
import org.springframework.security.ui.rememberme.AbstractRememberMeServices;
import org.springframework.security.ui.rememberme.InvalidCookieException;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.util.StringUtils;

public class TokenBasedRememberMeServices
extends AbstractRememberMeServices {
    public UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        long tokenExpiryTime;
        if (cookieTokens.length != 3) {
            throw new InvalidCookieException("Cookie token did not contain 2 tokens, but contained '" + Arrays.asList(cookieTokens) + "'");
        }
        try {
            tokenExpiryTime = new Long(cookieTokens[1]);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidCookieException("Cookie token[1] did not contain a valid number (contained '" + cookieTokens[1] + "')");
        }
        if (this.isTokenExpired(tokenExpiryTime)) {
            throw new InvalidCookieException("Cookie token[1] has expired (expired on '" + new Date(tokenExpiryTime) + "'; current time is '" + new Date() + "')");
        }
        UserDetails userDetails = this.getUserDetailsService().loadUserByUsername(cookieTokens[0]);
        String expectedTokenSignature = this.makeTokenSignature(tokenExpiryTime, userDetails.getUsername(), userDetails.getPassword());
        if (!expectedTokenSignature.equals(cookieTokens[2])) {
            throw new InvalidCookieException("Cookie token[2] contained signature '" + cookieTokens[2] + "' but expected '" + expectedTokenSignature + "'");
        }
        return userDetails;
    }

    protected String makeTokenSignature(long tokenExpiryTime, String username, String password) {
        return DigestUtils.md5Hex((String)(username + ":" + tokenExpiryTime + ":" + password + ":" + this.getKey()));
    }

    protected boolean isTokenExpired(long tokenExpiryTime) {
        return tokenExpiryTime < System.currentTimeMillis();
    }

    public void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        String username = this.retrieveUserName(successfulAuthentication);
        String password = this.retrievePassword(successfulAuthentication);
        if (!StringUtils.hasLength((String)username) || !StringUtils.hasLength((String)password)) {
            return;
        }
        int tokenLifetime = this.calculateLoginLifetime(request, successfulAuthentication);
        long expiryTime = System.currentTimeMillis() + 1000L * (long)tokenLifetime;
        String signatureValue = this.makeTokenSignature(expiryTime, username, password);
        this.setCookie(new String[]{username, Long.toString(expiryTime), signatureValue}, tokenLifetime, request, response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added remember-me cookie for user '" + username + "', expiry: '" + new Date(expiryTime) + "'"));
        }
    }

    protected int calculateLoginLifetime(HttpServletRequest request, Authentication authentication) {
        return this.getTokenValiditySeconds();
    }

    protected String retrieveUserName(Authentication authentication) {
        if (this.isInstanceOfUserDetails(authentication)) {
            return ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return authentication.getPrincipal().toString();
    }

    protected String retrievePassword(Authentication authentication) {
        if (this.isInstanceOfUserDetails(authentication)) {
            return ((UserDetails)authentication.getPrincipal()).getPassword();
        }
        return authentication.getCredentials().toString();
    }

    private boolean isInstanceOfUserDetails(Authentication authentication) {
        return authentication.getPrincipal() instanceof UserDetails;
    }
}

