/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.function.Predicate;
import java.util.logging.Logger;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.CloseMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.Session;
import net.sf.freecol.server.model.TimedSession;

public class DiplomacySession
extends TimedSession {
    private static final Logger logger = Logger.getLogger(DiplomacySession.class.getName());
    private DiplomaticTrade agreement = null;
    private final Unit unit;
    private final Settlement settlement;
    private final Unit otherUnit;

    public DiplomacySession(Unit unit, Settlement settlement, long timeout) {
        super(DiplomacySession.makeDiplomacySessionKey(unit, settlement), timeout);
        this.unit = unit;
        this.settlement = settlement;
        this.otherUnit = null;
    }

    public DiplomacySession(Unit unit, Unit otherUnit, long timeout) {
        super(DiplomacySession.makeDiplomacySessionKey(unit, otherUnit), timeout);
        this.unit = unit;
        this.settlement = null;
        this.otherUnit = otherUnit;
    }

    public static String makeDiplomacySessionKey(Ownable o1, Ownable o2) {
        return DiplomacySession.makeSessionKey(DiplomacySession.class, o1.getOwner(), o2.getOwner());
    }

    private ServerGame getGame() {
        return (ServerGame)this.unit.getGame();
    }

    public DiplomaticTrade getAgreement() {
        return this.agreement;
    }

    public void setAgreement(DiplomaticTrade agreement) {
        this.agreement = agreement;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public Unit getOtherUnit() {
        return this.otherUnit;
    }

    private ServerPlayer getOwner() {
        return (ServerPlayer)this.unit.getOwner();
    }

    private ServerPlayer getOtherPlayer() {
        return (ServerPlayer)(this.settlement != null ? this.settlement.getOwner() : this.otherUnit.getOwner());
    }

    public ServerPlayer getOtherPlayer(ServerPlayer serverPlayer) {
        ServerPlayer other = this.getOwner();
        return other != serverPlayer ? other : this.getOtherPlayer();
    }

    public DiplomacyMessage getMessage(Player destination) {
        return destination.owns(this.unit) ? (this.otherUnit == null ? new DiplomacyMessage((FreeColGameObject)this.unit, this.settlement, this.agreement) : new DiplomacyMessage(this.unit, this.otherUnit, this.agreement)) : (this.otherUnit == null ? new DiplomacyMessage(this.settlement, (FreeColGameObject)this.unit, this.agreement) : new DiplomacyMessage(this.otherUnit, this.unit, this.agreement));
    }

    public boolean isCompatible(FreeColGameObject fcgo1, FreeColGameObject fcgo2) {
        return fcgo1 == this.unit && (fcgo2 == this.settlement || fcgo2 == this.otherUnit) || fcgo2 == this.unit && (fcgo1 == this.settlement || fcgo1 == this.otherUnit);
    }

    public static DiplomacySession findContactSession(Unit unit, Unit other) {
        return DiplomacySession.findContactSession(unit.getOwner(), other.getOwner());
    }

    public static DiplomacySession findContactSession(Unit unit, Settlement settlement) {
        return DiplomacySession.findContactSession(unit.getOwner(), settlement.getOwner());
    }

    private static DiplomacySession findContactSession(Player p1, Player p2) {
        Predicate<Session> pred = s -> s instanceof DiplomacySession && ((DiplomacySession)s).getAgreement() != null && ((DiplomacySession)s).getAgreement().getContext() == DiplomaticTrade.TradeContext.CONTACT && (((DiplomacySession)s).getOwner() == p1 && ((DiplomacySession)s).getOtherPlayer() == p2 || ((DiplomacySession)s).getOwner() == p2 && ((DiplomacySession)s).getOtherPlayer() == p1);
        return (DiplomacySession)DiplomacySession.findSession(pred);
    }

    private void completeInternal(boolean result, ChangeSet cs) {
        logger.info("Completing diplomacy session: " + this);
        if (this.agreement != null) {
            if (result) {
                result = this.getGame().csAcceptTrade(this.agreement, this.unit, this.settlement, cs);
            }
            this.agreement.setStatus(result ? DiplomaticTrade.TradeStatus.ACCEPT_TRADE : DiplomaticTrade.TradeStatus.REJECT_TRADE);
            Player sp = this.agreement.getSender();
            cs.add(ChangeSet.See.only(sp), this.getMessage(sp));
            Player rp = this.agreement.getRecipient();
            cs.add(ChangeSet.See.only(rp), this.getMessage(rp));
        }
        this.unit.setMovesLeft(0);
        cs.add(ChangeSet.See.only(this.getOwner()), this.unit);
    }

    public boolean completeFirstContact(ChangeSet cs) {
        return super.complete(cs);
    }

    public boolean complete(boolean result, ChangeSet cs) {
        boolean ret = super.complete(cs);
        if (!ret) {
            this.completeInternal(result, cs);
        }
        return ret;
    }

    @Override
    protected boolean complete(boolean result) {
        String dialogName = "net.sf.freecol.client.gui.dialog.NegotiationDialog";
        ChangeSet cs = new ChangeSet();
        boolean ret = this.complete(false, cs);
        if (!ret) {
            cs.add(ChangeSet.See.only(this.agreement.getSender()), new CloseMessage("net.sf.freecol.client.gui.dialog.NegotiationDialog"));
            cs.add(ChangeSet.See.only(this.agreement.getRecipient()), new CloseMessage("net.sf.freecol.client.gui.dialog.NegotiationDialog"));
        }
        this.getGame().sendToAll(cs);
        return ret;
    }

    @Override
    public boolean complete(ChangeSet cs) {
        return this.complete(false, cs);
    }
}

