/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.export;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aesh.command.export.ExportChangeListener;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.utils.Config;

public class ExportManager {
    private static final char DOLLAR = '$';
    private final Map<String, String> variables;
    private final Pattern exportPattern = Pattern.compile("^(export)\\s+(\\w+)\\s*=\\s*(\\S+).*$");
    private final Pattern variableDollarFirstPattern = Pattern.compile("\\$(\\w+|\\{(\\w+)\\})(.*)");
    private final Pattern variablePattern = Pattern.compile("(.*)\\$(\\w+|\\{(\\w+)\\})(.*)");
    private static final Logger LOGGER = LoggerUtil.getLogger(ExportManager.class.getName());
    private static final String EXPORT = "export";
    private final File exportFile;
    private final boolean exportUsesSystemEnvironment;
    private final ExportChangeListener listener;

    public ExportManager(File exportFile) {
        this(exportFile, false, null);
    }

    public ExportManager(File exportFile, ExportChangeListener listener) {
        this(exportFile, false, listener);
    }

    public ExportManager(File exportFile, boolean exportUsesSystemEnvironment) {
        this(exportFile, exportUsesSystemEnvironment, null);
    }

    public ExportManager(File exportFile, boolean exportUsesSystemEnvironment, ExportChangeListener listener) {
        this.exportFile = exportFile;
        this.exportUsesSystemEnvironment = exportUsesSystemEnvironment;
        this.variables = new HashMap<String, String>();
        if (exportFile.isFile()) {
            this.readVariablesFromFile();
        }
        this.listener = listener;
    }

    private void readVariablesFromFile() {
        try (BufferedReader br = new BufferedReader(new FileReader(this.exportFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(EXPORT)) continue;
                this.addVariable(line);
            }
        }
        catch (IOException e) {
            LOGGER.warning("Failed to read variables from file " + this.exportFile + ", error: " + e);
        }
    }

    public Set<String> keys() {
        return this.variables.keySet();
    }

    public String addVariable(String line) {
        Matcher variableMatcher = this.exportPattern.matcher(line);
        if (variableMatcher.matches()) {
            String name = variableMatcher.group(2);
            String value = variableMatcher.group(3);
            if (value.contains(String.valueOf('$' + name))) {
                value = value.replace(String.valueOf('$' + name), this.variables.get(name));
            }
            this.variables.put(name, value);
            if (this.listener != null) {
                this.listener.exportChange(name, value);
            }
            return null;
        }
        return "export: usage: export [name[=value] ...]";
    }

    public String getValue(String key) {
        if (key.indexOf(36) == -1) {
            String value = this.getVariable(key);
            if (value == null) {
                return null;
            }
            if (value.indexOf(36) == -1) {
                return value;
            }
            return this.parseValue(value);
        }
        return this.parseValue(key);
    }

    private String getVariable(String key) {
        if (this.variables.containsKey(key)) {
            return this.variables.get(key);
        }
        if (this.exportUsesSystemEnvironment) {
            return System.getenv().get(key);
        }
        return null;
    }

    private boolean containsKey(String key) {
        boolean result = false;
        result = this.variables.containsKey(key);
        if (!result && this.exportUsesSystemEnvironment) {
            result = System.getenv().containsKey(key);
        }
        return result;
    }

    public String getValueIgnoreCase(String name) {
        for (String key : this.variables.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            return this.variables.get(key);
        }
        if (this.exportUsesSystemEnvironment) {
            for (String key : System.getenv().keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                return System.getenv().get(key);
            }
        }
        return "";
    }

    private String parseValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.indexOf(36) == -1) {
            return value;
        }
        if (value.indexOf(36) == 0) {
            Matcher matcher = this.variableDollarFirstPattern.matcher(value);
            if (matcher.matches()) {
                String group1 = matcher.group(1);
                String group2 = matcher.group(3);
                if (matcher.group(2) != null) {
                    group1 = matcher.group(2);
                }
                if (group1 != null && this.containsKey(group1)) {
                    if (group2 != null && group2.indexOf(36) > -1) {
                        if (this.getVariable(group1).indexOf(36) == -1) {
                            return this.getVariable(group1) + this.parseValue(group2);
                        }
                        return this.parseValue(this.getVariable(group1)) + this.parseValue(group2);
                    }
                    if (this.getVariable(group1).indexOf(36) == -1) {
                        return this.getVariable(group1) + group2;
                    }
                    return this.parseValue(this.getVariable(group1)) + group2;
                }
                return group2;
            }
            return null;
        }
        Matcher matcher = this.variablePattern.matcher(value);
        if (matcher.matches()) {
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            String group3 = matcher.group(4);
            if (matcher.group(3) != null) {
                group2 = matcher.group(3);
            }
            if (group2 != null && this.containsKey(group2)) {
                if (group3 != null && group3.indexOf(36) > -1) {
                    if (this.getVariable(group2).indexOf(36) == -1) {
                        return this.parseValue(group1) + this.getVariable(group2) + this.parseValue(group3);
                    }
                    return this.parseValue(group1) + this.parseValue(this.getVariable(group2)) + this.parseValue(group3);
                }
                if (this.getVariable(group2).indexOf(36) == -1) {
                    return this.parseValue(group1) + this.getVariable(group2) + group3;
                }
                return this.parseValue(group1) + this.parseValue(this.getVariable(group2)) + group3;
            }
            return group1 + group3;
        }
        return null;
    }

    public String listAllVariables() {
        StringBuilder builder = new StringBuilder();
        for (String key : this.variables.keySet()) {
            builder.append(key).append('=').append(this.parseValue(this.variables.get(key))).append(Config.getLineSeparator());
        }
        if (this.exportUsesSystemEnvironment) {
            for (String key : System.getenv().keySet()) {
                builder.append(key).append('=').append(this.parseValue(this.variables.get(key))).append(Config.getLineSeparator());
            }
        }
        return builder.toString();
    }

    public void persistVariables() {
        boolean keepGoing = true;
        try {
            if (this.exportFile.isFile()) {
                keepGoing = this.exportFile.delete();
            }
            if (keepGoing) {
                File parentFile = this.exportFile.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                keepGoing = this.exportFile.createNewFile();
            }
            if (keepGoing) {
                FileWriter fw = new FileWriter(this.exportFile);
                for (String key : this.variables.keySet()) {
                    fw.write("export " + key + "=" + this.variables.get(key) + Config.getLineSeparator());
                }
                fw.flush();
                fw.close();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to persist variables to file " + this.exportFile, e);
        }
    }

    public List<String> getAllNamesWithEquals() {
        ArrayList<String> names = new ArrayList<String>(this.variables.size());
        for (String key : this.variables.keySet()) {
            names.add(key + "=");
        }
        if (this.exportUsesSystemEnvironment) {
            for (String key : System.getenv().keySet()) {
                names.add(key + "=");
            }
        }
        return names;
    }

    public List<String> getAllNames() {
        ArrayList<String> names = new ArrayList<String>(this.variables.size());
        for (String key : this.variables.keySet()) {
            names.add(key);
        }
        if (this.exportUsesSystemEnvironment) {
            for (String key : System.getenv().keySet()) {
                names.add(key);
            }
        }
        return names;
    }

    public List<String> findAllMatchingKeys(String word) {
        int index = word.lastIndexOf(36);
        if (index > -1) {
            word = word.substring(index + 1, word.length());
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.variables.keySet()) {
            if (!key.startsWith(word)) continue;
            if (index > -1) {
                keys.add("$" + key);
                continue;
            }
            keys.add(key);
        }
        if (this.exportUsesSystemEnvironment) {
            for (String key : System.getenv().keySet()) {
                if (!key.startsWith(word)) continue;
                if (index > -1) {
                    keys.add("$" + key);
                    continue;
                }
                keys.add(key);
            }
        }
        return keys;
    }
}

