/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.TeXConstants;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TeXFormulaParser {
    private static Map a = new HashMap();
    private final Map b = new HashMap();
    private final Map c = new HashMap();
    private final Map d = new HashMap();
    private final Map e = new HashMap();
    private Object a;
    private final String a;
    private final Element a;
    private int a = new Object();

    public TeXFormulaParser(String string, Element element, String string2) {
        this.a = string;
        this.a = element;
        int n = this.a = "Command".equals(string2) ? 0 : 1;
        if ("Command".equals(string2)) {
            this.c.put("CreateCommand", new CreateCommandParser());
        } else {
            this.c.put("CreateTeXFormula", new CreateTeXFormulaParser());
        }
        this.c.put("MethodInvocation", new MethodInvocationParser());
        this.c.put("Return", new ReturnParser());
        this.b.put("TeXConstants", new TeXConstantsValueParser());
        this.b.put("TeXFormula", new TeXFormulaValueParser());
        this.b.put("String", new StringValueParser());
        this.b.put("float", new FloatValueParser());
        this.b.put("int", new IntValueParser());
        this.b.put("boolean", new BooleanValueParser());
        this.b.put("char", new CharValueParser());
        this.b.put("ColorConstant", new ColorConstantValueParser());
    }

    public Object parse() {
        NodeList nodeList = this.a.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            ActionParser actionParser;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3 || (actionParser = (ActionParser)this.c.get((element = (Element)node).getTagName())) == null) continue;
            actionParser.parse(element);
        }
        return this.a;
    }

    private Object[] getArgumentValues(NodeList nodeList) {
        Object[] objectArray = new Object[nodeList.getLength()];
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", element);
            String string2 = element.getAttribute("value");
            objectArray[n] = ((ArgumentValueParser)this.b.get(string)).parseValue(string2, string);
            ++n;
        }
        return objectArray;
    }

    private static Class[] getArgumentClasses(NodeList nodeList) {
        Class[] classArray = new Class[nodeList.getLength()];
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", element);
            Object v = a.get(string);
            if (v == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "type", "has an invalid class name value!");
            }
            classArray[n] = (Class)v;
            ++n;
        }
        return classArray;
    }

    private static void checkNullValue(String string, String string2) {
        if (string.equals("")) {
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "is required for an argument of type '" + string2 + "'!");
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String string, Element element) {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", element.getTagName(), string, null);
        }
        return string2;
    }

    static {
        a.put("TeXConstants", Integer.TYPE);
        a.put("TeXFormula", TeXFormula.class);
        a.put("String", String.class);
        a.put("float", Float.TYPE);
        a.put("int", Integer.TYPE);
        a.put("boolean", Boolean.TYPE);
        a.put("char", Character.TYPE);
        a.put("ColorConstant", Color.class);
    }

    private static interface ActionParser {
        public void parse(Element var1);
    }

    private static interface ArgumentValueParser {
        public Object parseValue(String var1, String var2);
    }

    private class BooleanValueParser
    implements ArgumentValueParser {
        BooleanValueParser() {
        }

        public Object parseValue(String string, String string2) {
            TeXFormulaParser.checkNullValue(string, string2);
            if ("true".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string)) {
                return Boolean.FALSE;
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an invalid '" + string2 + "'-value : '" + string + "'!");
        }
    }

    private class CharValueParser
    implements ArgumentValueParser {
        CharValueParser() {
        }

        public Object parseValue(String string, String string2) {
            TeXFormulaParser.checkNullValue(string, string2);
            if (string.length() == 1) {
                return new Character(string.charAt(0));
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "must have a value that consists of exactly 1 character!");
        }
    }

    private class ColorConstantValueParser
    implements ArgumentValueParser {
        ColorConstantValueParser() {
        }

        public Object parseValue(String string, String string2) {
            TeXFormulaParser.checkNullValue(string, string2);
            try {
                return Color.class.getDeclaredField(string).get(null);
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an unknown color constant name as value : '" + string + "'!", exception);
            }
        }
    }

    private class CreateCommandParser
    implements ActionParser {
        CreateCommandParser() {
        }

        public void parse(Element element) {
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", element);
            NodeList nodeList = element.getElementsByTagName("Argument");
            Class[] classArray = TeXFormulaParser.getArgumentClasses(nodeList);
            Object[] objectArray = TeXFormulaParser.this.getArgumentValues(nodeList);
            try {
                MacroInfo macroInfo = (MacroInfo)MacroInfo.class.getConstructor(classArray).newInstance(objectArray);
                TeXFormulaParser.this.e.put(string, macroInfo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = "IllegalArgumentException:\n";
                string2 = string2 + "ClassLoader to load this class (TeXFormulaParser): " + this.getClass().getClassLoader() + "\n";
                for (Class object : classArray) {
                    string2 = string2 + "Created class: " + object + " loaded with the ClassLoader: " + object.getClassLoader() + "\n";
                }
                for (Object object : objectArray) {
                    string2 = string2 + "Created object: " + object + "\n";
                }
                throw new XMLResourceParseException("Error creating the temporary command '" + string + "' while constructing the predefined command '" + TeXFormulaParser.this.a + "'!\n" + string2);
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("Error creating the temporary command '" + string + "' while constructing the predefined command '" + TeXFormulaParser.this.a + "'!\n" + exception.toString());
            }
        }
    }

    private class CreateTeXFormulaParser
    implements ActionParser {
        CreateTeXFormulaParser() {
        }

        public void parse(Element element) {
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", element);
            NodeList nodeList = element.getElementsByTagName("Argument");
            Class[] classArray = TeXFormulaParser.getArgumentClasses(nodeList);
            Object[] objectArray = TeXFormulaParser.this.getArgumentValues(nodeList);
            try {
                TeXFormula teXFormula = (TeXFormula)TeXFormula.class.getConstructor(classArray).newInstance(objectArray);
                TeXFormulaParser.this.d.put(string, teXFormula);
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("Error creating the temporary TeXFormula '" + string + "' while constructing the predefined TeXFormula '" + TeXFormulaParser.this.a + "'!\n" + exception.toString());
            }
        }
    }

    private class FloatValueParser
    implements ArgumentValueParser {
        FloatValueParser() {
        }

        public Object parseValue(String string, String string2) {
            TeXFormulaParser.checkNullValue(string, string2);
            try {
                return new Float(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an invalid '" + string2 + "'-value : '" + string + "'!", numberFormatException);
            }
        }
    }

    private class IntValueParser
    implements ArgumentValueParser {
        IntValueParser() {
        }

        public Object parseValue(String string, String string2) {
            TeXFormulaParser.checkNullValue(string, string2);
            try {
                int n = Integer.parseInt(string);
                return new Float(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an invalid '" + string2 + "'-value : '" + string + "'!", numberFormatException);
            }
        }
    }

    private class MethodInvocationParser
    implements ActionParser {
        MethodInvocationParser() {
        }

        public void parse(Element element) {
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", element);
            String string2 = TeXFormulaParser.getAttrValueAndCheckIfNotNull("formula", element);
            Object v = TeXFormulaParser.this.d.get(string2);
            if (v == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "formula", "has an unknown temporary TeXFormula name as value : '" + string2 + "'!");
            }
            NodeList nodeList = element.getElementsByTagName("Argument");
            Class[] classArray = TeXFormulaParser.getArgumentClasses(nodeList);
            Object[] objectArray = TeXFormulaParser.this.getArgumentValues(nodeList);
            try {
                TeXFormula.class.getMethod(string, classArray).invoke((Object)((TeXFormula)v), objectArray);
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("Error invoking the method '" + string + "' on the temporary TeXFormula '" + string2 + "' while constructing the predefined TeXFormula '" + TeXFormulaParser.this.a + "'!\n" + exception.toString());
            }
        }
    }

    private class ReturnParser
    implements ActionParser {
        ReturnParser() {
        }

        public void parse(Element element) {
            Object v;
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", element);
            Object v2 = v = TeXFormulaParser.this.a == 0 ? TeXFormulaParser.this.e.get(string) : TeXFormulaParser.this.d.get(string);
            if (v == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Return", "name", "contains an unknown temporary TeXFormula variable name '" + string + "' for the predefined TeXFormula '" + TeXFormulaParser.this.a + "'!");
            }
            TeXFormulaParser.this.a = v;
        }
    }

    private class StringValueParser
    implements ArgumentValueParser {
        StringValueParser() {
        }

        public Object parseValue(String string, String string2) {
            return string;
        }
    }

    private class TeXConstantsValueParser
    implements ArgumentValueParser {
        TeXConstantsValueParser() {
        }

        public Object parseValue(String string, String string2) {
            TeXFormulaParser.checkNullValue(string, string2);
            try {
                int n = TeXConstants.class.getDeclaredField(string).getInt(null);
                return n;
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an unknown constant name as value : '" + string + "'!", exception);
            }
        }
    }

    private class TeXFormulaValueParser
    implements ArgumentValueParser {
        TeXFormulaValueParser() {
        }

        public Object parseValue(String string, String string2) {
            if (string == null) {
                return null;
            }
            Object v = TeXFormulaParser.this.d.get(string);
            if (v == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an unknown temporary TeXFormula name as value : '" + string + "'!");
            }
            return (TeXFormula)v;
        }
    }
}

