/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.RepositoryResourceAccessor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.repositories.AbstractResolutionAwareArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.FlatDirRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.descriptor.IvyRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultArtifactMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.resolve.caching.ImplicitInputRecorder;
import org.gradle.internal.resolve.caching.ImplicitInputsCapturingInstantiator;
import org.gradle.internal.resolve.caching.ImplicitInputsProvidingService;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.util.internal.CollectionUtils;

public class DefaultFlatDirArtifactRepository
extends AbstractResolutionAwareArtifactRepository<FlatDirRepositoryDescriptor>
implements FlatDirectoryArtifactRepository,
ResolutionAwareRepository {
    private final FileCollectionFactory fileCollectionFactory;
    private final List<Object> dirs = new ArrayList<Object>();
    private final RepositoryTransportFactory transportFactory;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final IvyMutableModuleMetadataFactory metadataFactory;
    private final InstantiatorFactory instantiatorFactory;
    private final ChecksumService checksumService;

    public DefaultFlatDirArtifactRepository(FileCollectionFactory fileCollectionFactory, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, IvyMutableModuleMetadataFactory metadataFactory, InstantiatorFactory instantiatorFactory, ObjectFactory objectFactory, ChecksumService checksumService, VersionParser versionParser) {
        super(objectFactory, versionParser);
        this.fileCollectionFactory = fileCollectionFactory;
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.metadataFactory = metadataFactory;
        this.instantiatorFactory = instantiatorFactory;
        this.checksumService = checksumService;
    }

    @Override
    public String getDisplayName() {
        Set<File> dirs = this.getDirs();
        if (dirs.isEmpty()) {
            return super.getDisplayName();
        }
        return super.getDisplayName() + '(' + Joiner.on((String)", ").join(dirs) + ')';
    }

    public Set<File> getDirs() {
        return this.fileCollectionFactory.resolving(this.dirs).getFiles();
    }

    public void setDirs(Set<File> dirs) {
        this.setDirs((Iterable<?>)dirs);
    }

    public void setDirs(Iterable<?> dirs) {
        this.invalidateDescriptor();
        this.dirs.clear();
        CollectionUtils.addAll(this.dirs, dirs);
    }

    public void dir(Object dir) {
        this.dirs(dir);
    }

    public void dirs(Object ... dirs) {
        this.invalidateDescriptor();
        this.dirs.addAll(Arrays.asList(dirs));
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.createRealResolver();
    }

    @Override
    protected FlatDirRepositoryDescriptor createDescriptor() {
        IvyRepositoryDescriptor.Builder builder = new IvyRepositoryDescriptor.Builder(this.getName(), null);
        builder.setM2Compatible(false);
        builder.setLayoutType("Unknown");
        builder.setMetadataSources((List)ImmutableList.of());
        builder.setAuthenticated(false);
        builder.setAuthenticationSchemes((List)ImmutableList.of());
        for (File root : this.getDirs()) {
            builder.addArtifactResource(root.toURI(), "/[artifact]-[revision](-[classifier]).[ext]");
            builder.addArtifactResource(root.toURI(), "/[artifact](-[classifier]).[ext]");
        }
        IvyRepositoryDescriptor ivyDescriptor = builder.create();
        return new FlatDirRepositoryDescriptor(this.getName(), this.getDirs(), ivyDescriptor);
    }

    @Override
    protected RepositoryResourceAccessor createRepositoryAccessor(RepositoryTransport transport, URI rootUri, FileStore<String> externalResourcesFileStore) {
        return new NoOpRepositoryResourceAccessor();
    }

    private IvyResolver createRealResolver() {
        FlatDirRepositoryDescriptor descriptor = (FlatDirRepositoryDescriptor)this.getDescriptor();
        ImmutableList<File> dirs = descriptor.getDirs();
        if (dirs.isEmpty()) {
            throw new InvalidUserDataException("You must specify at least one directory for a flat directory repository.");
        }
        RepositoryTransport transport = this.transportFactory.createFileTransport(this.getName());
        ImplicitInputsCapturingInstantiator injector = this.createInjectorForMetadataSuppliers(transport, this.instantiatorFactory, null, null);
        return new IvyResolver(descriptor.getBackingDescriptor(), transport, this.locallyAvailableResourceFinder, false, this.artifactFileStore, null, null, this.createMetadataSources(), IvyMetadataArtifactProvider.INSTANCE, injector, this.checksumService);
    }

    private ImmutableMetadataSources createMetadataSources() {
        DefaultArtifactMetadataSource artifactMetadataSource = new DefaultArtifactMetadataSource(this.metadataFactory);
        return new DefaultImmutableMetadataSources(Collections.singletonList(artifactMetadataSource));
    }

    private static class NoOpRepositoryResourceAccessor
    implements RepositoryResourceAccessor,
    ImplicitInputsProvidingService<String, Long, RepositoryResourceAccessor> {
        private NoOpRepositoryResourceAccessor() {
        }

        public void withResource(String relativePath, Action<? super InputStream> action) {
        }

        @Override
        public RepositoryResourceAccessor withImplicitInputRecorder(ImplicitInputRecorder registrar) {
            return this;
        }

        @Override
        public boolean isUpToDate(String s, @Nullable Long oldValue) {
            return true;
        }
    }
}

