/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.normalization.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.changedetection.state.IgnoringResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.IgnoringResourceFilter;
import org.gradle.api.internal.changedetection.state.PropertiesFileFilter;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.normalization.MetaInfNormalization;
import org.gradle.normalization.PropertiesFileNormalization;
import org.gradle.normalization.internal.RuntimeClasspathNormalizationInternal;

public class DefaultRuntimeClasspathNormalization
implements RuntimeClasspathNormalizationInternal {
    private final MetaInfNormalization metaInfNormalization = new RuntimeMetaInfNormalization();
    private final EvaluatableFilter<ResourceFilter> resourceFilter = DefaultRuntimeClasspathNormalization.filter(IgnoringResourceFilter::new, ResourceFilter.FILTER_NOTHING);
    private final EvaluatableFilter<ResourceEntryFilter> manifestAttributeResourceFilter = DefaultRuntimeClasspathNormalization.filter(IgnoringResourceEntryFilter::new, ResourceEntryFilter.FILTER_NOTHING);
    private final DefaultPropertiesFileFilter propertyFileFilters = new DefaultPropertiesFileFilter();

    public void ignore(String pattern) {
        this.resourceFilter.ignore(pattern);
    }

    public void metaInf(Action<? super MetaInfNormalization> configuration) {
        configuration.execute((Object)this.metaInfNormalization);
    }

    public void properties(String pattern, Action<? super PropertiesFileNormalization> configuration) {
        this.propertyFileFilters.configure(pattern, configuration);
    }

    public void properties(Action<? super PropertiesFileNormalization> configuration) {
        this.properties("**/*.properties", configuration);
    }

    @Override
    public ResourceFilter getClasspathResourceFilter() {
        return this.resourceFilter.evaluate();
    }

    @Override
    public ResourceEntryFilter getManifestAttributeResourceEntryFilter() {
        return this.manifestAttributeResourceFilter.evaluate();
    }

    @Override
    public Map<String, ResourceEntryFilter> getPropertiesFileFilters() {
        return this.propertyFileFilters.getFilters();
    }

    @Override
    public RuntimeClasspathNormalizationInternal.CachedState computeCachedState() {
        DefaultCachedState cachedState = new DefaultCachedState(this.resourceFilter, this.manifestAttributeResourceFilter, this.propertyFileFilters);
        if (cachedState.isTrivial()) {
            return null;
        }
        return cachedState;
    }

    @Override
    public void configureFromCachedState(RuntimeClasspathNormalizationInternal.CachedState state) {
        if (!(state instanceof DefaultCachedState)) {
            throw new IllegalArgumentException("Cannot restore state from " + state.getClass() + ", expecting DefaultCachedState");
        }
        DefaultCachedState defaultCachedState = (DefaultCachedState)state;
        defaultCachedState.resourceFilterState.forEach(this.resourceFilter::ignore);
        defaultCachedState.manifestAttributesFilterState.forEach(this.manifestAttributeResourceFilter::ignore);
        defaultCachedState.propertiesFileFiltersState.forEach((pattern, ignores) -> this.propertyFileFilters.configure((String)pattern, (Action<? super PropertiesFileNormalization>)((Action)normalization -> ignores.forEach(arg_0 -> ((PropertiesFileNormalization)normalization).ignoreProperty(arg_0)))));
    }

    private static <T> EvaluatableFilter<T> filter(Function<ImmutableSet<String>, T> initializer, T emptyValue) {
        return new EvaluatableFilter<T>(initializer, emptyValue);
    }

    private static class DefaultCachedState
    implements RuntimeClasspathNormalizationInternal.CachedState {
        final Set<String> resourceFilterState;
        final Set<String> manifestAttributesFilterState;
        final Map<String, Set<String>> propertiesFileFiltersState;

        DefaultCachedState(EvaluatableFilter<?> resourceFilter, EvaluatableFilter<?> manifestAttributesFilter, DefaultPropertiesFileFilter propertiesFileFilters) {
            this.resourceFilterState = resourceFilter.getState();
            this.manifestAttributesFilterState = manifestAttributesFilter.getState();
            this.propertiesFileFiltersState = propertiesFileFilters.getState();
        }

        boolean isTrivial() {
            return this.resourceFilterState.isEmpty() && this.manifestAttributesFilterState.isEmpty() && this.propertiesFileFiltersState.values().stream().allMatch(Set::isEmpty);
        }
    }

    private static class DefaultPropertiesFileFilter
    implements PropertiesFileFilter {
        private final Map<String, EvaluatableFilter<ResourceEntryFilter>> propertyFilters = new HashMap<String, EvaluatableFilter<ResourceEntryFilter>>();
        private Map<String, ResourceEntryFilter> finalPropertyFilters;

        DefaultPropertiesFileFilter() {
            this.propertyFilters.put("**/*.properties", DefaultRuntimeClasspathNormalization.filter(IgnoringResourceEntryFilter::new, ResourceEntryFilter.FILTER_NOTHING));
        }

        public Map<String, ResourceEntryFilter> getFilters() {
            if (this.finalPropertyFilters == null) {
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                this.propertyFilters.forEach((pattern, filter) -> builder.put(pattern, (Object)((ResourceEntryFilter)filter.evaluate())));
                this.finalPropertyFilters = builder.build();
            }
            return this.finalPropertyFilters;
        }

        void configure(String pattern, Action<? super PropertiesFileNormalization> configuration) {
            EvaluatableFilter<ResourceEntryFilter> filter;
            if (this.finalPropertyFilters == null) {
                if (this.propertyFilters.containsKey(pattern)) {
                    filter = this.propertyFilters.get(pattern);
                } else {
                    filter = DefaultRuntimeClasspathNormalization.filter(IgnoringResourceEntryFilter::new, ResourceEntryFilter.FILTER_NOTHING);
                    this.propertyFilters.put(pattern, filter);
                }
            } else {
                throw new IllegalStateException("Cannot configure runtime classpath normalization after execution started.");
            }
            PropertiesFileNormalization normalization = filter::ignore;
            configuration.execute((Object)normalization);
        }

        Map<String, Set<String>> getState() {
            this.getFilters();
            return (Map)this.propertyFilters.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((EvaluatableFilter)e.getValue()).getState()));
        }
    }

    private static class EvaluatableFilter<T> {
        private T value;
        private final Supplier<T> valueSupplier;
        private final ImmutableSet.Builder<String> builder = ImmutableSet.builder();

        public EvaluatableFilter(Function<ImmutableSet<String>, T> initializer, T emptyValue) {
            this.valueSupplier = () -> Optional.of(this.builder.build()).filter(ignores -> !ignores.isEmpty()).map(initializer).orElse(emptyValue);
        }

        public T evaluate() {
            if (this.value == null) {
                this.value = this.valueSupplier.get();
            }
            return this.value;
        }

        private void checkNotEvaluated() {
            if (this.value != null) {
                throw new GradleException("Cannot configure runtime classpath normalization after execution started.");
            }
        }

        public void ignore(String ignore) {
            this.checkNotEvaluated();
            this.builder.add((Object)ignore);
        }

        Set<String> getState() {
            this.evaluate();
            return this.builder.build();
        }
    }

    public class RuntimeMetaInfNormalization
    implements MetaInfNormalization {
        public void ignoreCompletely() {
            DefaultRuntimeClasspathNormalization.this.ignore("META-INF/*");
        }

        public void ignoreManifest() {
            DefaultRuntimeClasspathNormalization.this.ignore("META-INF/MANIFEST.MF");
        }

        public void ignoreAttribute(String name) {
            DefaultRuntimeClasspathNormalization.this.manifestAttributeResourceFilter.ignore(name.toLowerCase(Locale.ROOT));
        }

        public void ignoreProperty(String name) {
            DefaultRuntimeClasspathNormalization.this.propertyFileFilters.configure("META-INF/**/*.properties", (Action<? super PropertiesFileNormalization>)((Action)propertiesFileNormalization -> propertiesFileNormalization.ignoreProperty(name)));
        }
    }
}

