/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.CommentsLevel;
import jadx.api.ICodeWriter;
import jadx.api.metadata.annotations.InsnCodeOffset;
import jadx.api.metadata.annotations.VarNode;
import jadx.api.plugins.input.data.MethodHandleType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.core.codegen.ClassGen;
import jadx.core.codegen.ConditionGen;
import jadx.core.codegen.MethodGen;
import jadx.core.codegen.NameGen;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.FieldInitInsnAttr;
import jadx.core.dex.attributes.nodes.FieldReplaceAttr;
import jadx.core.dex.attributes.nodes.GenericInfoAttr;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.attributes.nodes.MethodReplaceAttr;
import jadx.core.dex.attributes.nodes.SkipMethodArgsAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.ConstClassNode;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.FillArrayInsn;
import jadx.core.dex.instructions.FilledNewArrayNode;
import jadx.core.dex.instructions.GotoNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeCustomNode;
import jadx.core.dex.instructions.InvokeCustomRawNode;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.NewArrayNode;
import jadx.core.dex.instructions.SwitchInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.Named;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.CodeGenUtils;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.android.AndroidResourcesUtils;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsnGen {
    private static final Logger LOG = LoggerFactory.getLogger(InsnGen.class);
    protected final MethodGen mgen;
    protected final MethodNode mth;
    protected final RootNode root;
    protected final boolean fallback;
    private static final Set<Flags> EMPTY_FLAGS = EnumSet.noneOf(Flags.class);
    private static final Set<Flags> BODY_ONLY_FLAG = EnumSet.of(Flags.BODY_ONLY);
    private static final Set<Flags> BODY_ONLY_NOWRAP_FLAGS = EnumSet.of(Flags.BODY_ONLY_NOWRAP);

    public InsnGen(MethodGen mgen, boolean fallback) {
        this.mgen = mgen;
        this.mth = mgen.getMethodNode();
        this.root = this.mth.root();
        this.fallback = fallback;
    }

    private boolean isFallback() {
        return this.fallback;
    }

    public void addArgDot(ICodeWriter code, InsnArg arg) throws CodegenException {
        int len = code.getLength();
        this.addArg(code, arg, true);
        if (len != code.getLength()) {
            code.add('.');
        }
    }

    public void addArg(ICodeWriter code, InsnArg arg) throws CodegenException {
        this.addArg(code, arg, true);
    }

    public void addArg(ICodeWriter code, InsnArg arg, boolean wrap) throws CodegenException {
        this.addArg(code, arg, wrap ? BODY_ONLY_FLAG : BODY_ONLY_NOWRAP_FLAGS);
    }

    public void addArg(ICodeWriter code, InsnArg arg, Set<Flags> flags) throws CodegenException {
        if (arg.isRegister()) {
            RegisterArg reg = (RegisterArg)arg;
            if (code.isMetadataSupported()) {
                code.attachAnnotation(VarNode.getRef(this.mth, reg));
            }
            code.add(this.mgen.getNameGen().useArg(reg));
        } else if (arg.isLiteral()) {
            this.addLiteralArg(code, (LiteralArg)arg, flags);
        } else if (arg.isInsnWrap()) {
            this.addWrappedArg(code, (InsnWrapArg)arg, flags);
        } else if (arg.isNamed()) {
            code.add(((Named)((Object)arg)).getName());
        } else {
            throw new CodegenException("Unknown arg type " + arg);
        }
    }

    private void addLiteralArg(ICodeWriter code, LiteralArg litArg, Set<Flags> flags) {
        String literalStr = this.lit(litArg);
        if (!flags.contains((Object)Flags.BODY_ONLY_NOWRAP) && literalStr.startsWith("-")) {
            code.add('(').add(literalStr).add(')');
        } else {
            code.add(literalStr);
        }
    }

    private void addWrappedArg(ICodeWriter code, InsnWrapArg arg, Set<Flags> flags) throws CodegenException {
        InsnNode wrapInsn = arg.getWrapInsn();
        if (wrapInsn.contains(AFlag.FORCE_ASSIGN_INLINE)) {
            code.add('(');
            this.makeInsn(wrapInsn, code, Flags.INLINE);
            code.add(')');
        } else {
            this.makeInsnBody(code, wrapInsn, flags);
        }
    }

    public void assignVar(ICodeWriter code, InsnNode insn) throws CodegenException {
        RegisterArg arg = insn.getResult();
        if (insn.contains(AFlag.DECLARE_VAR)) {
            this.declareVar(code, arg);
        } else {
            this.addArg(code, (InsnArg)arg, false);
        }
    }

    public void declareVar(ICodeWriter code, RegisterArg arg) {
        this.declareVar(code, arg.getSVar().getCodeVar());
    }

    public void declareVar(ICodeWriter code, CodeVar codeVar) {
        if (codeVar.isFinal()) {
            code.add("final ");
        }
        this.useType(code, codeVar.getType());
        code.add(' ');
        this.defVar(code, codeVar);
    }

    private void defVar(ICodeWriter code, CodeVar codeVar) {
        String varName = this.mgen.getNameGen().assignArg(codeVar);
        if (code.isMetadataSupported()) {
            code.attachDefinition(VarNode.get(this.mth, codeVar));
        }
        code.add(varName);
    }

    private String lit(LiteralArg arg) {
        return TypeGen.literalToString(arg, this.mth, this.fallback);
    }

    private void instanceField(ICodeWriter code, FieldInfo field, InsnArg arg) throws CodegenException {
        FieldReplaceAttr replace;
        ClassNode pCls = this.mth.getParentClass();
        FieldNode fieldNode = pCls.root().resolveField(field);
        if (fieldNode != null && (replace = fieldNode.get(AType.FIELD_REPLACE)) != null) {
            switch (replace.getReplaceType()) {
                case CLASS_INSTANCE: {
                    this.useClass(code, replace.getClsRef());
                    code.add(".this");
                    break;
                }
                case VAR: {
                    this.addArg(code, replace.getVarRef());
                }
            }
            return;
        }
        this.addArgDot(code, arg);
        if (fieldNode != null) {
            code.attachAnnotation(fieldNode);
        }
        if (fieldNode == null) {
            code.add(field.getAlias());
        } else {
            code.add(fieldNode.getAlias());
        }
    }

    protected void staticField(ICodeWriter code, FieldInfo field) throws CodegenException {
        InsnNode insn;
        FieldInitInsnAttr initInsnAttr;
        FieldNode fieldNode = this.root.resolveField(field);
        if (fieldNode != null && fieldNode.contains(AFlag.INLINE_INSTANCE_FIELD) && fieldNode.getParentClass().contains(AType.ANONYMOUS_CLASS) && (initInsnAttr = fieldNode.get(AType.FIELD_INIT_INSN)) != null && (insn = initInsnAttr.getInsn()) instanceof ConstructorInsn) {
            fieldNode.add(AFlag.DONT_GENERATE);
            this.inlineAnonymousConstructor(code, fieldNode.getParentClass(), (ConstructorInsn)insn);
            return;
        }
        InsnGen.makeStaticFieldAccess(code, field, fieldNode, this.mgen.getClassGen());
    }

    public static void makeStaticFieldAccess(ICodeWriter code, FieldInfo field, ClassGen clsGen) {
        FieldNode fieldNode = clsGen.getClassNode().root().resolveField(field);
        InsnGen.makeStaticFieldAccess(code, field, fieldNode, clsGen);
    }

    private static void makeStaticFieldAccess(ICodeWriter code, FieldInfo field, @Nullable FieldNode fieldNode, ClassGen clsGen) {
        ClassInfo declClass = field.getDeclClass();
        boolean fieldFromThisClass = clsGen.getClassNode().getClassInfo().equals(declClass);
        if (!fieldFromThisClass || !clsGen.isBodyGenStarted()) {
            if (!AndroidResourcesUtils.handleAppResField(code, clsGen, declClass)) {
                clsGen.useClass(code, declClass);
            }
            code.add('.');
        }
        if (fieldNode != null) {
            code.attachAnnotation(fieldNode);
        }
        if (fieldNode == null) {
            code.add(field.getAlias());
        } else {
            code.add(fieldNode.getAlias());
        }
    }

    public void useClass(ICodeWriter code, ArgType type) {
        this.mgen.getClassGen().useClass(code, type);
    }

    public void useClass(ICodeWriter code, ClassInfo cls) {
        this.mgen.getClassGen().useClass(code, cls);
    }

    protected void useType(ICodeWriter code, ArgType type) {
        this.mgen.getClassGen().useType(code, type);
    }

    public void makeInsn(InsnNode insn, ICodeWriter code) throws CodegenException {
        this.makeInsn(insn, code, null);
    }

    protected void makeInsn(InsnNode insn, ICodeWriter code, Flags flag) throws CodegenException {
        if (insn.getType() == InsnType.REGION_ARG) {
            return;
        }
        try {
            if (flag == Flags.BODY_ONLY || flag == Flags.BODY_ONLY_NOWRAP) {
                this.makeInsnBody(code, insn, flag == Flags.BODY_ONLY ? BODY_ONLY_FLAG : BODY_ONLY_NOWRAP_FLAGS);
            } else {
                SSAVar var;
                RegisterArg resArg;
                if (flag != Flags.INLINE) {
                    code.startLineWithNum(insn.getSourceLine());
                    InsnCodeOffset.attach(code, insn);
                    if (insn.contains(AFlag.COMMENT_OUT)) {
                        code.add("// ");
                    }
                }
                if ((resArg = insn.getResult()) != null && ((var = resArg.getSVar()) == null || var.getUseCount() != 0 || insn.getType() != InsnType.CONSTRUCTOR)) {
                    this.assignVar(code, insn);
                    code.add(" = ");
                }
                this.makeInsnBody(code, insn, EMPTY_FLAGS);
                if (flag != Flags.INLINE) {
                    code.add(';');
                    CodeGenUtils.addCodeComments(code, this.mth, insn);
                }
            }
        }
        catch (Exception e) {
            throw new CodegenException(this.mth, "Error generate insn: " + insn, (Throwable)e);
        }
    }

    private void makeInsnBody(ICodeWriter code, InsnNode insn, Set<Flags> state) throws CodegenException {
        switch (insn.getType()) {
            case CONST_STR: {
                String str = ((ConstStringNode)insn).getString();
                code.add(this.mth.root().getStringUtils().unescapeString(str));
                break;
            }
            case CONST_CLASS: {
                ArgType clsType = ((ConstClassNode)insn).getClsType();
                this.useType(code, clsType);
                code.add(".class");
                break;
            }
            case CONST: {
                LiteralArg arg = (LiteralArg)insn.getArg(0);
                code.add(this.lit(arg));
                break;
            }
            case MOVE: {
                this.addArg(code, insn.getArg(0), false);
                break;
            }
            case CHECK_CAST: 
            case CAST: {
                boolean wrap = state.contains((Object)Flags.BODY_ONLY);
                if (wrap) {
                    code.add('(');
                }
                code.add('(');
                this.useType(code, (ArgType)((IndexInsnNode)insn).getIndex());
                code.add(") ");
                this.addArg(code, insn.getArg(0), true);
                if (!wrap) break;
                code.add(')');
                break;
            }
            case ARITH: {
                this.makeArith((ArithNode)insn, code, state);
                break;
            }
            case NEG: {
                this.oneArgInsn(code, insn, state, '-');
                break;
            }
            case NOT: {
                char op = insn.getArg(0).getType() == ArgType.BOOLEAN ? (char)'!' : '~';
                this.oneArgInsn(code, insn, state, op);
                break;
            }
            case RETURN: {
                if (insn.getArgsCount() != 0) {
                    code.add("return ");
                    this.addArg(code, insn.getArg(0), false);
                    break;
                }
                code.add("return");
                break;
            }
            case BREAK: {
                code.add("break");
                LoopLabelAttr labelAttr = insn.get(AType.LOOP_LABEL);
                if (labelAttr == null) break;
                code.add(' ').add(this.mgen.getNameGen().getLoopLabel(labelAttr));
                break;
            }
            case CONTINUE: {
                code.add("continue");
                break;
            }
            case THROW: {
                code.add("throw ");
                this.addArg(code, insn.getArg(0), true);
                break;
            }
            case CMP_L: 
            case CMP_G: {
                code.add('(');
                this.addArg(code, insn.getArg(0));
                code.add(" > ");
                this.addArg(code, insn.getArg(1));
                code.add(" ? 1 : (");
                this.addArg(code, insn.getArg(0));
                code.add(" == ");
                this.addArg(code, insn.getArg(1));
                code.add(" ? 0 : -1))");
                break;
            }
            case INSTANCE_OF: {
                boolean wrap = state.contains((Object)Flags.BODY_ONLY);
                if (wrap) {
                    code.add('(');
                }
                this.addArg(code, insn.getArg(0));
                code.add(" instanceof ");
                this.useType(code, (ArgType)((IndexInsnNode)insn).getIndex());
                if (!wrap) break;
                code.add(')');
                break;
            }
            case CONSTRUCTOR: {
                this.makeConstructor((ConstructorInsn)insn, code);
                break;
            }
            case INVOKE: {
                this.makeInvoke((InvokeNode)insn, code);
                break;
            }
            case NEW_ARRAY: {
                int k;
                ArgType arrayType = ((NewArrayNode)insn).getArrayType();
                code.add("new ");
                this.useType(code, arrayType.getArrayRootElement());
                int argsCount = insn.getArgsCount();
                for (k = 0; k < argsCount; ++k) {
                    code.add('[');
                    this.addArg(code, insn.getArg(k), false);
                    code.add(']');
                }
                int dim = arrayType.getArrayDimension();
                while (k < dim - 1) {
                    code.add("[]");
                    ++k;
                }
                break;
            }
            case ARRAY_LENGTH: {
                this.addArg(code, insn.getArg(0));
                code.add(".length");
                break;
            }
            case FILLED_NEW_ARRAY: {
                this.filledNewArray((FilledNewArrayNode)insn, code);
                break;
            }
            case FILL_ARRAY: {
                FillArrayInsn arrayNode = (FillArrayInsn)insn;
                if (this.fallback) {
                    String arrStr = arrayNode.dataToString();
                    this.addArg(code, insn.getArg(0));
                    code.add(" = {").add(arrStr.substring(1, arrStr.length() - 1)).add("} // fill-array");
                    break;
                }
                this.fillArray(code, arrayNode);
                break;
            }
            case AGET: {
                this.addArg(code, insn.getArg(0));
                code.add('[');
                this.addArg(code, insn.getArg(1), false);
                code.add(']');
                break;
            }
            case APUT: {
                this.addArg(code, insn.getArg(0));
                code.add('[');
                this.addArg(code, insn.getArg(1), false);
                code.add("] = ");
                this.addArg(code, insn.getArg(2), false);
                break;
            }
            case IGET: {
                FieldInfo fieldInfo = (FieldInfo)((IndexInsnNode)insn).getIndex();
                this.instanceField(code, fieldInfo, insn.getArg(0));
                break;
            }
            case IPUT: {
                FieldInfo fieldInfo = (FieldInfo)((IndexInsnNode)insn).getIndex();
                this.instanceField(code, fieldInfo, insn.getArg(1));
                code.add(" = ");
                this.addArg(code, insn.getArg(0), false);
                break;
            }
            case SGET: {
                this.staticField(code, (FieldInfo)((IndexInsnNode)insn).getIndex());
                break;
            }
            case SPUT: {
                FieldInfo field = (FieldInfo)((IndexInsnNode)insn).getIndex();
                this.staticField(code, field);
                code.add(" = ");
                this.addArg(code, insn.getArg(0), false);
                break;
            }
            case STR_CONCAT: {
                boolean wrap = state.contains((Object)Flags.BODY_ONLY);
                if (wrap) {
                    code.add('(');
                }
                Iterator<InsnArg> it = insn.getArguments().iterator();
                while (it.hasNext()) {
                    this.addArg(code, it.next());
                    if (!it.hasNext()) continue;
                    code.add(" + ");
                }
                if (!wrap) break;
                code.add(')');
                break;
            }
            case MONITOR_ENTER: {
                if (!this.isFallback()) break;
                code.add("monitor-enter(");
                this.addArg(code, insn.getArg(0));
                code.add(')');
                break;
            }
            case MONITOR_EXIT: {
                if (!this.isFallback()) break;
                code.add("monitor-exit(");
                if (insn.getArgsCount() == 1) {
                    this.addArg(code, insn.getArg(0));
                }
                code.add(')');
                break;
            }
            case TERNARY: {
                this.makeTernary((TernaryInsn)insn, code, state);
                break;
            }
            case ONE_ARG: {
                this.addArg(code, insn.getArg(0), state);
                break;
            }
            case IF: {
                this.fallbackOnlyInsn(insn);
                IfNode ifInsn = (IfNode)insn;
                code.add("if (");
                this.addArg(code, insn.getArg(0));
                code.add(' ');
                code.add(ifInsn.getOp().getSymbol()).add(' ');
                this.addArg(code, insn.getArg(1));
                code.add(") goto ").add(MethodGen.getLabelName(ifInsn));
                break;
            }
            case GOTO: {
                this.fallbackOnlyInsn(insn);
                code.add("goto ").add(MethodGen.getLabelName(((GotoNode)insn).getTarget()));
                break;
            }
            case MOVE_EXCEPTION: {
                this.fallbackOnlyInsn(insn);
                code.add("move-exception");
                break;
            }
            case SWITCH: {
                this.fallbackOnlyInsn(insn);
                SwitchInsn sw = (SwitchInsn)insn;
                code.add("switch(");
                this.addArg(code, insn.getArg(0));
                code.add(") {");
                code.incIndent();
                int[] keys = sw.getKeys();
                int size = keys.length;
                BlockNode[] targetBlocks = sw.getTargetBlocks();
                if (targetBlocks != null) {
                    for (int i = 0; i < size; ++i) {
                        code.startLine("case ").add(Integer.toString(keys[i])).add(": goto ");
                        code.add(MethodGen.getLabelName(targetBlocks[i])).add(';');
                    }
                    code.startLine("default: goto ");
                    code.add(MethodGen.getLabelName(sw.getDefTargetBlock())).add(';');
                } else {
                    int[] targets = sw.getTargets();
                    for (int i = 0; i < size; ++i) {
                        code.startLine("case ").add(Integer.toString(keys[i])).add(": goto ");
                        code.add(MethodGen.getLabelName(targets[i])).add(';');
                    }
                    code.startLine("default: goto ");
                    code.add(MethodGen.getLabelName(sw.getDefaultCaseOffset())).add(';');
                }
                code.decIndent();
                code.startLine('}');
                break;
            }
            case NEW_INSTANCE: {
                this.fallbackOnlyInsn(insn);
                code.add("new ").add(insn.getResult().getInitType().toString());
                break;
            }
            case PHI: {
                this.fallbackOnlyInsn(insn);
                code.add(insn.getType().toString()).add('(');
                for (InsnArg insnArg : insn.getArguments()) {
                    this.addArg(code, insnArg);
                    code.add(' ');
                }
                code.add(')');
                break;
            }
            case MOVE_RESULT: {
                this.fallbackOnlyInsn(insn);
                code.add("move-result");
                break;
            }
            case FILL_ARRAY_DATA: {
                this.fallbackOnlyInsn(insn);
                code.add("fill-array " + insn);
                break;
            }
            case SWITCH_DATA: {
                this.fallbackOnlyInsn(insn);
                code.add(insn.toString());
                break;
            }
            case MOVE_MULTI: {
                this.fallbackOnlyInsn(insn);
                int len = insn.getArgsCount();
                for (int i = 0; i < len - 1; i += 2) {
                    this.addArg(code, insn.getArg(i));
                    code.add(" = ");
                    this.addArg(code, insn.getArg(i + 1));
                    code.add("; ");
                }
                break;
            }
            default: {
                throw new CodegenException(this.mth, "Unknown instruction: " + (Object)((Object)insn.getType()));
            }
        }
    }

    private void fillArray(ICodeWriter code, FillArrayInsn arrayNode) throws CodegenException {
        ArgType elemType;
        if (this.mth.checkCommentsLevel(CommentsLevel.INFO)) {
            code.add("// fill-array-data instruction");
        }
        code.startLine();
        InsnArg arrArg = arrayNode.getArg(0);
        ArgType arrayType = arrArg.getType();
        if (arrayType.isTypeKnown() && arrayType.isArray()) {
            elemType = arrayType.getArrayElement();
        } else {
            ArgType elementType = arrayNode.getElementType();
            elemType = elementType.selectFirst();
        }
        List<LiteralArg> args = arrayNode.getLiteralArgs(elemType);
        int len = args.size();
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                code.add(';');
                code.startLine();
            }
            this.addArg(code, arrArg);
            code.add('[').add(Integer.toString(i)).add("] = ").add(this.lit(args.get(i)));
        }
    }

    private void oneArgInsn(ICodeWriter code, InsnNode insn, Set<Flags> state, char op) throws CodegenException {
        boolean wrap = state.contains((Object)Flags.BODY_ONLY);
        if (wrap) {
            code.add('(');
        }
        code.add(op);
        this.addArg(code, insn.getArg(0));
        if (wrap) {
            code.add(')');
        }
    }

    private void fallbackOnlyInsn(InsnNode insn) throws CodegenException {
        if (!this.fallback) {
            String msg = (Object)((Object)insn.getType()) + " instruction can be used only in fallback mode";
            CodegenException e = new CodegenException(msg);
            this.mth.addError(msg, e);
            this.mth.getParentClass().getTopParentClass().add(AFlag.RESTART_CODEGEN);
            throw e;
        }
    }

    private void filledNewArray(FilledNewArrayNode insn, ICodeWriter code) throws CodegenException {
        if (!insn.contains(AFlag.DECLARE_VAR)) {
            code.add("new ");
            this.useType(code, insn.getArrayType());
        }
        code.add('{');
        int c = insn.getArgsCount();
        int wrap = 0;
        for (int i = 0; i < c; ++i) {
            this.addArg(code, insn.getArg(i), false);
            if (i + 1 < c) {
                code.add(", ");
            }
            if (++wrap != 1000) continue;
            code.startLine();
            wrap = 0;
        }
        code.add('}');
    }

    private void makeConstructor(ConstructorInsn insn, ICodeWriter code) throws CodegenException {
        MethodReplaceAttr replaceAttr;
        MethodNode callMth;
        ClassNode cls = this.mth.root().resolveClass(insn.getClassType());
        if (cls != null && cls.isAnonymous() && !this.fallback) {
            this.inlineAnonymousConstructor(code, cls, insn);
            return;
        }
        if (insn.isSelf()) {
            throw new JadxRuntimeException("Constructor 'self' invoke must be removed!");
        }
        MethodNode refMth = callMth = this.mth.root().resolveMethod(insn.getCallMth());
        if (callMth != null && (replaceAttr = callMth.get(AType.METHOD_REPLACE)) != null) {
            refMth = replaceAttr.getReplaceMth();
        }
        if (insn.isSuper()) {
            code.attachAnnotation(refMth);
            code.add("super");
        } else if (insn.isThis()) {
            code.attachAnnotation(refMth);
            code.add("this");
        } else {
            code.add("new ");
            if (refMth == null || refMth.contains(AFlag.DONT_GENERATE)) {
                code.attachAnnotation(this.mth.root().resolveClass(insn.getCallMth().getDeclClass()));
            } else {
                code.attachAnnotation(refMth);
            }
            this.mgen.getClassGen().addClsName(code, insn.getClassType());
            GenericInfoAttr genericInfoAttr = insn.get(AType.GENERIC_INFO);
            if (genericInfoAttr != null) {
                code.add('<');
                if (genericInfoAttr.isExplicit()) {
                    boolean first = true;
                    for (ArgType type : genericInfoAttr.getGenericTypes()) {
                        if (!first) {
                            code.add(',');
                        } else {
                            first = false;
                        }
                        this.mgen.getClassGen().useType(code, type);
                    }
                }
                code.add('>');
            }
        }
        this.generateMethodArguments(code, insn, 0, callMth);
    }

    private void inlineAnonymousConstructor(ICodeWriter code, ClassNode cls, ConstructorInsn insn) throws CodegenException {
        cls.ensureProcessed();
        if (this.mth.getParentClass() == cls) {
            cls.remove(AType.ANONYMOUS_CLASS);
            cls.remove(AFlag.DONT_GENERATE);
            this.mth.getParentClass().getTopParentClass().add(AFlag.RESTART_CODEGEN);
            throw new CodegenException("Anonymous inner class unlimited recursion detected. Convert class to inner: " + cls.getClassInfo().getFullName());
        }
        ArgType parent = cls.get(AType.ANONYMOUS_CLASS).getBaseType();
        for (MethodNode ctor : cls.getMethods()) {
            if (!ctor.contains(AFlag.ANONYMOUS_CONSTRUCTOR) || !RegionUtils.isEmpty(ctor.getRegion())) continue;
            ctor.add(AFlag.DONT_GENERATE);
        }
        code.attachDefinition(cls);
        code.add("new ");
        this.useClass(code, parent);
        MethodNode callMth = this.mth.root().resolveMethod(insn.getCallMth());
        if (callMth != null) {
            List<RegisterArg> mthArgs = callMth.getArgRegs();
            int argsCount = Math.min(insn.getArgsCount(), mthArgs.size());
            for (int i = 0; i < argsCount; ++i) {
                InsnArg arg = insn.getArg(i);
                if (!arg.isRegister()) continue;
                RegisterArg mthArg = mthArgs.get(i);
                RegisterArg insnArg = (RegisterArg)arg;
                mthArg.getSVar().setCodeVar(insnArg.getSVar().getCodeVar());
            }
        }
        this.generateMethodArguments(code, insn, 0, callMth);
        code.add(' ');
        ClassGen classGen = new ClassGen(cls, this.mgen.getClassGen().getParentGen());
        classGen.setOuterNameGen(this.mgen.getNameGen());
        classGen.addClassBody(code, true);
        this.mth.getParentClass().addInlinedClass(cls);
    }

    private void makeInvoke(InvokeNode insn, ICodeWriter code) throws CodegenException {
        InvokeType type = insn.getInvokeType();
        if (type == InvokeType.CUSTOM) {
            this.makeInvokeLambda(code, (InvokeCustomNode)insn);
            return;
        }
        MethodInfo callMth = insn.getCallMth();
        MethodNode callMthNode = this.mth.root().resolveMethod(callMth);
        if (type == InvokeType.CUSTOM_RAW) {
            this.makeInvokeCustomRaw((InvokeCustomRawNode)insn, callMthNode, code);
            return;
        }
        if (insn.isPolymorphicCall()) {
            code.add('(');
            this.useType(code, callMth.getReturnType());
            code.add(") ");
        }
        int k = 0;
        switch (type) {
            case DIRECT: 
            case VIRTUAL: 
            case INTERFACE: 
            case POLYMORPHIC: {
                InsnArg arg = insn.getArg(0);
                if (this.needInvokeArg(arg)) {
                    this.addArgDot(code, arg);
                }
                ++k;
                break;
            }
            case SUPER: {
                this.callSuper(code, callMth);
                ++k;
                code.add('.');
                break;
            }
            case STATIC: {
                ClassInfo insnCls = this.mth.getParentClass().getClassInfo();
                ClassInfo declClass = callMth.getDeclClass();
                if (insnCls.equals(declClass)) break;
                this.useClass(code, declClass);
                code.add('.');
            }
        }
        if (callMthNode != null) {
            code.attachAnnotation(callMthNode);
        }
        if (insn.contains(AFlag.FORCE_RAW_NAME)) {
            code.add(callMth.getName());
        } else if (callMthNode != null) {
            code.add(callMthNode.getAlias());
        } else {
            code.add(callMth.getAlias());
        }
        this.generateMethodArguments(code, insn, k, callMthNode);
    }

    private void makeInvokeCustomRaw(InvokeCustomRawNode insn, @Nullable MethodNode callMthNode, ICodeWriter code) throws CodegenException {
        if (this.isFallback()) {
            code.add("call_site(");
            code.incIndent();
            for (EncodedValue value : insn.getCallSiteValues()) {
                code.startLine(value.toString());
            }
            code.decIndent();
            code.startLine(").invoke");
            this.generateMethodArguments(code, insn, 0, callMthNode);
        } else {
            ArgType returnType = insn.getCallMth().getReturnType();
            if (!returnType.isVoid()) {
                code.add('(');
                this.useType(code, returnType);
                code.add(") ");
            }
            this.makeInvoke(insn.getResolveInvoke(), code);
            code.add(".dynamicInvoker().invoke");
            this.generateMethodArguments(code, insn, 0, callMthNode);
            code.add(" /* invoke-custom */");
        }
    }

    private boolean needInvokeArg(InsnArg arg) {
        if (arg.isAnyThis()) {
            if (arg.isThis()) {
                return false;
            }
            ClassNode clsNode = this.mth.root().resolveClass(arg.getType());
            if (clsNode != null && clsNode.contains(AFlag.DONT_GENERATE)) {
                return false;
            }
        }
        return true;
    }

    private void makeInvokeLambda(ICodeWriter code, InvokeCustomNode customNode) throws CodegenException {
        if (customNode.isUseRef()) {
            this.makeRefLambda(code, customNode);
            return;
        }
        if (this.fallback || !customNode.isInlineInsn()) {
            this.makeSimpleLambda(code, customNode);
            return;
        }
        MethodNode callMth = (MethodNode)customNode.getCallInsn().get(AType.METHOD_DETAILS);
        this.makeInlinedLambdaMethod(code, customNode, callMth);
    }

    private void makeRefLambda(ICodeWriter code, InvokeCustomNode customNode) {
        InsnNode callInsn = customNode.getCallInsn();
        if (callInsn instanceof ConstructorInsn) {
            MethodInfo callMth = ((ConstructorInsn)callInsn).getCallMth();
            this.useClass(code, callMth.getDeclClass());
            code.add("::new");
            return;
        }
        if (callInsn instanceof InvokeNode) {
            InvokeNode invokeInsn = (InvokeNode)callInsn;
            MethodInfo callMth = invokeInsn.getCallMth();
            if (customNode.getHandleType() == MethodHandleType.INVOKE_STATIC) {
                this.useClass(code, callMth.getDeclClass());
            } else {
                code.add("this");
            }
            code.add("::").add(callMth.getAlias());
        }
    }

    private void makeSimpleLambda(ICodeWriter code, InvokeCustomNode customNode) {
        try {
            InsnNode callInsn = customNode.getCallInsn();
            MethodInfo implMthInfo = customNode.getImplMthInfo();
            int implArgsCount = implMthInfo.getArgsCount();
            if (implArgsCount == 0) {
                code.add("()");
            } else {
                code.add('(');
                int callArgsCount = callInsn.getArgsCount();
                int startArg = callArgsCount - implArgsCount;
                if (customNode.getHandleType() != MethodHandleType.INVOKE_STATIC && customNode.getArgsCount() > 0 && customNode.getArg(0).isThis()) {
                    callInsn.getArg(0).add(AFlag.THIS);
                }
                if (startArg >= 0) {
                    for (int i = startArg; i < callArgsCount; ++i) {
                        if (i != startArg) {
                            code.add(", ");
                        }
                        this.addArg(code, callInsn.getArg(i));
                    }
                } else {
                    code.add("/* ERROR: " + startArg + " */");
                }
                code.add(')');
            }
            code.add(" -> {");
            if (this.fallback) {
                code.add(" // ").add(implMthInfo.toString());
            }
            code.incIndent();
            code.startLine();
            if (!implMthInfo.getReturnType().isVoid()) {
                code.add("return ");
            }
            this.makeInsn(callInsn, code, Flags.INLINE);
            code.add(";");
            code.decIndent();
            code.startLine('}');
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to generate 'invoke-custom' instruction: " + e.getMessage(), e);
        }
    }

    private void makeInlinedLambdaMethod(ICodeWriter code, InvokeCustomNode customNode, MethodNode callMth) throws CodegenException {
        int startArg;
        MethodGen callMthGen = new MethodGen(this.mgen.getClassGen(), callMth);
        NameGen nameGen = callMthGen.getNameGen();
        nameGen.inheritUsedNames(this.mgen.getNameGen());
        List<ArgType> implArgs = customNode.getImplMthInfo().getArgumentsTypes();
        List<RegisterArg> callArgs = callMth.getArgRegs();
        if (implArgs.isEmpty()) {
            code.add("()");
        } else {
            int callArgsCount = callArgs.size();
            for (int i = startArg = callArgsCount - implArgs.size(); i < callArgsCount; ++i) {
                if (i != startArg) {
                    code.add(", ");
                }
                CodeVar argCodeVar = callArgs.get(i).getSVar().getCodeVar();
                this.defVar(code, argCodeVar);
            }
        }
        int extArgsCount = customNode.getArgsCount();
        startArg = customNode.getHandleType() == MethodHandleType.INVOKE_STATIC ? 0 : 1;
        int callArg = 0;
        for (int i = startArg; i < extArgsCount; ++i) {
            RegisterArg extArg = (RegisterArg)customNode.getArg(i);
            RegisterArg callRegArg = callArgs.get(callArg++);
            callRegArg.getSVar().setCodeVar(extArg.getSVar().getCodeVar());
        }
        code.add(" -> {");
        code.incIndent();
        callMthGen.addInstructions(code);
        code.decIndent();
        code.startLine('}');
    }

    private void callSuper(ICodeWriter code, MethodInfo callMth) {
        ClassInfo superCallCls = this.getClassForSuperCall(callMth);
        if (superCallCls == null) {
            code.add("super/*").add(callMth.getDeclClass().getFullName()).add("*/");
            return;
        }
        ClassInfo curClass = this.mth.getParentClass().getClassInfo();
        if (superCallCls.equals(curClass)) {
            code.add("super");
            return;
        }
        this.useClass(code, superCallCls);
        code.add(".super");
    }

    @Nullable
    private ClassInfo getClassForSuperCall(MethodInfo callMth) {
        ArgType declClsType = callMth.getDeclClass().getType();
        ClassNode parentNode = this.mth.getParentClass();
        ClassInfo parentCls;
        while (!ArgType.isInstanceOf(this.root, (parentCls = parentNode.getClassInfo()).getType(), declClsType)) {
            ClassNode nextParent = parentNode.getParentClass();
            if (nextParent == parentNode) {
                return null;
            }
            parentNode = nextParent;
        }
        return parentCls;
    }

    void generateMethodArguments(ICodeWriter code, BaseInvokeNode insn, int startArgNum, @Nullable MethodNode mthNode) throws CodegenException {
        int k = startArgNum;
        if (mthNode != null && mthNode.contains(AFlag.SKIP_FIRST_ARG)) {
            ++k;
        }
        int argsCount = insn.getArgsCount();
        code.add('(');
        boolean firstArg = true;
        if (k < argsCount) {
            for (int i = k; i < argsCount; ++i) {
                int argOrigPos;
                InsnArg arg = insn.getArg(i);
                if (arg.contains(AFlag.SKIP_ARG) || SkipMethodArgsAttr.isSkip(mthNode, argOrigPos = i - startArgNum)) continue;
                if (!firstArg) {
                    code.add(", ");
                } else {
                    firstArg = false;
                }
                if (i == argsCount - 1 && this.processVarArg(code, insn, arg)) continue;
                this.addArg(code, arg, false);
                firstArg = false;
            }
        }
        code.add(')');
    }

    private boolean processVarArg(ICodeWriter code, BaseInvokeNode invokeInsn, InsnArg lastArg) throws CodegenException {
        if (!invokeInsn.contains(AFlag.VARARG_CALL)) {
            return false;
        }
        if (!lastArg.getType().isArray() || !lastArg.isInsnWrap()) {
            return false;
        }
        InsnNode insn = ((InsnWrapArg)lastArg).getWrapInsn();
        if (insn.getType() != InsnType.FILLED_NEW_ARRAY) {
            return false;
        }
        int count = insn.getArgsCount();
        for (int i = 0; i < count; ++i) {
            InsnArg elemArg = insn.getArg(i);
            this.addArg(code, elemArg, false);
            if (i >= count - 1) continue;
            code.add(", ");
        }
        return true;
    }

    private void makeTernary(TernaryInsn insn, ICodeWriter code, Set<Flags> state) throws CodegenException {
        boolean wrap = state.contains((Object)Flags.BODY_ONLY);
        if (wrap) {
            code.add('(');
        }
        InsnArg first = insn.getArg(0);
        InsnArg second = insn.getArg(1);
        ConditionGen condGen = new ConditionGen(this);
        if (first.isTrue() && second.isFalse()) {
            condGen.add(code, insn.getCondition());
        } else {
            condGen.wrap(code, insn.getCondition());
            code.add(" ? ");
            this.addArg(code, first, false);
            code.add(" : ");
            this.addArg(code, second, false);
        }
        if (wrap) {
            code.add(')');
        }
    }

    private void makeArith(ArithNode insn, ICodeWriter code, Set<Flags> state) throws CodegenException {
        boolean wrap;
        if (insn.contains(AFlag.ARITH_ONEARG)) {
            this.makeArithOneArg(insn, code);
            return;
        }
        boolean bl = wrap = state.contains((Object)Flags.BODY_ONLY) && !insn.contains(AFlag.DONT_WRAP);
        if (wrap) {
            code.add('(');
        }
        this.addArg(code, insn.getArg(0));
        code.add(' ');
        code.add(insn.getOp().getSymbol());
        code.add(' ');
        this.addArg(code, insn.getArg(1));
        if (wrap) {
            code.add(')');
        }
    }

    private void makeArithOneArg(ArithNode insn, ICodeWriter code) throws CodegenException {
        LiteralArg lit;
        ArithOp op = insn.getOp();
        InsnArg resArg = insn.getArg(0);
        InsnArg arg = insn.getArg(1);
        if (arg.isLiteral() && (op == ArithOp.ADD || op == ArithOp.SUB) && (lit = (LiteralArg)arg).getLiteral() == 1L && lit.isInteger()) {
            this.addArg(code, resArg, false);
            String opSymbol = op.getSymbol();
            code.add(opSymbol).add(opSymbol);
            return;
        }
        this.addArg(code, resArg, false);
        code.add(' ').add(op.getSymbol()).add("= ");
        this.addArg(code, arg, false);
    }

    protected static enum Flags {
        BODY_ONLY,
        BODY_ONLY_NOWRAP,
        INLINE;

    }
}

