/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import jadx.api.ICodeInfo;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.IResParser;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResXmlGen;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.core.xmlgen.entry.EntryConfig;
import jadx.core.xmlgen.entry.ProtoValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ResProtoParser
implements IResParser {
    private final RootNode root;
    private final ResourceStorage resStorage = new ResourceStorage();

    public ResProtoParser(RootNode root) {
        this.root = root;
    }

    public ResContainer decodeFiles(InputStream inputStream) throws IOException {
        this.decode(inputStream);
        ValuesParser vp = new ValuesParser(new String[0], this.resStorage.getResourcesNames());
        ResXmlGen resGen = new ResXmlGen(this.resStorage, vp);
        ICodeInfo content = XmlGenUtils.makeXmlDump(this.root.makeCodeWriter(), this.resStorage);
        List<ResContainer> xmlFiles = resGen.makeResourcesXml();
        return ResContainer.resourceTable("res", xmlFiles, content);
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        Resources.ResourceTable table = Resources.ResourceTable.parseFrom((byte[])FileUtils.streamToByteArray(inputStream));
        for (Resources.Package p : table.getPackageList()) {
            this.parse(p);
        }
        this.resStorage.finish();
    }

    private void parse(Resources.Package p) {
        String name = p.getPackageName();
        this.resStorage.setAppPackage(name);
        this.parse(name, p.getTypeList());
    }

    private void parse(String packageName, List<Resources.Type> types) {
        for (Resources.Type type : types) {
            String typeName = type.getName();
            for (Resources.Entry entry : type.getEntryList()) {
                int id = entry.getEntryId().getId();
                String entryName = entry.getName();
                for (Resources.ConfigValue configValue : entry.getConfigValueList()) {
                    String config = this.parse(configValue.getConfig());
                    ResourceEntry resEntry = new ResourceEntry(id, packageName, typeName, entryName, config);
                    this.resStorage.add(resEntry);
                    ProtoValue protoValue = configValue.getValue().getValueCase() == Resources.Value.ValueCase.ITEM ? new ProtoValue(this.parse(configValue.getValue().getItem())) : this.parse(configValue.getValue().getCompoundValue());
                    resEntry.setProtoValue(protoValue);
                }
            }
        }
    }

    private ProtoValue parse(Resources.Style s) {
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(s.getEntryCount());
        String parent = s.getParent().getName();
        parent = parent.isEmpty() ? null : '@' + parent;
        for (int i = 0; i < s.getEntryCount(); ++i) {
            Resources.Style.Entry entry = s.getEntry(i);
            String name = entry.getKey().getName();
            String value = this.parse(entry.getItem());
            namedValues.add(new ProtoValue(value).setName(name));
        }
        return new ProtoValue().setNamedValues(namedValues).setParent(parent);
    }

    private ProtoValue parse(Resources.Styleable s) {
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(s.getEntryCount());
        for (int i = 0; i < s.getEntryCount(); ++i) {
            Resources.Styleable.Entry e = s.getEntry(i);
            namedValues.add(new ProtoValue('@' + e.getAttr().getName()));
        }
        return new ProtoValue().setNamedValues(namedValues);
    }

    private ProtoValue parse(Resources.Array a) {
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(a.getElementCount());
        for (int i = 0; i < a.getElementCount(); ++i) {
            Resources.Array.Element e = a.getElement(i);
            String value = this.parse(e.getItem());
            namedValues.add(new ProtoValue(value));
        }
        return new ProtoValue().setNamedValues(namedValues);
    }

    private ProtoValue parse(Resources.Attribute a) {
        String format = XmlGenUtils.getAttrTypeAsString(a.getFormatFlags());
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(a.getSymbolCount());
        for (int i = 0; i < a.getSymbolCount(); ++i) {
            Resources.Attribute.Symbol s = a.getSymbol(i);
            int type = s.getType();
            String name = s.getName().getName();
            String value = String.valueOf(s.getValue());
            namedValues.add(new ProtoValue(value).setName(name).setType(type));
        }
        return new ProtoValue(format).setNamedValues(namedValues);
    }

    private ProtoValue parse(Resources.Plural p) {
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(p.getEntryCount());
        for (int i = 0; i < p.getEntryCount(); ++i) {
            Resources.Plural.Entry e = p.getEntry(i);
            String name = e.getArity().name();
            String value = this.parse(e.getItem());
            namedValues.add(new ProtoValue(value).setName(name));
        }
        return new ProtoValue().setNamedValues(namedValues);
    }

    private ProtoValue parse(Resources.CompoundValue c) {
        switch (c.getValueCase()) {
            case STYLE: {
                return this.parse(c.getStyle());
            }
            case STYLEABLE: {
                return this.parse(c.getStyleable());
            }
            case ARRAY: {
                return this.parse(c.getArray());
            }
            case ATTR: {
                return this.parse(c.getAttr());
            }
            case PLURAL: {
                return this.parse(c.getPlural());
            }
        }
        return new ProtoValue("Unresolved value");
    }

    private String parse(ConfigurationOuterClass.Configuration c) {
        char[] language = c.getLocale().toCharArray();
        if (language.length == 0) {
            language = new char[]{'\u0000'};
        }
        short mcc = (short)c.getMcc();
        short mnc = (short)c.getMnc();
        byte orientation = (byte)c.getOrientationValue();
        short screenWidth = (short)c.getScreenWidth();
        short screenHeight = (short)c.getScreenHeight();
        short screenWidthDp = (short)c.getScreenWidthDp();
        short screenHeightDp = (short)c.getScreenHeightDp();
        short smallestScreenWidthDp = (short)c.getSmallestScreenWidthDp();
        short sdkVersion = (short)c.getSdkVersion();
        byte keyboard = (byte)c.getKeyboardValue();
        byte touchscreen = (byte)c.getTouchscreenValue();
        int density = c.getDensity();
        byte screenLayout = (byte)c.getScreenLayoutLongValue();
        byte colorMode = (byte)(c.getHdrValue() | c.getWideColorGamutValue());
        byte screenLayout2 = (byte)(c.getLayoutDirectionValue() | c.getScreenRoundValue());
        byte navigation = (byte)c.getNavigationValue();
        byte inputFlags = (byte)(c.getKeysHiddenValue() | c.getNavHiddenValue());
        int size = c.getSerializedSize();
        byte uiMode = (byte)(c.getUiModeNightValue() | c.getUiModeTypeValue());
        c.getScreenLayoutSize();
        c.getProduct();
        return new EntryConfig(mcc, mnc, language, new char[]{'\u0000'}, orientation, touchscreen, density, keyboard, navigation, inputFlags, screenWidth, screenHeight, sdkVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, new char[]{'\u0000'}, new char[]{'\u0000'}, screenLayout2, colorMode, false, size).getQualifiers();
    }

    private String parse(Resources.Item i) {
        if (i.hasRawStr()) {
            return i.getRawStr().getValue();
        }
        if (i.hasStr()) {
            return i.getStr().getValue();
        }
        if (i.hasStyledStr()) {
            return i.getStyledStr().getValue();
        }
        if (i.hasPrim()) {
            Resources.Primitive prim = i.getPrim();
            switch (prim.getOneofValueCase()) {
                case NULL_VALUE: {
                    return null;
                }
                case INT_DECIMAL_VALUE: {
                    return String.valueOf(prim.getIntDecimalValue());
                }
                case INT_HEXADECIMAL_VALUE: {
                    return Integer.toHexString(prim.getIntHexadecimalValue());
                }
                case BOOLEAN_VALUE: {
                    return String.valueOf(prim.getBooleanValue());
                }
                case FLOAT_VALUE: {
                    return String.valueOf(prim.getFloatValue());
                }
                case COLOR_ARGB4_VALUE: {
                    return String.format("#%04x", prim.getColorArgb4Value());
                }
                case COLOR_ARGB8_VALUE: {
                    return String.format("#%08x", prim.getColorArgb8Value());
                }
                case COLOR_RGB4_VALUE: {
                    return String.format("#%03x", prim.getColorRgb4Value());
                }
                case COLOR_RGB8_VALUE: {
                    return String.format("#%06x", prim.getColorRgb8Value());
                }
                case DIMENSION_VALUE: {
                    return XmlGenUtils.decodeComplex(prim.getDimensionValue(), false);
                }
                case FRACTION_VALUE: {
                    return XmlGenUtils.decodeComplex(prim.getDimensionValue(), true);
                }
            }
            return "";
        }
        if (i.hasRef()) {
            return '@' + i.getRef().getName();
        }
        if (i.hasFile()) {
            return i.getFile().getPath();
        }
        return "";
    }

    @Override
    public ResourceStorage getResStorage() {
        return this.resStorage;
    }

    @Override
    public String[] getStrings() {
        return new String[0];
    }
}

