/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import ch.qos.logback.classic.Level;
import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.logs.ILogListener;
import jadx.gui.utils.logs.LogCollector;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class LogViewerDialog
extends JFrame {
    private static final long serialVersionUID = -2188700277429054641L;
    private static final Level[] LEVEL_ITEMS = new Level[]{Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR};
    private static Level level = Level.WARN;
    private final transient JadxSettings settings;
    private transient RSyntaxTextArea textPane;
    private JComboBox<Level> levelCb;
    private static LogViewerDialog openLogDialog;

    public static void open(MainWindow mainWindow) {
        LogViewerDialog.openWithLevel(mainWindow, level);
    }

    public static void openWithLevel(MainWindow mainWindow, Level newLevel) {
        level = newLevel;
        if (openLogDialog == null) {
            LogViewerDialog newLogDialog = new LogViewerDialog(mainWindow);
            newLogDialog.setVisible(true);
            openLogDialog = newLogDialog;
        } else {
            LogViewerDialog logDialog = openLogDialog;
            logDialog.levelCb.setSelectedItem(level);
            logDialog.setVisible(true);
            logDialog.toFront();
        }
    }

    private LogViewerDialog(MainWindow mainWindow) {
        this.settings = mainWindow.getSettings();
        this.initUI(mainWindow);
        this.registerLogListener();
        this.settings.loadWindowPos(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                openLogDialog = null;
            }
        });
    }

    public final void initUI(MainWindow mainWindow) {
        UiUtils.setWindowIcons(this);
        this.textPane = AbstractCodeArea.getDefaultArea(mainWindow);
        this.textPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel controlPane = new JPanel();
        controlPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.levelCb = new JComboBox<Level>(LEVEL_ITEMS);
        this.levelCb.setSelectedItem(level);
        this.levelCb.addActionListener(e -> {
            int i = this.levelCb.getSelectedIndex();
            level = LEVEL_ITEMS[i];
            this.registerLogListener();
        });
        JLabel levelLabel = new JLabel(NLS.str("log_viewer.log_level"));
        levelLabel.setLabelFor(this.levelCb);
        controlPane.add(levelLabel);
        controlPane.add(this.levelCb);
        JScrollPane scrollPane = new JScrollPane((Component)this.textPane);
        JButton close = new JButton(NLS.str("tabs.close"));
        close.addActionListener(event -> this.close());
        close.setAlignmentX(0.5f);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)controlPane, "First");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)close, "Last");
        this.setTitle(NLS.str("log_viewer.title"));
        this.pack();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
    }

    private void registerLogListener() {
        LogCollector logCollector = LogCollector.getInstance();
        logCollector.resetListener();
        this.textPane.setText("");
        logCollector.registerListener(new ILogListener(){

            @Override
            public Level getFilterLevel() {
                return level;
            }

            @Override
            public void onAppend(String logStr) {
                SwingUtilities.invokeLater(() -> LogViewerDialog.this.textPane.append(logStr));
            }
        });
    }

    private void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        LogCollector.getInstance().resetListener();
        this.settings.saveWindowPos(this);
        super.dispose();
    }
}

