/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ThreadMonitor {
    private MBeanServerConnection server;
    private ThreadMXBean tmbean;
    private ObjectName objname;
    private String findDeadlocksMethodName = "findDeadlockedThreads";
    private boolean canDumpLocks = true;
    private static String INDENT = "    ";

    public ThreadMonitor(MBeanServerConnection mBeanServerConnection) throws IOException {
        this.server = mBeanServerConnection;
        this.tmbean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Threading", ThreadMXBean.class);
        try {
            this.objname = new ObjectName("java.lang:type=Threading");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            InternalError internalError = new InternalError(malformedObjectNameException.getMessage());
            internalError.initCause(malformedObjectNameException);
            throw internalError;
        }
        this.parseMBeanInfo();
    }

    public ThreadMonitor() {
        this.tmbean = ManagementFactory.getThreadMXBean();
    }

    public void threadDump() {
        if (this.canDumpLocks) {
            if (this.tmbean.isObjectMonitorUsageSupported() && this.tmbean.isSynchronizerUsageSupported()) {
                this.dumpThreadInfoWithLocks();
            }
        } else {
            this.dumpThreadInfo();
        }
    }

    private void dumpThreadInfo() {
        ThreadInfo[] threadInfoArray;
        System.out.println("Full Java thread dump");
        long[] lArray = this.tmbean.getAllThreadIds();
        for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.getThreadInfo(lArray, Integer.MAX_VALUE)) {
            this.printThreadInfo(threadInfo);
        }
    }

    private void dumpThreadInfoWithLocks() {
        ThreadInfo[] threadInfoArray;
        System.out.println("Full Java thread dump with locks info");
        for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.dumpAllThreads(true, true)) {
            this.printThreadInfo(threadInfo);
            LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
            this.printLockInfo(lockInfoArray);
        }
        System.out.println();
    }

    private void printThreadInfo(ThreadInfo threadInfo) {
        this.printThread(threadInfo);
        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            System.out.println(INDENT + "at " + stackTraceElement.toString());
            for (MonitorInfo monitorInfo : monitorInfoArray) {
                if (monitorInfo.getLockedStackDepth() != i) continue;
                System.out.println(INDENT + "  - locked " + monitorInfo);
            }
        }
        System.out.println();
    }

    private void printThread(ThreadInfo threadInfo) {
        StringBuilder stringBuilder = new StringBuilder("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId() + " in " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            stringBuilder.append(" on lock=" + threadInfo.getLockName());
        }
        if (threadInfo.isSuspended()) {
            stringBuilder.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            stringBuilder.append(" (running in native)");
        }
        System.out.println(stringBuilder.toString());
        if (threadInfo.getLockOwnerName() != null) {
            System.out.println(INDENT + " owned by " + threadInfo.getLockOwnerName() + " Id=" + threadInfo.getLockOwnerId());
        }
    }

    private void printMonitorInfo(ThreadInfo threadInfo) {
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        System.out.println(INDENT + "Locked monitors: count = " + monitorInfoArray.length);
        for (MonitorInfo monitorInfo : monitorInfoArray) {
            System.out.println(INDENT + "  - " + monitorInfo + " locked at ");
            System.out.println(INDENT + "      " + monitorInfo.getLockedStackDepth() + " " + monitorInfo.getLockedStackFrame());
        }
    }

    private void printLockInfo(LockInfo[] lockInfoArray) {
        System.out.println(INDENT + "Locked synchronizers: count = " + lockInfoArray.length);
        for (LockInfo lockInfo : lockInfoArray) {
            System.out.println(INDENT + "  - " + lockInfo);
        }
        System.out.println();
    }

    public boolean findDeadlock() {
        if (this.findDeadlocksMethodName.equals("findDeadlockedThreads") && this.tmbean.isSynchronizerUsageSupported()) {
            ThreadInfo[] threadInfoArray;
            long[] lArray = this.tmbean.findDeadlockedThreads();
            if (lArray == null) {
                return false;
            }
            System.out.println("Deadlock found :-");
            for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.getThreadInfo(lArray, true, true)) {
                this.printThreadInfo(threadInfo);
                this.printMonitorInfo(threadInfo);
                this.printLockInfo(threadInfo.getLockedSynchronizers());
                System.out.println();
            }
        } else {
            ThreadInfo[] threadInfoArray;
            long[] lArray = this.tmbean.findMonitorDeadlockedThreads();
            if (lArray == null) {
                return false;
            }
            for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.getThreadInfo(lArray, Integer.MAX_VALUE)) {
                this.printThreadInfo(threadInfo);
            }
        }
        return true;
    }

    private void parseMBeanInfo() throws IOException {
        try {
            MBeanOperationInfo[] mBeanOperationInfoArray = this.server.getMBeanInfo(this.objname).getOperations();
            boolean bl = false;
            for (MBeanOperationInfo mBeanOperationInfo : mBeanOperationInfoArray) {
                if (!mBeanOperationInfo.getName().equals(this.findDeadlocksMethodName)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.findDeadlocksMethodName = "findMonitorDeadlockedThreads";
                this.canDumpLocks = false;
            }
        }
        catch (IntrospectionException introspectionException) {
            InternalError internalError = new InternalError(introspectionException.getMessage());
            internalError.initCause(introspectionException);
            throw internalError;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            InternalError internalError = new InternalError(instanceNotFoundException.getMessage());
            internalError.initCause(instanceNotFoundException);
            throw internalError;
        }
        catch (ReflectionException reflectionException) {
            InternalError internalError = new InternalError(reflectionException.getMessage());
            internalError.initCause(reflectionException);
            throw internalError;
        }
    }
}

