/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Utils;

public final class CertificateAmendment {
    private static final EmbeddedCertAmend[] CERT_AMEND = new EmbeddedCertAmend[0];
    private static final NativeCertAmend[] PLATFORM_CERT_AMEND = new NativeCertAmend[]{new NativeCertAmend("DST Root CA X3", "DST Root CA X3", "DST_Root_CA_X3.pem", "0687260331a72403d909f105e69bcf0d32e1bd2493ffc6d9206d11bcd6770739", "https://acme-v02.api.letsencrypt.org"), new NativeCertAmend("Staat der Nederlanden Root CA - G2", "Staat der Nederlanden Root CA - G2", "Staat_der_Nederlanden_Root_CA_-_G2.crt", "668c83947da63b724bece1743c31a0e6aed0db8ec5b31be377bb784f91b6716f", "https://roottest-g2.pkioverheid.nl"), new NativeCertAmend("Government of Netherlands G3", "Staat der Nederlanden Root CA - G3", "Staat_der_Nederlanden_Root_CA_-_G3.crt", "3c4fb0b95ab8b30032f432b86f535fe172c185d0fd39865837cf36187fa6f428", "https://roottest-g3.pkioverheid.nl"), new NativeCertAmend("Certigna", "Certigna", "Certigna.crt", "e3b6a2db2ed7ce48842f7ac53241c7b71d54144bfb40c11f3f1d0b42f5eea12d", "https://www.certigna.fr"), new NativeCertAmend("CA Disig Root R2", "CA Disig Root R2", "CA_Disig_Root_R2.pem", "e23d4a036d7b70e9f595b1422079d2b91edfbb1fb651a0633eaa8a9dc5f80703", "https://eidas.disig.sk"), new NativeCertAmend("Government Root Certification Authority", "Government Root Certification Authority", "Taiwan_GRCA.pem", "7600295eefe85b9e1fd624db76062aaaae59818a54d2774cd4c0b2c01131e1b3", "https://grca.nat.gov.tw")};

    private CertificateAmendment() {
    }

    public static void addMissingCertificates() throws IOException, GeneralSecurityException {
        if (!Config.getPref().getBoolean("tls.add-missing-certificates", true)) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Path cacertsPath = Paths.get(Utils.getSystemProperty("java.home"), "lib", "security", "cacerts");
        try (InputStream is = Files.newInputStream(cacertsPath, new OpenOption[0]);){
            keyStore.load(is, "changeit".toCharArray());
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to load keystore", e);
            return;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        boolean certificateAdded = false;
        for (EmbeddedCertAmend embeddedCertAmend : CERT_AMEND) {
            try (CachedFile certCF = new CachedFile(embeddedCertAmend.url);){
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certCF.getByteContent()));
                if (!CertificateAmendment.checkAndAddCertificate(md, cert, embeddedCertAmend, keyStore)) continue;
                certificateAdded = true;
            }
        }
        try {
            for (CertAmend certAmend : PLATFORM_CERT_AMEND) {
                X509Certificate cert = PlatformManager.getPlatform().getX509Certificate((NativeCertAmend)certAmend);
                if (!CertificateAmendment.checkAndAddCertificate(md, cert, certAmend, keyStore)) continue;
                certificateAdded = true;
            }
        }
        catch (IOException | IllegalStateException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Logging.error(e);
        }
        if (certificateAdded) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, tmf.getTrustManagers(), null);
            SSLContext.setDefault(sslContext);
        }
    }

    private static boolean checkAndAddCertificate(MessageDigest md, X509Certificate cert, CertAmend certAmend, KeyStore keyStore) throws CertificateEncodingException, KeyStoreException, InvalidAlgorithmParameterException {
        if (cert != null) {
            String sha256 = Utils.toHexString(md.digest(cert.getEncoded()));
            if (!certAmend.sha256.equals(sha256)) {
                throw new IllegalStateException(I18n.tr("Error adding certificate {0} - certificate fingerprint mismatch. Expected {1}, was {2}", certAmend, certAmend.sha256, sha256));
            }
            if (CertificateAmendment.certificateIsMissing(keyStore, cert)) {
                if (Logging.isDebugEnabled()) {
                    Logging.debug(I18n.tr("Adding certificate for TLS connections: {0}", cert.getSubjectX500Principal().getName()));
                }
                String alias = "josm:" + certAmend.filename;
                keyStore.setCertificateEntry(alias, cert);
                return true;
            }
        }
        return false;
    }

    private static boolean certificateIsMissing(KeyStore keyStore, X509Certificate crt) throws KeyStoreException, InvalidAlgorithmParameterException {
        PKIXParameters params = new PKIXParameters(keyStore);
        String id = crt.getSubjectX500Principal().getName();
        for (TrustAnchor ta : params.getTrustAnchors()) {
            X509Certificate cert = ta.getTrustedCert();
            if (!Objects.equals(id, cert.getSubjectX500Principal().getName())) continue;
            return false;
        }
        return true;
    }

    public static class NativeCertAmend
    extends CertAmend {
        private final String winAlias;
        private final String macAlias;
        private final String httpsWebSite;

        NativeCertAmend(String winAlias, String macAlias, String filename, String sha256, String httpsWebSite) {
            super(filename, sha256);
            this.winAlias = Objects.requireNonNull(winAlias);
            this.macAlias = Objects.requireNonNull(macAlias);
            this.httpsWebSite = Objects.requireNonNull(httpsWebSite);
        }

        public final String getWinAlias() {
            return this.winAlias;
        }

        public final String getMacAlias() {
            return this.macAlias;
        }

        public String getWebSite() {
            return this.httpsWebSite;
        }

        public String toString() {
            String result = this.winAlias;
            if (!this.winAlias.equals(this.macAlias)) {
                result = result + " / " + this.macAlias;
            }
            return result;
        }
    }

    public static class EmbeddedCertAmend
    extends CertAmend {
        private final String url;

        EmbeddedCertAmend(String url, String filename, String sha256) {
            super(filename, sha256);
            this.url = Objects.requireNonNull(url);
        }

        public final String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.url;
        }
    }

    public static class CertAmend {
        private final String filename;
        private final String sha256;

        protected CertAmend(String filename, String sha256) {
            this.filename = Objects.requireNonNull(filename);
            this.sha256 = Objects.requireNonNull(sha256);
        }

        public final String getFilename() {
            return this.filename;
        }

        public final String getSha256() {
            return this.sha256;
        }
    }
}

