/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.tree;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBSingleSelectionModel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.NameUtility;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.DataListener;
import com.ca.directory.jxplorer.DataQuery;
import com.ca.directory.jxplorer.DataSink;
import com.ca.directory.jxplorer.DataSource;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class NewEntryWin
extends CBDialog
implements ActionListener,
DataListener {
    JTextField rdnField;
    JTextField parentDNField;
    JScrollPane possiblePanel;
    JList possibleList;
    JScrollPane selectedPanel;
    JList selectedList;
    DefaultListModel selDataModel;
    DefaultListModel posDataModel;
    DataSink entryEditor;
    JCheckBox autoSuggest;
    CBButton select;
    CBButton remove;
    static boolean suggest = true;
    Vector suggestedClasses = new Vector();
    DataSource dataSource;
    DN parentDN;
    DN childDN;
    DN entryDN = null;
    DXAttributes defaultAttributes = null;
    protected CBHelpSystem helpBroker;
    String objectClassName = null;
    private static Logger log = Logger.getLogger(NewEntryWin.class.getName());
    protected boolean simpleMode;
    protected boolean disableName = false;
    boolean virtualEntry = false;
    public BasicAttribute newObjectClasses = null;

    public NewEntryWin(DN pDN, DN cDN, DataSource dSource, DataSink attDisplay, Frame parent) {
        this(pDN, cDN, dSource, null, null, attDisplay, parent);
        this.disableName = false;
        this.rdnField.setEnabled(true);
        this.parentDNField.setEnabled(true);
    }

    public NewEntryWin(DN pDN, DN cDN, DataSource dSource, Attributes defaultValues, String rdn, DataSink attDisplay, Frame parent) {
        super(parent, CBIntText.get("Set Entry Object Classes"), "entry.new");
        this.simpleMode = false;
        this.dataSource = dSource;
        this.entryEditor = attDisplay;
        if (defaultValues != null) {
            this.defaultAttributes = defaultValues instanceof DXAttributes ? (DXAttributes)defaultValues : new DXAttributes(this.defaultAttributes);
        }
        try {
            this.objectClassName = this.dataSource.getSchemaOps().getNameOfObjectClassAttribute();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.parentDN = pDN;
        this.childDN = cDN;
        this.getContentPane().add(this.display);
        this.autoSuggest = new JCheckBox(CBIntText.get("Suggest Classes?"), suggest);
        this.display.add((Component)this.autoSuggest, 3, 0);
        this.display.newLine();
        this.display.add(new JLabel(CBIntText.get("Parent DN") + ": "));
        this.parentDNField = new JTextField(this.parentDN.toString(), 20);
        this.display.addLine(this.parentDNField);
        this.parentDNField.setEnabled(false);
        this.display.add(new JLabel(CBIntText.get("Enter RDN") + ": "));
        this.rdnField = new JTextField("=", 20);
        this.display.addLine(this.rdnField);
        if (rdn != null) {
            this.rdnField.setText(rdn);
            this.rdnField.setEnabled(false);
        } else if (suggest && this.childDN != null) {
            this.rdnField.setText(this.childDN.getLowestRDN().getAtt() + "=");
        }
        this.setupObjectClassPanels(null);
        this.autoSuggest.addActionListener(this);
        this.registerMouseListeners();
    }

    public NewEntryWin(DataSource dSource, DN entryDN, Attributes defaultValues, DataSink attDisplay, Frame parent) {
        super(parent, CBIntText.get("Set Entry Object Classes"), "class.change");
        this.simpleMode = true;
        this.entryDN = entryDN;
        this.dataSource = dSource;
        this.entryEditor = attDisplay;
        this.defaultAttributes = defaultValues instanceof DXAttributes ? (DXAttributes)defaultValues : new DXAttributes(this.defaultAttributes);
        try {
            this.objectClassName = this.dataSource.getSchemaOps().getNameOfObjectClassAttribute();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getContentPane().add(this.display);
        this.setupObjectClassPanels(this.defaultAttributes);
        this.registerMouseListeners();
    }

    public NewEntryWin(DataSource dSource, DN entryDN, DataSink attDisplay, Frame parent, boolean virtualEntry) {
        super(parent, CBIntText.get("Set Entry Object Classes"), "class.change");
        this.virtualEntry = virtualEntry;
        this.simpleMode = true;
        this.entryDN = entryDN;
        this.dataSource = dSource;
        this.entryEditor = attDisplay;
        this.getContentPane().add(this.display);
        this.setupObjectClassPanels(null);
        this.registerMouseListeners();
    }

    protected void setupObjectClassPanels(Attributes currentAtts) {
        this.display.addWide(new JLabel(CBIntText.get("Available Classes") + ": "), 2);
        this.display.addWide(new JLabel(CBIntText.get("Selected Classes") + ": "), 2);
        this.display.newLine();
        this.selDataModel = new DefaultListModel();
        this.selectedList = new JList(this.selDataModel);
        this.selectedList.setSelectionMode(0);
        this.selectedList.setSelectionModel(new CBSingleSelectionModel(this.selectedList));
        this.posDataModel = new DefaultListModel();
        this.possibleList = new JList(this.posDataModel);
        this.possibleList.setSelectionMode(0);
        this.possibleList.setSelectionModel(new CBSingleSelectionModel(this.possibleList));
        this.possiblePanel = new JScrollPane(this.possibleList);
        this.selectedPanel = new JScrollPane(this.selectedList);
        if (currentAtts != null) {
            Attribute objectClasses = currentAtts.get(this.objectClassName);
            try {
                NamingEnumeration<?> recommendedObjectClasses = objectClasses.getAll();
                while (recommendedObjectClasses.hasMoreElements()) {
                    String oc = (String)recommendedObjectClasses.nextElement();
                    this.selDataModel.addElement(oc);
                    this.suggestedClasses.add(oc);
                }
            }
            catch (Exception e) {}
        } else if (this.childDN != null) {
            DataQuery myQuery = this.dataSource.getRecommendedObjectClasses(this.childDN);
            myQuery.addDataListener(this);
        }
        try {
            ArrayList allObjectClasses = this.dataSource.getSchemaOps().objectClasses();
            for (int i = 0; i < allObjectClasses.size(); ++i) {
                this.posDataModel.addElement(allObjectClasses.get(i));
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        Enumeration existing = this.selDataModel.elements();
        while (existing.hasMoreElements()) {
            this.posDataModel.removeElement(existing.nextElement());
        }
        this.display.makeHeavy();
        this.display.add(this.possiblePanel, 0, 4, 2, 2);
        this.display.add(this.selectedPanel, 2, 4, 2, 2);
        this.display.makeLight();
        this.display.newLine();
        this.select = new CBButton(CBIntText.get("Add"), CBIntText.get("Click to add the selection."));
        this.remove = new CBButton(CBIntText.get("Remove"), CBIntText.get("Click to remove the selection."));
        this.display.addWide(this.select, 2);
        this.display.addWide(this.remove, 2);
        this.display.newLine();
        this.validate();
        this.select.addActionListener(this);
        this.remove.addActionListener(this);
    }

    public void dataReady(DataQuery result) {
        try {
            if (result.getType() == 128) {
                if (this.suggestedClasses.size() < 1) {
                    ArrayList recommendedObjectClasses = result.getObjectClasses();
                    for (int i = 0; i < recommendedObjectClasses.size(); ++i) {
                        this.suggestedClasses.addElement(recommendedObjectClasses.get(i));
                    }
                }
                this.checkSuggestedList();
            }
        }
        catch (NamingException e) {
            CBUtility.error(CBIntText.get("threaded broker error: "), e);
        }
    }

    protected void checkSuggestedList() {
        if (suggest && this.suggestedClasses.size() > 0) {
            for (int i = 0; i < this.suggestedClasses.size(); ++i) {
                this.selectClass((String)this.suggestedClasses.get(i));
            }
        }
    }

    public void registerMouseListeners() {
        this.possibleList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NewEntryWin.this.selectClass((String)NewEntryWin.this.possibleList.getSelectedValue());
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.selectedList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NewEntryWin.this.removeClass((String)NewEntryWin.this.selectedList.getSelectedValue());
                } else {
                    super.mouseClicked(e);
                }
            }
        });
    }

    public void selectClass(String value) {
        if (!this.selDataModel.contains(value)) {
            this.selDataModel.addElement(value);
            this.posDataModel.removeElement(value);
        }
    }

    public void removeClass(String value) {
        if (this.selDataModel.contains(value)) {
            this.selDataModel.removeElement(value);
            if (!this.posDataModel.contains(value)) {
                Object[] possibleValues = this.posDataModel.toArray();
                int len = possibleValues.length;
                for (int i = 0; i < len; ++i) {
                    if (value.compareTo(possibleValues[i].toString()) > 0) continue;
                    this.posDataModel.add(i, value);
                    break;
                }
            }
        }
    }

    public void doOK() {
        Enumeration atts;
        String rdnText = null;
        if (!this.simpleMode) {
            rdnText = this.rdnField.getText().trim();
            int equalpos = rdnText.indexOf(61);
            rdnText = rdnText.substring(0, equalpos + 1) + NameUtility.escape(rdnText.substring(equalpos + 1));
            try {
                if (rdnText == null || "".equals(rdnText)) {
                    throw new InvalidNameException(CBIntText.get("Empty RDN, please enter a valid RDN. ") + (rdnText == null ? "<null>" : CBIntText.get("The RDN value entered was: '") + rdnText) + "'");
                }
                if (NameUtility.next(rdnText, 0, '=') < 0) {
                    throw new InvalidNameException(CBIntText.get("Invalid RDN, please enter a naming attribute followed by '=' followed by a name in the RDN field (for example, 'cn=Trudi). '") + (rdnText == null ? "<null>" : CBIntText.get("The RDN value entered was: '") + rdnText) + "'");
                }
                if (NameUtility.next(rdnText, 0, '=') < 1) {
                    throw new InvalidNameException(CBIntText.get("Invalid RDN, please enter a naming attribute in the RDN field (for example, cn: 'cn=Trudi). '") + (rdnText == null ? "<null>" : CBIntText.get("The RDN value entered was: '") + rdnText) + "'");
                }
            }
            catch (InvalidNameException ine) {
                CBUtility.warning(this, CBIntText.get("Please Fill in the RDN field with a valid RDN."), CBIntText.get("Invalid RDN"));
                log.log(Level.WARNING, "Invalid RDN value in the New Entry dialog: ", ine);
                return;
            }
            String dn = this.parentDNField.getText().trim().length() > 0 ? rdnText + "," + this.parentDNField.getText() : rdnText;
            this.entryDN = new DN(dn);
        }
        if ((atts = this.selDataModel.elements()) == null) {
            CBUtility.warning(this, CBIntText.get("At least one object class must be selected!"), CBIntText.get("Need ObjectClass(s)"));
            return;
        }
        BasicAttribute obclasses = new BasicAttribute(this.objectClassName == null ? "objectClass" : this.objectClassName);
        while (atts.hasMoreElements()) {
            String oc = atts.nextElement().toString();
            obclasses.add(oc);
        }
        if (obclasses.size() == 0) {
            CBUtility.warning(this, CBIntText.get("At least one object class must be selected."), CBIntText.get(" Need ObjectClass(s)"));
            return;
        }
        if (this.virtualEntry) {
            this.newObjectClasses = obclasses;
            this.doCancel();
        }
        if (this.createNewEntry(obclasses, rdnText, this.entryDN)) {
            this.doCancel();
        }
    }

    public void doCancel() {
        this.setVisible(false);
        this.dispose();
        this.getParent().repaint();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.select) {
            if (this.possibleList.getSelectedValue() != null) {
                this.selectClass(this.possibleList.getSelectedValue().toString());
            }
        } else if (src == this.remove) {
            if (this.selectedList.getSelectedValue() != null) {
                this.removeClass(this.selectedList.getSelectedValue().toString());
            }
        } else if (src == this.autoSuggest) {
            suggest = this.autoSuggest.isSelected();
            if (suggest) {
                this.checkSuggestedList();
            } else if (this.suggestedClasses.size() > 0) {
                for (int i = 0; i < this.suggestedClasses.size(); ++i) {
                    this.removeClass((String)this.suggestedClasses.get(i));
                }
            }
        }
    }

    public boolean createNewEntry(Attribute obclasses, String rdnText, DN newObjectDN) {
        DXAttributes attlist = new DXAttributes(obclasses);
        Attribute allObjectClasses = attlist.getAllObjectClasses();
        if (allObjectClasses == null) {
            return false;
        }
        attlist.put(allObjectClasses);
        attlist.expandAllAttributes();
        if (this.defaultAttributes != null) {
            DXNamingEnumeration defAtts = (DXNamingEnumeration)this.defaultAttributes.getAllNonNull();
            while (defAtts.hasMore()) {
                Attribute defAtt = (Attribute)defAtts.next();
                String defAttName = defAtt.getID();
                if (defAttName.equalsIgnoreCase("objectclass") || attlist.get(defAttName) == null) continue;
                attlist.put(defAtt);
            }
        }
        if (rdnText != null) {
            RDN rdn = new RDN(rdnText);
            if (rdn.size() == 0 || "".equals(rdn.getRawVal(0))) {
                CBUtility.warning(this, CBIntText.get("Please fill in a valid name for the entry"), CBIntText.get("Can't read RDN"));
                return false;
            }
            String rdnAttribute = rdn.getAtt(0);
            String rdnValue = rdn.getRawVal(0);
            if (!rdn.isMultiValued()) {
                BasicAttribute rdnAtt = new BasicAttribute(rdnAttribute, rdnValue);
                attlist.put(rdnAtt);
            } else {
                for (int i = 0; i < rdn.size(); ++i) {
                    BasicAttribute rdnAtt = new BasicAttribute(rdn.getAtt(i), rdn.getRawVal(i));
                    attlist.put(rdnAtt);
                }
            }
            if (!rdn.validate()) {
                CBUtility.warning(this, CBIntText.get("Couldn't parse entry's name - please try again"), CBIntText.get("Can't read RDN"));
                return false;
            }
        }
        this.setVisible(false);
        this.getParent().repaint();
        if (this.dataSource == null) {
            CBUtility.error(CBIntText.get("unusual error:") + "\nno Data Source registered in NewEntryWin.", null);
            return false;
        }
        log.fine("creating entry " + newObjectDN);
        DXEntry newEntry = new DXEntry(attlist, newObjectDN);
        newEntry.setStatus(1);
        this.entryEditor.displayEntry(newEntry, this.dataSource);
        return true;
    }
}

