/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.sampled.AudioFormats;

public class AudioUtils {
    public static long getLengthInBytes(AudioInputStream audioInputStream) {
        return AudioUtils.getLengthInBytes(audioInputStream.getFormat(), audioInputStream.getFrameLength());
    }

    public static long getLengthInBytes(AudioFormat audioFormat, long lLengthInFrames) {
        int nFrameSize = audioFormat.getFrameSize();
        if (lLengthInFrames >= 0L && nFrameSize >= 1) {
            return lLengthInFrames * (long)nFrameSize;
        }
        return -1L;
    }

    public static boolean containsFormat(AudioFormat sourceFormat, Iterator possibleFormats) {
        while (possibleFormats.hasNext()) {
            AudioFormat format = (AudioFormat)possibleFormats.next();
            if (!AudioFormats.matches(format, sourceFormat)) continue;
            return true;
        }
        return false;
    }

    public static long millis2Bytes(long ms, AudioFormat format) {
        return AudioUtils.millis2Bytes(ms, format.getFrameRate(), format.getFrameSize());
    }

    public static long millis2Bytes(long ms, float frameRate, int frameSize) {
        return (long)((float)ms * frameRate / 1000.0f * (float)frameSize);
    }

    public static long millis2BytesFrameAligned(long ms, AudioFormat format) {
        return AudioUtils.millis2BytesFrameAligned(ms, format.getFrameRate(), format.getFrameSize());
    }

    public static long millis2BytesFrameAligned(long ms, float frameRate, int frameSize) {
        return (long)((float)ms * frameRate / 1000.0f) * (long)frameSize;
    }

    public static long millis2Frames(long ms, AudioFormat format) {
        return AudioUtils.millis2Frames(ms, format.getFrameRate());
    }

    public static long millis2Frames(long ms, float frameRate) {
        return (long)((float)ms * frameRate / 1000.0f);
    }

    public static long bytes2Millis(long bytes, AudioFormat format) {
        return (long)((float)bytes / format.getFrameRate() * 1000.0f / (float)format.getFrameSize());
    }

    public static long frames2Millis(long frames, AudioFormat format) {
        return (long)((float)frames / format.getFrameRate() * 1000.0f);
    }

    public static String NS_or_number(int number) {
        return number == -1 ? "NOT_SPECIFIED" : String.valueOf(number);
    }

    public static String NS_or_number(float number) {
        return number == -1.0f ? "NOT_SPECIFIED" : String.valueOf(number);
    }

    public static String format2ShortStr(AudioFormat format) {
        return format.getEncoding() + "-" + AudioUtils.NS_or_number(format.getChannels()) + "ch-" + AudioUtils.NS_or_number(format.getSampleSizeInBits()) + "bit-" + AudioUtils.NS_or_number((int)format.getSampleRate()) + "Hz-" + (format.isBigEndian() ? "be" : "le");
    }
}

