/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawAble;
import de.escape.quincunx.dxf.DrawSet;
import de.escape.quincunx.dxf.DxfColorModel;
import de.escape.quincunx.dxf.DxfViewer;
import de.escape.quincunx.dxf.LineStyle;
import de.escape.quincunx.dxf.LineStyleManager;
import de.escape.quincunx.dxf.SegmentWalker;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.gimmicks.Clipping;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Hashtable;

public class DrawLines
extends DrawAble {
    private static final boolean CLIP_LINES = true;
    private static final float MAX_HEURISTIC_OFFSET = 10000.0f;
    protected static final int FLAG_DIFFERENT_REPRESENTATIONS = 1;
    protected static final int FLAG_CONSTANT_REPRESENTATION = 2;
    protected static final int FLAG_CONTINUOUS = 4;
    protected static final int FLAG_DRAW_DIRECT = 6;
    protected Point3D[] line;
    protected int nrPoints;
    protected boolean isClosed;
    protected Hashtable representations;
    protected int flags;
    protected float length = -1.0f;
    protected DrawAble representation;

    public DrawLines() {
    }

    public DrawLines(int nr) {
        if (nr > 0) {
            this.line = new Point3D[nr];
        }
    }

    protected static void drawLine(Graphics g, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (z1 < 0 || z2 < 0) {
            boolean bl = z1 < 0 && z2 < 0;
        } else {
            Clipping.drawLine(g, x1, y1, x2, y2, g.getClipBounds());
        }
    }

    public static void drawPoly(Graphics g, int nrPoints, int[] px, int[] py, int[] pz, Color col) {
        boolean zLess0 = false;
        int i = 0;
        while (i < nrPoints) {
            if (pz[i] <= 0) {
                zLess0 = true;
                break;
            }
            ++i;
        }
        g.setColor(col);
        if (zLess0) {
            int i2 = nrPoints - 1;
            while (i2 > 0) {
                DrawLines.drawLine(g, px[i2], py[i2], pz[i2], px[i2 - 1], py[i2 - 1], pz[i2 - 1]);
                --i2;
            }
        } else {
            Clipping.drawPolyline(g, px, py, nrPoints, g.getClipBounds());
        }
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insertLayer, DxfColorModel colors, short insertColor) {
        if (!this.isVisible(insertLayer)) {
            return;
        }
        if (this.nrPoints > 0) {
            short activeColor = this.calcColor(insertColor, insertLayer);
            int[] px = new int[this.nrPoints + (this.isClosed ? 1 : 0)];
            int[] py = new int[this.nrPoints + (this.isClosed ? 1 : 0)];
            int[] pz = new int[this.nrPoints + (this.isClosed ? 1 : 0)];
            mat.transform(this.line, px, py, pz, this.nrPoints);
            if (this.isClosed) {
                px[this.nrPoints] = px[0];
                py[this.nrPoints] = py[0];
                pz[this.nrPoints] = pz[0];
                DrawLines.drawPoly(g, this.nrPoints + 1, px, py, pz, colors.getColor(activeColor));
            } else {
                DrawLines.drawPoly(g, this.nrPoints, px, py, pz, colors.getColor(activeColor));
            }
        }
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colors, short insColor, int nr, int maxNr) {
        if (nr == 0) {
            this.draw(g, mat, insLayer, colors, insColor);
        }
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colorModel, short insColor, LineStyleManager lineStyles, LineStyle insLStyle) {
        if (this.flags == 0) {
            if (this.lineType == null) {
                this.flags = 6;
            }
            if (lineStyles.isVariableLineStyle(this.lineType)) {
                this.flags = 1;
                this.representations = new Hashtable(11);
            } else {
                this.flags = 2;
                this.representation = this.calculateRepresentation(lineStyles.getLineStyle(this.lineType, insLStyle, this.getCorrectLayer(insLayer)));
            }
        }
        if ((this.flags & 4) != 0) {
            this.draw(g, mat, insLayer, colorModel, insColor);
        } else if ((this.flags & 2) != 0) {
            this.representation.draw(g, mat, insLayer, colorModel, insColor);
        } else {
            DrawAble rep;
            if (DxfViewer.debugLevel > 9) {
                System.out.println("Getting " + this.lineType);
            }
            LineStyle lt = lineStyles.getLineStyle(this.lineType, insLStyle, this.getCorrectLayer(insLayer));
            if (DxfViewer.debugLevel > 9) {
                System.out.println("linetype=" + lt);
            }
            if ((rep = (DrawAble)this.representations.get(lt)) == null) {
                rep = this.calculateRepresentation(lt);
                this.representations.put(lt, rep);
            }
            rep.draw(g, mat, insLayer, colorModel, insColor);
        }
    }

    public void addPoint(Point3D pt) {
        this.addPoint(pt.x, pt.y, pt.z);
    }

    public void addPoint(float x, float y, float z) {
        if (this.line == null) {
            this.line = new Point3D[2];
        } else if (this.nrPoints == this.line.length) {
            Point3D[] nLine = new Point3D[2 * this.line.length];
            System.arraycopy(this.line, 0, nLine, 0, this.line.length);
            this.line = nLine;
        }
        if (this.nrPoints == 0 || x != this.line[this.nrPoints - 1].x || y != this.line[this.nrPoints - 1].y || z != this.line[this.nrPoints - 1].z) {
            this.line[this.nrPoints++] = new Point3D(x, y, z);
        }
    }

    public void close() {
        if (this.nrPoints > 0) {
            while (this.nrPoints > 1 && this.line[0].equals(this.line[this.nrPoints - 1])) {
                --this.nrPoints;
            }
            this.isClosed = this.nrPoints > 1;
        }
    }

    public int calcBB(Point3D min, Point3D max, Matrix4D mat, DxfLAYER insertLayer, boolean onlyVisible) {
        if (onlyVisible && !this.isVisible(insertLayer)) {
            return 0;
        }
        int i = 0;
        while (i < this.nrPoints) {
            Point3D p;
            Point3D point3D = p = mat == null ? this.line[i] : mat.mult(this.line[i]);
            if (p.x < min.x) {
                min.x = p.x;
            }
            if (p.y < min.y) {
                min.y = p.y;
            }
            if (p.z < min.z) {
                min.z = p.z;
            }
            if (p.x > max.x) {
                max.x = p.x;
            }
            if (p.y > max.y) {
                max.y = p.y;
            }
            if (p.z > max.z) {
                max.z = p.z;
            }
            ++i;
        }
        return this.nrPoints > 1 ? this.nrPoints - (this.isClosed ? 0 : 1) : this.nrPoints;
    }

    public void transformBy(Matrix4D mat) {
        int i = 0;
        while (i < this.nrPoints) {
            mat.transform(this.line[i]);
            ++i;
        }
    }

    public DrawAble extrude(float dist, Vector3D up) {
        if (dist == 0.0f) {
            return this;
        }
        Vector3D ex = new Vector3D(dist * up.x, dist * up.y, dist * up.z);
        DrawSet set = new DrawSet(2 + this.nrPoints);
        DrawLines second = new DrawLines(this.nrPoints);
        set.setLayer(this.layer);
        set.setColor(this.color);
        second.setLayer(this.layer);
        second.setColor(this.color);
        set.addDrawable(this);
        int i = 0;
        while (i < this.nrPoints) {
            second.addPoint(this.line[i].x + ex.x, this.line[i].y + ex.y, this.line[i].z + ex.z);
            DrawLines conn = new DrawLines(2);
            conn.setLayer(this.layer);
            conn.setColor(this.color);
            conn.addPoint(this.line[i]);
            conn.addPoint(second.line[i]);
            set.addDrawable(conn);
            ++i;
        }
        if (this.isClosed) {
            second.close();
        }
        set.addDrawable(second);
        return set;
    }

    protected DrawAble calculateRepresentation(LineStyle lstyle) {
        Point3D[] line;
        SegmentWalker walker;
        if (lstyle == null || this.nrPoints == 1 || (walker = lstyle.lineSegments(this.calculateLength(), this.isClosed)) == null) {
            return this;
        }
        DrawSet set = new DrawSet();
        Point3D lastPoint = new Point3D(this.line[0]);
        int index = 1;
        Vector3D offset = lastPoint.minus(new Point3D());
        if (offset.length() > 10000.0f) {
            lastPoint = new Point3D();
            line = new Point3D[this.nrPoints];
            int p = this.nrPoints - 1;
            while (p >= 0) {
                line[p] = this.line[p].minus(offset);
                --p;
            }
        } else {
            offset = null;
            line = this.line;
        }
        set.setLayer(this.layer);
        set.setColor(this.color);
        block1: while (walker.hasMoreSegments()) {
            DrawLines seg;
            float segmentLength = walker.nextSegment();
            if (segmentLength >= 0.0f) {
                seg = new DrawLines();
                seg.setLayer(this.layer);
                seg.setColor(this.color);
                seg.addPoint(lastPoint);
                set.addDrawable(seg);
            } else {
                seg = null;
                segmentLength = -segmentLength;
            }
            float diff = line[index].minus(lastPoint).length();
            while (diff <= segmentLength) {
                segmentLength -= diff;
                lastPoint = new Point3D(line[index++]);
                if (seg != null) {
                    seg.addPoint(lastPoint);
                }
                if (index == this.nrPoints) {
                    if (this.isClosed) {
                        index = 0;
                    } else {
                        if (DxfViewer.debugLevel <= 0 || !walker.hasMoreSegments()) break block1;
                        System.out.println("OOOPS! LineType matching problem, probably rounding error!");
                        break block1;
                    }
                }
                diff = line[index].minus(lastPoint).length();
            }
            if (!(segmentLength > 0.0f)) continue;
            Vector3D dir = line[index].minus(lastPoint);
            dir.scale(segmentLength / diff);
            lastPoint.add(dir);
            if (seg == null) continue;
            seg.addPoint(lastPoint);
        }
        if (offset != null) {
            Matrix4D matrix = new Matrix4D();
            matrix.translate(offset);
            set.transformBy(matrix);
        }
        return set;
    }

    protected float calculateLength() {
        if (this.length < 0.0f) {
            this.length = 0.0f;
            int p = 1;
            while (p < this.nrPoints) {
                this.length += this.line[p].minus(this.line[p - 1]).length();
                ++p;
            }
            if (this.isClosed) {
                this.length += this.line[0].minus(this.line[this.nrPoints - 1]).length();
            }
        }
        return this.length;
    }
}

