/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.server.data.mspdi;

import com.projectlibre1.algorithm.Query;
import com.projectlibre1.algorithm.RangeIntervalGenerator;
import com.projectlibre1.algorithm.SelectFrom;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.HasTimeDistributedData;
import com.projectlibre1.pm.assignment.TimeDistributedHelper;
import com.projectlibre1.pm.assignment.functor.AssignmentFieldFunctor;
import com.projectlibre1.pm.scheduling.Schedule;
import com.projectlibre1.server.data.mspdi.TimeDistributedTypeMapper;
import com.projectlibre1.server.data.mspdi.TimephasedConsumer;
import com.projectlibre1.server.data.mspdi.TimephasedGetter;
import com.projectlibre1.server.data.mspdi.XsdDuration;
import com.projectlibre1.util.DateTime;
import net.sf.mpxj.mspdi.schema.ObjectFactory;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;

public class TimephasedService {
    protected static TimephasedService instance = null;

    protected TimephasedService() {
    }

    public static TimephasedService getInstance() {
        if (instance == null) {
            instance = new TimephasedService();
        }
        return instance;
    }

    private void doQuery(Assignment assignment, ObjectFactory objectFactory, TimephasedConsumer timephasedConsumer, Object object, int n, long l) {
        SelectFrom selectFrom = SelectFrom.getInstance();
        AssignmentFieldFunctor assignmentFieldFunctor = assignment.getDataSelect(object, selectFrom, false);
        TimephasedGetter timephasedGetter = TimephasedGetter.getInstance(objectFactory, timephasedConsumer, assignmentFieldFunctor, n, l);
        long l2 = assignment.getEnd();
        long l3 = assignment.getStart();
        if (object == HasTimeDistributedData.ACTUAL_WORK) {
            l2 = assignment.getStop();
        } else if (object == HasTimeDistributedData.REMAINING_WORK) {
            l3 = assignment.getStop();
        }
        RangeIntervalGenerator rangeIntervalGenerator = RangeIntervalGenerator.getInstance(l3, l2, 5);
        Query.getInstance().selectFrom(selectFrom).groupBy(rangeIntervalGenerator).action(timephasedGetter).execute();
    }

    public void consumeTimephased(Schedule schedule, TimephasedConsumer timephasedConsumer, Object object) {
        ObjectFactory objectFactory = (ObjectFactory)object;
        if (!(schedule instanceof Assignment)) {
            return;
        }
        Assignment assignment = (Assignment)schedule;
        long l = 0L;
        if (assignment.getPercentComplete() > 0.0) {
            this.doQuery(assignment, objectFactory, timephasedConsumer, HasTimeDistributedData.ACTUAL_WORK, 2, l++);
        }
        this.doQuery(assignment, objectFactory, timephasedConsumer, HasTimeDistributedData.REMAINING_WORK, 1, l++);
        Object[] objectArray = HasTimeDistributedData.baselineWorkTypes;
        for (int i = 0; i < objectArray.length; ++i) {
            Assignment assignment2 = assignment.getBaselineAssignment(new Integer(i), false);
            if (assignment2 == null) continue;
            int n = TimeDistributedTypeMapper.getTimeDistributedType(i, false, assignment2);
            this.doQuery(assignment2, objectFactory, timephasedConsumer, HasTimeDistributedData.WORK, n, l++);
        }
    }

    public void readTimephased(Assignment assignment, TimephasedDataType timephasedDataType) {
        if (!TimeDistributedHelper.isWork(timephasedDataType.getType())) {
            return;
        }
        Object object = TimeDistributedTypeMapper.getOPPrField(timephasedDataType.getType());
        long l = XsdDuration.millis(timephasedDataType.getValue());
        assignment.setInterval(object, DateTime.gmt(timephasedDataType.getStart().getTime()), DateTime.gmt(timephasedDataType.getFinish().getTime()), l);
    }
}

