/*
 * Decompiled with CFR 0.152.
 */
package tr.view.reference.screen;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.logging.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import tr.view.Window;
import tr.view.reference.screen.ReferenceNode;
import tr.view.reference.screen.ReferencePanel;
import tr.view.reference.screen.ReferencesTopComponent;

public final class ReferenceTopComponent
extends Window
implements LookupListener {
    private static final Logger LOG = Logger.getLogger("tr.view.reference");
    private static final String PREFERRED_ID = "ReferenceTopComponent";
    private static ReferenceTopComponent instance;
    private ReferencePanel panel;
    private Lookup.Result result;

    private ReferenceTopComponent() {
        this.setName(NbBundle.getMessage(ReferenceTopComponent.class, (String)"CTL_ReferenceTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ReferenceTopComponent.class, (String)"TTT_ReferenceTopComponent"));
        this.setIcon(Icons.Reference.getImage());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    protected void componentOpened() {
        super.componentOpened();
        if (this.panel == null) {
            this.removeAll();
            this.panel = new ReferencePanel();
            this.add(this.panel, "Center");
        }
        this.panel.initModel(null);
        ReferencesTopComponent rtc = ReferencesTopComponent.findInstance();
        this.result = rtc.getLookup().lookup(new Lookup.Template(ReferenceNode.class));
        this.result.addLookupListener((LookupListener)this);
        this.result.allInstances();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    protected void componentDeactivated() {
        this.panel.deactivate();
        super.componentDeactivated();
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        LOG.info("Starting");
        if (this.panel == null) {
            return;
        }
        Collection collection = this.result.allInstances();
        if (collection.isEmpty()) {
            this.panel.initModel(null);
            LOG.info("null");
        } else {
            ReferenceNode node = (ReferenceNode)collection.iterator().next();
            this.panel.initModel(node.info);
            LOG.info("initialising model");
        }
    }

    public void edit() {
        if (this.panel == null) {
            return;
        }
        this.requestActive();
        this.panel.edit();
    }

    public static synchronized ReferenceTopComponent getDefault() {
        if (instance == null) {
            instance = new ReferenceTopComponent();
        }
        return instance;
    }

    public static synchronized ReferenceTopComponent findInstance() {
        return ReferenceTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.reference");
    }
}

