/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.reports.weekly;

import au.com.trgtd.tr.reports.weekly.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.view.JasperViewer;
import org.w3c.dom.Document;
import tr.extract.Extract;
import tr.extract.ExtractActions;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamList;
import tr.extract.ParamsDialog;
import tr.model.Data;
import tr.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImpl
extends Extract {
    private static final String ID = "tr.reports.weekly";
    private ParamList paramStart;
    private ParamBoolean paramSuccess;
    private ParamBoolean paramCriteria;
    private ParamBoolean paramProject;
    private ParamBoolean paramNotes;
    private ParamBoolean paramOverdue;

    public String getID() {
        return ID;
    }

    public String getName() {
        return this.getString("CTL_ReportAction");
    }

    public List<Param> getParams() {
        Vector<Param> params = new Vector<Param>();
        Vector<Param.Item> dateItems = new Vector<Param.Item>();
        dateItems.add(new Param.Item(this.getString("today"), "today"));
        dateItems.add(new Param.Item(this.getString("tomorrow"), "tomorrow"));
        this.paramStart = new ParamList("paramStart", this.getString("param-start"), dateItems);
        params.add((Param)this.paramStart);
        this.paramOverdue = new ParamBoolean("paramOverdue", this.getString("param-overdue"));
        params.add((Param)this.paramOverdue);
        this.paramCriteria = new ParamBoolean("paramCriteria", this.getString("param-criteria"));
        params.add((Param)this.paramCriteria);
        this.paramSuccess = new ParamBoolean("paramSuccess", this.getString("param-success"));
        params.add((Param)this.paramSuccess);
        this.paramProject = new ParamBoolean("paramProject", this.getString("param-project"));
        params.add((Param)this.paramProject);
        this.paramNotes = new ParamBoolean("paramNotes", this.getString("param-notes"));
        params.add((Param)this.paramNotes);
        return params;
    }

    public void process(Data data) throws Exception {
        String title = this.getDialogTitleReport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), this.getParams());
        if (dlg.showDialog() == 2) {
            return;
        }
        HashMap<String, Object> rparams = new HashMap<String, Object>();
        boolean today = this.paramStart.getValue().equals("today");
        Date todayDate = today ? this.getDate(0) : this.getDate(1);
        Date weekStartDate = today ? this.getDate(1) : this.getDate(2);
        Date weekEndDate = today ? this.getDate(7) : this.getDate(8);
        rparams.put("paramDate", todayDate);
        rparams.put("paramTodayStart", this.getStart(todayDate));
        rparams.put("paramTodayEnd", this.getEnd(todayDate));
        rparams.put("paramWeekStart", this.getStart(weekStartDate));
        rparams.put("paramWeekEnd", this.getEnd(weekEndDate));
        rparams.put("paramOverdue", Boolean.parseBoolean(this.paramOverdue.getValue()));
        rparams.put("paramCriteria", Boolean.parseBoolean(this.paramCriteria.getValue()));
        rparams.put("paramSuccess", Boolean.parseBoolean(this.paramSuccess.getValue()));
        rparams.put("paramProject", Boolean.parseBoolean(this.paramProject.getValue()));
        rparams.put("paramNotes", Boolean.parseBoolean(this.paramNotes.getValue()));
        File resourcePath = Resources.FILE_RPT_WEEKLY.getParentFile();
        rparams.put("SUBREPORT_DIR", resourcePath.getPath() + File.separator);
        File xmlfile = ReportImpl.getTmpFile((String)"Actions.xml");
        ExtractActions.process((Data)data, (File)xmlfile);
        Document document = JRXmlUtils.parse((InputStream)JRLoader.getURLInputStream((String)xmlfile.toURI().toString()));
        rparams.put("XML_DATA_DOCUMENT", document);
        FileInputStream reportStream = new FileInputStream(Resources.FILE_RPT_WEEKLY);
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)reportStream, rparams);
        JasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)false);
    }

    private Long getStart(Date date) {
        return DateUtils.getStart((Date)date).getTime();
    }

    private Long getEnd(Date date) {
        return DateUtils.getEnd((Date)date).getTime();
    }

    private Date getDate(int addDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, addDays);
        return calendar.getTime();
    }
}

