/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.encoder.typeprocessors;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.encoder.Asn1Encoder;
import de.rub.nds.asn1.encoder.encodingoptions.Asn1EncodingOptions;
import de.rub.nds.asn1.encoder.encodingoptions.DefaultX509EncodingOptions;
import de.rub.nds.asn1.encoder.typeprocessors.Asn1TypeProcessor;
import de.rub.nds.asn1.util.AttributeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultX509TypeProcessor
extends Asn1TypeProcessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DefaultX509EncodingOptions encodingOptions;
    private final Asn1Encodable asn1Encodable;
    private boolean isLinkHandled = false;

    public DefaultX509TypeProcessor(Asn1EncodingOptions encodingOptions, Asn1Encodable asn1Encodable) {
        super(encodingOptions, asn1Encodable);
        this.encodingOptions = (DefaultX509EncodingOptions)encodingOptions;
        this.asn1Encodable = asn1Encodable;
    }

    public byte[] encode() {
        byte[] encoded = new byte[]{};
        if (this.isFlaggedForEncoding()) {
            encoded = this.linksAnotherAsn1Encodable() && !this.isLinkHandled ? this.encodeFromLinkedAsn1Encodable() : this.asn1Encodable.getSerializer().serialize();
        }
        return encoded;
    }

    protected boolean linksAnotherAsn1Encodable() {
        return this.encodingOptions.linker.hasLink(this.asn1Encodable);
    }

    private byte[] encodeFromLinkedAsn1Encodable() {
        Asn1Encodable linkedAsn1Encodable = this.encodingOptions.linker.getLinkedAsn1Encodable(this.asn1Encodable);
        if (!this.asn1Encodable.getType().equals(linkedAsn1Encodable.getType())) {
            LOGGER.warn("Type mismatch: " + this.asn1Encodable.getClass() + " with type " + this.asn1Encodable.getType() + " references " + linkedAsn1Encodable.getClass() + " with type " + linkedAsn1Encodable.getType() + "! Encoding reference anyways...");
        }
        Asn1Encoder asn1Encoder = new Asn1Encoder((Asn1EncodingOptions)this.encodingOptions, linkedAsn1Encodable, new Asn1Encodable[0]);
        return asn1Encoder.encode();
    }

    protected boolean isFlaggedForEncoding() {
        boolean isFlaggedForEncoding = true;
        boolean excludeFromSignature = AttributeParser.parseBooleanAttributeOrDefault((Asn1Encodable)this.asn1Encodable, (String)"excludeFromSignature", (boolean)false);
        boolean excludeFromCertificate = AttributeParser.parseBooleanAttributeOrDefault((Asn1Encodable)this.asn1Encodable, (String)"excludeFromCertificate", (boolean)false);
        switch (this.encodingOptions.encodeTarget) {
            case FOR_SIGNATURE_ONLY: {
                if (!excludeFromSignature) break;
                isFlaggedForEncoding = false;
                break;
            }
            case FOR_CERTIFICATE_ONLY: {
                if (!excludeFromCertificate) break;
                isFlaggedForEncoding = false;
            }
        }
        return isFlaggedForEncoding;
    }

    protected void setLinkHandled(boolean isLinkHandled) {
        this.isLinkHandled = isLinkHandled;
    }
}

