/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.protocol.handler.PWDClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PWDComputations;
import de.rub.nds.tlsattacker.core.state.TlsContext;

public class PWDClientKeyExchangeMessage
extends ClientKeyExchangeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger elementLength;
    @ModifiableVariableProperty
    private ModifiableByteArray element;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger scalarLength;
    @ModifiableVariableProperty
    private ModifiableByteArray scalar;
    protected PWDComputations computations;

    public PWDClientKeyExchangeMessage() {
    }

    public PWDClientKeyExchangeMessage(Config tlsConfig) {
        super(tlsConfig);
    }

    @Override
    public PWDComputations getComputations() {
        return this.computations;
    }

    @Override
    public void prepareComputations() {
        if (this.getComputations() == null) {
            this.computations = new PWDComputations();
        }
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new PWDClientKeyExchangeHandler(context);
    }

    public ModifiableInteger getElementLength() {
        return this.elementLength;
    }

    public void setElementLength(ModifiableInteger elementLength) {
        this.elementLength = elementLength;
    }

    public void setElementLength(int elementLength) {
        this.elementLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.elementLength, (Integer)elementLength);
    }

    public ModifiableByteArray getElement() {
        return this.element;
    }

    public void setElement(ModifiableByteArray element) {
        this.element = element;
    }

    public void setElement(byte[] element) {
        this.element = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.element, (byte[])element);
    }

    public ModifiableInteger getScalarLength() {
        return this.scalarLength;
    }

    public void setScalarLength(ModifiableInteger scalarLength) {
        this.scalarLength = scalarLength;
    }

    public void setScalarLength(int scalarLength) {
        this.scalarLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.scalarLength, (Integer)scalarLength);
    }

    public ModifiableByteArray getScalar() {
        return this.scalar;
    }

    public void setScalar(ModifiableByteArray scalar) {
        this.scalar = scalar;
    }

    public void setScalar(byte[] scalar) {
        this.scalar = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.scalar, (byte[])scalar);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PWDClientKeyExchangeMessage:");
        sb.append("\n  Element: ");
        if (this.getElement() != null && this.getElement().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getElement().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Scalar: ");
        if (this.getScalar() != null && this.getScalar().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getScalar().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        return "PWD_CLIENT_KEY_EXCHANGE";
    }
}

