/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRetryRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelloRetryRequestParser
extends HandshakeMessageParser<HelloRetryRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HelloRetryRequestParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.HELLO_RETRY_REQUEST, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(HelloRetryRequestMessage msg) {
        LOGGER.debug("Parsing HelloRetryRequestMessage");
        this.parseProtocolVersion(msg);
        this.parseSelectedCiphersuite(msg);
        if (this.hasExtensionLengthField(msg)) {
            this.parseExtensionLength(msg);
            if (this.hasExtensions(msg)) {
                this.parseExtensionBytes(msg);
            }
        }
    }

    @Override
    protected HelloRetryRequestMessage createHandshakeMessage() {
        return new HelloRetryRequestMessage();
    }

    protected void parseProtocolVersion(HelloRetryRequestMessage message) {
        message.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion:" + ArrayConverter.bytesToHexString((byte[])((byte[])message.getProtocolVersion().getValue())));
    }

    protected void parseSelectedCiphersuite(HelloRetryRequestMessage message) {
        message.setSelectedCipherSuite(this.parseByteArrayField(2));
        LOGGER.debug("CipherSuite:" + ArrayConverter.bytesToHexString((byte[])((byte[])message.getSelectedCipherSuite().getValue())));
    }
}

