/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Whitespace;

public abstract class Value
implements Serializable,
SequenceIterable,
ValueRepresentation {
    private static double[] powers = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8};
    private static Pattern doublePattern = Pattern.compile("^[0-9.eE+-]+$");
    public static final int INDETERMINATE_ORDERING = Integer.MIN_VALUE;
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public static Value asValue(ValueRepresentation val) {
        if (val instanceof Value) {
            return (Value)val;
        }
        if (val == null) {
            return EmptySequence.getInstance();
        }
        return new SingletonNode((NodeInfo)val);
    }

    public static Item asItem(ValueRepresentation value) throws XPathException {
        if (value instanceof Item) {
            return (Item)value;
        }
        return ((Value)value).asItem();
    }

    public Item asItem() throws XPathException {
        SequenceIterator iter = this.iterate();
        Item item = iter.next();
        if (item == null) {
            return null;
        }
        if (iter.next() != null) {
            throw new XPathException("Attempting to access a sequence as a singleton item");
        }
        return item;
    }

    public static Value fromItem(Item item) {
        if (item == null) {
            return EmptySequence.getInstance();
        }
        if (item instanceof AtomicValue) {
            return (AtomicValue)item;
        }
        return new SingletonNode((NodeInfo)item);
    }

    public static SequenceIterator asIterator(ValueRepresentation val) throws XPathException {
        if (val instanceof Value) {
            return ((Value)val).iterate();
        }
        if (val == null) {
            return EmptyIterator.getInstance();
        }
        return SingletonIterator.makeIterator((NodeInfo)val);
    }

    public static double stringToNumber(CharSequence s) throws NumberFormatException {
        String n;
        int len = s.length();
        if (len < 9) {
            boolean useJava = false;
            long num = 0L;
            int dot = -1;
            int lastDigit = -1;
            boolean onlySpaceAllowed = false;
            block5: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (lastDigit == -1) continue block5;
                        onlySpaceAllowed = true;
                        continue block5;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (onlySpaceAllowed) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        lastDigit = i;
                        num = num * 10L + (long)(c - 48);
                        continue block5;
                    }
                    case '.': {
                        if (onlySpaceAllowed) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        if (dot != -1) {
                            throw new NumberFormatException("Only one decimal point allowed");
                        }
                        dot = i;
                        continue block5;
                    }
                    default: {
                        useJava = true;
                        break block5;
                    }
                }
            }
            if (!useJava) {
                if (lastDigit == -1) {
                    throw new NumberFormatException("No digits found");
                }
                if (dot == -1 || dot > lastDigit) {
                    return num;
                }
                int afterPoint = lastDigit - dot;
                return (double)num / powers[afterPoint];
            }
        }
        if ("INF".equals(n = ((Object)Whitespace.trimWhitespace(s)).toString())) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(n)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(n)) {
            return Double.NaN;
        }
        if (!doublePattern.matcher(n).matches()) {
            throw new NumberFormatException("Invalid characters in float/double value");
        }
        return Double.parseDouble(n);
    }

    public static SequenceIterator getIterator(ValueRepresentation val) throws XPathException {
        if (val instanceof Value) {
            return ((Value)val).iterate();
        }
        if (val instanceof NodeInfo) {
            return SingletonIterator.makeIterator((NodeInfo)val);
        }
        if (val == null) {
            throw new AssertionError((Object)"Value of variable is undefined (null)");
        }
        throw new AssertionError((Object)("Unknown value representation " + val.getClass()));
    }

    public abstract SequenceIterator iterate() throws XPathException;

    public final SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.iterate();
    }

    public CharSequence getStringValueCS() throws XPathException {
        return this.getStringValue();
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        try {
            return this.getStringValueCS();
        }
        catch (XPathException err) {
            throw new IllegalStateException("Failed to get canonical lexical representation: " + err.getMessage());
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        try {
            SequenceIterator iter = this.iterate();
            Item next = iter.next();
            if (next == null) {
                return 8192;
            }
            if (iter.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException err) {
            return 57344;
        }
    }

    public Item itemAt(int n) throws XPathException {
        Item item;
        if (n < 0) {
            return null;
        }
        int i = 0;
        SequenceIterator iter = this.iterate();
        do {
            if ((item = iter.next()) != null) continue;
            return null;
        } while (i++ != n);
        return item;
    }

    public int getLength() throws XPathException {
        return Aggregate.count(this.iterate());
    }

    public void process(XPathContext context) throws XPathException {
        Item it;
        SequenceIterator iter = this.iterate();
        SequenceReceiver out = context.getReceiver();
        while ((it = iter.next()) != null) {
            out.append(it, 0, 2);
        }
    }

    public String getStringValue() throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(1024);
        SequenceIterator iter = this.iterate();
        Item item = iter.next();
        if (item != null) {
            while (true) {
                sb.append(item.getStringValueCS());
                item = iter.next();
                if (item == null) break;
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    public Comparable getSchemaComparable() {
        return new ValueSchemaComparable();
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("Value.equals()");
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
    }

    public Value reduce() throws XPathException {
        return this;
    }

    public static QNameValue makeQNameValue(Object object, Configuration config) {
        try {
            Class qnameClass = config.getClass("javax.xml.namespace.QName", false, null);
            Class[] args = EMPTY_CLASS_ARRAY;
            Method getPrefix = qnameClass.getMethod("getPrefix", args);
            Method getLocalPart = qnameClass.getMethod("getLocalPart", args);
            Method getNamespaceURI = qnameClass.getMethod("getNamespaceURI", args);
            String prefix = (String)getPrefix.invoke(object, (Object[])args);
            String localPart = (String)getLocalPart.invoke(object, (Object[])args);
            String uri = (String)getNamespaceURI.invoke(object, (Object[])args);
            return new QNameValue(prefix, uri, localPart, BuiltInAtomicType.QNAME, config.getNameChecker());
        }
        catch (XPathException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException err) {
            return super.toString();
        }
    }

    public static Object convertToJava(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            Object node = item;
            while (node instanceof VirtualNode) {
                node = ((VirtualNode)node).getUnderlyingNode();
            }
            return node;
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).getObject();
        }
        AtomicValue value = (AtomicValue)item;
        switch (value.getItemType(null).getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 631: {
                return value.getStringValue();
            }
            case 514: {
                return ((BooleanValue)value).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 515: {
                return ((DecimalValue)value).getDecimalValue();
            }
            case 532: {
                return new Long(((NumericValue)value).longValue());
            }
            case 517: {
                return new Double(((DoubleValue)value).getDoubleValue());
            }
            case 516: {
                return new Float(((FloatValue)value).getFloatValue());
            }
            case 519: {
                return ((DateTimeValue)value).getCalendar().getTime();
            }
            case 521: {
                return ((DateValue)value).getCalendar().getTime();
            }
            case 520: {
                return value.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)value).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)value).getBinaryValue();
            }
        }
        return item;
    }

    private class ValueSchemaComparable
    implements Comparable {
        private ValueSchemaComparable() {
        }

        public Value getValue() {
            return Value.this;
        }

        public int compareTo(Object obj) {
            try {
                if (obj instanceof ValueSchemaComparable) {
                    Item item2;
                    Item item1;
                    int c;
                    SequenceIterator iter1 = this.getValue().iterate();
                    SequenceIterator iter2 = ((ValueSchemaComparable)obj).getValue().iterate();
                    do {
                        item1 = iter1.next();
                        item2 = iter2.next();
                        if (item1 == null && item2 == null) {
                            return 0;
                        }
                        if (item1 == null) {
                            return -1;
                        }
                        if (item2 == null) {
                            return 1;
                        }
                        if (!(item1 instanceof NodeInfo) && !(item2 instanceof NodeInfo)) continue;
                        throw new UnsupportedOperationException("Sequences containing nodes are not schema-comparable");
                    } while ((c = ((AtomicValue)item1).getSchemaComparable().compareTo(((AtomicValue)item2).getSchemaComparable())) == 0);
                    return c;
                }
                return Integer.MIN_VALUE;
            }
            catch (XPathException e) {
                throw new AssertionError((Object)("Failure comparing schema values: " + e.getMessage()));
            }
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            try {
                int hash = 107189858;
                SequenceIterator iter = this.getValue().iterate();
                while (true) {
                    Item item;
                    if ((item = iter.next()) == null) {
                        return hash;
                    }
                    hash ^= ((AtomicValue)item).getSchemaComparable().hashCode();
                }
            }
            catch (XPathException e) {
                return 0;
            }
        }
    }
}

