/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class TcpTimestampsOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = -7134215148170658739L;
    private final TcpOptionKind kind = TcpOptionKind.TIMESTAMPS;
    private final byte length;
    private final int tsValue;
    private final int tsEchoReply;

    public static TcpTimestampsOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new TcpTimestampsOption(rawData, offset, length);
    }

    private TcpTimestampsOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 10) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 9. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[offset] != (Byte)this.kind.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The kind must be: ").append(this.kind.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1 + offset];
        if (this.length != 10) {
            throw new IllegalRawDataException("The value of length field must be 10 but: " + this.length);
        }
        this.tsValue = ByteArrays.getInt(rawData, 2 + offset);
        this.tsEchoReply = ByteArrays.getInt(rawData, 6 + offset);
    }

    private TcpTimestampsOption(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder: " + builder2);
        }
        this.tsValue = builder2.tsValue;
        this.tsEchoReply = builder2.tsEchoReply;
        this.length = builder2.correctLengthAtBuild ? (byte)this.length() : builder2.length;
    }

    @Override
    public TcpOptionKind getKind() {
        return this.kind;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public int getTsValue() {
        return this.tsValue;
    }

    public long getTsValueAsLong() {
        return 0xFFFFFFFFL & (long)this.tsValue;
    }

    public int getTsEchoReply() {
        return this.tsEchoReply;
    }

    public long getTsEchoReplyAsLong() {
        return 0xFFFFFFFFL & (long)this.tsEchoReply;
    }

    @Override
    public int length() {
        return 10;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.kind.value();
        rawData[1] = this.length;
        System.arraycopy(ByteArrays.toByteArray(this.tsValue), 0, rawData, 2, 4);
        System.arraycopy(ByteArrays.toByteArray(this.tsEchoReply), 0, rawData, 6, 4);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(this.kind).append("] [Length: ").append(this.getLengthAsInt()).append(" bytes] [TS Value: ").append(this.getTsValueAsLong()).append("] [TS Echo Reply: ").append(this.getTsEchoReplyAsLong()).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        TcpTimestampsOption other = (TcpTimestampsOption)obj;
        return this.length == other.length && this.tsValue == other.tsValue && this.tsEchoReply == other.tsEchoReply;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.length;
        result = 31 * result + this.tsValue;
        result = 31 * result + this.tsEchoReply;
        return result;
    }

    public static final class Builder
    implements LengthBuilder<TcpTimestampsOption> {
        private byte length;
        private int tsValue;
        private int tsEchoReply;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(TcpTimestampsOption option) {
            this.length = option.length;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder tsValue(int tsValue) {
            this.tsValue = tsValue;
            return this;
        }

        public Builder tsEchoReply(int tsEchoReply) {
            this.tsEchoReply = tsEchoReply;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public TcpTimestampsOption build() {
            return new TcpTimestampsOption(this);
        }
    }
}

