/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OpusTags
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USER_COMMENTS;
    public static final int COMMENT_LENGTHS;
    public static final int COMMENTS;
    public static final int VENDOR;

    public OpusTags(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OpusTags.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char **")
    public PointerBuffer user_comments() {
        return OpusTags.nuser_comments(this.address());
    }

    @NativeType(value="int *")
    public IntBuffer comment_lengths() {
        return OpusTags.ncomment_lengths(this.address());
    }

    public int comments() {
        return OpusTags.ncomments(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer vendor() {
        return OpusTags.nvendor(this.address());
    }

    @NativeType(value="char *")
    public String vendorString() {
        return OpusTags.nvendorString(this.address());
    }

    public static OpusTags malloc() {
        return (OpusTags)OpusTags.wrap(OpusTags.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OpusTags calloc() {
        return (OpusTags)OpusTags.wrap(OpusTags.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OpusTags create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OpusTags)OpusTags.wrap(OpusTags.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OpusTags create(long address) {
        return (OpusTags)OpusTags.wrap(OpusTags.class, (long)address);
    }

    @Nullable
    public static OpusTags createSafe(long address) {
        return address == 0L ? null : (OpusTags)OpusTags.wrap(OpusTags.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OpusTags.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OpusTags.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OpusTags.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OpusTags.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OpusTags.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OpusTags.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OpusTags.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OpusTags malloc(MemoryStack stack) {
        return (OpusTags)OpusTags.wrap(OpusTags.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OpusTags calloc(MemoryStack stack) {
        return (OpusTags)OpusTags.wrap(OpusTags.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OpusTags.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OpusTags.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static PointerBuffer nuser_comments(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)USER_COMMENTS)), (int)OpusTags.ncomments(struct));
    }

    public static IntBuffer ncomment_lengths(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)COMMENT_LENGTHS)), (int)OpusTags.ncomments(struct));
    }

    public static int ncomments(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMMENTS);
    }

    public static ByteBuffer nvendor(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)VENDOR)));
    }

    public static String nvendorString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)VENDOR)));
    }

    static {
        Struct.Layout layout = OpusTags.__struct((Struct.Member[])new Struct.Member[]{OpusTags.__member((int)POINTER_SIZE), OpusTags.__member((int)POINTER_SIZE), OpusTags.__member((int)4), OpusTags.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USER_COMMENTS = layout.offsetof(0);
        COMMENT_LENGTHS = layout.offsetof(1);
        COMMENTS = layout.offsetof(2);
        VENDOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OpusTags, Buffer>
    implements NativeResource {
        private static final OpusTags ELEMENT_FACTORY = OpusTags.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OpusTags getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char **")
        public PointerBuffer user_comments() {
            return OpusTags.nuser_comments(this.address());
        }

        @NativeType(value="int *")
        public IntBuffer comment_lengths() {
            return OpusTags.ncomment_lengths(this.address());
        }

        public int comments() {
            return OpusTags.ncomments(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer vendor() {
            return OpusTags.nvendor(this.address());
        }

        @NativeType(value="char *")
        public String vendorString() {
            return OpusTags.nvendorString(this.address());
        }
    }
}

