/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.layout.template.json.util.Recycler;

public class QueueingRecycler<V>
implements Recycler<V> {
    private final Supplier<V> supplier;
    private final Consumer<V> cleaner;
    private final Queue<V> queue;

    public QueueingRecycler(Supplier<V> supplier, Consumer<V> cleaner, Queue<V> queue) {
        this.supplier = supplier;
        this.cleaner = cleaner;
        this.queue = queue;
    }

    Queue<V> getQueue() {
        return this.queue;
    }

    @Override
    public V acquire() {
        V value = this.queue.poll();
        if (value == null) {
            return this.supplier.get();
        }
        this.cleaner.accept(value);
        return value;
    }

    @Override
    public void release(V value) {
        this.queue.offer(value);
    }
}

