/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt3;

import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoderContext;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt3.Mqtt3MessageEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt3.message.Mqtt3MessageType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt3PublishEncoder
extends Mqtt3MessageEncoder<MqttStatefulPublish> {
    private static final int FIXED_HEADER = Mqtt3MessageType.PUBLISH.getCode() << 4;

    @Inject
    Mqtt3PublishEncoder() {
    }

    @Override
    int remainingLength(@NotNull MqttStatefulPublish message) {
        ByteBuffer payload;
        MqttPublish stateless = (MqttPublish)message.stateless();
        int remainingLength = 0;
        remainingLength += stateless.getTopic().encodedLength();
        if (stateless.getQos() != MqttQos.AT_MOST_ONCE) {
            remainingLength += 2;
        }
        if ((payload = stateless.getRawPayload()) != null) {
            remainingLength += payload.remaining();
        }
        return remainingLength;
    }

    @Override
    @NotNull
    ByteBuf encode(@NotNull MqttStatefulPublish message, @NotNull MqttEncoderContext context, int encodedLength, int remainingLength) {
        ByteBuffer payload = ((MqttPublish)message.stateless()).getRawPayload();
        if (payload != null && payload.isDirect()) {
            int encodedLengthWithoutPayload = encodedLength - payload.remaining();
            ByteBuf out = context.getAllocator().ioBuffer(encodedLengthWithoutPayload, encodedLengthWithoutPayload);
            this.encode(message, out, remainingLength);
            return Unpooled.wrappedUnmodifiableBuffer((ByteBuf[])new ByteBuf[]{out, Unpooled.wrappedBuffer((ByteBuffer)payload)});
        }
        ByteBuf out = context.getAllocator().ioBuffer(encodedLength, encodedLength);
        this.encode(message, out, remainingLength);
        return out;
    }

    @Override
    void encode(@NotNull MqttStatefulPublish message, @NotNull ByteBuf out, int remainingLength) {
        this.encodeFixedHeader(message, out, remainingLength);
        this.encodeVariableHeader(message, out);
        this.encodePayload(message, out);
    }

    private void encodeFixedHeader(@NotNull MqttStatefulPublish message, @NotNull ByteBuf out, int remainingLength) {
        MqttPublish stateless = (MqttPublish)message.stateless();
        int flags = 0;
        if (message.isDup()) {
            flags |= 8;
        }
        flags |= stateless.getQos().getCode() << 1;
        if (stateless.isRetain()) {
            flags |= 1;
        }
        out.writeByte(FIXED_HEADER | flags);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull MqttStatefulPublish message, @NotNull ByteBuf out) {
        MqttPublish stateless = (MqttPublish)message.stateless();
        stateless.getTopic().encode(out);
        if (stateless.getQos() != MqttQos.AT_MOST_ONCE) {
            out.writeShort(message.getPacketIdentifier());
        }
    }

    private void encodePayload(@NotNull MqttStatefulPublish message, @NotNull ByteBuf out) {
        ByteBuffer payload = ((MqttPublish)message.stateless()).getRawPayload();
        if (payload != null && !payload.isDirect()) {
            out.writeBytes(payload.duplicate());
        }
    }
}

