/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.compressor;

import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.compressor.AlgorithmFactory;
import de.rub.nds.tlsattacker.core.record.compressor.Compressor;
import de.rub.nds.tlsattacker.core.record.compressor.compression.CompressionAlgorithm;
import de.rub.nds.tlsattacker.core.state.TlsContext;

public class RecordCompressor
extends Compressor<AbstractRecord> {
    private CompressionAlgorithm algorithm;
    private ProtocolVersion version;

    public RecordCompressor(TlsContext context) {
        this.version = context.getChooser().getSelectedProtocolVersion();
        if (this.version.isTLS13()) {
            this.setMethod(CompressionMethod.NULL);
        } else {
            this.setMethod(context.getChooser().getSelectedCompressionMethod());
        }
    }

    @Override
    public void compress(AbstractRecord record) {
        byte[] cleanBytes = (byte[])record.getCleanProtocolMessageBytes().getValue();
        byte[] compressedBytes = this.algorithm.compress(cleanBytes);
        record.setCleanProtocolMessageBytes(compressedBytes);
    }

    public void setMethod(CompressionMethod method) {
        AlgorithmFactory factory = new AlgorithmFactory();
        this.algorithm = factory.getAlgorithm(this.version, method);
    }
}

