/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.api.plugins.input.data.IClassData;
import jadx.api.plugins.input.data.IFieldData;
import jadx.api.plugins.input.data.IMethodData;
import jadx.api.plugins.input.data.ISeqConsumer;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.types.SourceFileAttr;
import jadx.plugins.input.dex.sections.DexAnnotationsConvert;
import jadx.plugins.input.dex.sections.DexCodeReader;
import jadx.plugins.input.dex.sections.DexFieldData;
import jadx.plugins.input.dex.sections.DexMethodData;
import jadx.plugins.input.dex.sections.DexMethodRef;
import jadx.plugins.input.dex.sections.SectionReader;
import jadx.plugins.input.dex.sections.annotations.AnnotationsParser;
import jadx.plugins.input.dex.utils.SmaliUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DexClassData
implements IClassData {
    private static final Logger LOG = LoggerFactory.getLogger(DexClassData.class);
    public static final int SIZE = 32;
    private final SectionReader in;
    private final AnnotationsParser annotationsParser;

    public DexClassData(SectionReader sectionReader, AnnotationsParser annotationsParser) {
        this.in = sectionReader;
        this.annotationsParser = annotationsParser;
    }

    public IClassData copy() {
        return new DexClassData(this.in.copy(), this.annotationsParser.copy());
    }

    public String getType() {
        int typeIdx = this.in.pos(0).readInt();
        String clsType = this.in.getType(typeIdx);
        if (clsType == null) {
            throw new NullPointerException("Unknown class type");
        }
        return clsType;
    }

    public int getAccessFlags() {
        return this.in.pos(4).readInt();
    }

    @Nullable
    public String getSuperType() {
        int typeIdx = this.in.pos(8).readInt();
        return this.in.getType(typeIdx);
    }

    public List<String> getInterfacesTypes() {
        int offset = this.in.pos(12).readInt();
        if (offset == 0) {
            return Collections.emptyList();
        }
        return this.in.absPos(offset).readTypeList();
    }

    @Nullable
    private String getSourceFile() {
        int strIdx = this.in.pos(16).readInt();
        return this.in.getString(strIdx);
    }

    public String getInputFileName() {
        return this.in.getDexReader().getInputFileName();
    }

    public int getAnnotationsOff() {
        return this.in.pos(20).readInt();
    }

    public int getClassDataOff() {
        return this.in.pos(24).readInt();
    }

    public int getStaticValuesOff() {
        return this.in.pos(28).readInt();
    }

    public void visitFieldsAndMethods(ISeqConsumer<IFieldData> fieldConsumer, ISeqConsumer<IMethodData> mthConsumer) {
        int classDataOff = this.getClassDataOff();
        if (classDataOff == 0) {
            return;
        }
        SectionReader data = this.in.copy(classDataOff);
        int staticFieldsCount = data.readUleb128();
        int instanceFieldsCount = data.readUleb128();
        int directMthCount = data.readUleb128();
        int virtualMthCount = data.readUleb128();
        fieldConsumer.init(staticFieldsCount + instanceFieldsCount);
        mthConsumer.init(directMthCount + virtualMthCount);
        this.annotationsParser.setOffset(this.getAnnotationsOff());
        this.visitFields((Consumer<IFieldData>)fieldConsumer, data, staticFieldsCount, instanceFieldsCount);
        this.visitMethods((Consumer<IMethodData>)mthConsumer, data, directMthCount, virtualMthCount);
    }

    private void visitFields(Consumer<IFieldData> fieldConsumer, SectionReader data, int staticFieldsCount, int instanceFieldsCount) {
        Map<Integer, Integer> annotationOffsetMap = this.annotationsParser.readFieldsAnnotationOffsetMap();
        DexFieldData fieldData = new DexFieldData(this.annotationsParser);
        fieldData.setParentClassType(this.getType());
        this.readFields(fieldConsumer, data, fieldData, staticFieldsCount, annotationOffsetMap, true);
        this.readFields(fieldConsumer, data, fieldData, instanceFieldsCount, annotationOffsetMap, false);
    }

    private void readFields(Consumer<IFieldData> fieldConsumer, SectionReader data, DexFieldData fieldData, int count, Map<Integer, Integer> annOffsetMap, boolean staticFields) {
        List<EncodedValue> constValues = staticFields ? this.getStaticFieldInitValues(data.copy()) : null;
        int fieldId = 0;
        for (int i = 0; i < count; ++i) {
            int accFlags = data.readUleb128();
            this.in.fillFieldData(fieldData, fieldId += data.readUleb128());
            fieldData.setAccessFlags(accFlags);
            fieldData.setAnnotationsOffset(DexClassData.getOffsetFromMap(fieldId, annOffsetMap));
            fieldData.setConstValue(staticFields && i < constValues.size() ? constValues.get(i) : null);
            fieldConsumer.accept(fieldData);
        }
    }

    private void visitMethods(Consumer<IMethodData> mthConsumer, SectionReader data, int directMthCount, int virtualMthCount) {
        DexMethodData methodData = new DexMethodData(this.annotationsParser);
        methodData.setMethodRef(new DexMethodRef());
        Map<Integer, Integer> annotationOffsetMap = this.annotationsParser.readMethodsAnnotationOffsetMap();
        Map<Integer, Integer> paramsAnnOffsetMap = this.annotationsParser.readMethodParamsAnnRefOffsetMap();
        this.readMethods(mthConsumer, data, methodData, directMthCount, annotationOffsetMap, paramsAnnOffsetMap);
        this.readMethods(mthConsumer, data, methodData, virtualMthCount, annotationOffsetMap, paramsAnnOffsetMap);
    }

    private void readMethods(Consumer<IMethodData> mthConsumer, SectionReader data, DexMethodData methodData, int count, Map<Integer, Integer> annotationOffsetMap, Map<Integer, Integer> paramsAnnOffsetMap) {
        DexCodeReader dexCodeReader = new DexCodeReader(this.in.copy());
        int mthIdx = 0;
        for (int i = 0; i < count; ++i) {
            int accFlags = data.readUleb128();
            int codeOff = data.readUleb128();
            DexMethodRef methodRef = methodData.getMethodRef();
            methodRef.reset();
            this.in.initMethodRef(mthIdx += data.readUleb128(), methodRef);
            methodData.setAccessFlags(accFlags);
            if (codeOff == 0) {
                methodData.setCodeReader(null);
            } else {
                dexCodeReader.setMthId(mthIdx);
                dexCodeReader.setOffset(codeOff);
                methodData.setCodeReader(dexCodeReader);
            }
            methodData.setAnnotationsOffset(DexClassData.getOffsetFromMap(mthIdx, annotationOffsetMap));
            methodData.setParamAnnotationsOffset(DexClassData.getOffsetFromMap(mthIdx, paramsAnnOffsetMap));
            mthConsumer.accept(methodData);
        }
    }

    private static int getOffsetFromMap(int idx, Map<Integer, Integer> annOffsetMap) {
        Integer offset = annOffsetMap.get(idx);
        return offset != null ? offset : 0;
    }

    private List<EncodedValue> getStaticFieldInitValues(SectionReader reader) {
        int staticValuesOff = this.getStaticValuesOff();
        if (staticValuesOff == 0) {
            return Collections.emptyList();
        }
        reader.absPos(staticValuesOff);
        return this.annotationsParser.parseEncodedArray(reader);
    }

    private List<IAnnotation> getAnnotations() {
        this.annotationsParser.setOffset(this.getAnnotationsOff());
        return this.annotationsParser.readClassAnnotations();
    }

    public List<IJadxAttribute> getAttributes() {
        ArrayList<IJadxAttribute> list = new ArrayList<IJadxAttribute>();
        String sourceFile = this.getSourceFile();
        if (sourceFile != null && !sourceFile.isEmpty()) {
            list.add((IJadxAttribute)new SourceFileAttr(sourceFile));
        }
        DexAnnotationsConvert.forClass(this.getType(), list, this.getAnnotations());
        return list;
    }

    public int getClassDefOffset() {
        return this.in.pos(0).getAbsPos();
    }

    public String getDisassembledCode() {
        byte[] dexBuf = this.in.getDexReader().getBuf().array();
        return SmaliUtils.getSmaliCode(dexBuf, this.getClassDefOffset());
    }

    public String toString() {
        return this.getType();
    }
}

