/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.DotNames;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public final class AssignabilityCheck {
    private final ConcurrentMap<DotName, Set<DotName>> cache = new ConcurrentHashMap<DotName, Set<DotName>>();
    private final IndexView index;

    public AssignabilityCheck(IndexView beanArchiveIndex, IndexView applicationIndex) {
        this.index = applicationIndex != null ? CompositeIndex.create((IndexView[])new IndexView[]{beanArchiveIndex, applicationIndex}) : beanArchiveIndex;
    }

    public boolean isAssignableFrom(Type type1, Type type2) {
        if (type1.name().equals((Object)DotNames.OBJECT)) {
            return true;
        }
        if (type1.name().equals((Object)type2.name())) {
            return true;
        }
        return this.getSupertypes(type2.name()).contains(type1.name());
    }

    private Set<DotName> getSupertypes(DotName name) {
        return this.cache.computeIfAbsent(name, this::findSupertypes);
    }

    private Set<DotName> findSupertypes(DotName name) {
        HashSet<DotName> result = new HashSet<DotName>();
        ArrayDeque<DotName> workQueue = new ArrayDeque<DotName>();
        workQueue.add(name);
        while (!workQueue.isEmpty()) {
            DotName type = (DotName)workQueue.poll();
            if (result.contains(type)) continue;
            result.add(type);
            ClassInfo clazz = this.index.getClassByName(type);
            if (clazz == null) continue;
            if (clazz.superName() != null) {
                workQueue.add(clazz.superName());
            }
            workQueue.addAll(clazz.interfaceNames());
        }
        return result;
    }
}

