/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class HistogramRed
extends AbstractRed {
    boolean[] computed;
    int tallied = 0;
    int[] bins = new int[256];

    public HistogramRed(CachableRed cachableRed) {
        super(cachableRed, null);
        int n = this.getNumXTiles() * this.getNumYTiles();
        this.computed = new boolean[n];
    }

    public void tallyTile(Raster raster) {
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int[] nArray = null;
        int n5 = n2;
        while (n5 < n2 + n4) {
            nArray = raster.getPixels(n, n5, n3, 1, nArray);
            int n6 = 0;
            while (n6 < 3 * n3) {
                int n7 = nArray[n6++] * 5;
                n7 += nArray[n6++] * 9;
                int n8 = (n7 += nArray[n6++] * 2) >> 4;
                this.bins[n8] = this.bins[n8] + 1;
                ++n6;
            }
            ++n5;
        }
        ++this.tallied;
    }

    public int[] getHistogram() {
        if (this.tallied == this.computed.length) {
            return this.bins;
        }
        CachableRed cachableRed = (CachableRed)this.getSources().elementAt(0);
        int n = cachableRed.getMinTileY();
        int n2 = cachableRed.getNumXTiles();
        int n3 = cachableRed.getMinTileX();
        int n4 = 0;
        while (n4 < cachableRed.getNumYTiles()) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n5 + n3 + n4 * n2;
                if (!this.computed[n6]) {
                    Raster raster = cachableRed.getTile(n5 + n3, n4 + n);
                    this.tallyTile(raster);
                    this.computed[n6] = true;
                }
                ++n5;
            }
            ++n4;
        }
        return this.bins;
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    public Raster getTile(int n, int n2) {
        int n3 = n2 - this.getMinTileY();
        int n4 = n - this.getMinTileX();
        CachableRed cachableRed = (CachableRed)this.getSources().elementAt(0);
        Raster raster = cachableRed.getTile(n, n2);
        int n5 = n4 + n3 * this.getNumXTiles();
        if (this.computed[n5]) {
            return raster;
        }
        this.tallyTile(raster);
        this.computed[n5] = true;
        return raster;
    }
}

