<?php declare(strict_types=1); ?>
<?php /** @var \Vpn\Portal\Tpl $this */?>
<?php /** @var string $pageTitle */ ?>
<?php /** @var string $requestRoot */ ?>
<?php /** @var string $portalHost */ ?>
<!DOCTYPE html>

<html lang="<?=$this->uiLanguage(); ?>" dir="<?=$this->textDir(); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Let's Connect! - <?=$this->e($pageTitle); ?></title>
    <link href="<?=$this->getAssetUrl($requestRoot, 'css/screen.css'); ?>" media="screen" rel="stylesheet">
    <link href="<?=$this->getAssetUrl($requestRoot, 'css/LC/screen.css'); ?>" media="screen" rel="stylesheet">
    <!-- portalHost: <?=$this->e($portalHost); ?> -->
</head>
<body>
    <header class="page">
        <?=$this->insert('languageSwitcher'); ?>
        <?=$this->insert('logoutButton'); ?>
    </header>
    <nav>
<?php if (isset($activeItem)) : ?>
<?=$this->insert('menu', ['activeItem' => $activeItem]); ?>
<?php endif; ?>
    </nav>
    <header class="main">
        <h1><?=$this->e($pageTitle); ?></h1>
    </header>
    <main>
<?=$this->section('content'); ?>
    </main>
    <footer>
<?php if ($this->exists('customFooter')) : ?>
    <?=$this->insert('customFooter'); ?>
<?php endif; ?>
        <p>
            Powered by <a target="_blank" href="https://www.letsconnect-vpn.org/">Let's Connect!</a>
        </p>
    </footer>
</body>
</html>
