/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk.impl.http;

import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.brk.ExtensionBreak;

public class ProxyListenerBreak
implements ProxyListener {
    public static final int PROXY_LISTENER_ORDER = 4999;
    private Model model = null;
    private ExtensionBreak extension = null;

    public ProxyListenerBreak(Model model, ExtensionBreak extension) {
        this.model = model;
        this.extension = extension;
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 4999;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage msg) {
        Session session;
        if (this.isSkipImage(msg.getRequestHeader())) {
            return true;
        }
        if (this.extension.isInScopeOnly() && !(session = Model.getSingleton().getSession()).isInScope(msg.getRequestHeader().getURI().toString())) {
            return true;
        }
        return this.extension.messageReceivedFromClient(msg);
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage msg) {
        Session session;
        if (this.isSkipImage(msg.getRequestHeader()) || this.isSkipImage(msg.getResponseHeader())) {
            return true;
        }
        if (this.extension.isInScopeOnly() && !(session = Model.getSingleton().getSession()).isInScope(msg.getRequestHeader().getURI().toString())) {
            return true;
        }
        return this.extension.messageReceivedFromServer(msg);
    }

    private boolean isSkipImage(HttpHeader header) {
        return header.isImage() && !this.model.getOptionsParam().getViewParam().isProcessImages();
    }
}

