/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.SrpServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.SRPServerComputations;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SrpServerKeyExchangeMessage
extends ServerKeyExchangeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.PUBLIC_KEY)
    private ModifiableByteArray modulus;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger modulusLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.PUBLIC_KEY)
    private ModifiableByteArray generator;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger generatorLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.PUBLIC_KEY)
    private ModifiableByteArray salt;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger saltLength;
    @HoldsModifiableVariable
    protected SRPServerComputations computations;

    public SrpServerKeyExchangeMessage() {
    }

    public SrpServerKeyExchangeMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.SERVER_KEY_EXCHANGE);
    }

    public ModifiableByteArray getModulus() {
        return this.modulus;
    }

    public void setModulus(ModifiableByteArray modulus) {
        this.modulus = modulus;
    }

    public void setModulus(byte[] modulus) {
        this.modulus = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.modulus, (byte[])modulus);
    }

    public ModifiableByteArray getSalt() {
        return this.salt;
    }

    public void setSalt(ModifiableByteArray salt) {
        this.salt = salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.salt, (byte[])salt);
    }

    public ModifiableInteger getSaltLength() {
        return this.saltLength;
    }

    public void setSaltLength(ModifiableInteger saltLength) {
        this.saltLength = saltLength;
    }

    public void setSaltLength(int saltLength) {
        this.saltLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.saltLength, (Integer)saltLength);
    }

    public ModifiableByteArray getGenerator() {
        return this.generator;
    }

    public void setGenerator(ModifiableByteArray generator) {
        this.generator = generator;
    }

    public void setGenerator(byte[] generator) {
        this.generator = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.generator, (byte[])generator);
    }

    public ModifiableInteger getModulusLength() {
        return this.modulusLength;
    }

    public void setModulusLength(ModifiableInteger modulusLength) {
        this.modulusLength = modulusLength;
    }

    public void setModulusLength(int modulusLength) {
        this.modulusLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.modulusLength, (Integer)modulusLength);
    }

    public ModifiableInteger getGeneratorLength() {
        return this.generatorLength;
    }

    public void setGeneratorLength(ModifiableInteger generatorLength) {
        this.generatorLength = generatorLength;
    }

    public void setGeneratorLength(int generatorLength) {
        this.generatorLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.generatorLength, (Integer)generatorLength);
    }

    @Override
    public SRPServerComputations getComputations() {
        return this.computations;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SrpServerKeyExchangeMessage:");
        sb.append("\n  Modulus p: ");
        if (this.modulus != null && this.modulus.getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.modulus.getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Generator g: ");
        if (this.generator != null && this.generator.getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.generator.getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Public Key: ");
        if (this.getPublicKey() != null && this.getPublicKey().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getPublicKey().getValue()), (boolean)false));
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature and Hash Algorithm: ");
        if (this.getSignatureAndHashAlgorithm() != null && this.getSignatureAndHashAlgorithm().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getSignatureAndHashAlgorithm().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature: ");
        if (this.getSignature() != null && this.getSignature().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getSignature().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new SrpServerKeyExchangeHandler(context);
    }

    @Override
    public String toCompactString() {
        return "SRP_SERVER_KEY_EXCHANGE";
    }

    @Override
    public void prepareComputations() {
        if (this.getComputations() == null) {
            this.computations = new SRPServerComputations();
        }
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            holders.add(this.computations);
        }
        return holders;
    }
}

