/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.manualrequest.http.impl;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.apache.commons.httpclient.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.manualrequest.MessageSender;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.network.HttpRedirectionValidator;
import org.zaproxy.zap.network.HttpRequestConfig;

public class HttpPanelSender
implements MessageSender {
    private static final Logger logger = LogManager.getLogger(HttpPanelSender.class);
    private final HttpPanelResponse responsePanel;
    private ExtensionHistory extension;
    private ExtensionAntiCSRF extAntiCSRF;
    private HttpSender delegate;
    private JToggleButton fixContentLength = null;
    private JToggleButton followRedirect = null;
    private JToggleButton useTrackingSessionState = null;
    private JToggleButton useCookies = null;
    private JToggleButton useCsrf = null;
    private List<PersistentConnectionListener> persistentConnectionListener = new ArrayList<PersistentConnectionListener>();

    public HttpPanelSender(HttpPanelRequest requestPanel, HttpPanelResponse responsePanel) {
        this.responsePanel = responsePanel;
        this.extAntiCSRF = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAntiCSRF.class);
        requestPanel.addOptions(this.getButtonUseTrackingSessionState(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        requestPanel.addOptions(this.getButtonUseCookies(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        requestPanel.addOptions(this.getButtonFollowRedirects(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        requestPanel.addOptions(this.getButtonFixContentLength(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        if (this.extAntiCSRF != null) {
            requestPanel.addOptions(this.getButtonUseCsrf(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        }
        boolean isSessionTrackingEnabled = Model.getSingleton().getOptionsParam().getConnectionParam().isHttpStateEnabled();
        this.getButtonUseTrackingSessionState().setEnabled(isSessionTrackingEnabled);
    }

    @Override
    public void handleSendMessage(Message aMessage) throws IllegalArgumentException, IOException {
        final HttpMessage httpMessage = (HttpMessage)aMessage;
        httpMessage.setRequestingUser(null);
        if (this.getButtonFixContentLength().isSelected()) {
            HttpPanelViewModelUtils.updateRequestContentLength(httpMessage);
        }
        try {
            final ModeRedirectionValidator redirectionValidator = new ModeRedirectionValidator();
            final boolean followRedirects = this.getButtonFollowRedirects().isSelected();
            if (this.extAntiCSRF != null && this.getButtonUseCsrf().isSelected()) {
                this.extAntiCSRF.regenerateAntiCsrfToken(httpMessage, this.getDelegate()::sendAndReceive);
            }
            if (followRedirects) {
                this.getDelegate().sendAndReceive(httpMessage, HttpRequestConfig.builder().setRedirectionValidator(redirectionValidator).build());
            } else {
                this.getDelegate().sendAndReceive(httpMessage, false);
            }
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!httpMessage.getResponseHeader().isEmpty()) {
                        HttpPanelSender.this.responsePanel.updateContent();
                        if (!followRedirects) {
                            HttpPanelSender.this.persistAndShowMessage(httpMessage);
                        } else if (!redirectionValidator.isRequestValid()) {
                            View.getSingleton().showWarningDialog(HttpPanelSender.this.responsePanel, Constant.messages.getString("manReq.outofscope.redirection.warning", redirectionValidator.getInvalidRedirection()));
                        }
                    }
                }
            });
            ZapGetMethod method = (ZapGetMethod)httpMessage.getUserObject();
            this.notifyPersistentConnectionListener(httpMessage, null, method);
        }
        catch (HttpMalformedHeaderException mhe) {
            throw new IllegalArgumentException("Malformed header error.", mhe);
        }
        catch (UnknownHostException uhe) {
            throw new IOException("Error forwarding to an Unknown host: " + uhe.getMessage(), uhe);
        }
        catch (SSLException sslEx) {
            throw sslEx;
        }
        catch (IOException ioe) {
            throw new IOException("IO error in sending request: " + ioe.getClass() + ": " + ioe.getMessage(), ioe);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void persistAndShowMessage(HttpMessage httpMessage) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(() -> this.persistAndShowMessage(httpMessage));
            return;
        }
        try {
            Session session = Model.getSingleton().getSession();
            HistoryReference ref = new HistoryReference(session, 15, httpMessage);
            ExtensionHistory extHistory = this.getHistoryExtension();
            if (extHistory != null) {
                extHistory.addHistory(ref);
            }
            SessionStructure.addPath(Model.getSingleton(), ref, httpMessage);
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            logger.warn("Failed to persist message sent:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyPersistentConnectionListener(HttpMessage httpMessage, Socket inSocket, ZapGetMethod method) {
        boolean keepSocketOpen = false;
        PersistentConnectionListener listener = null;
        List<PersistentConnectionListener> list = this.persistentConnectionListener;
        synchronized (list) {
            for (int i = 0; i < this.persistentConnectionListener.size(); ++i) {
                listener = this.persistentConnectionListener.get(i);
                try {
                    if (!listener.onHandshakeResponse(httpMessage, inSocket, method)) continue;
                    keepSocketOpen = true;
                    break;
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        return keepSocketOpen;
    }

    protected ExtensionHistory getHistoryExtension() {
        if (this.extension == null) {
            this.extension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        }
        return this.extension;
    }

    @Override
    public void cleanup() {
        if (this.delegate != null) {
            this.delegate.shutdown();
            this.delegate = null;
        }
    }

    private HttpSender getDelegate() {
        if (this.delegate == null) {
            this.delegate = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), this.getButtonUseTrackingSessionState().isSelected(), 6);
            this.delegate.setUseCookies(this.getButtonUseCookies().isSelected());
        }
        return this.delegate;
    }

    private JToggleButton getButtonFollowRedirects() {
        if (this.followRedirect == null) {
            this.followRedirect = new JToggleButton(new ImageIcon(HttpPanelSender.class.getResource("/resource/icon/16/118.png")));
            this.followRedirect.setToolTipText(Constant.messages.getString("manReq.checkBox.followRedirect"));
            this.followRedirect.setSelected(true);
        }
        return this.followRedirect;
    }

    private JToggleButton getButtonUseTrackingSessionState() {
        if (this.useTrackingSessionState == null) {
            this.useTrackingSessionState = new JToggleButton(new ImageIcon(HttpPanelSender.class.getResource("/resource/icon/fugue/globe-green.png")));
            this.useTrackingSessionState.setToolTipText(Constant.messages.getString("manReq.checkBox.useSession"));
            this.useTrackingSessionState.addItemListener(e -> this.setUseTrackingSessionState(e.getStateChange() == 1));
        }
        return this.useTrackingSessionState;
    }

    private JToggleButton getButtonUseCookies() {
        if (this.useCookies == null) {
            this.useCookies = new JToggleButton(new ImageIcon(HttpPanelSender.class.getResource("/resource/icon/fugue/cookie.png")), true);
            this.useCookies.setToolTipText(Constant.messages.getString("manReq.checkBox.useCookies"));
            this.useCookies.addItemListener(e -> this.setUseCookies(e.getStateChange() == 1));
        }
        return this.useCookies;
    }

    private JToggleButton getButtonUseCsrf() {
        if (this.useCsrf == null) {
            this.useCsrf = new JToggleButton(new ImageIcon(HttpPanelSender.class.getResource("/resource/icon/csrf-button.png")));
            this.useCsrf.setToolTipText(Constant.messages.getString("manReq.checkBox.useCSRF"));
        }
        return this.useCsrf;
    }

    private JToggleButton getButtonFixContentLength() {
        if (this.fixContentLength == null) {
            this.fixContentLength = new JToggleButton(new ImageIcon(HttpPanelSender.class.getResource("/resource/icon/fugue/application-resize.png")), true);
            this.fixContentLength.setToolTipText(Constant.messages.getString("manReq.checkBox.fixLength"));
        }
        return this.fixContentLength;
    }

    public void addPersistentConnectionListener(PersistentConnectionListener listener) {
        this.persistentConnectionListener.add(listener);
    }

    public void removePersistentConnectionListener(PersistentConnectionListener listener) {
        this.persistentConnectionListener.remove(listener);
    }

    private void setUseTrackingSessionState(boolean shouldUseTrackingSessionState) {
        if (this.delegate != null) {
            this.delegate.setUseGlobalState(shouldUseTrackingSessionState);
        }
    }

    private void setUseCookies(boolean shouldUseCookies) {
        if (this.delegate != null) {
            this.delegate.setUseCookies(shouldUseCookies);
        }
    }

    public void setButtonTrackingSessionStateEnabled(boolean enabled) {
        this.getButtonUseTrackingSessionState().setEnabled(enabled);
        this.getButtonUseTrackingSessionState().setSelected(enabled);
    }

    private class ModeRedirectionValidator
    implements HttpRedirectionValidator {
        private boolean isRequestValid = true;
        private URI invalidRedirection;

        @Override
        public void notifyMessageReceived(HttpMessage message) {
            HttpPanelSender.this.persistAndShowMessage(message);
        }

        @Override
        public boolean isValid(URI redirection) {
            if (!this.isValidForCurrentMode(redirection)) {
                this.isRequestValid = false;
                this.invalidRedirection = redirection;
                return false;
            }
            return true;
        }

        private boolean isValidForCurrentMode(URI uri) {
            switch (Control.getSingleton().getMode()) {
                case safe: {
                    return false;
                }
                case protect: {
                    return Model.getSingleton().getSession().isInScope(uri.toString());
                }
            }
            return true;
        }

        public boolean isRequestValid() {
            return this.isRequestValid;
        }

        public URI getInvalidRedirection() {
            return this.invalidRedirection;
        }
    }
}

